"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2InstanceRunningScheduler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const scheduler = require("aws-cdk-lib/aws-scheduler");
const constructs_1 = require("constructs");
class Ec2InstanceRunningScheduler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const account = cdk.Stack.of(this).account;
        //const stackName: string = cdk.Stack.of(this).stackName;
        //const region = cdk.Stack.of(this).region;
        const randomNameKey = crypto.createHash('shake256', { outputLength: 4 })
            .update(`${cdk.Names.uniqueId(scope)}-${cdk.Names.uniqueId(this)}`)
            .digest('hex');
        // 👇EventBridge Scheduler IAM Role
        const schedulerExecutionRole = new iam.Role(this, 'SchedulerExecutionRole', {
            roleName: `stop-ec2-instance-schedule-${randomNameKey}-exec-role`,
            assumedBy: new iam.ServicePrincipal('scheduler.amazonaws.com'),
            inlinePolicies: {
                ['ec2-instance-stop-policy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'ec2:StartInstances',
                                'ec2:StopInstances',
                            ],
                            resources: [
                                `arn:aws:ec2:*:${account}:instance/*`,
                            ],
                        }),
                    ],
                }),
            },
        });
        // Object.entries(props.targets)
        for (const target of props.targets) {
            // 👇Create random string
            const scheduleNameKey = crypto.createHash('shake256', { outputLength: 4 })
                .update(target.instances.toString())
                .digest('hex');
            // 👇EventBridge Scheduler for DB Instance Stop
            new scheduler.CfnSchedule(this, `StopSchedule${scheduleNameKey.toUpperCase()}`, {
                name: `auto-stop-ec2-instance-${scheduleNameKey}-schedule`,
                description: `auto stop ec2 instance (${target.instances.join(',')}) schedule.`,
                state: 'ENABLED',
                //groupName: scheduleGroup.name, // default
                flexibleTimeWindow: {
                    mode: 'OFF',
                },
                scheduleExpressionTimezone: target.stopSchedule.timezone,
                scheduleExpression: (() => {
                    // default: weekday 21:10
                    const minute = target.stopSchedule.minute ?? '10';
                    const hour = target.stopSchedule.hour ?? '21';
                    const week = target.stopSchedule.week ?? 'MON-FRI';
                    return `cron(${minute} ${hour} ? * ${week} *)`;
                })(),
                target: {
                    arn: 'arn:aws:scheduler:::aws-sdk:ec2:stopInstances',
                    roleArn: schedulerExecutionRole.roleArn,
                    input: JSON.stringify({ InstanceIds: target.instances }),
                    retryPolicy: {
                        maximumEventAgeInSeconds: 60,
                        maximumRetryAttempts: 0,
                    },
                },
            });
            // 👇EventBridge Scheduler for DB Instance Start
            new scheduler.CfnSchedule(this, `StartSchedule${scheduleNameKey.toUpperCase()}`, {
                name: `auto-start-ec2-instance-${scheduleNameKey}-schedule`,
                description: `auto start ec2 instance(${target.instances.join(',')}) schedule.`,
                state: 'ENABLED',
                //groupName: scheduleGroup.name, // default
                flexibleTimeWindow: {
                    mode: 'OFF',
                },
                scheduleExpressionTimezone: target.startSchedule.timezone,
                scheduleExpression: (() => {
                    // default: weekday 07:50
                    const minute = target.startSchedule.minute ?? '50';
                    const hour = target.startSchedule.hour ?? '7';
                    const week = target.startSchedule.week ?? 'MON-FRI';
                    return `cron(${minute} ${hour} ? * ${week} *)`;
                })(),
                target: {
                    arn: 'arn:aws:scheduler:::aws-sdk:ec2:startInstances',
                    roleArn: schedulerExecutionRole.roleArn,
                    input: JSON.stringify({ InstanceIds: target.instances }),
                    retryPolicy: {
                        maximumEventAgeInSeconds: 60,
                        maximumRetryAttempts: 0,
                    },
                },
            });
        }
    }
}
_a = JSII_RTTI_SYMBOL_1;
Ec2InstanceRunningScheduler[_a] = { fqn: "@gammarer/aws-ec2-instance-running-scheduler.Ec2InstanceRunningScheduler", version: "0.7.15" };
exports.Ec2InstanceRunningScheduler = Ec2InstanceRunningScheduler;
//# sourceMappingURL=data:application/json;base64,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