# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallSettingsArgs', 'FirewallSettings']

@pulumi.input_type
class FirewallSettingsArgs:
    def __init__(__self__, *,
                 default_firewall_ids: Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']] = None):
        """
        The set of arguments for constructing a FirewallSettings resource.
        :param pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs'] default_firewall_ids: A map of default firewall IDs for various interfaces.
        """
        if default_firewall_ids is not None:
            pulumi.set(__self__, "default_firewall_ids", default_firewall_ids)

    @_builtins.property
    @pulumi.getter(name="defaultFirewallIds")
    def default_firewall_ids(self) -> Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']]:
        """
        A map of default firewall IDs for various interfaces.
        """
        return pulumi.get(self, "default_firewall_ids")

    @default_firewall_ids.setter
    def default_firewall_ids(self, value: Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']]):
        pulumi.set(self, "default_firewall_ids", value)


@pulumi.input_type
class _FirewallSettingsState:
    def __init__(__self__, *,
                 default_firewall_ids: Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']] = None):
        """
        Input properties used for looking up and filtering FirewallSettings resources.
        :param pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs'] default_firewall_ids: A map of default firewall IDs for various interfaces.
        """
        if default_firewall_ids is not None:
            pulumi.set(__self__, "default_firewall_ids", default_firewall_ids)

    @_builtins.property
    @pulumi.getter(name="defaultFirewallIds")
    def default_firewall_ids(self) -> Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']]:
        """
        A map of default firewall IDs for various interfaces.
        """
        return pulumi.get(self, "default_firewall_ids")

    @default_firewall_ids.setter
    def default_firewall_ids(self, value: Optional[pulumi.Input['FirewallSettingsDefaultFirewallIdsArgs']]):
        pulumi.set(self, "default_firewall_ids", value)


@pulumi.type_token("linode:index/firewallSettings:FirewallSettings")
class FirewallSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_firewall_ids: Optional[pulumi.Input[Union['FirewallSettingsDefaultFirewallIdsArgs', 'FirewallSettingsDefaultFirewallIdsArgsDict']]] = None,
                 __props__=None):
        """
        Manages Linode account-level firewall settings. Resetting default firewall IDs
        to null is not available to all customers and unsupported in this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        example = linode.FirewallSettings("example", default_firewall_ids={
            "linode": 12345,
            "nodebalancer": 12345,
            "public_interface": 12345,
            "vpc_interface": 12345,
        })
        ```

        ## API Reference

        See the [Linode API documentation](https://techdocs.akamai.com/linode-api/reference/put-firewall-settings) for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirewallSettingsDefaultFirewallIdsArgs', 'FirewallSettingsDefaultFirewallIdsArgsDict']] default_firewall_ids: A map of default firewall IDs for various interfaces.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FirewallSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Linode account-level firewall settings. Resetting default firewall IDs
        to null is not available to all customers and unsupported in this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        example = linode.FirewallSettings("example", default_firewall_ids={
            "linode": 12345,
            "nodebalancer": 12345,
            "public_interface": 12345,
            "vpc_interface": 12345,
        })
        ```

        ## API Reference

        See the [Linode API documentation](https://techdocs.akamai.com/linode-api/reference/put-firewall-settings) for more details.

        :param str resource_name: The name of the resource.
        :param FirewallSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_firewall_ids: Optional[pulumi.Input[Union['FirewallSettingsDefaultFirewallIdsArgs', 'FirewallSettingsDefaultFirewallIdsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallSettingsArgs.__new__(FirewallSettingsArgs)

            __props__.__dict__["default_firewall_ids"] = default_firewall_ids
        super(FirewallSettings, __self__).__init__(
            'linode:index/firewallSettings:FirewallSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_firewall_ids: Optional[pulumi.Input[Union['FirewallSettingsDefaultFirewallIdsArgs', 'FirewallSettingsDefaultFirewallIdsArgsDict']]] = None) -> 'FirewallSettings':
        """
        Get an existing FirewallSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirewallSettingsDefaultFirewallIdsArgs', 'FirewallSettingsDefaultFirewallIdsArgsDict']] default_firewall_ids: A map of default firewall IDs for various interfaces.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallSettingsState.__new__(_FirewallSettingsState)

        __props__.__dict__["default_firewall_ids"] = default_firewall_ids
        return FirewallSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultFirewallIds")
    def default_firewall_ids(self) -> pulumi.Output[Optional['outputs.FirewallSettingsDefaultFirewallIds']]:
        """
        A map of default firewall IDs for various interfaces.
        """
        return pulumi.get(self, "default_firewall_ids")

