# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDatabaseMysqlV2Result',
    'AwaitableGetDatabaseMysqlV2Result',
    'get_database_mysql_v2',
    'get_database_mysql_v2_output',
]

@pulumi.output_type
class GetDatabaseMysqlV2Result:
    """
    A collection of values returned by getDatabaseMysqlV2.
    """
    def __init__(__self__, allow_lists=None, ca_cert=None, cluster_size=None, created=None, encrypted=None, engine=None, engine_config_binlog_retention_period=None, engine_config_mysql_connect_timeout=None, engine_config_mysql_default_time_zone=None, engine_config_mysql_group_concat_max_len=None, engine_config_mysql_information_schema_stats_expiry=None, engine_config_mysql_innodb_change_buffer_max_size=None, engine_config_mysql_innodb_flush_neighbors=None, engine_config_mysql_innodb_ft_min_token_size=None, engine_config_mysql_innodb_ft_server_stopword_table=None, engine_config_mysql_innodb_lock_wait_timeout=None, engine_config_mysql_innodb_log_buffer_size=None, engine_config_mysql_innodb_online_alter_log_max_size=None, engine_config_mysql_innodb_read_io_threads=None, engine_config_mysql_innodb_rollback_on_timeout=None, engine_config_mysql_innodb_thread_concurrency=None, engine_config_mysql_innodb_write_io_threads=None, engine_config_mysql_interactive_timeout=None, engine_config_mysql_internal_tmp_mem_storage_engine=None, engine_config_mysql_max_allowed_packet=None, engine_config_mysql_max_heap_table_size=None, engine_config_mysql_net_buffer_length=None, engine_config_mysql_net_read_timeout=None, engine_config_mysql_net_write_timeout=None, engine_config_mysql_sort_buffer_size=None, engine_config_mysql_sql_mode=None, engine_config_mysql_sql_require_primary_key=None, engine_config_mysql_tmp_table_size=None, engine_config_mysql_wait_timeout=None, engine_id=None, fork_restore_time=None, fork_source=None, host_primary=None, host_secondary=None, id=None, label=None, members=None, oldest_restore_time=None, pending_updates=None, platform=None, port=None, private_network=None, region=None, root_password=None, root_username=None, ssl_connection=None, status=None, suspended=None, type=None, updated=None, updates=None, version=None):
        if allow_lists and not isinstance(allow_lists, list):
            raise TypeError("Expected argument 'allow_lists' to be a list")
        pulumi.set(__self__, "allow_lists", allow_lists)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if cluster_size and not isinstance(cluster_size, int):
            raise TypeError("Expected argument 'cluster_size' to be a int")
        pulumi.set(__self__, "cluster_size", cluster_size)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if encrypted and not isinstance(encrypted, bool):
            raise TypeError("Expected argument 'encrypted' to be a bool")
        pulumi.set(__self__, "encrypted", encrypted)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_config_binlog_retention_period and not isinstance(engine_config_binlog_retention_period, int):
            raise TypeError("Expected argument 'engine_config_binlog_retention_period' to be a int")
        pulumi.set(__self__, "engine_config_binlog_retention_period", engine_config_binlog_retention_period)
        if engine_config_mysql_connect_timeout and not isinstance(engine_config_mysql_connect_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_connect_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_connect_timeout", engine_config_mysql_connect_timeout)
        if engine_config_mysql_default_time_zone and not isinstance(engine_config_mysql_default_time_zone, str):
            raise TypeError("Expected argument 'engine_config_mysql_default_time_zone' to be a str")
        pulumi.set(__self__, "engine_config_mysql_default_time_zone", engine_config_mysql_default_time_zone)
        if engine_config_mysql_group_concat_max_len and not isinstance(engine_config_mysql_group_concat_max_len, float):
            raise TypeError("Expected argument 'engine_config_mysql_group_concat_max_len' to be a float")
        pulumi.set(__self__, "engine_config_mysql_group_concat_max_len", engine_config_mysql_group_concat_max_len)
        if engine_config_mysql_information_schema_stats_expiry and not isinstance(engine_config_mysql_information_schema_stats_expiry, int):
            raise TypeError("Expected argument 'engine_config_mysql_information_schema_stats_expiry' to be a int")
        pulumi.set(__self__, "engine_config_mysql_information_schema_stats_expiry", engine_config_mysql_information_schema_stats_expiry)
        if engine_config_mysql_innodb_change_buffer_max_size and not isinstance(engine_config_mysql_innodb_change_buffer_max_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_change_buffer_max_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_change_buffer_max_size", engine_config_mysql_innodb_change_buffer_max_size)
        if engine_config_mysql_innodb_flush_neighbors and not isinstance(engine_config_mysql_innodb_flush_neighbors, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_flush_neighbors' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_flush_neighbors", engine_config_mysql_innodb_flush_neighbors)
        if engine_config_mysql_innodb_ft_min_token_size and not isinstance(engine_config_mysql_innodb_ft_min_token_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_ft_min_token_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_ft_min_token_size", engine_config_mysql_innodb_ft_min_token_size)
        if engine_config_mysql_innodb_ft_server_stopword_table and not isinstance(engine_config_mysql_innodb_ft_server_stopword_table, str):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_ft_server_stopword_table' to be a str")
        pulumi.set(__self__, "engine_config_mysql_innodb_ft_server_stopword_table", engine_config_mysql_innodb_ft_server_stopword_table)
        if engine_config_mysql_innodb_lock_wait_timeout and not isinstance(engine_config_mysql_innodb_lock_wait_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_lock_wait_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_lock_wait_timeout", engine_config_mysql_innodb_lock_wait_timeout)
        if engine_config_mysql_innodb_log_buffer_size and not isinstance(engine_config_mysql_innodb_log_buffer_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_log_buffer_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_log_buffer_size", engine_config_mysql_innodb_log_buffer_size)
        if engine_config_mysql_innodb_online_alter_log_max_size and not isinstance(engine_config_mysql_innodb_online_alter_log_max_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_online_alter_log_max_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_online_alter_log_max_size", engine_config_mysql_innodb_online_alter_log_max_size)
        if engine_config_mysql_innodb_read_io_threads and not isinstance(engine_config_mysql_innodb_read_io_threads, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_read_io_threads' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_read_io_threads", engine_config_mysql_innodb_read_io_threads)
        if engine_config_mysql_innodb_rollback_on_timeout and not isinstance(engine_config_mysql_innodb_rollback_on_timeout, bool):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_rollback_on_timeout' to be a bool")
        pulumi.set(__self__, "engine_config_mysql_innodb_rollback_on_timeout", engine_config_mysql_innodb_rollback_on_timeout)
        if engine_config_mysql_innodb_thread_concurrency and not isinstance(engine_config_mysql_innodb_thread_concurrency, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_thread_concurrency' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_thread_concurrency", engine_config_mysql_innodb_thread_concurrency)
        if engine_config_mysql_innodb_write_io_threads and not isinstance(engine_config_mysql_innodb_write_io_threads, int):
            raise TypeError("Expected argument 'engine_config_mysql_innodb_write_io_threads' to be a int")
        pulumi.set(__self__, "engine_config_mysql_innodb_write_io_threads", engine_config_mysql_innodb_write_io_threads)
        if engine_config_mysql_interactive_timeout and not isinstance(engine_config_mysql_interactive_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_interactive_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_interactive_timeout", engine_config_mysql_interactive_timeout)
        if engine_config_mysql_internal_tmp_mem_storage_engine and not isinstance(engine_config_mysql_internal_tmp_mem_storage_engine, str):
            raise TypeError("Expected argument 'engine_config_mysql_internal_tmp_mem_storage_engine' to be a str")
        pulumi.set(__self__, "engine_config_mysql_internal_tmp_mem_storage_engine", engine_config_mysql_internal_tmp_mem_storage_engine)
        if engine_config_mysql_max_allowed_packet and not isinstance(engine_config_mysql_max_allowed_packet, int):
            raise TypeError("Expected argument 'engine_config_mysql_max_allowed_packet' to be a int")
        pulumi.set(__self__, "engine_config_mysql_max_allowed_packet", engine_config_mysql_max_allowed_packet)
        if engine_config_mysql_max_heap_table_size and not isinstance(engine_config_mysql_max_heap_table_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_max_heap_table_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_max_heap_table_size", engine_config_mysql_max_heap_table_size)
        if engine_config_mysql_net_buffer_length and not isinstance(engine_config_mysql_net_buffer_length, int):
            raise TypeError("Expected argument 'engine_config_mysql_net_buffer_length' to be a int")
        pulumi.set(__self__, "engine_config_mysql_net_buffer_length", engine_config_mysql_net_buffer_length)
        if engine_config_mysql_net_read_timeout and not isinstance(engine_config_mysql_net_read_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_net_read_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_net_read_timeout", engine_config_mysql_net_read_timeout)
        if engine_config_mysql_net_write_timeout and not isinstance(engine_config_mysql_net_write_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_net_write_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_net_write_timeout", engine_config_mysql_net_write_timeout)
        if engine_config_mysql_sort_buffer_size and not isinstance(engine_config_mysql_sort_buffer_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_sort_buffer_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_sort_buffer_size", engine_config_mysql_sort_buffer_size)
        if engine_config_mysql_sql_mode and not isinstance(engine_config_mysql_sql_mode, str):
            raise TypeError("Expected argument 'engine_config_mysql_sql_mode' to be a str")
        pulumi.set(__self__, "engine_config_mysql_sql_mode", engine_config_mysql_sql_mode)
        if engine_config_mysql_sql_require_primary_key and not isinstance(engine_config_mysql_sql_require_primary_key, bool):
            raise TypeError("Expected argument 'engine_config_mysql_sql_require_primary_key' to be a bool")
        pulumi.set(__self__, "engine_config_mysql_sql_require_primary_key", engine_config_mysql_sql_require_primary_key)
        if engine_config_mysql_tmp_table_size and not isinstance(engine_config_mysql_tmp_table_size, int):
            raise TypeError("Expected argument 'engine_config_mysql_tmp_table_size' to be a int")
        pulumi.set(__self__, "engine_config_mysql_tmp_table_size", engine_config_mysql_tmp_table_size)
        if engine_config_mysql_wait_timeout and not isinstance(engine_config_mysql_wait_timeout, int):
            raise TypeError("Expected argument 'engine_config_mysql_wait_timeout' to be a int")
        pulumi.set(__self__, "engine_config_mysql_wait_timeout", engine_config_mysql_wait_timeout)
        if engine_id and not isinstance(engine_id, str):
            raise TypeError("Expected argument 'engine_id' to be a str")
        pulumi.set(__self__, "engine_id", engine_id)
        if fork_restore_time and not isinstance(fork_restore_time, str):
            raise TypeError("Expected argument 'fork_restore_time' to be a str")
        pulumi.set(__self__, "fork_restore_time", fork_restore_time)
        if fork_source and not isinstance(fork_source, int):
            raise TypeError("Expected argument 'fork_source' to be a int")
        pulumi.set(__self__, "fork_source", fork_source)
        if host_primary and not isinstance(host_primary, str):
            raise TypeError("Expected argument 'host_primary' to be a str")
        pulumi.set(__self__, "host_primary", host_primary)
        if host_secondary and not isinstance(host_secondary, str):
            raise TypeError("Expected argument 'host_secondary' to be a str")
        pulumi.set(__self__, "host_secondary", host_secondary)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if members and not isinstance(members, dict):
            raise TypeError("Expected argument 'members' to be a dict")
        pulumi.set(__self__, "members", members)
        if oldest_restore_time and not isinstance(oldest_restore_time, str):
            raise TypeError("Expected argument 'oldest_restore_time' to be a str")
        pulumi.set(__self__, "oldest_restore_time", oldest_restore_time)
        if pending_updates and not isinstance(pending_updates, list):
            raise TypeError("Expected argument 'pending_updates' to be a list")
        pulumi.set(__self__, "pending_updates", pending_updates)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_network and not isinstance(private_network, dict):
            raise TypeError("Expected argument 'private_network' to be a dict")
        pulumi.set(__self__, "private_network", private_network)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_password and not isinstance(root_password, str):
            raise TypeError("Expected argument 'root_password' to be a str")
        pulumi.set(__self__, "root_password", root_password)
        if root_username and not isinstance(root_username, str):
            raise TypeError("Expected argument 'root_username' to be a str")
        pulumi.set(__self__, "root_username", root_username)
        if ssl_connection and not isinstance(ssl_connection, bool):
            raise TypeError("Expected argument 'ssl_connection' to be a bool")
        pulumi.set(__self__, "ssl_connection", ssl_connection)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)
        if updates and not isinstance(updates, dict):
            raise TypeError("Expected argument 'updates' to be a dict")
        pulumi.set(__self__, "updates", updates)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Sequence[_builtins.str]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> _builtins.str:
        """
        The base64-encoded SSL CA certificate for the Managed Database.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> _builtins.int:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Whether the Managed Databases is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The Managed Database engine. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineConfigBinlogRetentionPeriod")
    def engine_config_binlog_retention_period(self) -> _builtins.int:
        """
        The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default, for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "engine_config_binlog_retention_period")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlConnectTimeout")
    def engine_config_mysql_connect_timeout(self) -> _builtins.int:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with "Bad handshake".
        """
        return pulumi.get(self, "engine_config_mysql_connect_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlDefaultTimeZone")
    def engine_config_mysql_default_time_zone(self) -> _builtins.str:
        """
        Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or `SYSTEM` to use the MySQL server default.
        """
        return pulumi.get(self, "engine_config_mysql_default_time_zone")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlGroupConcatMaxLen")
    def engine_config_mysql_group_concat_max_len(self) -> _builtins.float:
        """
        The maximum permitted result length in bytes for the `GROUP_CONCAT()` function.
        """
        return pulumi.get(self, "engine_config_mysql_group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInformationSchemaStatsExpiry")
    def engine_config_mysql_information_schema_stats_expiry(self) -> _builtins.int:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "engine_config_mysql_information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbChangeBufferMaxSize")
    def engine_config_mysql_innodb_change_buffer_max_size(self) -> _builtins.int:
        """
        Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_change_buffer_max_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFlushNeighbors")
    def engine_config_mysql_innodb_flush_neighbors(self) -> _builtins.int:
        """
        Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_flush_neighbors")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtMinTokenSize")
    def engine_config_mysql_innodb_ft_min_token_size(self) -> _builtins.int:
        """
        Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbFtServerStopwordTable")
    def engine_config_mysql_innodb_ft_server_stopword_table(self) -> _builtins.str:
        """
        This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLockWaitTimeout")
    def engine_config_mysql_innodb_lock_wait_timeout(self) -> _builtins.int:
        """
        The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbLogBufferSize")
    def engine_config_mysql_innodb_log_buffer_size(self) -> _builtins.int:
        """
        The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_log_buffer_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbOnlineAlterLogMaxSize")
    def engine_config_mysql_innodb_online_alter_log_max_size(self) -> _builtins.int:
        """
        The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbReadIoThreads")
    def engine_config_mysql_innodb_read_io_threads(self) -> _builtins.int:
        """
        The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_read_io_threads")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbRollbackOnTimeout")
    def engine_config_mysql_innodb_rollback_on_timeout(self) -> _builtins.bool:
        """
        When enabled, a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbThreadConcurrency")
    def engine_config_mysql_innodb_thread_concurrency(self) -> _builtins.int:
        """
        Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        """
        return pulumi.get(self, "engine_config_mysql_innodb_thread_concurrency")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInnodbWriteIoThreads")
    def engine_config_mysql_innodb_write_io_threads(self) -> _builtins.int:
        """
        The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_innodb_write_io_threads")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInteractiveTimeout")
    def engine_config_mysql_interactive_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlInternalTmpMemStorageEngine")
    def engine_config_mysql_internal_tmp_mem_storage_engine(self) -> _builtins.str:
        """
        The storage engine for in-memory internal temporary tables.
        """
        return pulumi.get(self, "engine_config_mysql_internal_tmp_mem_storage_engine")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxAllowedPacket")
    def engine_config_mysql_max_allowed_packet(self) -> _builtins.int:
        """
        Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        """
        return pulumi.get(self, "engine_config_mysql_max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlMaxHeapTableSize")
    def engine_config_mysql_max_heap_table_size(self) -> _builtins.int:
        """
        Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_max_heap_table_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetBufferLength")
    def engine_config_mysql_net_buffer_length(self) -> _builtins.int:
        """
        Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "engine_config_mysql_net_buffer_length")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetReadTimeout")
    def engine_config_mysql_net_read_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "engine_config_mysql_net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlNetWriteTimeout")
    def engine_config_mysql_net_write_timeout(self) -> _builtins.int:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "engine_config_mysql_net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSortBufferSize")
    def engine_config_mysql_sort_buffer_size(self) -> _builtins.int:
        """
        Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        """
        return pulumi.get(self, "engine_config_mysql_sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlMode")
    def engine_config_mysql_sql_mode(self) -> _builtins.str:
        """
        Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned.
        """
        return pulumi.get(self, "engine_config_mysql_sql_mode")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlSqlRequirePrimaryKey")
    def engine_config_mysql_sql_require_primary_key(self) -> _builtins.bool:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        """
        return pulumi.get(self, "engine_config_mysql_sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlTmpTableSize")
    def engine_config_mysql_tmp_table_size(self) -> _builtins.int:
        """
        Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "engine_config_mysql_tmp_table_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigMysqlWaitTimeout")
    def engine_config_mysql_wait_timeout(self) -> _builtins.int:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "engine_config_mysql_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> _builtins.str:
        """
        The Managed Database engine in engine/version format. (e.g. `mysql`)
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> _builtins.str:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> _builtins.int:
        """
        The ID of the database that was forked from.
        """
        return pulumi.get(self, "fork_source")

    @_builtins.property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> _builtins.str:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @_builtins.property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> _builtins.str:
        """
        The secondary/private host for the managed database.
        """
        return pulumi.get(self, "host_secondary")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="oldestRestoreTime")
    def oldest_restore_time(self) -> _builtins.str:
        return pulumi.get(self, "oldest_restore_time")

    @_builtins.property
    @pulumi.getter(name="pendingUpdates")
    def pending_updates(self) -> Sequence['outputs.GetDatabaseMysqlV2PendingUpdateResult']:
        return pulumi.get(self, "pending_updates")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        The back-end platform for relational databases used by the service.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The access port for this Managed Database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> 'outputs.GetDatabaseMysqlV2PrivateNetworkResult':
        return pulumi.get(self, "private_network")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> _builtins.str:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @_builtins.property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> _builtins.str:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @_builtins.property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> _builtins.bool:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> _builtins.bool:
        """
        Whether this Managed Database is suspended.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Linode Instance type used for the nodes of the Managed Database.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.str:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def updates(self) -> 'outputs.GetDatabaseMysqlV2UpdatesResult':
        return pulumi.get(self, "updates")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Managed Database engine version. (e.g. `13.2`)
        """
        return pulumi.get(self, "version")


class AwaitableGetDatabaseMysqlV2Result(GetDatabaseMysqlV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseMysqlV2Result(
            allow_lists=self.allow_lists,
            ca_cert=self.ca_cert,
            cluster_size=self.cluster_size,
            created=self.created,
            encrypted=self.encrypted,
            engine=self.engine,
            engine_config_binlog_retention_period=self.engine_config_binlog_retention_period,
            engine_config_mysql_connect_timeout=self.engine_config_mysql_connect_timeout,
            engine_config_mysql_default_time_zone=self.engine_config_mysql_default_time_zone,
            engine_config_mysql_group_concat_max_len=self.engine_config_mysql_group_concat_max_len,
            engine_config_mysql_information_schema_stats_expiry=self.engine_config_mysql_information_schema_stats_expiry,
            engine_config_mysql_innodb_change_buffer_max_size=self.engine_config_mysql_innodb_change_buffer_max_size,
            engine_config_mysql_innodb_flush_neighbors=self.engine_config_mysql_innodb_flush_neighbors,
            engine_config_mysql_innodb_ft_min_token_size=self.engine_config_mysql_innodb_ft_min_token_size,
            engine_config_mysql_innodb_ft_server_stopword_table=self.engine_config_mysql_innodb_ft_server_stopword_table,
            engine_config_mysql_innodb_lock_wait_timeout=self.engine_config_mysql_innodb_lock_wait_timeout,
            engine_config_mysql_innodb_log_buffer_size=self.engine_config_mysql_innodb_log_buffer_size,
            engine_config_mysql_innodb_online_alter_log_max_size=self.engine_config_mysql_innodb_online_alter_log_max_size,
            engine_config_mysql_innodb_read_io_threads=self.engine_config_mysql_innodb_read_io_threads,
            engine_config_mysql_innodb_rollback_on_timeout=self.engine_config_mysql_innodb_rollback_on_timeout,
            engine_config_mysql_innodb_thread_concurrency=self.engine_config_mysql_innodb_thread_concurrency,
            engine_config_mysql_innodb_write_io_threads=self.engine_config_mysql_innodb_write_io_threads,
            engine_config_mysql_interactive_timeout=self.engine_config_mysql_interactive_timeout,
            engine_config_mysql_internal_tmp_mem_storage_engine=self.engine_config_mysql_internal_tmp_mem_storage_engine,
            engine_config_mysql_max_allowed_packet=self.engine_config_mysql_max_allowed_packet,
            engine_config_mysql_max_heap_table_size=self.engine_config_mysql_max_heap_table_size,
            engine_config_mysql_net_buffer_length=self.engine_config_mysql_net_buffer_length,
            engine_config_mysql_net_read_timeout=self.engine_config_mysql_net_read_timeout,
            engine_config_mysql_net_write_timeout=self.engine_config_mysql_net_write_timeout,
            engine_config_mysql_sort_buffer_size=self.engine_config_mysql_sort_buffer_size,
            engine_config_mysql_sql_mode=self.engine_config_mysql_sql_mode,
            engine_config_mysql_sql_require_primary_key=self.engine_config_mysql_sql_require_primary_key,
            engine_config_mysql_tmp_table_size=self.engine_config_mysql_tmp_table_size,
            engine_config_mysql_wait_timeout=self.engine_config_mysql_wait_timeout,
            engine_id=self.engine_id,
            fork_restore_time=self.fork_restore_time,
            fork_source=self.fork_source,
            host_primary=self.host_primary,
            host_secondary=self.host_secondary,
            id=self.id,
            label=self.label,
            members=self.members,
            oldest_restore_time=self.oldest_restore_time,
            pending_updates=self.pending_updates,
            platform=self.platform,
            port=self.port,
            private_network=self.private_network,
            region=self.region,
            root_password=self.root_password,
            root_username=self.root_username,
            ssl_connection=self.ssl_connection,
            status=self.status,
            suspended=self.suspended,
            type=self.type,
            updated=self.updated,
            updates=self.updates,
            version=self.version)


def get_database_mysql_v2(id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseMysqlV2Result:
    """
    Provides information about a Linode MySQL Database.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-databases-mysql-instance).

    ## Example Usage

    Get information about a MySQL database:

    ```python
    import pulumi
    import pulumi_linode as linode

    my_db = linode.get_database_mysql_v2(id="12345")
    ```

    ## pending_updates

    The following arguments are exposed by each entry in the `pending_updates` attribute:

    * `deadline` - The time when a mandatory update needs to be applied.

    * `description` - A description of the update.

    * `planned_for` - The date and time a maintenance update will be applied.

    ## updates

    The following arguments are supported in the `updates` specification block:

    * `day_of_week` - The day to perform maintenance. (`monday`, `tuesday`, ...)

    * `duration` - The maximum maintenance window time in hours. (`1`..`3`)

    * `frequency` - The frequency at which maintenance occurs. (`weekly`)

    * `hour_of_day` - The hour to begin maintenance based in UTC time. (`0`..`23`)

    ## private_network

    The following arguments are exposed by the `private_network` attribute:

    * `vpc_id` - The ID of the virtual private cloud (VPC) to restrict access to this database using.

    * `subnet_id` - The ID of the VPC subnet to restrict access to this database using.

    * `public_access` - If true, clients outside the VPC can connect to the database using a public IP address.


    :param _builtins.str id: The ID of the MySQL database.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getDatabaseMysqlV2:getDatabaseMysqlV2', __args__, opts=opts, typ=GetDatabaseMysqlV2Result).value

    return AwaitableGetDatabaseMysqlV2Result(
        allow_lists=pulumi.get(__ret__, 'allow_lists'),
        ca_cert=pulumi.get(__ret__, 'ca_cert'),
        cluster_size=pulumi.get(__ret__, 'cluster_size'),
        created=pulumi.get(__ret__, 'created'),
        encrypted=pulumi.get(__ret__, 'encrypted'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_config_binlog_retention_period=pulumi.get(__ret__, 'engine_config_binlog_retention_period'),
        engine_config_mysql_connect_timeout=pulumi.get(__ret__, 'engine_config_mysql_connect_timeout'),
        engine_config_mysql_default_time_zone=pulumi.get(__ret__, 'engine_config_mysql_default_time_zone'),
        engine_config_mysql_group_concat_max_len=pulumi.get(__ret__, 'engine_config_mysql_group_concat_max_len'),
        engine_config_mysql_information_schema_stats_expiry=pulumi.get(__ret__, 'engine_config_mysql_information_schema_stats_expiry'),
        engine_config_mysql_innodb_change_buffer_max_size=pulumi.get(__ret__, 'engine_config_mysql_innodb_change_buffer_max_size'),
        engine_config_mysql_innodb_flush_neighbors=pulumi.get(__ret__, 'engine_config_mysql_innodb_flush_neighbors'),
        engine_config_mysql_innodb_ft_min_token_size=pulumi.get(__ret__, 'engine_config_mysql_innodb_ft_min_token_size'),
        engine_config_mysql_innodb_ft_server_stopword_table=pulumi.get(__ret__, 'engine_config_mysql_innodb_ft_server_stopword_table'),
        engine_config_mysql_innodb_lock_wait_timeout=pulumi.get(__ret__, 'engine_config_mysql_innodb_lock_wait_timeout'),
        engine_config_mysql_innodb_log_buffer_size=pulumi.get(__ret__, 'engine_config_mysql_innodb_log_buffer_size'),
        engine_config_mysql_innodb_online_alter_log_max_size=pulumi.get(__ret__, 'engine_config_mysql_innodb_online_alter_log_max_size'),
        engine_config_mysql_innodb_read_io_threads=pulumi.get(__ret__, 'engine_config_mysql_innodb_read_io_threads'),
        engine_config_mysql_innodb_rollback_on_timeout=pulumi.get(__ret__, 'engine_config_mysql_innodb_rollback_on_timeout'),
        engine_config_mysql_innodb_thread_concurrency=pulumi.get(__ret__, 'engine_config_mysql_innodb_thread_concurrency'),
        engine_config_mysql_innodb_write_io_threads=pulumi.get(__ret__, 'engine_config_mysql_innodb_write_io_threads'),
        engine_config_mysql_interactive_timeout=pulumi.get(__ret__, 'engine_config_mysql_interactive_timeout'),
        engine_config_mysql_internal_tmp_mem_storage_engine=pulumi.get(__ret__, 'engine_config_mysql_internal_tmp_mem_storage_engine'),
        engine_config_mysql_max_allowed_packet=pulumi.get(__ret__, 'engine_config_mysql_max_allowed_packet'),
        engine_config_mysql_max_heap_table_size=pulumi.get(__ret__, 'engine_config_mysql_max_heap_table_size'),
        engine_config_mysql_net_buffer_length=pulumi.get(__ret__, 'engine_config_mysql_net_buffer_length'),
        engine_config_mysql_net_read_timeout=pulumi.get(__ret__, 'engine_config_mysql_net_read_timeout'),
        engine_config_mysql_net_write_timeout=pulumi.get(__ret__, 'engine_config_mysql_net_write_timeout'),
        engine_config_mysql_sort_buffer_size=pulumi.get(__ret__, 'engine_config_mysql_sort_buffer_size'),
        engine_config_mysql_sql_mode=pulumi.get(__ret__, 'engine_config_mysql_sql_mode'),
        engine_config_mysql_sql_require_primary_key=pulumi.get(__ret__, 'engine_config_mysql_sql_require_primary_key'),
        engine_config_mysql_tmp_table_size=pulumi.get(__ret__, 'engine_config_mysql_tmp_table_size'),
        engine_config_mysql_wait_timeout=pulumi.get(__ret__, 'engine_config_mysql_wait_timeout'),
        engine_id=pulumi.get(__ret__, 'engine_id'),
        fork_restore_time=pulumi.get(__ret__, 'fork_restore_time'),
        fork_source=pulumi.get(__ret__, 'fork_source'),
        host_primary=pulumi.get(__ret__, 'host_primary'),
        host_secondary=pulumi.get(__ret__, 'host_secondary'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        members=pulumi.get(__ret__, 'members'),
        oldest_restore_time=pulumi.get(__ret__, 'oldest_restore_time'),
        pending_updates=pulumi.get(__ret__, 'pending_updates'),
        platform=pulumi.get(__ret__, 'platform'),
        port=pulumi.get(__ret__, 'port'),
        private_network=pulumi.get(__ret__, 'private_network'),
        region=pulumi.get(__ret__, 'region'),
        root_password=pulumi.get(__ret__, 'root_password'),
        root_username=pulumi.get(__ret__, 'root_username'),
        ssl_connection=pulumi.get(__ret__, 'ssl_connection'),
        status=pulumi.get(__ret__, 'status'),
        suspended=pulumi.get(__ret__, 'suspended'),
        type=pulumi.get(__ret__, 'type'),
        updated=pulumi.get(__ret__, 'updated'),
        updates=pulumi.get(__ret__, 'updates'),
        version=pulumi.get(__ret__, 'version'))
def get_database_mysql_v2_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseMysqlV2Result]:
    """
    Provides information about a Linode MySQL Database.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-databases-mysql-instance).

    ## Example Usage

    Get information about a MySQL database:

    ```python
    import pulumi
    import pulumi_linode as linode

    my_db = linode.get_database_mysql_v2(id="12345")
    ```

    ## pending_updates

    The following arguments are exposed by each entry in the `pending_updates` attribute:

    * `deadline` - The time when a mandatory update needs to be applied.

    * `description` - A description of the update.

    * `planned_for` - The date and time a maintenance update will be applied.

    ## updates

    The following arguments are supported in the `updates` specification block:

    * `day_of_week` - The day to perform maintenance. (`monday`, `tuesday`, ...)

    * `duration` - The maximum maintenance window time in hours. (`1`..`3`)

    * `frequency` - The frequency at which maintenance occurs. (`weekly`)

    * `hour_of_day` - The hour to begin maintenance based in UTC time. (`0`..`23`)

    ## private_network

    The following arguments are exposed by the `private_network` attribute:

    * `vpc_id` - The ID of the virtual private cloud (VPC) to restrict access to this database using.

    * `subnet_id` - The ID of the VPC subnet to restrict access to this database using.

    * `public_access` - If true, clients outside the VPC can connect to the database using a public IP address.


    :param _builtins.str id: The ID of the MySQL database.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getDatabaseMysqlV2:getDatabaseMysqlV2', __args__, opts=opts, typ=GetDatabaseMysqlV2Result)
    return __ret__.apply(lambda __response__: GetDatabaseMysqlV2Result(
        allow_lists=pulumi.get(__response__, 'allow_lists'),
        ca_cert=pulumi.get(__response__, 'ca_cert'),
        cluster_size=pulumi.get(__response__, 'cluster_size'),
        created=pulumi.get(__response__, 'created'),
        encrypted=pulumi.get(__response__, 'encrypted'),
        engine=pulumi.get(__response__, 'engine'),
        engine_config_binlog_retention_period=pulumi.get(__response__, 'engine_config_binlog_retention_period'),
        engine_config_mysql_connect_timeout=pulumi.get(__response__, 'engine_config_mysql_connect_timeout'),
        engine_config_mysql_default_time_zone=pulumi.get(__response__, 'engine_config_mysql_default_time_zone'),
        engine_config_mysql_group_concat_max_len=pulumi.get(__response__, 'engine_config_mysql_group_concat_max_len'),
        engine_config_mysql_information_schema_stats_expiry=pulumi.get(__response__, 'engine_config_mysql_information_schema_stats_expiry'),
        engine_config_mysql_innodb_change_buffer_max_size=pulumi.get(__response__, 'engine_config_mysql_innodb_change_buffer_max_size'),
        engine_config_mysql_innodb_flush_neighbors=pulumi.get(__response__, 'engine_config_mysql_innodb_flush_neighbors'),
        engine_config_mysql_innodb_ft_min_token_size=pulumi.get(__response__, 'engine_config_mysql_innodb_ft_min_token_size'),
        engine_config_mysql_innodb_ft_server_stopword_table=pulumi.get(__response__, 'engine_config_mysql_innodb_ft_server_stopword_table'),
        engine_config_mysql_innodb_lock_wait_timeout=pulumi.get(__response__, 'engine_config_mysql_innodb_lock_wait_timeout'),
        engine_config_mysql_innodb_log_buffer_size=pulumi.get(__response__, 'engine_config_mysql_innodb_log_buffer_size'),
        engine_config_mysql_innodb_online_alter_log_max_size=pulumi.get(__response__, 'engine_config_mysql_innodb_online_alter_log_max_size'),
        engine_config_mysql_innodb_read_io_threads=pulumi.get(__response__, 'engine_config_mysql_innodb_read_io_threads'),
        engine_config_mysql_innodb_rollback_on_timeout=pulumi.get(__response__, 'engine_config_mysql_innodb_rollback_on_timeout'),
        engine_config_mysql_innodb_thread_concurrency=pulumi.get(__response__, 'engine_config_mysql_innodb_thread_concurrency'),
        engine_config_mysql_innodb_write_io_threads=pulumi.get(__response__, 'engine_config_mysql_innodb_write_io_threads'),
        engine_config_mysql_interactive_timeout=pulumi.get(__response__, 'engine_config_mysql_interactive_timeout'),
        engine_config_mysql_internal_tmp_mem_storage_engine=pulumi.get(__response__, 'engine_config_mysql_internal_tmp_mem_storage_engine'),
        engine_config_mysql_max_allowed_packet=pulumi.get(__response__, 'engine_config_mysql_max_allowed_packet'),
        engine_config_mysql_max_heap_table_size=pulumi.get(__response__, 'engine_config_mysql_max_heap_table_size'),
        engine_config_mysql_net_buffer_length=pulumi.get(__response__, 'engine_config_mysql_net_buffer_length'),
        engine_config_mysql_net_read_timeout=pulumi.get(__response__, 'engine_config_mysql_net_read_timeout'),
        engine_config_mysql_net_write_timeout=pulumi.get(__response__, 'engine_config_mysql_net_write_timeout'),
        engine_config_mysql_sort_buffer_size=pulumi.get(__response__, 'engine_config_mysql_sort_buffer_size'),
        engine_config_mysql_sql_mode=pulumi.get(__response__, 'engine_config_mysql_sql_mode'),
        engine_config_mysql_sql_require_primary_key=pulumi.get(__response__, 'engine_config_mysql_sql_require_primary_key'),
        engine_config_mysql_tmp_table_size=pulumi.get(__response__, 'engine_config_mysql_tmp_table_size'),
        engine_config_mysql_wait_timeout=pulumi.get(__response__, 'engine_config_mysql_wait_timeout'),
        engine_id=pulumi.get(__response__, 'engine_id'),
        fork_restore_time=pulumi.get(__response__, 'fork_restore_time'),
        fork_source=pulumi.get(__response__, 'fork_source'),
        host_primary=pulumi.get(__response__, 'host_primary'),
        host_secondary=pulumi.get(__response__, 'host_secondary'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        members=pulumi.get(__response__, 'members'),
        oldest_restore_time=pulumi.get(__response__, 'oldest_restore_time'),
        pending_updates=pulumi.get(__response__, 'pending_updates'),
        platform=pulumi.get(__response__, 'platform'),
        port=pulumi.get(__response__, 'port'),
        private_network=pulumi.get(__response__, 'private_network'),
        region=pulumi.get(__response__, 'region'),
        root_password=pulumi.get(__response__, 'root_password'),
        root_username=pulumi.get(__response__, 'root_username'),
        ssl_connection=pulumi.get(__response__, 'ssl_connection'),
        status=pulumi.get(__response__, 'status'),
        suspended=pulumi.get(__response__, 'suspended'),
        type=pulumi.get(__response__, 'type'),
        updated=pulumi.get(__response__, 'updated'),
        updates=pulumi.get(__response__, 'updates'),
        version=pulumi.get(__response__, 'version')))
