# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFirewallTemplateResult',
    'AwaitableGetFirewallTemplateResult',
    'get_firewall_template',
    'get_firewall_template_output',
]

@pulumi.output_type
class GetFirewallTemplateResult:
    """
    A collection of values returned by getFirewallTemplate.
    """
    def __init__(__self__, id=None, inbound_policy=None, inbounds=None, outbound_policy=None, outbounds=None, slug=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_policy and not isinstance(inbound_policy, str):
            raise TypeError("Expected argument 'inbound_policy' to be a str")
        pulumi.set(__self__, "inbound_policy", inbound_policy)
        if inbounds and not isinstance(inbounds, list):
            raise TypeError("Expected argument 'inbounds' to be a list")
        pulumi.set(__self__, "inbounds", inbounds)
        if outbound_policy and not isinstance(outbound_policy, str):
            raise TypeError("Expected argument 'outbound_policy' to be a str")
        pulumi.set(__self__, "outbound_policy", outbound_policy)
        if outbounds and not isinstance(outbounds, list):
            raise TypeError("Expected argument 'outbounds' to be a list")
        pulumi.set(__self__, "outbounds", outbounds)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The computed ID of the data source, which matches the `slug` attribute.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundPolicy")
    def inbound_policy(self) -> _builtins.str:
        """
        The default behavior for inbound traffic. This can be overridden by individual firewall rules.
        """
        return pulumi.get(self, "inbound_policy")

    @_builtins.property
    @pulumi.getter
    def inbounds(self) -> Sequence['outputs.GetFirewallTemplateInboundResult']:
        """
        A list of firewall rules specifying allowed inbound network traffic.
        """
        return pulumi.get(self, "inbounds")

    @_builtins.property
    @pulumi.getter(name="outboundPolicy")
    def outbound_policy(self) -> _builtins.str:
        """
        The default behavior for outbound traffic. This can be overridden by individual firewall rules.
        """
        return pulumi.get(self, "outbound_policy")

    @_builtins.property
    @pulumi.getter
    def outbounds(self) -> Sequence['outputs.GetFirewallTemplateOutboundResult']:
        """
        A list of firewall rules specifying allowed outbound network traffic.
        """
        return pulumi.get(self, "outbounds")

    @_builtins.property
    @pulumi.getter
    def slug(self) -> _builtins.str:
        return pulumi.get(self, "slug")


class AwaitableGetFirewallTemplateResult(GetFirewallTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallTemplateResult(
            id=self.id,
            inbound_policy=self.inbound_policy,
            inbounds=self.inbounds,
            outbound_policy=self.outbound_policy,
            outbounds=self.outbounds,
            slug=self.slug)


def get_firewall_template(slug: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallTemplateResult:
    """
    Provides information about a Linode Firewall Template.

    ## Example Usage

    The following example shows how one might use this data source to access information about a specific Firewall Template:

    ```python
    import pulumi
    import pulumi_linode as linode

    public_template = linode.get_firewall_template(slug="public")
    pulumi.export("firewallTemplateId", public_template.id)
    ```


    :param _builtins.str slug: The slug of the firewall template.
    """
    __args__ = dict()
    __args__['slug'] = slug
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getFirewallTemplate:getFirewallTemplate', __args__, opts=opts, typ=GetFirewallTemplateResult).value

    return AwaitableGetFirewallTemplateResult(
        id=pulumi.get(__ret__, 'id'),
        inbound_policy=pulumi.get(__ret__, 'inbound_policy'),
        inbounds=pulumi.get(__ret__, 'inbounds'),
        outbound_policy=pulumi.get(__ret__, 'outbound_policy'),
        outbounds=pulumi.get(__ret__, 'outbounds'),
        slug=pulumi.get(__ret__, 'slug'))
def get_firewall_template_output(slug: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallTemplateResult]:
    """
    Provides information about a Linode Firewall Template.

    ## Example Usage

    The following example shows how one might use this data source to access information about a specific Firewall Template:

    ```python
    import pulumi
    import pulumi_linode as linode

    public_template = linode.get_firewall_template(slug="public")
    pulumi.export("firewallTemplateId", public_template.id)
    ```


    :param _builtins.str slug: The slug of the firewall template.
    """
    __args__ = dict()
    __args__['slug'] = slug
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getFirewallTemplate:getFirewallTemplate', __args__, opts=opts, typ=GetFirewallTemplateResult)
    return __ret__.apply(lambda __response__: GetFirewallTemplateResult(
        id=pulumi.get(__response__, 'id'),
        inbound_policy=pulumi.get(__response__, 'inbound_policy'),
        inbounds=pulumi.get(__response__, 'inbounds'),
        outbound_policy=pulumi.get(__response__, 'outbound_policy'),
        outbounds=pulumi.get(__response__, 'outbounds'),
        slug=pulumi.get(__response__, 'slug')))
