# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFirewallTemplatesResult',
    'AwaitableGetFirewallTemplatesResult',
    'get_firewall_templates',
    'get_firewall_templates_output',
]

@pulumi.output_type
class GetFirewallTemplatesResult:
    """
    A collection of values returned by getFirewallTemplates.
    """
    def __init__(__self__, filters=None, firewall_templates=None, id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if firewall_templates and not isinstance(firewall_templates, list):
            raise TypeError("Expected argument 'firewall_templates' to be a list")
        pulumi.set(__self__, "firewall_templates", firewall_templates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFirewallTemplatesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="firewallTemplates")
    def firewall_templates(self) -> Optional[Sequence['outputs.GetFirewallTemplatesFirewallTemplateResult']]:
        return pulumi.get(self, "firewall_templates")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


class AwaitableGetFirewallTemplatesResult(GetFirewallTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallTemplatesResult(
            filters=self.filters,
            firewall_templates=self.firewall_templates,
            id=self.id)


def get_firewall_templates(filters: Optional[Sequence[Union['GetFirewallTemplatesFilterArgs', 'GetFirewallTemplatesFilterArgsDict']]] = None,
                           firewall_templates: Optional[Sequence[Union['GetFirewallTemplatesFirewallTemplateArgs', 'GetFirewallTemplatesFirewallTemplateArgsDict']]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallTemplatesResult:
    """
    Provides information about all Linode Firewall Templates.

    ## Example Usage

    The following example shows how one might use this data source to list all available Firewall Templates:

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_firewall_templates()
    pulumi.export("firewallTemplateSlugs", all.firewall_templates)
    ```

    Or with some filters to get a subset of the results.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered = linode.get_firewall_templates(filters=[{
        "name": "slug",
        "values": ["public"],
        "match_by": "exact",
    }])
    pulumi.export("firewallTemplateSlugs", filtered.firewall_templates)
    ```

    ## Filterable Fields

    * `slug`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['firewallTemplates'] = firewall_templates
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getFirewallTemplates:getFirewallTemplates', __args__, opts=opts, typ=GetFirewallTemplatesResult).value

    return AwaitableGetFirewallTemplatesResult(
        filters=pulumi.get(__ret__, 'filters'),
        firewall_templates=pulumi.get(__ret__, 'firewall_templates'),
        id=pulumi.get(__ret__, 'id'))
def get_firewall_templates_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFirewallTemplatesFilterArgs', 'GetFirewallTemplatesFilterArgsDict']]]]] = None,
                                  firewall_templates: Optional[pulumi.Input[Optional[Sequence[Union['GetFirewallTemplatesFirewallTemplateArgs', 'GetFirewallTemplatesFirewallTemplateArgsDict']]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallTemplatesResult]:
    """
    Provides information about all Linode Firewall Templates.

    ## Example Usage

    The following example shows how one might use this data source to list all available Firewall Templates:

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_firewall_templates()
    pulumi.export("firewallTemplateSlugs", all.firewall_templates)
    ```

    Or with some filters to get a subset of the results.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered = linode.get_firewall_templates(filters=[{
        "name": "slug",
        "values": ["public"],
        "match_by": "exact",
    }])
    pulumi.export("firewallTemplateSlugs", filtered.firewall_templates)
    ```

    ## Filterable Fields

    * `slug`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['firewallTemplates'] = firewall_templates
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getFirewallTemplates:getFirewallTemplates', __args__, opts=opts, typ=GetFirewallTemplatesResult)
    return __ret__.apply(lambda __response__: GetFirewallTemplatesResult(
        filters=pulumi.get(__response__, 'filters'),
        firewall_templates=pulumi.get(__response__, 'firewall_templates'),
        id=pulumi.get(__response__, 'id')))
