# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNodebalancerVpcResult',
    'AwaitableGetNodebalancerVpcResult',
    'get_nodebalancer_vpc',
    'get_nodebalancer_vpc_output',
]

@pulumi.output_type
class GetNodebalancerVpcResult:
    """
    A collection of values returned by getNodebalancerVpc.
    """
    def __init__(__self__, id=None, ipv4_range=None, nodebalancer_id=None, subnet_id=None, vpc_id=None):
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if ipv4_range and not isinstance(ipv4_range, str):
            raise TypeError("Expected argument 'ipv4_range' to be a str")
        pulumi.set(__self__, "ipv4_range", ipv4_range)
        if nodebalancer_id and not isinstance(nodebalancer_id, int):
            raise TypeError("Expected argument 'nodebalancer_id' to be a int")
        pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if subnet_id and not isinstance(subnet_id, int):
            raise TypeError("Expected argument 'subnet_id' to be a int")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id and not isinstance(vpc_id, int):
            raise TypeError("Expected argument 'vpc_id' to be a int")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv4Range")
    def ipv4_range(self) -> _builtins.str:
        """
        A CIDR range for the VPC's IPv4 addresses. The NodeBalancer sources IP addresses from this range when routing traffic to the backend VPC nodes.
        """
        return pulumi.get(self, "ipv4_range")

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> _builtins.int:
        return pulumi.get(self, "nodebalancer_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.int:
        """
        The ID of this configuration's VPC subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.int:
        """
        The ID of this configuration's VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetNodebalancerVpcResult(GetNodebalancerVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodebalancerVpcResult(
            id=self.id,
            ipv4_range=self.ipv4_range,
            nodebalancer_id=self.nodebalancer_id,
            subnet_id=self.subnet_id,
            vpc_id=self.vpc_id)


def get_nodebalancer_vpc(id: Optional[_builtins.int] = None,
                         nodebalancer_id: Optional[_builtins.int] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodebalancerVpcResult:
    """
    > **Limited Availability** VPC-attached NodeBalancers may not currently be available to all users and may require the `api_version` provider argument must be set to `v4beta`.

    Provides information about a NodeBalancer VPC configuration.
    For more information, see the corresponding [Linode APIv4 documentation](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-vpc-config).

    ## Example Usage

    Retrieve information about a NodeBalancer VPC configuration:

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_config = linode.get_nodebalancer_vpc(nodebalancer_id=123,
        id=456)
    ```


    :param _builtins.int id: The ID of the VPC configuration.
    :param _builtins.int nodebalancer_id: The ID of the parent NodeBalancer of the VPC configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['nodebalancerId'] = nodebalancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getNodebalancerVpc:getNodebalancerVpc', __args__, opts=opts, typ=GetNodebalancerVpcResult).value

    return AwaitableGetNodebalancerVpcResult(
        id=pulumi.get(__ret__, 'id'),
        ipv4_range=pulumi.get(__ret__, 'ipv4_range'),
        nodebalancer_id=pulumi.get(__ret__, 'nodebalancer_id'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_nodebalancer_vpc_output(id: Optional[pulumi.Input[_builtins.int]] = None,
                                nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodebalancerVpcResult]:
    """
    > **Limited Availability** VPC-attached NodeBalancers may not currently be available to all users and may require the `api_version` provider argument must be set to `v4beta`.

    Provides information about a NodeBalancer VPC configuration.
    For more information, see the corresponding [Linode APIv4 documentation](https://techdocs.akamai.com/linode-api/reference/get-node-balancer-vpc-config).

    ## Example Usage

    Retrieve information about a NodeBalancer VPC configuration:

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_config = linode.get_nodebalancer_vpc(nodebalancer_id=123,
        id=456)
    ```


    :param _builtins.int id: The ID of the VPC configuration.
    :param _builtins.int nodebalancer_id: The ID of the parent NodeBalancer of the VPC configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['nodebalancerId'] = nodebalancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getNodebalancerVpc:getNodebalancerVpc', __args__, opts=opts, typ=GetNodebalancerVpcResult)
    return __ret__.apply(lambda __response__: GetNodebalancerVpcResult(
        id=pulumi.get(__response__, 'id'),
        ipv4_range=pulumi.get(__response__, 'ipv4_range'),
        nodebalancer_id=pulumi.get(__response__, 'nodebalancer_id'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
