# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNodebalancerVpcsResult',
    'AwaitableGetNodebalancerVpcsResult',
    'get_nodebalancer_vpcs',
    'get_nodebalancer_vpcs_output',
]

@pulumi.output_type
class GetNodebalancerVpcsResult:
    """
    A collection of values returned by getNodebalancerVpcs.
    """
    def __init__(__self__, filters=None, id=None, nodebalancer_id=None, order=None, order_by=None, vpc_configs=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nodebalancer_id and not isinstance(nodebalancer_id, int):
            raise TypeError("Expected argument 'nodebalancer_id' to be a int")
        pulumi.set(__self__, "nodebalancer_id", nodebalancer_id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if vpc_configs and not isinstance(vpc_configs, list):
            raise TypeError("Expected argument 'vpc_configs' to be a list")
        pulumi.set(__self__, "vpc_configs", vpc_configs)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNodebalancerVpcsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the VPC configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nodebalancerId")
    def nodebalancer_id(self) -> _builtins.int:
        """
        The ID of the parent NodeBalancer for this VPC configuration.
        """
        return pulumi.get(self, "nodebalancer_id")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter(name="vpcConfigs")
    def vpc_configs(self) -> Sequence['outputs.GetNodebalancerVpcsVpcConfigResult']:
        return pulumi.get(self, "vpc_configs")


class AwaitableGetNodebalancerVpcsResult(GetNodebalancerVpcsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodebalancerVpcsResult(
            filters=self.filters,
            id=self.id,
            nodebalancer_id=self.nodebalancer_id,
            order=self.order,
            order_by=self.order_by,
            vpc_configs=self.vpc_configs)


def get_nodebalancer_vpcs(filters: Optional[Sequence[Union['GetNodebalancerVpcsFilterArgs', 'GetNodebalancerVpcsFilterArgsDict']]] = None,
                          nodebalancer_id: Optional[_builtins.int] = None,
                          order: Optional[_builtins.str] = None,
                          order_by: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodebalancerVpcsResult:
    """
    > **Limited Availability** VPC-attached NodeBalancers may not currently be available to all users and may require the `api_version` provider argument must be set to `v4beta`.

    Provides information about Linode NodeBalancers VPC configurations that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancers).

    ## Example Usage

    Retrieve all VPC configurations under a NodeBalancer:

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_configs = linode.get_nodebalancer_vpcs(nodebalancer_id=12345)
    ```

    Retrieve all VPC configurations under a NodeBalancer with an IPv4 range of "10.0.0.4/30":

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_configs = linode.get_nodebalancer_vpcs(nodebalancer_id=12345,
        filters=[{
            "name": "ipv4_range",
            "values": ["10.0.0.4/30"],
        }])
    ```

    ## Filterable Fields

    * `id`

    * `ipv4_range`

    * `nodebalancer_id`

    * `subnet_id`

    * `vpc_id`


    :param _builtins.int nodebalancer_id: The ID of the NodeBalancer to list VPC configurations for.
           
           * `filter` - (Optional) A set of filters used to select VPC configurations that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['nodebalancerId'] = nodebalancer_id
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getNodebalancerVpcs:getNodebalancerVpcs', __args__, opts=opts, typ=GetNodebalancerVpcsResult).value

    return AwaitableGetNodebalancerVpcsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        nodebalancer_id=pulumi.get(__ret__, 'nodebalancer_id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'),
        vpc_configs=pulumi.get(__ret__, 'vpc_configs'))
def get_nodebalancer_vpcs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNodebalancerVpcsFilterArgs', 'GetNodebalancerVpcsFilterArgsDict']]]]] = None,
                                 nodebalancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                                 order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNodebalancerVpcsResult]:
    """
    > **Limited Availability** VPC-attached NodeBalancers may not currently be available to all users and may require the `api_version` provider argument must be set to `v4beta`.

    Provides information about Linode NodeBalancers VPC configurations that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-node-balancers).

    ## Example Usage

    Retrieve all VPC configurations under a NodeBalancer:

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_configs = linode.get_nodebalancer_vpcs(nodebalancer_id=12345)
    ```

    Retrieve all VPC configurations under a NodeBalancer with an IPv4 range of "10.0.0.4/30":

    ```python
    import pulumi
    import pulumi_linode as linode

    vpc_configs = linode.get_nodebalancer_vpcs(nodebalancer_id=12345,
        filters=[{
            "name": "ipv4_range",
            "values": ["10.0.0.4/30"],
        }])
    ```

    ## Filterable Fields

    * `id`

    * `ipv4_range`

    * `nodebalancer_id`

    * `subnet_id`

    * `vpc_id`


    :param _builtins.int nodebalancer_id: The ID of the NodeBalancer to list VPC configurations for.
           
           * `filter` - (Optional) A set of filters used to select VPC configurations that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['nodebalancerId'] = nodebalancer_id
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getNodebalancerVpcs:getNodebalancerVpcs', __args__, opts=opts, typ=GetNodebalancerVpcsResult)
    return __ret__.apply(lambda __response__: GetNodebalancerVpcsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        nodebalancer_id=pulumi.get(__response__, 'nodebalancer_id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by'),
        vpc_configs=pulumi.get(__response__, 'vpc_configs')))
