# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSshKeyResult',
    'AwaitableGetSshKeyResult',
    'get_ssh_key',
    'get_ssh_key_output',
]

@pulumi.output_type
class GetSshKeyResult:
    """
    A collection of values returned by getSshKey.
    """
    def __init__(__self__, created=None, id=None, label=None, ssh_key=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if ssh_key and not isinstance(ssh_key, str):
            raise TypeError("Expected argument 'ssh_key' to be a str")
        pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date this key was added.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the SSH Key
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> _builtins.str:
        """
        The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        return pulumi.get(self, "ssh_key")


class AwaitableGetSshKeyResult(GetSshKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshKeyResult(
            created=self.created,
            id=self.id,
            label=self.label,
            ssh_key=self.ssh_key)


def get_ssh_key(id: Optional[_builtins.str] = None,
                label: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshKeyResult:
    """
    `SshKey` provides access to a specifically labeled SSH Key in the Profile of the User identified by the access token.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ssh-key).

    ## Example Usage

    The following example shows how the resource might be used to obtain the name of the SSH Key configured on the Linode user profile.

    ```python
    import pulumi
    import pulumi_linode as linode

    foo = linode.get_ssh_key(label="foo")
    ```


    :param _builtins.str id: The ID of the SSH Key
    :param _builtins.str label: The label of the SSH Key to select.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getSshKey:getSshKey', __args__, opts=opts, typ=GetSshKeyResult).value

    return AwaitableGetSshKeyResult(
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        ssh_key=pulumi.get(__ret__, 'ssh_key'))
def get_ssh_key_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       label: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSshKeyResult]:
    """
    `SshKey` provides access to a specifically labeled SSH Key in the Profile of the User identified by the access token.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ssh-key).

    ## Example Usage

    The following example shows how the resource might be used to obtain the name of the SSH Key configured on the Linode user profile.

    ```python
    import pulumi
    import pulumi_linode as linode

    foo = linode.get_ssh_key(label="foo")
    ```


    :param _builtins.str id: The ID of the SSH Key
    :param _builtins.str label: The label of the SSH Key to select.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getSshKey:getSshKey', __args__, opts=opts, typ=GetSshKeyResult)
    return __ret__.apply(lambda __response__: GetSshKeyResult(
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        ssh_key=pulumi.get(__response__, 'ssh_key')))
