# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcIpsResult',
    'AwaitableGetVpcIpsResult',
    'get_vpc_ips',
    'get_vpc_ips_output',
]

@pulumi.output_type
class GetVpcIpsResult:
    """
    A collection of values returned by getVpcIps.
    """
    def __init__(__self__, filters=None, id=None, ipv6=None, vpc_id=None, vpc_ips=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6 and not isinstance(ipv6, bool):
            raise TypeError("Expected argument 'ipv6' to be a bool")
        pulumi.set(__self__, "ipv6", ipv6)
        if vpc_id and not isinstance(vpc_id, int):
            raise TypeError("Expected argument 'vpc_id' to be a int")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_ips and not isinstance(vpc_ips, list):
            raise TypeError("Expected argument 'vpc_ips' to be a list")
        pulumi.set(__self__, "vpc_ips", vpc_ips)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcIpsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.int]:
        """
        The unique globally general API entity identifier for the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcIps")
    def vpc_ips(self) -> Optional[Sequence['outputs.GetVpcIpsVpcIpResult']]:
        return pulumi.get(self, "vpc_ips")


class AwaitableGetVpcIpsResult(GetVpcIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcIpsResult(
            filters=self.filters,
            id=self.id,
            ipv6=self.ipv6,
            vpc_id=self.vpc_id,
            vpc_ips=self.vpc_ips)


def get_vpc_ips(filters: Optional[Sequence[Union['GetVpcIpsFilterArgs', 'GetVpcIpsFilterArgsDict']]] = None,
                ipv6: Optional[_builtins.bool] = None,
                vpc_id: Optional[_builtins.int] = None,
                vpc_ips: Optional[Sequence[Union['GetVpcIpsVpcIpArgs', 'GetVpcIpsVpcIpArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcIpsResult:
    """
    Provides information about a list of Linode VPC IPs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpcs-ips).

    ## Example Usage

    The following example shows how one might use this data source to list VPC IPs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_ips = linode.get_vpc_ips(filters=[{
        "name": "address",
        "values": ["10.0.0.0"],
    }])
    pulumi.export("vpcIps", filtered_ips.vpc_ips)
    ```

    One might also use this data source to list all VPC IPs in a specific VPC. The following example shows how to do this.

    ```python
    import pulumi
    import pulumi_linode as linode

    specific_vpc_ips = linode.get_vpc_ips(vpc_id=123)
    pulumi.export("vpcIps", specific_vpc_ips.vpc_ips)
    ```

    By default, this data source retrieves only IPv4 addresses. To instead retrieve IPv6 addresses, the `ipv6` field should be set to true:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_vpc_ipv6 = linode.get_vpc_ips(ipv6=True)
    ```

    ## Filterable Fields

    * `active`

    * `config_id`

    * `linode_id`

    * `region`

    * `vpc_id`


    :param _builtins.int vpc_id: The id of the parent VPC for the list of VPC IPs.
           
           * `filter` - (Optional) A set of filters used to select Linode VPC IPs that meet certain requirements.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipv6'] = ipv6
    __args__['vpcId'] = vpc_id
    __args__['vpcIps'] = vpc_ips
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getVpcIps:getVpcIps', __args__, opts=opts, typ=GetVpcIpsResult).value

    return AwaitableGetVpcIpsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipv6=pulumi.get(__ret__, 'ipv6'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vpc_ips=pulumi.get(__ret__, 'vpc_ips'))
def get_vpc_ips_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcIpsFilterArgs', 'GetVpcIpsFilterArgsDict']]]]] = None,
                       ipv6: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       vpc_ips: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcIpsVpcIpArgs', 'GetVpcIpsVpcIpArgsDict']]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcIpsResult]:
    """
    Provides information about a list of Linode VPC IPs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpcs-ips).

    ## Example Usage

    The following example shows how one might use this data source to list VPC IPs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_ips = linode.get_vpc_ips(filters=[{
        "name": "address",
        "values": ["10.0.0.0"],
    }])
    pulumi.export("vpcIps", filtered_ips.vpc_ips)
    ```

    One might also use this data source to list all VPC IPs in a specific VPC. The following example shows how to do this.

    ```python
    import pulumi
    import pulumi_linode as linode

    specific_vpc_ips = linode.get_vpc_ips(vpc_id=123)
    pulumi.export("vpcIps", specific_vpc_ips.vpc_ips)
    ```

    By default, this data source retrieves only IPv4 addresses. To instead retrieve IPv6 addresses, the `ipv6` field should be set to true:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_vpc_ipv6 = linode.get_vpc_ips(ipv6=True)
    ```

    ## Filterable Fields

    * `active`

    * `config_id`

    * `linode_id`

    * `region`

    * `vpc_id`


    :param _builtins.int vpc_id: The id of the parent VPC for the list of VPC IPs.
           
           * `filter` - (Optional) A set of filters used to select Linode VPC IPs that meet certain requirements.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipv6'] = ipv6
    __args__['vpcId'] = vpc_id
    __args__['vpcIps'] = vpc_ips
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getVpcIps:getVpcIps', __args__, opts=opts, typ=GetVpcIpsResult)
    return __ret__.apply(lambda __response__: GetVpcIpsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipv6=pulumi.get(__response__, 'ipv6'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vpc_ips=pulumi.get(__response__, 'vpc_ips')))
