# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcsResult',
    'AwaitableGetVpcsResult',
    'get_vpcs',
    'get_vpcs_output',
]

@pulumi.output_type
class GetVpcsResult:
    """
    A collection of values returned by getVpcs.
    """
    def __init__(__self__, filters=None, id=None, vpcs=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique id of this VPC.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Optional[Sequence['outputs.GetVpcsVpcResult']]:
        return pulumi.get(self, "vpcs")


class AwaitableGetVpcsResult(GetVpcsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcsResult(
            filters=self.filters,
            id=self.id,
            vpcs=self.vpcs)


def get_vpcs(filters: Optional[Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']]] = None,
             vpcs: Optional[Sequence[Union['GetVpcsVpcArgs', 'GetVpcsVpcArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcsResult:
    """
    Provides information about a list of Linode VPCs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpcs).

    ## Example Usage

    The following example shows how one might use this data source to list VPCs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_vpcs = linode.get_vpcs(filters=[{
        "name": "label",
        "values": ["test"],
    }])
    pulumi.export("vpcs", filtered_vpcs.vpcs)
    ```

    ## IPv6

    > **Limited Availability** IPv6 VPCs may not currently be available to all users.

    Contains information about a single IPv6 allocation under a VPC.

    * `range` - The allocated range in CIDR format.

    ## Filterable Fields

    * `id`

    * `label`

    * `description`

    * `region`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vpcs'] = vpcs
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult).value

    return AwaitableGetVpcsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_vpcs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']]]]] = None,
                    vpcs: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcsVpcArgs', 'GetVpcsVpcArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcsResult]:
    """
    Provides information about a list of Linode VPCs that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-vpcs).

    ## Example Usage

    The following example shows how one might use this data source to list VPCs.

    ```python
    import pulumi
    import pulumi_linode as linode

    filtered_vpcs = linode.get_vpcs(filters=[{
        "name": "label",
        "values": ["test"],
    }])
    pulumi.export("vpcs", filtered_vpcs.vpcs)
    ```

    ## IPv6

    > **Limited Availability** IPv6 VPCs may not currently be available to all users.

    Contains information about a single IPv6 allocation under a VPC.

    * `range` - The allocated range in CIDR format.

    ## Filterable Fields

    * `id`

    * `label`

    * `description`

    * `region`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vpcs'] = vpcs
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult)
    return __ret__.apply(lambda __response__: GetVpcsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        vpcs=pulumi.get(__response__, 'vpcs')))
