# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 cloud_init: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.int]] = None,
                 file_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ImageTimeoutsArgs']] = None,
                 wait_for_replications: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] label: A short description of the Image. Labels cannot contain special characters.
        :param pulumi.Input[_builtins.bool] cloud_init: Whether this image supports cloud-init.
        :param pulumi.Input[_builtins.str] description: A detailed description of this Image.
        :param pulumi.Input[_builtins.int] disk_id: The ID of the Linode Disk that this Image will be created from.
        :param pulumi.Input[_builtins.str] file_hash: The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        :param pulumi.Input[_builtins.str] file_path: The path of the image file to be uploaded.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode that this Image will be created from.
               
               - - -
               
               > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.
               
               The following arguments apply to uploading an image:
        :param pulumi.Input[_builtins.str] region: The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_regions: A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of customized tags.
        :param pulumi.Input[_builtins.bool] wait_for_replications: Whether to wait for all image replications become `available`. Default to false.
               
               - - -
               
               The following arguments apply to creating an image from an existing Linode Instance:
        """
        pulumi.set(__self__, "label", label)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if file_hash is not None:
            pulumi.set(__self__, "file_hash", file_hash)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_regions is not None:
            pulumi.set(__self__, "replica_regions", replica_regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if wait_for_replications is not None:
            pulumi.set(__self__, "wait_for_replications", wait_for_replications)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A short description of the Image. Labels cannot contain special characters.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this image supports cloud-init.
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_init", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of this Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode Disk that this Image will be created from.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="fileHash")
    def file_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        """
        return pulumi.get(self, "file_hash")

    @file_hash.setter
    def file_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_hash", value)

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the image file to be uploaded.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_path", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode that this Image will be created from.

        - - -

        > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.

        The following arguments apply to uploading an image:
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        """
        return pulumi.get(self, "replica_regions")

    @replica_regions.setter
    def replica_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replica_regions", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of customized tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ImageTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ImageTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="waitForReplications")
    def wait_for_replications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for all image replications become `available`. Default to false.

        - - -

        The following arguments apply to creating an image from an existing Linode Instance:
        """
        return pulumi.get(self, "wait_for_replications")

    @wait_for_replications.setter
    def wait_for_replications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_replications", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cloud_init: Optional[pulumi.Input[_builtins.bool]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 deprecated: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.int]] = None,
                 expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 file_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replications: Optional[pulumi.Input[Sequence[pulumi.Input['ImageReplicationArgs']]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ImageTimeoutsArgs']] = None,
                 total_size: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_replications: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The capabilities of this Image.
        :param pulumi.Input[_builtins.bool] cloud_init: Whether this image supports cloud-init.
        :param pulumi.Input[_builtins.str] created: When this Image was created.
        :param pulumi.Input[_builtins.str] created_by: The name of the User who created this Image.
        :param pulumi.Input[_builtins.bool] deprecated: Whether or not this Image is deprecated. Will only be True for deprecated public Images.
        :param pulumi.Input[_builtins.str] description: A detailed description of this Image.
        :param pulumi.Input[_builtins.int] disk_id: The ID of the Linode Disk that this Image will be created from.
        :param pulumi.Input[_builtins.str] expiry: Only Images created automatically (from a deleted Linode; type=automatic) will expire.
        :param pulumi.Input[_builtins.str] file_hash: The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        :param pulumi.Input[_builtins.str] file_path: The path of the image file to be uploaded.
        :param pulumi.Input[_builtins.bool] is_public: True if the Image is public.
        :param pulumi.Input[_builtins.str] label: A short description of the Image. Labels cannot contain special characters.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode that this Image will be created from.
               
               - - -
               
               > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.
               
               The following arguments apply to uploading an image:
        :param pulumi.Input[_builtins.str] region: The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_regions: A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        :param pulumi.Input[Sequence[pulumi.Input['ImageReplicationArgs']]] replications: A list of image replications region and corresponding status.
        :param pulumi.Input[_builtins.int] size: The minimum size this Image needs to deploy. Size is in MB.
        :param pulumi.Input[_builtins.str] status: The status of an image replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of customized tags.
        :param pulumi.Input[_builtins.int] total_size: The total size of the image in all available regions.
        :param pulumi.Input[_builtins.str] type: How the Image was created. 'Manual' Images can be created at any time. 'Automatic' images are created automatically from a deleted Linode.
        :param pulumi.Input[_builtins.str] vendor: The upstream distribution vendor. Nil for private Images.
        :param pulumi.Input[_builtins.bool] wait_for_replications: Whether to wait for all image replications become `available`. Default to false.
               
               - - -
               
               The following arguments apply to creating an image from an existing Linode Instance:
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if file_hash is not None:
            pulumi.set(__self__, "file_hash", file_hash)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_regions is not None:
            pulumi.set(__self__, "replica_regions", replica_regions)
        if replications is not None:
            pulumi.set(__self__, "replications", replications)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if total_size is not None:
            pulumi.set(__self__, "total_size", total_size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)
        if wait_for_replications is not None:
            pulumi.set(__self__, "wait_for_replications", wait_for_replications)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The capabilities of this Image.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this image supports cloud-init.
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cloud_init", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this Image was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the User who created this Image.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not this Image is deprecated. Will only be True for deprecated public Images.
        """
        return pulumi.get(self, "deprecated")

    @deprecated.setter
    def deprecated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deprecated", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of this Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode Disk that this Image will be created from.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only Images created automatically (from a deleted Linode; type=automatic) will expire.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiry", value)

    @_builtins.property
    @pulumi.getter(name="fileHash")
    def file_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        """
        return pulumi.get(self, "file_hash")

    @file_hash.setter
    def file_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_hash", value)

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the image file to be uploaded.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_path", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        True if the Image is public.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short description of the Image. Labels cannot contain special characters.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode that this Image will be created from.

        - - -

        > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.

        The following arguments apply to uploading an image:
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        """
        return pulumi.get(self, "replica_regions")

    @replica_regions.setter
    def replica_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replica_regions", value)

    @_builtins.property
    @pulumi.getter
    def replications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageReplicationArgs']]]]:
        """
        A list of image replications region and corresponding status.
        """
        return pulumi.get(self, "replications")

    @replications.setter
    def replications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageReplicationArgs']]]]):
        pulumi.set(self, "replications", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum size this Image needs to deploy. Size is in MB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of an image replica.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of customized tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ImageTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ImageTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="totalSize")
    def total_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total size of the image in all available regions.
        """
        return pulumi.get(self, "total_size")

    @total_size.setter
    def total_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the Image was created. 'Manual' Images can be created at any time. 'Automatic' images are created automatically from a deleted Linode.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upstream distribution vendor. Nil for private Images.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vendor", value)

    @_builtins.property
    @pulumi.getter(name="waitForReplications")
    def wait_for_replications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for all image replications become `available`. Default to false.

        - - -

        The following arguments apply to creating an image from an existing Linode Instance:
        """
        return pulumi.get(self, "wait_for_replications")

    @wait_for_replications.setter
    def wait_for_replications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_replications", value)


@pulumi.type_token("linode:index/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_init: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.int]] = None,
                 file_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ImageTimeoutsArgs', 'ImageTimeoutsArgsDict']]] = None,
                 wait_for_replications: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Linode Image resource.  This can be used to create, modify, and delete Linodes Images.  Linode Images are snapshots of a Linode Instance Disk which can then be used to provision more Linode Instances.  Images can be used across regions.

        For more information, see [Linode's documentation on Images](https://www.linode.com/docs/platform/disk-images/linode-images/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-image).

        ## Example Usage

        Creating an image from an existing Linode Instance and deploying another instance with that image:

        ```python
        import pulumi
        import pulumi_linode as linode

        foo = linode.Instance("foo",
            type="g6-nanode-1",
            region="us-central",
            image="linode/ubuntu22.04",
            root_pass="insecure-p4ssw0rd!!")
        bar = linode.Image("bar",
            label="foo-sda-image",
            description="Image taken from foo",
            disk_id=foo.disks[0].id,
            linode_id=foo.id,
            tags=[
                "image-tag",
                "test",
            ])
        bar_based = linode.Instance("bar_based",
            type=foo.type,
            region="eu-west",
            image=bar.id)
        ```

        Creating and uploading an image from a local file:

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foobar = linode.Image("foobar",
            label="foobar-image",
            description="An image uploaded from Terraform!",
            region="us-southeast",
            tags=[
                "image-tag",
                "test",
            ],
            file_path="path/to/image.img.gz",
            file_hash=std.filemd5(input="path/to/image.img.gz").result)
        ```

        Upload and replicate an image from a local file:

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foobar = linode.Image("foobar",
            label="foobar-image",
            description="An image uploaded from Terraform!",
            region="us-southeast",
            tags=[
                "image-tag",
                "test",
            ],
            file_path="path/to/image.img.gz",
            file_hash=std.filemd5(input="path/to/image.img.gz").result,
            replica_regions=[
                "us-southeast",
                "us-east",
                "eu-west",
            ])
        ```

        ## Import

        Linodes Images can be imported using the Linode Image `id`, e.g.

        ```sh
        $ pulumi import linode:index/image:Image myimage 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cloud_init: Whether this image supports cloud-init.
        :param pulumi.Input[_builtins.str] description: A detailed description of this Image.
        :param pulumi.Input[_builtins.int] disk_id: The ID of the Linode Disk that this Image will be created from.
        :param pulumi.Input[_builtins.str] file_hash: The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        :param pulumi.Input[_builtins.str] file_path: The path of the image file to be uploaded.
        :param pulumi.Input[_builtins.str] label: A short description of the Image. Labels cannot contain special characters.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode that this Image will be created from.
               
               - - -
               
               > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.
               
               The following arguments apply to uploading an image:
        :param pulumi.Input[_builtins.str] region: The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_regions: A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of customized tags.
        :param pulumi.Input[_builtins.bool] wait_for_replications: Whether to wait for all image replications become `available`. Default to false.
               
               - - -
               
               The following arguments apply to creating an image from an existing Linode Instance:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Image resource.  This can be used to create, modify, and delete Linodes Images.  Linode Images are snapshots of a Linode Instance Disk which can then be used to provision more Linode Instances.  Images can be used across regions.

        For more information, see [Linode's documentation on Images](https://www.linode.com/docs/platform/disk-images/linode-images/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-image).

        ## Example Usage

        Creating an image from an existing Linode Instance and deploying another instance with that image:

        ```python
        import pulumi
        import pulumi_linode as linode

        foo = linode.Instance("foo",
            type="g6-nanode-1",
            region="us-central",
            image="linode/ubuntu22.04",
            root_pass="insecure-p4ssw0rd!!")
        bar = linode.Image("bar",
            label="foo-sda-image",
            description="Image taken from foo",
            disk_id=foo.disks[0].id,
            linode_id=foo.id,
            tags=[
                "image-tag",
                "test",
            ])
        bar_based = linode.Instance("bar_based",
            type=foo.type,
            region="eu-west",
            image=bar.id)
        ```

        Creating and uploading an image from a local file:

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foobar = linode.Image("foobar",
            label="foobar-image",
            description="An image uploaded from Terraform!",
            region="us-southeast",
            tags=[
                "image-tag",
                "test",
            ],
            file_path="path/to/image.img.gz",
            file_hash=std.filemd5(input="path/to/image.img.gz").result)
        ```

        Upload and replicate an image from a local file:

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foobar = linode.Image("foobar",
            label="foobar-image",
            description="An image uploaded from Terraform!",
            region="us-southeast",
            tags=[
                "image-tag",
                "test",
            ],
            file_path="path/to/image.img.gz",
            file_hash=std.filemd5(input="path/to/image.img.gz").result,
            replica_regions=[
                "us-southeast",
                "us-east",
                "eu-west",
            ])
        ```

        ## Import

        Linodes Images can be imported using the Linode Image `id`, e.g.

        ```sh
        $ pulumi import linode:index/image:Image myimage 1234567
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_init: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.int]] = None,
                 file_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ImageTimeoutsArgs', 'ImageTimeoutsArgsDict']]] = None,
                 wait_for_replications: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["cloud_init"] = cloud_init
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_id"] = disk_id
            __props__.__dict__["file_hash"] = file_hash
            __props__.__dict__["file_path"] = file_path
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["linode_id"] = linode_id
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_regions"] = replica_regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["wait_for_replications"] = wait_for_replications
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["deprecated"] = None
            __props__.__dict__["expiry"] = None
            __props__.__dict__["is_public"] = None
            __props__.__dict__["replications"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["total_size"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vendor"] = None
        super(Image, __self__).__init__(
            'linode:index/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cloud_init: Optional[pulumi.Input[_builtins.bool]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            deprecated: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_id: Optional[pulumi.Input[_builtins.int]] = None,
            expiry: Optional[pulumi.Input[_builtins.str]] = None,
            file_hash: Optional[pulumi.Input[_builtins.str]] = None,
            file_path: Optional[pulumi.Input[_builtins.str]] = None,
            is_public: Optional[pulumi.Input[_builtins.bool]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            linode_id: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            replications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageReplicationArgs', 'ImageReplicationArgsDict']]]]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ImageTimeoutsArgs', 'ImageTimeoutsArgsDict']]] = None,
            total_size: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vendor: Optional[pulumi.Input[_builtins.str]] = None,
            wait_for_replications: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: The capabilities of this Image.
        :param pulumi.Input[_builtins.bool] cloud_init: Whether this image supports cloud-init.
        :param pulumi.Input[_builtins.str] created: When this Image was created.
        :param pulumi.Input[_builtins.str] created_by: The name of the User who created this Image.
        :param pulumi.Input[_builtins.bool] deprecated: Whether or not this Image is deprecated. Will only be True for deprecated public Images.
        :param pulumi.Input[_builtins.str] description: A detailed description of this Image.
        :param pulumi.Input[_builtins.int] disk_id: The ID of the Linode Disk that this Image will be created from.
        :param pulumi.Input[_builtins.str] expiry: Only Images created automatically (from a deleted Linode; type=automatic) will expire.
        :param pulumi.Input[_builtins.str] file_hash: The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        :param pulumi.Input[_builtins.str] file_path: The path of the image file to be uploaded.
        :param pulumi.Input[_builtins.bool] is_public: True if the Image is public.
        :param pulumi.Input[_builtins.str] label: A short description of the Image. Labels cannot contain special characters.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode that this Image will be created from.
               
               - - -
               
               > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.
               
               The following arguments apply to uploading an image:
        :param pulumi.Input[_builtins.str] region: The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replica_regions: A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageReplicationArgs', 'ImageReplicationArgsDict']]]] replications: A list of image replications region and corresponding status.
        :param pulumi.Input[_builtins.int] size: The minimum size this Image needs to deploy. Size is in MB.
        :param pulumi.Input[_builtins.str] status: The status of an image replica.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of customized tags.
        :param pulumi.Input[_builtins.int] total_size: The total size of the image in all available regions.
        :param pulumi.Input[_builtins.str] type: How the Image was created. 'Manual' Images can be created at any time. 'Automatic' images are created automatically from a deleted Linode.
        :param pulumi.Input[_builtins.str] vendor: The upstream distribution vendor. Nil for private Images.
        :param pulumi.Input[_builtins.bool] wait_for_replications: Whether to wait for all image replications become `available`. Default to false.
               
               - - -
               
               The following arguments apply to creating an image from an existing Linode Instance:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["cloud_init"] = cloud_init
        __props__.__dict__["created"] = created
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["deprecated"] = deprecated
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["expiry"] = expiry
        __props__.__dict__["file_hash"] = file_hash
        __props__.__dict__["file_path"] = file_path
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["label"] = label
        __props__.__dict__["linode_id"] = linode_id
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_regions"] = replica_regions
        __props__.__dict__["replications"] = replications
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["total_size"] = total_size
        __props__.__dict__["type"] = type
        __props__.__dict__["vendor"] = vendor
        __props__.__dict__["wait_for_replications"] = wait_for_replications
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The capabilities of this Image.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this image supports cloud-init.
        """
        return pulumi.get(self, "cloud_init")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        When this Image was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the User who created this Image.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not this Image is deprecated. Will only be True for deprecated public Images.
        """
        return pulumi.get(self, "deprecated")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A detailed description of this Image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the Linode Disk that this Image will be created from.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> pulumi.Output[_builtins.str]:
        """
        Only Images created automatically (from a deleted Linode; type=automatic) will expire.
        """
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter(name="fileHash")
    def file_hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The MD5 hash of the file to be uploaded. This is used to trigger file updates.
        """
        return pulumi.get(self, "file_hash")

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path of the image file to be uploaded.
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[_builtins.bool]:
        """
        True if the Image is public.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A short description of the Image. Labels cannot contain special characters.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the Linode that this Image will be created from.

        - - -

        > **NOTICE:** Uploading images is currently in beta. Ensure `LINODE_API_VERSION` is set to `v4beta` in order to use this functionality.

        The following arguments apply to uploading an image:
        """
        return pulumi.get(self, "linode_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of the image. See all regions [here](https://techdocs.akamai.com/linode-api/reference/get-regions).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of regions that customer wants to replicate this image in. At least one valid region is required and only core regions allowed. Existing images in the regions not passed will be removed. See Replicate an Image [here](https://techdocs.akamai.com/linode-api/reference/post-replicate-image) for more details.
        """
        return pulumi.get(self, "replica_regions")

    @_builtins.property
    @pulumi.getter
    def replications(self) -> pulumi.Output[Sequence['outputs.ImageReplication']]:
        """
        A list of image replications region and corresponding status.
        """
        return pulumi.get(self, "replications")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum size this Image needs to deploy. Size is in MB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of an image replica.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of customized tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ImageTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="totalSize")
    def total_size(self) -> pulumi.Output[_builtins.int]:
        """
        The total size of the image in all available regions.
        """
        return pulumi.get(self, "total_size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        How the Image was created. 'Manual' Images can be created at any time. 'Automatic' images are created automatically from a deleted Linode.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[_builtins.str]:
        """
        The upstream distribution vendor. Nil for private Images.
        """
        return pulumi.get(self, "vendor")

    @_builtins.property
    @pulumi.getter(name="waitForReplications")
    def wait_for_replications(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to wait for all image replications become `available`. Default to false.

        - - -

        The following arguments apply to creating an image from an existing Linode Instance:
        """
        return pulumi.get(self, "wait_for_replications")

