# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 alerts: Optional[pulumi.Input['InstanceAlertsArgs']] = None,
                 authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.int]] = None,
                 backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_config_label: Optional[pulumi.Input[_builtins.str]] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_helper: Optional[pulumi.Input[_builtins.bool]] = None,
                 placement_group: Optional[pulumi.Input['InstancePlacementGroupArgs']] = None,
                 placement_group_externally_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stackscript_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 stackscript_id: Optional[pulumi.Input[_builtins.int]] = None,
                 swap_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 watchdog_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] region: This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        :param pulumi.Input['InstanceAlertsArgs'] alerts: Configuration options for alert triggers on this Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_keys: A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        :param pulumi.Input[_builtins.int] backup_id: A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        :param pulumi.Input[_builtins.bool] backups_enabled: If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        :param pulumi.Input[_builtins.str] boot_config_label: The Label of the Instance Config that should be used to boot the Linode instance.
        :param pulumi.Input[_builtins.bool] booted: If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]] configs: Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)
               
               * **NOTE: Disk encryption may not currently be available to all users.**
        :param pulumi.Input[_builtins.int] firewall_id: The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        :param pulumi.Input[_builtins.str] group: A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        :param pulumi.Input[_builtins.str] image: An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        :param pulumi.Input[_builtins.str] interface_generation: Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)
               
               * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        :param pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]] interfaces: An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4s: A set of reserved IPv4 addresses to assign to this Linode on creation.
               
               * **NOTE: IP reservation is not currently available to all users.**
        :param pulumi.Input[_builtins.str] label: The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        :param pulumi.Input[_builtins.str] maintenance_policy: The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]] metadatas: Various fields related to the Linode Metadata service.
        :param pulumi.Input[_builtins.str] migration_type: The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        :param pulumi.Input[_builtins.bool] network_helper: Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.
               
               * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        :param pulumi.Input['InstancePlacementGroupArgs'] placement_group: Information about the Placement Group this Linode is assigned to.
        :param pulumi.Input[_builtins.bool] placement_group_externally_managed: If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        :param pulumi.Input[_builtins.bool] private_ip: If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        :param pulumi.Input[_builtins.bool] resize_disk: If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*
               
               * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.
               
               * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        :param pulumi.Input[_builtins.str] root_pass: The password that will be initially assigned to the 'root' user account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_ipv4s: A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.
               
               * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.
               
               * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] stackscript_data: An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        :param pulumi.Input[_builtins.int] stackscript_id: The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        :param pulumi.Input[_builtins.int] swap_size: When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[_builtins.str] type: The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).
               
               - - -
        :param pulumi.Input[_builtins.bool] watchdog_enabled: The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        pulumi.set(__self__, "region", region)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if authorized_keys is not None:
            pulumi.set(__self__, "authorized_keys", authorized_keys)
        if authorized_users is not None:
            pulumi.set(__self__, "authorized_users", authorized_users)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if backups_enabled is not None:
            pulumi.set(__self__, "backups_enabled", backups_enabled)
        if boot_config_label is not None:
            pulumi.set(__self__, "boot_config_label", boot_config_label)
        if booted is not None:
            pulumi.set(__self__, "booted", booted)
        if configs is not None:
            warnings.warn("""The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""", DeprecationWarning)
            pulumi.log.warn("""configs is deprecated: The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""")
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disks is not None:
            warnings.warn("""The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""", DeprecationWarning)
            pulumi.log.warn("""disks is deprecated: The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""")
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if group is not None:
            warnings.warn("""Group label is deprecated. We recommend using tags instead.""", DeprecationWarning)
            pulumi.log.warn("""group is deprecated: Group label is deprecated. We recommend using tags instead.""")
        if group is not None:
            pulumi.set(__self__, "group", group)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interface_generation is not None:
            pulumi.set(__self__, "interface_generation", interface_generation)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if ipv4s is not None:
            pulumi.set(__self__, "ipv4s", ipv4s)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if network_helper is not None:
            pulumi.set(__self__, "network_helper", network_helper)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_group_externally_managed is not None:
            pulumi.set(__self__, "placement_group_externally_managed", placement_group_externally_managed)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if root_pass is not None:
            pulumi.set(__self__, "root_pass", root_pass)
        if shared_ipv4s is not None:
            pulumi.set(__self__, "shared_ipv4s", shared_ipv4s)
        if stackscript_data is not None:
            pulumi.set(__self__, "stackscript_data", stackscript_data)
        if stackscript_id is not None:
            pulumi.set(__self__, "stackscript_id", stackscript_id)
        if swap_size is not None:
            pulumi.set(__self__, "swap_size", swap_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if watchdog_enabled is not None:
            pulumi.set(__self__, "watchdog_enabled", watchdog_enabled)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['InstanceAlertsArgs']]:
        """
        Configuration options for alert triggers on this Linode.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['InstanceAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @_builtins.property
    @pulumi.getter(name="authorizedKeys")
    def authorized_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_keys")

    @authorized_keys.setter
    def authorized_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_keys", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_users")

    @authorized_users.setter
    def authorized_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_users", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="backupsEnabled")
    def backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        """
        return pulumi.get(self, "backups_enabled")

    @backups_enabled.setter
    def backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backups_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bootConfigLabel")
    def boot_config_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Label of the Instance Config that should be used to boot the Linode instance.
        """
        return pulumi.get(self, "boot_config_label")

    @boot_config_label.setter
    def boot_config_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_config_label", value)

    @_builtins.property
    @pulumi.getter
    def booted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        """
        return pulumi.get(self, "booted")

    @booted.setter
    def booted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "booted", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""")
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]]:
        """
        Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)

        * **NOTE: Disk encryption may not currently be available to all users.**
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""")
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Group label is deprecated. We recommend using tags instead.""")
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="interfaceGeneration")
    def interface_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)

        * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        """
        return pulumi.get(self, "interface_generation")

    @interface_generation.setter
    def interface_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_generation", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]]:
        """
        An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter
    def ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of reserved IPv4 addresses to assign to this Linode on creation.

        * **NOTE: IP reservation is not currently available to all users.**
        """
        return pulumi.get(self, "ipv4s")

    @ipv4s.setter
    def ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4s", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]]:
        """
        Various fields related to the Linode Metadata service.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="networkHelper")
    def network_helper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.

        * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        """
        return pulumi.get(self, "network_helper")

    @network_helper.setter
    def network_helper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "network_helper", value)

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input['InstancePlacementGroupArgs']]:
        """
        Information about the Placement Group this Linode is assigned to.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input['InstancePlacementGroupArgs']]):
        pulumi.set(self, "placement_group", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupExternallyManaged")
    def placement_group_externally_managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        """
        return pulumi.get(self, "placement_group_externally_managed")

    @placement_group_externally_managed.setter
    def placement_group_externally_managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "placement_group_externally_managed", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*

        * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.

        * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resize_disk", value)

    @_builtins.property
    @pulumi.getter(name="rootPass")
    def root_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that will be initially assigned to the 'root' user account.
        """
        return pulumi.get(self, "root_pass")

    @root_pass.setter
    def root_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_pass", value)

    @_builtins.property
    @pulumi.getter(name="sharedIpv4s")
    def shared_ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.

        * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.

        * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        """
        return pulumi.get(self, "shared_ipv4s")

    @shared_ipv4s.setter
    def shared_ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shared_ipv4s", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptData")
    def stackscript_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        """
        return pulumi.get(self, "stackscript_data")

    @stackscript_data.setter
    def stackscript_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "stackscript_data", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptId")
    def stackscript_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        """
        return pulumi.get(self, "stackscript_id")

    @stackscript_id.setter
    def stackscript_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stackscript_id", value)

    @_builtins.property
    @pulumi.getter(name="swapSize")
    def swap_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        """
        return pulumi.get(self, "swap_size")

    @swap_size.setter
    def swap_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "swap_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="watchdogEnabled")
    def watchdog_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        return pulumi.get(self, "watchdog_enabled")

    @watchdog_enabled.setter
    def watchdog_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "watchdog_enabled", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['InstanceAlertsArgs']] = None,
                 authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.int]] = None,
                 backups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackupArgs']]]] = None,
                 backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_config_label: Optional[pulumi.Input[_builtins.str]] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 has_user_data: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 lke_cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_helper: Optional[pulumi.Input[_builtins.bool]] = None,
                 placement_group: Optional[pulumi.Input['InstancePlacementGroupArgs']] = None,
                 placement_group_externally_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSpecArgs']]]] = None,
                 stackscript_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 stackscript_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 swap_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 watchdog_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAlertsArgs'] alerts: Configuration options for alert triggers on this Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_keys: A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        :param pulumi.Input[_builtins.int] backup_id: A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBackupArgs']]] backups: Information about this Linode's backups status.
        :param pulumi.Input[_builtins.bool] backups_enabled: If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        :param pulumi.Input[_builtins.str] boot_config_label: The Label of the Instance Config that should be used to boot the Linode instance.
        :param pulumi.Input[_builtins.bool] booted: If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: A list of capabilities of this Linode instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]] configs: Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)
               
               * **NOTE: Disk encryption may not currently be available to all users.**
        :param pulumi.Input[_builtins.int] firewall_id: The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        :param pulumi.Input[_builtins.str] group: A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        :param pulumi.Input[_builtins.bool] has_user_data: Whether this Instance was created with user-data.
        :param pulumi.Input[_builtins.str] host_uuid: The Linode’s host machine, as a UUID.
        :param pulumi.Input[_builtins.str] image: An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        :param pulumi.Input[_builtins.str] interface_generation: Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)
               
               * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        :param pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]] interfaces: An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        :param pulumi.Input[_builtins.str] ip_address: A string containing the Linode's public IP address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4s: A set of reserved IPv4 addresses to assign to this Linode on creation.
               
               * **NOTE: IP reservation is not currently available to all users.**
        :param pulumi.Input[_builtins.str] ipv6: This Linode's IPv6 SLAAC addresses. This address is specific to a Linode, and may not be shared.  The prefix (`/128`) is included in this attribute.
        :param pulumi.Input[_builtins.str] label: The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        :param pulumi.Input[_builtins.int] lke_cluster_id: If applicable, the ID of the LKE cluster this instance is a part of.
        :param pulumi.Input[_builtins.str] maintenance_policy: The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]] metadatas: Various fields related to the Linode Metadata service.
        :param pulumi.Input[_builtins.str] migration_type: The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        :param pulumi.Input[_builtins.bool] network_helper: Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.
               
               * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        :param pulumi.Input['InstancePlacementGroupArgs'] placement_group: Information about the Placement Group this Linode is assigned to.
        :param pulumi.Input[_builtins.bool] placement_group_externally_managed: If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        :param pulumi.Input[_builtins.bool] private_ip: If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        :param pulumi.Input[_builtins.str] private_ip_address: This Linode's Private IPv4 Address, if enabled.  The regional private IP address range, 192.168.128.0/17, is shared by all Linode Instances in a region.
        :param pulumi.Input[_builtins.str] region: This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        :param pulumi.Input[_builtins.bool] resize_disk: If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*
               
               * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.
               
               * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        :param pulumi.Input[_builtins.str] root_pass: The password that will be initially assigned to the 'root' user account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_ipv4s: A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.
               
               * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.
               
               * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSpecArgs']]] specs: Information about the resources available to this Linode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] stackscript_data: An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        :param pulumi.Input[_builtins.int] stackscript_id: The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        :param pulumi.Input[_builtins.str] status: The status of the instance, indicating the current readiness state. (`running`, `offline`, ...)
        :param pulumi.Input[_builtins.int] swap_size: When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[_builtins.str] type: The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).
               
               - - -
        :param pulumi.Input[_builtins.bool] watchdog_enabled: The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if authorized_keys is not None:
            pulumi.set(__self__, "authorized_keys", authorized_keys)
        if authorized_users is not None:
            pulumi.set(__self__, "authorized_users", authorized_users)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if backups_enabled is not None:
            pulumi.set(__self__, "backups_enabled", backups_enabled)
        if boot_config_label is not None:
            pulumi.set(__self__, "boot_config_label", boot_config_label)
        if booted is not None:
            pulumi.set(__self__, "booted", booted)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if configs is not None:
            warnings.warn("""The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""", DeprecationWarning)
            pulumi.log.warn("""configs is deprecated: The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""")
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disks is not None:
            warnings.warn("""The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""", DeprecationWarning)
            pulumi.log.warn("""disks is deprecated: The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""")
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if group is not None:
            warnings.warn("""Group label is deprecated. We recommend using tags instead.""", DeprecationWarning)
            pulumi.log.warn("""group is deprecated: Group label is deprecated. We recommend using tags instead.""")
        if group is not None:
            pulumi.set(__self__, "group", group)
        if has_user_data is not None:
            pulumi.set(__self__, "has_user_data", has_user_data)
        if host_uuid is not None:
            pulumi.set(__self__, "host_uuid", host_uuid)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interface_generation is not None:
            pulumi.set(__self__, "interface_generation", interface_generation)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if ip_address is not None:
            warnings.warn("""The `ip_address` attribute in Instance resource is deprecated. Please consider using the `ipv4` set attribute in the same resource or a `get_instance_networking` data source instead.""", DeprecationWarning)
            pulumi.log.warn("""ip_address is deprecated: The `ip_address` attribute in Instance resource is deprecated. Please consider using the `ipv4` set attribute in the same resource or a `get_instance_networking` data source instead.""")
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv4s is not None:
            pulumi.set(__self__, "ipv4s", ipv4s)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if lke_cluster_id is not None:
            pulumi.set(__self__, "lke_cluster_id", lke_cluster_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if network_helper is not None:
            pulumi.set(__self__, "network_helper", network_helper)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_group_externally_managed is not None:
            pulumi.set(__self__, "placement_group_externally_managed", placement_group_externally_managed)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if root_pass is not None:
            pulumi.set(__self__, "root_pass", root_pass)
        if shared_ipv4s is not None:
            pulumi.set(__self__, "shared_ipv4s", shared_ipv4s)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if stackscript_data is not None:
            pulumi.set(__self__, "stackscript_data", stackscript_data)
        if stackscript_id is not None:
            pulumi.set(__self__, "stackscript_id", stackscript_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if swap_size is not None:
            pulumi.set(__self__, "swap_size", swap_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if watchdog_enabled is not None:
            pulumi.set(__self__, "watchdog_enabled", watchdog_enabled)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['InstanceAlertsArgs']]:
        """
        Configuration options for alert triggers on this Linode.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['InstanceAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @_builtins.property
    @pulumi.getter(name="authorizedKeys")
    def authorized_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_keys")

    @authorized_keys.setter
    def authorized_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_keys", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_users")

    @authorized_users.setter
    def authorized_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_users", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackupArgs']]]]:
        """
        Information about this Linode's backups status.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBackupArgs']]]]):
        pulumi.set(self, "backups", value)

    @_builtins.property
    @pulumi.getter(name="backupsEnabled")
    def backups_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        """
        return pulumi.get(self, "backups_enabled")

    @backups_enabled.setter
    def backups_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backups_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bootConfigLabel")
    def boot_config_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Label of the Instance Config that should be used to boot the Linode instance.
        """
        return pulumi.get(self, "boot_config_label")

    @boot_config_label.setter
    def boot_config_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_config_label", value)

    @_builtins.property
    @pulumi.getter
    def booted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        """
        return pulumi.get(self, "booted")

    @booted.setter
    def booted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "booted", value)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of capabilities of this Linode instance.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""")
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]]:
        """
        Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)

        * **NOTE: Disk encryption may not currently be available to all users.**
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""")
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Group label is deprecated. We recommend using tags instead.""")
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="hasUserData")
    def has_user_data(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Instance was created with user-data.
        """
        return pulumi.get(self, "has_user_data")

    @has_user_data.setter
    def has_user_data(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_user_data", value)

    @_builtins.property
    @pulumi.getter(name="hostUuid")
    def host_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode’s host machine, as a UUID.
        """
        return pulumi.get(self, "host_uuid")

    @host_uuid.setter
    def host_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_uuid", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="interfaceGeneration")
    def interface_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)

        * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        """
        return pulumi.get(self, "interface_generation")

    @interface_generation.setter
    def interface_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_generation", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]]:
        """
        An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    @_utilities.deprecated("""The `ip_address` attribute in Instance resource is deprecated. Please consider using the `ipv4` set attribute in the same resource or a `get_instance_networking` data source instead.""")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string containing the Linode's public IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of reserved IPv4 addresses to assign to this Linode on creation.

        * **NOTE: IP reservation is not currently available to all users.**
        """
        return pulumi.get(self, "ipv4s")

    @ipv4s.setter
    def ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4s", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This Linode's IPv6 SLAAC addresses. This address is specific to a Linode, and may not be shared.  The prefix (`/128`) is included in this attribute.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="lkeClusterId")
    def lke_cluster_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If applicable, the ID of the LKE cluster this instance is a part of.
        """
        return pulumi.get(self, "lke_cluster_id")

    @lke_cluster_id.setter
    def lke_cluster_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lke_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]]:
        """
        Various fields related to the Linode Metadata service.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="networkHelper")
    def network_helper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.

        * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        """
        return pulumi.get(self, "network_helper")

    @network_helper.setter
    def network_helper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "network_helper", value)

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input['InstancePlacementGroupArgs']]:
        """
        Information about the Placement Group this Linode is assigned to.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input['InstancePlacementGroupArgs']]):
        pulumi.set(self, "placement_group", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupExternallyManaged")
    def placement_group_externally_managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        """
        return pulumi.get(self, "placement_group_externally_managed")

    @placement_group_externally_managed.setter
    def placement_group_externally_managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "placement_group_externally_managed", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This Linode's Private IPv4 Address, if enabled.  The regional private IP address range, 192.168.128.0/17, is shared by all Linode Instances in a region.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*

        * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.

        * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resize_disk", value)

    @_builtins.property
    @pulumi.getter(name="rootPass")
    def root_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password that will be initially assigned to the 'root' user account.
        """
        return pulumi.get(self, "root_pass")

    @root_pass.setter
    def root_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_pass", value)

    @_builtins.property
    @pulumi.getter(name="sharedIpv4s")
    def shared_ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.

        * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.

        * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        """
        return pulumi.get(self, "shared_ipv4s")

    @shared_ipv4s.setter
    def shared_ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shared_ipv4s", value)

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSpecArgs']]]]:
        """
        Information about the resources available to this Linode.
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptData")
    def stackscript_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        """
        return pulumi.get(self, "stackscript_data")

    @stackscript_data.setter
    def stackscript_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "stackscript_data", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptId")
    def stackscript_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        """
        return pulumi.get(self, "stackscript_id")

    @stackscript_id.setter
    def stackscript_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stackscript_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the instance, indicating the current readiness state. (`running`, `offline`, ...)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="swapSize")
    def swap_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        """
        return pulumi.get(self, "swap_size")

    @swap_size.setter
    def swap_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "swap_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="watchdogEnabled")
    def watchdog_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        return pulumi.get(self, "watchdog_enabled")

    @watchdog_enabled.setter
    def watchdog_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "watchdog_enabled", value)


@pulumi.type_token("linode:index/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['InstanceAlertsArgs', 'InstanceAlertsArgsDict']]] = None,
                 authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.int]] = None,
                 backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_config_label: Optional[pulumi.Input[_builtins.str]] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigArgs', 'InstanceConfigArgsDict']]]]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiskArgs', 'InstanceDiskArgsDict']]]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceInterfaceArgs', 'InstanceInterfaceArgsDict']]]]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMetadataArgs', 'InstanceMetadataArgsDict']]]]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_helper: Optional[pulumi.Input[_builtins.bool]] = None,
                 placement_group: Optional[pulumi.Input[Union['InstancePlacementGroupArgs', 'InstancePlacementGroupArgsDict']]] = None,
                 placement_group_externally_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stackscript_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 stackscript_id: Optional[pulumi.Input[_builtins.int]] = None,
                 swap_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 watchdog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Linode Instance resource.  This can be used to create, modify, and delete Linodes.
        For more information, see [Getting Started with Linode](https://linode.com/docs/getting-started/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-linode-instance).

        ## Example Usage

        ### Simple Linode Instance

        The following example shows how one might use this resource to configure a Linode instance.

        ```python
        import pulumi
        import pulumi_linode as linode

        web = linode.Instance("web",
            label="simple_instance",
            image="linode/ubuntu22.04",
            region="us-central",
            type="g6-standard-1",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            root_pass="this-is-not-a-safe-password",
            tags=["foo"],
            swap_size=256,
            private_ip=True)
        ```

        ### Linode Instance with Explicit Networking Interfaces

        You can add a VPC or VLAN interface directly to a Linode instance resource.

        ```python
        import pulumi
        import pulumi_linode as linode

        web = linode.Instance("web",
            label="simple_instance",
            image="linode/ubuntu22.04",
            region="us-central",
            type="g6-standard-1",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            root_pass="this-is-not-a-safe-password",
            interfaces=[
                {
                    "purpose": "public",
                },
                {
                    "purpose": "vpc",
                    "subnet_id": 123,
                    "ipv4": {
                        "vpc": "10.0.4.250",
                    },
                },
            ],
            tags=["foo"],
            swap_size=256,
            private_ip=True)
        ```

        ### Linode Instance with Explicit Configs and Disks

        Using explicit Instance Configs and Disks it is possible to create a more elaborate Linode instance. This can be used to provision multiple disks and volumes during Instance creation.

        ```python
        import pulumi
        import pulumi_linode as linode

        me = linode.get_profile()
        web = linode.Instance("web",
            label="complex_instance",
            tags=["foo"],
            region="us-central",
            type="g6-nanode-1",
            private_ip=True)
        web_volume = linode.Volume("web_volume",
            label="web_volume",
            size=20,
            region="us-central")
        boot_disk = linode.InstanceDisk("boot_disk",
            label="boot",
            linode_id=web.id,
            size=3000,
            image="linode/ubuntu22.04",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            authorized_users=[me.username],
            root_pass="terr4form-test")
        boot_config = linode.InstanceConfig("boot_config",
            label="boot_config",
            linode_id=web.id,
            devices=[
                {
                    "deviceName": "sda",
                    "diskId": boot_disk.id,
                },
                {
                    "deviceName": "sdb",
                    "volumeId": web_volume.id,
                },
            ],
            root_device="/dev/sda",
            kernel="linode/latest-64bit",
            booted=True)
        ```

        ### Linode Instance Assigned to a Placement Group

        The following example shows how one might use this resource to configure a Linode instance assigned to a
        Placement Group.

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            region="us-mia",
            type="g6-standard-1",
            placement_group={
                "id": 12345,
            })
        ```

        ## Import

        Linodes Instances can be imported using the Linode `id`, e.g.

        ```sh
        $ pulumi import linode:index/instance:Instance mylinode 1234567
        ```

        When importing an instance, all `disk` and `config` values must be represented.

        Imported disks must include their `label` value.  **Any disk that is not precisely represented may be removed resulting in data loss.**

        Imported configs should include all `devices`, and must include `label`, `kernel`, and the `root_device`.  The instance must include a `boot_config_label` referring to the correct configuration profile.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAlertsArgs', 'InstanceAlertsArgsDict']] alerts: Configuration options for alert triggers on this Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_keys: A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        :param pulumi.Input[_builtins.int] backup_id: A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        :param pulumi.Input[_builtins.bool] backups_enabled: If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        :param pulumi.Input[_builtins.str] boot_config_label: The Label of the Instance Config that should be used to boot the Linode instance.
        :param pulumi.Input[_builtins.bool] booted: If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigArgs', 'InstanceConfigArgsDict']]]] configs: Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)
               
               * **NOTE: Disk encryption may not currently be available to all users.**
        :param pulumi.Input[_builtins.int] firewall_id: The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        :param pulumi.Input[_builtins.str] group: A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        :param pulumi.Input[_builtins.str] image: An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        :param pulumi.Input[_builtins.str] interface_generation: Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)
               
               * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceInterfaceArgs', 'InstanceInterfaceArgsDict']]]] interfaces: An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4s: A set of reserved IPv4 addresses to assign to this Linode on creation.
               
               * **NOTE: IP reservation is not currently available to all users.**
        :param pulumi.Input[_builtins.str] label: The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        :param pulumi.Input[_builtins.str] maintenance_policy: The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMetadataArgs', 'InstanceMetadataArgsDict']]]] metadatas: Various fields related to the Linode Metadata service.
        :param pulumi.Input[_builtins.str] migration_type: The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        :param pulumi.Input[_builtins.bool] network_helper: Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.
               
               * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        :param pulumi.Input[Union['InstancePlacementGroupArgs', 'InstancePlacementGroupArgsDict']] placement_group: Information about the Placement Group this Linode is assigned to.
        :param pulumi.Input[_builtins.bool] placement_group_externally_managed: If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        :param pulumi.Input[_builtins.bool] private_ip: If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        :param pulumi.Input[_builtins.str] region: This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        :param pulumi.Input[_builtins.bool] resize_disk: If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*
               
               * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.
               
               * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        :param pulumi.Input[_builtins.str] root_pass: The password that will be initially assigned to the 'root' user account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_ipv4s: A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.
               
               * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.
               
               * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] stackscript_data: An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        :param pulumi.Input[_builtins.int] stackscript_id: The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        :param pulumi.Input[_builtins.int] swap_size: When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[_builtins.str] type: The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).
               
               - - -
        :param pulumi.Input[_builtins.bool] watchdog_enabled: The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Instance resource.  This can be used to create, modify, and delete Linodes.
        For more information, see [Getting Started with Linode](https://linode.com/docs/getting-started/) and the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-linode-instance).

        ## Example Usage

        ### Simple Linode Instance

        The following example shows how one might use this resource to configure a Linode instance.

        ```python
        import pulumi
        import pulumi_linode as linode

        web = linode.Instance("web",
            label="simple_instance",
            image="linode/ubuntu22.04",
            region="us-central",
            type="g6-standard-1",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            root_pass="this-is-not-a-safe-password",
            tags=["foo"],
            swap_size=256,
            private_ip=True)
        ```

        ### Linode Instance with Explicit Networking Interfaces

        You can add a VPC or VLAN interface directly to a Linode instance resource.

        ```python
        import pulumi
        import pulumi_linode as linode

        web = linode.Instance("web",
            label="simple_instance",
            image="linode/ubuntu22.04",
            region="us-central",
            type="g6-standard-1",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            root_pass="this-is-not-a-safe-password",
            interfaces=[
                {
                    "purpose": "public",
                },
                {
                    "purpose": "vpc",
                    "subnet_id": 123,
                    "ipv4": {
                        "vpc": "10.0.4.250",
                    },
                },
            ],
            tags=["foo"],
            swap_size=256,
            private_ip=True)
        ```

        ### Linode Instance with Explicit Configs and Disks

        Using explicit Instance Configs and Disks it is possible to create a more elaborate Linode instance. This can be used to provision multiple disks and volumes during Instance creation.

        ```python
        import pulumi
        import pulumi_linode as linode

        me = linode.get_profile()
        web = linode.Instance("web",
            label="complex_instance",
            tags=["foo"],
            region="us-central",
            type="g6-nanode-1",
            private_ip=True)
        web_volume = linode.Volume("web_volume",
            label="web_volume",
            size=20,
            region="us-central")
        boot_disk = linode.InstanceDisk("boot_disk",
            label="boot",
            linode_id=web.id,
            size=3000,
            image="linode/ubuntu22.04",
            authorized_keys=["ssh-rsa AAAA...Gw== user@example.local"],
            authorized_users=[me.username],
            root_pass="terr4form-test")
        boot_config = linode.InstanceConfig("boot_config",
            label="boot_config",
            linode_id=web.id,
            devices=[
                {
                    "deviceName": "sda",
                    "diskId": boot_disk.id,
                },
                {
                    "deviceName": "sdb",
                    "volumeId": web_volume.id,
                },
            ],
            root_device="/dev/sda",
            kernel="linode/latest-64bit",
            booted=True)
        ```

        ### Linode Instance Assigned to a Placement Group

        The following example shows how one might use this resource to configure a Linode instance assigned to a
        Placement Group.

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            region="us-mia",
            type="g6-standard-1",
            placement_group={
                "id": 12345,
            })
        ```

        ## Import

        Linodes Instances can be imported using the Linode `id`, e.g.

        ```sh
        $ pulumi import linode:index/instance:Instance mylinode 1234567
        ```

        When importing an instance, all `disk` and `config` values must be represented.

        Imported disks must include their `label` value.  **Any disk that is not precisely represented may be removed resulting in data loss.**

        Imported configs should include all `devices`, and must include `label`, `kernel`, and the `root_device`.  The instance must include a `boot_config_label` referring to the correct configuration profile.

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['InstanceAlertsArgs', 'InstanceAlertsArgsDict']]] = None,
                 authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.int]] = None,
                 backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_config_label: Optional[pulumi.Input[_builtins.str]] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigArgs', 'InstanceConfigArgsDict']]]]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiskArgs', 'InstanceDiskArgsDict']]]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceInterfaceArgs', 'InstanceInterfaceArgsDict']]]]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMetadataArgs', 'InstanceMetadataArgsDict']]]]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_helper: Optional[pulumi.Input[_builtins.bool]] = None,
                 placement_group: Optional[pulumi.Input[Union['InstancePlacementGroupArgs', 'InstancePlacementGroupArgsDict']]] = None,
                 placement_group_externally_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stackscript_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 stackscript_id: Optional[pulumi.Input[_builtins.int]] = None,
                 swap_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 watchdog_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["alerts"] = alerts
            __props__.__dict__["authorized_keys"] = authorized_keys
            __props__.__dict__["authorized_users"] = authorized_users
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["backups_enabled"] = backups_enabled
            __props__.__dict__["boot_config_label"] = boot_config_label
            __props__.__dict__["booted"] = booted
            __props__.__dict__["configs"] = configs
            __props__.__dict__["disk_encryption"] = disk_encryption
            __props__.__dict__["disks"] = disks
            __props__.__dict__["firewall_id"] = firewall_id
            __props__.__dict__["group"] = group
            __props__.__dict__["image"] = image
            __props__.__dict__["interface_generation"] = interface_generation
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["ipv4s"] = ipv4s
            __props__.__dict__["label"] = label
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["migration_type"] = migration_type
            __props__.__dict__["network_helper"] = network_helper
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["placement_group_externally_managed"] = placement_group_externally_managed
            __props__.__dict__["private_ip"] = private_ip
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["resize_disk"] = resize_disk
            __props__.__dict__["root_pass"] = None if root_pass is None else pulumi.Output.secret(root_pass)
            __props__.__dict__["shared_ipv4s"] = shared_ipv4s
            __props__.__dict__["stackscript_data"] = None if stackscript_data is None else pulumi.Output.secret(stackscript_data)
            __props__.__dict__["stackscript_id"] = stackscript_id
            __props__.__dict__["swap_size"] = swap_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["watchdog_enabled"] = watchdog_enabled
            __props__.__dict__["backups"] = None
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["has_user_data"] = None
            __props__.__dict__["host_uuid"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["ipv6"] = None
            __props__.__dict__["lke_cluster_id"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["specs"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["rootPass", "stackscriptData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'linode:index/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Union['InstanceAlertsArgs', 'InstanceAlertsArgsDict']]] = None,
            authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_id: Optional[pulumi.Input[_builtins.int]] = None,
            backups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackupArgs', 'InstanceBackupArgsDict']]]]] = None,
            backups_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            boot_config_label: Optional[pulumi.Input[_builtins.str]] = None,
            booted: Optional[pulumi.Input[_builtins.bool]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigArgs', 'InstanceConfigArgsDict']]]]] = None,
            disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDiskArgs', 'InstanceDiskArgsDict']]]]] = None,
            firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            has_user_data: Optional[pulumi.Input[_builtins.bool]] = None,
            host_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            interface_generation: Optional[pulumi.Input[_builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceInterfaceArgs', 'InstanceInterfaceArgsDict']]]]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            lke_cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
            maintenance_policy: Optional[pulumi.Input[_builtins.str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMetadataArgs', 'InstanceMetadataArgsDict']]]]] = None,
            migration_type: Optional[pulumi.Input[_builtins.str]] = None,
            network_helper: Optional[pulumi.Input[_builtins.bool]] = None,
            placement_group: Optional[pulumi.Input[Union['InstancePlacementGroupArgs', 'InstancePlacementGroupArgsDict']]] = None,
            placement_group_externally_managed: Optional[pulumi.Input[_builtins.bool]] = None,
            private_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
            root_pass: Optional[pulumi.Input[_builtins.str]] = None,
            shared_ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSpecArgs', 'InstanceSpecArgsDict']]]]] = None,
            stackscript_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            stackscript_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            swap_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            watchdog_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAlertsArgs', 'InstanceAlertsArgsDict']] alerts: Configuration options for alert triggers on this Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_keys: A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        :param pulumi.Input[_builtins.int] backup_id: A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBackupArgs', 'InstanceBackupArgsDict']]]] backups: Information about this Linode's backups status.
        :param pulumi.Input[_builtins.bool] backups_enabled: If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        :param pulumi.Input[_builtins.str] boot_config_label: The Label of the Instance Config that should be used to boot the Linode instance.
        :param pulumi.Input[_builtins.bool] booted: If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] capabilities: A list of capabilities of this Linode instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigArgs', 'InstanceConfigArgsDict']]]] configs: Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)
               
               * **NOTE: Disk encryption may not currently be available to all users.**
        :param pulumi.Input[_builtins.int] firewall_id: The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        :param pulumi.Input[_builtins.str] group: A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        :param pulumi.Input[_builtins.bool] has_user_data: Whether this Instance was created with user-data.
        :param pulumi.Input[_builtins.str] host_uuid: The Linode’s host machine, as a UUID.
        :param pulumi.Input[_builtins.str] image: An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        :param pulumi.Input[_builtins.str] interface_generation: Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)
               
               * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceInterfaceArgs', 'InstanceInterfaceArgsDict']]]] interfaces: An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        :param pulumi.Input[_builtins.str] ip_address: A string containing the Linode's public IP address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4s: A set of reserved IPv4 addresses to assign to this Linode on creation.
               
               * **NOTE: IP reservation is not currently available to all users.**
        :param pulumi.Input[_builtins.str] ipv6: This Linode's IPv6 SLAAC addresses. This address is specific to a Linode, and may not be shared.  The prefix (`/128`) is included in this attribute.
        :param pulumi.Input[_builtins.str] label: The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        :param pulumi.Input[_builtins.int] lke_cluster_id: If applicable, the ID of the LKE cluster this instance is a part of.
        :param pulumi.Input[_builtins.str] maintenance_policy: The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMetadataArgs', 'InstanceMetadataArgsDict']]]] metadatas: Various fields related to the Linode Metadata service.
        :param pulumi.Input[_builtins.str] migration_type: The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        :param pulumi.Input[_builtins.bool] network_helper: Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.
               
               * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        :param pulumi.Input[Union['InstancePlacementGroupArgs', 'InstancePlacementGroupArgsDict']] placement_group: Information about the Placement Group this Linode is assigned to.
        :param pulumi.Input[_builtins.bool] placement_group_externally_managed: If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        :param pulumi.Input[_builtins.bool] private_ip: If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        :param pulumi.Input[_builtins.str] private_ip_address: This Linode's Private IPv4 Address, if enabled.  The regional private IP address range, 192.168.128.0/17, is shared by all Linode Instances in a region.
        :param pulumi.Input[_builtins.str] region: This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        :param pulumi.Input[_builtins.bool] resize_disk: If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*
               
               * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.
               
               * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.
               
               * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        :param pulumi.Input[_builtins.str] root_pass: The password that will be initially assigned to the 'root' user account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_ipv4s: A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.
               
               * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.
               
               * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSpecArgs', 'InstanceSpecArgsDict']]]] specs: Information about the resources available to this Linode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] stackscript_data: An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        :param pulumi.Input[_builtins.int] stackscript_id: The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        :param pulumi.Input[_builtins.str] status: The status of the instance, indicating the current readiness state. (`running`, `offline`, ...)
        :param pulumi.Input[_builtins.int] swap_size: When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        :param pulumi.Input[_builtins.str] type: The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).
               
               - - -
        :param pulumi.Input[_builtins.bool] watchdog_enabled: The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["authorized_keys"] = authorized_keys
        __props__.__dict__["authorized_users"] = authorized_users
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["backups"] = backups
        __props__.__dict__["backups_enabled"] = backups_enabled
        __props__.__dict__["boot_config_label"] = boot_config_label
        __props__.__dict__["booted"] = booted
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["configs"] = configs
        __props__.__dict__["disk_encryption"] = disk_encryption
        __props__.__dict__["disks"] = disks
        __props__.__dict__["firewall_id"] = firewall_id
        __props__.__dict__["group"] = group
        __props__.__dict__["has_user_data"] = has_user_data
        __props__.__dict__["host_uuid"] = host_uuid
        __props__.__dict__["image"] = image
        __props__.__dict__["interface_generation"] = interface_generation
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ipv4s"] = ipv4s
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["label"] = label
        __props__.__dict__["lke_cluster_id"] = lke_cluster_id
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["migration_type"] = migration_type
        __props__.__dict__["network_helper"] = network_helper
        __props__.__dict__["placement_group"] = placement_group
        __props__.__dict__["placement_group_externally_managed"] = placement_group_externally_managed
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["region"] = region
        __props__.__dict__["resize_disk"] = resize_disk
        __props__.__dict__["root_pass"] = root_pass
        __props__.__dict__["shared_ipv4s"] = shared_ipv4s
        __props__.__dict__["specs"] = specs
        __props__.__dict__["stackscript_data"] = stackscript_data
        __props__.__dict__["stackscript_id"] = stackscript_id
        __props__.__dict__["status"] = status
        __props__.__dict__["swap_size"] = swap_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["watchdog_enabled"] = watchdog_enabled
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> pulumi.Output['outputs.InstanceAlerts']:
        """
        Configuration options for alert triggers on this Linode.
        """
        return pulumi.get(self, "alerts")

    @_builtins.property
    @pulumi.getter(name="authorizedKeys")
    def authorized_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of SSH public keys to deploy for the root user on the newly created Linode. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_keys")

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Linode usernames. If the usernames have associated SSH keys, the keys will be appended to the `root` user's `~/.ssh/authorized_keys` file automatically. Only accepted if 'image' is provided.
        """
        return pulumi.get(self, "authorized_users")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        A Backup ID from another Linode's available backups. Your User must have read_write access to that Linode, the Backup must have a status of successful, and the Linode must be deployed to the same region as the Backup. See /linode/instances/{linodeId}/backups for a Linode's available backups. This field and the image field are mutually exclusive.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Sequence['outputs.InstanceBackup']]:
        """
        Information about this Linode's backups status.
        """
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="backupsEnabled")
    def backups_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If this field is set to true, the created Linode will automatically be enrolled in the Linode Backup service. This will incur an additional charge. The cost for the Backup service is dependent on the Type of Linode deployed.
        """
        return pulumi.get(self, "backups_enabled")

    @_builtins.property
    @pulumi.getter(name="bootConfigLabel")
    def boot_config_label(self) -> pulumi.Output[_builtins.str]:
        """
        The Label of the Instance Config that should be used to boot the Linode instance.
        """
        return pulumi.get(self, "boot_config_label")

    @_builtins.property
    @pulumi.getter
    def booted(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, then the instance is kept or converted into in a running state. If false, the instance will be shutdown. If unspecified, the Linode's power status will not be managed by the Provider.
        """
        return pulumi.get(self, "booted")

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of capabilities of this Linode instance.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded config is deprecated and scheduled to be removed in the next major version.Please consider migrating it  to InstanceConfig resource.""")
    def configs(self) -> pulumi.Output[Sequence['outputs.InstanceConfig']]:
        """
        Configuration profiles define the VM settings and boot behavior of the Linode Instance.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        The disk encryption policy for this instance. (`enabled`, `disabled`; default `enabled` in supported regions)

        * **NOTE: Disk encryption may not currently be available to all users.**
        """
        return pulumi.get(self, "disk_encryption")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The embedded disk block in Instance resource is deprecated and scheduled to be removed in the next major version. Please consider migrating it to be the InstanceDisk resource.""")
    def disks(self) -> pulumi.Output[Sequence['outputs.InstanceDisk']]:
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the Firewall to attach to the instance upon creation. *Changing `firewall_id` forces the creation of a new Linode Instance.*
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Group label is deprecated. We recommend using tags instead.""")
    def group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A deprecated property denoting a group label for this Linode. We recommend using the `tags` attribute instead.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="hasUserData")
    def has_user_data(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this Instance was created with user-data.
        """
        return pulumi.get(self, "has_user_data")

    @_builtins.property
    @pulumi.getter(name="hostUuid")
    def host_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The Linode’s host machine, as a UUID.
        """
        return pulumi.get(self, "host_uuid")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An Image ID to deploy the Disk from. Official Linode Images start with linode/, while your Images start with private/. See /images for more information on the Images available for you to use.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="interfaceGeneration")
    def interface_generation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the interface type for the Linode. If set to `linode`, Linode interfaces must be created using a separate resource before this Linode can be booted. (`linode`, `legacy_config`; default is determined by the account `interfaces_for_new_linodes` setting)

        * TODO(Linode Interfaces): Link to a usage example using the `linode_instance_interface` resource
        """
        return pulumi.get(self, "interface_generation")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceInterface']]]:
        """
        An array of Network Interfaces for this Linode to be created with. If an explicit config or disk is defined, interfaces must be declared in the config block.
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    @_utilities.deprecated("""The `ip_address` attribute in Instance resource is deprecated. Please consider using the `ipv4` set attribute in the same resource or a `get_instance_networking` data source instead.""")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        A string containing the Linode's public IP address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def ipv4s(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of reserved IPv4 addresses to assign to this Linode on creation.

        * **NOTE: IP reservation is not currently available to all users.**
        """
        return pulumi.get(self, "ipv4s")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[_builtins.str]:
        """
        This Linode's IPv6 SLAAC addresses. This address is specific to a Linode, and may not be shared.  The prefix (`/128`) is included in this attribute.
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The Linode's label is for display purposes only. If no label is provided for a Linode, a default will be assigned.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="lkeClusterId")
    def lke_cluster_id(self) -> pulumi.Output[_builtins.int]:
        """
        If applicable, the ID of the LKE cluster this instance is a part of.
        """
        return pulumi.get(self, "lke_cluster_id")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The maintenance policy of this Linode instance. Examples are `"linode/migrate"` and `"linode/power_off_on"`. Defaults to the default maintenance policy of the account. (**Note: v4beta only.**)
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceMetadata']]]:
        """
        Various fields related to the Linode Metadata service.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of migration to use when updating the type or region of a Linode. (`cold`, `warm`; default `cold`)
        """
        return pulumi.get(self, "migration_type")

    @_builtins.property
    @pulumi.getter(name="networkHelper")
    def network_helper(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables the Network Helper feature. The default value is determined by the network_helper setting in the account settings.

        * `interface` - (Optional) A list of network interfaces to be assigned to the Linode on creation. If an explicit config or disk is defined, interfaces must be declared in the `config` block.
        """
        return pulumi.get(self, "network_helper")

    @_builtins.property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[Optional['outputs.InstancePlacementGroup']]:
        """
        Information about the Placement Group this Linode is assigned to.
        """
        return pulumi.get(self, "placement_group")

    @_builtins.property
    @pulumi.getter(name="placementGroupExternallyManaged")
    def placement_group_externally_managed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, changes to the Linode's assigned Placement Group will be ignored. This is necessary when using this resource in conjunction with the PlacementGroupAssignment resource.
        """
        return pulumi.get(self, "placement_group_externally_managed")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the created Linode will have private networking enabled, allowing use of the 192.168.128.0/17 network within the Linode's region. It can be enabled on an existing Linode but it can't be disabled.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        This Linode's Private IPv4 Address, if enabled.  The regional private IP address range, 192.168.128.0/17, is shared by all Linode Instances in a region.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        This is the location where the Linode is deployed. Examples are `"us-east"`, `"us-west"`, `"ap-south"`, etc. See all regions [here](https://api.linode.com/v4/regions). *Changing `region` will trigger a migration of this Linode. Migration operations are typically long-running operations, so the update timeout should be adjusted accordingly.*.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, changes in Linode type will attempt to upsize or downsize implicitly created disks. This must be false if explicit disks are defined. *This is an irreversible action as Linode disks cannot be automatically downsized.*

        * `alerts.0.cpu` - (Optional) The percentage of CPU usage required to trigger an alert. If the average CPU usage over two hours exceeds this value, we'll send you an alert. If this is set to 0, the alert is disabled.

        * `alerts.0.network_in` - (Optional) The amount of incoming traffic, in Mbit/s, required to trigger an alert. If the average incoming traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.network_out` - (Optional) The amount of outbound traffic, in Mbit/s, required to trigger an alert. If the average outbound traffic over two hours exceeds this value, we'll send you an alert. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.transfer_quota` - (Optional) The percentage of network transfer that may be used before an alert is triggered. When this value is exceeded, we'll alert you. If this is set to 0 (zero), the alert is disabled.

        * `alerts.0.io` - (Optional) The amount of disk IO operation per second required to trigger an alert. If the average disk IO over two hours exceeds this value, we'll send you an alert. If set to 0, this alert is disabled.
        """
        return pulumi.get(self, "resize_disk")

    @_builtins.property
    @pulumi.getter(name="rootPass")
    def root_pass(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password that will be initially assigned to the 'root' user account.
        """
        return pulumi.get(self, "root_pass")

    @_builtins.property
    @pulumi.getter(name="sharedIpv4s")
    def shared_ipv4s(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of IPv4 addresses to be shared with the Instance. These IP addresses can be both private and public, but must be in the same region as the instance.

        * `metadata.0.user_data` - (Optional) The base64-encoded user-defined data exposed to this instance through the Linode Metadata service. Refer to the base64encode(...) function for information on encoding content for this field.

        * `placement_group.0.id` - (Optional) The ID of the Placement Group to assign this Linode to.
        """
        return pulumi.get(self, "shared_ipv4s")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> pulumi.Output[Sequence['outputs.InstanceSpec']]:
        """
        Information about the resources available to this Linode.
        """
        return pulumi.get(self, "specs")

    @_builtins.property
    @pulumi.getter(name="stackscriptData")
    def stackscript_data(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An object containing responses to any User Defined Fields present in the StackScript being deployed to this Linode. Only accepted if 'stackscript_id' is given. The required values depend on the StackScript being deployed.
        """
        return pulumi.get(self, "stackscript_data")

    @_builtins.property
    @pulumi.getter(name="stackscriptId")
    def stackscript_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The StackScript to deploy to the newly created Linode. If provided, 'image' must also be provided, and must be an Image that is compatible with this StackScript.
        """
        return pulumi.get(self, "stackscript_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the instance, indicating the current readiness state. (`running`, `offline`, ...)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="swapSize")
    def swap_size(self) -> pulumi.Output[_builtins.int]:
        """
        When deploying from an Image, this field is optional with a Linode API default of 512mb, otherwise it is ignored. This is used to set the swap disk size for the newly-created Linode.
        """
        return pulumi.get(self, "swap_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Linode type defines the pricing, CPU, disk, and RAM specs of the instance. Examples are `"g6-nanode-1"`, `"g6-standard-2"`, `"g6-highmem-16"`, `"g6-dedicated-16"`, etc. See all types [here](https://api.linode.com/v4/linode/types).

        - - -
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="watchdogEnabled")
    def watchdog_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The watchdog, named Lassie, is a Shutdown Watchdog that monitors your Linode and will reboot it if it powers off unexpectedly. It works by issuing a boot job when your Linode powers off without a shutdown job being responsible. To prevent a loop, Lassie will give up if there have been more than 5 boot jobs issued within 15 minutes.
        """
        return pulumi.get(self, "watchdog_enabled")

