# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceConfigInitArgs', 'InstanceConfig']

@pulumi.input_type
class InstanceConfigInitArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 linode_id: pulumi.Input[_builtins.int],
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]] = None,
                 devices: Optional[pulumi.Input['InstanceConfigDevicesArgs']] = None,
                 helpers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]] = None,
                 kernel: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_level: Optional[pulumi.Input[_builtins.str]] = None,
                 virt_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceConfig resource.
        :param pulumi.Input[_builtins.str] label: The Config’s label for display purposes only.
               
               - - -
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to create this configuration profile under.
        :param pulumi.Input[_builtins.bool] booted: If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        :param pulumi.Input[_builtins.str] comments: Optional field for arbitrary User comments on this Config.
               
               * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.
               
               * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.
               
               * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]] device: Blocks for device disks in a Linode's configuration profile.
        :param pulumi.Input['InstanceConfigDevicesArgs'] devices: A dictionary of device disks to use as a device map in a Linode's configuration profile.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]] helpers: Helpers enabled when booting to this Linode Config.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]] interfaces: An array of Network Interfaces to add to this Linode's Configuration Profile.
        :param pulumi.Input[_builtins.str] kernel: A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        :param pulumi.Input[_builtins.int] memory_limit: The memory limit of the Config. Defaults to the total ram of the Linode.
        :param pulumi.Input[_builtins.str] root_device: The root device to boot. (default `/dev/sda`)
        :param pulumi.Input[_builtins.str] run_level: Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        :param pulumi.Input[_builtins.str] virt_mode: Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "linode_id", linode_id)
        if booted is not None:
            pulumi.set(__self__, "booted", booted)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if devices is not None:
            warnings.warn("""Devices attribute is deprecated in favor of `device`.""", DeprecationWarning)
            pulumi.log.warn("""devices is deprecated: Devices attribute is deprecated in favor of `device`.""")
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if helpers is not None:
            pulumi.set(__self__, "helpers", helpers)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if kernel is not None:
            pulumi.set(__self__, "kernel", kernel)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if root_device is not None:
            pulumi.set(__self__, "root_device", root_device)
        if run_level is not None:
            pulumi.set(__self__, "run_level", run_level)
        if virt_mode is not None:
            pulumi.set(__self__, "virt_mode", virt_mode)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The Config’s label for display purposes only.

        - - -
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the Linode to create this configuration profile under.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def booted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        """
        return pulumi.get(self, "booted")

    @booted.setter
    def booted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "booted", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional field for arbitrary User comments on this Config.

        * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.

        * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.

        * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]]:
        """
        Blocks for device disks in a Linode's configuration profile.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Devices attribute is deprecated in favor of `device`.""")
    def devices(self) -> Optional[pulumi.Input['InstanceConfigDevicesArgs']]:
        """
        A dictionary of device disks to use as a device map in a Linode's configuration profile.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['InstanceConfigDevicesArgs']]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter
    def helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]]:
        """
        Helpers enabled when booting to this Linode Config.
        """
        return pulumi.get(self, "helpers")

    @helpers.setter
    def helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]]):
        pulumi.set(self, "helpers", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]]:
        """
        An array of Network Interfaces to add to this Linode's Configuration Profile.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter
    def kernel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        """
        return pulumi.get(self, "kernel")

    @kernel.setter
    def kernel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kernel", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory limit of the Config. Defaults to the total ram of the Linode.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root device to boot. (default `/dev/sda`)
        """
        return pulumi.get(self, "root_device")

    @root_device.setter
    def root_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_device", value)

    @_builtins.property
    @pulumi.getter(name="runLevel")
    def run_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        """
        return pulumi.get(self, "run_level")

    @run_level.setter
    def run_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_level", value)

    @_builtins.property
    @pulumi.getter(name="virtMode")
    def virt_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        return pulumi.get(self, "virt_mode")

    @virt_mode.setter
    def virt_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virt_mode", value)


@pulumi.input_type
class _InstanceConfigState:
    def __init__(__self__, *,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]] = None,
                 devices: Optional[pulumi.Input['InstanceConfigDevicesArgs']] = None,
                 helpers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]] = None,
                 kernel: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_level: Optional[pulumi.Input[_builtins.str]] = None,
                 virt_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceConfig resources.
        :param pulumi.Input[_builtins.bool] booted: If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        :param pulumi.Input[_builtins.str] comments: Optional field for arbitrary User comments on this Config.
               
               * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.
               
               * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.
               
               * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]] device: Blocks for device disks in a Linode's configuration profile.
        :param pulumi.Input['InstanceConfigDevicesArgs'] devices: A dictionary of device disks to use as a device map in a Linode's configuration profile.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]] helpers: Helpers enabled when booting to this Linode Config.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]] interfaces: An array of Network Interfaces to add to this Linode's Configuration Profile.
        :param pulumi.Input[_builtins.str] kernel: A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        :param pulumi.Input[_builtins.str] label: The Config’s label for display purposes only.
               
               - - -
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to create this configuration profile under.
        :param pulumi.Input[_builtins.int] memory_limit: The memory limit of the Config. Defaults to the total ram of the Linode.
        :param pulumi.Input[_builtins.str] root_device: The root device to boot. (default `/dev/sda`)
        :param pulumi.Input[_builtins.str] run_level: Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        :param pulumi.Input[_builtins.str] virt_mode: Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        if booted is not None:
            pulumi.set(__self__, "booted", booted)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if devices is not None:
            warnings.warn("""Devices attribute is deprecated in favor of `device`.""", DeprecationWarning)
            pulumi.log.warn("""devices is deprecated: Devices attribute is deprecated in favor of `device`.""")
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if helpers is not None:
            pulumi.set(__self__, "helpers", helpers)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if kernel is not None:
            pulumi.set(__self__, "kernel", kernel)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if root_device is not None:
            pulumi.set(__self__, "root_device", root_device)
        if run_level is not None:
            pulumi.set(__self__, "run_level", run_level)
        if virt_mode is not None:
            pulumi.set(__self__, "virt_mode", virt_mode)

    @_builtins.property
    @pulumi.getter
    def booted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        """
        return pulumi.get(self, "booted")

    @booted.setter
    def booted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "booted", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional field for arbitrary User comments on this Config.

        * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.

        * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.

        * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]]:
        """
        Blocks for device disks in a Linode's configuration profile.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigDeviceArgs']]]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Devices attribute is deprecated in favor of `device`.""")
    def devices(self) -> Optional[pulumi.Input['InstanceConfigDevicesArgs']]:
        """
        A dictionary of device disks to use as a device map in a Linode's configuration profile.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['InstanceConfigDevicesArgs']]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter
    def helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]]:
        """
        Helpers enabled when booting to this Linode Config.
        """
        return pulumi.get(self, "helpers")

    @helpers.setter
    def helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigHelperArgs']]]]):
        pulumi.set(self, "helpers", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]]:
        """
        An array of Network Interfaces to add to this Linode's Configuration Profile.
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter
    def kernel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        """
        return pulumi.get(self, "kernel")

    @kernel.setter
    def kernel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kernel", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Config’s label for display purposes only.

        - - -
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode to create this configuration profile under.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory limit of the Config. Defaults to the total ram of the Linode.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root device to boot. (default `/dev/sda`)
        """
        return pulumi.get(self, "root_device")

    @root_device.setter
    def root_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_device", value)

    @_builtins.property
    @pulumi.getter(name="runLevel")
    def run_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        """
        return pulumi.get(self, "run_level")

    @run_level.setter
    def run_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_level", value)

    @_builtins.property
    @pulumi.getter(name="virtMode")
    def virt_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        return pulumi.get(self, "virt_mode")

    @virt_mode.setter
    def virt_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virt_mode", value)


@pulumi.type_token("linode:index/instanceConfig:InstanceConfig")
class InstanceConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigDeviceArgs', 'InstanceConfigDeviceArgsDict']]]]] = None,
                 devices: Optional[pulumi.Input[Union['InstanceConfigDevicesArgs', 'InstanceConfigDevicesArgsDict']]] = None,
                 helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigHelperArgs', 'InstanceConfigHelperArgsDict']]]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigInterfaceArgs', 'InstanceConfigInterfaceArgsDict']]]]] = None,
                 kernel: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_level: Optional[pulumi.Input[_builtins.str]] = None,
                 virt_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Creating a simple bootable Linode Instance Configuration Profile:

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            type="g6-standard-1",
            region="us-southeast")
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs[0].disk,
            image="linode/ubuntu22.04",
            root_pass="myc00lpass!")
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[{
                "deviceName": "sda",
                "diskId": boot.id,
            }],
            booted=True)
        ```

        Creating a complex bootable Instance Configuration Profile with a VPC:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a VPC and a subnet
        foobar = linode.Vpc("foobar",
            label="my-vpc",
            region="us-mia",
            description="test description")
        foobar_vpc_subnet = linode.VpcSubnet("foobar",
            vpc_id=foobar.id,
            label="my-subnet",
            ipv4="10.0.4.0/24")
        my_instance = linode.Instance("my-instance",
            label="my-instance",
            type="g6-standard-1",
            region="us-mia")
        # Create a boot disk
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs.apply(lambda specs: specs[0].disk - 512),
            image="linode/ubuntu22.04",
            root_pass="myc00lpass!ciuw23asxbviwuc")
        # Create a swap disk
        swap = linode.InstanceDisk("swap",
            label="swap",
            linode_id=my_instance.id,
            size=512,
            filesystem="swap")
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[
                {
                    "deviceName": "sda",
                    "diskId": boot.id,
                },
                {
                    "deviceName": "sdb",
                    "diskId": swap.id,
                },
            ],
            helpers=[{
                "updatedb_disabled": False,
            }],
            interfaces=[
                {
                    "purpose": "public",
                },
                {
                    "purpose": "vlan",
                    "label": "my-vlan",
                    "ipam_address": "10.0.0.2/24",
                },
                {
                    "purpose": "vpc",
                    "subnet_id": foobar_vpc_subnet.id,
                    "ipv4": {
                        "vpc": "10.0.4.250",
                    },
                },
            ],
            booted=True)
        # Unsupported provisioner type remote-exec
        ```

        ## Import

        Instance Configs can be imported using the `linode_id` followed by the Instance Config `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/instanceConfig:InstanceConfig my-config 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] booted: If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        :param pulumi.Input[_builtins.str] comments: Optional field for arbitrary User comments on this Config.
               
               * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.
               
               * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.
               
               * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigDeviceArgs', 'InstanceConfigDeviceArgsDict']]]] device: Blocks for device disks in a Linode's configuration profile.
        :param pulumi.Input[Union['InstanceConfigDevicesArgs', 'InstanceConfigDevicesArgsDict']] devices: A dictionary of device disks to use as a device map in a Linode's configuration profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigHelperArgs', 'InstanceConfigHelperArgsDict']]]] helpers: Helpers enabled when booting to this Linode Config.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigInterfaceArgs', 'InstanceConfigInterfaceArgsDict']]]] interfaces: An array of Network Interfaces to add to this Linode's Configuration Profile.
        :param pulumi.Input[_builtins.str] kernel: A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        :param pulumi.Input[_builtins.str] label: The Config’s label for display purposes only.
               
               - - -
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to create this configuration profile under.
        :param pulumi.Input[_builtins.int] memory_limit: The memory limit of the Config. Defaults to the total ram of the Linode.
        :param pulumi.Input[_builtins.str] root_device: The root device to boot. (default `/dev/sda`)
        :param pulumi.Input[_builtins.str] run_level: Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        :param pulumi.Input[_builtins.str] virt_mode: Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceConfigInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Creating a simple bootable Linode Instance Configuration Profile:

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            type="g6-standard-1",
            region="us-southeast")
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs[0].disk,
            image="linode/ubuntu22.04",
            root_pass="myc00lpass!")
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[{
                "deviceName": "sda",
                "diskId": boot.id,
            }],
            booted=True)
        ```

        Creating a complex bootable Instance Configuration Profile with a VPC:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a VPC and a subnet
        foobar = linode.Vpc("foobar",
            label="my-vpc",
            region="us-mia",
            description="test description")
        foobar_vpc_subnet = linode.VpcSubnet("foobar",
            vpc_id=foobar.id,
            label="my-subnet",
            ipv4="10.0.4.0/24")
        my_instance = linode.Instance("my-instance",
            label="my-instance",
            type="g6-standard-1",
            region="us-mia")
        # Create a boot disk
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs.apply(lambda specs: specs[0].disk - 512),
            image="linode/ubuntu22.04",
            root_pass="myc00lpass!ciuw23asxbviwuc")
        # Create a swap disk
        swap = linode.InstanceDisk("swap",
            label="swap",
            linode_id=my_instance.id,
            size=512,
            filesystem="swap")
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[
                {
                    "deviceName": "sda",
                    "diskId": boot.id,
                },
                {
                    "deviceName": "sdb",
                    "diskId": swap.id,
                },
            ],
            helpers=[{
                "updatedb_disabled": False,
            }],
            interfaces=[
                {
                    "purpose": "public",
                },
                {
                    "purpose": "vlan",
                    "label": "my-vlan",
                    "ipam_address": "10.0.0.2/24",
                },
                {
                    "purpose": "vpc",
                    "subnet_id": foobar_vpc_subnet.id,
                    "ipv4": {
                        "vpc": "10.0.4.250",
                    },
                },
            ],
            booted=True)
        # Unsupported provisioner type remote-exec
        ```

        ## Import

        Instance Configs can be imported using the `linode_id` followed by the Instance Config `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/instanceConfig:InstanceConfig my-config 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param InstanceConfigInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceConfigInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 booted: Optional[pulumi.Input[_builtins.bool]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigDeviceArgs', 'InstanceConfigDeviceArgsDict']]]]] = None,
                 devices: Optional[pulumi.Input[Union['InstanceConfigDevicesArgs', 'InstanceConfigDevicesArgsDict']]] = None,
                 helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigHelperArgs', 'InstanceConfigHelperArgsDict']]]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigInterfaceArgs', 'InstanceConfigInterfaceArgsDict']]]]] = None,
                 kernel: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 root_device: Optional[pulumi.Input[_builtins.str]] = None,
                 run_level: Optional[pulumi.Input[_builtins.str]] = None,
                 virt_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceConfigInitArgs.__new__(InstanceConfigInitArgs)

            __props__.__dict__["booted"] = booted
            __props__.__dict__["comments"] = comments
            __props__.__dict__["device"] = device
            __props__.__dict__["devices"] = devices
            __props__.__dict__["helpers"] = helpers
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["kernel"] = kernel
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if linode_id is None and not opts.urn:
                raise TypeError("Missing required property 'linode_id'")
            __props__.__dict__["linode_id"] = linode_id
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["root_device"] = root_device
            __props__.__dict__["run_level"] = run_level
            __props__.__dict__["virt_mode"] = virt_mode
        super(InstanceConfig, __self__).__init__(
            'linode:index/instanceConfig:InstanceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            booted: Optional[pulumi.Input[_builtins.bool]] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigDeviceArgs', 'InstanceConfigDeviceArgsDict']]]]] = None,
            devices: Optional[pulumi.Input[Union['InstanceConfigDevicesArgs', 'InstanceConfigDevicesArgsDict']]] = None,
            helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigHelperArgs', 'InstanceConfigHelperArgsDict']]]]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigInterfaceArgs', 'InstanceConfigInterfaceArgsDict']]]]] = None,
            kernel: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            linode_id: Optional[pulumi.Input[_builtins.int]] = None,
            memory_limit: Optional[pulumi.Input[_builtins.int]] = None,
            root_device: Optional[pulumi.Input[_builtins.str]] = None,
            run_level: Optional[pulumi.Input[_builtins.str]] = None,
            virt_mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceConfig':
        """
        Get an existing InstanceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] booted: If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        :param pulumi.Input[_builtins.str] comments: Optional field for arbitrary User comments on this Config.
               
               * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.
               
               * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.
               
               * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigDeviceArgs', 'InstanceConfigDeviceArgsDict']]]] device: Blocks for device disks in a Linode's configuration profile.
        :param pulumi.Input[Union['InstanceConfigDevicesArgs', 'InstanceConfigDevicesArgsDict']] devices: A dictionary of device disks to use as a device map in a Linode's configuration profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigHelperArgs', 'InstanceConfigHelperArgsDict']]]] helpers: Helpers enabled when booting to this Linode Config.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigInterfaceArgs', 'InstanceConfigInterfaceArgsDict']]]] interfaces: An array of Network Interfaces to add to this Linode's Configuration Profile.
        :param pulumi.Input[_builtins.str] kernel: A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        :param pulumi.Input[_builtins.str] label: The Config’s label for display purposes only.
               
               - - -
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to create this configuration profile under.
        :param pulumi.Input[_builtins.int] memory_limit: The memory limit of the Config. Defaults to the total ram of the Linode.
        :param pulumi.Input[_builtins.str] root_device: The root device to boot. (default `/dev/sda`)
        :param pulumi.Input[_builtins.str] run_level: Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        :param pulumi.Input[_builtins.str] virt_mode: Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceConfigState.__new__(_InstanceConfigState)

        __props__.__dict__["booted"] = booted
        __props__.__dict__["comments"] = comments
        __props__.__dict__["device"] = device
        __props__.__dict__["devices"] = devices
        __props__.__dict__["helpers"] = helpers
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["kernel"] = kernel
        __props__.__dict__["label"] = label
        __props__.__dict__["linode_id"] = linode_id
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["root_device"] = root_device
        __props__.__dict__["run_level"] = run_level
        __props__.__dict__["virt_mode"] = virt_mode
        return InstanceConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def booted(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the Linode will be booted into this config. If another config is booted, the Linode will be rebooted into this config. If false, the Linode will be shutdown only if it is currently booted into this config. If undefined, the config will alter the boot status of the Linode.
        """
        return pulumi.get(self, "booted")

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional field for arbitrary User comments on this Config.

        * `devices` - (Optional) A dictionary of device disks to use as a device map in a Linode’s configuration profile.

        * `helpers` - (Optional) Helpers enabled when booting to this Linode Config.

        * `interface` - (Optional) An array of Network Interfaces to use for this Configuration Profile.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Sequence['outputs.InstanceConfigDevice']]:
        """
        Blocks for device disks in a Linode's configuration profile.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Devices attribute is deprecated in favor of `device`.""")
    def devices(self) -> pulumi.Output['outputs.InstanceConfigDevices']:
        """
        A dictionary of device disks to use as a device map in a Linode's configuration profile.
        """
        return pulumi.get(self, "devices")

    @_builtins.property
    @pulumi.getter
    def helpers(self) -> pulumi.Output[Sequence['outputs.InstanceConfigHelper']]:
        """
        Helpers enabled when booting to this Linode Config.
        """
        return pulumi.get(self, "helpers")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceConfigInterface']]]:
        """
        An array of Network Interfaces to add to this Linode's Configuration Profile.
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter
    def kernel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Kernel ID to boot a Linode with. Default is `linode/latest-64bit`. Examples are `linode/latest-64bit`, `linode/grub2`, `linode/direct-disk`, etc. See all kernels [here](https://api.linode.com/v4/linode/kernels). Note that this is a paginated API endpoint ([docs](https://techdocs.akamai.com/linode-api/reference/get-kernels)).
        """
        return pulumi.get(self, "kernel")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The Config’s label for display purposes only.

        - - -
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Linode to create this configuration profile under.
        """
        return pulumi.get(self, "linode_id")

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The memory limit of the Config. Defaults to the total ram of the Linode.
        """
        return pulumi.get(self, "memory_limit")

    @_builtins.property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The root device to boot. (default `/dev/sda`)
        """
        return pulumi.get(self, "root_device")

    @_builtins.property
    @pulumi.getter(name="runLevel")
    def run_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the state of your Linode after booting. (`default`, `single`, `binbash`)
        """
        return pulumi.get(self, "run_level")

    @_builtins.property
    @pulumi.getter(name="virtMode")
    def virt_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls the virtualization mode. (`paravirt`, `fullvirt`)
        """
        return pulumi.get(self, "virt_mode")

