# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterfaceArgs', 'Interface']

@pulumi.input_type
class InterfaceArgs:
    def __init__(__self__, *,
                 linode_id: pulumi.Input[_builtins.int],
                 default_route: Optional[pulumi.Input['InterfaceDefaultRouteArgs']] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input['InterfacePublicArgs']] = None,
                 vlan: Optional[pulumi.Input['InterfaceVlanArgs']] = None,
                 vpc: Optional[pulumi.Input['InterfaceVpcArgs']] = None):
        """
        The set of arguments for constructing a Interface resource.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to assign this interface to.
        :param pulumi.Input['InterfaceDefaultRouteArgs'] default_route: Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        :param pulumi.Input[_builtins.int] firewall_id: The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        :param pulumi.Input['InterfacePublicArgs'] public: Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input['InterfaceVlanArgs'] vlan: Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input['InterfaceVpcArgs'] vpc: Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        pulumi.set(__self__, "linode_id", linode_id)
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the Linode to assign this interface to.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[pulumi.Input['InterfaceDefaultRouteArgs']]:
        """
        Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: Optional[pulumi.Input['InterfaceDefaultRouteArgs']]):
        pulumi.set(self, "default_route", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input['InterfacePublicArgs']]:
        """
        Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input['InterfacePublicArgs']]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input['InterfaceVlanArgs']]:
        """
        Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input['InterfaceVlanArgs']]):
        pulumi.set(self, "vlan", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['InterfaceVpcArgs']]:
        """
        Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['InterfaceVpcArgs']]):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class _InterfaceState:
    def __init__(__self__, *,
                 default_route: Optional[pulumi.Input['InterfaceDefaultRouteArgs']] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input['InterfacePublicArgs']] = None,
                 vlan: Optional[pulumi.Input['InterfaceVlanArgs']] = None,
                 vpc: Optional[pulumi.Input['InterfaceVpcArgs']] = None):
        """
        Input properties used for looking up and filtering Interface resources.
        :param pulumi.Input['InterfaceDefaultRouteArgs'] default_route: Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        :param pulumi.Input[_builtins.int] firewall_id: The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to assign this interface to.
        :param pulumi.Input['InterfacePublicArgs'] public: Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input['InterfaceVlanArgs'] vlan: Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input['InterfaceVpcArgs'] vpc: Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[pulumi.Input['InterfaceDefaultRouteArgs']]:
        """
        Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: Optional[pulumi.Input['InterfaceDefaultRouteArgs']]):
        pulumi.set(self, "default_route", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode to assign this interface to.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)

    @_builtins.property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input['InterfacePublicArgs']]:
        """
        Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input['InterfacePublicArgs']]):
        pulumi.set(self, "public", value)

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input['InterfaceVlanArgs']]:
        """
        Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input['InterfaceVlanArgs']]):
        pulumi.set(self, "vlan", value)

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input['InterfaceVpcArgs']]:
        """
        Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input['InterfaceVpcArgs']]):
        pulumi.set(self, "vpc", value)


@pulumi.type_token("linode:index/interface:Interface")
class Interface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[Union['InterfaceDefaultRouteArgs', 'InterfaceDefaultRouteArgsDict']]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[Union['InterfacePublicArgs', 'InterfacePublicArgsDict']]] = None,
                 vlan: Optional[pulumi.Input[Union['InterfaceVlanArgs', 'InterfaceVlanArgsDict']]] = None,
                 vpc: Optional[pulumi.Input[Union['InterfaceVpcArgs', 'InterfaceVpcArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Linode Interface resource that can be used to create, modify, and delete network interfaces for Linode instances. Interfaces allow you to configure public, VLAN, and VPC networking for your Linode instances.

        This resource is specifically for Linode interfaces. If you are interested in deploying a Linode instance with a legacy config interface, please refer to the `InstanceConfig` resource documentation for details.

        This resource is designed to work with explicitly defined disk and config resources for the Linode instance. See the Complete Example with Linode section below for details.

        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-linode-instance-interface).

        ## Example Usage

        ### Public Interface Example

        The following example shows how to create a public interface with specific IPv4 and IPv6 configurations.

        ```python
        import pulumi
        import pulumi_linode as linode

        public = linode.Interface("public",
            linode_id=my_instance["id"],
            public={
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                        "primary": True,
                    }],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        ```

        ### IPv6-Only Public Interface Example

        The following example shows how to create an IPv6-only public interface. Note that you must explicitly set `addresses = []` to prevent the automatic creation of an IPv4 address.

        ```python
        import pulumi
        import pulumi_linode as linode

        ipv6_only = linode.Interface("ipv6_only",
            linode_id=my_instance["id"],
            public={
                "ipv4": {
                    "addresses": [],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        ```

        ### VPC Interface Example

        The following example shows how to create a VPC interface with custom IPv4 configuration and 1:1 NAT.

        ```python
        import pulumi
        import pulumi_linode as linode

        vpc = linode.Interface("vpc",
            linode_id=my_instance["id"],
            vpc={
                "subnet_id": 240213,
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                    }],
                    "ranges": [{
                        "range": "/32",
                    }],
                },
            })
        ```

        ### VPC (IPv6) Interface Example

        The following example shows how to create a public VPC interface with a custom IPv6 configuration.

        ```python
        import pulumi
        import pulumi_linode as linode

        vpc = linode.Interface("vpc",
            linode_id=my_instance["id"],
            vpc={
                "subnet_id": 12345,
                "ipv6": {
                    "is_public": True,
                    "slaacs": [{
                        "range": "auto",
                    }],
                    "ranges": [{
                        "range": "auto",
                    }],
                },
            })
        ```

        ### VLAN Interface Example

        The following example shows how to create a VLAN interface.

        ```python
        import pulumi
        import pulumi_linode as linode

        vlan = linode.Interface("vlan",
            linode_id=web["id"],
            vlan={
                "vlan_label": "web-vlan",
                "ipam_address": "192.168.200.5/24",
            })
        ```

        ### Complete Example with Linode

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            region="us-mia",
            type="g6-standard-1",
            interface_generation="linode")
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs[0].disk,
            image="linode/debian12",
            root_pass="this-is-NOT-a-safe-password")
        public = linode.Interface("public",
            linode_id=my_instance.id,
            public={
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                        "primary": True,
                    }],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[{
                "deviceName": "sda",
                "diskId": boot.id,
            }],
            booted=True,
            opts = pulumi.ResourceOptions(depends_on=[public]))
        ```

        ## Notes

        * Each Linode instance can have up to 3 network interfaces.
        * VLAN interfaces cannot be updated after creation and require recreation.
        * VPC subnet IDs cannot be changed after interface creation.
        * Firewall IDs are only supported for public and VPC interfaces, not for VLAN interfaces.
        * When configuring multiple interfaces, use the `default_route` setting to specify which interface should handle default routing.

        ## Import

        Interfaces can be imported using a Linode ID followed by an Interface ID, separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/interface:Interface example 12345,67890
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InterfaceDefaultRouteArgs', 'InterfaceDefaultRouteArgsDict']] default_route: Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        :param pulumi.Input[_builtins.int] firewall_id: The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to assign this interface to.
        :param pulumi.Input[Union['InterfacePublicArgs', 'InterfacePublicArgsDict']] public: Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input[Union['InterfaceVlanArgs', 'InterfaceVlanArgsDict']] vlan: Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input[Union['InterfaceVpcArgs', 'InterfaceVpcArgsDict']] vpc: Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode Interface resource that can be used to create, modify, and delete network interfaces for Linode instances. Interfaces allow you to configure public, VLAN, and VPC networking for your Linode instances.

        This resource is specifically for Linode interfaces. If you are interested in deploying a Linode instance with a legacy config interface, please refer to the `InstanceConfig` resource documentation for details.

        This resource is designed to work with explicitly defined disk and config resources for the Linode instance. See the Complete Example with Linode section below for details.

        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-linode-instance-interface).

        ## Example Usage

        ### Public Interface Example

        The following example shows how to create a public interface with specific IPv4 and IPv6 configurations.

        ```python
        import pulumi
        import pulumi_linode as linode

        public = linode.Interface("public",
            linode_id=my_instance["id"],
            public={
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                        "primary": True,
                    }],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        ```

        ### IPv6-Only Public Interface Example

        The following example shows how to create an IPv6-only public interface. Note that you must explicitly set `addresses = []` to prevent the automatic creation of an IPv4 address.

        ```python
        import pulumi
        import pulumi_linode as linode

        ipv6_only = linode.Interface("ipv6_only",
            linode_id=my_instance["id"],
            public={
                "ipv4": {
                    "addresses": [],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        ```

        ### VPC Interface Example

        The following example shows how to create a VPC interface with custom IPv4 configuration and 1:1 NAT.

        ```python
        import pulumi
        import pulumi_linode as linode

        vpc = linode.Interface("vpc",
            linode_id=my_instance["id"],
            vpc={
                "subnet_id": 240213,
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                    }],
                    "ranges": [{
                        "range": "/32",
                    }],
                },
            })
        ```

        ### VPC (IPv6) Interface Example

        The following example shows how to create a public VPC interface with a custom IPv6 configuration.

        ```python
        import pulumi
        import pulumi_linode as linode

        vpc = linode.Interface("vpc",
            linode_id=my_instance["id"],
            vpc={
                "subnet_id": 12345,
                "ipv6": {
                    "is_public": True,
                    "slaacs": [{
                        "range": "auto",
                    }],
                    "ranges": [{
                        "range": "auto",
                    }],
                },
            })
        ```

        ### VLAN Interface Example

        The following example shows how to create a VLAN interface.

        ```python
        import pulumi
        import pulumi_linode as linode

        vlan = linode.Interface("vlan",
            linode_id=web["id"],
            vlan={
                "vlan_label": "web-vlan",
                "ipam_address": "192.168.200.5/24",
            })
        ```

        ### Complete Example with Linode

        ```python
        import pulumi
        import pulumi_linode as linode

        my_instance = linode.Instance("my-instance",
            label="my-instance",
            region="us-mia",
            type="g6-standard-1",
            interface_generation="linode")
        boot = linode.InstanceDisk("boot",
            label="boot",
            linode_id=my_instance.id,
            size=my_instance.specs[0].disk,
            image="linode/debian12",
            root_pass="this-is-NOT-a-safe-password")
        public = linode.Interface("public",
            linode_id=my_instance.id,
            public={
                "ipv4": {
                    "addresses": [{
                        "address": "auto",
                        "primary": True,
                    }],
                },
                "ipv6": {
                    "ranges": [{
                        "range": "/64",
                    }],
                },
            })
        my_config = linode.InstanceConfig("my-config",
            linode_id=my_instance.id,
            label="my-config",
            devices=[{
                "deviceName": "sda",
                "diskId": boot.id,
            }],
            booted=True,
            opts = pulumi.ResourceOptions(depends_on=[public]))
        ```

        ## Notes

        * Each Linode instance can have up to 3 network interfaces.
        * VLAN interfaces cannot be updated after creation and require recreation.
        * VPC subnet IDs cannot be changed after interface creation.
        * Firewall IDs are only supported for public and VPC interfaces, not for VLAN interfaces.
        * When configuring multiple interfaces, use the `default_route` setting to specify which interface should handle default routing.

        ## Import

        Interfaces can be imported using a Linode ID followed by an Interface ID, separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/interface:Interface example 12345,67890
        ```

        :param str resource_name: The name of the resource.
        :param InterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[Union['InterfaceDefaultRouteArgs', 'InterfaceDefaultRouteArgsDict']]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 public: Optional[pulumi.Input[Union['InterfacePublicArgs', 'InterfacePublicArgsDict']]] = None,
                 vlan: Optional[pulumi.Input[Union['InterfaceVlanArgs', 'InterfaceVlanArgsDict']]] = None,
                 vpc: Optional[pulumi.Input[Union['InterfaceVpcArgs', 'InterfaceVpcArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterfaceArgs.__new__(InterfaceArgs)

            __props__.__dict__["default_route"] = default_route
            __props__.__dict__["firewall_id"] = firewall_id
            if linode_id is None and not opts.urn:
                raise TypeError("Missing required property 'linode_id'")
            __props__.__dict__["linode_id"] = linode_id
            __props__.__dict__["public"] = public
            __props__.__dict__["vlan"] = vlan
            __props__.__dict__["vpc"] = vpc
        super(Interface, __self__).__init__(
            'linode:index/interface:Interface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_route: Optional[pulumi.Input[Union['InterfaceDefaultRouteArgs', 'InterfaceDefaultRouteArgsDict']]] = None,
            firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
            linode_id: Optional[pulumi.Input[_builtins.int]] = None,
            public: Optional[pulumi.Input[Union['InterfacePublicArgs', 'InterfacePublicArgsDict']]] = None,
            vlan: Optional[pulumi.Input[Union['InterfaceVlanArgs', 'InterfaceVlanArgsDict']]] = None,
            vpc: Optional[pulumi.Input[Union['InterfaceVpcArgs', 'InterfaceVpcArgsDict']]] = None) -> 'Interface':
        """
        Get an existing Interface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InterfaceDefaultRouteArgs', 'InterfaceDefaultRouteArgsDict']] default_route: Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        :param pulumi.Input[_builtins.int] firewall_id: The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to assign this interface to.
        :param pulumi.Input[Union['InterfacePublicArgs', 'InterfacePublicArgsDict']] public: Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input[Union['InterfaceVlanArgs', 'InterfaceVlanArgsDict']] vlan: Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        :param pulumi.Input[Union['InterfaceVpcArgs', 'InterfaceVpcArgsDict']] vpc: Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterfaceState.__new__(_InterfaceState)

        __props__.__dict__["default_route"] = default_route
        __props__.__dict__["firewall_id"] = firewall_id
        __props__.__dict__["linode_id"] = linode_id
        __props__.__dict__["public"] = public
        __props__.__dict__["vlan"] = vlan
        __props__.__dict__["vpc"] = vpc
        return Interface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> pulumi.Output['outputs.InterfaceDefaultRoute']:
        """
        Indicates if the interface serves as the default route when multiple interfaces are eligible for this role.
        """
        return pulumi.get(self, "default_route")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of an enabled firewall to secure a VPC or public interface. Not allowed for VLAN interfaces.
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Linode to assign this interface to.
        """
        return pulumi.get(self, "linode_id")

    @_builtins.property
    @pulumi.getter
    def public(self) -> pulumi.Output[Optional['outputs.InterfacePublic']]:
        """
        Nested attributes object for a Linode public interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "public")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[Optional['outputs.InterfaceVlan']]:
        """
        Nested attributes object for a Linode VLAN interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vlan")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[Optional['outputs.InterfaceVpc']]:
        """
        Nested attributes object for a Linode VPC interface. Exactly one of `public`, `vlan`, or `vpc` must be specified.
        """
        return pulumi.get(self, "vpc")

