# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkingIpAssignmentArgs', 'NetworkingIpAssignment']

@pulumi.input_type
class NetworkingIpAssignmentArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 assignments: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkingIpAssignment resource.
        :param pulumi.Input[_builtins.str] region: The region where the IP addresses will be assigned.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]] assignments: A list of IP/Linode assignments to apply.
        """
        pulumi.set(__self__, "region", region)
        if assignments is not None:
            pulumi.set(__self__, "assignments", assignments)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region where the IP addresses will be assigned.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]]:
        """
        A list of IP/Linode assignments to apply.
        """
        return pulumi.get(self, "assignments")

    @assignments.setter
    def assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]]):
        pulumi.set(self, "assignments", value)


@pulumi.input_type
class _NetworkingIpAssignmentState:
    def __init__(__self__, *,
                 assignments: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkingIpAssignment resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]] assignments: A list of IP/Linode assignments to apply.
        :param pulumi.Input[_builtins.str] region: The region where the IP addresses will be assigned.
        """
        if assignments is not None:
            pulumi.set(__self__, "assignments", assignments)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]]:
        """
        A list of IP/Linode assignments to apply.
        """
        return pulumi.get(self, "assignments")

    @assignments.setter
    def assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkingIpAssignmentAssignmentArgs']]]]):
        pulumi.set(self, "assignments", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the IP addresses will be assigned.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("linode:index/networkingIpAssignment:NetworkingIpAssignment")
class NetworkingIpAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkingIpAssignmentAssignmentArgs', 'NetworkingIpAssignmentAssignmentArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the assignment of multiple IPv4 addresses and/or IPv6 ranges to multiple Linodes in a specified region.

        For more information, see the corresponding [API documentation](https://techdocs.akamai.com/linode-api/reference/post-assign-ips).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.NetworkingIpAssignment("foobar",
            region="us-mia",
            assignments=[
                {
                    "address": reserved_ip1["address"],
                    "linode_id": terraform_web1["id"],
                },
                {
                    "address": reserved_ip2["address"],
                    "linode_id": terraform_web2["id"],
                },
            ])
        ```

        ## Import

        Network IP assignments cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkingIpAssignmentAssignmentArgs', 'NetworkingIpAssignmentAssignmentArgsDict']]]] assignments: A list of IP/Linode assignments to apply.
        :param pulumi.Input[_builtins.str] region: The region where the IP addresses will be assigned.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkingIpAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the assignment of multiple IPv4 addresses and/or IPv6 ranges to multiple Linodes in a specified region.

        For more information, see the corresponding [API documentation](https://techdocs.akamai.com/linode-api/reference/post-assign-ips).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.NetworkingIpAssignment("foobar",
            region="us-mia",
            assignments=[
                {
                    "address": reserved_ip1["address"],
                    "linode_id": terraform_web1["id"],
                },
                {
                    "address": reserved_ip2["address"],
                    "linode_id": terraform_web2["id"],
                },
            ])
        ```

        ## Import

        Network IP assignments cannot be imported.

        :param str resource_name: The name of the resource.
        :param NetworkingIpAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkingIpAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkingIpAssignmentAssignmentArgs', 'NetworkingIpAssignmentAssignmentArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkingIpAssignmentArgs.__new__(NetworkingIpAssignmentArgs)

            __props__.__dict__["assignments"] = assignments
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
        super(NetworkingIpAssignment, __self__).__init__(
            'linode:index/networkingIpAssignment:NetworkingIpAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkingIpAssignmentAssignmentArgs', 'NetworkingIpAssignmentAssignmentArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkingIpAssignment':
        """
        Get an existing NetworkingIpAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkingIpAssignmentAssignmentArgs', 'NetworkingIpAssignmentAssignmentArgsDict']]]] assignments: A list of IP/Linode assignments to apply.
        :param pulumi.Input[_builtins.str] region: The region where the IP addresses will be assigned.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkingIpAssignmentState.__new__(_NetworkingIpAssignmentState)

        __props__.__dict__["assignments"] = assignments
        __props__.__dict__["region"] = region
        return NetworkingIpAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def assignments(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkingIpAssignmentAssignment']]]:
        """
        A list of IP/Linode assignments to apply.
        """
        return pulumi.get(self, "assignments")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the IP addresses will be assigned.
        """
        return pulumi.get(self, "region")

