# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SshKeyArgs', 'SshKey']

@pulumi.input_type
class SshKeyArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 ssh_key: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SshKey resource.
        :param pulumi.Input[_builtins.str] label: A label for the SSH Key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A label for the SSH Key.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Input[_builtins.str]:
        """
        The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ssh_key", value)


@pulumi.input_type
class _SshKeyState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SshKey resources.
        :param pulumi.Input[_builtins.str] created: The date this SSH Key was created.
        :param pulumi.Input[_builtins.str] label: A label for the SSH Key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date this SSH Key was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A label for the SSH Key.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_key", value)


@pulumi.type_token("linode:index/sshKey:SshKey")
class SshKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Linode SSH Key resource.  This can be used to create, modify, and delete Linodes SSH Keys.  Managed SSH Keys allow instances to be created with a list of Linode usernames, whose SSH keys will be automatically applied to the root account's `~/.ssh/authorized_keys` file.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ssh-keys).

        **NOTE**: This does not generate a new ssh key, you must have an existing key generated and saved locally.

        ## Example Usage

        The following example shows how one might use this resource to configure a SSH Key for access to a Linode Instance.

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foo = linode.SshKey("foo",
            label="foo",
            ssh_key=std.chomp(input=std.file(input="~/.ssh/id_rsa.pub").result).result)
        foo_instance = linode.Instance("foo",
            image="linode/ubuntu22.04",
            label="foo",
            region="us-east",
            type="g6-nanode-1",
            authorized_keys=[foo.ssh_key],
            root_pass="...")
        ```

        ## Import

        Linodes SSH Keys can be imported using the Linode SSH Key `id`, e.g.

        ```sh
        $ pulumi import linode:index/sshKey:SshKey mysshkey 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] label: A label for the SSH Key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SshKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode SSH Key resource.  This can be used to create, modify, and delete Linodes SSH Keys.  Managed SSH Keys allow instances to be created with a list of Linode usernames, whose SSH keys will be automatically applied to the root account's `~/.ssh/authorized_keys` file.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-ssh-keys).

        **NOTE**: This does not generate a new ssh key, you must have an existing key generated and saved locally.

        ## Example Usage

        The following example shows how one might use this resource to configure a SSH Key for access to a Linode Instance.

        ```python
        import pulumi
        import pulumi_linode as linode
        import pulumi_std as std

        foo = linode.SshKey("foo",
            label="foo",
            ssh_key=std.chomp(input=std.file(input="~/.ssh/id_rsa.pub").result).result)
        foo_instance = linode.Instance("foo",
            image="linode/ubuntu22.04",
            label="foo",
            region="us-east",
            type="g6-nanode-1",
            authorized_keys=[foo.ssh_key],
            root_pass="...")
        ```

        ## Import

        Linodes SSH Keys can be imported using the Linode SSH Key `id`, e.g.

        ```sh
        $ pulumi import linode:index/sshKey:SshKey mysshkey 1234567
        ```

        :param str resource_name: The name of the resource.
        :param SshKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SshKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SshKeyArgs.__new__(SshKeyArgs)

            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if ssh_key is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_key'")
            __props__.__dict__["ssh_key"] = ssh_key
            __props__.__dict__["created"] = None
        super(SshKey, __self__).__init__(
            'linode:index/sshKey:SshKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'SshKey':
        """
        Get an existing SshKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created: The date this SSH Key was created.
        :param pulumi.Input[_builtins.str] label: A label for the SSH Key.
        :param pulumi.Input[_builtins.str] ssh_key: The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SshKeyState.__new__(_SshKeyState)

        __props__.__dict__["created"] = created
        __props__.__dict__["label"] = label
        __props__.__dict__["ssh_key"] = ssh_key
        return SshKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date this SSH Key was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A label for the SSH Key.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[_builtins.str]:
        """
        The public SSH Key, which is used to authenticate to the root user of the Linodes you deploy.
        """
        return pulumi.get(self, "ssh_key")

