# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcSubnetArgs', 'VpcSubnet']

@pulumi.input_type
class VpcSubnetArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.int],
                 ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]] = None):
        """
        The set of arguments for constructing a VpcSubnet resource.
        :param pulumi.Input[_builtins.str] label: The label of the VPC. Only contains ASCII letters, digits and dashes.
        :param pulumi.Input[_builtins.int] vpc_id: The id of the parent VPC for this VPC subnet.
        :param pulumi.Input[_builtins.str] ipv4: The IPv4 range of this subnet in CIDR format.
               
               * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        :param pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]] ipv6s: The IPv6 ranges of this subnet.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6s is not None:
            pulumi.set(__self__, "ipv6s", ipv6s)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The label of the VPC. Only contains ASCII letters, digits and dashes.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.int]:
        """
        The id of the parent VPC for this VPC subnet.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 range of this subnet in CIDR format.

        * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4", value)

    @_builtins.property
    @pulumi.getter
    def ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]]:
        """
        The IPv6 ranges of this subnet.
        """
        return pulumi.get(self, "ipv6s")

    @ipv6s.setter
    def ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]]):
        pulumi.set(self, "ipv6s", value)


@pulumi.input_type
class _VpcSubnetState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 linodes: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetLinodeArgs']]]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering VpcSubnet resources.
        :param pulumi.Input[_builtins.str] created: The date and time when the VPC was created.
        :param pulumi.Input[_builtins.str] ipv4: The IPv4 range of this subnet in CIDR format.
               
               * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        :param pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]] ipv6s: The IPv6 ranges of this subnet.
        :param pulumi.Input[_builtins.str] label: The label of the VPC. Only contains ASCII letters, digits and dashes.
        :param pulumi.Input[Sequence[pulumi.Input['VpcSubnetLinodeArgs']]] linodes: A list of Linode that added to this subnet.
        :param pulumi.Input[_builtins.str] updated: The date and time when the VPC was last updated.
        :param pulumi.Input[_builtins.int] vpc_id: The id of the parent VPC for this VPC subnet.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6s is not None:
            pulumi.set(__self__, "ipv6s", ipv6s)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if linodes is not None:
            pulumi.set(__self__, "linodes", linodes)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the VPC was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 range of this subnet in CIDR format.

        * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4", value)

    @_builtins.property
    @pulumi.getter
    def ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]]:
        """
        The IPv6 ranges of this subnet.
        """
        return pulumi.get(self, "ipv6s")

    @ipv6s.setter
    def ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetIpv6Args']]]]):
        pulumi.set(self, "ipv6s", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label of the VPC. Only contains ASCII letters, digits and dashes.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def linodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetLinodeArgs']]]]:
        """
        A list of Linode that added to this subnet.
        """
        return pulumi.get(self, "linodes")

    @linodes.setter
    def linodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcSubnetLinodeArgs']]]]):
        pulumi.set(self, "linodes", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the VPC was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The id of the parent VPC for this VPC subnet.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("linode:index/vpcSubnet:VpcSubnet")
class VpcSubnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetIpv6Args', 'VpcSubnetIpv6ArgsDict']]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Linode VPC subnet.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-vpc-subnet).

        ## Example Usage

        Create a VPC subnet:

        ```python
        import pulumi
        import pulumi_linode as linode

        test = linode.VpcSubnet("test",
            vpc_id=123,
            label="test-subnet",
            ipv4="10.0.0.0/24")
        ```

        Create a VPC subnet with an implicitly determined IPv6 range:

        ```python
        import pulumi
        import pulumi_linode as linode

        test_vpc = linode.Vpc("test",
            label="test-vpc",
            region="us-mia",
            ipv6s=[{
                "range": "/52",
            }])
        # NOTE: IPv6 VPCs may not currently be available to all users.
        test = linode.VpcSubnet("test",
            vpc_id=test_vpc.id,
            label="test-subnet",
            ipv4="10.0.0.0/24",
            ipv6s=[{
                "range": "auto",
            }])
        ```

        ## IPv6

        > **Limited Availability** IPv6 VPCs may not currently be available to all users.

        The following arguments can be configured for each entry under the `ipv6` field:

        * `range` - (Optional) An existing IPv6 prefix owned by the current account or a forward slash (/) followed by a valid prefix length. If `auto`, a range with the default prefix will be allocated for this VPC.

        * `allocated_range` - (Read-Only) The value of range computed by the API. This is necessary when needing to access the range for an implicit allocation.

        ## Import

        Linode Virtual Private Cloud (VPC) Subnet can be imported using the `vpc_id` followed by the subnet `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/vpcSubnet:VpcSubnet my_subnet_duplicated 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipv4: The IPv4 range of this subnet in CIDR format.
               
               * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetIpv6Args', 'VpcSubnetIpv6ArgsDict']]]] ipv6s: The IPv6 ranges of this subnet.
        :param pulumi.Input[_builtins.str] label: The label of the VPC. Only contains ASCII letters, digits and dashes.
        :param pulumi.Input[_builtins.int] vpc_id: The id of the parent VPC for this VPC subnet.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcSubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linode VPC subnet.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-vpc-subnet).

        ## Example Usage

        Create a VPC subnet:

        ```python
        import pulumi
        import pulumi_linode as linode

        test = linode.VpcSubnet("test",
            vpc_id=123,
            label="test-subnet",
            ipv4="10.0.0.0/24")
        ```

        Create a VPC subnet with an implicitly determined IPv6 range:

        ```python
        import pulumi
        import pulumi_linode as linode

        test_vpc = linode.Vpc("test",
            label="test-vpc",
            region="us-mia",
            ipv6s=[{
                "range": "/52",
            }])
        # NOTE: IPv6 VPCs may not currently be available to all users.
        test = linode.VpcSubnet("test",
            vpc_id=test_vpc.id,
            label="test-subnet",
            ipv4="10.0.0.0/24",
            ipv6s=[{
                "range": "auto",
            }])
        ```

        ## IPv6

        > **Limited Availability** IPv6 VPCs may not currently be available to all users.

        The following arguments can be configured for each entry under the `ipv6` field:

        * `range` - (Optional) An existing IPv6 prefix owned by the current account or a forward slash (/) followed by a valid prefix length. If `auto`, a range with the default prefix will be allocated for this VPC.

        * `allocated_range` - (Read-Only) The value of range computed by the API. This is necessary when needing to access the range for an implicit allocation.

        ## Import

        Linode Virtual Private Cloud (VPC) Subnet can be imported using the `vpc_id` followed by the subnet `id` separated by a comma, e.g.

        ```sh
        $ pulumi import linode:index/vpcSubnet:VpcSubnet my_subnet_duplicated 1234567,7654321
        ```

        :param str resource_name: The name of the resource.
        :param VpcSubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcSubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetIpv6Args', 'VpcSubnetIpv6ArgsDict']]]]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcSubnetArgs.__new__(VpcSubnetArgs)

            __props__.__dict__["ipv4"] = ipv4
            __props__.__dict__["ipv6s"] = ipv6s
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["linodes"] = None
            __props__.__dict__["updated"] = None
        super(VpcSubnet, __self__).__init__(
            'linode:index/vpcSubnet:VpcSubnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetIpv6Args', 'VpcSubnetIpv6ArgsDict']]]]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            linodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetLinodeArgs', 'VpcSubnetLinodeArgsDict']]]]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'VpcSubnet':
        """
        Get an existing VpcSubnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created: The date and time when the VPC was created.
        :param pulumi.Input[_builtins.str] ipv4: The IPv4 range of this subnet in CIDR format.
               
               * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetIpv6Args', 'VpcSubnetIpv6ArgsDict']]]] ipv6s: The IPv6 ranges of this subnet.
        :param pulumi.Input[_builtins.str] label: The label of the VPC. Only contains ASCII letters, digits and dashes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcSubnetLinodeArgs', 'VpcSubnetLinodeArgsDict']]]] linodes: A list of Linode that added to this subnet.
        :param pulumi.Input[_builtins.str] updated: The date and time when the VPC was last updated.
        :param pulumi.Input[_builtins.int] vpc_id: The id of the parent VPC for this VPC subnet.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcSubnetState.__new__(_VpcSubnetState)

        __props__.__dict__["created"] = created
        __props__.__dict__["ipv4"] = ipv4
        __props__.__dict__["ipv6s"] = ipv6s
        __props__.__dict__["label"] = label
        __props__.__dict__["linodes"] = linodes
        __props__.__dict__["updated"] = updated
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcSubnet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the VPC was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 range of this subnet in CIDR format.

        * `ipv6` - (Optional) A list of IPv6 ranges under this VPC subnet. NOTE: IPv6 VPCs may not currently be available to all users.
        """
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6s(self) -> pulumi.Output[Optional[Sequence['outputs.VpcSubnetIpv6']]]:
        """
        The IPv6 ranges of this subnet.
        """
        return pulumi.get(self, "ipv6s")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The label of the VPC. Only contains ASCII letters, digits and dashes.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def linodes(self) -> pulumi.Output[Sequence['outputs.VpcSubnetLinode']]:
        """
        A list of Linode that added to this subnet.
        """
        return pulumi.get(self, "linodes")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the VPC was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.int]:
        """
        The id of the parent VPC for this VPC subnet.
        """
        return pulumi.get(self, "vpc_id")

