#
# This file is part of Invenio.
# Copyright (C) 2016-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Added target uuid."""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = '41961e82e345'
down_revision = '0efa32f39c62'
branch_labels = ()
depends_on = None


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('oarepo_records_references', sa.Column('reference_uuid', sqlalchemy_utils.types.uuid.UUIDType(), nullable=True))
    op.create_index(op.f('ix_oarepo_records_references_reference_uuid'), 'oarepo_records_references', ['reference_uuid'], unique=False)
    op.add_column('oarepo_records_references_version', sa.Column('reference_uuid', sqlalchemy_utils.types.uuid.UUIDType(), autoincrement=False, nullable=True))
    op.create_index(op.f('ix_oarepo_records_references_version_reference_uuid'), 'oarepo_records_references_version', ['reference_uuid'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_oarepo_records_references_version_reference_uuid'), table_name='oarepo_records_references_version')
    op.drop_column('oarepo_records_references_version', 'reference_uuid')
    op.drop_index(op.f('ix_oarepo_records_references_reference_uuid'), table_name='oarepo_records_references')
    op.drop_column('oarepo_records_references', 'reference_uuid')
    # ### end Alembic commands ###
