"""WeatherBench2 datasets validation information

This module has been generated automatically using the function
`pyearthtools.data.download.weatherbench.create_dataset_mapping`.
Do not modify manually.
"""

#: infos for WeatherBench2 datasets, mapping urls to 2 elements tuples made of
#: - a mapping from long variable names to short variable names
#: - valid level values
DATASETS_INFOS = {
    "gs://weatherbench2/datasets/era5/1959-2023_01_10-full_37-1h-0p25deg-chunk-1.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "angle_of_sub_gridscale_orography": "anor",
            "anisotropy_of_sub_gridscale_orography": "isor",
            "boundary_layer_height": "blh",
            "geopotential": "z",
            "geopotential_at_surface": "z",
            "high_vegetation_cover": "cvh",
            "lake_cover": "cl",
            "land_sea_mask": "lsm",
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "low_vegetation_cover": "cvl",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "slope_of_sub_gridscale_orography": "slor",
            "snow_depth": "sd",
            "soil_type": "slt",
            "specific_humidity": "q",
            "standard_deviation_of_filtered_subgrid_orography": "sdfor",
            "standard_deviation_of_orography": "sdor",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation": "tp",
            "type_of_high_vegetation": "tvh",
            "type_of_low_vegetation": "tvl",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
        },
        [
            1,
            2,
            3,
            5,
            7,
            10,
            20,
            30,
            50,
            70,
            100,
            125,
            150,
            175,
            200,
            225,
            250,
            300,
            350,
            400,
            450,
            500,
            550,
            600,
            650,
            700,
            750,
            775,
            800,
            825,
            850,
            875,
            900,
            925,
            950,
            975,
            1000,
        ],
    ),
    "gs://weatherbench2/datasets/era5/1959-2023_01_10-wb13-6h-1440x721_with_derived_variables.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "angle_of_sub_gridscale_orography": "anor",
            "anisotropy_of_sub_gridscale_orography": "isor",
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geopotential_at_surface": "z",
            "geostrophic_wind_speed": None,
            "high_vegetation_cover": "cvh",
            "integrated_vapor_transport": None,
            "lake_cover": "cl",
            "land_sea_mask": "lsm",
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "low_vegetation_cover": "cvl",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "slope_of_sub_gridscale_orography": "slor",
            "snow_depth": "sd",
            "soil_type": "slt",
            "specific_humidity": "q",
            "standard_deviation_of_filtered_subgrid_orography": "sdfor",
            "standard_deviation_of_orography": "sdor",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_6hr": "tp",
            "type_of_high_vegetation": "tvh",
            "type_of_low_vegetation": "tvl",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5/1959-2023_01_10-6h-240x121_equiangular_with_poles_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "angle_of_sub_gridscale_orography": "anor",
            "anisotropy_of_sub_gridscale_orography": "isor",
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geopotential_at_surface": "z",
            "geostrophic_wind_speed": None,
            "high_vegetation_cover": "cvh",
            "integrated_vapor_transport": None,
            "lake_cover": "cl",
            "land_sea_mask": "lsm",
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "low_vegetation_cover": "cvl",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "slope_of_sub_gridscale_orography": "slor",
            "snow_depth": "sd",
            "soil_type": "slt",
            "specific_humidity": "q",
            "standard_deviation_of_filtered_subgrid_orography": "sdfor",
            "standard_deviation_of_orography": "sdor",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_6hr": "tp",
            "type_of_high_vegetation": "tvh",
            "type_of_low_vegetation": "tvl",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5/1959-2023_01_10-6h-64x32_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "angle_of_sub_gridscale_orography": "anor",
            "anisotropy_of_sub_gridscale_orography": "isor",
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geopotential_at_surface": "z",
            "geostrophic_wind_speed": None,
            "high_vegetation_cover": "cvh",
            "integrated_vapor_transport": None,
            "lake_cover": "cl",
            "land_sea_mask": "lsm",
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "low_vegetation_cover": "cvl",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "slope_of_sub_gridscale_orography": "slor",
            "snow_depth": "sd",
            "soil_type": "slt",
            "specific_humidity": "q",
            "standard_deviation_of_filtered_subgrid_orography": "sdfor",
            "standard_deviation_of_orography": "sdor",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_6hr": "tp",
            "type_of_high_vegetation": "tvh",
            "type_of_low_vegetation": "tvl",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2017_6h_1440x721.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2017_6h_512x256_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "toa_incident_solar_radiation": "tisr",
            "toa_incident_solar_radiation_12hr": "tisr",
            "toa_incident_solar_radiation_24hr": "tisr",
            "toa_incident_solar_radiation_6hr": "tisr",
            "total_cloud_cover": "tcc",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2017_6h_240x121_equiangular_with_poles_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2017_6h_64x32_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2019_6h_1440x721.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2019_6h_512x256_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "toa_incident_solar_radiation": "tisr",
            "toa_incident_solar_radiation_12hr": "tisr",
            "toa_incident_solar_radiation_24hr": "tisr",
            "toa_incident_solar_radiation_6hr": "tisr",
            "total_cloud_cover": "tcc",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2019_6h_240x121_equiangular_with_poles_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/era5-hourly-climatology/1990-2019_6h_64x32_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_dewpoint_temperature": "d2m",
            "2m_temperature": "t2m",
            "above_ground": None,
            "ageostrophic_wind_speed": None,
            "boundary_layer_height": "blh",
            "divergence": None,
            "eddy_kinetic_energy": None,
            "geopotential": "z",
            "geostrophic_wind_speed": None,
            "integrated_vapor_transport": None,
            "lapse_rate": None,
            "leaf_area_index_high_vegetation": "lai_hv",
            "leaf_area_index_low_vegetation": "lai_lv",
            "mean_sea_level_pressure": "msl",
            "mean_surface_latent_heat_flux": "mslhf",
            "mean_surface_net_long_wave_radiation_flux": "msnlwrf",
            "mean_surface_net_short_wave_radiation_flux": "msnswrf",
            "mean_surface_sensible_heat_flux": "msshf",
            "mean_top_downward_short_wave_radiation_flux": "mtdwswrf",
            "mean_top_net_long_wave_radiation_flux": "mtnlwrf",
            "mean_top_net_short_wave_radiation_flux": "mtnswrf",
            "mean_vertically_integrated_moisture_divergence": "mvimd",
            "potential_vorticity": "pv",
            "relative_humidity": None,
            "sea_ice_cover": "siconc",
            "sea_surface_temperature": "sst",
            "snow_depth": "sd",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_cloud_cover": "tcc",
            "total_column_vapor": None,
            "total_column_water": "tcw",
            "total_column_water_vapour": "tcwv",
            "total_precipitation_12hr": "tp",
            "total_precipitation_24hr": "tp",
            "total_precipitation_24hr_seeps_dry_fraction": "tp",
            "total_precipitation_24hr_seeps_threshold": "tp",
            "total_precipitation_6hr": "tp",
            "total_precipitation_6hr_seeps_dry_fraction": "tp",
            "total_precipitation_6hr_seeps_threshold": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "volumetric_soil_water_layer_1": "swvl1",
            "volumetric_soil_water_layer_2": "swvl2",
            "volumetric_soil_water_layer_3": "swvl3",
            "volumetric_soil_water_layer_4": "swvl4",
            "vorticity": None,
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres_t0/2016-2022-6h-1440x721.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation_6hr": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres_t0/2016-2022-6h-512x256_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation_6hr": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres_t0/2016-2022-6h-240x121_equiangular_with_poles_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation_6hr": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres_t0/2016-2022-6h-64x32_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation_6hr": "tp",
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres/2016-2022-0012-1440x721.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation": "tp",
            "total_precipitation_24hr": None,
            "total_precipitation_6hr": None,
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres/2016-2022-0012-512x256_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation": "tp",
            "total_precipitation_24hr": None,
            "total_precipitation_6hr": None,
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres/2016-2022-0012-240x121_equiangular_with_poles_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation": "tp",
            "total_precipitation_24hr": None,
            "total_precipitation_6hr": None,
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
    "gs://weatherbench2/datasets/hres/2016-2022-0012-64x32_equiangular_conservative.zarr": (
        {
            "10m_u_component_of_wind": "u10",
            "10m_v_component_of_wind": "v10",
            "10m_wind_speed": None,
            "2m_temperature": "t2m",
            "geopotential": "z",
            "mean_sea_level_pressure": "msl",
            "specific_humidity": "q",
            "surface_pressure": "sp",
            "temperature": "t",
            "total_precipitation": "tp",
            "total_precipitation_24hr": None,
            "total_precipitation_6hr": None,
            "u_component_of_wind": "u",
            "v_component_of_wind": "v",
            "vertical_velocity": "w",
            "wind_speed": None,
        },
        [50, 100, 150, 200, 250, 300, 400, 500, 600, 700, 850, 925, 1000],
    ),
}
