# Copyright Commonwealth of Australia, Bureau of Meteorology 2024.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


"""
Translation and default values for `cds.ERA5`
"""

ERA5_LEVELS = [
    None,
    1,
    2,
    3,
    5,
    7,
    10,
    20,
    30,
    50,
    70,
    100,
    125,
    150,
    175,
    200,
    225,
    250,
    300,
    350,
    400,
    450,
    500,
    550,
    600,
    650,
    700,
    750,
    775,
    800,
    825,
    850,
    875,
    900,
    925,
    950,
    975,
    1000,
]

ERA_PRESSURE_NAME_CHANGE = dict(
    divergence="d",
    fraction_of_cloud_cover="cc",
    geopotential="z",
    ozone_mass_mixing_ratio="o3",
    potential_vorticity="pv",
    relative_humidity="r",
    specific_cloud_ice_water_content="ciwc",
    specific_cloud_liquid_water_content="clwc",
    specific_humidity="q",
    specific_rain_water_content="crwc",
    specific_snow_water_content="cswc",
    temperature="t",
    u_component_of_wind="u",
    v_component_of_wind="v",
    vertical_velocity="w",
    vorticity="vo",
)

ERA_SINGLE_NAME_CHANGE = dict(
    **{
        "100m_u_component_of_wind": "u100",
        "100m_v_component_of_wind": "v100",
        "10m_u_component_of_neutral_wind": "dwi",
        "10m_u_component_of_wind": "u10",
        "10m_v_component_of_neutral_wind": "wind",
        "10m_v_component_of_wind": "v10",
        "10m_wind_gust_since_previous_post_processing": "fg10",
        "2m_dewpoint_temperature": "d2m",
        "2m_temperature": "t2m",
    },
    air_density_over_the_oceans="p140209",
    angle_of_sub_gridscale_orography="anor",
    anisotropy_of_sub_gridscale_orography="isor",
    benjamin_feir_index="bfi",
    boundary_layer_dissipation="bld",
    boundary_layer_height="blh",
    charnock="chnk",
    clear_sky_direct_solar_radiation_at_surface="cdir",
    cloud_base_height="cbh",
    coefficient_of_drag_with_waves="cdww",
    convective_available_potential_energy="cape",
    convective_inhibition="cin",
    convective_precipitation="cp",
    convective_rain_rate="crr",
    convective_snowfall="csf",
    convective_snowfall_rate_water_equivalent="csfr",
    downward_uv_radiation_at_the_surface="uvb",
    duct_base_height="dctb",
    eastward_gravity_wave_surface_stress="lgws",
    eastward_turbulent_surface_stress="ewss",
    evaporation="e",
    forecast_albedo="fal",
    forecast_logarithm_of_surface_roughness_for_heat="flsr",
    forecast_surface_roughness="fsr",
    free_convective_velocity_over_the_oceans="p140208",
    friction_velocity="zust",
    gravity_wave_dissipation="gwd",
    geopotential_at_surface="z_surface",
    high_cloud_cover="hcc",
    high_vegetation_cover="cvh",
    ice_temperature_layer_1="istl1",
    ice_temperature_layer_2="istl2",
    ice_temperature_layer_3="istl3",
    ice_temperature_layer_4="istl4",
    instantaneous_10m_wind_gust="i10fg",
    instantaneous_eastward_turbulent_surface_stress="iews",
    instantaneous_large_scale_surface_precipitation_fraction="ilspf",
    instantaneous_moisture_flux="ie",
    instantaneous_northward_turbulent_surface_stress="inss",
    instantaneous_surface_sensible_heat_flux="ishf",
    k_index="kx",
    lake_bottom_temperature="lblt",
    lake_cover="cl",
    lake_ice_temperature="lict",
    lake_ice_depth="licd",
    lake_mix_layer_depth="lmld",
    lake_mix_layer_temperature="lmlt",
    lake_shape_factor="lshf",
    lake_depth="dl",
    lake_total_layer_temperature="ltlt",
    land_sea_mask="lsm",
    large_scale_precipitation="lsp",
    large_scale_precipitation_fraction="lspf",
    large_scale_snowfall="lsf",
    large_scale_rain_rate="lsrr",
    large_scale_snowfall_rate_water_equivalent="lssfr",
    leaf_area_index_high_vegetation="lai_hv",
    leaf_area_index_low_vegetation="lai_lv",
    low_cloud_cover="lcc",
    low_vegetation_cover="cvl",
    maximum_individual_wave_height="hmax",
    maximum_2m_temperature_since_previous_post_processing="mx2t",
    maximum_total_precipitation_rate_since_previous_post_processing="mxtpr",
    mean_boundary_layer_dissipation="mbld",
    mean_convective_precipitation_rate="mcpr",
    mean_convective_snowfall_rate="mcsr",
    mean_direction_of_total_swell="mdts",
    mean_direction_of_wind_waves="mdww",
    mean_eastward_gravity_wave_surface_stress="megwss",
    mean_eastward_turbulent_surface_stress="metss",
    mean_evaporation_rate="mer",
    mean_gravity_wave_dissipation="mgwd",
    mean_large_scale_precipitation_fraction="mlspf",
    mean_large_scale_precipitation_rate="mlspr",
    mean_large_scale_snowfall_rate="mlssr",
    mean_northward_gravity_wave_surface_stress="mngwss",
    mean_northward_turbulent_surface_stress="mntss",
    mean_period_of_total_swell="mpts",
    mean_period_of_wind_waves="mpww",
    mean_potential_evaporation_rate="mper",
    mean_runoff_rate="mror",
    mean_sea_level_pressure="msl",
    mean_snow_evaporation_rate="mser",
    mean_snowfall_rate="msr",
    mean_snowmelt_rate="msmr",
    mean_square_slope_of_waves="msqs",
    mean_sub_surface_runoff_rate="mssror",
    mean_surface_direct_short_wave_radiation_flux="msdrswrf",
    mean_surface_direct_short_wave_radiation_flux_clear_sky="msdrswrfcs",
    mean_surface_downward_long_wave_radiation_flux="msdwlwrf",
    mean_surface_downward_long_wave_radiation_flux_clear_sky="msdwlwrfcs",
    mean_surface_downward_short_wave_radiation_flux="msdwswrf",
    mean_surface_downward_short_wave_radiation_flux_clear_sky="msdwswrfcs",
    mean_surface_downward_uv_radiation_flux="msdwuvrf",
    mean_surface_latent_heat_flux="mslhf",
    mean_surface_net_long_wave_radiation_flux="msnlwrf",
    mean_surface_net_long_wave_radiation_flux_clear_sky="msnlwrfcs",
    mean_surface_net_short_wave_radiation_flux="msnswrf",
    mean_surface_net_short_wave_radiation_flux_clear_sky="msnswrfcs",
    mean_surface_runoff_rate="msror",
    mean_surface_sensible_heat_flux="msshf",
    mean_top_downward_short_wave_radiation_flux="mtdwswrf",
    mean_top_net_long_wave_radiation_flux="mtnlwrf",
    mean_top_net_long_wave_radiation_flux_clear_sky="mtnlwrfcs",
    mean_top_net_short_wave_radiation_flux="mtnswrf",
    mean_top_net_short_wave_radiation_flux_clear_sky="mtnswrfcs",
    mean_total_precipitation_rate="mtpr",
    mean_vertical_gradient_of_refractivity_inside_trapping_layer="dndza",
    mean_vertically_integrated_moisture_divergence="mvimd",
    mean_wave_direction="mwd",
    mean_wave_direction_of_first_swell_partition="p140122",
    mean_wave_direction_of_second_swell_partition="p140125",
    mean_wave_direction_of_third_swell_partition="p140128",
    mean_wave_period="mwp",
    mean_wave_period_based_on_first_moment="mp1",
    mean_wave_period_based_on_first_moment_for_swell="p1ps",
    mean_wave_period_based_on_first_moment_for_wind_waves="p1ww",
    mean_wave_period_based_on_second_moment_for_swell="p2ps",
    mean_wave_period_based_on_second_moment_for_wind_waves="p2ww",
    mean_wave_period_of_first_swell_partition="p140123",
    mean_wave_period_of_second_swell_partition="p140126",
    mean_wave_period_of_third_swell_partition="p140129",
    mean_zero_crossing_wave_period="mp2",
    medium_cloud_cover="mcc",
    minimum_2m_temperature_since_previous_post_processing="mn2t",
    minimum_total_precipitation_rate_since_previous_post_processing="mntpr",
    minimum_vertical_gradient_of_refractivity_inside_trapping_layer="dndzn",
    model_bathymetry="wmb",
    near_ir_albedo_for_diffuse_radiation="alnid",
    near_ir_albedo_for_direct_radiation="alnip",
    neutral_wind_at_10_m_u_component="u10n",
    neutral_wind_at_10_m_v_component="v10n",
    normalized_energy_flux_into_ocean="phioc",
    normalized_energy_flux_into_waves="phiaw",
    normalized_stress_into_ocean="tauoc",
    northward_gravity_wave_surface_stress="mgws",
    northward_turbulent_surface_stress="nsss",
    peak_wave_period="pp1d",
    period_corresponding_to_maximum_individual_wave_height="tmax",
    potential_evaporation="pev",
    precipitation_type="ptype",
    runoff="ro",
    sea_ice_cover="siconc",
    sea_surface_temperature="sst",
    significant_height_of_combined_wind_waves_and_swell="swh",
    significant_height_of_total_swell="shts",
    significant_height_of_wind_waves="shww",
    significant_wave_height_of_first_swell_partition="p140121",
    significant_wave_height_of_second_swell_partition="p140124",
    significant_wave_height_of_third_swell_partition="p140127",
    skin_reservoir_content="src",
    skin_temperature="skt",
    slope_of_sub_gridscale_orography="slor",
    snow_albedo="asn",
    snow_density="rsn",
    snow_depth="sd",
    snow_evaporation="es",
    snowfall="sf",
    snowmelt="smlt",
    soil_temperature_level_1="stl1",
    soil_temperature_level_2="stl2",
    soil_temperature_level_3="stl3",
    soil_temperature_level_4="stl4",
    soil_type="slt",
    standard_deviation_of_filtered_subgrid_orography="sdfor",
    standard_deviation_of_orography="sdor",
    sub_surface_runoff="ssro",
    surface_latent_heat_flux="slhf",
    surface_thermal_radiation_downwards="strd",
    surface_net_thermal_radiation="str",
    surface_net_thermal_radiation_clear_sky="strc",
    surface_net_solar_radiation="ssr",
    surface_net_solar_radiation_clear_sky="ssrc",
    surface_pressure="sp",
    surface_runoff="sro",
    surface_sensible_heat_flux="sshf",
    surface_solar_radiation_downwards="ssrd",
    surface_solar_radiation_downward_clear_sky="ssrdc",
    surface_thermal_radiation_downward_clear_sky="strdc",
    temperature_of_snow_layer="tsn",
    toa_incident_solar_radiation="tisr",
    top_net_thermal_radiation="ttr",
    top_net_solar_radiation="tsr",
    top_net_solar_radiation_clear_sky="tsrc",
    top_net_thermal_radiation_clear_sky="ttrc",
    total_cloud_cover="tcc",
    total_column_cloud_ice_water="tciw",
    total_column_cloud_liquid_water="tclw",
    total_column_ozone="tco3",
    total_column_rain_water="tcrw",
    total_column_snow_water="tcsw",
    total_column_supercooled_liquid_water="tcslw",
    total_column_water_vapour="tcwv",
    total_column_water="tcw",
    total_precipitation="tp",
    total_sky_direct_solar_radiation_at_surface="fdir",
    total_totals_index="totalx",
    trapping_layer_base_height="tplb",
    trapping_layer_top_height="tplt",
    type_of_high_vegetation="tvh",
    type_of_low_vegetation="tvl",
    u_component_stokes_drift="ust",
    uv_visible_albedo_for_diffuse_radiation="aluvd",
    uv_visible_albedo_for_direct_radiation="aluvp",
    v_component_stokes_drift="vst",
    vertical_integral_of_divergence_of_cloud_frozen_water_flux="p80.162",
    vertical_integral_of_divergence_of_cloud_liquid_water_flux="p79.162",
    vertical_integral_of_divergence_of_geopotential_flux="p85.162",
    vertical_integral_of_divergence_of_kinetic_energy_flux="p82.162",
    vertical_integral_of_divergence_of_mass_flux="p81.162",
    vertical_integral_of_divergence_of_moisture_flux="p84.162",
    vertical_integral_of_divergence_of_ozone_flux="p87.162",
    vertical_integral_of_divergence_of_thermal_energy_flux="p83.162",
    vertical_integral_of_divergence_of_total_energy_flux="p86.162",
    vertical_integral_of_eastward_cloud_frozen_water_flux="p90.162",
    vertical_integral_of_eastward_cloud_liquid_water_flux="p88.162",
    vertical_integral_of_eastward_geopotential_flux="p73.162",
    vertical_integral_of_eastward_heat_flux="p69.162",
    vertical_integral_of_eastward_kinetic_energy_flux="p67.162",
    vertical_integral_of_eastward_mass_flux="p65.162",
    vertical_integral_of_eastward_ozone_flux="p77.162",
    vertical_integral_of_eastward_total_energy_flux="p75.162",
    vertical_integral_of_eastward_water_vapour_flux="p71.162",
    vertical_integral_of_energy_conversion="p64.162",
    vertical_integral_of_kinetic_energy="p59.162",
    vertical_integral_of_mass_of_atmosphere="p53.162",
    vertical_integral_of_mass_tendency="p92.162",
    vertical_integral_of_northward_cloud_frozen_water_flux="p91.162",
    vertical_integral_of_northward_cloud_liquid_water_flux="p89.162",
    vertical_integral_of_northward_geopotential_flux="p74.162",
    vertical_integral_of_northward_heat_flux="p70.162",
    vertical_integral_of_northward_kinetic_energy_flux="p68.162",
    vertical_integral_of_northward_mass_flux="p66.162",
    vertical_integral_of_northward_ozone_flux="p78.162",
    vertical_integral_of_northward_total_energy_flux="p76.162",
    vertical_integral_of_northward_water_vapour_flux="p72.162",
    vertical_integral_of_potential_internal_and_latent_energy="p62.162",
    vertical_integral_of_potential_and_internal_energy="p61.162",
    vertical_integral_of_temperature="p54.162",
    vertical_integral_of_thermal_energy="p60.162",
    vertical_integral_of_total_energy="p63.162",
    vertically_integrated_moisture_divergence="vimd",
    volumetric_soil_water_layer_1="swvl1",
    volumetric_soil_water_layer_2="swvl2",
    volumetric_soil_water_layer_3="swvl3",
    volumetric_soil_water_layer_4="swvl4",
    wave_spectral_directional_width="wdw",
    wave_spectral_directional_width_for_swell="dwps",
    wave_spectral_directional_width_for_wind_waves="dwww",
    wave_spectral_kurtosis="wsk",
    wave_spectral_peakedness="wsp",
    wave_spectral_skewness="wss",
    zero_degree_level="deg0l",
)
