# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import enum
import numpy
import numpy.typing
import typing

@typing.final
class CorrelationSpec:
    ALL: builtins.int = 15
    SQUARED_EXPONENTIAL: builtins.int = 1
    ABSOLUTE_EXPONENTIAL: builtins.int = 2
    MATERN32: builtins.int = 4
    MATERN52: builtins.int = 8

@typing.final
class Egor:
    r"""
    Optimizer constructor
        xspecs (list(XSpec)) where XSpec(xtype=FLOAT|INT|ORD|ENUM, xlimits=[<f(xtype)>] or tags=[strings]):
            Specifications of the nx components of the input x (eg. len(xspecs) == nx)
            Depending on the x type we get the following for xlimits:
            * when FLOAT: xlimits is [float lower_bound, float upper_bound],
            * when INT: xlimits is [int lower_bound, int upper_bound],
            * when ORD: xlimits is [float_1, float_2, ..., float_n],
            * when ENUM: xlimits is just the int size of the enumeration otherwise a list of tags is specified
              (eg xlimits=[3] or tags=["red", "green", "blue"], tags are there for documention purpose but
               tags specific values themselves are not used only indices in the enum are used hence
               we can just specify the size of the enum, xlimits=[3]),

        gp_config (GpConfig):
           GP configuration used by the optimizer, see GpConfig for details.

        n_cstr (int):
            the number of constraints which will be approximated by surrogates (see `fun` argument)

        cstr_tol (list(n_cstr + n_fcstr,)):
            List of tolerances for constraints to be satisfied (cstr < tol),
            list size should be equal to n_cstr + n_fctrs where n_cstr is the `n_cstr` argument
            and `n_fcstr` the number of constraints passed as functions.
            When None, tolerances default to DEFAULT_CSTR_TOL=1e-4.

        n_start (int > 0):
            Number of runs of infill strategy optimizations (best result taken)

        n_doe (int >= 0):
            Number of samples of initial LHS sampling (used when DOE not provided by the user).
            When 0 a number of points is computed automatically regarding the number of input variables
            of the function under optimization.

        doe (array[ns, nt]):
            Initial DOE containing ns samples:
                either nt = nx then only x are specified and ns evals are done to get y doe values,
                or nt = nx + ny then x = doe[:, :nx] and y = doe[:, nx:] are specified

        infill_strategy (InfillStrategy enum):
            Infill criteria to decide best next promising point.
            Can be either InfillStrategy.EI, InfillStrategy.WB2, InfillStrategy.WB2S orInfillStrategy.LOG_EI

        infill_optimizer (InfillOptimizer enum):
            Internal optimizer used to optimize infill criteria.
            Can be either InfillOptimizer.COBYLA or InfillOptimizer.SLSQP

        cstr_infill (bool):
            Activate constrained infill criterion where the product of probability of feasibility of constraints
            used as a factor of the infill criterion specified via infill_strategy

        cstr_strategy (ConstraintStrategy enum):
            Constraint management either use the mean value or upper bound
            Can be either ConstraintStrategy.MeanValue or ConstraintStrategy.UpperTrustedBound.

        q_infill_strategy (QInfillStrategy enum):
            Parallel infill criteria (aka qEI) to get virtual next promising points in order to allow
            q parallel evaluations of the function under optimization (only used when q_points > 1)
            Can be either QInfillStrategy.KB (Kriging Believer),
            QInfillStrategy.KBLB (KB Lower Bound), QInfillStrategy.KBUB (KB Upper Bound),
            QInfillStrategy.CLMIN (Constant Liar Minimum)

        q_points (int > 0):
            Number of points to be evaluated to allow parallel evaluation of the function under optimization.

        q_optmod (int >= 1):
            Number of iterations between two surrogate models true training (hypermarameters optimization)
            otherwise previous hyperparameters are re-used only when computing q_points to be evaluated in parallel.
            The default value is 1 meaning surrogates are properly trained for each q points determination.
            The value is used as a modulo of iteration number * q_points to trigger true training.
            This is used to decrease the number of training at the expense of surrogate accuracy.


        trego (bool):
            When true, TREGO algorithm is used, otherwise classic EGO algorithm is used.

        coego_n_coop (int >= 0):
            Number of cooperative components groups which will be used by the CoEGO algorithm.
            Better to have n_coop a divider of nx or if not with a remainder as large as possible.
            The CoEGO algorithm is used to tackle high-dimensional problems turning it in a set of
            partial optimizations using only nx / n_coop components at a time.
            The default value is 0 meaning that the CoEGO algorithm is not used.

        target (float):
            Known optimum used as stopping criterion.

        outdir (String):
            Directory to write optimization history and used as search path for warm start doe

        warm_start (bool):
            Start by loading initial doe from <outdir> directory

        hot_start (int >= 0 or None):
            When hot_start>=0 saves optimizer state at each iteration and starts from a previous checkpoint
            if any for the given hot_start number of iterations beyond the max_iters nb of iterations.
            In an unstable environment were there can be crashes it allows to restart the optimization
            from the last iteration till stopping criterion is reached. Just use hot_start=0 in this case.
            When specifying an extended nb of iterations (hot_start > 0) it can allow to continue till max_iters +
            hot_start nb of iters is reached (provided the stopping criterion is max_iters)
            Checkpoint information is stored in .checkpoint/egor.arg binary file.

        seed (int >= 0):
            Random generator seed to allow computation reproducibility.
    """
    def __new__(
        cls,
        xspecs: typing.Any,
        gp_config: GpConfig = ...,
        n_cstr: builtins.int = 0,
        cstr_tol: typing.Optional[typing.Sequence[builtins.float]] = None,
        n_start: builtins.int = 20,
        n_doe: builtins.int = 0,
        doe: typing.Optional[numpy.typing.NDArray[numpy.float64]] = None,
        infill_strategy: InfillStrategy = InfillStrategy.WB2,
        cstr_infill: builtins.bool = False,
        cstr_strategy: ConstraintStrategy = ConstraintStrategy.MC,
        q_points: builtins.int = 1,
        q_infill_strategy: QInfillStrategy = QInfillStrategy.KB,
        infill_optimizer: InfillOptimizer = InfillOptimizer.COBYLA,
        trego: builtins.bool = False,
        coego_n_coop: builtins.int = 0,
        q_optmod: builtins.int = 1,
        target: builtins.float = -inf,
        outdir: typing.Optional[builtins.str] = None,
        warm_start: builtins.bool = False,
        hot_start: typing.Optional[builtins.int] = None,
        seed: typing.Optional[builtins.int] = None,
    ) -> Egor: ...
    def minimize(
        self,
        fun: typing.Any,
        fcstrs: typing.Sequence[typing.Any] = [],
        max_iters: builtins.int = 20,
        run_info: typing.Optional[typing.Any] = None,
    ) -> OptimResult:
        r"""
        ```ignore
        This function finds the minimum of a given function "fun"

        Parameters
            fun: (array[n, nx] -> array[n, ny])
                the function to be minimized
                fun(x) = [obj(x), cstr_1(x), ... cstr_k(x)] where
                   obj is the objective function [n, nx] -> [n, 1]
                   cstr_i is the ith constraint function [n, nx] -> [n, 1]
                   an k the number of constraints (n_cstr)
                   hence ny = 1 (obj) + k (cstrs)
                cstr functions are expected be negative (<=0) at the optimum.
                This constraints will be approximated using surrogates, so
                if constraints are cheap to evaluate better to pass them through run(fcstrs=[...])

            max_iters:
                the iteration budget, number of fun calls is "n_doe + q_points * max_iters".

            fcstrs:
                list of constraints functions defined as g(x, return_grad): (ndarray[nx], bool) -> float or ndarray[nx,]
                If the given "return_grad" boolean is "False" the function has to return the constraint float value
                to be made negative by the optimizer (which drives the input array "x").
                Otherwise the function has to return the gradient (ndarray[nx,]) of the constraint function
                wrt the "nx" components of "x".

        Returns
            optimization result
                x_opt (array[1, nx]): x value where fun is at its minimum subject to constraints
                y_opt (array[1, nx]): fun(x_opt)
        """
    def suggest(
        self,
        x_doe: numpy.typing.NDArray[numpy.float64],
        y_doe: numpy.typing.NDArray[numpy.float64],
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        This function gives the next best location where to evaluate the function
        under optimization wrt to previous evaluations.
        The function returns several point when multi point qEI strategy is used.

        Parameters
            x_doe (array[ns, nx]): ns samples where function has been evaluated
            y_doe (array[ns, 1 + n_cstr]): ns values of objecctive and constraints

        Returns
            (array[1, nx]): suggested location where to evaluate objective and constraints
        """
    def get_result_index(
        self, y_doe: numpy.typing.NDArray[numpy.float64]
    ) -> builtins.int:
        r"""
        This function gives the best evaluation index given the outputs
        of the function (objective wrt constraints) under minimization.
        Caveat: This function does not take into account function constraints values

        Parameters
            y_doe (array[ns, 1 + n_cstr]): ns values of objective and constraints

        Returns
            index in y_doe of the best evaluation
        """
    def get_result(
        self,
        x_doe: numpy.typing.NDArray[numpy.float64],
        y_doe: numpy.typing.NDArray[numpy.float64],
    ) -> OptimResult:
        r"""
        This function gives the best result given inputs and outputs
        of the function (objective wrt constraints) under minimization.
        Caveat: This function does not take into account function constraints values

        Parameters
            x_doe (array[ns, nx]): ns samples where function has been evaluated
            y_doe (array[ns, 1 + n_cstr]): ns values of objective and constraints

        Returns
            result
                x_opt (array[1, nx]): x value where fun is at its minimum subject to constraints
                y_opt (array[1, nx]): fun(x_opt)
        """

@typing.final
class ExpectedOptimum:
    @property
    def val(self) -> builtins.float: ...
    @property
    def tol(self) -> builtins.float: ...

@typing.final
class GpConfig:
    r"""
    GP configuration used by `Egor` and `GpMix`
    """
    @property
    def regr_spec(self) -> builtins.int:
        r"""
        (RegressionSpec flags, an int in [1, 7])
          Specification of regression models used in mixture.
          Can be RegressionSpec.CONSTANT (1), RegressionSpec.LINEAR (2), RegressionSpec.QUADRATIC (4) or
          any bit-wise union of these values (e.g. RegressionSpec.CONSTANT | RegressionSpec.LINEAR)
        """
    @regr_spec.setter
    def regr_spec(self, value: builtins.int) -> None:
        r"""
        (RegressionSpec flags, an int in [1, 7])
          Specification of regression models used in mixture.
          Can be RegressionSpec.CONSTANT (1), RegressionSpec.LINEAR (2), RegressionSpec.QUADRATIC (4) or
          any bit-wise union of these values (e.g. RegressionSpec.CONSTANT | RegressionSpec.LINEAR)
        """
    @property
    def corr_spec(self) -> builtins.int:
        r"""
        (CorrelationSpec flags, an int in [1, 15])
          Specification of correlation models used in mixture.
          Can be CorrelationSpec.SQUARED_EXPONENTIAL (1), CorrelationSpec.ABSOLUTE_EXPONENTIAL (2),
          CorrelationSpec.MATERN32 (4), CorrelationSpec.MATERN52 (8) or
          any bit-wise union of these values (e.g. CorrelationSpec.MATERN32 | CorrelationSpec.MATERN52)
        """
    @corr_spec.setter
    def corr_spec(self, value: builtins.int) -> None:
        r"""
        (CorrelationSpec flags, an int in [1, 15])
          Specification of correlation models used in mixture.
          Can be CorrelationSpec.SQUARED_EXPONENTIAL (1), CorrelationSpec.ABSOLUTE_EXPONENTIAL (2),
          CorrelationSpec.MATERN32 (4), CorrelationSpec.MATERN52 (8) or
          any bit-wise union of these values (e.g. CorrelationSpec.MATERN32 | CorrelationSpec.MATERN52)
        """
    @property
    def kpls_dim(self) -> typing.Optional[builtins.int]:
        r"""
        (0 < int < nx where nx is the dimension of inputs x)
          Number of components to be used when PLS projection is used (a.k.a KPLS method).
          This is used to address high-dimensional problems typically when nx > 9.
        """
    @kpls_dim.setter
    def kpls_dim(self, value: typing.Optional[builtins.int]) -> None:
        r"""
        (0 < int < nx where nx is the dimension of inputs x)
          Number of components to be used when PLS projection is used (a.k.a KPLS method).
          This is used to address high-dimensional problems typically when nx > 9.
        """
    @property
    def n_clusters(self) -> builtins.int:
        r"""
        (int)
          Number of clusters used by the mixture of surrogate experts (default is 1).
          When set to 0, the number of cluster is determined automatically and refreshed every
          10-points addition (should say 'tentative addition' because addition may fail for some points
          but it is counted anyway).
          When set to negative number -n, the number of clusters is determined automatically in [1, n]
          this is used to limit the number of trials hence the execution time.
        """
    @n_clusters.setter
    def n_clusters(self, value: builtins.int) -> None:
        r"""
        (int)
          Number of clusters used by the mixture of surrogate experts (default is 1).
          When set to 0, the number of cluster is determined automatically and refreshed every
          10-points addition (should say 'tentative addition' because addition may fail for some points
          but it is counted anyway).
          When set to negative number -n, the number of clusters is determined automatically in [1, n]
          this is used to limit the number of trials hence the execution time.
        """
    @property
    def recombination(self) -> Recombination:
        r"""
        (Recombination.Smooth or Recombination.Hard (default))
          Specify how the various experts predictions are recombined
          * Smooth: prediction is a combination of experts prediction wrt their responsabilities,
          the heaviside factor which controls steepness of the change between experts regions is optimized
          to get best mixture quality.
          * Hard: prediction is taken from the expert with highest responsability
          resulting in a model with discontinuities.
        """
    @recombination.setter
    def recombination(self, value: Recombination) -> None:
        r"""
        (Recombination.Smooth or Recombination.Hard (default))
          Specify how the various experts predictions are recombined
          * Smooth: prediction is a combination of experts prediction wrt their responsabilities,
          the heaviside factor which controls steepness of the change between experts regions is optimized
          to get best mixture quality.
          * Hard: prediction is taken from the expert with highest responsability
          resulting in a model with discontinuities.
        """
    @property
    def theta_init(self) -> typing.Optional[builtins.list[builtins.float]]:
        r"""
        ([nx] where nx is the dimension of inputs x)
          Initial guess for GP theta hyperparameters.
          When None the default is 1e-2 for all components
        """
    @theta_init.setter
    def theta_init(self, value: typing.Optional[builtins.list[builtins.float]]) -> None:
        r"""
        ([nx] where nx is the dimension of inputs x)
          Initial guess for GP theta hyperparameters.
          When None the default is 1e-2 for all components
        """
    @property
    def theta_bounds(
        self,
    ) -> typing.Optional[builtins.list[builtins.list[builtins.float]]]:
        r"""
        ([[lower_1, upper_1], ..., [lower_nx, upper_nx]] where nx is the dimension of inputs x)
          Space search when optimizing theta GP hyperparameters
          When None the default is [1e-6, 1e2] for all components
        """
    @theta_bounds.setter
    def theta_bounds(
        self, value: typing.Optional[builtins.list[builtins.list[builtins.float]]]
    ) -> None:
        r"""
        ([[lower_1, upper_1], ..., [lower_nx, upper_nx]] where nx is the dimension of inputs x)
          Space search when optimizing theta GP hyperparameters
          When None the default is [1e-6, 1e2] for all components
        """
    @property
    def n_start(self) -> builtins.int:
        r"""
        (int >= 0)
          Number of internal GP hyperpameters optimization restart (multistart)
          When is negative optimization is disabled and theta init value is used
        """
    @n_start.setter
    def n_start(self, value: builtins.int) -> None:
        r"""
        (int >= 0)
          Number of internal GP hyperpameters optimization restart (multistart)
          When is negative optimization is disabled and theta init value is used
        """
    @property
    def max_eval(self) -> builtins.int:
        r"""
        (int >= 0)
          Max number of likelihood evaluations during GP hyperparameters optimization
        """
    @max_eval.setter
    def max_eval(self, value: builtins.int) -> None:
        r"""
        (int >= 0)
          Max number of likelihood evaluations during GP hyperparameters optimization
        """

@typing.final
class GpMix:
    def __new__(
        cls,
        regr_spec: builtins.int = 1,
        corr_spec: builtins.int = 1,
        kpls_dim: typing.Optional[builtins.int] = None,
        n_clusters: builtins.int = 1,
        recombination: Recombination = Recombination.HARD,
        theta_init: typing.Optional[typing.Sequence[builtins.float]] = None,
        theta_bounds: typing.Optional[
            typing.Sequence[typing.Sequence[builtins.float]]
        ] = None,
        n_start: builtins.int = 10,
        max_eval: builtins.int = 50,
        seed: typing.Optional[builtins.int] = None,
    ) -> GpMix:
        r"""
        Gaussian processes mixture builder

            regr_spec (RegressionSpec flags, an int in [1, 7]):
                Specification of regression models used in mixture.
                Can be RegressionSpec.CONSTANT (1), RegressionSpec.LINEAR (2), RegressionSpec.QUADRATIC (4) or
                any bit-wise union of these values (e.g. RegressionSpec.CONSTANT | RegressionSpec.LINEAR)

            corr_spec (CorrelationSpec flags, an int in [1, 15]):
                Specification of correlation models used in mixture.
                Can be CorrelationSpec.SQUARED_EXPONENTIAL (1), CorrelationSpec.ABSOLUTE_EXPONENTIAL (2),
                CorrelationSpec.MATERN32 (4), CorrelationSpec.MATERN52 (8) or
                any bit-wise union of these values (e.g. CorrelationSpec.MATERN32 | CorrelationSpec.MATERN52)

            n_clusters (int):
                Number of clusters used by the mixture of surrogate experts (default is 1).
                When set to 0, the number of cluster is determined automatically and refreshed every
                10-points addition (should say 'tentative addition' because addition may fail for some points
                but it is counted anyway).
                When set to negative number -n, the number of clusters is determined automatically in [1, n]
                this is used to limit the number of trials hence the execution time.

            recombination (Recombination.Smooth or Recombination.Hard (default)):
                Specify how the various experts predictions are recombined
                * Smooth: prediction is a combination of experts prediction wrt their responsabilities,
                the heaviside factor which controls steepness of the change between experts regions is optimized
                to get best mixture quality.
                * Hard: prediction is taken from the expert with highest responsability
                resulting in a model with discontinuities.

            theta_init ([nx] where nx is the dimension of inputs x):
                Initial guess for GP theta hyperparameters.
                When None the default is 1e-2 for all components

            theta_bounds ([[lower_1, upper_1], ..., [lower_nx, upper_nx]] where nx is the dimension of inputs x):
                Space search when optimizing theta GP hyperparameters
                When None the default is [1e-6, 1e2] for all components

            kpls_dim (0 < int < nx where nx is the dimension of inputs x):
                Number of components to be used when PLS projection is used (a.k.a KPLS method).
                This is used to address high-dimensional problems typically when nx > 9.

            n_start (int >= 0):
                Number of internal GP hyperpameters optimization restart (multistart)

            max_eval (int >= 0):
                Max number of likelihood evaluations during GP hyperparameters optimization

            seed (int >= 0):
                Random generator seed to allow computation reproducibility.
        """
    def fit(
        self,
        xt: numpy.typing.NDArray[numpy.float64],
        yt: numpy.typing.NDArray[numpy.float64],
    ) -> Gpx:
        r"""
        Fit the parameters of the model using the training dataset to build a trained model

        # Parameters
            xt (array[nsamples, nx]): input samples
            yt (array[nsamples, 1]): output samples

        # Returns Gpx object
            the fitted Gaussian process mixture
        """

@typing.final
class Gpx:
    r"""
    A trained Gaussian processes mixture
    """
    @staticmethod
    def builder(
        regr_spec: builtins.int = 1,
        corr_spec: builtins.int = 1,
        kpls_dim: typing.Optional[builtins.int] = None,
        n_clusters: builtins.int = 1,
        recombination: Recombination = Recombination.HARD,
        theta_init: typing.Optional[typing.Sequence[builtins.float]] = None,
        theta_bounds: typing.Optional[
            typing.Sequence[typing.Sequence[builtins.float]]
        ] = None,
        n_start: builtins.int = 10,
        max_eval: builtins.int = 50,
        seed: typing.Optional[builtins.int] = None,
    ) -> GpMix:
        r"""
        Get Gaussian processes mixture builder aka `GpMix`

        See `GpMix` constructor
        """
    def __repr__(self) -> builtins.str:
        r"""
        Returns the String representation from serde json serializer
        """
    def __str__(self) -> builtins.str:
        r"""
        Returns a String informal representation
        """
    def save(self, filename: builtins.str) -> builtins.bool:
        r"""
        Save Gaussian processes mixture in a file.
        If the filename has .json JSON human readable format is used
        otherwise an optimized binary format is used.

        # Parameters
            filename with .json or .bin extension (string)
                file generated in the current directory

        # Returns True if save succeeds otherwise False
        """
    @staticmethod
    def load(filename: builtins.str) -> Gpx:
        r"""
        Load Gaussian processes mixture from file.

        # Parameters
            filename (string)
                json filepath generated by saving a trained Gaussian processes mixture
        """
    def predict(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict output values at nsamples points.

        # Parameters
            x (array[nsamples, nx])
                input values

        Returns
            the output values at nsamples x points (array[nsamples,])
        """
    def predict_var(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict variances at nsample points.

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the variances of the output values at nsamples input points (array[nsamples,])
        """
    def predict_gradients(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict surrogate output derivatives at nsamples points.

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the output derivatives at nsamples x points (array[nsamples, nx]) wrt inputs
            The ith column is the partial derivative value wrt to the ith component of x at the given samples.
        """
    def predict_var_gradients(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict variance derivatives at nsamples points.

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the variance derivatives at nsamples x points (array[nsamples, nx]) wrt inputs
            The ith column is the partial derivative value wrt to the ith component of x at the given samples.
        """
    def sample(
        self, x: numpy.typing.NDArray[numpy.float64], n_traj: builtins.int
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Sample gaussian process trajectories.

        # Parameters
            x (array[nsamples, nx])
                locations of the sampled trajectories
            n_traj number of trajectories to generate

        # Returns
            the trajectories as an array[nsamples, n_traj]
        """
    def dims(self) -> tuple[builtins.int, builtins.int]:
        r"""
        Get the input and output dimensions of the surrogate

        # Returns
            the couple (nx, ny)
        """
    def training_data(
        self,
    ) -> tuple[
        numpy.typing.NDArray[numpy.float64], numpy.typing.NDArray[numpy.float64]
    ]:
        r"""
        Get the nt training data points used to fit the surrogate

        # Returns
            the couple (ndarray[nt, nx], ndarray[nt,])
        """
    def thetas(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get optimized thetas hyperparameters (ie once GP experts are fitted)

        # Returns
            thetas as an array[n_clusters, nx or kpls_dim]
        """
    def variances(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get GP expert variance (ie posterior GP variance)

        # Returns
            variances as an array[n_clusters]
        """
    def likelihoods(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get reduced likelihood values gotten when fitting the GP experts

        Maybe used to compare various parameterization

        # Returns
            likelihood as an array[n_clusters]
        """

@typing.final
class OptimResult:
    @property
    def x_opt(self) -> numpy.typing.NDArray[numpy.float64]: ...
    @property
    def y_opt(self) -> numpy.typing.NDArray[numpy.float64]: ...
    @property
    def x_doe(self) -> numpy.typing.NDArray[numpy.float64]: ...
    @property
    def y_doe(self) -> numpy.typing.NDArray[numpy.float64]: ...

@typing.final
class RegressionSpec:
    ALL: builtins.int = 7
    CONSTANT: builtins.int = 1
    LINEAR: builtins.int = 2
    QUADRATIC: builtins.int = 4

@typing.final
class RunInfo:
    @property
    def fname(self) -> builtins.str: ...
    @fname.setter
    def fname(self, value: builtins.str) -> None: ...
    @property
    def num(self) -> builtins.int: ...
    @num.setter
    def num(self, value: builtins.int) -> None: ...
    def __new__(cls, fname: builtins.str, num: builtins.int = 0) -> RunInfo: ...

@typing.final
class SparseGpMix:
    r"""
    Sparse Gaussian processes mixture builder

        n_clusters (int >= 0):
            Number of clusters used by the mixture of surrogate experts.
            When set to 0, the number of cluster is determined automatically and refreshed every
            10-points addition (should say 'tentative addition' because addition may fail for some points
            but failures are counted anyway).

        corr_spec (CorrelationSpec flags, an int in [1, 15]):
            Specification of correlation models used in mixture.
            Can be CorrelationSpec.SQUARED_EXPONENTIAL (1), CorrelationSpec.ABSOLUTE_EXPONENTIAL (2),
            CorrelationSpec.MATERN32 (4), CorrelationSpec.MATERN52 (8) or
            any bit-wise union of these values (e.g. CorrelationSpec.MATERN32 | CorrelationSpec.MATERN52)

        recombination (Recombination.Smooth or Recombination.Hard):
            Specify how the various experts predictions are recombined
            * Smooth: prediction is a combination of experts prediction wrt their responsabilities,
            the heaviside factor which controls steepness of the change between experts regions is optimized
            to get best mixture quality.
            * Hard: prediction is taken from the expert with highest responsability
            resulting in a model with discontinuities.

        kpls_dim (0 < int < nx where nx is the dimension of inputs x):
            Number of components to be used when PLS projection is used (a.k.a KPLS method).
            This is used to address high-dimensional problems typically when nx > 9.

        n_start (int >= 0):
            Number of internal GP hyperpameters optimization restart (multistart)

        method (SparseMethod.FITC or SparseMethod.VFE):
            Sparse method to be used (default is FITC)

        seed (int >= 0):
            Random generator seed to allow computation reproducibility.
    """
    def __new__(
        cls,
        corr_spec: builtins.int = 1,
        theta_init: typing.Optional[typing.Sequence[builtins.float]] = None,
        theta_bounds: typing.Optional[
            typing.Sequence[typing.Sequence[builtins.float]]
        ] = None,
        kpls_dim: typing.Optional[builtins.int] = None,
        n_start: builtins.int = 10,
        nz: typing.Optional[builtins.int] = None,
        z: typing.Optional[numpy.typing.NDArray[numpy.float64]] = None,
        method: SparseMethod = SparseMethod.FITC,
        seed: typing.Optional[builtins.int] = None,
    ) -> SparseGpMix: ...
    def fit(
        self,
        xt: numpy.typing.NDArray[numpy.float64],
        yt: numpy.typing.NDArray[numpy.float64],
    ) -> SparseGpx:
        r"""
        Fit the parameters of the model using the training dataset to build a trained model

        # Parameters
            xt (array[nsamples, nx]): input samples
            yt (array[nsamples, 1]): output samples

        # Returns Sgp object
            the fitted Gaussian process mixture
        """

@typing.final
class SparseGpx:
    r"""
    A trained Gaussian processes mixture
    """
    @staticmethod
    def builder(
        corr_spec: builtins.int = 1,
        theta_init: typing.Optional[typing.Sequence[builtins.float]] = None,
        theta_bounds: typing.Optional[
            typing.Sequence[typing.Sequence[builtins.float]]
        ] = None,
        kpls_dim: typing.Optional[builtins.int] = None,
        n_start: builtins.int = 10,
        nz: typing.Optional[builtins.int] = None,
        z: typing.Optional[numpy.typing.NDArray[numpy.float64]] = None,
        method: SparseMethod = SparseMethod.FITC,
        seed: typing.Optional[builtins.int] = None,
    ) -> SparseGpMix:
        r"""
        Get Gaussian processes mixture builder aka `GpSparse`

        See `GpSparse` constructor
        """
    def __repr__(self) -> builtins.str:
        r"""
        Returns the String representation from serde json serializer
        """
    def __str__(self) -> builtins.str:
        r"""
        Returns a String informal representation
        """
    def save(self, filename: builtins.str) -> builtins.bool:
        r"""
        Save Gaussian processes mixture in a file.
        If the filename has .json JSON human readable format is used
        otherwise an optimized binary format is used.

        # Parameters
            filename with .json or .bin extension (string)
                file generated in the current directory

        # Returns True if save succeeds otherwise False
        """
    @staticmethod
    def load(filename: builtins.str) -> SparseGpx:
        r"""
        Load Gaussian processes mixture from a json file.

        # Parameters
            filename (string)
                json filepath generated by saving a trained Gaussian processes mixture
        """
    def predict(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict output values at nsamples points.

        # Parameters
            x (array[nsamples, nx])
                input values

        Returns
            the output values at nsamples x points (array[nsamples,])
        """
    def predict_var(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict variances at nsample points.

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the variances of the output values at nsamples input points (array[nsamples,])
        """
    def predict_gradients(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict surrogate output derivatives at nsamples points.

        Implementation note: central finite difference technique
        on `predict()` function is used which may be subject to numerical issues

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the output derivatives at nsamples x points (array[nsamples, nx]) wrt inputs
            The ith column is the partial derivative value wrt to the ith component of x at the given samples.
        """
    def predict_var_gradients(
        self, x: numpy.typing.NDArray[numpy.float64]
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Predict variance derivatives at nsamples points.

        Implementation note: central finite difference technique
        on `predict_var()` function is used which may be subject to numerical issues

        # Parameters
            x (array[nsamples, nx])
                input values

        # Returns
            the variance derivatives at nsamples x points (array[nsamples, nx]) wrt inputs
            The ith column is the partial derivative value wrt to the ith component of x at the given samples.
        """
    def sample(
        self, x: numpy.typing.NDArray[numpy.float64], n_traj: builtins.int
    ) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Sample gaussian process trajectories.

        # Parameters
            x (array[nsamples, nx])
                locations of the sampled trajectories
            n_traj number of trajectories to generate

        # Returns
            the trajectories as an array[nsamples, n_traj]
        """
    def thetas(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get optimized thetas hyperparameters (ie once GP experts are fitted)

        # Returns
            thetas as an array[n_clusters, nx or kpls_dim]
        """
    def variances(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get GP expert variance (ie posterior GP variance)

        # Returns
            variances as an array[n_clusters]
        """
    def likelihoods(self) -> numpy.typing.NDArray[numpy.float64]:
        r"""
        Get reduced likelihood values gotten when fitting the GP experts

        Maybe used to compare various parameterization

        # Returns
            likelihood as an array[n_clusters]
        """

@typing.final
class XSpec:
    @property
    def xtype(self) -> XType: ...
    @property
    def xlimits(self) -> builtins.list[builtins.float]: ...
    @property
    def tags(self) -> builtins.list[builtins.str]: ...
    def __new__(
        cls,
        xtype: XType,
        xlimits: typing.Sequence[builtins.float] = [],
        tags: typing.Sequence[builtins.str] = [],
    ) -> XSpec: ...

@typing.final
class ConstraintStrategy(enum.Enum):
    MC = ...
    UTB = ...

@typing.final
class InfillOptimizer(enum.Enum):
    COBYLA = ...
    SLSQP = ...

@typing.final
class InfillStrategy(enum.Enum):
    EI = ...
    WB2 = ...
    WB2S = ...
    LOG_EI = ...

@typing.final
class QInfillStrategy(enum.Enum):
    KB = ...
    KBLB = ...
    KBUB = ...
    CLMIN = ...

@typing.final
class Recombination(enum.Enum):
    HARD = ...
    r"""
    prediction is taken from the expert with highest responsability
    resulting in a model with discontinuities
    """
    SMOOTH = ...
    r"""
    Prediction is a combination experts prediction wrt their responsabilities,
    an optional heaviside factor might be used control steepness of the change between
    experts regions.
    """

@typing.final
class Sampling(enum.Enum):
    LHS = ...
    FULL_FACTORIAL = ...
    RANDOM = ...
    LHS_CLASSIC = ...
    LHS_CENTERED = ...
    LHS_MAXIMIN = ...
    LHS_CENTERED_MAXIMIN = ...

@typing.final
class SparseMethod(enum.Enum):
    Fitc = ...
    Vfe = ...

@typing.final
class XType(enum.Enum):
    FLOAT = ...
    INT = ...
    ORD = ...
    ENUM = ...

def lhs(
    xspecs: typing.Any,
    n_samples: builtins.int,
    seed: typing.Optional[builtins.int] = None,
) -> numpy.typing.NDArray[numpy.float64]:
    r"""
    Samples generation using optimized Latin Hypercube Sampling

    # Parameters
        xspecs: list of XSpec
        n_samples: number of samples
        seed: random seed

    # Returns
       ndarray of shape (n_samples, n_variables)
    """

def sampling(
    method: Sampling,
    xspecs: typing.Any,
    n_samples: builtins.int,
    seed: typing.Optional[builtins.int] = None,
) -> numpy.typing.NDArray[numpy.float64]:
    r"""
    Samples generation using given method

    # Parameters
        method: LHS, FULL_FACTORIAL or RANDOM
        xspecs: list of XSpec
        n_samples: number of samples
        seed: random seed

    # Returns
       ndarray of shape (n_samples, n_variables)
    """
