# /// script
# dependencies = ["pymhf[gui]>=0.1.16"]
#
# [tool.pymhf]
# exe = "NMS.exe"
# steam_gameid = 275850
# start_paused = false
#
# [tool.pymhf.gui]
# always_on_top = true
#
# [tool.pymhf.logging]
# log_dir = "."
# log_level = "info"
# window_name_override = "Instant scanning"
# ///

import logging
import ctypes

from pymhf import Mod
from pymhf.core.hooking import on_key_release
from pymhf.gui.decorators import BOOLEAN
import nmspy.data.types as nms

logger = logging.getLogger("InstantScan")


class instantScan(Mod):
    def __init__(self):
        super().__init__()
        self.should_be_instant = True

    # Used to define a Boolean Type with a label in the Mod GUI, autogenerated by pyMHF.
    @property
    @BOOLEAN("Scanning is instant:")
    def is_instant(self):
        return self.should_be_instant

    # Used to actually update the persisted value with the one input by the user in the GUI.
    @is_instant.setter
    def is_instant(self, value):
        self.should_be_instant = value

    # Also set a keyboard shortcut as an option instead of the button in the UI.
    # When you press this button you will see that the checkboxin the UI will also change.
    @on_key_release("o")
    def toggle_instantness(self):
        self.should_be_instant = not self.should_be_instant

    @nms.cGcBinoculars.UpdateScanBarProgress.before
    def set_no_scan(
        self, this: ctypes._Pointer[nms.cGcBinoculars], lfScanProgress: float
    ):
        if self.should_be_instant and lfScanProgress < 1:
            return (this, 1)
