import ctypes
from enum import IntEnum
from typing import Annotated

from pymhf.core.hooking import Structure
from pymhf.utils.partial_struct import partial_struct, Field, c_enum32

import nmspy.data.basic_types as basic
import nmspy.data.enums as enums


@partial_struct
class cTkNoiseFlattenOptions(Structure):
    class eFlatteningEnum(IntEnum):
        None_ = 0x0
        Flatten = 0x1
        TerrainEdits = 0x2

    Flattening: Annotated[
        c_enum32[eFlatteningEnum], Field(c_enum32[eFlatteningEnum], 0x0)
    ]

    class eWaterPlacementEnum(IntEnum):
        None_ = 0x0
        OnWater = 0x1
        Underwater = 0x2
        UnderwaterOnly = 0x3

    WaterPlacement: Annotated[
        c_enum32[eWaterPlacementEnum], Field(c_enum32[eWaterPlacementEnum], 0x4)
    ]


@partial_struct
class cTkNoiseFlattenPoint(Structure):
    FlattenType: Annotated[cTkNoiseFlattenOptions, Field(cTkNoiseFlattenOptions, 0x0)]
    Classification: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    Density: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FlattenRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Placement: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    TurbulenceAmplitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TurbulenceFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    TurbulenceOctaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AddLandingPad: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    AddShelter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    AddWaypoint: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]


@partial_struct
class cTkNoiseFlattenFixedPosition(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    FlattenPoint: Annotated[cTkNoiseFlattenPoint, Field(cTkNoiseFlattenPoint, 0x10)]


@partial_struct
class cTkNoiseUberData(Structure):
    AltitudeErosion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AmplifyFeatures: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]

    class eDebugNoiseTypeEnum(IntEnum):
        Plane = 0x0
        Check = 0x1
        Sine = 0x2
        Uber = 0x3

    DebugNoiseType: Annotated[
        c_enum32[eDebugNoiseTypeEnum], Field(c_enum32[eDebugNoiseTypeEnum], 0x8)
    ]
    Gain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Lacunarity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Octaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    PerturbFeatures: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    RemapFromMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    RemapFromMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    RemapToMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    RemapToMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    RidgeErosion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    SharpToRoundFeatures: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    SlopeBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    SlopeErosion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    SlopeGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]


@partial_struct
class cTkNoiseSuperFormulaData(Structure):
    Form_m: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Form_n1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Form_n2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Form_n3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cTkNoiseSuperPrimitiveData(Structure):
    BottomRadiusOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CornerRadiusXY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CornerRadiusZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Depth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Height: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Thickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cTkNoiseLayerData(Structure):
    FrequencyScaleY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Height: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]

    class eNoiseTypeEnum(IntEnum):
        Plane = 0x0
        Check = 0x1
        Sine = 0x2
        Smooth = 0x3
        Fractal = 0x4
        Ridged = 0x5
        Billow = 0x6
        Erosion = 0x7
        Volcanic = 0x8
        Glacial = 0x9
        Plateau = 0xA

    NoiseType: Annotated[c_enum32[eNoiseTypeEnum], Field(c_enum32[eNoiseTypeEnum], 0x8)]
    Octaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    RegionRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RegionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SeedOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    TurbulenceAmplitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    TurbulenceFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    TurbulenceOctaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Absolute: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    Invert: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    Subtract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]


@partial_struct
class cTkDomainWarpSettings(Structure):
    FeatureSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FractalGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    FractalLacunarity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    FractalOctaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    FractalWeightedStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    WarpAmplitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkNoiseFeatureData(Structure):
    class eFeatureTypeEnum(IntEnum):
        Tube = 0x0
        Blob = 0x1

    FeatureType: Annotated[
        c_enum32[eFeatureTypeEnum], Field(c_enum32[eFeatureTypeEnum], 0x0)
    ]
    Height: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HeightVarianceAmplitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    HeightVarianceFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaximumLOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    Octaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    Offset: Annotated[
        c_enum32[enums.cTkNoiseOffsetEnum],
        Field(c_enum32[enums.cTkNoiseOffsetEnum], 0x1C),
    ]
    Ratio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    RegionSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    SeedOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    SmoothRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    TileBlendMeters: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    VoxelType: Annotated[
        c_enum32[enums.cTkNoiseVoxelTypeEnum],
        Field(c_enum32[enums.cTkNoiseVoxelTypeEnum], 0x34),
    ]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]
    Subtract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3D)]
    Trench: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3E)]


@partial_struct
class cTkNoiseCaveData(Structure):
    Mouth: Annotated[cTkNoiseFeatureData, Field(cTkNoiseFeatureData, 0x0)]
    Tunnel: Annotated[cTkNoiseFeatureData, Field(cTkNoiseFeatureData, 0x40)]


@partial_struct
class cTkControllerButtonLookup(Structure):
    ButtonImageLookupFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkControllerList(Structure):
    Controllers: Annotated[
        basic.cTkDynamicArray[cTkControllerButtonLookup],
        Field(basic.cTkDynamicArray[cTkControllerButtonLookup], 0x0),
    ]


@partial_struct
class cTkOpenVRControllerLookup(Structure):
    DeviceSpec: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    ResetVRViewLayerName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DeviceKeywords: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]


@partial_struct
class cTkPlatformButtonPair(Structure):
    ButtonId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PlatformId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Size: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]


@partial_struct
class cTkOpenVRControllerList(Structure):
    Devices: Annotated[
        basic.cTkDynamicArray[cTkOpenVRControllerLookup],
        Field(basic.cTkDynamicArray[cTkOpenVRControllerLookup], 0x0),
    ]


@partial_struct
class cTkTriggerFeedbackData(Structure):
    class eFeedbackTypeEnum(IntEnum):
        None_ = 0x0
        Feedback = 0x1
        Weapon = 0x2
        Vibration = 0x3

    FeedbackType: Annotated[
        c_enum32[eFeedbackTypeEnum], Field(c_enum32[eFeedbackTypeEnum], 0x0)
    ]
    Frequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Position: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cTkVirtualBindingAltLayer(Structure):
    HudLayerID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcInputActionMapping(Structure):
    RemappedKey: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    RemappedPad: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcInputActionMapping2(Structure):
    Action: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x0)]
    ActionSet: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    Axis: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)]
    Button: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)]


@partial_struct
class cTkImGuiWindowData(Structure):
    WindowH: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    WindowMinH: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    WindowMinW: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    WindowScroll: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    WindowTab: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    WindowW: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    WindowX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    WindowY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    Type: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x20)]
    WindowMinimised: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA0)]
    WindowOpen: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA1)]
    WindowResize: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA2)]
    WindowUsed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA3)]


@partial_struct
class cTkImGuiData(Structure):
    RecentToolbox: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    WindowTable: Annotated[cTkImGuiWindowData, Field(cTkImGuiWindowData, 0xA0)]
    MainWindow: Annotated[cTkImGuiWindowData, Field(cTkImGuiWindowData, 0x52A0)]
    DimensionX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5344)]
    DimensionY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5348)]
    WindowCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x534C)]
    Maximised: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5350)]


@partial_struct
class cTkImGuiSettings(Structure):
    ActiveTextColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ActiveWindowBackgroundColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    ActiveWindowTitleColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    BackgroundColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    ButtonColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    ButtonHighlightColour: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    ButtonPressedColour: Annotated[basic.Colour, Field(basic.Colour, 0x60)]
    CloseButtonClickColour: Annotated[basic.Colour, Field(basic.Colour, 0x70)]
    CloseButtonColour: Annotated[basic.Colour, Field(basic.Colour, 0x80)]
    CloseButtonHighlightColour: Annotated[basic.Colour, Field(basic.Colour, 0x90)]
    EditBoxActiveColour: Annotated[basic.Colour, Field(basic.Colour, 0xA0)]
    EditBoxColour: Annotated[basic.Colour, Field(basic.Colour, 0xB0)]
    EditBoxSelectedColour: Annotated[basic.Colour, Field(basic.Colour, 0xC0)]
    MinimiseButtonClickColour: Annotated[basic.Colour, Field(basic.Colour, 0xD0)]
    MinimiseButtonColour: Annotated[basic.Colour, Field(basic.Colour, 0xE0)]
    MinimiseButtonHighlightColour: Annotated[basic.Colour, Field(basic.Colour, 0xF0)]
    TaskBarColour: Annotated[basic.Colour, Field(basic.Colour, 0x100)]
    TaskBarShadow: Annotated[basic.Colour, Field(basic.Colour, 0x110)]
    TextColour: Annotated[basic.Colour, Field(basic.Colour, 0x120)]
    TextDisabledColour: Annotated[basic.Colour, Field(basic.Colour, 0x130)]
    TextShadowColour: Annotated[basic.Colour, Field(basic.Colour, 0x140)]
    WindowBackgroundColour: Annotated[basic.Colour, Field(basic.Colour, 0x150)]
    WindowHighlight: Annotated[basic.Colour, Field(basic.Colour, 0x160)]
    WindowTitleColour: Annotated[basic.Colour, Field(basic.Colour, 0x170)]
    AltPlacementDistanceScrollSpeed: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x180)
    ]
    ScrollSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x184)]


@partial_struct
class cTkPostProcessData(Structure):
    BrightnessDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BrightnessFinal: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    ContrastDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ContrastFinal: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    DOFFarAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DOFFarPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DOFNearAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DOFNearPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    SaturationDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    SaturationFinal: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cTkLSystemRestrictionData(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]

    class eRestrictionEnum(IntEnum):
        NoMoreThan = 0x0
        AtLeast = 0x1
        AtLeastIfICan = 0x2

    Restriction: Annotated[
        c_enum32[eRestrictionEnum], Field(c_enum32[eRestrictionEnum], 0x4)
    ]


@partial_struct
class cTkLSystemGlobalRestriction(Structure):
    Model: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Restrictions: Annotated[
        basic.cTkDynamicArray[cTkLSystemRestrictionData],
        Field(basic.cTkDynamicArray[cTkLSystemRestrictionData], 0x10),
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]


@partial_struct
class cTkLSystemGlobalVariation(Structure):
    Model: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Variations: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x14)]


@partial_struct
class cTkLSystemLocatorEntry(Structure):
    Model: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Restrictions: Annotated[
        basic.cTkDynamicArray[cTkLSystemRestrictionData],
        Field(basic.cTkDynamicArray[cTkLSystemRestrictionData], 0x10),
    ]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cTkLSystemInnerRule(Structure):
    Entries: Annotated[
        basic.cTkDynamicArray[cTkLSystemLocatorEntry],
        Field(basic.cTkDynamicArray[cTkLSystemLocatorEntry], 0x0),
    ]

    class eMergeProbabilityOptionsEnum(IntEnum):
        Balance = 0x0
        Prioritize = 0x1
        Replace = 0x2

    MergeProbabilityOptions: Annotated[
        c_enum32[eMergeProbabilityOptionsEnum],
        Field(c_enum32[eMergeProbabilityOptionsEnum], 0x10),
    ]
    LocatorType: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x14)
    ]


@partial_struct
class cTkLSystemRule(Structure):
    Model: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Rules: Annotated[
        basic.cTkDynamicArray[cTkLSystemInnerRule],
        Field(basic.cTkDynamicArray[cTkLSystemInnerRule], 0x10),
    ]

    class eRuleTypeEnum(IntEnum):
        Default = 0x0
        BaseRule = 0x1

    RuleType: Annotated[c_enum32[eRuleTypeEnum], Field(c_enum32[eRuleTypeEnum], 0x20)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x24)]


@partial_struct
class cTkLSystemRuleTemplate(Structure):
    LSystem: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)]


@partial_struct
class cTkLSystemRulesData(Structure):
    GlobalRestriction: Annotated[
        basic.cTkDynamicArray[cTkLSystemGlobalRestriction],
        Field(basic.cTkDynamicArray[cTkLSystemGlobalRestriction], 0x0),
    ]
    GlobalVariation: Annotated[
        basic.cTkDynamicArray[cTkLSystemGlobalVariation],
        Field(basic.cTkDynamicArray[cTkLSystemGlobalVariation], 0x10),
    ]
    Rules: Annotated[
        basic.cTkDynamicArray[cTkLSystemRule],
        Field(basic.cTkDynamicArray[cTkLSystemRule], 0x20),
    ]
    Templates: Annotated[
        basic.cTkDynamicArray[cTkLSystemRuleTemplate],
        Field(basic.cTkDynamicArray[cTkLSystemRuleTemplate], 0x30),
    ]


@partial_struct
class cTkHeavyAirSystem(Structure):
    AmplitudeMax: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    AmplitudeMin: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Colour1: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    Colour2: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    FadeSpeedRange: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    MajorDirection: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x50)]
    RotationSpeedRange: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x60)]
    ScaleRange: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x70)]
    TwinkleRange: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x80)]
    Material: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x90)]
    Colour1Alpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    Colour2Alpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]


@partial_struct
class cTkIdSceneFilename(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkMagicModelData(Structure):
    Centre: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Vertices: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x10),
    ]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cTkInputFrame(Structure):
    LeftStick: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    RightStick: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    LeftTrigger: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RightTrigger: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Buttons: Annotated[ctypes.c_int16, Field(ctypes.c_int16, 0x18)]


@partial_struct
class cTkProductIdArray(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cTkFoliageData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Material: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    AngleMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Density: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    DensityVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    AngleExponentially: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cTkRawID(Structure):
    Value0: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    Value1: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x8)]


@partial_struct
class cTkSketchNodeConnections(Structure):
    Connections: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint32],
        Field(basic.cTkDynamicArray[ctypes.c_uint32], 0x0),
    ]


@partial_struct
class cTkSketchNodeData(Structure):
    Connections: Annotated[
        basic.cTkDynamicArray[cTkSketchNodeConnections],
        Field(basic.cTkDynamicArray[cTkSketchNodeConnections], 0x0),
    ]
    CustomData: Annotated[
        basic.cTkDynamicArray[ctypes.c_byte],
        Field(basic.cTkDynamicArray[ctypes.c_byte], 0x10),
    ]
    PositionX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    PositionY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    SelectedVariant: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]

    class eTriggerTypeEnum(IntEnum):
        Disabled = 0x0
        Interrupt = 0x1
        RunParallel = 0x2
        Blocked = 0x3
        QueueLatest = 0x4
        QueueAll = 0x5

    TriggerType: Annotated[
        c_enum32[eTriggerTypeEnum], Field(c_enum32[eTriggerTypeEnum], 0x2C)
    ]
    TypeName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x30)]


@partial_struct
class cTkTextureResource(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    ResHandle: Annotated[basic.GcResource, Field(basic.GcResource, 0x10)]


@partial_struct
class cTkTrophyEntry(Structure):
    TrophyId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Ps4Id: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    PCId: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x14)]
    XboxOneId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x54)
    ]


@partial_struct
class cTkTrophyData(Structure):
    Trophies: Annotated[
        basic.cTkDynamicArray[cTkTrophyEntry],
        Field(basic.cTkDynamicArray[cTkTrophyEntry], 0x0),
    ]


@partial_struct
class cTkEmitFromParticleInfo(Structure):
    class eEmissionRateTypeEnum(IntEnum):
        PerParticle = 0x0
        Distance = 0x1

    EmissionRateType: Annotated[
        c_enum32[eEmissionRateTypeEnum], Field(c_enum32[eEmissionRateTypeEnum], 0x0)
    ]
    OtherEmitterIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cTkEmitterBillboardAlignment(Structure):
    class eBillboardAlignmentEnum(IntEnum):
        Screen = 0x0
        XLocal = 0x1
        YLocal = 0x2
        ZLocal = 0x3
        NegativeXLocal = 0x4
        NegativeYLocal = 0x5
        NegativeZLocal = 0x6
        ScreenWorld = 0x7

    BillboardAlignment: Annotated[
        c_enum32[eBillboardAlignmentEnum], Field(c_enum32[eBillboardAlignmentEnum], 0x0)
    ]
    CameraFacing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cTkEmitterData(Structure):
    Particle: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cTkLocalisationEntry(Structure):
    Id: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    BrazilianPortuguese: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Dutch: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    English: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    French: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)]
    German: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)]
    Italian: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)]
    Japanese: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x80)]
    Korean: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x90)]
    LatinAmericanSpanish: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xA0)
    ]
    Polish: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xB0)]
    Portuguese: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xC0)
    ]
    Russian: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xD0)]
    SimplifiedChinese: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xE0)
    ]
    Spanish: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xF0)]
    TencentChinese: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x100)
    ]
    TraditionalChinese: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x110)
    ]
    USEnglish: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x120)
    ]


@partial_struct
class cTkLocalisationTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cTkLocalisationEntry],
        Field(basic.cTkDynamicArray[cTkLocalisationEntry], 0x0),
    ]


@partial_struct
class cTkModelResource(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Seed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    ResHandle: Annotated[basic.GcResource, Field(basic.GcResource, 0x18)]


@partial_struct
class cTkLODModelResource(Structure):
    LODModel: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    SwapThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cTkMaterialResource(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    ResHandle: Annotated[basic.GcResource, Field(basic.GcResource, 0x10)]


@partial_struct
class cTkLanguageFontTableEntry(Structure):
    ConsoleFont: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    ConsoleFont2: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    GameFont: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    GameFont2: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Language: Annotated[
        c_enum32[enums.cTkLanguages], Field(c_enum32[enums.cTkLanguages], 0x40)
    ]


@partial_struct
class cTkLanguageFontTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cTkLanguageFontTableEntry],
        Field(basic.cTkDynamicArray[cTkLanguageFontTableEntry], 0x0),
    ]


@partial_struct
class cTkPaletteTexture(Structure):
    class eColourAltEnum(IntEnum):
        Primary = 0x0
        Alternative1 = 0x1
        Alternative2 = 0x2
        Alternative3 = 0x3
        Alternative4 = 0x4
        Unique = 0x5
        MatchGround = 0x6
        None_ = 0x7

    ColourAlt: Annotated[c_enum32[eColourAltEnum], Field(c_enum32[eColourAltEnum], 0x0)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]

    class ePaletteEnum(IntEnum):
        Grass = 0x0
        Plant = 0x1
        Leaf = 0x2
        Wood = 0x3
        Rock = 0x4
        Stone = 0x5
        Crystal = 0x6
        Sand = 0x7
        Dirt = 0x8
        Metal = 0x9
        Paint = 0xA
        Plastic = 0xB
        Fur = 0xC
        Scale = 0xD
        Feather = 0xE
        Water = 0xF
        Cloud = 0x10
        Sky = 0x11
        Space = 0x12
        Underbelly = 0x13
        Undercoat = 0x14
        Snow = 0x15
        SkyHorizon = 0x16
        SkyFog = 0x17
        SkyHeightFog = 0x18
        SkySunset = 0x19
        SkyNight = 0x1A
        WaterNear = 0x1B
        SpaceCloud = 0x1C
        SpaceBottom = 0x1D
        SpaceSolar = 0x1E
        SpaceLight = 0x1F
        Warrior = 0x20
        Scientific = 0x21
        Trader = 0x22
        WarriorAlt = 0x23
        ScientificAlt = 0x24
        TraderAlt = 0x25
        RockSaturated = 0x26
        RockLight = 0x27
        RockDark = 0x28
        PlanetRing = 0x29
        Custom_Head = 0x2A
        Custom_Torso = 0x2B
        Custom_Chest_Armour = 0x2C
        Custom_Backpack = 0x2D
        Custom_Arms = 0x2E
        Custom_Hands = 0x2F
        Custom_Legs = 0x30
        Custom_Feet = 0x31
        Cave = 0x32
        GrassAlt = 0x33
        BioShip_Body = 0x34
        BioShip_Underbelly = 0x35
        BioShip_Cockpit = 0x36
        SailShip_Sails = 0x37
        Freighter = 0x38
        FreighterPaint = 0x39
        PirateBase = 0x3A
        PirateAlt = 0x3B
        SpaceStationBase = 0x3C
        SpaceStationAlt = 0x3D
        SpaceStationLights = 0x3E
        DeepWaterBioLum = 0x3F

    Palette: Annotated[c_enum32[ePaletteEnum], Field(c_enum32[ePaletteEnum], 0x8)]


@partial_struct
class cTkLanguagesAllowedData(Structure):
    Allowed: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cTkLanguages]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cTkLanguages]], 0x0),
    ]
    Fallback: Annotated[
        c_enum32[enums.cTkLanguages], Field(c_enum32[enums.cTkLanguages], 0x10)
    ]


@partial_struct
class cTkProceduralTexture(Structure):
    AverageColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Name: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x10)]
    TextureName: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x40)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]

    class eTextureGameplayUseEnum(IntEnum):
        IgnoreName = 0x0
        MatchName = 0x1
        DoNotMatchName = 0x2

    TextureGameplayUse: Annotated[
        c_enum32[eTextureGameplayUseEnum],
        Field(c_enum32[eTextureGameplayUseEnum], 0x50),
    ]
    Multiply: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]
    OverrideAverageColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x55)]


@partial_struct
class cTkFloatRange(Structure):
    Maximum: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Minimum: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cTkGlobals(Structure):
    class eAssertsLevelEnum(IntEnum):
        Disabled = 0x0
        Ignored = 0x1
        Skipped = 0x2
        Enabled = 0x3

    AssertsLevel: Annotated[
        c_enum32[eAssertsLevelEnum], Field(c_enum32[eAssertsLevelEnum], 0x0)
    ]

    class eEnabledChannelsEnum(IntEnum):
        empty = 0x0
        Default = 0x1
        Note = 0x2
        Error = 0x4
        Warning = 0x8
        Info = 0x10
        Alt = 0x20
        AltWarn = 0x40
        AltError = 0x80

    EnabledChannels: Annotated[
        c_enum32[eEnabledChannelsEnum], Field(c_enum32[eEnabledChannelsEnum], 0x4)
    ]
    EnableOit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]

    class eForceGPUPresetToEnum(IntEnum):
        PC_Low = 0x0
        PC_Medium = 0x1
        PC_High = 0x2
        PC_Ultra = 0x3
        PS4 = 0x4
        PS4VR = 0x5
        PS4Pro = 0x6
        PS4ProVR = 0x7
        XB1 = 0x8
        XB1X = 0x9
        Oberon = 0xA
        MacOS = 0xB
        iOS = 0xC

    ForceGPUPresetTo: Annotated[
        c_enum32[eForceGPUPresetToEnum], Field(c_enum32[eForceGPUPresetToEnum], 0xC)
    ]
    FrameFlipRateDefault: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    FrameFlipRateGame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    FrameFlipRateLoad: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]

    class eGameWindowModeEnum(IntEnum):
        Bordered = 0x0
        Borderless = 0x1
        Fullscreen = 0x2
        Maximised = 0x3
        Minimised = 0x4

    GameWindowMode: Annotated[
        c_enum32[eGameWindowModeEnum], Field(c_enum32[eGameWindowModeEnum], 0x1C)
    ]
    HighlightPlacementIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    HmdEyeBufferHeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    HmdEyeBufferWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    HmdEyeScalePos: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    HmdHeadScalePos: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HmdImmersionFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    HmdMonitor: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    HmdPreviewScale: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    LoadBalanceTimeoutMS: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    LODOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    MaxFrameRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    Monitor: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4C)]
    OctahedralImpostersViewCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    PSVR2LoadBalanceTimeoutMS: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    ScratchpadInstanceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    ScratchpadInstancesCap: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5C)]
    ScratchpadInstanceSpacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    ScratchpadInstancesPerSide: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x64)]
    ScratchpadInstancesRandomness: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x68)
    ]
    ScratchpadModelSeed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x6C)]
    ScreenHeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    ScreenWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    TiledWindowsIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]
    TiledWindowsSplitCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x7C)]
    TitlebarMenuOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    TouchScreenSwipeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    TouchScreenSwipeTravelThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x88)
    ]

    class eTrialStatusEnum(IntEnum):
        SystemDefault = 0x0
        ForceTrial = 0x1
        ForceFullGame = 0x2

    TrialStatus: Annotated[
        c_enum32[eTrialStatusEnum], Field(c_enum32[eTrialStatusEnum], 0x8C)
    ]
    UpdatePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    UpdatePeriodSteam: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    VoiceUpdatePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    VoiceUpdatePeriodSteam: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    VRLoadBalanceTimeoutMS: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    WindowPositionX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA4)]
    WindowPositionY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA8)]
    WwiseVibrationMultiplierPrimary: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xAC)
    ]
    WwiseVibrationMultiplierSecondary: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB0)
    ]
    EditorLayout: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xB4)
    ]
    ExcludeLogFilter: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1B4)
    ]
    IncludeLogFilter: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x2B4)
    ]
    ScratchpadModel: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x3B4)
    ]
    AllowInPlaceNGuiElementRenaming: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4B4)
    ]
    AssertsPopupAlwaysOnTop: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B5)]
    AutoTabNewlyOpenedWindows: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B6)]
    ColourLODs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B7)]
    ColourVertexDensity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B8)]
    CompressImposterTextures: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B9)]
    CrashOnFailedCriticalAssertion: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4BA)
    ]
    DefaultSelectIgnoreAsserts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4BB)]
    DisableImposters: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4BC)]
    DisableMultiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4BD)]
    DisableResScaling: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4BE)]
    DisableSwitchingAwayFromPad: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4BF)]
    DisableUndergrowthInstanceRendering: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4C0)
    ]
    DisableVSync: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C1)]
    EnableGpuBreadcrumbs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C2)]
    EnableNvidiaAftermath: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C3)]
    EnablePix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C4)]
    EnableRayTracing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C5)]
    EnableRenderdoc: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C6)]
    EnableShaderReload: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C7)]
    EnableVirtualTouchScreen: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C8)]
    EnableZstdSaves: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C9)]
    FavouritesAndUndoEnabledByDefault: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4CA)
    ]
    FilterTranslatedTextWhenSearching: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4CB)
    ]
    ForceGPUPreset: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4CC)]
    ForceWinGdkHandheld: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4CD)]
    FreezeCulling: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4CE)]
    HideRenderdocOverlay: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4CF)]
    HmdDistortionPassthru: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D0)]
    HmdEnable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D1)]
    HmdFoveated: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D2)]
    HmdStereoRender: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D3)]
    HmdTracking: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D4)]
    JitterRenderOffsetEveryFrame: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D5)]
    LoadRelativeEditorLayouts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D6)]
    LogInputChanges: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D7)]
    LogInputSetup: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D8)]
    MakeUnusedUniformsNaN: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D9)]
    MinGPUMode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4DA)]
    OctahedralImpostersDisable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4DB)]
    OctahedralImpostersEnable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4DC)]
    OctahedralImpostersViewFromSpace: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4DD)
    ]
    SampleCollisionWithCamera: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4DE)]
    ScratchpadInstanced: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4DF)]
    ScratchpadWind: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E0)]
    ShowPlayerCollisions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E1)]
    SimulateDisabledParticleRefractions: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4E2)
    ]
    SmokeTestSmokeBotAutoStart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E3)]
    UseDebugScreenSettings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E4)]
    UseHeavyAir: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E5)]
    VulkanValidationEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E6)]
    VulkanValidationPrintMessages: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E7)]
    VulkanValidationPrintUniqueOnly: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4E8)
    ]


@partial_struct
class cTkID256Array(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x0),
    ]


@partial_struct
class cTkIdArray(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cTkNavMeshAreaNavigability(Structure):
    EntryCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    TravelCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    IsNavigable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cTkIdModelResource(Structure):
    Model: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cTkBoundingBoxData(Structure):
    Max: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Min: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]


@partial_struct
class cTkCameraData(Structure):
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    AdjustPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AdjustRoll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AdjustYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Angle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Fov: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    HeightAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cTkCameraWanderData(Structure):
    CamWanderAmplitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CamWanderPhase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CamWander: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cTkDynamicTreeWindFrequency(Structure):
    BranchHForcePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BranchHForcePeriodFast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    BranchVForcePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    BranchVForcePeriodFast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    LeafForcePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    LeafForcePeriodFast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    LeafNoiseSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    LeafNoiseSpeedFast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cTkBigPosData(Structure):
    Local: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]


@partial_struct
class cTkBlackboardDefaultValueBool(Structure):
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x10),
    ]
    DefaultValue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cTkBlackboardDefaultValueFloat(Structure):
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x10),
    ]
    DefaultValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkBlackboardDefaultValueId(Structure):
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DefaultValue: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x20),
    ]


@partial_struct
class cTkBlackboardDefaultValueInteger(Structure):
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x10),
    ]
    DefaultValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cTkBlackboardDefaultValueVector(Structure):
    DefaultValue: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x20),
    ]


@partial_struct
class cTkBlackboardKey(Structure):
    BlackboardKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BlackboardCategory: Annotated[
        c_enum32[enums.cTkBlackboardCategory],
        Field(c_enum32[enums.cTkBlackboardCategory], 0x10),
    ]


@partial_struct
class cTkBlackboardValueBool(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cTkBlackboardValueFloat(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cTkBlackboardValueId(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkBlackboardValueInteger(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cTkBlackboardValueVector(Structure):
    Value: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkBehaviourTreeConcurrentSelectorData(Structure):
    Children: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eFailWhenEnum(IntEnum):
        AnyChildFails = 0x0
        AllChildrenFail = 0x1

    FailWhen: Annotated[c_enum32[eFailWhenEnum], Field(c_enum32[eFailWhenEnum], 0x20)]

    class eSucceedWhenEnum(IntEnum):
        AllChildrenSucceed = 0x0
        AnyChildSucceeds = 0x1

    SucceedWhen: Annotated[
        c_enum32[eSucceedWhenEnum], Field(c_enum32[eSucceedWhenEnum], 0x24)
    ]


@partial_struct
class cTkBehaviourTreePriorityDecoratorData(Structure):
    Child: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]


@partial_struct
class cTkBehaviourTreeSequentialSelectorData(Structure):
    Children: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    FailWhenAnyChildFails: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    Looping: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]


@partial_struct
class cTkBehaviourTreeSucceedDecoratorData(Structure):
    Child: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]


@partial_struct
class cTkNavMeshBuildParams(Structure):
    AgentHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AgentMaxSlopeDegrees: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AgentMaxStepHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AgentRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    AgentSteepSlopeDegrees: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    ContourMaxError: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    ContourMaxLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DetailMeshMaxError: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    DetailMeshSampleDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    RegionMinCellCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    BuildAsync: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    BuildDetailMesh: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    BuildPolyBVH: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    ErodeWalkableAreas: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    FilterLedgeSpans: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    FilterLowHangingObstacles: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    FilterWalkableLowHeightSpans: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    KeepIntermediateRecastData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]
    MedianFilterWalkableAreas: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcPlanetaryNavMeshBuildParams(Structure):
    BaseParams: Annotated[cTkNavMeshBuildParams, Field(cTkNavMeshBuildParams, 0x0)]
    CellsPerVoxelHeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    CellsPerVoxelWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]


@partial_struct
class cTkNavMeshAreaFlagNavigability(Structure):
    Navigability: Annotated[
        cTkNavMeshAreaNavigability, Field(cTkNavMeshAreaNavigability, 0x0)
    ]
    AreaFlag: Annotated[
        c_enum32[enums.cTkNavMeshAreaFlags],
        Field(c_enum32[enums.cTkNavMeshAreaFlags], 0xC),
    ]


@partial_struct
class cTkNavMeshAreaGroup(Structure):
    Areas: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cTkNavMeshAreaType]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cTkNavMeshAreaType]], 0x0),
    ]
    GroupId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkNavMeshAreaGroupNavigability(Structure):
    AreaGroupId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Navigability: Annotated[
        cTkNavMeshAreaNavigability, Field(cTkNavMeshAreaNavigability, 0x10)
    ]


@partial_struct
class cTkNavMeshAreaTypeNavigability(Structure):
    Navigability: Annotated[
        cTkNavMeshAreaNavigability, Field(cTkNavMeshAreaNavigability, 0x0)
    ]
    AreaType: Annotated[
        c_enum32[enums.cTkNavMeshAreaType],
        Field(c_enum32[enums.cTkNavMeshAreaType], 0xC),
    ]


@partial_struct
class cTkNavMeshFlockingParams(Structure):
    InfluenceRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    LookAheadTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    WeightAlignment: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    WeightCoherence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    WeightSeparation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkNavMeshInclusionParams(Structure):
    InclusionMinSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AreaType: Annotated[
        c_enum32[enums.cTkNavMeshAreaType],
        Field(c_enum32[enums.cTkNavMeshAreaType], 0x4),
    ]
    InclusionType: Annotated[
        c_enum32[enums.cTkNavMeshInclusionType],
        Field(c_enum32[enums.cTkNavMeshInclusionType], 0x5),
    ]


@partial_struct
class cTkSceneBoneRemapping(Structure):
    FromBone: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x0)]
    ToBone: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x80)]


@partial_struct
class cTkSceneBoneRemappingTable(Structure):
    BoneMappings: Annotated[
        basic.cTkDynamicArray[cTkSceneBoneRemapping],
        Field(basic.cTkDynamicArray[cTkSceneBoneRemapping], 0x0),
    ]


@partial_struct
class cTkNavMeshMovementDebugVisOptions(Structure):
    VelocityArrowLookAheadTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eNavMeshMovementDebugVisFlagsEnum(IntEnum):
        empty = 0x0
        Corridor = 0x1
        PointPath = 0x2
        LocalBoundary = 0x4
        CurrentPos = 0x8
        Target = 0x10
        CurrentVel = 0x20
        DesiredVelNoRepel = 0x40
        DesiredVel = 0x80
        ResultVel = 0x100
        Flocking = 0x200
        VelocitySampling = 0x400
        ObstacleAvoidance = 0x800

    NavMeshMovementDebugVisFlags: Annotated[
        c_enum32[eNavMeshMovementDebugVisFlagsEnum],
        Field(c_enum32[eNavMeshMovementDebugVisFlagsEnum], 0x4),
    ]


@partial_struct
class cTkSceneNodeAttributeData(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cTkNavMeshVelocitySamplingParams(Structure):
    AdaptiveDepths: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x0)]
    AdaptiveDivs: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x4)]
    AdaptiveRings: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x8)]
    GridSize: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0xC)]
    HorizonTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    VelocityBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    WeightCollisionTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    WeightCurVel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    WeightDesiredVel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    WeightEnergyCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    WeightFacingDir: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    WeightProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    WeightSide: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eSamplingTypeEnum(IntEnum):
        Adaptive = 0x0
        Grid = 0x1

    SamplingType: Annotated[
        c_enum32[eSamplingTypeEnum], Field(c_enum32[eSamplingTypeEnum], 0x34)
    ]


@partial_struct
class cTkNavMeshPathingQualitySettings(Structure):
    VelocitySamplingParams: Annotated[
        cTkNavMeshVelocitySamplingParams, Field(cTkNavMeshVelocitySamplingParams, 0x0)
    ]
    CollisionQueryRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    HeuristicScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    UseRaycastShortcuts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cTkTransformData(Structure):
    RotX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    RotY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    RotZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ScaleX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    ScaleY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    ScaleZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    TransX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TransY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    TransZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cTkSceneNodeData(Structure):
    Attributes: Annotated[
        basic.cTkDynamicArray[cTkSceneNodeAttributeData],
        Field(basic.cTkDynamicArray[cTkSceneNodeAttributeData], 0x0),
    ]
    Children: Annotated[
        "basic.cTkDynamicArray[cTkSceneNodeData]",
        Field("basic.cTkDynamicArray[cTkSceneNodeData]", 0x10),
    ]
    Name: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Type: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Transform: Annotated[cTkTransformData, Field(cTkTransformData, 0x40)]
    NameHash: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x64)]
    PlatformExclusion: Annotated[ctypes.c_int8, Field(ctypes.c_int8, 0x68)]


@partial_struct
class cTkMaterialShaderMillComment(Structure):
    PosMaxX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    PosMaxY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    PosMinX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    PosMinY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    Text: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)]


@partial_struct
class cTkMaterialShaderMillConnect(Structure):
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x4)]
    Expanded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cTkMaterialShaderMillNode(Structure):
    ColourValue: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Inputs: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillConnect],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillConnect], 0x10),
    ]
    Outputs: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillConnect],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillConnect], 0x20),
    ]
    FValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FValue2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    Id: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    IValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    IValue2: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    WindowX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    WindowY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    Value: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x4C)]
    ParameterName: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xCC)
    ]
    Type: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10C)]
    ExposeAsParameter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12C)]


@partial_struct
class cTkMaterialShaderMillLink(Structure):
    InputShuffle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OutputShuffle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    InputNode: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    OutputNode: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    InputConnect: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x2C)
    ]
    OutputConnect: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x4C)
    ]


@partial_struct
class cTkMaterialShaderMillFlag(Structure):
    Flag: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]


@partial_struct
class cTkMaterialShaderMillData(Structure):
    ShaderMillCmts: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillComment],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillComment], 0x0),
    ]
    ShaderMillFlags: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillFlag],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillFlag], 0x10),
    ]
    ShaderMillLinks: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillLink],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillLink], 0x20),
    ]
    ShaderMillNodes: Annotated[
        basic.cTkDynamicArray[cTkMaterialShaderMillNode],
        Field(basic.cTkDynamicArray[cTkMaterialShaderMillNode], 0x30),
    ]
    OutputX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    OutputY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    ScrollX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    ScrollY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    Zoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Description: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x54)
    ]
    Filename: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x154)
    ]
    Name: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x254)]


@partial_struct
class cTkVertexStream(Structure):
    VertexStream: Annotated[
        basic.cTkDynamicArray[ctypes.c_byte],
        Field(basic.cTkDynamicArray[ctypes.c_byte], 0x0),
    ]


@partial_struct
class cTkMaterialAlternative(Structure):
    MaterialAlternativeId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]

    class eTextureTypeEnum(IntEnum):
        Diffuse = 0x0
        Normal = 0x1
        Ambient = 0x2
        Environment = 0x3

    TextureType: Annotated[
        c_enum32[eTextureTypeEnum], Field(c_enum32[eTextureTypeEnum], 0x30)
    ]


@partial_struct
class cTkMaterialUniform_Float(Structure):
    Values: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x0)]
    ExtendedValues: Annotated[
        basic.cTkDynamicArray[basic.Vector4f],
        Field(basic.cTkDynamicArray[basic.Vector4f], 0x10),
    ]
    Name: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]


@partial_struct
class cTkMaterialUniform_UInt(Structure):
    Values: Annotated[basic.Vector4i, Field(basic.Vector4i, 0x0)]
    ExtendedValues: Annotated[
        basic.cTkDynamicArray[basic.Vector4i],
        Field(basic.cTkDynamicArray[basic.Vector4i], 0x10),
    ]
    Name: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]


@partial_struct
class cTkMaterialSampler(Structure):
    MaterialAlternativeId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Map: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Name: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    Anisotropy: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]

    class eTextureAddressModeEnum(IntEnum):
        Wrap = 0x0
        WrapUClampV = 0x1
        Clamp = 0x2
        ClampToBorder = 0x3
        Mirror = 0x4

    TextureAddressMode: Annotated[
        c_enum32[eTextureAddressModeEnum],
        Field(c_enum32[eTextureAddressModeEnum], 0x44),
    ]

    class eTextureFilterModeEnum(IntEnum):
        None_ = 0x0
        Bilinear = 0x1
        Trilinear = 0x2

    TextureFilterMode: Annotated[
        c_enum32[eTextureFilterModeEnum], Field(c_enum32[eTextureFilterModeEnum], 0x48)
    ]
    IsCube: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]
    IsSRGB: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]
    UseCompression: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E)]
    UseMipMaps: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4F)]


@partial_struct
class cTkMeshData(Structure):
    IdString: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MeshDataStream: Annotated[
        basic.cTkDynamicArray[ctypes.c_byte],
        Field(basic.cTkDynamicArray[ctypes.c_byte], 0x10),
    ]
    MeshPositionDataStream: Annotated[
        basic.cTkDynamicArray[ctypes.c_byte],
        Field(basic.cTkDynamicArray[ctypes.c_byte], 0x20),
    ]
    Hash: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x30)]
    IndexDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    VertexDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    VertexPositionDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]


@partial_struct
class cTkGeometryStreamData(Structure):
    StreamDataArray: Annotated[
        basic.cTkDynamicArray[cTkMeshData],
        Field(basic.cTkDynamicArray[cTkMeshData], 0x0),
    ]


@partial_struct
class cTkAnimNodeFrameData(Structure):
    Rotations: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint16],
        Field(basic.cTkDynamicArray[ctypes.c_uint16], 0x0),
    ]
    Scales: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x10),
    ]
    Translations: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x20),
    ]


@partial_struct
class cTkIndexStream(Structure):
    IndexStream: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x0),
    ]


@partial_struct
class cTkJointBindingData(Structure):
    InvBindMatrix: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BindRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    BindScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    BindTranslate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]


@partial_struct
class cTkJointExtentData(Structure):
    JointExtentCenter: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    JointExtentMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    JointExtentMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    JointExtentStdDev: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cTkJointMirrorAxis(Structure):
    MirrorAxisMode: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    RotAdjustW: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    RotAdjustX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    RotAdjustY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    RotAdjustZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RotMirrorAxisX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    RotMirrorAxisY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    RotMirrorAxisZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    TransMirrorAxisX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    TransMirrorAxisY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    TransMirrorAxisZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cTkVertexElement(Structure):
    class eInstancingEnum(IntEnum):
        PerVertex = 0x0
        PerModel = 0x1

    Instancing: Annotated[
        c_enum32[eInstancingEnum], Field(c_enum32[eInstancingEnum], 0x0)
    ]
    Type: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Normalise: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0x8)]
    Offset: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0x9)]
    SemanticID: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0xA)]
    Size: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0xB)]


@partial_struct
class cTkVertexLayout(Structure):
    VertexElements: Annotated[
        basic.cTkDynamicArray[cTkVertexElement],
        Field(basic.cTkDynamicArray[cTkVertexElement], 0x0),
    ]
    PlatformData: Annotated[ctypes.c_int64, Field(ctypes.c_int64, 0x10)]
    ElementCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    Stride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]


@partial_struct
class cTkMeshMetaData(Structure):
    IdString: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Hash: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    IndexDataOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    IndexDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    VertexDataOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    VertexDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    VertexPositionDataOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    VertexPositionDataSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    DoubleBufferGeometry: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cTkRagdollData(Structure):
    ChainEnds: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x0),
    ]
    ExcludeJoints: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x10),
    ]


@partial_struct
class cTkGeometryData(Structure):
    PositionVertexLayout: Annotated[cTkVertexLayout, Field(cTkVertexLayout, 0x0)]
    VertexLayout: Annotated[cTkVertexLayout, Field(cTkVertexLayout, 0x20)]
    BoundHullVertEd: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x40),
    ]
    BoundHullVerts: Annotated[
        basic.cTkDynamicArray[basic.Vector4f],
        Field(basic.cTkDynamicArray[basic.Vector4f], 0x50),
    ]
    BoundHullVertSt: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x60),
    ]
    IndexBuffer: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x70),
    ]
    JointBindings: Annotated[
        basic.cTkDynamicArray[cTkJointBindingData],
        Field(basic.cTkDynamicArray[cTkJointBindingData], 0x80),
    ]
    JointExtents: Annotated[
        basic.cTkDynamicArray[cTkJointExtentData],
        Field(basic.cTkDynamicArray[cTkJointExtentData], 0x90),
    ]
    JointMirrorAxes: Annotated[
        basic.cTkDynamicArray[cTkJointMirrorAxis],
        Field(basic.cTkDynamicArray[cTkJointMirrorAxis], 0xA0),
    ]
    JointMirrorPairs: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0xB0),
    ]
    MeshAABBMax: Annotated[
        basic.cTkDynamicArray[basic.Vector4f],
        Field(basic.cTkDynamicArray[basic.Vector4f], 0xC0),
    ]
    MeshAABBMin: Annotated[
        basic.cTkDynamicArray[basic.Vector4f],
        Field(basic.cTkDynamicArray[basic.Vector4f], 0xD0),
    ]
    MeshBaseSkinMat: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0xE0),
    ]
    MeshVertREnd: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0xF0),
    ]
    MeshVertRStart: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x100),
    ]
    ProcGenNodeNames: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x110),
    ]
    ProcGenParentId: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x120),
    ]
    SkinMatrixLayout: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x130),
    ]
    StreamMetaDataArray: Annotated[
        basic.cTkDynamicArray[cTkMeshMetaData],
        Field(basic.cTkDynamicArray[cTkMeshMetaData], 0x140),
    ]
    CollisionIndexCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x150)]
    IndexCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x154)]
    Indices16Bit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x158)]
    VertexCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x15C)]


@partial_struct
class cTkPhysicsData(Structure):
    AngularDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Friction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Gravity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LinearDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Mass: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RollingFriction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcProceduralTextureColourIndices(Structure):
    Alts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cTkAnimNodeData(Structure):
    Node: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    RotIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    ScaleIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    TransIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cTkAnimNodeFrameHalfData(Structure):
    Rotations: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint16],
        Field(basic.cTkDynamicArray[ctypes.c_uint16], 0x0),
    ]
    Scales: Annotated[
        basic.cTkDynamicArray[basic.halfVector4],
        Field(basic.cTkDynamicArray[basic.halfVector4], 0x10),
    ]
    Translations: Annotated[
        basic.cTkDynamicArray[basic.halfVector4],
        Field(basic.cTkDynamicArray[basic.halfVector4], 0x20),
    ]


@partial_struct
class cTkNGuiTreeViewTemplate(Structure):
    FilteredTextColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    HighlightColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    InactiveTextColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    LineColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    TextColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    ElementHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    IconMargin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    IconPad: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    IconWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    LineWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    NestIndent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    VerticalSplitPad: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    VerticalSplitWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    AllowVerticalSplit: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]
    FilteringHidesElements: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x71)]


@partial_struct
class cTkNGuiUserSettings(Structure):
    AnimationViewerRecents: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AnimationViewerRecentWindows: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    FileBrowserThumbnailSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]
    NguiScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x144)]
    FavouriteWindows: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x148)
    ]
    FileBrowserFavourites: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xB48)
    ]
    FileBrowserRecents: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1548)
    ]
    LastActiveLayout: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1F48)
    ]
    LastLoadedModel: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x2048)
    ]
    CanSelectRegionDecoratorNodesInDebugEditor: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x2148)
    ]
    DebugEditorDebugDrawInPlayMode: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x2149)
    ]
    FileBrowserAutoBuildTree: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x214A)]


@partial_struct
class cTkNGuiWindowLayoutData(Structure):
    ActiveTabIdx: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    PositionX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    PositionXRelative: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PositionY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    PositionYRelative: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    ScrollX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    ScrollY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Separator: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    SizeX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    SizeXRelative: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    SizeY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    SizeYRelative: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    Tabs: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x30)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x1030)]

    class eWindowStateEnum(IntEnum):
        Open = 0x0
        Minimised = 0x1
        Closed = 0x2

    WindowState: Annotated[
        c_enum32[eWindowStateEnum], Field(c_enum32[eWindowStateEnum], 0x10B0)
    ]


@partial_struct
class cTkNGuiGraphicAnimatedImageData(Structure):
    FramesPerSecond: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ScrollSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    ScrollAngle: Annotated[ctypes.c_int16, Field(ctypes.c_int16, 0x8)]
    BlendFrames: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]
    FramesHorizontal: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0xB)]
    FramesVertical: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0xC)]

    class eNGuiImageAnimTypeEnum(IntEnum):
        None_ = 0x0
        Animated = 0x1
        Scrolling = 0x2

    NGuiImageAnimType: Annotated[
        c_enum32[eNGuiImageAnimTypeEnum], Field(c_enum32[eNGuiImageAnimTypeEnum], 0xD)
    ]
    TotalFrames: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0xE)]


@partial_struct
class cTkNGuiLayoutListData(Structure):
    Default: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x20)]
    Autosave: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA0)]
    CanBeDeleted: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA1)]


@partial_struct
class cTkNGuiEditorSavedFavourite(Structure):
    Children: Annotated[
        "basic.cTkDynamicArray[cTkNGuiEditorSavedFavourite]",
        Field("basic.cTkDynamicArray[cTkNGuiEditorSavedFavourite]", 0x0),
    ]
    Name: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)]
    AddedManually: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x110)]


@partial_struct
class cTkNGuiEditorSavedTreeNodeModification(Structure):
    Children: Annotated[
        "basic.cTkDynamicArray[cTkNGuiEditorSavedTreeNodeModification]",
        Field("basic.cTkDynamicArray[cTkNGuiEditorSavedTreeNodeModification]", 0x0),
    ]
    Name: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)]
    Modified: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x110)]


@partial_struct
class cTkNGuiAlignment(Structure):
    class eHorizontalEnum(IntEnum):
        Left = 0x0
        Center = 0x1
        Right = 0x2

    Horizontal: Annotated[
        c_enum32[eHorizontalEnum], Field(c_enum32[eHorizontalEnum], 0x0)
    ]

    class eVerticalEnum(IntEnum):
        Top = 0x0
        Middle = 0x1
        Bottom = 0x2

    Vertical: Annotated[c_enum32[eVerticalEnum], Field(c_enum32[eVerticalEnum], 0x1)]


@partial_struct
class cTkNGuiEditorLayout(Structure):
    FavouriteData: Annotated[
        basic.cTkDynamicArray[cTkNGuiEditorSavedFavourite],
        Field(basic.cTkDynamicArray[cTkNGuiEditorSavedFavourite], 0x0),
    ]
    FavouriteTreeNodeChildCounts: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x10),
    ]
    FavouriteTreeNodes: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x100],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x100], 0x20),
    ]
    TreeNodeModificationData: Annotated[
        basic.cTkDynamicArray[cTkNGuiEditorSavedTreeNodeModification],
        Field(basic.cTkDynamicArray[cTkNGuiEditorSavedTreeNodeModification], 0x30),
    ]
    Windows: Annotated[cTkNGuiWindowLayoutData, Field(cTkNGuiWindowLayoutData, 0x40)]


@partial_struct
class cTkLODDistances(Structure):
    Distances: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cTkLODSettingsData(Structure):
    ImposterOverrideRange: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MaxObjectDistanceOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    RegionLODHiddenRanges: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    RegionLODRadius: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    LODAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AsteroidCountMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    AsteroidDividerMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]
    AsteroidFadeRangeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    ImposterResolutionMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    MaxAsteroidGenerationPerFrame: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x84)
    ]
    MaxAsteroidGenerationPerFramePulseJump: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x88)
    ]
    NumberOfImposterViews: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8C)]
    EnableOctahedralImposters: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x90)]
    ViewImpostersFromSpace: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x91)]


@partial_struct
class cTkNGuiEditorStyleColour(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x10)]


@partial_struct
class cTkWaterMeshConfig(Structure):
    BaseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DynamicWaveScale: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    FoamScale: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    GeometryDownSampleFactor: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    LodCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    LodDataResolution: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MaxHorizontalScaleMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    MinHorizontalScaleMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    DisableSkirtGeneration: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cTkWaveSpectrumData(Structure):
    Chop: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Wavelength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cTkAnimDetailSettingsData(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    NumCulledFrames: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    DisableAnim: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cTkAnimDetailSettings(Structure):
    AnimDistanceSettings: Annotated[
        basic.cTkDynamicArray[cTkAnimDetailSettingsData],
        Field(basic.cTkDynamicArray[cTkAnimDetailSettingsData], 0x0),
    ]
    AnimLODDistances: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxVisibleAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cTkDynamicResScalingSettings(Structure):
    class eDynamicResScalingAggressivenessEnum(IntEnum):
        Moderate = 0x0
        Balanced = 0x1
        Aggressive = 0x2

    DynamicResScalingAggressiveness: Annotated[
        c_enum32[eDynamicResScalingAggressivenessEnum],
        Field(c_enum32[eDynamicResScalingAggressivenessEnum], 0x0),
    ]
    FrametimeHeadroomProportion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LowestDynamicResScalingFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cTkEngineSettingsMapping(Structure):
    CloudsMaxIterations: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    CloudsResolutionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    IKFullBodyIterations: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ReflectionProbesMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    ShadowMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    NeedsGameRestart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]


@partial_struct
class cTkWaveInputData(Structure):
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Variance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cTkGameSettings(Structure):
    KeyMapping: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping],
        Field(basic.cTkDynamicArray[cGcInputActionMapping], 0x0),
    ]
    KeyMapping2: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x10),
    ]
    LastKnownPadType: Annotated[
        c_enum32[enums.cTkPadEnum], Field(c_enum32[enums.cTkPadEnum], 0x20)
    ]


@partial_struct
class cTkGraphicsDetailPreset(Structure):
    DynamicResScalingSettings: Annotated[
        cTkDynamicResScalingSettings, Field(cTkDynamicResScalingSettings, 0x0)
    ]

    class eAmbientOcclusionEnum(IntEnum):
        Off = 0x0
        GTAO_Low = 0x1
        GTAO_Medium = 0x2
        GTAO_High = 0x3
        GTAO_Ultra = 0x4
        HBAO_Low = 0x5
        HBAO_High = 0x6

    AmbientOcclusion: Annotated[
        c_enum32[eAmbientOcclusionEnum], Field(c_enum32[eAmbientOcclusionEnum], 0xC)
    ]
    AnimationQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x10),
    ]

    class eAnisotropyLevelEnum(IntEnum):
        _1 = 0x0
        _2 = 0x1
        _4 = 0x2
        _8 = 0x3
        _16 = 0x4

    AnisotropyLevel: Annotated[
        c_enum32[eAnisotropyLevelEnum], Field(c_enum32[eAnisotropyLevelEnum], 0x14)
    ]

    class eAntiAliasingEnum(IntEnum):
        None_ = 0x0
        TAA_LOW = 0x1
        TAA = 0x2
        FXAA = 0x3
        FFXSR2 = 0x4
        DLSS = 0x5
        DLAA = 0x6
        XESS = 0x7
        MetalFXSpatial = 0x8
        MetalFXTemporal = 0x9

    AntiAliasing: Annotated[
        c_enum32[eAntiAliasingEnum], Field(c_enum32[eAntiAliasingEnum], 0x18)
    ]
    BaseQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x1C),
    ]

    class eDLSSFrameGenerationEnum(IntEnum):
        On2X = 0x0
        Off = 0x1
        On3X = 0x2
        On4X = 0x3

    DLSSFrameGeneration: Annotated[
        c_enum32[eDLSSFrameGenerationEnum],
        Field(c_enum32[eDLSSFrameGenerationEnum], 0x20),
    ]

    class eDLSSQualityEnum(IntEnum):
        MaxPerformance = 0x0
        Balanced = 0x1
        MaxQuality = 0x2
        UltraPerformance = 0x3
        UltraQuality = 0x4

    DLSSQuality: Annotated[
        c_enum32[eDLSSQualityEnum], Field(c_enum32[eDLSSQualityEnum], 0x24)
    ]

    class eFFXSR2QualityEnum(IntEnum):
        UltraPerformance = 0x0
        Performance = 0x1
        Balanced = 0x2
        Quality = 0x3
        Native = 0x4

    FFXSR2Quality: Annotated[
        c_enum32[eFFXSR2QualityEnum], Field(c_enum32[eFFXSR2QualityEnum], 0x28)
    ]

    class eFFXSRQualityEnum(IntEnum):
        Off = 0x0
        UltraQuality = 0x1
        Quality = 0x2
        Balanced = 0x3
        Performance = 0x4

    FFXSRQuality: Annotated[
        c_enum32[eFFXSRQualityEnum], Field(c_enum32[eFFXSRQualityEnum], 0x2C)
    ]

    class eMetalFXModeEnum(IntEnum):
        Off = 0x0
        Spatial = 0x1
        Temporal = 0x2

    MetalFXMode: Annotated[
        c_enum32[eMetalFXModeEnum], Field(c_enum32[eMetalFXModeEnum], 0x30)
    ]

    class eMetalFXQualityEnum(IntEnum):
        UltraQuality = 0x0
        Quality = 0x1
        Balanced = 0x2
        Performance = 0x3

    MetalFXQuality: Annotated[
        c_enum32[eMetalFXQualityEnum], Field(c_enum32[eMetalFXQualityEnum], 0x34)
    ]

    class eNVIDIAReflexLowLatencyEnum(IntEnum):
        On = 0x0
        Off = 0x1
        OnWithBoost = 0x2

    NVIDIAReflexLowLatency: Annotated[
        c_enum32[eNVIDIAReflexLowLatencyEnum],
        Field(c_enum32[eNVIDIAReflexLowLatencyEnum], 0x38),
    ]
    PlanetQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x3C),
    ]
    PostProcessingEffects: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x40),
    ]
    ReflectionsQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x44),
    ]
    ShadowQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x48),
    ]
    TerrainTessellation: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x4C),
    ]
    TextureQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x50),
    ]

    class eUIQualityEnum(IntEnum):
        Normal = 0x0
        _4K = 0x1

    UIQuality: Annotated[
        c_enum32[eUIQualityEnum], Field(c_enum32[eUIQualityEnum], 0x54)
    ]
    VolumetricsQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x58),
    ]
    WaterQuality: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x5C),
    ]

    class eXESSQualityEnum(IntEnum):
        UltraPerformance = 0x0
        Performance = 0x1
        Balanced = 0x2
        Quality = 0x3
        UltraQuality = 0x4
        UltraQualityPlus = 0x5
        Native = 0x6

    XESSQuality: Annotated[
        c_enum32[eXESSQualityEnum], Field(c_enum32[eXESSQualityEnum], 0x60)
    ]


@partial_struct
class cTkNetEntityRefComponentData(Structure):
    Reference: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cTkProceduralInstanceData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cTkProceduralInstance(Structure):
    Data: Annotated[cTkProceduralInstanceData, Field(cTkProceduralInstanceData, 0x0)]


@partial_struct
class cTkFoamProperties(Structure):
    FoamBlurFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FoamFadeRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    ShorelineFoamFadeDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ShorelineFoamMidpointDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    ShorelineFoamSaturateDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    WaveFoamBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    WaveFoamGenerationStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    WaveFoamSensitivity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cTkMeshWaterQualitySettingData(Structure):
    WaterMeshConfig: Annotated[cTkWaterMeshConfig, Field(cTkWaterMeshConfig, 0x0)]
    EnableDetailNormals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    EnableDynamicWaves: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    EnableFoam: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    EnableLocalTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]
    PostProcessWater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    RainDropEffect: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]


@partial_struct
class cTkProceduralModelComponentData(Structure):
    List: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cTkMeshWaterReflectionQualitySettingData(Structure):
    class ePlanarReflectionsEnum(IntEnum):
        Off = 0x0
        TerrainOnly = 0x1
        TerrainAndScreenspace = 0x2

    PlanarReflections: Annotated[
        c_enum32[ePlanarReflectionsEnum], Field(c_enum32[ePlanarReflectionsEnum], 0x0)
    ]

    class eScreenSpaceReflectionsEnum(IntEnum):
        Off = 0x0
        On = 0x1

    ScreenSpaceReflections: Annotated[
        c_enum32[eScreenSpaceReflectionsEnum],
        Field(c_enum32[eScreenSpaceReflectionsEnum], 0x4),
    ]


@partial_struct
class cTkProceduralModelList(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    List: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x10),
    ]


@partial_struct
class cTkReferenceComponentData(Structure):
    LSystem: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Reference: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]


@partial_struct
class cTkShearWindOctaveData(Structure):
    MaxStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MinStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    StrengthVariationFreq: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    WaveFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    WaveSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cTkShearWindData(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Octave0: Annotated[cTkShearWindOctaveData, Field(cTkShearWindOctaveData, 0x10)]
    Octave1: Annotated[cTkShearWindOctaveData, Field(cTkShearWindOctaveData, 0x24)]
    Octave2: Annotated[cTkShearWindOctaveData, Field(cTkShearWindOctaveData, 0x38)]
    Octave3: Annotated[cTkShearWindOctaveData, Field(cTkShearWindOctaveData, 0x4C)]
    LdsWindSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    LdsWindStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    OverallWindStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    ShearWindSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    WindShearGradientStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    WindShearToDotLdsFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    WindShearVertpushStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    WindStrengthToVertpush: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]


@partial_struct
class cTkResourceFilterData(Structure):
    FilteredResources: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x0),
    ]
    FilterName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkResourceFilterList(Structure):
    Filters: Annotated[
        basic.cTkDynamicArray[cTkResourceFilterData],
        Field(basic.cTkDynamicArray[cTkResourceFilterData], 0x0),
    ]


@partial_struct
class cTkRotationComponentData(Structure):
    Axis: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SyncGroup: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    AlwaysUpdate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cTkResourceDescriptorData(Structure):
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Children: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x20),
    ]
    ReferencePaths: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x30),
    ]
    Chance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x44)]


@partial_struct
class cTkResourceDescriptorList(Structure):
    Descriptors: Annotated[
        basic.cTkDynamicArray[cTkResourceDescriptorData],
        Field(basic.cTkDynamicArray[cTkResourceDescriptorData], 0x0),
    ]
    TypeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkAllowedWaterConditions(Structure):
    ConditionWeights: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cTkModelDescriptorList(Structure):
    List: Annotated[
        basic.cTkDynamicArray[cTkResourceDescriptorList],
        Field(basic.cTkDynamicArray[cTkResourceDescriptorList], 0x0),
    ]


@partial_struct
class cTkDynamicChainComponentData(Structure):
    IgnoreJoints: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x0),
    ]
    AirThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AngularDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AngularLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    BodyMassChange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Gravity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    InitialBodyMass: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    LinearDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    MaxMotorForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MotorStrengthCone: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MotorStrengthTwist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    TwistLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    VertAirThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    WindStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    WeightByJointLength: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]


@partial_struct
class cTkRigidBodyComponentData(Structure):
    Properties: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]

    class eTargetNodeEnum(IntEnum):
        Model = 0x0
        MasterModel = 0x1
        Attachment = 0x2

    TargetNode: Annotated[
        c_enum32[eTargetNodeEnum], Field(c_enum32[eTargetNodeEnum], 0x10)
    ]
    TriggerVolumeType: Annotated[
        c_enum32[enums.cTkVolumeTriggerType],
        Field(c_enum32[enums.cTkVolumeTriggerType], 0x14),
    ]
    AddToWorldImmediately: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    AddToWorldOnPrepare: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]
    TriggerVolume: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A)]


@partial_struct
class cTkDynamicPhysicsComponentData(Structure):
    RigidBody: Annotated[
        cTkRigidBodyComponentData, Field(cTkRigidBodyComponentData, 0x0)
    ]
    Data: Annotated[cTkPhysicsData, Field(cTkPhysicsData, 0x20)]

    class ePhysicsSurfacePropertiesEnum(IntEnum):
        None_ = 0x0
        Glass = 0x1

    PhysicsSurfaceProperties: Annotated[
        c_enum32[ePhysicsSurfacePropertiesEnum],
        Field(c_enum32[ePhysicsSurfacePropertiesEnum], 0x38),
    ]
    SimpleCharacterCollisionFwdOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3C)
    ]
    SimpleCharacterCollisionHeight: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x40)
    ]
    SimpleCharacterCollisionHeightOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x44)
    ]
    SimpleCharacterCollisionRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x48)
    ]
    SpinOnCreate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    TriggerVolumeType: Annotated[
        c_enum32[enums.cTkVolumeTriggerType],
        Field(c_enum32[enums.cTkVolumeTriggerType], 0x50),
    ]
    Animated: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]
    DisableGravity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x55)]
    RotateSimpleCharacterCollisionCapsule: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x56)
    ]
    TriggerVolume: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x57)]
    UseSimpleCharacterCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]


@partial_struct
class cTkInstanceWindComponentData(Structure):
    BaseMass: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BaseSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LinearDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MassReduction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    SpringLengthFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SpringNonDirFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SpringReduction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    EnableLdsWind: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cTkNavModifierComponentData(Structure):
    NavMeshInclusion: Annotated[
        cTkNavMeshInclusionParams, Field(cTkNavMeshInclusionParams, 0x0)
    ]


@partial_struct
class cTkPhysicsWorldComponentData(Structure):
    MaximumNumberOfBodies: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    SafeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cTkCreatureTailJoints(Structure):
    InterpSpeedHead: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    InterpSpeedTail: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    PullSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PullSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    StrengthX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    StrengthY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    StrengthZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SwimPhaseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    EndJoint: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    StartJoint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]


@partial_struct
class cTkCreatureTailParams(Structure):
    PartName: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Joints: Annotated[
        basic.cTkDynamicArray[cTkCreatureTailJoints],
        Field(basic.cTkDynamicArray[cTkCreatureTailJoints], 0x20),
    ]
    PerBoneSwimStrength: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x30),
    ]
    AnimationMix: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MaxTurnForSwim: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinSwimStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    SwimBlendInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    SwimBlendOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    SwimFallOffBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    SwimFallOffEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    SwimMagnitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    SwimReps: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    SwimRollMagnitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    SwimSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    SwimTurn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    HorizontalStrokes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]


@partial_struct
class cTkNamedAudioIdArray(Structure):
    Values: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0x0),
    ]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x10)]


@partial_struct
class cTkNamedAudioIdArrayTable(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[cTkNamedAudioIdArray],
        Field(basic.cTkDynamicArray[cTkNamedAudioIdArray], 0x0),
    ]


@partial_struct
class cTkAnimStateMachineComponentData(Structure):
    InitialStateMachine: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cTkAudioAnimTrigger(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OnlyValidWithParts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x10),
    ]

    class eAudioTypeEnum(IntEnum):
        Standard = 0x0
        CreatureVocal = 0x1
        CreatureSnore = 0x2
        Projectile = 0x3

    AudioType: Annotated[
        c_enum32[eAudioTypeEnum], Field(c_enum32[eAudioTypeEnum], 0x20)
    ]
    FrameStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    Sound: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x28)]


@partial_struct
class cTkAudioEmitterLine(Structure):
    End: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Start: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cTkAnimationAttachmentData(Structure):
    AnimGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cTkCameraAttachmentData(Structure):
    BaseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    OffsetScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cTkAudioIDArray(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0x0),
    ]


@partial_struct
class cTkAnimStateMachineParameterTrigger(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Default: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cTkAnimStateMachineTransitionConditionBoolData(Structure):
    Parameter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CompareValue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cTkAnimStateMachineTransitionConditionFloatData(Structure):
    Parameter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CompareValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]

    class eFloatComparisonModeEnum(IntEnum):
        LessThan = 0x0
        LessThanEqual = 0x1
        GreaterThanEqual = 0x2
        GreaterThan = 0x3

    FloatComparisonMode: Annotated[
        c_enum32[eFloatComparisonModeEnum],
        Field(c_enum32[eFloatComparisonModeEnum], 0x14),
    ]


@partial_struct
class cTkAnimStateMachineTransitionConditionIntData(Structure):
    Parameter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CompareValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]

    class eIntComparisonModeEnum(IntEnum):
        LessThan = 0x0
        LessThanEqual = 0x1
        Equal = 0x2
        GreaterThanEqual = 0x3
        GreaterThan = 0x4

    IntComparisonMode: Annotated[
        c_enum32[eIntComparisonModeEnum], Field(c_enum32[eIntComparisonModeEnum], 0x14)
    ]


@partial_struct
class cTkAnimStateMachineTransitionConditionStateTimeData(Structure):
    MaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cTkWeightedAnim(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cTkAnimStateMachineParameterBool(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Default: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cTkWeightedAnimLibrary(Structure):
    Anims: Annotated[
        basic.cTkDynamicArray[cTkWeightedAnim],
        Field(basic.cTkDynamicArray[cTkWeightedAnim], 0x0),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkAnimStateMachineParameterFloat(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Default: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cTkAnimStateMachineParameterInt(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Default: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cTkAnimPoseData(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FrameEnd: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    FrameStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cTkAnimPoseExampleElement(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cTkAnimPoseExampleData(Structure):
    Elements: Annotated[
        basic.cTkDynamicArray[cTkAnimPoseExampleElement],
        Field(basic.cTkDynamicArray[cTkAnimPoseExampleElement], 0x0),
    ]


@partial_struct
class cTkAnimRandomOneShots(Structure):
    List: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Parent: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DelayMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    DelayMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cTkAnimationNotifyAddEffect(Structure):
    CharacterLocator: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Modules: Annotated[
        basic.cTkDynamicArray[basic.LinkableNMSTemplate],
        Field(basic.cTkDynamicArray[basic.LinkableNMSTemplate], 0x20),
    ]
    FacingDirOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    Node: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x38)]
    Attach: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]
    MirrorDuplicate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x79)]
    UseModelFacingDir: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7A)]


@partial_struct
class cTkAnimationNotifyAddEffectGroundInteraction(Structure):
    FadeOutHeightBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FadeOutHeightEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    TravelSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ClampToGround: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]
    UseGroundNormal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD)]
    UseWaterSurface: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE)]


@partial_struct
class cTkAnimationNotifyGeneric(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cTkAnimJointLODData(Structure):
    JointNames: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0x0),
    ]
    LOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cTkAnimMaskBone(Structure):
    NameHash: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    RotationWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    TranslationWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Name: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xC)]
    ChildrenInheritWeights: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]
    LinkWeights: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]


@partial_struct
class cTkAnimationAction(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    EndFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    StartFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkAnimMask(Structure):
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Bones: Annotated[
        basic.cTkDynamicArray[cTkAnimMaskBone],
        Field(basic.cTkDynamicArray[cTkAnimMaskBone], 0x20),
    ]


@partial_struct
class cTkAnimationMask(Structure):
    Mask: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]

    class eAnimMaskTypeEnum(IntEnum):
        UpperBody = 0x0

    AnimMaskType: Annotated[
        c_enum32[eAnimMaskTypeEnum], Field(c_enum32[eAnimMaskTypeEnum], 0x20)
    ]


@partial_struct
class cTkAnimationNotify(Structure):
    Data: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]
    EndFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    StartFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Track: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cTkAnimationGameData(Structure):
    class eRootMotionEnum(IntEnum):
        None_ = 0x0
        EnabledWithGravity = 0x1
        EnabledFullControl = 0x2

    RootMotion: Annotated[
        c_enum32[eRootMotionEnum], Field(c_enum32[eRootMotionEnum], 0x0)
    ]
    BlockPlayerMovement: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]

    class eBlockPlayerWeaponEnum(IntEnum):
        Unblocked = 0x0
        Sheathed = 0x1
        OutButCannotFire = 0x2

    BlockPlayerWeapon: Annotated[
        c_enum32[eBlockPlayerWeaponEnum], Field(c_enum32[eBlockPlayerWeaponEnum], 0x8)
    ]


@partial_struct
class cTkAnimMaskTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cTkAnimMask],
        Field(basic.cTkDynamicArray[cTkAnimMask], 0x0),
    ]


@partial_struct
class cTkAnimationData(Structure):
    Mask: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Actions: Annotated[
        basic.cTkDynamicArray[cTkAnimationAction],
        Field(basic.cTkDynamicArray[cTkAnimationAction], 0x20),
    ]
    AdditionalMasks: Annotated[
        basic.cTkDynamicArray[cTkAnimationMask],
        Field(basic.cTkDynamicArray[cTkAnimationMask], 0x30),
    ]
    AdditiveBaseAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    ExtraStartNodes: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0x60),
    ]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)]
    Notifies: Annotated[
        basic.cTkDynamicArray[cTkAnimationNotify],
        Field(basic.cTkDynamicArray[cTkAnimationNotify], 0x80),
    ]
    GameData: Annotated[cTkAnimationGameData, Field(cTkAnimationGameData, 0x90)]
    ActionFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    ActionStartFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    AdditiveBaseFrame: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]

    class eAnimTypeEnum(IntEnum):
        Loop = 0x0
        OneShot = 0x1
        OneShotBlendable = 0x2
        Control = 0x3

    AnimType: Annotated[c_enum32[eAnimTypeEnum], Field(c_enum32[eAnimTypeEnum], 0xA8)]

    class eCreatureSizeEnum(IntEnum):
        AllSizes = 0x0
        SmallOnly = 0x1
        LargeOnly = 0x2

    CreatureSize: Annotated[
        c_enum32[eCreatureSizeEnum], Field(c_enum32[eCreatureSizeEnum], 0xAC)
    ]
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    FrameEnd: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB4)]
    FrameEndGame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB8)]
    FrameStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xBC)]
    OffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    OffsetMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    Priority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC8)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    StartNode: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xD0)
    ]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x110)]
    Additive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x111)]
    AnimGroupOverride: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x112)]
    Has30HzFrames: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x113)]
    Mirrored: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x114)]


@partial_struct
class cTkAnimPoseBabyModifier(Structure):
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkAnimPoseCorrelationData(Structure):
    ItemA: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ItemB: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Correlation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcWonderRecordCustomData(Structure):
    ActualType: Annotated[
        c_enum32[enums.cGcWonderType], Field(c_enum32[enums.cGcWonderType], 0x0)
    ]
    CustomName: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x4)
    ]


@partial_struct
class cTkAnim2dBlendNodeData(Structure):
    Position: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    BlendChild: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x8)]


@partial_struct
class cTkAnim2dBlendNode(Structure):
    NodeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PositionIn: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)
    ]
    PositionRangeBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    PositionRangeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    PositionSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    PositionCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x5C)
    ]
    SelectBlend: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5D)]
    SelectBlendSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    PolarInputInterpolation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]
    PolarInputLimitCentre: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    PolarInputLimitExtent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]

    class eCoordinatesEnum(IntEnum):
        Polar = 0x0
        Cartesian = 0x1

    Coordinates: Annotated[
        c_enum32[eCoordinatesEnum], Field(c_enum32[eCoordinatesEnum], 0x70)
    ]

    class eBlendOpEnum(IntEnum):
        Blend = 0x0
        Add = 0x1

    BlendOp: Annotated[c_enum32[eBlendOpEnum], Field(c_enum32[eBlendOpEnum], 0x74)]
    BlendChildren: Annotated[
        basic.cTkDynamicArray[cTkAnim2dBlendNodeData],
        Field(basic.cTkDynamicArray[cTkAnim2dBlendNodeData], 0x78),
    ]


@partial_struct
class cTkAnimAnimNode(Structure):
    DisplayName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    AnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    PhaseIn: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x30)]
    PhaseCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x70)
    ]
    PhaseRangeBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    PhaseRangeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    SyncGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]

    class eSyncGroupRoleEnum(IntEnum):
        CanBeLeader = 0x0
        AlwaysLeader = 0x1
        NeverLeader = 0x2

    SyncGroupRole: Annotated[
        c_enum32[eSyncGroupRoleEnum], Field(c_enum32[eSyncGroupRoleEnum], 0x90)
    ]


@partial_struct
class cTkAnimBlendNode(Structure):
    NodeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    WeightIn: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)]
    WeightRangeBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    WeightRangeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    WeightSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    WeightCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x5C)
    ]
    InitialWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    BlendLeft: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x68)]
    BlendRight: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x78)]


@partial_struct
class cTkAnimVectorBlendNodeData(Structure):
    NodeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    WeightIn: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)]
    WeightRangeBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    WeightRangeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    WeightSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    WeightCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x5C)
    ]
    InitialWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    BlendChild: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x68)]


@partial_struct
class cTkAnimVectorBlendNode(Structure):
    BlendChildren: Annotated[
        basic.cTkDynamicArray[cTkAnimVectorBlendNodeData],
        Field(basic.cTkDynamicArray[cTkAnimVectorBlendNodeData], 0x0),
    ]
    NodeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eBlendOperationEnum(IntEnum):
        Blend = 0x0
        Add = 0x1

    BlendOperation: Annotated[
        c_enum32[eBlendOperationEnum], Field(c_enum32[eBlendOperationEnum], 0x20)
    ]


@partial_struct
class cGcWonderRecord(Structure):
    GenerationID: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    WonderStatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SeenInFrontend: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcID256Enum(Structure):
    Values: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x0),
    ]


@partial_struct
class cGcStoryPageSeenData(Structure):
    LastSeenEntryIdx: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    PageIdx: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcStoryPageSeenDataArray(Structure):
    PagesData: Annotated[
        basic.cTkDynamicArray[cGcStoryPageSeenData],
        Field(basic.cTkDynamicArray[cGcStoryPageSeenData], 0x0),
    ]


@partial_struct
class cGcIDLookupPath(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Path: Annotated[basic.cTkFixedString0x800, Field(basic.cTkFixedString0x800, 0x10)]
    DescriptionField: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x810)
    ]
    ImageField: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x890)
    ]
    NameField: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x910)
    ]
    SubTitleField: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x990)
    ]
    GlobalSort: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA10)]


@partial_struct
class cGcWikiPage(Structure):
    PageID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    ContentImage: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x38)]
    Content: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x50)]
    VRAnyHandControlContent: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x90)
    ]
    VRContent: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xD0)
    ]
    VRMoveControllerContent: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x110)
    ]


@partial_struct
class cGcIDLookupPaths(Structure):
    Paths: Annotated[
        basic.cTkDynamicArray[cGcIDLookupPath],
        Field(basic.cTkDynamicArray[cGcIDLookupPath], 0x0),
    ]


@partial_struct
class cGcCompositeCurveElementData(Structure):
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    EndValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CurveType: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x8)
    ]


@partial_struct
class cGcCompositeCurveData(Structure):
    Elements: Annotated[
        basic.cTkDynamicArray[cGcCompositeCurveElementData],
        Field(basic.cTkDynamicArray[cGcCompositeCurveElementData], 0x0),
    ]
    StartValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcShipDataNames(Structure):
    ResourceName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)
    ]
    DataName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x100)
    ]


@partial_struct
class cGcStoryEntryBranch(Structure):
    Entry: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    RequiresMission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ConditionMissionComplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcVibrationData(Structure):
    DecayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    OutputStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    SmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Variance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    VarianceContrast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    OutputStrengthCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x14)
    ]


@partial_struct
class cGcWonderCategoryConfig(Structure):
    LocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    StatID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ThresholdValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eWonderCategoryComparisonTypeEnum(IntEnum):
        Max = 0x0
        Min = 0x1

    WonderCategoryComparisonType: Annotated[
        c_enum32[eWonderCategoryComparisonTypeEnum],
        Field(c_enum32[eWonderCategoryComparisonTypeEnum], 0x34),
    ]


@partial_struct
class cGcVibrationChannelData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Data: Annotated[cGcVibrationData, Field(cGcVibrationData, 0x10)]

    class eVRAffectedHandsEnum(IntEnum):
        Both = 0x0
        LeftOnly = 0x1
        RightOnly = 0x2
        DisableInVR = 0x3

    VRAffectedHands: Annotated[
        c_enum32[eVRAffectedHandsEnum], Field(c_enum32[eVRAffectedHandsEnum], 0x40)
    ]
    VROnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    VRSwapHandForLeftHanded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]


@partial_struct
class cGcPhotoModeAdjustData(Structure):
    AdjustMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AdjustMaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AdjustMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AdjustMaxCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xC)
    ]
    AdjustMinCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xD)
    ]
    Inverted: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE)]


@partial_struct
class cGcPhotoModeSettings(Structure):
    SunDir: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x0)]
    Bloom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    CloudAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DepthOfFieldDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DepthOfFieldDistanceSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    DepthOfFieldPhysAperture: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    DepthOfFieldPhysConvergence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]

    class eDepthOfFieldSettingEnum(IntEnum):
        Off = 0x0
        Mid = 0x1
        On = 0x2
        Macro = 0x3

    DepthOfFieldSetting: Annotated[
        c_enum32[eDepthOfFieldSettingEnum],
        Field(c_enum32[eDepthOfFieldSettingEnum], 0x28),
    ]
    Filter: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    Fog: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FoV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    HalfFocalPlaneDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    HalfFocalPlaneDepthSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    Vignette: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcSurvivalBarBoolArray(Structure):
    Values: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcGyroSettingsData(Structure):
    Acceleration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eActiveModeInExocraftEnum(IntEnum):
        None_ = 0x0
        Firing = 0x1
        Always = 0x2

    ActiveModeInExocraft: Annotated[
        c_enum32[eActiveModeInExocraftEnum],
        Field(c_enum32[eActiveModeInExocraftEnum], 0x4),
    ]

    class eActiveModeOnFootEnum(IntEnum):
        None_ = 0x0
        ScopeOnly = 0x1
        ScopeOrFiring = 0x2
        Always = 0x3

    ActiveModeOnFoot: Annotated[
        c_enum32[eActiveModeOnFootEnum], Field(c_enum32[eActiveModeOnFootEnum], 0x8)
    ]

    class eActiveModeWhenBuildingEnum(IntEnum):
        None_ = 0x0
        BuildPlacementOnly = 0x1
        SelectionModeOnly = 0x2
        Always = 0x3

    ActiveModeWhenBuilding: Annotated[
        c_enum32[eActiveModeWhenBuildingEnum],
        Field(c_enum32[eActiveModeWhenBuildingEnum], 0xC),
    ]
    AimingMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BuildingMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]

    class eCursorLookStickEnabledEnum(IntEnum):
        None_ = 0x0
        Disabled = 0x1

    CursorLookStickEnabled: Annotated[
        c_enum32[eCursorLookStickEnabledEnum],
        Field(c_enum32[eCursorLookStickEnabledEnum], 0x18),
    ]
    CursorSensitivityX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    CursorSensitivityY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    CursorTighteningThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Deadzone: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]

    class eEnableGyroInBuildingFreeCamEnum(IntEnum):
        Never = 0x0
        MatchActiveModeWhenBuilding = 0x1
        Always = 0x2

    EnableGyroInBuildingFreeCam: Annotated[
        c_enum32[eEnableGyroInBuildingFreeCamEnum],
        Field(c_enum32[eEnableGyroInBuildingFreeCamEnum], 0x2C),
    ]
    ExocraftMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eGyroRotationSpaceEnum(IntEnum):
        Local = 0x0
        Player = 0x1

    GyroRotationSpace: Annotated[
        c_enum32[eGyroRotationSpaceEnum], Field(c_enum32[eGyroRotationSpaceEnum], 0x34)
    ]

    class eGyroRotationSpaceHandheldEnum(IntEnum):
        Local = 0x0
        Player = 0x1

    GyroRotationSpaceHandheld: Annotated[
        c_enum32[eGyroRotationSpaceHandheldEnum],
        Field(c_enum32[eGyroRotationSpaceHandheldEnum], 0x38),
    ]

    class eHandednessEnum(IntEnum):
        Left = 0x0
        Right = 0x1

    Handedness: Annotated[
        c_enum32[eHandednessEnum], Field(c_enum32[eHandednessEnum], 0x3C)
    ]

    class eLookStickEnabledEnum(IntEnum):
        None_ = 0x0
        Disabled = 0x1
        Enabled = 0x2

    LookStickEnabled: Annotated[
        c_enum32[eLookStickEnabledEnum], Field(c_enum32[eLookStickEnabledEnum], 0x40)
    ]

    class ePitchAxisDirectionEnum(IntEnum):
        Disabled = 0x0
        Standard = 0x1
        Inverted = 0x2

    PitchAxisDirection: Annotated[
        c_enum32[ePitchAxisDirectionEnum],
        Field(c_enum32[ePitchAxisDirectionEnum], 0x44),
    ]

    class eRollAxisDirectionEnum(IntEnum):
        Disabled = 0x0
        Standard = 0x1
        Inverted = 0x2

    RollAxisDirection: Annotated[
        c_enum32[eRollAxisDirectionEnum], Field(c_enum32[eRollAxisDirectionEnum], 0x48)
    ]
    ScopeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    SensitivityX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    SensitivityY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    SmoothingThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    SmoothingWindow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    Steadying: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    TighteningThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]

    class eYawAxisDirectionEnum(IntEnum):
        Disabled = 0x0
        Standard = 0x1
        Inverted = 0x2

    YawAxisDirection: Annotated[
        c_enum32[eYawAxisDirectionEnum], Field(c_enum32[eYawAxisDirectionEnum], 0x68)
    ]
    AllowWhenRidingCreatures: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6C)]
    EnableAdvancedOptions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6D)]
    FilterControllerVibrations: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6E)]
    GyroCursorEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6F)]
    GyroEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]
    GyroEnabledHandheld: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x71)]
    ZoomScalesSensitivity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x72)]


@partial_struct
class cGcTriggerFeedbackState(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Data: Annotated[cTkTriggerFeedbackData, Field(cTkTriggerFeedbackData, 0x10)]
    Action: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x20)
    ]


@partial_struct
class cGcItemShopAvailabilityDifficultyOptionData(Structure):
    NeverSoldItems: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcDifficultySettingUIOption(Structure):
    AlsoChangeOptions: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcDifficultySettingEnum]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcDifficultySettingEnum]], 0x0),
    ]
    MainOption: Annotated[
        c_enum32[enums.cGcDifficultySettingEnum],
        Field(c_enum32[enums.cGcDifficultySettingEnum], 0x10),
    ]


@partial_struct
class cGcDifficultyOptionUIGroup(Structure):
    HeadingLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    DifficultyOptions: Annotated[
        basic.cTkDynamicArray[cGcDifficultySettingUIOption],
        Field(basic.cTkDynamicArray[cGcDifficultySettingUIOption], 0x20),
    ]


@partial_struct
class cGcDifficultySettingCommonData(Structure):
    DescriptionLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    TitleLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    ToggleDisabledLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    ToggleEnabledLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    EditabilityInOptionsMenu: Annotated[
        c_enum32[enums.cGcDifficultySettingEditability],
        Field(c_enum32[enums.cGcDifficultySettingEditability], 0x80),
    ]
    SettingType: Annotated[
        c_enum32[enums.cGcDifficultySettingType],
        Field(c_enum32[enums.cGcDifficultySettingType], 0x84),
    ]
    IsAscendingDifficulty: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x88)]


@partial_struct
class cGcDifficultySettingLocData(Structure):
    DescriptionLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    TitleLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]


@partial_struct
class cGcDifficultyCurrencyCostOptionData(Structure):
    Multipliers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    TradeBuyPriceMarkupMod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FreeCostTypes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    CostManagerCostsAreFree: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x13)]
    InteractionsCostsAreFree: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcDifficultyFuelUseTechOverride(Structure):
    TechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Multiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcDifficultyFuelUseOptionData(Structure):
    TechOverrides: Annotated[
        basic.cTkDynamicArray[cGcDifficultyFuelUseTechOverride],
        Field(basic.cTkDynamicArray[cGcDifficultyFuelUseTechOverride], 0x0),
    ]
    Multiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcDifficultyInventoryStackSizeOptionData(Structure):
    MaxProductStackSizes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MaxSubstanceStackSizes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    ProductStackLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    SubstanceStackLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x6C)]


@partial_struct
class cGcInWorldUIScreenData(Structure):
    ScreenOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    ScreenRotation: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x10)]
    ScreenScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcBlockedMessage(Structure):
    MessageId: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x0)]


@partial_struct
class cGcBlockedUser(Structure):
    UserId: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x0)]
    Username: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x40)]
    Platform: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)]


@partial_struct
class cGcBlockListPersistence(Structure):
    ListSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MessageListSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    MessageNextSlot: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    NextSlot: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    BlockedUserArray: Annotated[cGcBlockedUser, Field(cGcBlockedUser, 0x10)]
    BlockedMessageArray: Annotated[cGcBlockedMessage, Field(cGcBlockedMessage, 0x1F50)]


@partial_struct
class cGcSpringWeightModifyingAnim(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DesiredWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    IncludeBlendOut: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcSpringLink(Structure):
    AngularLimitMaxDeg: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    AngularLimitMinDeg: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    AngularMotionLimitBounciness: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    AngularMotionScale: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    CentreOfMassLocal: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    MotionLimitBounciness: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x50)]
    MotionLimitMax: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x60)]
    MotionLimitMin: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x70)]
    MotionScale: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x80)]
    PivotAnchorLocal: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x90)]
    PivotLocal: Annotated[basic.Vector3f, Field(basic.Vector3f, 0xA0)]
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0xB0)]
    LinkWeightModifyingAnims: Annotated[
        basic.cTkDynamicArray[cGcSpringWeightModifyingAnim],
        Field(basic.cTkDynamicArray[cGcSpringWeightModifyingAnim], 0xD0),
    ]
    NodeNames: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0xE0),
    ]
    AirSpeedFromMovementSpeedScale: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF0)
    ]
    AngularDampingCriticality: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    AngularMotionScale_Uniform: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    AngularNaturalFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]

    class eApplyAngularLimitsInEnum(IntEnum):
        Disabled = 0x0
        Itself = 0x1
        Parent = 0x2
        Component = 0x3

    ApplyAngularLimitsIn: Annotated[
        c_enum32[eApplyAngularLimitsInEnum],
        Field(c_enum32[eApplyAngularLimitsInEnum], 0x100),
    ]

    class eApplyAngularMotionScaleInEnum(IntEnum):
        Disabled = 0x0
        Uniform = 0x1
        Itself = 0x2
        Parent = 0x3
        Component = 0x4

    ApplyAngularMotionScaleIn: Annotated[
        c_enum32[eApplyAngularMotionScaleInEnum],
        Field(c_enum32[eApplyAngularMotionScaleInEnum], 0x104),
    ]
    ApplyAngularSpringInMovingFrame: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x108)
    ]
    ApplyGameGravity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10C)]
    ApplyGameWind: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x110)]
    ApplyInfluenceOfTranslationInMovingFrame: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x114)
    ]

    class eApplyMotionLimitsInEnum(IntEnum):
        Disabled = 0x0
        Uniform = 0x1
        Itself = 0x2
        Parent = 0x3
        Component = 0x4

    ApplyMotionLimitsIn: Annotated[
        c_enum32[eApplyMotionLimitsInEnum],
        Field(c_enum32[eApplyMotionLimitsInEnum], 0x118),
    ]

    class eApplyMotionScaleInEnum(IntEnum):
        Disabled = 0x0
        Uniform = 0x1
        Itself = 0x2
        Parent = 0x3
        Component = 0x4

    ApplyMotionScaleIn: Annotated[
        c_enum32[eApplyMotionScaleInEnum],
        Field(c_enum32[eApplyMotionScaleInEnum], 0x11C),
    ]
    DampingCriticality: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x120)]
    DistanceWhereRotationMatchesLinear: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x124)
    ]
    InfluenceOfTranslation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x128)]

    class eLinkWeightModeEnum(IntEnum):
        AlwaysOn = 0x0
        DefaultOn = 0x1
        DefaultOff = 0x2

    LinkWeightMode: Annotated[
        c_enum32[eLinkWeightModeEnum], Field(c_enum32[eLinkWeightModeEnum], 0x12C)
    ]
    LinkWeightModifyTimeActive: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x130)]
    LinkWeightModifyTimeInactive: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x134)
    ]
    MaximumSpeedFeltByDynamics: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x138)]
    MotionLimit_MaxDetachmentDistance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x13C)
    ]
    MotionScale_Uniform: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]
    NaturalFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x144)]

    class ePivotAnchorsToEnum(IntEnum):
        Itself = 0x0
        Parent = 0x1
        Node = 0x2
        NodeWithAnchor = 0x3

    PivotAnchorsTo: Annotated[
        c_enum32[ePivotAnchorsToEnum], Field(c_enum32[ePivotAnchorsToEnum], 0x148)
    ]
    SpringHangsDown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14C)]
    Name: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x150)]
    PivotAnchorNode: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x190)
    ]
    AngularSpringEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D0)]
    ApplySpringInMovingFrame: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D1)]
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D2)]
    PositionalSpringEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D3)]
    SpringCollides: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D4)]
    SpringPivots: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D5)]


@partial_struct
class cGcVehicleScanTableEntry(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    RequiredTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x38)]
    ScanList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x48),
    ]


@partial_struct
class cGcCamouflageData(Structure):
    CamouflageMaterial: Annotated[cTkMaterialResource, Field(cTkMaterialResource, 0x0)]
    DissolveTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DissolveTimeVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    FadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FadeOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    LowQualityBrightnessMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x28)
    ]
    LowQualityFresnelModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]


@partial_struct
class cGcVehicleMuzzleData(Structure):
    MuzzleFlashDataID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcPlayerWeaponData(Structure):
    Reticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcVehicleWeaponMuzzleData(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MuzzleFlashEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcVehicleData(Structure):
    WheelGrassPushers: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    WheelLocs: Annotated[basic.Vector3f, Field(basic.Vector3f, 0xA0)]
    CollDimensions: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x140)]
    CollOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x150)]
    ExtraCollOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x160)]
    FirstPersonSeatAdjust: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x170)]
    InertiaDimensions: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x180)]
    WheelForwardAngularFactor: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x190)]
    WheelSideAngularFactor: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x1A0)]
    WheelSuspensionAngularFactor: Annotated[
        basic.Vector3f, Field(basic.Vector3f, 0x1B0)
    ]
    WheelTurnAngularFactor: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x1C0)]
    SuspensionAnimNames: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1D0)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x270)]
    SideSkidParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x280)]
    SubSplashParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x290)]
    WheelSpinParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x2A0)]
    WheelSplashParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x2B0)]
    WheelRadiusMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C0)]
    WheelRayFakeWidthFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E8)]
    AudioImpactSpeedMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x310)]
    AudioImpactSpeedThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x314)]
    CollRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x318)]
    CreatureMassScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x31C)]
    HardStopSpeedThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x320)]
    HeadlightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x324)]
    InertiaMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x328)]
    NumGrassPushers: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x32C)]
    NumWheels: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x330)]
    SideSkidParticleMaxRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x334)]
    SideSkidParticleMaxThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x338)]
    SideSkidParticleMinRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x33C)]
    SideSkidParticleMinThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x340)]
    SteeringWheelPushRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x344)]
    SteeringWheelSpringMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x348)
    ]
    SubSplashParticleMaxThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34C)]
    SubSplashParticleMinThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x350)]
    TopSpeedForward: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x354)]
    TopSpeedReverse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x358)]
    TurningWheelForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x35C)]
    TurningWheelForceDamperVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x360)]
    TurningWheelFrictionBraking: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x364)]
    TurningWheelFrictionNonBraking: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x368)
    ]
    TurningWheelFrictionOmega: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x36C)]
    UnderwaterAlignDir: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x370)]
    UnderwaterAlignUp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x374)]
    UnderwaterEngineDirectionBrake: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x378)
    ]
    UnderwaterEngineDirectionBrakeVertical: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x37C)
    ]
    UnderwaterEngineFalloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x380)]
    UnderwaterEngineMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x384)]
    UnderwaterEngineMaxSpeedVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x388)]
    UnderwaterEnginePower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38C)]
    UnderwaterEnginePowerVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x390)]
    VehicleAngularDampingAerial: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x394)]
    VehicleAngularDampingGround: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x398)]
    VehicleAngularDampingWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x39C)]
    VehicleAudioSideSkidMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A0)]
    VehicleAudioSideSkidThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3A4)
    ]
    VehicleAudioSpeedMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A8)]
    VehicleAudioSpinSkidMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3AC)]
    VehicleAudioSpinSkidThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3B0)
    ]
    VehicleAudioSuspensionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3B4)]
    VehicleAudioSuspensionThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3B8)
    ]
    VehicleAudioTorqueMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3BC)]
    VehicleBoostExtraMaxSpeedAir: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3C0)
    ]
    VehicleBoostForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C4)]
    VehicleBoostMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C8)]
    VehicleBoostRechargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3CC)]
    VehicleBoostSpeedFalloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D0)]
    VehicleBoostTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D4)]
    VehicleComCheat: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D8)]
    VehicleGravity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3DC)]
    VehicleGravityWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E0)]
    VehicleJumpAirControlForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E4)]
    VehicleJumpAirMaxTorque: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E8)]
    VehicleJumpAirRotateTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3EC)]
    VehicleJumpAirRotateTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F0)]
    VehicleJumpAirRotateXAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F4)]
    VehicleJumpAirRotateZAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F8)]
    VehicleJumpForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3FC)]
    VehicleLinearDampingAerial: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x400)]
    VehicleLinearDampingGround: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x404)]
    VehicleLinearDampingWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x408)]
    VehicleUnderwaterRotateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40C)]
    VisualPitchAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x410)]
    VisualRollAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x414)]
    VisualRollOffsetY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x418)]
    WheelDragginess: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x41C)]
    WheelEndHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x420)]
    WheelFrontFrictionDynamic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x424)]
    WheelFrontFrictionDynamicThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x428)
    ]
    WheelFrontFrictionOmega: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x42C)]
    WheelFrontFrictionStatic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x430)]
    WheelFrontFrictionStaticThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x434)
    ]
    WheelGrassPusherFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x438)]
    WheelGrassPusherStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x43C)]
    WheelGrassPusherWobble: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x440)]
    WheelGuardAdjustUpwards: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x444)]
    WheelGuardExtraHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x448)]
    WheelGuardExtraRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44C)]
    WheelGuardMassScaleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x450)]
    WheelGuardMassScaleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x454)]
    WheelGuardMassScaleMinClamp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x458)]
    WheelGuardPenetrationScaleMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x45C)
    ]
    WheelGuardPenetrationScaleMin: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x460)
    ]
    WheelGuardPenetrationScaleMinClamp: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x464)
    ]
    WheelGuardVerticalResponseMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x468)
    ]
    WheelGuardVerticalResponseMin: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x46C)
    ]
    WheelMaxAccelForceForward: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x470)]
    WheelMaxAccelForceReverse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x474)]
    WheelMaxDecelForceBraking: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x478)]
    WheelMaxDecelForceNonBraking: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x47C)
    ]
    WheelRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x480)]
    WheelSideFrictionDynamic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x484)]
    WheelSideFrictionDynamicThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x488)
    ]
    WheelSideFrictionOmega: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48C)]
    WheelSideFrictionStatic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x490)]
    WheelSideFrictionStaticThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x494)
    ]
    WheelSpinniness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x498)]
    WheelSpinParticleMaxRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x49C)]
    WheelSpinParticleMaxThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4A0)]
    WheelSpinParticleMinRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4A4)]
    WheelSpinParticleMinThresh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4A8)]
    WheelStartHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4AC)]
    WheelSuspensionAnimMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4B0)]
    WheelSuspensionAnimMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4B4)]
    WheelSuspensionDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4B8)]
    WheelSuspensionForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4BC)]
    WheelSuspensionlength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C0)]
    CockpitHeadlightNames: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x4C4)
    ]
    HeadlightNames: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x6C4)
    ]
    VolumetricHeadlightNames: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x8C4)
    ]
    WheelNames: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xAC4)
    ]
    WheelSuspensionNames: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC04)
    ]
    AudioBoostStart: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xD44)
    ]
    AudioBoostStop: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xDC4)
    ]
    AudioHornStart: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xE44)
    ]
    AudioHornStop: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xEC4)
    ]
    AudioIdleExterior: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xF44)
    ]
    AudioImpacts: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xFC4)
    ]
    AudioJump: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x1044)
    ]
    AudioStart: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x10C4)
    ]
    AudioStop: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x1144)
    ]
    AudioSuspension: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x11C4)
    ]
    CustomCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1244)]
    DriveOnTopOfWater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1245)]
    LockVehicleAxis: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1246)]
    UseBuggySuspensionHack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1247)]
    UseRoverWheelHack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1248)]
    VehicleAudioSwapSkidAndSpeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1249)]


@partial_struct
class cGcDebugCameraEntry(Structure):
    Facing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Local: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    FOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    SpeedModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]


@partial_struct
class cGcDebugCamera(Structure):
    Waypoints: Annotated[
        basic.cTkDynamicArray[cGcDebugCameraEntry],
        Field(basic.cTkDynamicArray[cGcDebugCameraEntry], 0x0),
    ]
    BaseSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    CurrentWaypoint: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    CurrentWaypointProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Smoothing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcMechPartEffectOverride(Structure):
    OverrideEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MeshPart: Annotated[
        c_enum32[enums.cGcMechMeshPart], Field(c_enum32[enums.cGcMechMeshPart], 0x10)
    ]
    MeshType: Annotated[
        c_enum32[enums.cGcMechMeshType], Field(c_enum32[enums.cGcMechMeshType], 0x14)
    ]


@partial_struct
class cGcMechEffect(Structure):
    DefaultEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MeshPartOverrides: Annotated[
        basic.cTkDynamicArray[cGcMechPartEffectOverride],
        Field(basic.cTkDynamicArray[cGcMechPartEffectOverride], 0x10),
    ]


@partial_struct
class cGcMechEffectTable(Structure):
    FootDust: Annotated[cGcMechEffect, Field(cGcMechEffect, 0x0)]
    Jetpack: Annotated[cGcMechEffect, Field(cGcMechEffect, 0x20)]
    JetpackLaunch: Annotated[cGcMechEffect, Field(cGcMechEffect, 0x40)]
    JetpackLaunchGroundEffect: Annotated[cGcMechEffect, Field(cGcMechEffect, 0x60)]
    LandingImpact: Annotated[cGcMechEffect, Field(cGcMechEffect, 0x80)]


@partial_struct
class cGcExoMechWeaponData(Structure):
    MuzzleFlashDataID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LocationPriority: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcMechWeaponLocation]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcMechWeaponLocation]], 0x50),
    ]
    AngleToleranceForArmAiming: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AttackAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    CooldownTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    CooldownTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    MaintainFireLocationMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    MaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    MinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    SelectionWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]


@partial_struct
class cGcMechMeshPartTypeData(Structure):
    DescriptorGroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RequiredTechs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]


@partial_struct
class cGcMechMeshPartData(Structure):
    MeshTypes: Annotated[cGcMechMeshPartTypeData, Field(cGcMechMeshPartTypeData, 0x0)]


@partial_struct
class cGcPulseEncounterSpawnAbandonedFreighter(Structure):
    AbandonedFreighter: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]


@partial_struct
class cGcPulseEncounterSpawnAlienFreighter(Structure):
    HailingPuzzleID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcPulseEncounterSpawnPirates(Structure):
    pass


@partial_struct
class cGcPulseEncounterSpawnObject(Structure):
    Object: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    DespawnEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    SpawnEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    TriggerActionOnSpawn: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Pitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Roll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    SpawnScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    SpawnTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    UpOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    WarpInDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    Yaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    BlockAIShipAutopilot: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6C)]
    LeaveIfAttacked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6D)]
    WarpIn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6E)]


@partial_struct
class cGcPulseEncounterSpawnConditions(Structure):
    BlockDuringSeasons: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x0),
    ]
    RequiresMissionActive: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    RequiresMissionComplete: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RequiresMissionNotActive: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    RequiresMissionNotComplete: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    RequiresProduct: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    AllowedBeyondPortals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    AllowedDuringTutorial: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]
    AllowedInCreative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x62)]
    AllowedInEmptySystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x63)]
    AllowedWhileOnMPMission: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]
    MissionEncounter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x65)]
    RequiresAlienShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x66)]
    RequiresCorvette: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x67)]
    RequiresNearbyCorruptWorld: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x68)]
    StandardEncounter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x69)]


@partial_struct
class cGcDebugShipTravelLine(Structure):
    Dir: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Origin: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    InfluenceRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcSpaceshipAvoidanceData(Structure):
    EndRadiusMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Force: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    NumRays: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    RayMinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    RaySpeedTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SpeedInterp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SpeedInterpMinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SpeedInterpRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    StartRadiusMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcDoShipClearCommunication(Structure):
    pass


@partial_struct
class cGcDoShipFlybyClose(Structure):
    LockOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    LockSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LockTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HailingBehaviour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]
    StayCloseAtLowSpeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD)]


@partial_struct
class cGcDoShipFlybyIntercept(Structure):
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcDoShipFlybyMineAsteroids(Structure):
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcDoShipFlybyOverhead(Structure):
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Offset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcDoShipLandNextToPlayer(Structure):
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Offset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcDoShipReceiveHail(Structure):
    pass


@partial_struct
class cGcDoShipReceiveMessage(Structure):
    ShipMessage: Annotated[
        c_enum32[enums.cGcShipMessage], Field(c_enum32[enums.cGcShipMessage], 0x0)
    ]


@partial_struct
class cGcShipAIDeathData(Structure):
    BrakeForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DroneDeathBoomTotalTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    DroneDeathForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    DroneDeathOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    DroneDeathTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DroneDeathTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DroneNumDeathBooms: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcShipAIPerformanceArray(Structure):
    Array: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]


@partial_struct
class cGcShipAIPlanetPatrolData(Structure):
    Squad: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AlignForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AlongPathForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    BrakeForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    PathOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    PathSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    PlayerFalloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    PlayerOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ToPathForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    WaypointDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcPlayerSpaceshipAim(Structure):
    AimAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AimAngleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AimDistanceAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AimDistanceAngleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    AimDistanceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AimDistanceRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcPlayerSpaceshipClassBonuses(Structure):
    BoostingTurnDampMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BoostingTurnDampMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    BoostMaxSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    BoostMaxSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    DirectionBrakeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DirectionBrakeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MaxSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MaxSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    ThrustForceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ThrustForceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    TurnStrengthMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    TurnStrengthMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]


@partial_struct
class cGcPlayerSpaceshipEngineData(Structure):
    BalanceTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BalanceTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    BoostFalloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    BoostingTurnDamp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    BoostMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BoostThrustForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DirectionBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DirectionBrakeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Falloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FollowDerivativeGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FollowDerivativeLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FollowIntegralDecay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    FollowIntegralGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FollowIntegralLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    FollowProportionalGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    FollowProportionalLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    LowSpeedTurnDamper: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MinSpeedForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    OverspeedBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    ReverseBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    RollAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    RollAutoTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    RollForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    ThrustForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    TurnBrakeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    TurnBrakeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    TurnStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]


@partial_struct
class cGcPlayerSpaceshipControlData(Structure):
    AtmosCombatEngine: Annotated[
        cGcPlayerSpaceshipEngineData, Field(cGcPlayerSpaceshipEngineData, 0x0)
    ]
    CombatEngine: Annotated[
        cGcPlayerSpaceshipEngineData, Field(cGcPlayerSpaceshipEngineData, 0x74)
    ]
    PlanetEngine: Annotated[
        cGcPlayerSpaceshipEngineData, Field(cGcPlayerSpaceshipEngineData, 0xE8)
    ]
    SpaceEngine: Annotated[
        cGcPlayerSpaceshipEngineData, Field(cGcPlayerSpaceshipEngineData, 0x15C)
    ]
    AngularFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D0)]
    ExitAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D4)]
    ExitAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D8)]
    ExitHeightFactorMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1DC)]
    ExitHeightFactorMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E0)]
    ExitHeightFactorPlungeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E4)]
    ExitHeightFactorPlungeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E8)]
    ExitLeaveAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1EC)]
    MaxTorque: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F0)]
    ShipMinHeightForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F4)]
    ShipPlanetBrakeAlignMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F8)]
    ShipPlanetBrakeAlignMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1FC)]
    ShipPlanetBrakeForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x200)]
    ShipPlanetBrakeMaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x204)]
    ShipPlanetBrakeMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x208)]
    ShipPlanetBrakeMinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20C)]
    ShipPlanetBrakeMinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x210)]
    ExitCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x214)
    ]
    ExitDownCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x215)
    ]


@partial_struct
class cGcPlayerSpaceshipWarpData(Structure):
    EntryTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ExitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    TravelTunnelTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    EntryTunnelCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xC)
    ]
    ExitTunnelCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xD)
    ]


@partial_struct
class cGcShieldComponentData(Structure):
    Type: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcShipAIAttackData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AttackAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AttackApproachMaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AttackApproachMinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    AttackApproachOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    AttackBoostAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AttackBoostRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    AttackBoostTimeToRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    AttackFlybyOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    AttackMaxPlanetHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    AttackMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    AttackReadyTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    AttackShootTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    AttackShootTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    AttackShootWaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    AttackTargetMaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    AttackTargetMinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    AttackTargetOffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    AttackTargetOffsetMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    AttackTargetSwitchTargetTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    AttackTooCloseRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    AttackTurnMaxMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AttackTurnMaxTimeRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    AttackTurnMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    AttackTurnMultiplierMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    AttackWeaponRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    FleeBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    FleeBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    FleeBrakeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    FleeMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    FleeMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    FleeRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    FleeRepositionAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    FleeRepositionAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    FleeRepositionTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    FleeRepositionUrgentAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    FleeRepositionUrgentAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    FleeRepositionUrgentTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    FleeUrgentBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    FleeUrgentBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    FleeUrgentBrakeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    FleeUrgentRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    GunDispersionAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    GunFireRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    LaserHealthPoint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    NumHitsBeforeBail: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC0)]
    NumHitsBeforeReposition: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC4)]
    PlanetFleeHeightExtra: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]


@partial_struct
class cGcShipAICombatDefinition(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    Behaviour: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    DamageMultiplier: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x28)]
    Engine: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x38)]
    Gun: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x58)]
    PlanetBehaviour: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x68)]
    PlanetEngine: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x78)]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x88)]
    Shield: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x98)]
    Health: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA8)]
    LaserDamageLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xAC)]
    LevelledExtraHealth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB0)]
    RewardCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB4)]
    UsesFuelRods: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB8)]
    UsesShieldGenerators: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB9)]


@partial_struct
class cGcDebugPlanetPos(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    OverridePosition: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcSpaceshipShieldData(Structure):
    DamageMulOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Health: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    LevelledExtraHealth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    RechargeDelayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    RechargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    StartDepletedWhenEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcSpaceshipTravelData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AvoidTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BoostSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DirectionBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Falloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Force: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MaxSpeedBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MinSpeedForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    Roll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    TurnMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    TurnMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Hovering: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]


@partial_struct
class cGcAISpaceshipWeightingData(Structure):
    CivilianClassWeightings: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcWaterEmissionData(Structure):
    FoamEmissionSelectionWeights: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    WaterEmissionSelectionWeights: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x10)
    ]
    OverrideDefault: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcWaterEmissionBiomeData(Structure):
    SubBiomeOverrides: Annotated[cGcWaterEmissionData, Field(cGcWaterEmissionData, 0x0)]


@partial_struct
class cGcAISpaceshipInstanceData(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcAISpaceshipMappingData(Structure):
    ClassMap: Annotated[
        cGcAISpaceshipInstanceData, Field(cGcAISpaceshipInstanceData, 0x0)
    ]


@partial_struct
class cGcWeatherWeightings(Structure):
    WeatherWeightings: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcAIShipDebugSpawnData(Structure):
    Facing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    FlightDir: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x40)]
    SpecificModel: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    HoverHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    HoverTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    IgnitionDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    TakeOffDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    WarpOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    Wingman: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]


@partial_struct
class cGcAIShipSpawnMarkerData(Structure):
    MarkerLabel: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    MarkerIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    MaxVisibleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    MinAngleVisible: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MinVisibleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]

    class eShipsToMarkEnum(IntEnum):
        None_ = 0x0
        Leader = 0x1
        All = 0x2

    ShipsToMark: Annotated[
        c_enum32[eShipsToMarkEnum], Field(c_enum32[eShipsToMarkEnum], 0x44)
    ]
    HideDuringCombat: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]


@partial_struct
class cGcAIShipSpawnData(Structure):
    OffsetSphereOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    MarkerData: Annotated[
        cGcAIShipSpawnMarkerData, Field(cGcAIShipSpawnMarkerData, 0x10)
    ]
    CombatMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    Message: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)]
    OSDMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xA0)
    ]
    RewardMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC0)
    ]
    AttackDefinition: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xE0)]
    ChildSpawns: Annotated[
        "basic.cTkDynamicArray[cGcAIShipSpawnData]",
        Field("basic.cTkDynamicArray[cGcAIShipSpawnData]", 0xF0),
    ]
    Performances: Annotated[
        cGcShipAIPerformanceArray, Field(cGcShipAIPerformanceArray, 0x100)
    ]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x110)]
    Count: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x120)]
    Scale: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x128)]
    Spread: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x130)]
    StartTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x138)]
    MinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]
    Role: Annotated[
        c_enum32[enums.cGcAISpaceshipRoles],
        Field(c_enum32[enums.cGcAISpaceshipRoles], 0x144),
    ]
    Shortcut: Annotated[
        c_enum32[enums.cTkInputEnum], Field(c_enum32[enums.cTkInputEnum], 0x148)
    ]

    class eSpawnShapeEnum(IntEnum):
        Sphere = 0x0
        Cone = 0x1
        OffsetSphere = 0x2

    SpawnShape: Annotated[
        c_enum32[eSpawnShapeEnum], Field(c_enum32[eSpawnShapeEnum], 0x14C)
    ]
    AttackFreighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x150)]
    WarpIn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x151)]


@partial_struct
class cGcPlanetWeatherColourIndex(Structure):
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]

    class eWeatherColourSetEnum(IntEnum):
        Common = 0x0
        Rare = 0x1

    WeatherColourSet: Annotated[
        c_enum32[eWeatherColourSetEnum], Field(c_enum32[eWeatherColourSetEnum], 0x4)
    ]


@partial_struct
class cGcSolarSystemSkyColourData(Structure):
    BottomColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    BottomColourPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    CloudColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    FogColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    FogColour2: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    LightColour: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    MidColour: Annotated[basic.Colour, Field(basic.Colour, 0x60)]
    MidColourPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x70)]
    NebulaColour1: Annotated[basic.Colour, Field(basic.Colour, 0x80)]
    NebulaColour2: Annotated[basic.Colour, Field(basic.Colour, 0x90)]
    NebulaColour3: Annotated[basic.Colour, Field(basic.Colour, 0xA0)]
    TopColour: Annotated[basic.Colour, Field(basic.Colour, 0xB0)]
    TopColourPlanet: Annotated[basic.Colour, Field(basic.Colour, 0xC0)]


@partial_struct
class cGcSpawnDensity(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eCoverageTypeEnum(IntEnum):
        Total = 0x0
        SmoothPatch = 0x1
        GridPatch = 0x2

    CoverageType: Annotated[
        c_enum32[eCoverageTypeEnum], Field(c_enum32[eCoverageTypeEnum], 0x10)
    ]
    PatchSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    RegionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cGcPlanetTerrainColour(Structure):
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x0)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]


@partial_struct
class cGcPlanetTradingData(Structure):
    TradingClass: Annotated[
        c_enum32[enums.cGcTradingClass], Field(c_enum32[enums.cGcTradingClass], 0x0)
    ]
    WealthClass: Annotated[
        c_enum32[enums.cGcWealthClass], Field(c_enum32[enums.cGcWealthClass], 0x4)
    ]


@partial_struct
class cGcPlanetWaterColourData(Structure):
    CausticsColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    EmissionColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    FoamColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    FoamEmission: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    ScatterColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    TransmittanceColour: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    MaxScatterDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    MaxTransmittanceDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    MinScatterDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    MinTransmittanceDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    SelectionWeighting: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    SubsurfaceBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    SurfaceAbsorptionMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]


@partial_struct
class cGcTerrainControls(Structure):
    GridLayers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    NoiseLayers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Features: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    Caves: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    HighWaterActiveFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    RockTileFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    SubstanceTileFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    WaterActiveFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    ForceContinentalNoise: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]


@partial_struct
class cGcPlanetWaterData(Structure):
    ColourIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    FoamEmission: Annotated[
        c_enum32[enums.cGcWaterEmissionBehaviourType],
        Field(c_enum32[enums.cGcWaterEmissionBehaviourType], 0x4),
    ]
    Murkyness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    WaterEmission: Annotated[
        c_enum32[enums.cGcWaterEmissionBehaviourType],
        Field(c_enum32[enums.cGcWaterEmissionBehaviourType], 0xC),
    ]


@partial_struct
class cGcTerrainEditing(Structure):
    EditSizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    SubtractSizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    BaseEditSizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    UndoEditSizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    DensityBlendDistanceMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3C)
    ]
    EditEffectScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    EditPlaneMaxAdditiveOffsetFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x44)
    ]
    EditPlaneMaxSubtractiveOffsetFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x48)
    ]
    EditPlaneMinAdditiveOffsetFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x4C)
    ]
    EditPlaneMinSubtractiveOffsetFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x50)
    ]
    FlatteningSizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    MinimumSubstancePresence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    RegionEditAreaMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    RegionMapSearchRadiusMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x60)
    ]
    TerrainBlocksSearchRadiusMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x64)
    ]
    TerrainEditBaseDistanceTolerance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x68)
    ]
    TerrainEditBeamAddInterpolationStepFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6C)
    ]
    TerrainEditBeamMaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    TerrainEditBeamSpherecastRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x74)
    ]
    TerrainEditBeamSubtractInterpolationStepFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x78)
    ]
    TerrainEditsNormalCostFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    TerrainEditsSurvivalCostFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x80)
    ]
    TerrainUndoBaseDistanceTolerance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x84)
    ]
    UndoBaseEditEffectiveScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    UndoEditToleranceFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    VoxelsDeletedAffectCostFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x90)
    ]
    EditGunBeamEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x94)]
    EditGunParticlesEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x95)]
    SubtractGunBeamEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x96)]
    SubtractGunParticlesEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x97)]


@partial_struct
class cGcPlanetWeatherColourData(Structure):
    CloudColour1: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    CloudColour2: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    FogColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    HeightFogColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    HorizonColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    LightColour: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    LightColourUnderground: Annotated[basic.Colour, Field(basic.Colour, 0x60)]
    SkyColour: Annotated[basic.Colour, Field(basic.Colour, 0x70)]
    SkyGradientSpeed: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x80)]
    SkySolarColour: Annotated[basic.Colour, Field(basic.Colour, 0x90)]
    SkyUpperColour: Annotated[basic.Colour, Field(basic.Colour, 0xA0)]
    SunColour: Annotated[basic.Colour, Field(basic.Colour, 0xB0)]
    GasGiantAtmosphereID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    CirrusCloudDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    SelectionWeighting: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]


@partial_struct
class cGcPlanetHazardData(Structure):
    LifeSupportDrain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Radiation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SpookLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Temperature: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    Toxicity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]


@partial_struct
class cGcPlanetDataResourceHint(Structure):
    Hint: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Icon: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcPlanetGroundCombatData(Structure):
    FlybyTimer: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    SentinelTimer: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    MaxActiveDrones: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    SentinelLevel: Annotated[
        c_enum32[enums.cGcPlanetSentinelLevel],
        Field(c_enum32[enums.cGcPlanetSentinelLevel], 0x14),
    ]


@partial_struct
class cGcPlanetInfo(Structure):
    SentinelsPerDifficulty: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x0)
    ]
    Fauna: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x200)]
    Flora: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x280)]
    PlanetDescription: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x300)
    ]
    PlanetType: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x380)
    ]
    Resources: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x400)
    ]
    Weather: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x480)]
    SentinelHighlightPerDifficulty: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x500)
    ]
    IsWeatherExtreme: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x504)]
    SpecialFauna: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x505)]


@partial_struct
class cGcPlanetRingData(Structure):
    Colour1: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Colour2: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    AlphaMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Depth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    LargeScale1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    LargeScale2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MidScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MidStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    Offset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    SmallScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    HasRings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]


@partial_struct
class cGcPlanetSectionData(Structure):
    DiscovererUID: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    DiscovererPlatform: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0x8)]
    DiscoveredState: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]


@partial_struct
class cGcPlanetaryMappingData(Structure):
    SectionsData: Annotated[
        basic.cTkDynamicArray[cGcPlanetSectionData],
        Field(basic.cTkDynamicArray[cGcPlanetSectionData], 0x0),
    ]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]


@partial_struct
class cGcPlanetaryMappingValues(Structure):
    PlanetSize: Annotated[
        c_enum32[enums.cGcPlanetSize], Field(c_enum32[enums.cGcPlanetSize], 0x0)
    ]
    PolesPerSection: Annotated[ctypes.c_uint16, Field(ctypes.c_uint16, 0x4)]
    SectionPerSide: Annotated[ctypes.c_uint16, Field(ctypes.c_uint16, 0x6)]


@partial_struct
class cGcBiomeFileListOption(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    PurpleSystemWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SubType: Annotated[
        c_enum32[enums.cGcBiomeSubType], Field(c_enum32[enums.cGcBiomeSubType], 0x14)
    ]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcBiomeFileListOptions(Structure):
    FileOptions: Annotated[
        basic.cTkDynamicArray[cGcBiomeFileListOption],
        Field(basic.cTkDynamicArray[cGcBiomeFileListOption], 0x0),
    ]


@partial_struct
class cGcGasGiantAtmosphereSetting(Structure):
    DiscoveryPlanetColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    AtmosphereID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    GradientMapResource: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]


@partial_struct
class cGcHeavyAirColourData(Structure):
    Colour1: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Colour2: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    ExtremeColour1: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    ExtremeColour2: Annotated[basic.Colour, Field(basic.Colour, 0x30)]


@partial_struct
class cGcHeavyAirSettingValues(Structure):
    ForceColour1: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ForceColour2: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    Colour1: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x20)]
    Colour2: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x2C)]
    Alpha1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Alpha2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Thickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    ForceColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    ReduceThicknessWithCloudCoverage: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x49)
    ]


@partial_struct
class cGcHeavyAirSetting(Structure):
    Settings: Annotated[cGcHeavyAirSettingValues, Field(cGcHeavyAirSettingValues, 0x0)]


@partial_struct
class cGcBiomeList(Structure):
    BiomeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    PrimeBiomeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]


@partial_struct
class cGcBiomeCloudSettings(Structure):
    StormCloudBottomColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    StormCloudTopColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    MaxCover: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MaxCoverage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MaxCoverageVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    MaxRateOfChange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MaxRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MaxVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    MinCover: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    MinCoverage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MinCoverageVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MinRateOfChange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MinVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    TendencyTowardsBeingCloudy: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]


@partial_struct
class cGcSolarSystemEventWarpOut(Structure):
    WarpIntervalRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    SquadName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC)]


@partial_struct
class cGcAtmosphereList(Structure):
    Atmospheres: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cGcGeneratedShipCounts(Structure):
    Counts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcSolarGenerationData(Structure):
    SolarSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]


@partial_struct
class cGcSolarSystemLocatorChoice(Structure):
    class eChoiceEnum(IntEnum):
        LookupName = 0x0
        AnyOfType = 0x1
        SpecificIndex = 0x2
        InFrontOfPlayer = 0x3

    Choice: Annotated[c_enum32[eChoiceEnum], Field(c_enum32[eChoiceEnum], 0x0)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Type: Annotated[
        c_enum32[enums.cGcSolarSystemLocatorTypes],
        Field(c_enum32[enums.cGcSolarSystemLocatorTypes], 0x8),
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC)]


@partial_struct
class cGcSpaceStationSpawnData(Structure):
    SpawnFacing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    SpawnPosition: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x20)]

    class eSpawnModeEnum(IntEnum):
        None_ = 0x0
        UseSeed = 0x1
        UseAltID = 0x2

    SpawnMode: Annotated[
        c_enum32[eSpawnModeEnum], Field(c_enum32[eSpawnModeEnum], 0x30)
    ]
    AltId: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x34)]


@partial_struct
class cGcAsteroidGeneratorAssignment(Structure):
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x0)]
    Locator: Annotated[
        cGcSolarSystemLocatorChoice, Field(cGcSolarSystemLocatorChoice, 0x10)
    ]
    AsteroidCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    PlanetIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]


@partial_struct
class cGcSolarSystemTraderSpawnData(Structure):
    SequenceTakeoffDelay: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    ChanceToDelayLaunch: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    InitialTakeoffDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MaxToSpawn: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcAsteroidGeneratorRing(Structure):
    Rotation: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Assignment: Annotated[
        cGcAsteroidGeneratorAssignment, Field(cGcAsteroidGeneratorAssignment, 0x10)
    ]
    LowerRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    OffBalance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5C)]
    PushAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    PushRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    UpperRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    USpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    FlipPush: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]


@partial_struct
class cGcSolarSystemLocator(Structure):
    Direction: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Type: Annotated[
        c_enum32[enums.cGcSolarSystemLocatorTypes],
        Field(c_enum32[enums.cGcSolarSystemLocatorTypes], 0x24),
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x28)]


@partial_struct
class cGcAsteroidGeneratorSlab(Structure):
    Rotation: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Scale: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Assignment: Annotated[
        cGcAsteroidGeneratorAssignment, Field(cGcAsteroidGeneratorAssignment, 0x20)
    ]
    NoiseApply: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    NoiseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    NoiseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]


@partial_struct
class cGcAsteroidGeneratorSurround(Structure):
    Assignment: Annotated[
        cGcAsteroidGeneratorAssignment, Field(cGcAsteroidGeneratorAssignment, 0x0)
    ]
    LowerRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    NoiseApply: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    NoiseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    NoiseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    UpperRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]


@partial_struct
class cGcExperienceTimers(Structure):
    High: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    Low: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    Normal: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    HighChance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    LowChance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]


@partial_struct
class cGcSentinelPounceBalance(Structure):
    MaxAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaxFireRateScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinFireRateScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MinTimeBetweenPounces: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    OtherPounceTimeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    PounceTimeFireRateScoreExtra: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcSentinelResource(Structure):
    Resource: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    BaseHealth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    HealthIncreasePerLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    RepairThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    RepairTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcSmokeBotStats(Structure):
    MinCpuFPSFacing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    MinCpuFPSPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    MinGpuFPSFacing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    MinGpuFPSPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    MinMemoryFacing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    MinMemoryPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x50)]
    AvgCpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AvgGpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    FrameCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    MaxCpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    MaxGpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    MinCpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    MinGpuFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    MinMemory: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    TotalCpuFps: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    TotalGpuFps: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]


@partial_struct
class cGcSmokeBotPlanetReport(Structure):
    PlanetStats: Annotated[cGcSmokeBotStats, Field(cGcSmokeBotStats, 0x0)]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x90)]


@partial_struct
class cGcSmokeBotSystemReport(Structure):
    SpaceStats: Annotated[cGcSmokeBotStats, Field(cGcSmokeBotStats, 0x0)]
    SystemStats: Annotated[cGcSmokeBotStats, Field(cGcSmokeBotStats, 0x90)]
    PlanetReports: Annotated[
        basic.cTkDynamicArray[cGcSmokeBotPlanetReport],
        Field(basic.cTkDynamicArray[cGcSmokeBotPlanetReport], 0x120),
    ]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x130)]


@partial_struct
class cGcSmokeBotReport(Structure):
    Systems: Annotated[
        basic.cTkDynamicArray[cGcSmokeBotSystemReport],
        Field(basic.cTkDynamicArray[cGcSmokeBotSystemReport], 0x0),
    ]
    StartingUA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]


@partial_struct
class cGcDroneResource(Structure):
    Resource: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcDroneWeaponData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Projectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ExplosionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FireRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FireTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FireTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    InheritInitialVelocity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MoveDistanceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    MoveDistanceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    NumProjectiles: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    NumShotsMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    NumShotsMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    ProjectileSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    Range: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    Timeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    ChangeBarrelEachShot: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]


@partial_struct
class cGcMechTargetSelectionWeightingSettings(Structure):
    CloseDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CloseDistanceWeightFactorExponent: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x4)
    ]
    DistanceWeightFactorBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    FarDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FarDistanceWeightFactorExponent: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x10)
    ]
    FwdDirectionWeightFactorBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MidDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MidDistanceWeightFactorExponent: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1C)
    ]
    ThreatWeightFactorBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    VeryCloseDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    VeryCloseDistanceWeightFactorExponent: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x28)
    ]
    VeryFarDistanceWeightFactorExponent: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2C)
    ]


@partial_struct
class cGcRobotLaserData(Structure):
    LaserColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    LaserLightOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    LaserID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    LaserActiveSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    LaserChargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    LaserLightAttackSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    LaserLightChargeSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    LaserMiningDamage: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    LaserSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    LaserTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]


@partial_struct
class cGcSentinelDamagedData(Structure):
    DamageEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DamageType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    SelfDestructEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DamageEffectHealthPercentThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x30)
    ]
    RangeTrigger: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    TimeTrigger: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    CanSelfDestruct: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]
    UseDamageEffect: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3D)]


@partial_struct
class cGcModularCustomisationEffectsData(Structure):
    EffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eModularCustomisationEffectModeEnum(IntEnum):
        Build = 0x0
        BuildOutward = 0x1
        Dissolve = 0x2

    ModularCustomisationEffectMode: Annotated[
        c_enum32[eModularCustomisationEffectModeEnum],
        Field(c_enum32[eModularCustomisationEffectModeEnum], 0x4),
    ]


@partial_struct
class cGcDroneControlData(Structure):
    DirectionBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    HeightAdjustDownStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HeightAdjustStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LeanInMoveDirStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    LookStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    LookStrengthVertical: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    RepelForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    RepelRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    StopTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]


@partial_struct
class cGcProjectileLineData(Structure):
    BulletGlowWidthMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BulletGlowWidthMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    BulletGlowWidthTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    BulletLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    BulletMaxScaleDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BulletMinScaleDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    BulletScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    BulletScalerMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    BulletScalerMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    BulletGlowWidthCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x24)
    ]


@partial_struct
class cGcProjectileImpactData(Structure):
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Impact: Annotated[
        c_enum32[enums.cGcProjectileImpactType],
        Field(c_enum32[enums.cGcProjectileImpactType], 0x10),
    ]

    class eImpactAlignmentEnum(IntEnum):
        ImpactNormal = 0x0
        ImpactReflected = 0x1
        GravityUp = 0x2

    ImpactAlignment: Annotated[
        c_enum32[eImpactAlignmentEnum], Field(c_enum32[eImpactAlignmentEnum], 0x14)
    ]

    class eImpactAttachmentEnum(IntEnum):
        World = 0x0
        HitBody = 0x1

    ImpactAttachment: Annotated[
        c_enum32[eImpactAttachmentEnum], Field(c_enum32[eImpactAttachmentEnum], 0x18)
    ]


@partial_struct
class cGcTracerData(Structure):
    DamageMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DamageMaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    DamageMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    DamageMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcZoomData(Structure):
    EffectStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FoV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxScanDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinScanDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    WalkSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]

    class eZoomTypeEnum(IntEnum):
        None_ = 0x0
        Far = 0x1
        Mid = 0x2
        Close = 0x3

    ZoomType: Annotated[c_enum32[eZoomTypeEnum], Field(c_enum32[eZoomTypeEnum], 0x18)]


@partial_struct
class cGcBoidData(Structure):
    Alignment: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Coherence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    DirectionBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Follow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    InitFacingOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    InitOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    InitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    LeadTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Separation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcDamageMultiplier(Structure):
    Multiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Type: Annotated[
        c_enum32[enums.cGcDamageType], Field(c_enum32[enums.cGcDamageType], 0x4)
    ]


@partial_struct
class cGcDamageMultiplierLookup(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Multipliers: Annotated[
        basic.cTkDynamicArray[cGcDamageMultiplier],
        Field(basic.cTkDynamicArray[cGcDamageMultiplier], 0x10),
    ]
    Default: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcProjectorOffsetData(Structure):
    Active: Annotated[cGcInWorldUIScreenData, Field(cGcInWorldUIScreenData, 0x0)]
    Inactive: Annotated[cGcInWorldUIScreenData, Field(cGcInWorldUIScreenData, 0x30)]
    ScreenScale: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x60)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]


@partial_struct
class cGcScanData(Structure):
    CameraEventId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eCameraEventFocusTargetTypeEnum(IntEnum):
        None_ = 0x0
        ScanEventBuilding = 0x1
        RevealedNPC = 0x2

    CameraEventFocusTargetType: Annotated[
        c_enum32[eCameraEventFocusTargetTypeEnum],
        Field(c_enum32[eCameraEventFocusTargetTypeEnum], 0x10),
    ]

    class eCameraEventTypeEnum(IntEnum):
        None_ = 0x0
        AerialView = 0x1
        LookAt = 0x2

    CameraEventType: Annotated[
        c_enum32[eCameraEventTypeEnum], Field(c_enum32[eCameraEventTypeEnum], 0x14)
    ]
    ChargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    PulseRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    PulseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ScanRevealDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    ScanType: Annotated[
        c_enum32[enums.cGcScanType], Field(c_enum32[enums.cGcScanType], 0x28)
    ]
    AddMarkers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    PlayAudioOnMarkers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]


@partial_struct
class cGcScanDataTableEntry(Structure):
    ScanData: Annotated[cGcScanData, Field(cGcScanData, 0x0)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcScanEffectData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BasecolourIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FadeOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FresnelIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    GlowIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eScanEffectTypeEnum(IntEnum):
        Building = 0x0
        TargetShip = 0x1
        Creature = 0x2
        Ground = 0x3
        Objects = 0x4

    ScanEffectType: Annotated[
        c_enum32[eScanEffectTypeEnum], Field(c_enum32[eScanEffectTypeEnum], 0x34)
    ]
    ScanlinesSeparation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    WaveOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    FixedUpAxis: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]
    ModelFade: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41)]
    Transparent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x42)]
    WaveActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43)]


@partial_struct
class cGcPlayerCharacterIKOverrideData(Structure):
    RotStrengths: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcPlayerCharacterAnimationOverrideData(Structure):
    Data: Annotated[
        cGcPlayerCharacterIKOverrideData, Field(cGcPlayerCharacterIKOverrideData, 0x0)
    ]
    AnimName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcPlayerCharacterIKStateData(Structure):
    Data: Annotated[
        cGcPlayerCharacterIKOverrideData, Field(cGcPlayerCharacterIKOverrideData, 0x0)
    ]
    AnimOverrides: Annotated[
        basic.cTkDynamicArray[cGcPlayerCharacterAnimationOverrideData],
        Field(basic.cTkDynamicArray[cGcPlayerCharacterAnimationOverrideData], 0x20),
    ]
    State: Annotated[
        c_enum32[enums.cGcPlayerCharacterStateType],
        Field(c_enum32[enums.cGcPlayerCharacterStateType], 0x30),
    ]


@partial_struct
class cGcPlayerCharacterStateData(Structure):
    AimTree1HPitch: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AimTree1HYaw: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AimTree2HPitch: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    AimTree2HYaw: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    AimTreeFishingPitch: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    AimTreeFishingYaw: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    AimTreeStaffPitch: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    AimTreeStaffYaw: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    HitReact0H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    HitReact1H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    HitReact2H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    HitReactStaff: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    Locomotion0H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    Locomotion1H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xD0)]
    Locomotion2H: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xE0)]
    LocomotionStaff: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xF0)]
    KeepHeadForward: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x100)]


@partial_struct
class cGcPlayerHazardData(Structure):
    Damage: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DamageRate: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    ProtectionTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x18)]
    WoundRate: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    CapValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    CriticalValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    OutputMaxAddition: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    OutputMinAddition: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    OutputMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    ProtectionInitialTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    RechargeInitialTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    RechargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    TriggerValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    DisplayCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x4C)
    ]
    Increases: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]


@partial_struct
class cGcPlayerStickData(Structure):
    Accelerate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AccelerateAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AcceleratorMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AcceleratorStickPoint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    StickyFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Turn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    TurnFast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcGrabbableData(Structure):
    HandPose: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RotationLimits: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    AttachTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    DetachTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    GrabRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]

    class eGrabTypeEnum(IntEnum):
        Default = 0x0
        EjectHandle = 0x1
        ControlStickLeft = 0x2
        ControlStickRight = 0x3

    GrabType: Annotated[c_enum32[eGrabTypeEnum], Field(c_enum32[eGrabTypeEnum], 0x24)]
    Hand: Annotated[c_enum32[enums.cGcHand], Field(c_enum32[enums.cGcHand], 0x28)]
    MovementMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MovementRequiredForActivation: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x30)
    ]
    MovementReturnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    ReleaseRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    ToggleGrabTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    LocatorName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    MovementEndLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    MovementStartLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)
    ]
    AllowOtherWayUp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA0)]
    AutoGrab: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA1)]


@partial_struct
class cGcPlayerEmotePropData(Structure):
    ScanEffect: Annotated[cGcScanEffectData, Field(cGcScanEffectData, 0x0)]
    Model: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)]
    DelayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    Hand: Annotated[c_enum32[enums.cGcHand], Field(c_enum32[enums.cGcHand], 0x64)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    ScanEffectNodeName: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x6C)
    ]
    IsHologram: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xAC)]


@partial_struct
class cGcPlayerEmote(Structure):
    PropData: Annotated[cGcPlayerEmotePropData, Field(cGcPlayerEmotePropData, 0x0)]
    ChatText: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xB0)]
    PetCommandTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xD0)
    ]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xF0)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x110)]
    PetCommandIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x128)]
    AnimationName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x140)]
    EmoteID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x150)]
    GekAnimationName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x160)]
    GekLoopAnimUntilMove: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x170)]
    LinkedSpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x180)]
    LoopAnimUntilMove: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x190)]
    RidingAnimationName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1A0)]
    IconPetCommandResource: Annotated[basic.GcResource, Field(basic.GcResource, 0x1B0)]
    IconResource: Annotated[basic.GcResource, Field(basic.GcResource, 0x1B4)]
    AvailableUnderwater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B8)]
    ChatUsesPrefix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B9)]
    CloseMenuOnSelect: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BA)]
    IsPetCommand: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BB)]
    MoveToCancel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BC)]
    NeverShowInMenu: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BD)]


@partial_struct
class cGcReplacementEffectData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ReplaceWith: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcPhotoBuildings(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    BuildingType: Annotated[
        c_enum32[enums.cGcPhotoBuilding], Field(c_enum32[enums.cGcPhotoBuilding], 0x8)
    ]


@partial_struct
class cGcAreaDamageData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PlayerDamageId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Damage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    DelayPerMetre: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    DamageCreatures: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    DamagePlayers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    InstantKill: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]


@partial_struct
class cGcPhotoFauna(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    CreatureArea: Annotated[
        c_enum32[enums.cGcPhotoCreature], Field(c_enum32[enums.cGcPhotoCreature], 0x8)
    ]
    MustBePet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcPhotoFlora(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    PlantType: Annotated[
        c_enum32[enums.cGcPhotoPlant], Field(c_enum32[enums.cGcPhotoPlant], 0x8)
    ]


@partial_struct
class cGcCreatureDiscoveryThumbnailOverride(Structure):
    DiscoveryUIOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    ContainsDescriptor: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x10)]
    DiscoveryUIScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcDebrisData(Structure):
    Filename: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    OverrideSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x20)]
    AnglularSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Number: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcPhotoShips(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    ShipType: Annotated[
        c_enum32[enums.cGcPhotoShip], Field(c_enum32[enums.cGcPhotoShip], 0x8)
    ]


@partial_struct
class cGcNPCProbabilityWordReactionData(Structure):
    NextInteraction: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcJudgementMessageOptions(Structure):
    MessageInSettlement: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x0)
    ]
    MessageInSettlementSystem: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x80)
    ]
    MessageOutOfSettlementSystem: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x100)
    ]


@partial_struct
class cGcNPCColourGroup(Structure):
    Primary: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Secondary: Annotated[
        basic.cTkDynamicArray[basic.Colour],
        Field(basic.cTkDynamicArray[basic.Colour], 0x10),
    ]
    Rarity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcProductToCollect(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcMissionSequenceWaitRealTime(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    DisplayStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Time: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x30)]
    Randomness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    StatFromNow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]
    TakeDisplayStatTargetFromSeasonData: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3D)
    ]


@partial_struct
class cGcMissionSequenceWaitRealTimeCombat(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    DisplayStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    MessageCombat: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Time: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x40)]
    Randomness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    StatFromNow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]


@partial_struct
class cGcConstructionPart(Structure):
    Part: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcConstructionPartGroup(Structure):
    ValidParts: Annotated[
        basic.cTkDynamicArray[cGcConstructionPart],
        Field(basic.cTkDynamicArray[cGcConstructionPart], 0x0),
    ]


@partial_struct
class cGcMissionSequenceWaitForSuitUpgrade(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcMissionSequenceWaitForWarps(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcMissionSequenceWaitForPhoto(Structure):
    Biomes: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcBiomeType]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcBiomeType]], 0x0),
    ]
    Buildings: Annotated[
        basic.cTkDynamicArray[cGcPhotoBuildings],
        Field(basic.cTkDynamicArray[cGcPhotoBuildings], 0x10),
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Fauna: Annotated[
        basic.cTkDynamicArray[cGcPhotoFauna],
        Field(basic.cTkDynamicArray[cGcPhotoFauna], 0x30),
    ]
    Flora: Annotated[
        basic.cTkDynamicArray[cGcPhotoFlora],
        Field(basic.cTkDynamicArray[cGcPhotoFlora], 0x40),
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)]
    MessageSecondary: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    MessageSuccess: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)
    ]
    Ships: Annotated[
        basic.cTkDynamicArray[cGcPhotoShips],
        Field(basic.cTkDynamicArray[cGcPhotoShips], 0x80),
    ]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x90)]


@partial_struct
class cGcMissionSequenceWaitForWonderValue(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    CreatureWonderType: Annotated[
        c_enum32[enums.cGcWonderCreatureCategory],
        Field(c_enum32[enums.cGcWonderCreatureCategory], 0x20),
    ]
    Decimals: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    FloraWonderType: Annotated[
        c_enum32[enums.cGcWonderFloraCategory],
        Field(c_enum32[enums.cGcWonderFloraCategory], 0x28),
    ]
    MineralWonderType: Annotated[
        c_enum32[enums.cGcWonderMineralCategory],
        Field(c_enum32[enums.cGcWonderMineralCategory], 0x2C),
    ]
    PlanetWonderType: Annotated[
        c_enum32[enums.cGcWonderPlanetCategory],
        Field(c_enum32[enums.cGcWonderPlanetCategory], 0x30),
    ]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x34)
    ]
    Value: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    WonderTypeToUse: Annotated[
        c_enum32[enums.cGcWonderType], Field(c_enum32[enums.cGcWonderType], 0x3C)
    ]
    TakeAmountFromSeasonalData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcMissionSequenceWaitForPortalWarp(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    SpecificOverrideUA: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    CommunityOverrideUA: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x30)
    ]
    PartOfAtlasStory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    WarpToRendezvousForThisStage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    WarpToSpace: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]


@partial_struct
class cGcMissionSequenceWaitForScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    NexusMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    SurveyHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    SurveyInactiveHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    SurveySwapHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)
    ]
    SurveyVehicleHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xA0)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xC0)
    ]
    GalaxyMapMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xD0)
    ]
    GalaxyMapMessageNotSpace: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xE0)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xF0)]
    TimeoutOSD: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x100)
    ]
    Timeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x110)]
    UseGPSInText: Annotated[
        c_enum32[enums.cGcScanEventGPSHint],
        Field(c_enum32[enums.cGcScanEventGPSHint], 0x114),
    ]
    DistanceTimeout: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x118)]


@partial_struct
class cGcMissionSequenceWaitForDepots(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcMissionSequenceWaitForSettlementActivity(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MessageForConflict: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    MessageForProposal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    MessageForVisitor: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    MessageWhileBuilding: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]


@partial_struct
class cGcMissionSequenceWaitForSettlementMiniMission(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceWaitForFreighterPods(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    TakeAmountFromPulseEncounter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcMissionSequenceWaitForStat(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    StatGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]


@partial_struct
class cGcMissionSequenceWaitForFriendlyDroneScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    MessageCantSummon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    MessageNotAvailable: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    MessageSummoned: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    MessageUnsummoned: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]


@partial_struct
class cGcMissionSequenceWaitForStatMilestone(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]

    class eMilestoneEnum(IntEnum):
        Bronze = 0x0
        Silver = 0x1
        Gold = 0x2

    Milestone: Annotated[
        c_enum32[eMilestoneEnum], Field(c_enum32[eMilestoneEnum], 0x30)
    ]
    EveryMilestone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]


@partial_struct
class cGcMissionSequenceWaitForMessage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    SetIconWithID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    WaitMessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    FormatMessageWithSeasonData: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]


@partial_struct
class cGcMissionSequenceWaitForStatSeasonal(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    StatGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    EncouragesFighting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    TakeAmountFromSeasonalData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]


@partial_struct
class cGcMissionSequenceVisitPlanets(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MessageOnIncompletePlanet: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    PlanetTypesToWatch: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcBiomeType]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcBiomeType]], 0x30),
    ]
    NumberOfEachToDiscover: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    MustAlsoDiscover: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    MustAlsoTakePhoto: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]
    TakeNumberFromSeasonalData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46)]


@partial_struct
class cGcMissionSequenceWait(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MultiplyTimeBySeasonValue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    SuppressMessages: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcMissionSequenceShowMissionUpdateMessage(Structure):
    CustomMessageLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CustomObjectiveLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]

    class eMissionUpdateMessageEnum(IntEnum):
        Start = 0x0
        End = 0x1

    MissionUpdateMessage: Annotated[
        c_enum32[eMissionUpdateMessageEnum],
        Field(c_enum32[eMissionUpdateMessageEnum], 0x50),
    ]

    class ePlayMusicStingEnum(IntEnum):
        None_ = 0x0
        Start = 0x1
        End = 0x2
        Corrupted = 0x3

    PlayMusicSting: Annotated[
        c_enum32[ePlayMusicStingEnum], Field(c_enum32[ePlayMusicStingEnum], 0x54)
    ]
    SetMissionSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]
    ShowChangeMissionNotify: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x59)]
    SuppressNotificationsNotFromThisMission: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x5A)
    ]
    WaitForMessageOver: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5B)]


@partial_struct
class cGcMissionSequenceWaitForAbandFreighterDoorOpen(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MessageOvertime: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    MinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcMissionSequenceShowPodMessage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceWaitForBuild(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    TargetTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcMissionSequenceShowSeasonTimeWarning(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    TimeToShow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcMissionSequenceWaitForCompletionMessage(Structure):
    MessageWhenInterstellar: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ReturnToOptionalScanEvent: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    CompletionCost: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)]


@partial_struct
class cGcMissionSequenceSignalGalacticPoint(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Target: Annotated[
        c_enum32[enums.cGcMissionGalacticPoint],
        Field(c_enum32[enums.cGcMissionGalacticPoint], 0x20),
    ]


@partial_struct
class cGcMissionSequenceStartMission(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Forced: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    MakeCurrent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    Restart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcMissionSequenceStartPartyEventForStage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcMissionSequenceStop(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceSummonNexus(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    IgnorePlanetRadiusAndForceSpawn: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x20)
    ]


@partial_struct
class cGcMissionSequenceSuppressMarkers(Structure):
    Suppressed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    SuppressedAfterNextWarp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcMissionSequenceVehicleScan(Structure):
    ScanEventID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]


@partial_struct
class cGcMissionSequenceShowHintMessage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    InventoryHint: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    MessagePadControl: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    MessageTitle: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    UseConditionsForTextFormatting: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x50),
    ]
    HighPriorityTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    InitialWaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    SecondaryWaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    AllowedWhileInDanger: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6C)]


@partial_struct
class cGcMissionSequenceKill(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMaxNoMP: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    AmountMinNoMP: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]

    class eKillTargetEnum(IntEnum):
        Robots = 0x0
        Drones = 0x1
        Quads = 0x2
        Walkers = 0x3
        Predators = 0x4
        Creatures = 0x5
        Pirates = 0x6
        Traders = 0x7
        Fiends = 0x8
        Queens = 0x9
        HazardousFlora = 0xA
        Worms = 0xB
        CorruptSentinels = 0xC
        SpiderSentinels = 0xD
        SmallSpiderSentinels = 0xE
        HostilesWhileInMech = 0xF
        CorruptPillars = 0x10
        Mechs = 0x11
        SpookSquids = 0x12

    KillTarget: Annotated[
        c_enum32[eKillTargetEnum], Field(c_enum32[eKillTargetEnum], 0x30)
    ]
    OverrideMissionStageIDForMPProgress: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x34)
    ]
    AddToMissionBoardObjective: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x39)]
    WriteProgressToMissionStat: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A)]


@partial_struct
class cGcMissionSequenceKillEncounter(Structure):
    EncounterComponentScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    AllowedToEscape: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcMissionSequenceLearnWords(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcMissionSequenceLeaveNexusMP(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MessageNoWarp: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Timeout: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x30)]


@partial_struct
class cGcMissionSequenceOpenSettlementBuildingWithScanEvent(Structure):
    ScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    MessageWhenDistant: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    UpgradeMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    UpgradeMessageWhenDistant: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]


@partial_struct
class cGcMissionSequencePinProductSurrogate(Structure):
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TakeProductFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcMissionSequencePirates(Structure):
    RewardMessageOverride: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    AttackDefinition: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    DistanceOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    NumSquads: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]

    class ePirateSpawnTypeEnum(IntEnum):
        CargoAttackStart = 0x0
        ProbeSuccess = 0x1
        PlanetaryRaidStart = 0x2

    PirateSpawnType: Annotated[
        c_enum32[ePirateSpawnTypeEnum], Field(c_enum32[ePirateSpawnTypeEnum], 0x48)
    ]
    ForceSpawn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]


@partial_struct
class cGcMissionSequenceProductAmountNeeded(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    ToBuild: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    IsRepair: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcMissionSequenceQuickWarp(Structure):
    ScanEventToWarpTo: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    CameraShakeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    MessageCannotWarp: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    MessageWarping: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    EffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    SequenceTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    DoCameraShake: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x68)]
    DoWhiteout: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x69)]


@partial_struct
class cGcMissionSequenceRepairTech(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    TechsToRepair: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]


@partial_struct
class cGcMissionSequenceRestorePurpleSystemStats(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcMissionSequenceReward(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]

    class eRewardInventoryOverrideEnum(IntEnum):
        None_ = 0x0
        Suit = 0x1
        Ship = 0x2
        Vehicle = 0x3
        Freighter = 0x4

    RewardInventoryOverride: Annotated[
        c_enum32[eRewardInventoryOverrideEnum],
        Field(c_enum32[eRewardInventoryOverrideEnum], 0x30),
    ]
    DoMissionBoardOverride: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35)]


@partial_struct
class cGcMissionSequenceScan(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    ScanOverrideData: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    WaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    ScanTypesToOverride: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]
    BlockTimedScans: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3F)]
    RequiresMissionActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcMissionSequenceSendChatMessage(Structure):
    CustomText: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    StatusMessageId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcMissionSequenceSetCurrentMission(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    FirstIncompleteMilestone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    OverrideMultiplayerPriority: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]


@partial_struct
class cGcMissionSequenceFindPurpleSystem(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceFinishSummonAnomaly(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcMissionSequenceFreighterDefend(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceFreighterEngage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MessageEngage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    MessageGetToSpace: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    TimeoutMessage: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    TimeoutOSDMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    EngageDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    EngageTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    TimeAfterWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]


@partial_struct
class cGcMissionSequenceGatherForBuild(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    GatherResource: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    TargetTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcMissionSequenceGetInShip(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]


@partial_struct
class cGcMissionSequenceGetToExpedition(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    GalaxyMapMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    TimeoutOSD: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    CompletionDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    Timeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]


@partial_struct
class cGcMissionSequenceGetToScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    NexusMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    SurveyHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    SurveyInactiveHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    SurveySwapHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x80)
    ]
    SurveyVehicleHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xA0)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xC0)
    ]
    GalaxyMapMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xD0)
    ]
    GalaxyMapMessageNotSpace: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xE0)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xF0)]
    TimeoutOSD: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x100)
    ]
    UseTeleporterMessage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x110)
    ]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x120)]
    Timeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x124)]
    UseGPSInText: Annotated[
        c_enum32[enums.cGcScanEventGPSHint],
        Field(c_enum32[enums.cGcScanEventGPSHint], 0x128),
    ]
    AlwaysAllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12C)]
    CanFormatObjectives: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12D)]
    DistanceTimeout: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12E)]
    EndEventWhenReached: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12F)]
    RequireInsideToEnd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x130)]
    WaterworldEndEventWhenPlanetReached: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x131)
    ]


@partial_struct
class cGcMissionSequenceEndScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]


@partial_struct
class cGcMissionSequenceGetUnits(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcMissionSequenceEnsureBarrelsAtPlayerSettlement(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    MinBarrelsThreshold: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    NumBarrels: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcMissionSequenceGetUnitsToBuyItem(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]


@partial_struct
class cGcMissionSequenceExplorationLogSpecial(Structure):
    CustomPlanetLog: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CustomPlanetMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    CustomSystemLog: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    CustomSystemMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x80)
    ]


@partial_struct
class cGcMissionSequenceExploreAbandonedFreighter(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Timer: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    RequireAllRoomsDone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcMissionSequenceGoToGalacticPoint(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Target: Annotated[
        c_enum32[enums.cGcMissionGalacticPoint],
        Field(c_enum32[enums.cGcMissionGalacticPoint], 0x20),
    ]


@partial_struct
class cGcMissionSequenceFeed(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    RequireSpecificBait: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]


@partial_struct
class cGcMissionSequenceCreateSpecificPulseEncounter(Structure):
    ShipHUDOverrideWhenReady: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    MessageEncounterReady: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    MessageNoShip: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    MessageNotPulsing: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    MessageSignalBlocked: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)
    ]
    PulseEncounterID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    MinTimeInPulse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    AllowAnyEncounter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x94)]
    AllowOutsideShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x95)]
    EnsureClearOfSolarSystemObjects: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x96)
    ]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x97)]
    TakeEncounterIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x98)]


@partial_struct
class cGcMissionSequenceDetailMessagePoint(Structure):
    Text: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    InsertItemName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]

    class ePointStateEnum(IntEnum):
        Statement = 0x0
        ObjectiveIncomplete = 0x1
        ObjectiveComplete = 0x2

    PointState: Annotated[
        c_enum32[ePointStateEnum], Field(c_enum32[ePointStateEnum], 0x30)
    ]


@partial_struct
class cGcMissionSequenceDiscover(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]

    class eDiscoverTargetEnum(IntEnum):
        Animal = 0x0
        Vegetable = 0x1
        Mineral = 0x2

    DiscoverTarget: Annotated[
        c_enum32[eDiscoverTargetEnum], Field(c_enum32[eDiscoverTargetEnum], 0x28)
    ]
    PerPlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    TakeAmountFromSeasonalData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]


@partial_struct
class cGcMissionSequenceCompleteMission(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    UseSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcMissionSequenceDiscoverOnPlanet(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]

    class eDiscoverTargetOnThisPlanetEnum(IntEnum):
        Animal = 0x0
        Vegetable = 0x1
        Mineral = 0x2

    DiscoverTargetOnThisPlanet: Annotated[
        c_enum32[eDiscoverTargetOnThisPlanetEnum],
        Field(c_enum32[eDiscoverTargetOnThisPlanetEnum], 0x20),
    ]
    PercentToDiscover: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcMissionSequenceCompleteSeasonalMilestone(Structure):
    pass


@partial_struct
class cGcMissionSequenceDisplaySeasonRewardReminder(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcMissionSequenceCompleteSettlementJudgement(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MessageOptions: Annotated[
        cGcJudgementMessageOptions, Field(cGcJudgementMessageOptions, 0x10)
    ]
    MessageNoOffice: Annotated[
        cGcJudgementMessageOptions, Field(cGcJudgementMessageOptions, 0x1210)
    ]
    FormatObjectives: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1390)]


@partial_struct
class cGcMissionSequenceConditionalReward(Structure):
    Conditions: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    RewardIfFalse: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RewardIfTrue: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    ConditionTest: Annotated[
        c_enum32[enums.cGcMissionConditionTest],
        Field(c_enum32[enums.cGcMissionConditionTest], 0x40),
    ]


@partial_struct
class cGcMissionSequenceConstructSettlementBuildingWithScanEvent(Structure):
    ScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)]
    MessageWhenDistant: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    MessageWhileBuilding: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    MessageWithItemsGathered: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    UpgradeMessageWithItemsGathered: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)
    ]
    ForceCompleteSequenceAtStagePercentage: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x80)
    ]


@partial_struct
class cGcMissionSequenceCorvetteAutopilot(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MessageAutopiloting: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    MessageNotReadyToAutopilot: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    MessageReadyToAutopilot: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    RequiredAutopilotTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    TakeTimeFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]


@partial_struct
class cGcMissionSequenceCraftProduct(Structure):
    MessageCanCraft: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    MessageLearnPreReqs: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    MessageLearnRecipe: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    MessageNoIngreds: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x80)
    ]
    TargetProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    TargetAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    CanSetIcon: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA4)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA5)]
    TakeIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA6)]
    TeachIfNotKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA7)]
    WaitForSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA8)]


@partial_struct
class cGcMissionSequenceClearInventoryHistory(Structure):
    pass


@partial_struct
class cGcMissionSequenceCloseMenu(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]

    class eMenuToCloseEnum(IntEnum):
        QuickMenu = 0x0
        BuildMenu = 0x1
        Inventory = 0x2
        AllDetailMessages = 0x3

    MenuToClose: Annotated[
        c_enum32[eMenuToCloseEnum], Field(c_enum32[eMenuToCloseEnum], 0x14)
    ]


@partial_struct
class cGcDailyRecurrence(Structure):
    RecurrenceHour: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    RecurrenceMinute: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    DebugText: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x8)]


@partial_struct
class cGcMonthlyRecurrence(Structure):
    RecurrenceDay: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    RecurrenceHour: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    RecurrenceMinute: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    DebugText: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xC)]


@partial_struct
class cGcMissionSequenceCollectMultiProducts(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Message: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Products: Annotated[
        basic.cTkDynamicArray[cGcProductToCollect],
        Field(basic.cTkDynamicArray[cGcProductToCollect], 0x20),
    ]
    SearchCookingIngredients: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    WaitForSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcMissionConsequenceClearDetailMessages(Structure):
    pass


@partial_struct
class cGcDate(Structure):
    Day: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Hour: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Minute: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    Month: Annotated[c_enum32[enums.cGcMonth], Field(c_enum32[enums.cGcMonth], 0xC)]
    Year: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcMissionCommunityMissionData(Structure):
    ShowTimeToDeadline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionSequenceBounty(Structure):
    Bounty: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DebugText: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    MessageDestroy: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    MessageEngage: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    MessageGetToSpace: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]


@partial_struct
class cGcMissionSequenceBroadcastMessage(Structure):
    DebugText: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BroadcastToActiveMultiplayerMission: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x20)
    ]
    CanSendToInactive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    Multiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]
    Seeded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23)]
    SendToAllMatchingSeeds: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcMissionIDEpochPair(Structure):
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RecurrenceDeadline: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]


@partial_struct
class cGcMissionBoardOptions(Structure):
    MultiplayerMissionInitialWarpScanEvent: Annotated[
        basic.TkID0x20, Field(basic.TkID0x20, 0x0)
    ]
    BasePartBlueprints: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    DefaultItemInitialWarpScanEvents: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x30),
    ]
    Faction: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcMissionFaction]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcMissionFaction]], 0x40),
    ]
    RewardPenaltyOnAbandon: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]

    class eDefaultItemTypeForInitialWarpEnum(IntEnum):
        None_ = 0x0
        PrimaryProduct = 0x1
        PrimarySubstance = 0x2
        SecondaryProduct = 0x3
        SecondarySubstance = 0x4

    DefaultItemTypeForInitialWarp: Annotated[
        c_enum32[eDefaultItemTypeForInitialWarpEnum],
        Field(c_enum32[eDefaultItemTypeForInitialWarpEnum], 0x60),
    ]
    Difficulty: Annotated[
        c_enum32[enums.cGcMissionDifficulty],
        Field(c_enum32[enums.cGcMissionDifficulty], 0x64),
    ]
    MinRank: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    Type: Annotated[
        c_enum32[enums.cGcMissionType], Field(c_enum32[enums.cGcMissionType], 0x6C)
    ]
    Weighting: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    CloseMissionGiver: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]
    IgnoreCalculatedObjective: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75)]
    IsGuildShopMission: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x76)]
    IsMultiplayerEventMission: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x77)]
    IsPlanetProcMission: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]


@partial_struct
class cGcGenericMissionVersionProgress(Structure):
    Progress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Version: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcGenericMissionStage(Structure):
    Stage: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]
    Versions: Annotated[
        basic.cTkDynamicArray[cGcGenericMissionVersionProgress],
        Field(basic.cTkDynamicArray[cGcGenericMissionVersionProgress], 0x10),
    ]


@partial_struct
class cGcObjectiveTextFormatOptions(Structure):
    FormattableObjective: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    FormattableObjectiveTip: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    ObjectivesCanBeFormattedBySequences: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x40)
    ]


@partial_struct
class cGcSeasonalObjectiveOverrides(Structure):
    OverrideObjective: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    OverrideObjectiveTip: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    ApplicableSeasonNumbers: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x40),
    ]


@partial_struct
class cGcTargetMissionSurveyOptions(Structure):
    SurveyHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    SurveyInactiveHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    SurveySwapHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    SurveyVehicleHint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)
    ]
    TargetMissionSurveyDefinitelyExistsWithResourceHint: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x80)
    ]
    TargetMissionSurveyId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    ForceSurveyTextForAllSequencesInThisGroup: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0xA0)
    ]
    TargetMissionSurveyDefinitelyExists: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0xA1)
    ]


@partial_struct
class cGcCustomNotifyTimerOptions(Structure):
    NotifyDisplayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    NotifyPauseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HasCustomNotifyTimer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcFactionSelectOptions(Structure):
    Faction: Annotated[
        c_enum32[enums.cGcMissionFaction], Field(c_enum32[enums.cGcMissionFaction], 0x0)
    ]

    class eFactionOptionEnum(IntEnum):
        DataDefined = 0x0
        CurrentMission = 0x1
        CurrentSystem = 0x2

    FactionOption: Annotated[
        c_enum32[eFactionOptionEnum], Field(c_enum32[eFactionOptionEnum], 0x4)
    ]


@partial_struct
class cGcSeasonalLogOverrides(Structure):
    MissionDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    MissionSubtitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    MissionTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    ApplicableSeasonNumbers: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x60),
    ]


@partial_struct
class cGcMissionConsequenceBroadcastMessage(Structure):
    MessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BroadcastToActiveMultiplayerMission: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x10)
    ]
    CanSendToInactive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    Multiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]
    Seeded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x13)]
    SendToAllMatchingSeeds: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcMissionConsequenceGiveReward(Structure):
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConsequenceRemoveCommunicatorMessage(Structure):
    Comms: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcMissionConsequenceRemoveCommunicatorTakeOffMessage(Structure):
    Comms: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcMissionConsequenceRemoveScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcMissionConsequenceResetPulseEncounterOverride(Structure):
    pass


@partial_struct
class cGcMissionConsequenceResetStoryPortal(Structure):
    pass


@partial_struct
class cGcMissionConditionWeaponMode(Structure):
    WeaponMode: Annotated[
        c_enum32[enums.cGcPlayerWeapons], Field(c_enum32[enums.cGcPlayerWeapons], 0x0)
    ]


@partial_struct
class cGcMissionConsequenceSetMissionStat(Structure):
    ValueToAdd: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    ValueToSet: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcDefaultMissionSubstance(Structure):
    Substance: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionWeather(Structure):
    WeatherRequirement: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x0),
    ]
    AllowNonHazardExtremeIfNoStorms: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    IgnoreStormIfInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]
    IsExtreme: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6)]
    StormActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7)]
    UseStrictSkyExtremeTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcDefaultMissionProduct(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcDefaultMissionItemsTable(Structure):
    PrimaryProducts: Annotated[
        basic.cTkDynamicArray[cGcDefaultMissionProduct],
        Field(basic.cTkDynamicArray[cGcDefaultMissionProduct], 0x0),
    ]
    PrimarySubstances: Annotated[
        basic.cTkDynamicArray[cGcDefaultMissionSubstance],
        Field(basic.cTkDynamicArray[cGcDefaultMissionSubstance], 0x10),
    ]
    SecondaryProducts: Annotated[
        basic.cTkDynamicArray[cGcDefaultMissionProduct],
        Field(basic.cTkDynamicArray[cGcDefaultMissionProduct], 0x20),
    ]
    SecondarySubstances: Annotated[
        basic.cTkDynamicArray[cGcDefaultMissionSubstance],
        Field(basic.cTkDynamicArray[cGcDefaultMissionSubstance], 0x30),
    ]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    AmountShouldBeRoundNumber: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]


@partial_struct
class cGcMissionConditionWristMenuOpen(Structure):
    GunHandOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    InventoryOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]
    LeftHandOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2)]
    QuickMenuOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3)]


@partial_struct
class cGcMissionConditionWaitForTime(Structure):
    WaitTimeInSeconds: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    ThisConditionWillSetMissionUserDataIsThatOk: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x8)
    ]


@partial_struct
class cGcMissionConditionWarping(Structure):
    pass


@partial_struct
class cGcMissionConditionTakingDamage(Structure):
    DamageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RequireShieldDown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcMissionConditionWaterInSystem(Structure):
    WaterworldSpecific: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionTechGroupCount(Structure):
    TechGroups: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x0),
    ]
    TargetCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    TakeCountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    TestDraftCorvette: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcMissionConditionWaterPlanet(Structure):
    pass


@partial_struct
class cGcMissionConditionTechnologyKnown(Structure):
    Technology: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DependentOnSeasonMilestone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    TakeTechFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcMissionConditionTetheredToCorvette(Structure):
    pass


@partial_struct
class cGcMissionConditionThisMissionStageIndex(Structure):
    StageIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionTotalWarpsNumber(Structure):
    WarpsNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionTouchControlled(Structure):
    pass


@partial_struct
class cGcMissionConditionTradeSurge(Structure):
    ControllingScanEvent: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]

    class eSurgeTestTypeEnum(IntEnum):
        Timer = 0x0
        Collection = 0x1
        Delivery = 0x2

    SurgeTestType: Annotated[
        c_enum32[eSurgeTestTypeEnum], Field(c_enum32[eSurgeTestTypeEnum], 0x20)
    ]
    TimeToCompleteInMinutes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcMissionConditionTrial(Structure):
    pass


@partial_struct
class cGcMissionConditionTutorialEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionUnclaimedStageReward(Structure):
    OptionalSpecificProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionUnderwaterDepth(Structure):
    Depth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    InBaseCanCountAsUnderwater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    ReturnTrueIfWaterBelowIsAtDepth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6)]


@partial_struct
class cGcMissionConditionSystemHasGasGiant(Structure):
    pass


@partial_struct
class cGcMissionConditionSystemHasInfestedPlanet(Structure):
    pass


@partial_struct
class cGcMissionConditionSystemHasRobotCreatures(Structure):
    RequireOnPlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionSystemHasRuinsPlanet(Structure):
    pass


@partial_struct
class cGcMissionConditionSystemPlanetTest(Structure):
    PlanetBiomeRequirement: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x0)
    ]
    PlanetWeatherRequirement: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x4),
    ]
    RequiresExtremePlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    UseStrictSkyExtremeTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]


@partial_struct
class cGcMissionConditionVisorActive(Structure):
    pass


@partial_struct
class cGcMissionConditionWaitForPirates(Structure):
    LivingPirates: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    CareAboutAttackingPlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    CheckAllFireteamMembers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]
    CompleteOnlyInSpace: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]
    CountHostileTraders: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB)]


@partial_struct
class cGcMissionConditionStatLevel(Structure):
    CompareStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FormatItemNameIntoText: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    FormatStatStyle: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    StatGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    DisplayMilestoneNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    LevelledStatRank: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x58)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x5C)
    ]
    ForceIgnoreLevelledStat: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    MulAmountBySeasonTier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]
    TakeLevelFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x62)]
    TakeStatFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x63)]


@partial_struct
class cGcMissionConditionSystemHasCorruptedPlanet(Structure):
    AllowNexus: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionSeasonRewardsRecipe(Structure):
    RecipeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionSystemHasCreatureType(Structure):
    CreatureID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AllowInNexus: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    RequireOnPlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcMissionConditionSeasonRewardUnlocked(Structure):
    SpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionSentinelsDisabled(Structure):
    pass


@partial_struct
class cGcMissionConditionSettlementBuildingsAllStarted(Structure):
    pass


@partial_struct
class cGcMissionConditionSettlementMatchesSeed(Structure):
    pass


@partial_struct
class cGcMissionConditionSettlementsEnabled(Structure):
    pass


@partial_struct
class cGcMissionConditionSettlementsHaveEverBeenDisabled(Structure):
    pass


@partial_struct
class cGcMissionConditionShieldDown(Structure):
    RequireOnFoot: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionSpaceCombatEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionRefinerHasOutput(Structure):
    OutputProduct: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OutputAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MustBeCooker: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    MustBeCorvetteModule: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x16)]


@partial_struct
class cGcMissionConditionSpecialKnown(Structure):
    SpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionSquadronPilotsOwned(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    TakeNumberFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcMissionConditionRequestedPhoto(Structure):
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x0)
    ]


@partial_struct
class cGcMissionConditionSquadronSlots(Structure):
    PilotSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    OnlyCountFreeSlots: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    TakeNumberFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]


@partial_struct
class cGcMissionConditionRidingCreature(Structure):
    pass


@partial_struct
class cGcMissionConditionSeasonAvailable(Structure):
    pass


@partial_struct
class cGcMissionConditionStartWithAllPartsKnown(Structure):
    pass


@partial_struct
class cGcMissionConditionStatChange(Structure):
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    StatGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcMissionConditionSeasonNumber(Structure):
    IncludeOtherSeasons: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x0),
    ]
    ActiveSeason: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    IncludeRemix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcMissionConditionStatDiff(Structure):
    CurrentStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TargetStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AmountPastTarget: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x24)
    ]


@partial_struct
class cGcMissionConditionOnPlanetWithSandwormsOverriden(Structure):
    AcceptMatchingSystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    AllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcMissionConditionReadyToSpawnPirates(Structure):
    pass


@partial_struct
class cGcMissionConditionPadActive(Structure):
    pass


@partial_struct
class cGcMissionConditionRefinerActive(Structure):
    ActiveRecipe: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    AmountToMake: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    HasFuel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcMissionConditionPercentageChance(Structure):
    Percent: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    OverrideMissionSeedWithRandomSeed: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4)
    ]
    OverrideZeroSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]
    Seeded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6)]


@partial_struct
class cGcMissionConditionRefinerHasInput(Structure):
    InputProduct: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    InputAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MustBeCooker: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    MustBeCorvetteModule: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcMissionConditionPirateFreighterSurrendered(Structure):
    pass


@partial_struct
class cGcMissionConditionPirateSystem(Structure):
    pass


@partial_struct
class cGcMissionConditionPlanetAttackPiratesActive(Structure):
    pass


@partial_struct
class cGcMissionConditionPlanetCorruptSentinelGeneration(Structure):
    pass


@partial_struct
class cGcMissionConditionPlanetCreatureRoles(Structure):
    NumRoles: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    TakeNumFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcMissionConditionPlanetResourceHint(Structure):
    UseScanEventToDetermineLocalResource: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ResourceHint: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    LocalSubstanceType: Annotated[
        c_enum32[enums.cGcLocalSubstanceType],
        Field(c_enum32[enums.cGcLocalSubstanceType], 0x30),
    ]
    UseSpecificPlanetIndexForLocalResource: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x34)
    ]
    AllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]
    AllowNexus: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x39)]
    TestAllPlanetsInSystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A)]
    UseRandomPlanetIndexForLocalResource: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3B)
    ]


@partial_struct
class cGcMissionConditionPlanetStatLevel(Structure):
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    SpecificUA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x1C)
    ]
    CalculateUAFromMilestoneIndex: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    CalculateUAFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]
    UseCurrentUA: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23)]


@partial_struct
class cGcMissionConditionNumAtlasStationsVisited(Structure):
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionNumberOfShipsOwned(Structure):
    NumShips: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionPrimaryExocraft(Structure):
    ExocraftType: Annotated[
        c_enum32[enums.cGcVehicleType], Field(c_enum32[enums.cGcVehicleType], 0x0)
    ]
    MustBeSummonedNearby: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionNumBrokenSlots(Structure):
    class eInventoryToTestEnum(IntEnum):
        Ship = 0x0
        ShipTech = 0x1
        Weapon = 0x2

    InventoryToTest: Annotated[
        c_enum32[eInventoryToTestEnum], Field(c_enum32[eInventoryToTestEnum], 0x0)
    ]
    NumberOfBrokenSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]


@partial_struct
class cGcMissionConditionProductKnown(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x10),
    ]
    DependentOnSeasonMilestone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    TakeProductFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcMissionConditionOnFootCombatEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionPulseEncounterActive(Structure):
    SpecificObjectID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eTestEncounterTypeEnum(IntEnum):
        AnyEncounter = 0x0
        AnyObject = 0x1
        SpecificObject = 0x2
        Trader = 0x3
        AbandonedFreighter = 0x4
        AnyEncounterOtherThanTheNamedOne = 0x5
        SpecificID = 0x6

    TestEncounterType: Annotated[
        c_enum32[eTestEncounterTypeEnum], Field(c_enum32[eTestEncounterTypeEnum], 0x10)
    ]
    RequireFullySpawned: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcMissionConditionOnMultiplayerMission(Structure):
    IncludeCorvetteMissions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionOnOtherSideOfPortal(Structure):
    TestForRegularPortal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    TestForStoryPortal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcMissionConditionPulseEncounterOverriden(Structure):
    pass


@partial_struct
class cGcMissionConditionLocalScanActive(Structure):
    pass


@partial_struct
class cGcMissionConditionNexusEnabled(Structure):
    pass


@partial_struct
class cGcMissionConditionLocalSystemHasTradeSurgeGoods(Structure):
    pass


@partial_struct
class cGcMissionConditionNexusNearby(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcMissionConditionMessageBeaconsQuery(Structure):
    MaxPartsFound: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MinPartsFound: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    SearchDistanceLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcMissionConditionMissionCompleted(Structure):
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CalculateSeasonalSeedFromStageIndexOffset: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x10)
    ]
    SeasonalMissionSeed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    CalculateTextMissionTargetFromStageIndex: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x18)
    ]
    TakeIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]


@partial_struct
class cGcMissionConditionMissionMessage(Structure):
    Message: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MessageToFormatSeasonalIDInto: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]


@partial_struct
class cGcMissionConditionMissionMessagePortal(Structure):
    pass


@partial_struct
class cGcMissionConditionMissionMessageWarp(Structure):
    pass


@partial_struct
class cGcMissionConditionMissionSelected(Structure):
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionMissionStatValue(Structure):
    MissionStatValue: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]


@partial_struct
class cGcMissionConditionMultiplayerFreighterAvailable(Structure):
    pass


@partial_struct
class cGcMissionConditionIsSurveying(Structure):
    class eForHotspotTypeEnum(IntEnum):
        Any = 0x0
        Power = 0x1
        Gas = 0x2
        Minerals = 0x3

    ForHotspotType: Annotated[
        c_enum32[eForHotspotTypeEnum], Field(c_enum32[eForHotspotTypeEnum], 0x0)
    ]
    RequireAlreadyAnalysed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionNearFossilDisplay(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MustBeComplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionNearObject(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eMissionObjectEnum(IntEnum):
        PlayerShip = 0x0
        PlayerVehicle = 0x1
        PlayerSubmarine = 0x2
        StoryPortal = 0x3
        OpenStoryPortal = 0x4
        OpenStandardPortal = 0x5

    MissionObject: Annotated[
        c_enum32[eMissionObjectEnum], Field(c_enum32[eMissionObjectEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionNearPole(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class ePoleConditionEnum(IntEnum):
        North = 0x0
        South = 0x1

    PoleCondition: Annotated[
        c_enum32[ePoleConditionEnum], Field(c_enum32[ePoleConditionEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionNearRobotSite(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    RequireNPCs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    RequireRevealTech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionItemRewardedBySeason(Structure):
    ItemID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TakeIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcMissionConditionNearScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    MustMatchThisMissionIDSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    RequiresFullFireteam: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    ReturnTrueIfMarkerGone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]


@partial_struct
class cGcMissionConditionLifeSupportEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionNearSettlement(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AllowBuildersSettlement: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    MustMatchThisMissionSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionInventoryOpen(Structure):
    pass


@partial_struct
class cGcMissionConditionIsScanEventOnCurrentPlanet(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    AllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcMissionConditionIsScanEventRepaired(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    CheckForAllRepairsInBuilding: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    OnlyCheckRequiresEmptySlotTypes: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x21)
    ]


@partial_struct
class cGcMissionConditionInventorySlots(Structure):
    class eInventoryTestEnum(IntEnum):
        Current = 0x0
        Personal = 0x1
        Ship = 0x2
        Vehicle = 0x3
        Weapon = 0x4
        CorvetteStorage = 0x5

    InventoryTest: Annotated[
        c_enum32[eInventoryTestEnum], Field(c_enum32[eInventoryTestEnum], 0x0)
    ]
    SlotsFree: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]
    TestAllSlotsUnlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]
    TestAnySlotOccupied: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD)]
    TestOnlyMainInventory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE)]


@partial_struct
class cGcMissionConditionInVR(Structure):
    NeedsHandControllers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    NeedsNoHandControllers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]
    NeedsSmoothMoveOn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2)]
    NeedsSnapTurnOn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3)]
    NeedsTeleportOn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionIsCurrentMission(Structure):
    pass


@partial_struct
class cGcMissionConditionIsDepotDestroyed(Structure):
    ControllingScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcMissionConditionIsFirstPurpleSystemLocal(Structure):
    pass


@partial_struct
class cGcMissionConditionIsFishing(Structure):
    MinimumDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    TakeDepthFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionIsGrabbed(Structure):
    pass


@partial_struct
class cGcMissionConditionIsLookingAtAnomaly(Structure):
    FOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcMissionConditionIsMissionInProgress(Structure):
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MustBeSelectedMission: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcMissionConditionInCombat(Structure):
    OverrideOSDMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]

    class eCombatTypeEnum(IntEnum):
        GroundCombat = 0x0
        SpaceCombat = 0x1
        FiendCombat = 0x2
        BigFishFiendCombat = 0x3
        CorruptedSentinelCombat = 0x4
        GroundWormCombat = 0x5
        RewardEncounter = 0x6
        BugQueen = 0x7
        JellyBoss = 0x8

    CombatType: Annotated[
        c_enum32[eCombatTypeEnum], Field(c_enum32[eCombatTypeEnum], 0x20)
    ]
    CheckAllFireteamMembers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    EncouragesFightingSentinels: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    SpaceCombatTextCountsPirates: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    SpaceCombatTextCountsSentinels: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]


@partial_struct
class cGcMissionConditionIsPartyPlanetUnlocked(Structure):
    SpecificRendevousPlanetIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    TakeIndexFromMilestoneStage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    TakeIndexFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionInMultiplayer(Structure):
    MustBeInFireteam: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionIsPlayerWanted(Structure):
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionInSeasonalUA(Structure):
    SpecificRendevousPlanetIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    CompleteIfRendezvousDone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    SpecificIndexOnlyNeedsToMatchSystem: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x5)
    ]
    TakeIndexFromMilestoneStage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6)]
    TakeIndexFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7)]


@partial_struct
class cGcMissionConditionIsScanEventActive(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    MustMatchThisMissionIDSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcMissionConditionIsScanEventLocal(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    BlockMissionRestart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    RequiresFullFireteam: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]


@partial_struct
class cGcMissionConditionInUA(Structure):
    UA: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)]


@partial_struct
class cGcMissionConditionIsScanEventLocalOrNear(Structure):
    Local: Annotated[
        cGcMissionConditionIsScanEventLocal,
        Field(cGcMissionConditionIsScanEventLocal, 0x0),
    ]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcMissionConditionHazard(Structure):
    Hazard: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x0),
    ]


@partial_struct
class cGcMissionConditionHasProcTechnology(Structure):
    ProcTechGroupID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcMissionConditionHazardLevel(Structure):
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    SpecificHazard: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x4),
    ]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]


@partial_struct
class cGcMissionConditionHazardsEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionHasSeasonalReward(Structure):
    pass


@partial_struct
class cGcMissionConditionHasSettlementLocal(Structure):
    pass


@partial_struct
class cGcMissionConditionHasSettlementProductPending(Structure):
    pass


@partial_struct
class cGcMissionConditionHasSpareProcTech(Structure):
    pass


@partial_struct
class cGcMissionConditionHasTechnology(Structure):
    Technology: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AllowPartiallyInstalled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    TakeTechFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    TeachIfNotKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]


@partial_struct
class cGcMissionConditionHasTwitchReward(Structure):
    pass


@partial_struct
class cGcMissionConditionHasPendingSettlementJudgement(Structure):
    SpecificID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionHasUnlockedPurpleSystems(Structure):
    pass


@partial_struct
class cGcMissionConditionHasPlatformReward(Structure):
    pass


@partial_struct
class cGcMissionConditionHasValidSaveContext(Structure):
    CurrentContext: Annotated[
        c_enum32[enums.cGcSaveContextQuery],
        Field(c_enum32[enums.cGcSaveContextQuery], 0x0),
    ]
    DesiredContext: Annotated[
        c_enum32[enums.cGcSaveContextQuery],
        Field(c_enum32[enums.cGcSaveContextQuery], 0x4),
    ]


@partial_struct
class cGcMissionConditionHasProcMissionForFaction(Structure):
    Faction: Annotated[
        c_enum32[enums.cGcMissionFaction], Field(c_enum32[enums.cGcMissionFaction], 0x0)
    ]


@partial_struct
class cGcMissionConditionHasWeapons(Structure):
    CountForInstalledTests: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]

    class eWeaponTestEnum(IntEnum):
        CombatPrimaryEquipped = 0x0
        CombatSecondaryEquipped = 0x1
        CombatPrimaryInstalled = 0x2
        CombatSecondaryInstalled = 0x3
        ExocraftCombatInstalled = 0x4
        ExocraftCombatActive = 0x5

    WeaponTest: Annotated[
        c_enum32[eWeaponTestEnum], Field(c_enum32[eWeaponTestEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionHasLegacyBasePending(Structure):
    pass


@partial_struct
class cGcMissionConditionHasEndpointForEvent(Structure):
    EventID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcMissionConditionHasLocalSubstance(Structure):
    UseScanEventToDetermineLocation: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    DefaultValueMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    LocalSubstanceType: Annotated[
        c_enum32[enums.cGcLocalSubstanceType],
        Field(c_enum32[enums.cGcLocalSubstanceType], 0x28),
    ]
    UseSpecificPlanetIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    UseDefaultValue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    UseRandomPlanetIndex: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcMissionConditionHasEntitlement(Structure):
    Entitlement: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionHasMessageWithTitle(Structure):
    TitleLocId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcMissionConditionHasExocraft(Structure):
    ExocraftType: Annotated[
        c_enum32[enums.cGcVehicleType], Field(c_enum32[enums.cGcVehicleType], 0x0)
    ]
    SpecificExocraft: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionHasMilestoneThatCouldRewardItem(Structure):
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Recipe: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcMissionConditionHasFuelForTakeoff(Structure):
    FormatTextAsPercentage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionHasGalacticFeature(Structure):
    Type: Annotated[
        c_enum32[enums.cGcMissionGalacticFeature],
        Field(c_enum32[enums.cGcMissionGalacticFeature], 0x0),
    ]
    RequireUnusedAtlas: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionHasGrabbableTarget(Structure):
    pass


@partial_struct
class cGcMissionConditionHasActiveStatsMessage(Structure):
    pass


@partial_struct
class cGcMissionConditionHasGrave(Structure):
    pass


@partial_struct
class cGcMissionConditionHasAnySettlementBuildingInProgress(Structure):
    IgnoreIfTimerActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionHasIllegalGoods(Structure):
    IncludeNipNip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionHasBait(Structure):
    SpecificID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OnlyPrimaryBait: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    RequireInBaitBox: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    TakeSpecificBaitIDFromSeasonData: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x12)
    ]


@partial_struct
class cGcMissionConditionHasIncompleteOptionalMilestones(Structure):
    ForStageIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionHasCommunicatorSignal(Structure):
    SpecificSignalID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CallMustBePending: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    SpecificSignalIsCurrentIntervention: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x21)
    ]


@partial_struct
class cGcMissionConditionHasItemFromListOfValue(Structure):
    ItemList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    UnitValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcMissionConditionHasCreatureEggItem(Structure):
    class eEggItemTypeEnum(IntEnum):
        Egg = 0x0
        ValidCatalyst = 0x1

    EggItemType: Annotated[
        c_enum32[eEggItemTypeEnum], Field(c_enum32[eEggItemTypeEnum], 0x0)
    ]
    IncludeEggMachineInventoryInSearch: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4)
    ]


@partial_struct
class cGcMissionConditionGroup(Structure):
    Conditions: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    ConditionTest: Annotated[
        c_enum32[enums.cGcMissionConditionTest],
        Field(c_enum32[enums.cGcMissionConditionTest], 0x10),
    ]
    OnlyUsedForTextFormatting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    ValueToReturnForTextFormatting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcMissionConditionDiscoveryPendingUpload(Structure):
    pass


@partial_struct
class cGcMissionConditionEggMachinePageOpen(Structure):
    pass


@partial_struct
class cGcMissionConditionGunOut(Structure):
    pass


@partial_struct
class cGcMissionConditionElevation(Structure):
    HeightAboveSea: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AllowInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionHasActiveDetailMessage(Structure):
    pass


@partial_struct
class cGcMissionConditionExocraftMoving(Structure):
    pass


@partial_struct
class cGcMissionConditionExpeditionContainsReward(Structure):
    RewardID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionExpeditionCount(Structure):
    ExpeditionCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    ActiveExpeditionsCountAsFueled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    OnlyCountAwaitingDebrief: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]
    OnlyCountIfActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]
    OnlyCountIfActiveWithRemainingEvents: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0xB)
    ]
    OnlyCountIfFueled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcMissionConditionExpeditionNearlyOver(Structure):
    RemainingTimeToStartWarning: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]


@partial_struct
class cGcMissionConditionExpeditionProgress(Structure):
    pass


@partial_struct
class cGcMissionConditionExtraSuitSlots(Structure):
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionFactionRank(Structure):
    Faction: Annotated[
        c_enum32[enums.cGcMissionFaction], Field(c_enum32[enums.cGcMissionFaction], 0x0)
    ]
    Rank: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    UseSystemRace: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcMissionConditionFeedingCreatures(Structure):
    MinCreatures: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    TakeNumFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionCreatureTrust(Structure):
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x0)
    ]
    Trust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcMissionConditionFirstPurpleSystemValid(Structure):
    CheckDistance: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionCriticalMissionsDone(Structure):
    OnlyCheckSeasonalCriticals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    Warped: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcMissionConditionForceHideMultiplayer(Structure):
    pass


@partial_struct
class cGcMissionConditionCurrentPlanetVisited(Structure):
    JustTestSeasonStartPlanetHack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionFreighterBattle(Structure):
    FreighterBattleDistance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]

    class eFreighterBattleStatusEnum(IntEnum):
        None_ = 0x0
        Active = 0x1
        Joined = 0x2
        Reward = 0x3

    FreighterBattleStatus: Annotated[
        c_enum32[eFreighterBattleStatusEnum],
        Field(c_enum32[eFreighterBattleStatusEnum], 0x4),
    ]
    FreighterBattleTest: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]
    HostileFreighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcMissionConditionCurrentSlope(Structure):
    SlopeAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    Abs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcMissionConditionFrigateCount(Structure):
    FrigateCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]


@partial_struct
class cGcMissionConditionDamagedFrigateAtHome(Structure):
    pass


@partial_struct
class cGcMissionConditionDefaultItem(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ProductType: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x10),
    ]
    SubstanceType: Annotated[
        c_enum32[enums.cGcDefaultMissionSubstanceEnum],
        Field(c_enum32[enums.cGcDefaultMissionSubstanceEnum], 0x14),
    ]


@partial_struct
class cGcMissionConditionBlackHolesRevealed(Structure):
    pass


@partial_struct
class cGcMissionConditionCreatureReadyToHatch(Structure):
    pass


@partial_struct
class cGcMissionConditionCreatureReadyToLay(Structure):
    PrimaryCreatureOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionCreatureSlots(Structure):
    CreatureSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x4)
    ]
    OnlyCountFreeSlots: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcMissionConditionCameraControlStealing(Structure):
    pass


@partial_struct
class cGcMissionConditionCreatureSummoned(Structure):
    pass


@partial_struct
class cGcMissionConditionCanMakeFossil(Structure):
    NearbyDisplayDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ConsiderItemsInNearbyDisplays: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionCanMakeItem(Structure):
    TargetItem: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcMissionConditionCanPayCost(Structure):
    CostID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionCanReceiveReward(Structure):
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcMissionConditionCanRenameDiscovery(Structure):
    ValueToReturnWhileSearchActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionCanSpaceDock(Structure):
    pass


@partial_struct
class cGcMissionConditionCanSummonExocraft(Structure):
    SummonableExocraft: Annotated[
        c_enum32[enums.cGcVehicleType], Field(c_enum32[enums.cGcVehicleType], 0x0)
    ]
    SpecificExocraft: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionCheckScanEventMissionState(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    RequiredState: Annotated[
        c_enum32[enums.cGcInteractionMissionState],
        Field(c_enum32[enums.cGcInteractionMissionState], 0x20),
    ]
    AlsoAcceptMaintenanceDone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcMissionConditionCombinedStatLevel(Structure):
    Stats: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Modulo: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x18)
    ]


@partial_struct
class cGcMissionConditionCommunityResearchTier(Structure):
    CompletedTiers: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MissionIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]
    TakeTierFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcMissionConditionConvertedFromSeason(Structure):
    Season: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionBaseRequiresPower(Structure):
    MinNumPowerUsingParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionCookingSearch(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    IfCookerOutputMustBeCorvetteModule: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x14)
    ]
    ReturnTrueIfCanMakeProduct: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]
    SetIcon: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x16)]


@partial_struct
class cGcMissionConditionBinocsActive(Structure):
    pass


@partial_struct
class cGcMissionConditionBiomeType(Structure):
    Type: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x0)
    ]
    AnyInfested: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    AnyRuins: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionCreatureOwned(Structure):
    SpecificCreatureID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x14)
    ]
    AnyPredator: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcModelExplosionRule(Structure):
    AxisMultiplier: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]

    class eExplodeActionEnum(IntEnum):
        RelativeToParent = 0x0
        DontMove = 0x1
        SaveCenter = 0x2
        RelativeToSaved = 0x3

    ExplodeAction: Annotated[
        c_enum32[eExplodeActionEnum], Field(c_enum32[eExplodeActionEnum], 0x20)
    ]
    ExplodeMod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]

    class eMatchNameEnum(IntEnum):
        ContainsString = 0x0
        ExactString = 0x1

    MatchName: Annotated[
        c_enum32[eMatchNameEnum], Field(c_enum32[eMatchNameEnum], 0x28)
    ]

    class eMatchNodeTypeEnum(IntEnum):
        Any = 0x0
        Mesh = 0x1
        Model = 0x2
        Joint = 0x3

    MatchNodeType: Annotated[
        c_enum32[eMatchNodeTypeEnum], Field(c_enum32[eMatchNodeTypeEnum], 0x2C)
    ]
    String: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x30)]


@partial_struct
class cGcMissionConditionBasePowerGenerated(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MustBeSpare: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    TakeAmountFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcMissionConditionAbandonedFreighterExplored(Structure):
    TargetRooms: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMissionConditionAbandonedMode(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcMissionConditionAimingTeleporter(Structure):
    pass


@partial_struct
class cGcMissionConditionAlienPodAggroed(Structure):
    Threshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcMissionConditionAllMilestonesComplete(Structure):
    ForStage: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    UseSeasonOverrideMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionAllSystemPlanetsDiscovered(Structure):
    DisplayNumberOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    OnlyMoons: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMissionConditionAreDroneHivePartsDestroyed(Structure):
    ControllingScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcMissionConditionAutoPowerEnabled(Structure):
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcScanEventTriggers(Structure):
    Triggers: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Range: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AllowRetrigger: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcMissionConditionBasePartNear(Structure):
    PartID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    TakeIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRegionHotspotData(Structure):
    ClassStrengths: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ClassWeightings: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DiscoveryDistanceThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MinRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ProbabilityWeighting: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]


@partial_struct
class cGcRegionHotspotSubstance(Structure):
    SubstanceId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AmountCost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    SubstanceYeild: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcRoomCountRule(Structure):
    RoomID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Max: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Min: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcRoomSequenceRule(Structure):
    MustBeAfterRoom: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MustBeBeforeRoom: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    RoomID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    MinRoomIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]


@partial_struct
class cGcQuestItemPlacementRule(Structure):
    MustBeAfterQuestItem: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MustBeBeforeQuestItem: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    QuestItemID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ValidRoomIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    MaxRoomIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    MinRoomIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]


@partial_struct
class cGcRegionHotspotBiomeGases(Structure):
    Gas1Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Gas2Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcFreighterDungeonChoice(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Weighting: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcFrigateUITraitLines(Structure):
    Line0: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Line1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Line2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Line3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Line4: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcFrigateClassCost(Structure):
    Cost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcGaussianCurveData(Structure):
    Mean: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    StdDev: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcInventoryClassCostMultiplier(Structure):
    Multiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcFrigateStatRange(Structure):
    Maximum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Minimum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcFrigateStats(Structure):
    InitialTrait: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Stats: Annotated[cGcFrigateStatRange, Field(cGcFrigateStatRange, 0x10)]


@partial_struct
class cGcPhysicsCollisionGroupCollidesWith(Structure):
    CollidesWith: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcPhysicsCollisionGroups]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcPhysicsCollisionGroups]], 0x0),
    ]
    Group: Annotated[
        c_enum32[enums.cGcPhysicsCollisionGroups],
        Field(c_enum32[enums.cGcPhysicsCollisionGroups], 0x10),
    ]


@partial_struct
class cGcFrigateStatsByClass(Structure):
    FrigateClass: Annotated[cGcFrigateStats, Field(cGcFrigateStats, 0x0)]


@partial_struct
class cGcFreighterBaseOption(Structure):
    BaseDataFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    ProbabilityWeighting: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcFrigateTraitIcons(Structure):
    Icons: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcFreighterBaseOptions(Structure):
    FreighterBases: Annotated[
        basic.cTkDynamicArray[cGcFreighterBaseOption],
        Field(basic.cTkDynamicArray[cGcFreighterBaseOption], 0x0),
    ]


@partial_struct
class cGcFrigateTraitStrengthValues(Structure):
    StatLocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    StatAlteration: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    StatDisplaysPositive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]


@partial_struct
class cGcFrigateTraitStrengthByType(Structure):
    FrigateStatType: Annotated[
        cGcFrigateTraitStrengthValues, Field(cGcFrigateTraitStrengthValues, 0x0)
    ]


@partial_struct
class cGcFishingRodData(Structure):
    DescriptorGroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcExpeditionCategoryStrength(Structure):
    OccurranceChance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcExpeditionDebriefPunctuation(Structure):
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Punctuation: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x4)
    ]


@partial_struct
class cGcExpeditionDifficultyKeyframe(Structure):
    Difficulty: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    EventNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcExpeditionDurationValues(Structure):
    Duration: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcFishSizeProbability(Structure):
    BaseWeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    DepthModifier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    DepthRangeMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    DepthRangeMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]


@partial_struct
class cGcFishSizeProbabilityBiomeOverride(Structure):
    SizeWeights: Annotated[cGcFishSizeProbability, Field(cGcFishSizeProbability, 0x0)]
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x40)
    ]


@partial_struct
class cGcExpeditionEventOccurrenceRate(Structure):
    ExpeditionCategory: Annotated[
        cGcExpeditionCategoryStrength, Field(cGcExpeditionCategoryStrength, 0x0)
    ]


@partial_struct
class cGcDungeonRoomParams(Structure):
    RoomId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BranchProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcExpeditionPaymentToken(Structure):
    TokenName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TokenValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcDungeonQuestParams(Structure):
    QuestItems: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcDungeonGenerationParams(Structure):
    BranchRoomTypes: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    GenerationRules: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x10),
    ]
    MainRoomTypes: Annotated[
        basic.cTkDynamicArray[cGcDungeonRoomParams],
        Field(basic.cTkDynamicArray[cGcDungeonRoomParams], 0x20),
    ]
    PruningRules: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    Quests: Annotated[
        basic.cTkDynamicArray[cGcDungeonQuestParams],
        Field(basic.cTkDynamicArray[cGcDungeonQuestParams], 0x40),
    ]
    EntranceX: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x50)]
    EntranceY: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x54)]
    EntranceZ: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x58)]
    Rooms: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x5C)]
    SizeX: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x60)]
    SizeY: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x64)]
    SizeZ: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x68)]
    StraightMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    XProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    YProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    ZProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]


@partial_struct
class cGcFishData(Structure):
    CatchIncrementsStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MissionSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RequiresMissionActive: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    MissionCatchChanceOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Quality: Annotated[
        c_enum32[enums.cGcItemQuality], Field(c_enum32[enums.cGcItemQuality], 0x44)
    ]
    Size: Annotated[
        c_enum32[enums.cGcFishSize], Field(c_enum32[enums.cGcFishSize], 0x48)
    ]
    Time: Annotated[
        c_enum32[enums.cGcFishingTime], Field(c_enum32[enums.cGcFishingTime], 0x4C)
    ]
    Biome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    MissionMustAlsoBeSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]
    NeedsStorm: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x62)]


@partial_struct
class cGcFishingRecord(Structure):
    ProductList: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LargestCatchList: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1000)]
    ProductCountList: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x1400)]


@partial_struct
class cGcGalaxyStarColours(Structure):
    ColourByStarType: Annotated[basic.Colour, Field(basic.Colour, 0x0)]


@partial_struct
class cGcGalaxyVoxelAttributesData(Structure):
    AtlasStationIndices: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    BlackholeIndices: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    TransitPopulationDistanceRange: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x60)
    ]
    AtlasStationCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    BlackholeCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x6C)]
    GuideStarMinimumCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    GuideStarRenegadeCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    PurpleSystemsCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]
    PurpleSystemsStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x7C)]
    RegionColourValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    TransitPopulationPerpDistance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x84)
    ]
    UnitDistanceFromGoalEdge: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    InsideGoalGap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8C)]


@partial_struct
class cGcAsteroidGenerationData(Structure):
    NoiseRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    ScaleVariance: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    FadeRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Health: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    NoiseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcAsteroidSystemGenerationData(Structure):
    CommonAsteroidData: Annotated[
        cGcAsteroidGenerationData, Field(cGcAsteroidGenerationData, 0x0)
    ]
    LargeAsteroidData: Annotated[
        cGcAsteroidGenerationData, Field(cGcAsteroidGenerationData, 0x24)
    ]
    RareAsteroidData: Annotated[
        cGcAsteroidGenerationData, Field(cGcAsteroidGenerationData, 0x48)
    ]
    RingAsteroidData: Annotated[
        cGcAsteroidGenerationData, Field(cGcAsteroidGenerationData, 0x6C)
    ]


@partial_struct
class cGcBaitData(Structure):
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RarityBoosts: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SizeBoosts: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    DayTimeBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    NightTimeBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    StormBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]


@partial_struct
class cGcCutSceneClouds(Structure):
    BottomColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    InitialOffsetWorldSpace: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    TopColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    StratosphereWindOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x30)]
    WindOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x38)]
    AbsorbtionFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    AnimScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    AtmosphereEndHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    AtmosphereStartHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    Coverage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Density: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    StratosphereHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    ControlClouds: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5C)]


@partial_struct
class cGcDebugObjectDecoration(Structure):
    Facing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Local: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x50)]
    Resource: Annotated[basic.GcResource, Field(basic.GcResource, 0x60)]


@partial_struct
class cGcGalaxyCameraData(Structure):
    CameraFOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CameraShakeDriftClip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CameraShakeDriftShift: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    CameraShakeMaximum: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    CameraShakeSmoothingRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FixedZoomRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    FreeElevationBlendRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    FreePanSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    FreePanSpeedTurbo: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FreeRotateSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FreeUpDownSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FreeUpDownSpeedTurbo: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    LockTransitionRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    LockedScaledElevationSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    LockedScaledPushSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    LockedSpinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MaxZoomDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MinPushingZoomDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinPushingZoomDistanceScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MinZoomDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MovementBlendRateFree: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    MovementBlendRateLocked: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    MovementBlendRateLookLocked: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    ZoomInRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    ZoomOutElevation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    ZoomOutPushDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    ZoomOutRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    ZoomOutSpin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]


@partial_struct
class cGcGalaxyGenerationSetupData(Structure):
    InnerSectorColours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    InnerFieldScales: Annotated[basic.Vector4f, Field(basic.Vector4f, 0xA0)]
    SpiralPull: Annotated[basic.Vector3f, Field(basic.Vector3f, 0xB0)]
    StarSize: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xC0)]
    BaseSize: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xE8)]
    ConnectionAttractorMax: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xF0)]
    ConnectionAttractorMin: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xF8)]
    ConnectionDistortion: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x100)]
    SpiralFlex: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x108)]
    SpiralInclusion: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x110)]
    SpiralSizeScale: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x118)]
    StarHighlightAlpha: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x120)]
    StarHighlightSize: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x128)]
    BaseGenerationThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x130)]
    BaseTurbulenceGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x134)]
    BaseTurbulenceLac: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x138)]
    BaseTurbulenceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x13C)]
    ColourBaseBlendOnSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]
    ConnectionDistanceLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x144)]
    ConnectionDistortionTMult: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x148)]
    FieldGenerationThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14C)]
    FieldAlphaBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x150)]
    FieldAlphaField1Inf: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x154)]
    FieldAlphaField2SqInf: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x158)]
    RareSunChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x15C)]
    SizeField4Inf: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x160)]
    SizeNoisePower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x164)]
    SizeNoiseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x168)]
    SpiralFormChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x16C)]
    SpiralTwistMult: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x170)]
    StarGenerationThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x174)]
    StarHighlightChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x178)]


@partial_struct
class cGcGalaxyMarkerSettings(Structure):
    Colours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    OutlineColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    Icon: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    IconSize: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x50)]
    TimeScaleRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x58)]
    EdgeCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x60)]
    LineWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    LineWidthFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    OutlineWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    RadiusBaseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    RadiusEdge: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    RadiusFixed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    RadiusMinimum: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    RotationBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    SizeScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    MarkerLabel: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x88)
    ]


@partial_struct
class cGcGalaxyRenderAnostreakData(Structure):
    InnerColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    OuterColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    Contrast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    HorizontalScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    VerticalCompression: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcGalaxyRenderSetupData(Structure):
    MapLargeAreaPrimaryDefaultColours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    MapLargeAreaPrimaryHighContrastColours: Annotated[
        basic.Colour, Field(basic.Colour, 0xA0)
    ]
    MapLargeAreaSecondaryDefaultColours: Annotated[
        basic.Colour, Field(basic.Colour, 0x140)
    ]
    MapLargeAreaSecondaryHighContrastColours: Annotated[
        basic.Colour, Field(basic.Colour, 0x1E0)
    ]
    CompositionControlB_S_C_G: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x280)]
    LensFlareColour: Annotated[basic.Colour, Field(basic.Colour, 0x290)]
    LensFlareSpread: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2A0)]
    SunCoreColour: Annotated[basic.Colour, Field(basic.Colour, 0x2B0)]
    LensFlareExpandTowards: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x2C0)]
    NebulaeTraceStepRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x2C8)]
    BGCellHorizonInfluence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D0)]
    BGCellMoveScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D4)]
    BGCellTraceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D8)]
    BGColourCellBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2DC)]
    BGColourPow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E0)]
    BGColourStage1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E4)]
    BGColourStage2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E8)]
    BGColourStage3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2EC)]
    BGColourStage4: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F0)]
    CompositionSaturationIncreaseError: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2F4)
    ]
    CompositionSaturationIncreaseFilter: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2F8)
    ]
    CompositionSaturationIncreaseSelected: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2FC)
    ]
    LensFlareBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x300)]
    NebulaeAlphaPow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x304)]
    NebulaeTraceDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x308)]
    NebulaeTraceDensityCutoff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30C)]
    NebulaeTraceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x310)]
    NebulaeTraceValueMult: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x314)]
    StarFieldBlendAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x318)]
    SunCoreBGContrib: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x31C)]
    SunCoreFGContrib: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x320)]
    SunCoreLarger: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x324)]
    SunCoreSmaller: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x328)]
    VignetteBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x32C)]
    VignetteSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x330)]
    VignetteSizeIncreaseError: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x334)]
    VignetteSizeIncreaseFilter: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x338)]
    VignetteSizeIncreaseSelected: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x33C)
    ]


@partial_struct
class cGcGalaxySolarSystemOrbitParams(Structure):
    FirstOrbitRadiusMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FirstOrbitRadiusMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    OrbitLineWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    OrbitRadiusOffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    OrbitRadiusOffsetMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    OrbitRotationSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    OrbitRotationSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcWeightedResource(Structure):
    Geometry: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcWFCFace(Structure):
    ExcludedNeighboursR0: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    ExcludedNeighboursR1: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    ExcludedNeighboursR2: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    ExcludedNeighboursR3: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]

    class eTransformEnum(IntEnum):
        None_ = 0x0
        Rotated90 = 0x1
        Rotated180 = 0x2
        Rotated270 = 0x3
        FlippedHorizontally = 0x4

    Transform: Annotated[
        c_enum32[eTransformEnum], Field(c_enum32[eTransformEnum], 0x50)
    ]
    Connector: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x54)
    ]
    Incomplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]
    IsEntrance: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75)]
    Symmetric: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x76)]
    Walkable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x77)]


@partial_struct
class cGcWFCTerrainConstraint(Structure):
    class eDirectionEnum(IntEnum):
        Left = 0x0
        Back = 0x1
        Right = 0x2
        Forward = 0x3
        LeftBack = 0x4
        RightBack = 0x5
        RightForward = 0x6
        LeftForward = 0x7
        All = 0x8

    Direction: Annotated[c_enum32[eDirectionEnum], Field(c_enum32[eDirectionEnum], 0x0)]

    class eLevelsEnum(IntEnum):
        Lower = 0x0
        Upper = 0x1
        Both = 0x2

    Levels: Annotated[c_enum32[eLevelsEnum], Field(c_enum32[eLevelsEnum], 0x4)]

    class eTerrainEnum(IntEnum):
        RequireAbove = 0x0
        RequireBelow = 0x1

    Terrain: Annotated[c_enum32[eTerrainEnum], Field(c_enum32[eTerrainEnum], 0x8)]


@partial_struct
class cGcWFCModulePrototype(Structure):
    Back: Annotated[cGcWFCFace, Field(cGcWFCFace, 0x0)]
    Down: Annotated[cGcWFCFace, Field(cGcWFCFace, 0x78)]
    Forward: Annotated[cGcWFCFace, Field(cGcWFCFace, 0xF0)]
    Left: Annotated[cGcWFCFace, Field(cGcWFCFace, 0x168)]
    Right: Annotated[cGcWFCFace, Field(cGcWFCFace, 0x1E0)]
    Up: Annotated[cGcWFCFace, Field(cGcWFCFace, 0x258)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x2D0)]
    LayoutGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x2E0)]
    Scenes: Annotated[
        basic.cTkDynamicArray[cGcWeightedResource],
        Field(basic.cTkDynamicArray[cGcWeightedResource], 0x2F0),
    ]
    TerrainConstraints: Annotated[
        basic.cTkDynamicArray[cGcWFCTerrainConstraint],
        Field(basic.cTkDynamicArray[cGcWFCTerrainConstraint], 0x300),
    ]

    class eFreighterModuleTypeEnum(IntEnum):
        None_ = 0x0
        Room = 0x1
        Corridor = 0x2

    FreighterModuleType: Annotated[
        c_enum32[eFreighterModuleTypeEnum],
        Field(c_enum32[eFreighterModuleTypeEnum], 0x310),
    ]
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x314)]

    class eTerrainEditsEnum(IntEnum):
        None_ = 0x0
        ClearEntireBlock = 0x1
        UseScene = 0x2
        UseBasebuildingEdits = 0x3

    TerrainEdits: Annotated[
        c_enum32[eTerrainEditsEnum], Field(c_enum32[eTerrainEditsEnum], 0x318)
    ]
    Group: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x31C)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x39C)]
    DontRotateModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41C)]
    ExcludeOnGround: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41D)]
    ExcludeOnTop: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41E)]
    ExcludeRotatedVariants: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41F)]
    Include: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x420)]
    Indoors: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x421)]
    LimitToOnePerLevel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x422)]


@partial_struct
class cGcWeightedMaterialId(Structure):
    DecorationId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x20)]
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcWeightedBuildingSize(Structure):
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    SizeX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    SizeY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    SizeZ: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    CreateSymmetricBuilding: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcWeightedColourId(Structure):
    DecorationPaletteId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PaletteId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcFreighterBaseRoom(Structure):
    Palette: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcIDPair(Structure):
    Item1: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Item2: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcWeatherEffectLightningData(Structure):
    pass


@partial_struct
class cGcMinimumUseConstraint(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Modules: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    MinUses: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcWeatherHazardLightningData(Structure):
    IndicatorDecal: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    StaticDecal: Annotated[cTkModelResource, Field(cTkModelResource, 0x20)]
    DamageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    ImpactParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    ShakeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    DamageRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    DecalFullGrowthProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    EarliestImpact: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    EarliestImpactFirstInstance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    FlashStartProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    FullDamageRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    MaxRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    MaxStrikes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8C)]
    MinRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    MinStrikes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x94)]
    NumFlashes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    StormDuration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]


@partial_struct
class cGcModuleOverride(Structure):
    Module: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Scenes: Annotated[
        basic.cTkDynamicArray[cGcWeightedResource],
        Field(basic.cTkDynamicArray[cGcWeightedResource], 0x10),
    ]
    OriginalSceneProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ProbabilityMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcWeatherHazardMeteorData(Structure):
    ImpactEffect: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    ImpactExplode: Annotated[cTkModelResource, Field(cTkModelResource, 0x20)]
    IndicatorDecal: Annotated[cTkModelResource, Field(cTkModelResource, 0x40)]
    Meteor: Annotated[cTkModelResource, Field(cTkModelResource, 0x60)]
    StaticDecal: Annotated[cTkModelResource, Field(cTkModelResource, 0x80)]
    DamageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    ImpactParticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    ShakeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    DamageRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    DecalFullGrowthProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    EarliestImpact: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    EarliestImpactFirstInstance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    FlashStartProgress: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    FullDamageRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    MaxMeteors: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE8)]
    MaxRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    MinMeteors: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xF0)]
    MinRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    NumFlashes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    StormDuration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x100)]


@partial_struct
class cGcWeatherHazardTornadoData(Structure):
    SuckInRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    SuckInStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    SuckUpHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    SuckUpHeightCutoff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    SuckUpRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SuckUpStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcWFCDecorationFace(Structure):
    class eCanWalkEnum(IntEnum):
        None_ = 0x0
        RequireCanWalk = 0x1
        RequireCanNotWalk = 0x2

    CanWalk: Annotated[c_enum32[eCanWalkEnum], Field(c_enum32[eCanWalkEnum], 0x0)]
    RequiredFace: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x4)
    ]


@partial_struct
class cGcHazardValues(Structure):
    Extreme: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Normal: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcSelectableObjectData(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcSpaceSkyColours(Structure):
    CloudColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ColourBottom: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    ColourBottomPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    ColourMid: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    ColourMidPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    ColourTop: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    ColourTopPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x60)]
    FogColour: Annotated[basic.Colour, Field(basic.Colour, 0x70)]
    FogColour2: Annotated[basic.Colour, Field(basic.Colour, 0x80)]
    NebulaColour1: Annotated[basic.Colour, Field(basic.Colour, 0x90)]
    NebulaColour2: Annotated[basic.Colour, Field(basic.Colour, 0xA0)]
    NebulaColour3: Annotated[basic.Colour, Field(basic.Colour, 0xB0)]
    NebulaShadowColour: Annotated[basic.Colour, Field(basic.Colour, 0xC0)]
    SunColour: Annotated[basic.Colour, Field(basic.Colour, 0xD0)]


@partial_struct
class cGcSpaceSkyProperties(Structure):
    PlanetHorizonColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    PlanetSkyColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    ColourIndex: Annotated[
        cGcPlanetWeatherColourIndex, Field(cGcPlanetWeatherColourIndex, 0x20)
    ]
    AtmosphereThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    CenterPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    CloudNoiseFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HorizonFadeSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    HorizonMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    NebulaBrightness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    NebulaCloudStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    NebulaCloudStrength1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    NebulaDistortionStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    NebulaFBMStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    NebulaFBMStrength1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    NebulaFogAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    NebulaFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    NebulaNoiseFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    NebulaSeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    NebulaSparseness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    NebulaTendrilStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    NebulaTurbulenceStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    NebulaWispyness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    NebulaWispyness1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    PlanetFogStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    SpaceFogColour2Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    SpaceFogColourStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    SpaceFogMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    SpaceFogPlanetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    SpaceFogStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    StarVisibility: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    SunSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    SunStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]


@partial_struct
class cGcTerrainTextureSettings(Structure):
    Brightness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Contrast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Specular: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcTileTypeOptions(Structure):
    Options: Annotated[
        basic.cTkDynamicArray[cTkPaletteTexture],
        Field(basic.cTkDynamicArray[cTkPaletteTexture], 0x0),
    ]


@partial_struct
class cGcTileTypeSet(Structure):
    Colours: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x0)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]


@partial_struct
class cGcSkyProperties(Structure):
    AtmosphereThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DayHorizonTightness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    DuskHorizonMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HorizonFadeSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    HorizonMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    NightHorizonMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SunSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SunStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    SunSurroundSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    SunSurroundStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    UpperSkyFadeOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    UpperSkyFadeSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]


@partial_struct
class cGcResourceCollectEffect(Structure):
    OffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    OffsetMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    PlayerOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    RotateMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    RotateMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SizeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SizeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    StartOffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    StartOffsetMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    StartSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    StartSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    TimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    TimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcPlanetaryBuildingRestrictions(Structure):
    RequiresCorruptSentinels: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    RequiresRelicWorld: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]
    RequiresWater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2)]


@partial_struct
class cGcExternalObjectListOptions(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Options: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x10),
    ]
    ResourceHint: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ResourceHintIcon: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Order: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    SeasonalProbabilityOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    TileType: Annotated[
        c_enum32[enums.cGcTerrainTileType],
        Field(c_enum32[enums.cGcTerrainTileType], 0x4C),
    ]
    AddToFilenameHashmapWhenOptional: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x50)
    ]
    AllowLimiting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    ChooseUsingLifeLevel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]
    SuppressSpawn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x53)]


@partial_struct
class cGcPlanetCloudProperties(Structure):
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x0)]
    CoverageRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    CoverExtremes: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x18)]

    class eCloudinessEnum(IntEnum):
        CloudyWithClearSpells = 0x0
        ClearWithCloudySpells = 0x1

    Cloudiness: Annotated[
        c_enum32[eCloudinessEnum], Field(c_enum32[eCloudinessEnum], 0x20)
    ]
    Coverage1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Coverage2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Coverage3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    Offset1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Offset2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    Offset3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    RateOfChange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    Ratio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SecondaryRateOfChange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]


@partial_struct
class cGcFogProperties(Structure):
    HeavyAir: Annotated[cGcHeavyAirSetting, Field(cGcHeavyAirSetting, 0x0)]
    CloudRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x190)]
    DepthOfField: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x194)]
    DepthOfFieldDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x198)]
    DepthOfFieldFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x19C)]
    FogColourMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A0)]
    FogColourStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A4)]
    FogHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A8)]
    FogMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1AC)]
    FogStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B0)]
    FullscreenEffect: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B4)]
    HeightFogFadeOutStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B8)]
    HeightFogMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1BC)]
    HeightFogOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C0)]
    HeightFogStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C4)]
    RainWetness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C8)]
    IsRaining: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1CC)]


@partial_struct
class cGcLightProperties(Structure):
    BounceColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    LightColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    SunColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]


@partial_struct
class cGcLightShaftProperties(Structure):
    LightShaftColourBottom: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    LightShaftColourTop: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    LightShaftBottom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    LightShaftScattering: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    LightShaftStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    LightShaftTop: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]


@partial_struct
class cGcObjectDefinitionData(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]

    class eLifeTypeEnum(IntEnum):
        Rock = 0x0
        DryPlant = 0x1
        LushPlant = 0x2
        Artificial = 0x3

    LifeType: Annotated[c_enum32[eLifeTypeEnum], Field(c_enum32[eLifeTypeEnum], 0x10)]

    class eLocationTypeEnum(IntEnum):
        AboveGround = 0x0
        UnderGround = 0x1
        WaterSurface = 0x2
        UnderWater = 0x3

    LocationType: Annotated[
        c_enum32[eLocationTypeEnum], Field(c_enum32[eLocationTypeEnum], 0x14)
    ]

    class eObjectAlignmentEnum(IntEnum):
        Upright = 0x0
        SlightOffsetFromUpright = 0x1
        LargeOffsetFromUpright = 0x2
        ToNormal = 0x3
        SlightOffsetFromNormal = 0x4
        LargeOffsetFromNormal = 0x5

    ObjectAlignment: Annotated[
        c_enum32[eObjectAlignmentEnum], Field(c_enum32[eObjectAlignmentEnum], 0x18)
    ]

    class eObjectCoverageTypeEnum(IntEnum):
        Blanket = 0x0
        Cluster = 0x1
        Solo = 0x2

    ObjectCoverageType: Annotated[
        c_enum32[eObjectCoverageTypeEnum],
        Field(c_enum32[eObjectCoverageTypeEnum], 0x1C),
    ]

    class eObjectRenderTypeEnum(IntEnum):
        Instanced = 0x0
        Single = 0x1

    ObjectRenderType: Annotated[
        c_enum32[eObjectRenderTypeEnum], Field(c_enum32[eObjectRenderTypeEnum], 0x20)
    ]

    class eSizeClassEnum(IntEnum):
        Tiny = 0x0
        Small = 0x1
        Medium = 0x2
        Large = 0x3
        Massive = 0x4

    SizeClass: Annotated[
        c_enum32[eSizeClassEnum], Field(c_enum32[eSizeClassEnum], 0x24)
    ]
    AutoCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    MatchGroundColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]


@partial_struct
class cGcObjectSpawnDataVariant(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LodDistances: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Coverage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FadeOutEndDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FadeOutOffsetDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    FadeOutStartDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FlatDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    MaxImposterRadius: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    MaxRegionRadius: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    SlopeDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SlopeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]


@partial_struct
class cGcBuildingDefinitionData(Structure):
    AABBOverrideMax: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    AABBOverrideMin: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    TextureNameHint: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x20)]
    ClusterLayout: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Density: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    FlattenType: Annotated[cTkNoiseFlattenOptions, Field(cTkNoiseFlattenOptions, 0x70)]
    ClusterSpacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    MaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    NumModelsToGenerate: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x84)]
    NumOverridesToGenerate: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x88)]
    NumOverridesToGenerateWaterworlds: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x8C)
    ]
    OverrideRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    PlanetRestrictions: Annotated[
        cGcPlanetaryBuildingRestrictions, Field(cGcPlanetaryBuildingRestrictions, 0x94)
    ]
    EnabledWhenPlanetHasNoNPCs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x97)]
    GivesShelter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x98)]
    IgnoreParticlesInAABB: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x99)]


@partial_struct
class cGcEnvironmentProperties(Structure):
    SkyHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AsteroidFadeHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AsteroidFadeHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    AtmosphereEndHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    AtmosphereStartHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    CloudHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    CloudHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FlightFogBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    FlightFogHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HeavyAirHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    HeavyAirHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    HorizonBlendHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    HorizonBlendLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    PlanetLodSwitch0: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    PlanetLodSwitch0Elevation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    PlanetLodSwitch1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    PlanetLodSwitch2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    PlanetLodSwitch3: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    PlanetObjectSwitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    SkyAtmosphereHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    SkyColourBlendLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    SkyColourHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    SkyPositionBlendLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    SkyPositionHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    SolarSystemLUTBlendLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    SolarSystemLUTHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    StratosphereHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]


@partial_struct
class cGcBuildingFilename(Structure):
    LSystem: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Scene: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    WFC: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]


@partial_struct
class cGcBuildingFilenameList(Structure):
    BuildingFiles: Annotated[cGcBuildingFilename, Field(cGcBuildingFilename, 0x0)]


@partial_struct
class cGcBuildingDensity(Structure):
    BuildingSpacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcBuildingDistribution(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxDistance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinDistance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcBuildingOverrideData(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcBuildingClusterLayoutEntry(Structure):
    Building: Annotated[
        c_enum32[enums.cGcBuildingClassification],
        Field(c_enum32[enums.cGcBuildingClassification], 0x0),
    ]
    Max: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Min: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FacesCentre: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcBuildingClusterLayout(Structure):
    ClusterBuildings: Annotated[
        basic.cTkDynamicArray[cGcBuildingClusterLayoutEntry],
        Field(basic.cTkDynamicArray[cGcBuildingClusterLayoutEntry], 0x0),
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AlignmentJitter: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AlignmentSteps: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    RelativeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcBuildingSpawnSlot(Structure):
    BuildingDataIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HasBuilding: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcCloudProperties(Structure):
    CloudBaseColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    CloudHeightGradient1: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x10)]
    CloudHeightGradient2: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x20)]
    CloudHeightGradient3: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x30)]
    CloudTopColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    StratosphereWindOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x50)]
    WindOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x58)]
    AbsorptionFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AmbientDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    AmbientScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    AnimationScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    BackwardScatteringG: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    BaseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    CloudBottomFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    CloudDistortion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    CloudDistortionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    ConeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    DarkOutlineScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    Density: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    DetailScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    DitheringScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    ErosionEdgeSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    ForwardScatteringG: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    HorizonCoverageEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    HorizonCoverageStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    HorizonDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    HorizonFadeScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    HorizonFadeStartAlpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    LightScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    LODDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    MaxIterations: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    RayMinimumY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    SampleScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    SampleThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    SunRayLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    UseBlueNoiseDithering: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD0)]


@partial_struct
class cGcPetAccessoryGroup(Structure):
    DisallowedAccessories: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcPetAccessoryType]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcPetAccessoryType]], 0x0),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcPetAccessoryInfo(Structure):
    Descriptor: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcPetEggSpeciesOverrideData(Structure):
    CreatureID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxScaleOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MinScaleOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    CanChangeAccessories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    CanChangeColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]
    CanChangeGrowth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A)]
    CanChangeTraits: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B)]


@partial_struct
class cGcSandwormTimerAndFrequencyOverride(Structure):
    PackedUA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    SpawnChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    Timer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cGcEcosystemCreatureData(Structure):
    Creature: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Rarity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TileType: Annotated[
        c_enum32[enums.cGcTerrainTileType],
        Field(c_enum32[enums.cGcTerrainTileType], 0x1C),
    ]


@partial_struct
class cGcSpookFiendSpawnData(Structure):
    SpawnID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxNumSpawns: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    SpawnChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    ThresholdSpookLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TimerAccelerator: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcEcosystemSpawnData(Structure):
    Creatures: Annotated[
        basic.cTkDynamicArray[cGcEcosystemCreatureData],
        Field(basic.cTkDynamicArray[cGcEcosystemCreatureData], 0x0),
    ]
    CreatureMaxNoise: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    CreatureMinNoise: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcIkPistonData(Structure):
    Joint1Name: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)
    ]
    Joint2Name: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x100)
    ]


@partial_struct
class cGcCreatureGenerationWeightedListDomainEntry(Structure):
    Archetype: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcCreatureGenerationWeightedList(Structure):
    Air: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry], 0x0),
    ]
    Cave: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry],
        Field(
            basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry], 0x10
        ),
    ]
    Ground: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry],
        Field(
            basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry], 0x20
        ),
    ]
    Water: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry],
        Field(
            basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry], 0x30
        ),
    ]


@partial_struct
class cGcCreatureGenerationOptionalWeightedList(Structure):
    Archetypes: Annotated[
        cGcCreatureGenerationWeightedList, Field(cGcCreatureGenerationWeightedList, 0x0)
    ]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    OverrideAllDomains: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]


@partial_struct
class cGcCreatureRoleFilename(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    BiomeProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcCreatureRoleFilenameList(Structure):
    Options: Annotated[
        basic.cTkDynamicArray[cGcCreatureRoleFilename],
        Field(basic.cTkDynamicArray[cGcCreatureRoleFilename], 0x0),
    ]


@partial_struct
class cGcCreatureGroupDescription(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    GroupsPerSquareKm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxGroupSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MinGroupSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcCreatureGroupProbability(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcCreatureRoleFilenameTable(Structure):
    WeirdBiomeFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x0)
    ]
    BiomeFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x200)
    ]
    AirFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x310)
    ]
    CaveFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x320)
    ]
    RobotFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x330)
    ]
    UnderwaterFiles: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x340)
    ]
    UnderwaterFilesExtra: Annotated[
        cGcCreatureRoleFilenameList, Field(cGcCreatureRoleFilenameList, 0x350)
    ]
    LifeChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x360)]
    RoleFrequencyModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x370)]


@partial_struct
class cGcCreatureDebugWaypoint(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]

    class eWaypointTypeEnum(IntEnum):
        Move = 0x0
        MoveAlt = 0x1
        Idle = 0x2

    WaypointType: Annotated[
        c_enum32[eWaypointTypeEnum], Field(c_enum32[eWaypointTypeEnum], 0x24)
    ]


@partial_struct
class cGcCreatureFilename(Structure):
    ExtraFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcCreatureGenerationDomainEntry(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    DensityModifier: Annotated[
        c_enum32[enums.cGcCreatureGenerationDensity],
        Field(c_enum32[enums.cGcCreatureGenerationDensity], 0x10),
    ]


@partial_struct
class cGcCreatureGenerationDomainAdditionalEntries(Structure):
    Tables: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainEntry],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainEntry], 0x0),
    ]
    ChanceOfHemisphereLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxTablesToAdd: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MaxToHemisphereLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcBehaviourPlayAnimTrigger(Structure):
    Trigger: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Frame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCreatureGenerationDomainTable(Structure):
    AdditionalTables: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainAdditionalEntries],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainAdditionalEntries], 0x0),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Tables: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainEntry],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainEntry], 0x20),
    ]
    ChanceOfHemisphereLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MaxToHemisphereLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]


@partial_struct
class cGcPetActionMoodModifier(Structure):
    MoodModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcWeirdCreatureRewardList(Structure):
    Rewards: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcPetTraitMoodModifier(Structure):
    MoodIncreaseMultiplierMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MoodIncreaseMultiplierMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    TraitMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    TraitMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cGcPetTraitMoodModifierList(Structure):
    Modifiers: Annotated[cGcPetTraitMoodModifier, Field(cGcPetTraitMoodModifier, 0x0)]


@partial_struct
class cGcCreatureSubstanceList(Structure):
    CreatureType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcCreatureVocalTestData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Size: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Squawk: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Genus: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x18)]


@partial_struct
class cGcCreatureBehaviourTreeData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Nodes: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x10),
    ]


@partial_struct
class cGcCreatureBehaviourTrees(Structure):
    BehaviourTree: Annotated[
        basic.cTkDynamicArray[cGcCreatureBehaviourTreeData],
        Field(basic.cTkDynamicArray[cGcCreatureBehaviourTreeData], 0x0),
    ]


@partial_struct
class cGcCreatureStupidName(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Names: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0x10),
    ]
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcCreatureEffectTrigger(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    JointName: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x100],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x100], 0x20),
    ]
    Frame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    GroundTint: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]


@partial_struct
class cGcCreatureEffectTriggerRequirementCreatureSize(Structure):
    MaxCreatureSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MinCreatureSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcCreatureVocalSoundData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MinCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    PlayFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]

    class eVocalEmoteEnum(IntEnum):
        EmoteIdle = 0x0
        EmoteFlee = 0x1
        EmoteAggression = 0x2
        EmoteRoar = 0x3
        EmotePain = 0x4
        EmoteAttack = 0x5
        EmoteDie = 0x6
        EmoteMiniRoarNeutral = 0x7
        EmoteMiniRoarHappy = 0x8
        EmoteMiniRoarAngry = 0x9

    VocalEmote: Annotated[
        c_enum32[eVocalEmoteEnum], Field(c_enum32[eVocalEmoteEnum], 0x1C)
    ]
    PlayImmediately: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    PlayOnlyOnce: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]


@partial_struct
class cGcCreatureVocalData(Structure):
    AttackVocal: Annotated[
        cGcCreatureVocalSoundData, Field(cGcCreatureVocalSoundData, 0x0)
    ]
    DeathVocal: Annotated[
        cGcCreatureVocalSoundData, Field(cGcCreatureVocalSoundData, 0x28)
    ]
    FleeVocal: Annotated[
        cGcCreatureVocalSoundData, Field(cGcCreatureVocalSoundData, 0x50)
    ]
    IdleVocal: Annotated[
        cGcCreatureVocalSoundData, Field(cGcCreatureVocalSoundData, 0x78)
    ]
    ScaleBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]


@partial_struct
class cGcCreatureFoodList(Structure):
    DebrisEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FoodProduct: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ResourceFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]


@partial_struct
class cGcCreatureWeirdMovementData(Structure):
    FeetNames: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x100],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x100], 0x0),
    ]
    BobAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BobSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    JumpAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]

    class eMoveModeEnum(IntEnum):
        Roll = 0x0
        Float = 0x1
        Drill = 0x2

    MoveMode: Annotated[c_enum32[eMoveModeEnum], Field(c_enum32[eMoveModeEnum], 0x1C)]
    SpinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Node: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x24)]


@partial_struct
class cGcFlyingSnakeData(Structure):
    AirThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AltitudeSinAmp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AltitudeSinPeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ApproachBaitSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    AscendDescendSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BarrelRollCount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    BarrelRollSpawnDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    BarrelRollSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    CircleSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    DefaultCircleDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    RiseDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    RiseHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    RiseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    TailStiffness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    TwistLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    WindForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]


@partial_struct
class cGcCreatureHarvestSubstanceList(Structure):
    CreatureType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Item: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    MinBlobs: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    Desc: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x24)]


@partial_struct
class cGcCreaturePetPartHider(Structure):
    PartName: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x0),
    ]
    AccessorySlot: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)
    ]


@partial_struct
class cGcCreatureSwarmDataParams(Structure):
    AnimThrustCycleAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ValidDescriptors: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x10),
    ]
    Alignment: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AlignTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    AnimThrustCycleEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    AnimThrustCycleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    AnimThrustCycleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    AnimThrustCyclePeak: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    AnimThrustCycleStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    BankingTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    Coherence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    FaceMoveDirStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    FlyTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    FlyTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    Follow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    LandAdjustDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    LandClampBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    LandIdleTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    LandIdleTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    LandSlowDown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    LandTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    LandTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    LandWalkTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    LandWalkTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    MaxBankingAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    MaxPitchAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    MinPitchAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    SeparateStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    SpeedForMaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    SpeedForMinPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    SteeringSpringSmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    SwimAnimSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    SwimAnimSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    SwimFastSpeedMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    SwimMaxAcceleration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    SwimTurn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    TakeOffStartSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    TakeOffTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    TakeOffUpwardBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    TurnRequiredForMaxBanking: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    UpwardMovementForMaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    WalkSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    WalkTurnTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    ApplyScaleToSpeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xCC)]
    ApplyScaleToSteeringSmoothTime: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xCD)]
    CanLand: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xCE)]
    CanWalk: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xCF)]
    FaceMoveDirYawOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD0)]
    UseAnimThrustCycle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD1)]


@partial_struct
class cGcCreatureSwarmData(Structure):
    Params: Annotated[
        basic.cTkDynamicArray[cGcCreatureSwarmDataParams],
        Field(basic.cTkDynamicArray[cGcCreatureSwarmDataParams], 0x0),
    ]
    MaxCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    SwarmMovementRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SwarmMovementSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]

    class eSwarmMovementTypeEnum(IntEnum):
        None_ = 0x0
        Circle = 0x1
        Random = 0x2
        Search = 0x3
        FollowPlayer = 0x4
        FollowPlayerLimited = 0x5

    SwarmMovementType: Annotated[
        c_enum32[eSwarmMovementTypeEnum], Field(c_enum32[eSwarmMovementTypeEnum], 0x20)
    ]
    AttractedToBait: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcCreaturePetTraitRange(Structure):
    Max: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Min: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcCreaturePetTraitRanges(Structure):
    TraitRanges: Annotated[
        cGcCreaturePetTraitRange, Field(cGcCreaturePetTraitRange, 0x0)
    ]


@partial_struct
class cGcCreatureRidingAnimation(Structure):
    MovementAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RidingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcCreatureRidingPartModifier(Structure):
    AnimOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    RotationOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    VROffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    PartName: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x40)]
    DefaultRidingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    IdleRidingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    RidingAnims: Annotated[
        basic.cTkDynamicArray[cGcCreatureRidingAnimation],
        Field(basic.cTkDynamicArray[cGcCreatureRidingAnimation], 0x80),
    ]
    HeadCounterRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    LegSpreadOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    MaxScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    MinScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    AdditionalScaleJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xA0)
    ]
    JointName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1A0)
    ]
    BreakIfNotSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A0)]
    OverrideAnims: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A1)]
    RelativeOffset: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A2)]


@partial_struct
class cGcCreatureRidingData(Structure):
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    RotationOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    VROffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    DefaultRidingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    IdleRidingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    PartModifiers: Annotated[
        basic.cTkDynamicArray[cGcCreatureRidingPartModifier],
        Field(basic.cTkDynamicArray[cGcCreatureRidingPartModifier], 0x50),
    ]
    RidingAnims: Annotated[
        basic.cTkDynamicArray[cGcCreatureRidingAnimation],
        Field(basic.cTkDynamicArray[cGcCreatureRidingAnimation], 0x60),
    ]
    HeadCounterRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    ScaleForMaxLegSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    ScaleForMinLegSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    ScaleForNeutralLegSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    UprightStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    AdditionalScaleJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x84)
    ]
    JointName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x184)
    ]
    LegSpread: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x284)]
    RequiresMatchingPartModifier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x285)]


@partial_struct
class cGcCreaturePetAccessorySlot(Structure):
    AccessoryGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AttachLocator: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)
    ]


@partial_struct
class cGcCreaturePetAccessory(Structure):
    RequiredDescriptor: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    HideParts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x20),
    ]
    Slots: Annotated[
        basic.cTkDynamicArray[cGcCreaturePetAccessorySlot],
        Field(basic.cTkDynamicArray[cGcCreaturePetAccessorySlot], 0x30),
    ]


@partial_struct
class cGcCreaturePetData(Structure):
    AccessorySlots: Annotated[
        basic.cTkDynamicArray[cGcCreaturePetAccessory],
        Field(basic.cTkDynamicArray[cGcCreaturePetAccessory], 0x0),
    ]


@partial_struct
class cGcCreatureHealthData(Structure):
    DeathAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DeathAudio: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DeathEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DespawnOnDeathDescriptors: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x30),
    ]
    HurtAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    HurtAudio: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    DespawnOnDeath: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]


@partial_struct
class cGcCreatureHoverTintableEffect(Structure):
    TintColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    LightStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    TintStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    EffectNode: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x18)
    ]


@partial_struct
class cGcCreatureHoverMovementDataParams(Structure):
    TintableEffects: Annotated[
        basic.cTkDynamicArray[cGcCreatureHoverTintableEffect],
        Field(basic.cTkDynamicArray[cGcCreatureHoverTintableEffect], 0x0),
    ]
    ValidDescriptors: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x10),
    ]
    ElevationAvoidStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    GroundAlignTimeModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    GroundEffectHeightForMaxAlpha: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x28)
    ]
    GroundEffectHeightForMinAlpha: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2C)
    ]
    GroundHeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HeightForMaxElevationAvoid: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    HeightForMaxGroundAlign: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    HeightForMaxGroundAvoid: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    HeightForMinElevationAvoid: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    HeightForMinGroundAlign: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    HeightForMinGroundAvoid: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    NavOffsetY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    NavOffsetZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    RayCastDown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    RayCastUp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    GroundEffect: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x5C)
    ]
    CanJump: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15C)]
    ElevationAvoid: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15D)]
    GroundAlign: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15E)]
    GroundAvoid: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15F)]


@partial_struct
class cGcCreatureHoverMovementData(Structure):
    Params: Annotated[
        basic.cTkDynamicArray[cGcCreatureHoverMovementDataParams],
        Field(basic.cTkDynamicArray[cGcCreatureHoverMovementDataParams], 0x0),
    ]


@partial_struct
class cGcCreatureJellyBossAttackData(Structure):
    BroodSpawnID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OrbAttackProjectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    OrbAttackCooldownRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    SpawnBroodCooldownRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x28)]
    DelayBetweenOrbAttacks: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    MaxBroodCountPreventSpawn: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    MaxIdleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MinIdleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MinWaterDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    OrbAttackCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    OrbAttackExplosionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    OrbAttackLaunchSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    OrbAttackPauseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    OrbAttackPickWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    OrbAttackProjectileCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5C)]
    SpawnBroodCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x60)]
    SpawnBroodPauseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    SpawnBroodPickWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    CanOrbAttack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6C)]
    CanSpawnBrood: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6D)]
    ExplodeOnPlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6E)]
    IsSpooky: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6F)]


@partial_struct
class cGcCreatureMoveAnimData(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AnimLeft: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AnimRight: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    AnimMoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    AnimSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    MaxPetSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    MaxPredatorSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MaxSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MinPetSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    AnimMoveSpeedCached: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]


@partial_struct
class cGcCreatureMovementData(Structure):
    Anims: Annotated[
        basic.cTkDynamicArray[cGcCreatureMoveAnimData],
        Field(basic.cTkDynamicArray[cGcCreatureMoveAnimData], 0x0),
    ]
    HeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    HeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    HeightRangeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    HeightRangeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    HeightTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MoveRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MoveSpeedScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    TurnRadiusScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    Herd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    IgnoreRotationInPounce: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    LimitHeightRange: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcCreatureParticleEffectDataEntry(Structure):
    EffectLocator: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    EffectName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Requirements: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x20),
    ]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Attached: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]
    DetachOnRetire: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35)]


@partial_struct
class cGcCreatureParticleEffectData(Structure):
    Effects: Annotated[
        basic.cTkDynamicArray[cGcCreatureParticleEffectDataEntry],
        Field(basic.cTkDynamicArray[cGcCreatureParticleEffectDataEntry], 0x0),
    ]
    RetireTriggers: Annotated[
        c_enum32[enums.cGcCreatureParticleEffectTrigger],
        Field(c_enum32[enums.cGcCreatureParticleEffectTrigger], 0x10),
    ]
    SpawnTriggers: Annotated[
        c_enum32[enums.cGcCreatureParticleEffectTrigger],
        Field(c_enum32[enums.cGcCreatureParticleEffectTrigger], 0x14),
    ]


@partial_struct
class cGcCreatureFiendAttackData(Structure):
    PushBackAttackAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PushBackDamageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    SpawnBroodAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    SpawnBroodID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    SpitAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    SpitProjectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    TurnLAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    TurnRAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    TurnAnimSpeeds: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x80)]
    AnimSpeedModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    AttackLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    DelayBetweenPounceAttacks: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    DelayBetweenSpitAttacks: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    FarDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    IdleLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    MaxFlurryHits: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    MinFlurryHits: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA4)]
    ModifyDistanceForHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    NearDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    PushBackAttackFrame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB0)]
    PushBackRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    RoarChanceOnHit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    RoarChanceOnMiss: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    SpawnBroodTimer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    SpitAnimFrame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC4)]
    SpitFacingRequirement: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    StartDamageTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    TurnAnimAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    TurnAnimAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    TurnToFaceTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    AttackLight: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xDC)
    ]
    SpitJoint: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x11C)
    ]
    AllowPounce: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15C)]
    AllowPushBackAttack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15D)]
    AllowSpawnBrood: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15E)]
    AllowSpit: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15F)]
    AllowSpitAlways: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x160)]
    AOESpitAttack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x161)]


@partial_struct
class cGcCreatureFlockMovementData(Structure):
    BankTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FlockAlign: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    FlockAvoidPredators: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    FlockAvoidPredatorsMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FlockAvoidPredatorsMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FlockAvoidPredatorsSpeedBoost: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x14)
    ]
    FlockAvoidTerrain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    FlockAvoidTerrainMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    FlockAvoidTerrainMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FlockCohere: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FlockFollow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    FlockHysteresis: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    FlockMoveDirectionTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FlockMoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    FlockSeperate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    FlockSeperateMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    FlockSeperateMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    FlockTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MaxBank: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MaxFlapSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MaxFlockMembers: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    MinFlapSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    MinFlockMembers: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x58)]
    MoveInFacingStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]


@partial_struct
class cGcCreatureParticleEffects(Structure):
    ParticleEffects: Annotated[
        basic.cTkDynamicArray[cGcCreatureParticleEffectData],
        Field(basic.cTkDynamicArray[cGcCreatureParticleEffectData], 0x0),
    ]


@partial_struct
class cGcCreatureFootParticleSingleData(Structure):
    EffectName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxCreatureSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MinCreatureSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]

    class eMoveSpeedEnum(IntEnum):
        Always = 0x0
        Walk = 0x1
        Run = 0x2

    MoveSpeed: Annotated[
        c_enum32[eMoveSpeedEnum], Field(c_enum32[eMoveSpeedEnum], 0x18)
    ]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcCreatureFootParticleData(Structure):
    ParticleData: Annotated[
        basic.cTkDynamicArray[cGcCreatureFootParticleSingleData],
        Field(basic.cTkDynamicArray[cGcCreatureFootParticleSingleData], 0x0),
    ]


@partial_struct
class cGcBehaviourRegisterAttackerData(Structure):
    TargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcBehaviourWaitData(Structure):
    Seconds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcBlackboardFloatCompareDecoratorData(Structure):
    CompareTo: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x0)
    ]
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    OnFalse: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x28)]
    OnTrue: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x38)]
    CompareBlackboardValueType: Annotated[
        c_enum32[enums.cTkBlackboardComparisonTypeEnum],
        Field(c_enum32[enums.cTkBlackboardComparisonTypeEnum], 0x48),
    ]


@partial_struct
class cGcBlackboardIntCompareDecoratorData(Structure):
    CompareTo: Annotated[
        cTkBlackboardDefaultValueInteger, Field(cTkBlackboardDefaultValueInteger, 0x0)
    ]
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    OnFalse: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x28)]
    OnTrue: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x38)]
    Comparison: Annotated[
        c_enum32[enums.cTkBlackboardComparisonTypeEnum],
        Field(c_enum32[enums.cTkBlackboardComparisonTypeEnum], 0x48),
    ]


@partial_struct
class cGcBlackboardIntModifyData(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eModifyIntTypeEnum(IntEnum):
        SetValue = 0x0
        IncrementValue = 0x1

    ModifyIntType: Annotated[
        c_enum32[eModifyIntTypeEnum], Field(c_enum32[eModifyIntTypeEnum], 0x10)
    ]
    Value: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcBlackboardValueDecoratorData(Structure):
    Child: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ClearOnSuccess: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcCreatureDestroyInstancesData(Structure):
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    MinInstanceRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    DebugDraw: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcCooldownDecoratorData(Structure):
    CooldownTime: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x0)
    ]
    Child: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x18)]
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x28)]


@partial_struct
class cGcBirdData(Structure):
    FlapAccel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FlapSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    FlapSpeedForMaxScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    FlapSpeedForMinScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    FlapSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FlapSpeedMaxScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    FlapSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    FlapSpeedMinScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    FlapTurn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    CircleAttractor: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x24)
    ]


@partial_struct
class cGcCreatureAlertData(Structure):
    AlertInitiator: Annotated[
        c_enum32[enums.cGcCreatureTypes], Field(c_enum32[enums.cGcCreatureTypes], 0x0)
    ]
    AlertTarget: Annotated[
        c_enum32[enums.cGcCreatureTypes], Field(c_enum32[enums.cGcCreatureTypes], 0x4)
    ]
    FleeRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HearingRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    SightAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SightRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcBehaviourLookData(Structure):
    CanLook: Annotated[
        cTkBlackboardDefaultValueBool, Field(cTkBlackboardDefaultValueBool, 0x0)
    ]
    FocusOnTarget: Annotated[
        cTkBlackboardDefaultValueBool, Field(cTkBlackboardDefaultValueBool, 0x18)
    ]
    RelaxedLook: Annotated[
        cTkBlackboardDefaultValueBool, Field(cTkBlackboardDefaultValueBool, 0x30)
    ]
    LookTargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]
    LookWhenBeyondMaxAngle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]


@partial_struct
class cGcBehaviourMaintainRangeFromTargetData(Structure):
    MaxDist: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x0)
    ]
    MinDist: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x18)
    ]
    TargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    AvoidCreaturesStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SpeedModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    _2D: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    SucceedWhenInRange: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]


@partial_struct
class cGcBehaviourMoveToTargetData(Structure):
    ArriveDist: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x0)
    ]
    TargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    AvoidCreaturesStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]

    class eBehaviourMoveSpeedEnum(IntEnum):
        Normal = 0x0
        Fast = 0x1
        Dynamic = 0x2

    BehaviourMoveSpeed: Annotated[
        c_enum32[eBehaviourMoveSpeedEnum],
        Field(c_enum32[eBehaviourMoveSpeedEnum], 0x2C),
    ]
    DynamicMoveSlowdownDistMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    SpeedModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]


@partial_struct
class cGcBehaviourPlayAnimData(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Triggers: Annotated[
        basic.cTkDynamicArray[cGcBehaviourPlayAnimTrigger],
        Field(basic.cTkDynamicArray[cGcBehaviourPlayAnimTrigger], 0x10),
    ]
    BlendInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    BlendOutAt: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcBehaviourAppearData(Structure):
    AppearAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcBehaviourApplyDamageData(Structure):
    Offset: Annotated[
        cTkBlackboardDefaultValueVector, Field(cTkBlackboardDefaultValueVector, 0x0)
    ]
    PlayerDamageType: Annotated[
        cTkBlackboardDefaultValueId, Field(cTkBlackboardDefaultValueId, 0x30)
    ]
    Radius: Annotated[
        cTkBlackboardDefaultValueFloat, Field(cTkBlackboardDefaultValueFloat, 0x58)
    ]


@partial_struct
class cGcBehaviourCheckDeathData(Structure):
    pass


@partial_struct
class cGcBehaviourCooldownBeginData(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcBehaviourDetailAnimsData(Structure):
    CanDetail: Annotated[
        cTkBlackboardDefaultValueBool, Field(cTkBlackboardDefaultValueBool, 0x0)
    ]


@partial_struct
class cGcBehaviourFaceTargetData(Structure):
    TargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ArriveAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcCustomisationShipTrails(Structure):
    Trails: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    LinkedTechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcBehaviourGetTargetData(Structure):
    TargetKey: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcBehaviourIdleData(Structure):
    pass


@partial_struct
class cGcCustomisationThrusterJet(Structure):
    JetMesh: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Trail: Annotated[cTkModelResource, Field(cTkModelResource, 0x20)]
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    LocatorPrefix: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]


@partial_struct
class cGcCustomisationThrusterEffect(Structure):
    LightColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Tip: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)]
    Jets: Annotated[
        basic.cTkDynamicArray[cGcCustomisationThrusterJet],
        Field(basic.cTkDynamicArray[cGcCustomisationThrusterJet], 0x30),
    ]
    LinkedSpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    AllowedInSeasonalDefaults: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    HiddenInCustomiser: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]


@partial_struct
class cGcBehaviourIncrementCounter(Structure):
    Key: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcBehaviourLaunchProjectileData(Structure):
    Projectile: Annotated[
        cTkBlackboardDefaultValueId, Field(cTkBlackboardDefaultValueId, 0x0)
    ]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    HorizontalDispersion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    VerticalDispersion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    LaunchJoint: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x34)
    ]


@partial_struct
class cGcCustomisationTextureGroup(Structure):
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    GroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    TextureOptionGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcCustomisationFreighterEngineEffect(Structure):
    GlowColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    EffectResource: Annotated[cTkModelResource, Field(cTkModelResource, 0x10)]
    Tip: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x30)]
    LinkedSpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    LinkedTechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]


@partial_struct
class cGcScareCreaturesAction(Structure):
    FleeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    HearRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcSpawnAction(Structure):
    Event: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcCustomisationCameraData(Structure):
    InteractionCameraIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MinYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    InteracttionCameraFocusJoint: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x14)
    ]


@partial_struct
class cGcCustomisationColourGroup(Structure):
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    GroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x30)]
    HiddenForFirstOption: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]


@partial_struct
class cGcAnimFrameEvent(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FrameStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    StartFromEnd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcBeenShotEvent(Structure):
    DamageThreshold: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    HealthThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]

    class eShotByEnum(IntEnum):
        Player = 0x0
        Anything = 0x1
        PlayerOrRemotePlayer = 0x2

    ShotBy: Annotated[c_enum32[eShotByEnum], Field(c_enum32[eShotByEnum], 0x8)]


@partial_struct
class cGcCreatureNearbyEvent(Structure):
    AlertTable: Annotated[
        basic.cTkDynamicArray[cGcCreatureAlertData],
        Field(basic.cTkDynamicArray[cGcCreatureAlertData], 0x0),
    ]
    Inverse: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcPlayerAttributesEvent(Structure):
    CheckSpaceWalking: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    IsSpaceWalking: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcPlayerNearbyEvent(Structure):
    MustAffordCostID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Angle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AngleMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AngleOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]

    class eDistanceCheckTypeEnum(IntEnum):
        Radius = 0x0
        BoundingBox = 0x1

    DistanceCheckType: Annotated[
        c_enum32[eDistanceCheckTypeEnum], Field(c_enum32[eDistanceCheckTypeEnum], 0x20)
    ]

    class eRequirePlayerActionEnum(IntEnum):
        None_ = 0x0
        Fire = 0x1
        InShip = 0x2
        OnFoot = 0x3
        OnFootOutside = 0x4
        Upload = 0x5

    RequirePlayerAction: Annotated[
        c_enum32[eRequirePlayerActionEnum],
        Field(c_enum32[eRequirePlayerActionEnum], 0x24),
    ]
    AnglePlayerRelative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    AngleReflected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    IncludeAllPhysics: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    IncludeMobileNPCs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    Inverse: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    OnlyForLocalPlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    TeleporterCountsAsPlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]


@partial_struct
class cGcStateTimeEvent(Structure):
    RandomSeconds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Seconds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    UseMissionClock: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcStormEvent(Structure):
    InStorm: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcCustomisationBackpackData(Structure):
    ActiveJetOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    NodeName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)]


@partial_struct
class cGcCustomisationBannerImageData(Structure):
    TipText: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    BannerImage: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    LinkedSpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x38)]
    WideImage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]


@partial_struct
class cGcPlayAnimAction(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcPlayAudioAction(Structure):
    OcclusionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Sound: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x4)]
    UseOcclusion: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x84)]


@partial_struct
class cGcPowerStateAction(Structure):
    SetConnectionEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    SetRateEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcResetSimpleInteractionAction(Structure):
    pass


@partial_struct
class cGcCustomisationBobbleHead(Structure):
    BobbleHead: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    LinkedTechId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcRewardAction(Structure):
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcCustomisationBoneScales(Structure):
    GroupTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Positions: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x20),
    ]
    ScaleBoneName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcMultitoolPoolData(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MaxDraw: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinDraw: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    PoolProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    PoolType: Annotated[
        c_enum32[enums.cGcMultitoolPoolType],
        Field(c_enum32[enums.cGcMultitoolPoolType], 0x1C),
    ]


@partial_struct
class cGcFireSimpleInteractionAction(Structure):
    pass


@partial_struct
class cGcFrigateInteractionAction(Structure):
    CommunicatorDialog: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]

    class eActionTypeEnum(IntEnum):
        Repair = 0x0
        UpdateDamagedComponents = 0x1
        CargoPhoneCall = 0x2

    ActionType: Annotated[
        c_enum32[eActionTypeEnum], Field(c_enum32[eActionTypeEnum], 0x20)
    ]


@partial_struct
class cGcHarvestPlantAction(Structure):
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcHazardAction(Structure):
    Hazard: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x0),
    ]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    RadiusBasedStrength: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcLodAction(Structure):
    LodOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcNodeActivationAction(Structure):
    SceneToAdd: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]

    class eNodeActiveStateEnum(IntEnum):
        Activate = 0x0
        Deactivate = 0x1
        Toggle = 0x2
        Add = 0x3
        Remove = 0x4
        RemoveChildren = 0x5

    NodeActiveState: Annotated[
        c_enum32[eNodeActiveStateEnum], Field(c_enum32[eNodeActiveStateEnum], 0x10)
    ]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x14)]
    AffectModels: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x94)]
    IncludeChildPhysics: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x95)]
    IncludePhysics: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x96)]
    NotifyNPC: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x97)]
    RestartEmitters: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x98)]
    UseLocalNode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x99)]
    UseMasterModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9A)]


@partial_struct
class cGcSpaceStormData(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    StormId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcPainAction(Structure):
    Damage: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RetriggerTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AffectsPlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    RadiusBasedDamage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]


@partial_struct
class cGcBaseBuildingSettingsAction(Structure):
    MaxAffectedDetail: Annotated[
        c_enum32[enums.cTkGraphicsDetailTypes],
        Field(c_enum32[enums.cTkGraphicsDetailTypes], 0x0),
    ]

    class eUseCorePartsOnlyEnum(IntEnum):
        False_ = 0x0
        True_ = 0x1
        DontCare = 0x2

    UseCorePartsOnly: Annotated[
        c_enum32[eUseCorePartsOnlyEnum], Field(c_enum32[eUseCorePartsOnlyEnum], 0x4)
    ]


@partial_struct
class cGcMetaBallComponentData(Structure):
    MaxSize: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    MinSize: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Root: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x34)]


@partial_struct
class cGcCameraShakeAction(Structure):
    Shake: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FalloffMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FalloffMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcDestroyAction(Structure):
    PlayEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DestroyAll: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    UseDestructables: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcHeroLightData(Structure):
    DayColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    NightColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    DayIntensityMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FOVMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    NightIntensityMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    LightName: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x2C)
    ]


@partial_struct
class cGcActionTrigger(Structure):
    Action: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    Event: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x10)]


@partial_struct
class cGcLootProbability(Structure):
    LootModel: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcActionTriggerState(Structure):
    StateID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Triggers: Annotated[
        basic.cTkDynamicArray[cGcActionTrigger],
        Field(basic.cTkDynamicArray[cGcActionTrigger], 0x10),
    ]


@partial_struct
class cGcBaseDefenceTrigger(Structure):
    LaserEffectId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PerceptionId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ActiveWhenIdle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    ActiveWhenSearching: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    ActiveWhenTargetAcquired: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]


@partial_struct
class cGcCameraShakeTriggerData(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FrameStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Shake: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x14)]


@partial_struct
class cGcChainComponentData(Structure):
    StartBone: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]


@partial_struct
class cGcColourisePalette(Structure):
    PrimaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    QuaternaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    SecondaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    TernaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]


@partial_struct
class cGcInventoryTechProbability(Structure):
    Tech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eDesiredTechProbabilityEnum(IntEnum):
        Never = 0x0
        Rare = 0x1
        Common = 0x2
        Always = 0x3

    DesiredTechProbability: Annotated[
        c_enum32[eDesiredTechProbabilityEnum],
        Field(c_enum32[eDesiredTechProbabilityEnum], 0x10),
    ]


@partial_struct
class cGcEasyRagdollSetUpBodyDimensions(Structure):
    Centre: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Size: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Joint: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]


@partial_struct
class cGcEasyRagdollSetUpData(Structure):
    ChainEnds: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x0),
    ]
    ExcludeJoints: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x10),
    ]
    ForceBodyDimensions: Annotated[
        basic.cTkDynamicArray[cGcEasyRagdollSetUpBodyDimensions],
        Field(basic.cTkDynamicArray[cGcEasyRagdollSetUpBodyDimensions], 0x20),
    ]


@partial_struct
class cGcMiningComponentData(Structure):
    Range: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcOutpostLSystemPair(Structure):
    LSystems: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Locator: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x90)]


@partial_struct
class cGcInteractionDof(Structure):
    FarFadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FarPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    NearPlaneAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    NearPlaneMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    IsEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    UseGlobals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcCombatEffectsProperties(Structure):
    DamageMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DurationMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    IgnoreFromOtherPlayers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    IgnoreFromSelf: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]
    IsAffected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]


@partial_struct
class cGcPlayerControlInput(Structure):
    Inputs: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    InterceptInputBlackList: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]], 0x10),
    ]
    InterceptInputWhitelist: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]], 0x20),
    ]
    InterceptAllInputs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcPlayerControlModeEntry(Structure):
    ControlModeResource: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcPlayerControlState(Structure):
    OverrideInput: Annotated[cGcPlayerControlInput, Field(cGcPlayerControlInput, 0x0)]
    Data: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x38),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]
    OverrideCamera: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x58)]
    StickToGround: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x68)]


@partial_struct
class cGcCharacterAlternateAnimation(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Replacement: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcCharacterJetpackEffect(Structure):
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NodeName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)
    ]


@partial_struct
class cGcCharacterLookAtData(Structure):
    CreatureLookAtRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    InteractionLookAtRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LookAtMaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LookAtMaxYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    LookAtRunGlanceMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    LookAtRunGlanceMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    LookAtRunMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    LookAtRunMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    LookAtTargetGlanceMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    LookAtTargetGlanceMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    LookAtTargetWaitMaxTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    LookAtTargetWaitMinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    SpaceshipLookAtRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcCharacterMove(Structure):
    Input: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eModeEnum(IntEnum):
        SetVelocity = 0x0
        ApplyForce = 0x1

    Mode: Annotated[c_enum32[eModeEnum], Field(c_enum32[eModeEnum], 0x10)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcCharacterRotate(Structure):
    Input: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Damping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RotateAxis: Annotated[
        c_enum32[enums.cGcPrimaryAxis], Field(c_enum32[enums.cGcPrimaryAxis], 0x14)
    ]
    RotateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcRewardTableEntitlementItem(Structure):
    EntitlementId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Reward: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x10)]
    RewardId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcStatsBonus(Structure):
    Bonus: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Stat: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x8)
    ]


@partial_struct
class cGcStatIconTable(Structure):
    StatIcons: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]


@partial_struct
class cGcInventoryValueData(Structure):
    BaseCostPerSlot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BaseMaxValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    BaseMinValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    ExponentialValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    SlotExponentialValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SlotsPerLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    ValueToCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcValueData(Structure):
    pass


@partial_struct
class cGcExactResource(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    GenerationSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]


@partial_struct
class cGcItemFilterStageDataStageGroup(Structure):
    Children: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]

    class eFilterStageGroupOperatorEnum(IntEnum):
        AND = 0x0
        OR = 0x1

    FilterStageGroupOperator: Annotated[
        c_enum32[eFilterStageGroupOperatorEnum],
        Field(c_enum32[eFilterStageGroupOperatorEnum], 0x10),
    ]


@partial_struct
class cGcItemFilterStageDataTechPack(Structure):
    DisabledMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcWeaponTerminalInteractionData(Structure):
    RespawnPeriodInSeconds: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    UseSentinelWeapon: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcRewardDestructEntry(Structure):
    HealthFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcRewardDestructRarities(Structure):
    Rarities: Annotated[cGcRewardDestructEntry, Field(cGcRewardDestructEntry, 0x0)]


@partial_struct
class cGcCustomiseShipInteractionData(Structure):
    IsSettlementPad: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcItemFilterData(Structure):
    Root: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]


@partial_struct
class cGcItemFilterDataTableEntry(Structure):
    Filter: Annotated[cGcItemFilterData, Field(cGcItemFilterData, 0x0)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcUnlockablePlatformReward(Structure):
    ProductId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RewardId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcItemFilterStageDataAcceptAll(Structure):
    pass


@partial_struct
class cGcUnlockableSeasonReward(Structure):
    SpecificMilestoneLoc: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    SeasonIds: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x30),
    ]
    StageIds: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x40),
    ]
    MustBeUnlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    SwitchExclusive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    UniqueInventoryItem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]


@partial_struct
class cGcItemFilterStageDataMatchID(Structure):
    DisabledMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ValidIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    MatchType: Annotated[
        c_enum32[enums.cGcItemFilterMatchIDType],
        Field(c_enum32[enums.cGcItemFilterMatchIDType], 0x30),
    ]


@partial_struct
class cGcItemFilterStageDataNegation(Structure):
    Child: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]


@partial_struct
class cGcUnlockableTwitchReward(Structure):
    LinkedGroupId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ProductId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    TwitchId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcWeaponInventoryMaxUpgradeCapacity(Structure):
    MaxInventoryCapacity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcUnlockableItemTreeNode(Structure):
    Children: Annotated[
        "basic.cTkDynamicArray[cGcUnlockableItemTreeNode]",
        Field("basic.cTkDynamicArray[cGcUnlockableItemTreeNode]", 0x0),
    ]
    Unlockable: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcUnlockableItemTree(Structure):
    Root: Annotated[cGcUnlockableItemTreeNode, Field(cGcUnlockableItemTreeNode, 0x0)]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    CostTypeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]


@partial_struct
class cGcWeightedFilename(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcTechList(Structure):
    AvailableTech: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcTradingCategoryData(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    ProductMultiplierChangePer100: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18)
    ]
    SubstanceMultiplierChangePer100: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1C)
    ]
    Name: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x20)]


@partial_struct
class cGcTradeData(Structure):
    AlwaysConsideredBarterProducts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    AlwaysPresentProducts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    AlwaysPresentSubstances: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    OptionalProducts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    OptionalSubstances: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x40),
    ]
    MaxAmountOfProductAvailable: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    MaxAmountOfSubstanceAvailable: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x60)
    ]
    MaxExtraSystemProducts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    MinAmountOfProductAvailable: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    MinAmountOfSubstanceAvailable: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x90)
    ]
    MinExtraSystemProducts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    TradeProductsPriceImprovements: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB0)
    ]
    BarterItemPreferenceFloor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    BarterPriceMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    BuyPriceDecreaseGreenThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC8)
    ]
    BuyPriceIncreaseRedThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    MaxItemsForSale: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xD0)]
    MinItemsForSale: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xD4)]
    PercentageOfItemsAreProducts: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    SellPriceDecreaseRedThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xDC)
    ]
    SellPriceIncreaseGreenThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xE0)
    ]
    BarterAcceptanceCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xE4)
    ]
    ShowSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE5)]
    UseBarterForBuy: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE6)]


@partial_struct
class cGcTechBoxData(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    InstallTechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x28)]
    IsAlien: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]


@partial_struct
class cGcSubstanceSecondary(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AmountMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AmountMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Chance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcSubstanceSecondaryBiome(Structure):
    SecondarySubstanceByBiome: Annotated[
        cGcSubstanceSecondary, Field(cGcSubstanceSecondary, 0x0)
    ]


@partial_struct
class cGcSubstanceSecondaryLookup(Structure):
    PrimaryID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    SecondaryChances: Annotated[
        basic.cTkDynamicArray[cGcSubstanceSecondary],
        Field(basic.cTkDynamicArray[cGcSubstanceSecondary], 0x10),
    ]


@partial_struct
class cGcSettlementStatStrengthRanges(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcSettlementStatStrengthData(Structure):
    PerkStatStrengthValues: Annotated[
        cGcSettlementStatStrengthRanges, Field(cGcSettlementStatStrengthRanges, 0x0)
    ]


@partial_struct
class cGcSettlementJudgementPerkOption(Structure):
    Perk: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PerkChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcShipInventoryMaxUpgradeCapacity(Structure):
    MaxCargoInventoryCapacity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MaxInventoryCapacity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MaxTechInventoryCapacity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcStatsEntry(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    BaseTechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    RangeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    RangeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Type: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x28)
    ]
    LessIsBetter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]


@partial_struct
class cGcStatsGroup(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    StatIds: Annotated[
        basic.cTkDynamicArray[cGcStatsEntry],
        Field(basic.cTkDynamicArray[cGcStatsEntry], 0x28),
    ]


@partial_struct
class cGcStats(Structure):
    Stats: Annotated[
        basic.cTkDynamicArray[cGcStatsGroup],
        Field(basic.cTkDynamicArray[cGcStatsGroup], 0x0),
    ]


@partial_struct
class cGcRewardTrigger(Structure):
    Trigger: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    UseMasterModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRewardTriggerMaintenance(Structure):
    pass


@partial_struct
class cGcRewardTriggerSettlementJudgement(Structure):
    pass


@partial_struct
class cGcRewardTriggerStorm(Structure):
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcRewardUnlockSeasonReward(Structure):
    EncryptedText: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    MarkAsClaimedInShop: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    UniqueInventoryItem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]
    UseSpecialFormatting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x33)]


@partial_struct
class cGcRewardUnlockTitle(Structure):
    TitleID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NoMusic: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    ShowEvenIfAlreadyUnlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcSettlementGiftDetails(Structure):
    LocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcRewardUpgradeWeaponClass(Structure):
    MatchClassToCommunityTier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]
    SilentlyMoveOnAtMaxClass: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2)]


@partial_struct
class cGcRewardUploadBase(Structure):
    pass


@partial_struct
class cGcRewardWantedLevel(Structure):
    Message: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcRewardWeapon(Structure):
    PoolTypeProbabilities: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ItemLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    SetInteractionStateOnSuccess: Annotated[
        c_enum32[enums.cGcInteractionMissionState],
        Field(c_enum32[enums.cGcInteractionMissionState], 0x18),
    ]
    ForceFixed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]
    MarkInteractionComplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D)]
    OnlyUseNextInteractionOnSuccess: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x1E)
    ]
    ReinteractOnDecline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1F)]
    RequeueInteraction: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    UsePlanetSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]


@partial_struct
class cGcRewardWeaponSlot(Structure):
    Cost: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NumTokens: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AwardCostAndOpenWindow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardWikiTopic(Structure):
    Topic: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    CentreMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcRewardTechRecipe(Structure):
    RewardGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Category: Annotated[
        c_enum32[enums.cGcTechnologyCategory],
        Field(c_enum32[enums.cGcTechnologyCategory], 0x10),
    ]


@partial_struct
class cGcRewardTimeWarp(Structure):
    pass


@partial_struct
class cGcRewardTraderFlyby(Structure):
    ExperienceSpawnIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcRewardStartPurchase(Structure):
    pass


@partial_struct
class cGcRewardStartSettlementExpedition(Structure):
    pass


@partial_struct
class cGcRewardStatCompareAndSet(Structure):
    CompareAndSetStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CoreStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcRewardStationTeleportEndpoint(Structure):
    FailPeekIfCannotAdd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardSwapMultiTool(Structure):
    pass


@partial_struct
class cGcRewardSystemSpecificProductFromList(Structure):
    ProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    ForceSpecialMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcRewardTableItem(Structure):
    LabelID: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Reward: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x10)]
    PercentageChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcRewardSpecificTechFromList(Structure):
    TechList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]

    class eTechListRewardOrderEnum(IntEnum):
        OneRandom = 0x0
        InOrder = 0x1
        TryAllRandom = 0x2

    TechListRewardOrder: Annotated[
        c_enum32[eTechListRewardOrderEnum],
        Field(c_enum32[eTechListRewardOrderEnum], 0x10),
    ]
    FailIfAllKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardShipMessage(Structure):
    ShipMessage: Annotated[
        c_enum32[enums.cGcShipMessage], Field(c_enum32[enums.cGcShipMessage], 0x0)
    ]


@partial_struct
class cGcRewardShipSlot(Structure):
    Cost: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NumTokens: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AwardCostAndOpenWindow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    FallbackOpenWindowIfBlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]
    IsAlien: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x16)]


@partial_struct
class cGcRewardShowBlackHoles(Structure):
    pass


@partial_struct
class cGcRewardSpecialFromList(Structure):
    TextFormat: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    FallbackList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    PriorityList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]


@partial_struct
class cGcRewardSpecificCommunityTierProduct(Structure):
    ProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    RequiresTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    ForceSpecialMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]


@partial_struct
class cGcRewardSpecificSpecial(Structure):
    Message: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    MilestoneRewardOverrideText: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    FailIfAlreadyKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    HideInSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    ShowSpecialProductPopup: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]
    UseSpecialFormatting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x53)]


@partial_struct
class cGcRewardSpecificSubstance(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionSubstanceEnum],
        Field(c_enum32[enums.cGcDefaultMissionSubstanceEnum], 0x18),
    ]
    DisableMultiplier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]
    RewardAsBlobs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1E)]
    UseFuelMultiplier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1F)]
    UseMissionBoardDifficultyScale: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcRewardSpecificTech(Structure):
    TechId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AutoPin: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    HideInSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]


@partial_struct
class cGcRewardSpecificProduct(Structure):
    SeasonRewardListFormat: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RequiresTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x48),
    ]
    ForceSpecialMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]
    HideAmountInMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]
    HideInSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4F)]


@partial_struct
class cGcRewardSettlementProgress(Structure):
    BuildingType: Annotated[
        c_enum32[enums.cGcBuildingClassification],
        Field(c_enum32[enums.cGcBuildingClassification], 0x0),
    ]
    UseInteractionBuildingType: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcRewardSpecificProductFromList(Structure):
    IncrementGlobalStatOnSuccess: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    ForceSpecialMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]


@partial_struct
class cGcRewardSpecificProductRecipe(Structure):
    SeasonRewardFormat: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    HideInSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcRewardSpecificProductRecipeFromList(Structure):
    ProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]

    class eProductListRewardOrderEnum(IntEnum):
        OneRandom = 0x0
        InOrder = 0x1
        TryAllRandom = 0x2
        TryUnknownRandom = 0x3

    ProductListRewardOrder: Annotated[
        c_enum32[eProductListRewardOrderEnum],
        Field(c_enum32[eProductListRewardOrderEnum], 0x10),
    ]
    FailIfAllKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardSetWeaponSuppressed(Structure):
    WeaponSuppressed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardShield(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    ShowOSDOnFail: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    ShowOSDOnSuccess: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]


@partial_struct
class cGcRewardSpecificSeasonalSubstance(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    ChanceToUse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    SeasonNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]


@partial_struct
class cGcRewardShipAssistance(Structure):
    class eAssistanceTypeEnum(IntEnum):
        Police = 0x0
        Wingmen = 0x1

    AssistanceType: Annotated[
        c_enum32[eAssistanceTypeEnum], Field(c_enum32[eAssistanceTypeEnum], 0x0)
    ]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcRewardSalvageMultitool(Structure):
    pass


@partial_struct
class cGcRewardSetAbandonedFreighterMissionState(Structure):
    class eAbandonedFreighterMissionStateEnum(IntEnum):
        EndRoomComplete = 0x0
        CrewManifestRead = 0x1
        CaptainsLogRead = 0x2
        HazardOn = 0x3
        SlowWalkOn = 0x4
        OpenDoors = 0x5

    AbandonedFreighterMissionState: Annotated[
        c_enum32[eAbandonedFreighterMissionStateEnum],
        Field(c_enum32[eAbandonedFreighterMissionStateEnum], 0x0),
    ]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcRewardSetAtlasMissionActive(Structure):
    pass


@partial_struct
class cGcRewardSalvageShip(Structure):
    SpecificCustomisationSlotIDs: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RewardShipParts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB0)]


@partial_struct
class cGcRewardSetCurrentMission(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Seeded: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcRewardScan(Structure):
    ScanDataId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcRewardSetFirstPurpleSystemUA(Structure):
    pass


@partial_struct
class cGcRewardScanEvent(Structure):
    Event: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    FailureOSD: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]

    class eScanEventTableEnum(IntEnum):
        Space = 0x0
        Planet = 0x1
        Missions = 0x2
        Tutorial = 0x3
        MissionsCreative = 0x4
        NPCPlanetSite = 0x5

    ScanEventTable: Annotated[
        c_enum32[eScanEventTableEnum], Field(c_enum32[eScanEventTableEnum], 0x40)
    ]
    StartDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    DoAerialScan: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    ForceSilentFailure: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]
    UseMissionIDSeedForEvent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4A)]
    UseStartDelayWhenNoAerialScan: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B)]


@partial_struct
class cGcRewardScanEventNearestBuilding(Structure):
    DoAerialScan: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    IncludeVisited: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]


@partial_struct
class cGcRewardSetInteractionMissionState(Structure):
    MissionState: Annotated[
        c_enum32[enums.cGcInteractionMissionState],
        Field(c_enum32[enums.cGcInteractionMissionState], 0x0),
    ]
    SetForInteractionClassInMyBuilding: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0x4),
    ]
    SetForThisInteraction: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcRewardSetInteractionSeenBitmask(Structure):
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    InteractionType: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0x10),
    ]
    OverrideIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcRewardSetMissionStat(Structure):
    ValueToAdd: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    ValueToSet: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcRewardSetNexusExitWarpTargetToFireteamMemberUA(Structure):
    FireteamMemberIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcRewardSettlementCustomJudgement(Structure):
    CustomJudgement: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    CanOverrideNonCustomJudgement: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    DisplaySettlementJudgementAlert: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x11)
    ]


@partial_struct
class cGcRewardSettlementJobGift(Structure):
    pass


@partial_struct
class cGcRewardRefreshHazProt(Structure):
    Amount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    SpecificHazard: Annotated[
        c_enum32[enums.cGcPlayerHazardType],
        Field(c_enum32[enums.cGcPlayerHazardType], 0x4),
    ]
    SetNotAdd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]


@partial_struct
class cGcRewardSettlementParty(Structure):
    OSD: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    FireworksDuration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    FireworksFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcRewardReinitialise(Structure):
    OverrideMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    DoIntroNextWarp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcRewardRemoveSettlementJobPerk(Structure):
    pass


@partial_struct
class cGcRewardRepairTech(Structure):
    Category: Annotated[
        c_enum32[enums.cGcTechnologyCategory],
        Field(c_enum32[enums.cGcTechnologyCategory], 0x0),
    ]


@partial_struct
class cGcRewardSecondarySubstance(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AmountFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    RewardAsBlobs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardRequirementsForRecipe(Structure):
    RecipeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RewardInCreative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRewardSendChatMessage(Structure):
    CustomText: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    StatusMessageId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcRewardOpenPage(Structure):
    class ePageToOpenEnum(IntEnum):
        FreighterShipTransfer = 0x0
        DisplayPortalUa = 0x1
        ExpeditionSelect = 0x2
        TraderInventory = 0x3
        ExpeditionDetails = 0x4
        ExpeditionDebrief = 0x5
        BuildingPartsShop = 0x6
        ExocraftShop = 0x7
        NexusTechShop = 0x8
        ScrapDealerShop = 0x9
        BuyShip = 0xA
        SettlementsOverview = 0xB
        SettlementManagement = 0xC
        SettlerNPCDetails = 0xD
        SquadronManagement = 0xE
        SquadronRecruitment = 0xF
        FleetManagement = 0x10
        WeaponCustomisation = 0x11
        FoodUnit = 0x12
        CookTrade = 0x13
        ArchiveManagementShip = 0x14
        BoneShop = 0x15
        BiggsBarterShop = 0x16
        BiggsBasicShop = 0x17

    PageToOpen: Annotated[
        c_enum32[ePageToOpenEnum], Field(c_enum32[ePageToOpenEnum], 0x0)
    ]
    ReinteractWhenComplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcRewardProceduralProductFromBiome(Structure):
    pass


@partial_struct
class cGcRewardOpenUnlockTree(Structure):
    PageIndexOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    TreeToOpen: Annotated[
        c_enum32[enums.cGcUnlockableItemTreeGroups],
        Field(c_enum32[enums.cGcUnlockableItemTreeGroups], 0x4),
    ]


@partial_struct
class cGcRewardProcTechProduct(Structure):
    Group: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    WeightedChanceEpic: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    WeightedChanceLegendary: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    WeightedChanceNormal: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    WeightedChanceRare: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    AllowAnyGroup: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    ForceQualityRelevant: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    ForceRelevant: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcRewardPurpleSystems(Structure):
    Allow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardRechargeTech(Structure):
    TechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRewardOverridePulseEncounterChance(Structure):
    Chance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcRewardPetAction(Structure):
    EffectID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    PlayerEmoteID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    SpecialHarvestID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    PetAction: Annotated[
        c_enum32[enums.cGcCreaturePetRewardActions],
        Field(c_enum32[enums.cGcCreaturePetRewardActions], 0x30),
    ]
    SpecialHarvestMul: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]


@partial_struct
class cGcRewardMultiSpecificProductRecipes(Structure):
    SetName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    DisplayProductId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ProductIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcRewardPetEgg(Structure):
    pass


@partial_struct
class cGcRewardMultiSpecificProducts(Structure):
    SetName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    ProductIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    OnlyGiveThisManyFromTheListAtRandom: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x30)
    ]
    UseListPopup: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]


@partial_struct
class cGcRewardPetEggHatch(Structure):
    EggIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcRewardPirateAttack(Structure):
    AttackDefinition: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NumSquads: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Instant: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardMultiSpecificTechRecipes(Structure):
    SetName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    DisplayTechId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    TechIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcRewardPirateProbeSignal(Structure):
    Attack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardNetworkPlayer(Structure):
    RewardWord: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x0)
    ]


@partial_struct
class cGcRewardPlanetSubstance(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    DisableMultiplier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    RewardAsBlobs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]
    UseFuelMultiplier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]


@partial_struct
class cGcRewardNexus(Structure):
    Allow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardPoliceScanSignal(Structure):
    Attack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardOpenFreeFreighter(Structure):
    NextInteractionIfBought: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    NextInteractionIfNotBought: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x20)]
    ReinteractWhenBought: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcRewardMission(Structure):
    AlreadyActiveFailureMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    FailRewardIfMissionActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    Restart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    SetAsSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcRewardMissionMessage(Structure):
    MessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BroadcastInMultiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRewardMissionMessageSeeded(Structure):
    MessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    SpecificMissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BroadcastInMultiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    BroadcastToActiveMultiplayerMission: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x21)
    ]


@partial_struct
class cGcRewardMissionMessageToMatchingSeeds(Structure):
    MessageID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BroadcastInMultiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRewardMissionOverride(Structure):
    ForceLocalMissionSelection: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    OptionalMissionSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x20)]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcRewardMissionSeeded(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MissionNoGroundCombat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    MissionNoSpaceCombat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ForceUseConversationSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    InheritActiveMultiplayerMissionSeed: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x31)
    ]
    SelectMissionAsLocalMissionBoard: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x32)
    ]


@partial_struct
class cGcRewardHazard(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcRewardHealth(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    SilentUnlessShieldAtMax: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcRewardIncrementStat(Structure):
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcRewardForgetSpecificTechRecipe(Structure):
    TechList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcRewardInstallTech(Structure):
    ReplaceExistingTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TechId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eInventoryToInstallInEnum(IntEnum):
        Personal = 0x0
        PersonalTech = 0x1
        Ship = 0x2
        ShipTech = 0x3
        Freighter = 0x4
        Vehicle = 0x5
        Weapon = 0x6

    InventoryToInstallIn: Annotated[
        c_enum32[eInventoryToInstallInEnum],
        Field(c_enum32[eInventoryToInstallInEnum], 0x20),
    ]
    SeedOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    InstallBroken: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]


@partial_struct
class cGcRewardFreeStamina(Structure):
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcRewardInteractionSketchBroadcast(Structure):
    BroadcastValue: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcRewardFreighterBaseReset(Structure):
    pass


@partial_struct
class cGcRewardInterventionResponse(Structure):
    InterveneWithMissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BasePercentOfMissionChanceSuccess: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x10)
    ]

    class eResponseTypeEnum(IntEnum):
        DontIntervene = 0x0
        InterveneWithMission = 0x1
        MissionSuccess = 0x2
        MissionFailure = 0x3
        MissionAvoid = 0x4
        MissionChance = 0x5

    ResponseType: Annotated[
        c_enum32[eResponseTypeEnum], Field(c_enum32[eResponseTypeEnum], 0x14)
    ]


@partial_struct
class cGcRewardFreighterMegaWarp(Structure):
    pass


@partial_struct
class cGcRewardInventorySlots(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcRewardFreighterSlot(Structure):
    Cost: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcRewardJetpackBoost(Structure):
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ForwardBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    IgnitionBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    UpBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cGcRewardDamageTech(Structure):
    TechToDamage_optional: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Category: Annotated[
        c_enum32[enums.cGcTechnologyCategory],
        Field(c_enum32[enums.cGcTechnologyCategory], 0x10),
    ]
    ShowDamageMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcRewardDeactivateFiends(Structure):
    pass


@partial_struct
class cGcRewardEnergy(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcRewardExchangeProduct(Structure):
    IDToGive: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    IDToTake: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AmountToGiveMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountToGiveMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    AmountToTakeMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    ForceSpecialMessage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    HideNewProduct: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]


@partial_struct
class cGcRewardExitEditShipInteraction(Structure):
    pass


@partial_struct
class cGcRewardFactionStanding(Structure):
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Faction: Annotated[
        c_enum32[enums.cGcMissionFaction], Field(c_enum32[enums.cGcMissionFaction], 0x8)
    ]
    SetToMinBeforeAdd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcRewardFillInventoryWithBrokenSlots(Structure):
    CustomTechCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    CustomTechOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    FractionOfInventoryToBreak: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]

    class eInventoryToBreakEnum(IntEnum):
        Ship = 0x0
        ShipTech = 0x1
        Freighter = 0x2
        FreighterTech = 0x3
        Vehicle = 0x4
        VehicleTech = 0x5
        Weapon = 0x6

    InventoryToBreak: Annotated[
        c_enum32[eInventoryToBreakEnum], Field(c_enum32[eInventoryToBreakEnum], 0xC)
    ]
    CustomTechFormat: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)
    ]


@partial_struct
class cGcRewardFishRelease(Structure):
    Rarity: Annotated[
        c_enum32[enums.cGcItemQuality], Field(c_enum32[enums.cGcItemQuality], 0x0)
    ]


@partial_struct
class cGcRewardForceDiscoverSystem(Structure):
    Silent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardForceOpenGalaxyMap(Structure):
    BlockWarp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardForgetSpecificProductRecipe(Structure):
    ProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcRewardDisableSentinels(Structure):
    OSDMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    WantedBarMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcRewardDiscoverRune(Structure):
    AllRunes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcRewardCrashSiteFly(Structure):
    NPCScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcRewardDisguisedProduct(Structure):
    AwardDisplayIDDuringMission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DisplayAs: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x38),
    ]
    UseDisplayIDWhenInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]


@partial_struct
class cGcRewardCrashSiteRepair(Structure):
    pass


@partial_struct
class cGcRewardDisplayTechWindow(Structure):
    TechID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Damaged: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    FullBox: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    NeedsInstall: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]


@partial_struct
class cGcRewardCustomExpeditionLogEntry(Structure):
    LocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    RewardID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    FromIntervention: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    WhaleEvent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcRewardDummyLocID(Structure):
    LocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    AmountMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AmountMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcRewardCustomPlayerControl(Structure):
    RequestedMode: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcRewardEnableInteractionClass(Structure):
    pass


@partial_struct
class cGcRewardEnableSentinels(Structure):
    pass


@partial_struct
class cGcRewardEndFrigateFlyby(Structure):
    pass


@partial_struct
class cGcRewardEndScanEvent(Structure):
    EventID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]


@partial_struct
class cGcRewardBuildersKnown(Structure):
    pass


@partial_struct
class cGcRewardCargo(Structure):
    pass


@partial_struct
class cGcRewardCleanUpPulseEncounter(Structure):
    pass


@partial_struct
class cGcRewardClosePortal(Structure):
    pass


@partial_struct
class cGcRepShopDonation(Structure):
    AltIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DonationValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    MaxDonations: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    ValidProcProdCategories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]


@partial_struct
class cGcRewardAbortTakeoff(Structure):
    pass


@partial_struct
class cGcRewardActivateEncounterSentinels(Structure):
    EncounterComponentScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    EncounterOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcRealitySubstanceCraftingMix(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Ratio: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcRewardCompleteMission(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcRewardAdvancePortalState(Structure):
    PortalScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]


@partial_struct
class cGcRewardCompleteMultiMission(Structure):
    Missions: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcRewardAssessCookedProduct(Structure):
    AmountAverage: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    AmountBad: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    AmountBest: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    AmountBestUpper: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    AmountGood: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    AmountWorst: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcRewardBeginSettlementBuilding(Structure):
    ValidBuildings: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcBuildingClassification]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcBuildingClassification]], 0x0),
    ]
    IsUpgrade: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcRealityCraftingRecipeData(Structure):
    Inputs: Annotated[
        cGcRealitySubstanceCraftingMix, Field(cGcRealitySubstanceCraftingMix, 0x0)
    ]
    OutputID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]


@partial_struct
class cGcRealityIcon(Structure):
    ID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Texture: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]


@partial_struct
class cGcPurchaseableSpecial(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MissionTier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    ShopNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    IsConsumable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcProductDescriptionOverride(Structure):
    NewDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcProceduralProductDeployable(Structure):
    BaseID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Variants: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcNameGeneratorWord(Structure):
    Word: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    NumOptions: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcProceduralTechnologyStatLevel(Structure):
    Stat: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x0)
    ]
    ValueMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    ValueMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    WeightingCurve: Annotated[
        c_enum32[enums.cGcWeightingCurve], Field(c_enum32[enums.cGcWeightingCurve], 0xC)
    ]
    AlwaysChoose: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcNumberedTextList(Structure):
    Format: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcProceduralTechnologyData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    UpgradeColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    Group: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    StatLevels: Annotated[
        basic.cTkDynamicArray[cGcProceduralTechnologyStatLevel],
        Field(basic.cTkDynamicArray[cGcProceduralTechnologyStatLevel], 0x50),
    ]
    Template: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Category: Annotated[
        c_enum32[enums.cGcProceduralTechnologyCategory],
        Field(c_enum32[enums.cGcProceduralTechnologyCategory], 0x70),
    ]
    NumStatsMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    NumStatsMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]

    class eQualityEnum(IntEnum):
        Normal = 0x0
        Rare = 0x1
        Epic = 0x2
        Legendary = 0x3
        Illegal = 0x4
        Sentinel = 0x5
        Robot = 0x6
        SeaTrash = 0x7

    Quality: Annotated[c_enum32[eQualityEnum], Field(c_enum32[eQualityEnum], 0x7C)]
    WeightingCurve: Annotated[
        c_enum32[enums.cGcWeightingCurve],
        Field(c_enum32[enums.cGcWeightingCurve], 0x80),
    ]
    Description: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x84)
    ]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x104)]
    NameLower: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x184)
    ]
    Subtitle: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x204)
    ]
    IsBiggsProcTech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x284)]


@partial_struct
class cGcPlanetResourceIconLookup(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    IconBinocs: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x18)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcModularCustomisationTextureGroup(Structure):
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    TextureOptionGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcModularCustomisationColourGroup(Structure):
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Palettes: Annotated[
        basic.cTkDynamicArray[cTkPaletteTexture],
        Field(basic.cTkDynamicArray[cTkPaletteTexture], 0x20),
    ]
    DefaultColourIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]


@partial_struct
class cGcModularCustomisationColourData(Structure):
    RequiredTextureOption: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    ColourGroups: Annotated[
        basic.cTkDynamicArray[cGcModularCustomisationColourGroup],
        Field(basic.cTkDynamicArray[cGcModularCustomisationColourGroup], 0x20),
    ]
    PaletteID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    RequiredTextureGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]


@partial_struct
class cGcMultiSpecificItemEntry(Structure):
    CustomRewardLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ProcTechGroup: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    CommunityTierProductList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x40),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    SeasonRewardListFormat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]

    class eMultiItemRewardTypeEnum(IntEnum):
        Product = 0x0
        Substance = 0x1
        ProcTech = 0x2
        ProcProduct = 0x3
        InventorySlot = 0x4
        InventorySlotShip = 0x5
        InventorySlotWeapon = 0x6
        CommunityTierProduct = 0x7

    MultiItemRewardType: Annotated[
        c_enum32[eMultiItemRewardTypeEnum],
        Field(c_enum32[eMultiItemRewardTypeEnum], 0x74),
    ]
    ProcProdRarity: Annotated[
        c_enum32[enums.cGcRarity], Field(c_enum32[enums.cGcRarity], 0x78)
    ]
    ProcProdType: Annotated[
        c_enum32[enums.cGcProceduralProductCategory],
        Field(c_enum32[enums.cGcProceduralProductCategory], 0x7C),
    ]
    ProcTechQuality: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    AlsoTeachTechBoxRecipe: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x84)]
    HideInSeasonRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x85)]
    IllegalProcTech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x86)]
    SentinelProcTech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x87)]


@partial_struct
class cGcModularCustomisationColourGroupPalette(Structure):
    RequiredTextureOption: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    RequiredTextureGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x30)]


@partial_struct
class cGcModularCustomisationDescriptorGroupData(Structure):
    ActivatedDescriptorGroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcItemAmountCostPair(Structure):
    ItemId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcInventoryLayoutGenerationBounds(Structure):
    MaxHeightLarge: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MaxHeightSmall: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    MaxHeightStandard: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    MaxWidthLarge: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    MaxWidthSmall: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MaxWidthStandard: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcItemCostData(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ChangePerSale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Cost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MaxCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MinCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcItemPriceModifiers(Structure):
    BuyBaseMarkup: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    BuyMarkupMod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HighPriceMod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LowPriceMod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    SpaceStationMarkup: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcLegacyItem(Structure):
    ConvertID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    ConvertRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AddNewRecipe: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    RemoveOldRecipe: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]


@partial_struct
class cGcMaintenanceElement(Structure):
    LocatorOverride: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    AmountEmptyTimePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eCompletionRequirementEnum(IntEnum):
        FullyChargedAndRepaired = 0x0
        AnyChargeAndRepaired = 0x1
        FullyRepaired = 0x2
        NotFullyCharged = 0x3
        EmptySlot = 0x4
        NoRequirement = 0x5
        UserInstalls = 0x6
        HasIngredients = 0x7
        GroupInstall = 0x8

    CompletionRequirement: Annotated[
        c_enum32[eCompletionRequirementEnum],
        Field(c_enum32[eCompletionRequirementEnum], 0x34),
    ]
    DamagedAfterTimePeriodMax: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    DamagedAfterTimePeriodMin: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]

    class eDamageStatusEnum(IntEnum):
        Damaged = 0x0
        Repaired = 0x1
        Random = 0x2

    DamageStatus: Annotated[
        c_enum32[eDamageStatusEnum], Field(c_enum32[eDamageStatusEnum], 0x40)
    ]
    ItemGroupOverride: Annotated[
        c_enum32[enums.cGcMaintenanceElementGroups],
        Field(c_enum32[enums.cGcMaintenanceElementGroups], 0x44),
    ]
    MaxCapacity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    MaxRandAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MinRandAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Type: Annotated[
        c_enum32[enums.cGcInventoryType], Field(c_enum32[enums.cGcInventoryType], 0x54)
    ]

    class eUpdateTypeEnum(IntEnum):
        UpdatesAlways = 0x0
        UpdateOnlyWhenComplete = 0x1
        UpdateOnlyWhenNotComplete = 0x2

    UpdateType: Annotated[
        c_enum32[eUpdateTypeEnum], Field(c_enum32[eUpdateTypeEnum], 0x58)
    ]
    BlockDiscardWhenAllowedForParent: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x5C)
    ]
    HideWhenComplete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5D)]


@partial_struct
class cGcInventoryTableEntry(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LayoutSizeType: Annotated[
        c_enum32[enums.cGcInventoryLayoutSizeType],
        Field(c_enum32[enums.cGcInventoryLayoutSizeType], 0x10),
    ]
    MaxSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MinSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcInventoryCostDataEntry(Structure):
    ClassMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CoolMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MaxValueInMillions: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MinSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    MinValueInMillions: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    TradeInMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcInventoryCostData(Structure):
    InventoryCostData: Annotated[
        cGcInventoryCostDataEntry, Field(cGcInventoryCostDataEntry, 0x0)
    ]


@partial_struct
class cGcInventoryGenerationBaseStatDataEntry(Structure):
    BaseStatID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Max: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxFixedAdd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Min: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MinFixedAdd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcInventoryGenerationBaseStatClassData(Structure):
    BaseStats: Annotated[
        basic.cTkDynamicArray[cGcInventoryGenerationBaseStatDataEntry],
        Field(basic.cTkDynamicArray[cGcInventoryGenerationBaseStatDataEntry], 0x0),
    ]


@partial_struct
class cGcInventoryGenerationBaseStatData(Structure):
    BaseStatsPerClass: Annotated[
        cGcInventoryGenerationBaseStatClassData,
        Field(cGcInventoryGenerationBaseStatClassData, 0x0),
    ]


@partial_struct
class cGcDiscoveryTrimScoringRules(Structure):
    MaxScoreValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MinScoreValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Curve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x8)
    ]


@partial_struct
class cGcInventoryBaseStatBonus(Structure):
    StatType: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x0)
    ]
    LessIsBetter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcInventoryBaseStat(Structure):
    BaseStatID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LocID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    StatBonus: Annotated[
        basic.cTkDynamicArray[cGcInventoryBaseStatBonus],
        Field(basic.cTkDynamicArray[cGcInventoryBaseStatBonus], 0x20),
    ]


@partial_struct
class cGcInventoryBaseStatEntry(Structure):
    BaseStatID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcDiscoveryWorth(Structure):
    OnScan: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Record: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    Mission: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcInventoryClassProbabilities(Structure):
    ClassProbabilities: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcExpeditionPowerup(Structure):
    ModuleDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    SelectionDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    ProductId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    StatModified: Annotated[
        c_enum32[enums.cGcFrigateStatType],
        Field(c_enum32[enums.cGcFrigateStatType], 0x50),
    ]
    ValueChange: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]


@partial_struct
class cGcDiscoveryOwner(Structure):
    Timestamp: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    LocalID: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x4)]
    OnlineID: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x44)]
    Platform: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x84)]
    Username: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xC4)]


@partial_struct
class cGcDiscoveryRewardLookup(Structure):
    BiomeSpecific: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x110)]
    Secondary: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x120)]


@partial_struct
class cGcFreighterCargoOption(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    PercentChance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcCostSalvageShip(Structure):
    ShipClassStringOverride: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CannotAffordIfStringOverrideIsNull: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x160)
    ]
    WillGiveShipParts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x161)]


@partial_struct
class cGcCostSalvageTool(Structure):
    pass


@partial_struct
class cGcDeathQuote(Structure):
    QuoteLine1: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x0)
    ]
    QuoteLine2: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x80)
    ]
    Author: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x100)]


@partial_struct
class cGcCostSentinelBlockStatus(Structure):
    CanAffordIfSentinelsDisabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcCostSettlementBuildingUpgrade(Structure):
    LevelRequired: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcDialogClearanceInfo(Structure):
    GlobalDialogID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    AssociatedMission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    AlwaysForceClearThisPair: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcCostShipLowSpeed(Structure):
    MaxShipSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcCostShipType(Structure):
    ShipType: Annotated[
        c_enum32[enums.cGcSpaceshipClasses],
        Field(c_enum32[enums.cGcSpaceshipClasses], 0x0),
    ]


@partial_struct
class cGcCostShipUpgradeable(Structure):
    pass


@partial_struct
class cGcCostSpecificCreatureBait(Structure):
    pass


@partial_struct
class cGcCostStat(Structure):
    CostAsString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    StatGroup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Value: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]


@partial_struct
class cGcCostStatCompare(Structure):
    CostStringCanAfford: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CostStringCantAfford: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    CanAffordIfMissionActive: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    CompareAndSetStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    CoreStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]


@partial_struct
class cGcCostPoliceCargoComply(Structure):
    pass


@partial_struct
class cGcCostSubstance(Structure):
    UseScanEventToDetermineLocalSubstance: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionSubstanceEnum],
        Field(c_enum32[enums.cGcDefaultMissionSubstanceEnum], 0x34),
    ]
    LocalSubstanceType: Annotated[
        c_enum32[enums.cGcLocalSubstanceType],
        Field(c_enum32[enums.cGcLocalSubstanceType], 0x38),
    ]
    UseSpecificPlanetIndexForLocalSubstance: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x3C)
    ]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]
    UseRandomPlanetIndex: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41)]


@partial_struct
class cGcCostProcProduct(Structure):
    FreighterPasswordIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Rarity: Annotated[c_enum32[enums.cGcRarity], Field(c_enum32[enums.cGcRarity], 0x4)]
    Type: Annotated[
        c_enum32[enums.cGcProceduralProductCategory],
        Field(c_enum32[enums.cGcProceduralProductCategory], 0x8),
    ]
    CareAboutRarity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcCostTableEntry(Structure):
    CannotAffordOSDMsg: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CommunityContributionCapLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    Cost: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x40)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    MissionMessageWhenCharged: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    CommunityContributionValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    DisplayCost: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]
    DisplayOnlyCostIfCantAfford: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75)]
    DontCharge: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x76)]
    HideCostStringIfCanAfford: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x77)]
    HideOptionAndDisplayCostOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]
    InvertCanAffordOutcome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x79)]
    MustAffordInCreative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7A)]
    RemoveOptionIfCantAfford: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7B)]


@partial_struct
class cGcCostProduct(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x14),
    ]
    TakeIDFromSeasonData: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]


@partial_struct
class cGcCostProductOnlyTakeIfCanAfford(Structure):
    AltCostLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    Default: Annotated[
        c_enum32[enums.cGcDefaultMissionProductEnum],
        Field(c_enum32[enums.cGcDefaultMissionProductEnum], 0x34),
    ]


@partial_struct
class cGcCostInstalledTech(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eInventoryToCheckEnum(IntEnum):
        All = 0x0
        Suit = 0x1
        Ship = 0x2
        Weapon = 0x3
        Freighter = 0x4
        Buggy = 0x5

    InventoryToCheck: Annotated[
        c_enum32[eInventoryToCheckEnum], Field(c_enum32[eInventoryToCheckEnum], 0x10)
    ]
    MinChargePercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    BurnCharge: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcCostMultiTool(Structure):
    CostString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    WeaponClass: Annotated[
        c_enum32[enums.cGcWeaponClasses], Field(c_enum32[enums.cGcWeaponClasses], 0x20)
    ]


@partial_struct
class cGcCostOwnSettlement(Structure):
    NumRequired: Annotated[ctypes.c_int8, Field(ctypes.c_int8, 0x0)]


@partial_struct
class cGcCostInteractionMissionState(Structure):
    CanAffordLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CantAffordLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    RequiredState: Annotated[
        c_enum32[enums.cGcInteractionMissionState],
        Field(c_enum32[enums.cGcInteractionMissionState], 0x40),
    ]
    ThisInteractionClassInMyBuilding: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0x44),
    ]
    AlsoAcceptMaintenanceDone: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    TestThisInteraction: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]


@partial_struct
class cGcCostPendingSettlementJudgement(Structure):
    pass


@partial_struct
class cGcCostInteractionNeedsMaintenance(Structure):
    CantAffordLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcCostPirateTribute(Structure):
    CargoValuePercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MinimumValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcCostItemFromList(Structure):
    ItemList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcCostPoliceCargoBribe(Structure):
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    IncludeNipNip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    OnlyCargoProbeInventories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcCostItemFromListOfValue(Structure):
    CostText: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    ItemList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    UnitValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    UseDefaultAmount: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]


@partial_struct
class cGcCostItemListIndexed(Structure):
    Costs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]

    class eItemIndexProviderEnum(IntEnum):
        None_ = 0x0
        Biome = 0x1
        SubBiome = 0x2

    ItemIndexProvider: Annotated[
        c_enum32[eItemIndexProviderEnum], Field(c_enum32[eItemIndexProviderEnum], 0x14)
    ]

    class eItemOutOfBoundsBehaviourEnum(IntEnum):
        NoCost = 0x0
        UseFirst = 0x1
        UseLast = 0x2

    ItemOutOfBoundsBehaviour: Annotated[
        c_enum32[eItemOutOfBoundsBehaviourEnum],
        Field(c_enum32[eItemOutOfBoundsBehaviourEnum], 0x18),
    ]
    AssertIfOutOfBounds: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cGcCostJourneyMilestone(Structure):
    RequiredMilestone: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcCostJourneyStatLevel(Structure):
    StatName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RequiredLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCostLocalMissionAvailable(Structure):
    TextOverride: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcCostMissionActive(Structure):
    CostString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    MissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcCostMissionComplete(Structure):
    TextOverride: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Cost: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    HideIfCompleted: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcCostGroup(Structure):
    Text: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Costs: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x20),
    ]
    HideOptionIfCantAffordIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    TakeTextFromIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    Test: Annotated[
        c_enum32[enums.cGcMissionConditionTest],
        Field(c_enum32[enums.cGcMissionConditionTest], 0x38),
    ]


@partial_struct
class cGcCostMoney(Structure):
    Cost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    CostCurrency: Annotated[
        c_enum32[enums.cGcCurrency], Field(c_enum32[enums.cGcCurrency], 0x4)
    ]


@partial_struct
class cGcCostHasActiveScanEvent(Structure):
    OptionalEventID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Text: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]


@partial_struct
class cGcCostMoneyList(Structure):
    Costs: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x0),
    ]
    CostCurrency: Annotated[
        c_enum32[enums.cGcCurrency], Field(c_enum32[enums.cGcCurrency], 0x10)
    ]

    class eIndexProviderEnum(IntEnum):
        None_ = 0x0
        ShipSlot = 0x1
        ShipClass = 0x2
        DailyFreighters = 0x3
        WeaponClass = 0x4
        WeaponSlot = 0x5
        PetSlot = 0x6
        PilotSlot = 0x7
        PilotRank = 0x8

    IndexProvider: Annotated[
        c_enum32[eIndexProviderEnum], Field(c_enum32[eIndexProviderEnum], 0x14)
    ]

    class eOutOfBoundsBehaviourEnum(IntEnum):
        NoCost = 0x0
        UseFirst = 0x1
        UseLast = 0x2

    OutOfBoundsBehaviour: Annotated[
        c_enum32[eOutOfBoundsBehaviourEnum],
        Field(c_enum32[eOutOfBoundsBehaviourEnum], 0x18),
    ]
    AssertIfOutOfBounds: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cGcCostHasCorvetteProduct(Structure):
    pass


@partial_struct
class cGcCostHasFireteamMember(Structure):
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    BlockIfCannotAccessTheirPurpleSystem: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4)
    ]


@partial_struct
class cGcCostMultiItem(Structure):
    DisplayLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ItemList: Annotated[
        basic.cTkDynamicArray[cGcItemAmountCostPair],
        Field(basic.cTkDynamicArray[cGcItemAmountCostPair], 0x20),
    ]
    OnlyTakeIfCanAfford: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcCostHealth(Structure):
    HealthUnits: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcCostCanUseShipPad(Structure):
    ShipPadAvalible: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcCostCargo(Structure):
    Slots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcCostCommunityResearchTier(Structure):
    CompletedTiers: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MissionIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x8)
    ]


@partial_struct
class cGcCostCorvetteDockedForEdit(Structure):
    pass


@partial_struct
class cGcCostCorvetteDraftInProgress(Structure):
    pass


@partial_struct
class cGcCostCreatureCanLayEggs(Structure):
    pass


@partial_struct
class cGcCostDifficultyGroundCombat(Structure):
    CostStringCantAfford: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    GroundCombatTimers: Annotated[
        c_enum32[enums.cGcCombatTimerDifficultyOption],
        Field(c_enum32[enums.cGcCombatTimerDifficultyOption], 0x20),
    ]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x24)
    ]


@partial_struct
class cGcCostDifficultySpaceCombat(Structure):
    CostStringCantAfford: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    SpaceCombatTimers: Annotated[
        c_enum32[enums.cGcCombatTimerDifficultyOption],
        Field(c_enum32[enums.cGcCombatTimerDifficultyOption], 0x20),
    ]
    Test: Annotated[
        c_enum32[enums.cTkEqualityEnum], Field(c_enum32[enums.cTkEqualityEnum], 0x24)
    ]


@partial_struct
class cGcCostDiscovery(Structure):
    CostString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    DiscoveryType: Annotated[
        c_enum32[enums.cGcDiscoveryType], Field(c_enum32[enums.cGcDiscoveryType], 0x20)
    ]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcCostAdvanceSettlementBuilding(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCostFleetStoredIncome(Structure):
    Class: Annotated[
        c_enum32[enums.cGcFrigateClass], Field(c_enum32[enums.cGcFrigateClass], 0x0)
    ]
    RequiredAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcCostAnyCookedProduct(Structure):
    CostString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CostStringCantAfford: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    Index: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    MixRandomAndBetter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    PreferBetterItems: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]


@partial_struct
class cGcCostFossilComponent(Structure):
    pass


@partial_struct
class cGcCostFrigateCargo(Structure):
    pass


@partial_struct
class cGcCostCanAddShip(Structure):
    pass


@partial_struct
class cGcBuildingBlueprint(Structure):
    ProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    GroupId: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCostCanAdoptCreature(Structure):
    pass


@partial_struct
class cGcBuildingCostPartCount(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Count: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCostCanCustomiseCreature(Structure):
    pass


@partial_struct
class cGcCostCanDispatchFleetExpeditions(Structure):
    pass


@partial_struct
class cGcCostCanFreighterMegaWarp(Structure):
    pass


@partial_struct
class cGcCostCanMilkCreature(Structure):
    pass


@partial_struct
class cGcCostCanRideCreature(Structure):
    pass


@partial_struct
class cGcAlienPuzzleMissionOverride(Structure):
    Puzzle: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    RequireScanEventActive: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    AltPriorityMissionForSelection: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x40)
    ]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    OptionalMissionSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x60)]
    ForceMissionSeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]
    RequireMainMissionActiveWhenUsingAlt: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x71)
    ]
    RequireMainMissionSelected: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x72)]


@partial_struct
class cGcAlienSpeechEntry(Structure):
    Group: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Text: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Category: Annotated[
        c_enum32[enums.cGcWordCategoryTableEnum],
        Field(c_enum32[enums.cGcWordCategoryTableEnum], 0x50),
    ]
    Frequency: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x58)]
    Race: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x5C)
    ]

    class eWordInteractEffectEnum(IntEnum):
        Pain = 0x0
        Heal = 0x1

    WordInteractEffect: Annotated[
        c_enum32[eWordInteractEffectEnum],
        Field(c_enum32[eWordInteractEffectEnum], 0x60),
    ]


@partial_struct
class cGcBreakTechByStatData(Structure):
    DamageTechWithStat: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x0)
    ]
    IncludeStatChildren: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcChildNode(Structure):
    JointPositionInBone: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    PositionInBone: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    NodeName: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x20)]
    JointPositionInBoneSet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]


@partial_struct
class cGcAlienMoodMissionOverride(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Mood: Annotated[
        c_enum32[enums.cGcAlienMood], Field(c_enum32[enums.cGcAlienMood], 0x10)
    ]


@partial_struct
class cGcExperienceDebugTriggerAction(Structure):
    Action: Annotated[
        c_enum32[enums.cGcExperienceDebugTriggerActionTypes],
        Field(c_enum32[enums.cGcExperienceDebugTriggerActionTypes], 0x0),
    ]
    IntParameter: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcExperienceDebugTriggerInput(Structure):
    Actions: Annotated[
        basic.cTkDynamicArray[cGcExperienceDebugTriggerAction],
        Field(basic.cTkDynamicArray[cGcExperienceDebugTriggerAction], 0x0),
    ]

    class eKeyPressEnum(IntEnum):
        _1 = 0x0
        _2 = 0x1
        _3 = 0x2
        _4 = 0x3
        _5 = 0x4
        _6 = 0x5
        _7 = 0x6
        _8 = 0x7
        _9 = 0x8
        PadUp = 0x9
        PadDown = 0xA
        PadLeft = 0xB
        PadRight = 0xC

    KeyPress: Annotated[c_enum32[eKeyPressEnum], Field(c_enum32[eKeyPressEnum], 0x10)]


@partial_struct
class cGcPerformanceFlyby(Structure):
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    LockOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LockSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LockTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Offset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Locked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcPlayfabMatchmakingAttributes(Structure):
    gameProgress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    isBackfilling: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    needsSmallLobby: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    lobbyConnectionString: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xC)
    ]
    gamemode: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x10C)
    ]
    matchmakingVersion: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x18C)
    ]
    platform: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x20C)
    ]
    seasonNumber: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x28C)
    ]
    UA: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x2CC)]


@partial_struct
class cTkSaveID(Structure):
    Value: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]


@partial_struct
class cGcMessageTitanFall(Structure):
    pass


@partial_struct
class cGcMessageTrackTargetAlert(Structure):
    AlertPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Attacker: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Victim: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    Primary: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcJourneyMedalTiers(Structure):
    Bronze: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Gold: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    None_: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    Silver: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]


@partial_struct
class cGcMessageUpdateFrigateSpeed(Structure):
    StartSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    TargetSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcMessageCrime(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]

    class eCrimeEnum(IntEnum):
        AttackCreature = 0x0
        AttackSentinel = 0x1
        AttackSentinelLaser = 0x2
        KillCreature = 0x3
        KillSentinel = 0x4
        MineResources = 0x5
        HitResources = 0x6
        AttackSpaceStation = 0x7
        AttackShip = 0x8
        AttackPolice = 0x9
        KillShip = 0xA
        KillPolice = 0xB
        TimedShootable = 0xC

    Crime: Annotated[c_enum32[eCrimeEnum], Field(c_enum32[eCrimeEnum], 0x10)]
    Criminal: Annotated[basic.GcNodeID, Field(basic.GcNodeID, 0x14)]
    Value: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    Victim: Annotated[basic.GcNodeID, Field(basic.GcNodeID, 0x1C)]


@partial_struct
class cGcMessageCutSceneAction(Structure):
    Facing: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Local: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    Action: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]


@partial_struct
class cGcMessageNPCBehaviourEvent(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    BehaviourEvent: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    UserData: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    InteractionSubType: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    InteractionTrigger: Annotated[
        c_enum32[enums.cGcNPCTriggerTypes],
        Field(c_enum32[enums.cGcNPCTriggerTypes], 0x34),
    ]
    SourceNode: Annotated[basic.GcNodeID, Field(basic.GcNodeID, 0x38)]


@partial_struct
class cGcMessagePetBehaviourEvent(Structure):
    Direction: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    UserData: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x20)]
    BehaviourEvent: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    ForceBehaviour: Annotated[
        c_enum32[enums.cGcPetBehaviours], Field(c_enum32[enums.cGcPetBehaviours], 0x50)
    ]
    Mood: Annotated[
        c_enum32[enums.cGcAlienMood], Field(c_enum32[enums.cGcAlienMood], 0x54)
    ]
    SourceNode: Annotated[basic.GcNodeID, Field(basic.GcNodeID, 0x58)]


@partial_struct
class cGcMessageProjectileLaunch(Structure):
    pass


@partial_struct
class cGcMessageRequestTakeOff(Structure):
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ImmediatelyDissolveNPC: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcMessageRequestWarp(Structure):
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcMessageSubstanceMined(Structure):
    Substance: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcVROverride_Text(Structure):
    FloatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    IntValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]

    class eVROverride_TextEnum(IntEnum):
        FontHeight = 0x0
        FontIndex = 0x1

    VROverride_Text: Annotated[
        c_enum32[eVROverride_TextEnum], Field(c_enum32[eVROverride_TextEnum], 0x8)
    ]


@partial_struct
class cGcStyleProp_Colour(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]


@partial_struct
class cGcStyleProp_Font(Structure):
    FontIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcInputActionInfo(Structure):
    ConsoleLocTag: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    LocTag: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    OverlayIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    SolidIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    SpecialIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    VirtualButtonIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x70)
    ]

    class eInputActionInfoFlagsEnum(IntEnum):
        empty = 0x0
        AvailableOnConsole = 0x1
        HideInControlsPage = 0x2
        HideInControlRebindingPage = 0x4
        HideInMenusMenu = 0x8
        OnlyVR = 0x10
        OnlyNonVR = 0x20

    InputActionInfoFlags: Annotated[
        c_enum32[eInputActionInfoFlagsEnum],
        Field(c_enum32[eInputActionInfoFlagsEnum], 0x80),
    ]
    Pairing: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x84)
    ]
    TextTag: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x88)]
    ExternalDigitalAliasId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x108)
    ]
    ExternalId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x128)
    ]
    ExternalLoc: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x148)
    ]
    Analogue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x168)]


@partial_struct
class cGcStyleProp_Size(Structure):
    FontSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcIKConstraint(Structure):
    DefaultState: Annotated[
        cGcPlayerCharacterIKOverrideData, Field(cGcPlayerCharacterIKOverrideData, 0x0)
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    States: Annotated[
        basic.cTkDynamicArray[cGcPlayerCharacterIKStateData],
        Field(basic.cTkDynamicArray[cGcPlayerCharacterIKStateData], 0x30),
    ]
    Type: Annotated[
        c_enum32[enums.cGcCreatureIkType],
        Field(c_enum32[enums.cGcCreatureIkType], 0x40),
    ]
    JointName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x44)
    ]


@partial_struct
class cGcNGuiStyleAnimationKeyframeData(Structure):
    StyleProperties: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    Position: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcNGuiStyleAnimationData(Structure):
    KeyFrames: Annotated[
        basic.cTkDynamicArray[cGcNGuiStyleAnimationKeyframeData],
        Field(basic.cTkDynamicArray[cGcNGuiStyleAnimationKeyframeData], 0x0),
    ]
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AnimateByDefault: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    Loop: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcActionSetAction(Structure):
    Action: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x0)
    ]
    Status: Annotated[
        c_enum32[enums.cGcActionUseType], Field(c_enum32[enums.cGcActionUseType], 0x4)
    ]


@partial_struct
class cGcActionSet(Structure):
    LocTag: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Actions: Annotated[
        basic.cTkDynamicArray[cGcActionSetAction],
        Field(basic.cTkDynamicArray[cGcActionSetAction], 0x20),
    ]
    BlockedActions: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]], 0x30),
    ]
    Status: Annotated[
        c_enum32[enums.cGcActionUseType], Field(c_enum32[enums.cGcActionUseType], 0x40)
    ]
    Type: Annotated[
        c_enum32[enums.cGcActionSetType], Field(c_enum32[enums.cGcActionSetType], 0x44)
    ]
    ExternalId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x48)
    ]
    ExternalLoc: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x68)
    ]
    ParentExternalId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x88)
    ]


@partial_struct
class cGcVROverride_Layout(Structure):
    FloatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eVROverride_LayoutEnum(IntEnum):
        PosX = 0x0
        PosY = 0x1
        LayerWidth = 0x2
        LayerHeight = 0x3
        MaxWidth = 0x4

    VROverride_Layout: Annotated[
        c_enum32[eVROverride_LayoutEnum], Field(c_enum32[eVROverride_LayoutEnum], 0x4)
    ]


@partial_struct
class cGcAccessibleOverride_Text(Structure):
    class eAccessibleOverride_TextEnum(IntEnum):
        FontHeight = 0x0

    AccessibleOverride_Text: Annotated[
        c_enum32[eAccessibleOverride_TextEnum],
        Field(c_enum32[eAccessibleOverride_TextEnum], 0x0),
    ]
    FloatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcNGuiActionData(Structure):
    Data: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    LayerID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eActionEnum(IntEnum):
        Click = 0x0
        Hover = 0x1
        ArrowLeft = 0x2
        ArrowRight = 0x3

    Action: Annotated[c_enum32[eActionEnum], Field(c_enum32[eActionEnum], 0x20)]


@partial_struct
class cGcNGuiSpecialTextStyleData(Structure):
    Animation: Annotated[
        cGcNGuiStyleAnimationData, Field(cGcNGuiStyleAnimationData, 0x0)
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x18)]
    StyleProperties: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x28),
    ]


@partial_struct
class cGcNGuiFileBrowserRecents(Structure):
    Recents: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)]


@partial_struct
class cGcShipHUDTargetIconData(Structure):
    Corner: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    GlowCorner: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    GlowLineHorizontal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    GlowLineVertical: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    LineHorizontal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    LineVertical: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]


@partial_struct
class cGcShipHUDTargetData(Structure):
    BaseColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    LockColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    PoliceColour1: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    PoliceColour2: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    ThreatColour: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    IconData: Annotated[cGcShipHUDTargetIconData, Field(cGcShipHUDTargetIconData, 0x50)]
    Arrow: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xB0)]
    ActivateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    ActiveDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    ArrowFadeRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    ArrowMaxSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    ArrowMinFadeDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    ArrowMinSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    ArrowOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    ArrowScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    GlowAlpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    HighlightTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    HitPulse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    HitPulseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    HitWhiteOut: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0)]
    IconMaxSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    IconMinSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    IconSizeIn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    IconSizeScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x100)]
    PoliceColourFreq: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x104)]


@partial_struct
class cGcTextStyleOutline(Structure):
    OutlineColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    OutlineOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]


@partial_struct
class cGcTextStylePlain(Structure):
    pass


@partial_struct
class cGcTextStyleShadow(Structure):
    ShadowColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ShadowOffset: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]


@partial_struct
class cGcNGuiSpecialTextImageData(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Path: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    Size: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    HeightModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ScaleFromFont: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    UseFontColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcAccessibleOverride_Layout(Structure):
    class eAccessibleOverride_LayoutEnum(IntEnum):
        PosX = 0x0
        PosY = 0x1
        LayerWidth = 0x2
        LayerHeight = 0x3
        MaxWidth = 0x4

    AccessibleOverride_Layout: Annotated[
        c_enum32[eAccessibleOverride_LayoutEnum],
        Field(c_enum32[eAccessibleOverride_LayoutEnum], 0x0),
    ]
    FloatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcSpaceMapObjectData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    DistanceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DistanceRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    ScaleMagnitude: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    ScaleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ScaleRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Orient: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    TintModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]


@partial_struct
class cGcHUDComponent(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]

    class eAlignEnum(IntEnum):
        Center = 0x0
        TopLeft = 0x1
        TopRight = 0x2
        BottomLeft = 0x3
        BottomRight = 0x4

    Align: Annotated[c_enum32[eAlignEnum], Field(c_enum32[eAlignEnum], 0x10)]
    Height: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    PosX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    PosY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    Width: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcHUDEffectRewardData(Structure):
    BoxColourEnd: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    BoxColourStart: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    BoxSizeEnd: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    BoxSizeStart: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x28)]
    BoxAnimTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    BoxAnimTimeBetweenBoxes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    BoxRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    BoxThicknessEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    BoxThicknessStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    NumBoxes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    BoxAnimTimeCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x48)
    ]


@partial_struct
class cGcHUDImageData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Data: Annotated[cGcHUDComponent, Field(cGcHUDComponent, 0x10)]
    Image: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x38)]


@partial_struct
class cGcPunctuationDelay(Structure):
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Punctuation: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x4)
    ]


@partial_struct
class cGcHUDLayerData(Structure):
    Data: Annotated[cGcHUDComponent, Field(cGcHUDComponent, 0x0)]
    Children: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x28),
    ]


@partial_struct
class cGcPunctuationDelayData(Structure):
    PunctuationList: Annotated[
        basic.cTkDynamicArray[cGcPunctuationDelay],
        Field(basic.cTkDynamicArray[cGcPunctuationDelay], 0x0),
    ]
    DefaultDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcScannerIcon(Structure):
    Main: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    Small: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x18)]
    Highlight: Annotated[
        c_enum32[enums.cGcScannerIconHighlightTypes],
        Field(c_enum32[enums.cGcScannerIconHighlightTypes], 0x30),
    ]


@partial_struct
class cGcHUDMarkerData(Structure):
    Distance: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Icon: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)]
    IconBehind: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]


@partial_struct
class cGcDiscoveryHelperTimings(Structure):
    DiscoverPlanetMessageTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DiscoverPlanetMessageWait: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    DiscoverPlanetTotalTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcFontData(Structure):
    File: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    MinCharWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCameraAnomalySetupData(Structure):
    CameraAt: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x0)]
    CameraOffset: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x10)]
    CameraUp: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x20)]
    SunDirection: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x30)]


@partial_struct
class cGcCameraFocusBuildingControlSettings(Structure):
    ClampRange: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    MaxStepRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MaxStepRateAccumulatedInput: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MinStepRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    StepSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    Clamp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]
    StepRateCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x1D)
    ]


@partial_struct
class cGcCameraFreeSettings(Structure):
    InitialOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    CollisionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MaxDistanceClampBuffer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    MaxDistanceClampForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    TurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]


@partial_struct
class cGcCameraSpawnSetupData(Structure):
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    HorizontalProportion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    YawProportion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    InFrontOfShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]


@partial_struct
class cGcCameraShakeCapturedData(Structure):
    ShakeFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ShakeStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    VibrateFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    VibrateStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcCameraShakeMechanicalData(Structure):
    ExtraShakeFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    ExtraVibrateFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    ShakeFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    ShakeStrength: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    VibrateFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    VibrateStrength: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x50)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]


@partial_struct
class cGcCameraShakeData(Structure):
    MechanicalData: Annotated[
        cGcCameraShakeMechanicalData, Field(cGcCameraShakeMechanicalData, 0x0)
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    CapturedData: Annotated[
        cGcCameraShakeCapturedData, Field(cGcCameraShakeCapturedData, 0x80)
    ]
    DecayRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    FovFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    FovStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    StrengthScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    ThirdPersonDamp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    TimeStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    TotalTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    VRStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]


@partial_struct
class cGcPresetTextureData(Structure):
    Filename: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)
    ]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x100)]


@partial_struct
class cGcScreenFilterData(Structure):
    LocText: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    FadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HdrAreaAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    SelectableInPhotoMode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]


@partial_struct
class cGcCameraAmbientBuildingData(Structure):
    Animation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DroneAnimation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Offset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AvailableBuildings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    AvailableRaces: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    AvoidTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x69)]
    UseLookAt: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6A)]


@partial_struct
class cGcCameraAmbientSpaceData(Structure):
    Animation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DroneAnimation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eOriginEnum(IntEnum):
        SpaceStationInternals = 0x0
        SpaceStationBack = 0x1
        FreighterBattle = 0x2
        Freighter = 0x3
        FreighterHangar = 0x4
        AtlasStation = 0x5
        BlackHole = 0x6
        Anomaly = 0x7

    Origin: Annotated[c_enum32[eOriginEnum], Field(c_enum32[eOriginEnum], 0x20)]


@partial_struct
class cGcCameraAmbientSpecialData(Structure):
    Animation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DroneAnimation: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]

    class eCameraOriginEnum(IntEnum):
        ExternalBase = 0x0

    CameraOrigin: Annotated[
        c_enum32[eCameraOriginEnum], Field(c_enum32[eCameraOriginEnum], 0x20)
    ]
    AvoidTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    UseLookAt: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]


@partial_struct
class cGcCameraAnimationData(Structure):
    CameraAnimation: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]


@partial_struct
class cGcWorldUISettings(Structure):
    GameModeSelectorQuadOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    GameModeSelectorQuadOffsetV2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HUDDefWorldQuadOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HUDDefWorldQuadOffsetV2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    HUDDefWorldQuadShipAddOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    HUDDefWorldQuadShipAddOffsetV2: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x14)
    ]
    HUDInterpSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    HUDThresholdHorz: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    HUDThresholdVert: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    HUDWorldQuadScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    HUDWorldQuadShipScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    UIWorldQuadOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    UIWorldQuadOffsetBuildMenu: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    UIWorldQuadOffsetBuildMenuV2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    UIWorldQuadOffsetV2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    UIWorldQuadScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    UIWorldQuadShipAddOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    UIWorldQuadShipAddOffsetV2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    UIWorldQuadShipScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    UIWorldQuadSideOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]


@partial_struct
class cGcTerrainOverlayColours(Structure):
    Cutoff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FlightStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    PulsePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PulseStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcCameraAerialViewData(Structure):
    class eAerialViewModeEnum(IntEnum):
        FaceDown = 0x0
        FaceOut = 0x1
        FaceDownThenOut = 0x2
        FaceDownThenFocus = 0x3

    AerialViewMode: Annotated[
        c_enum32[eAerialViewModeEnum], Field(c_enum32[eAerialViewModeEnum], 0x0)
    ]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    FocusTargetOffsetDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    LookTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    PauseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SpeedLineDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    StartTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TargetOffsetAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    TimeBack: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Curve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x28)
    ]
    CurveDown: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x29)
    ]
    IgnoreDistanceRestrictions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    SlerpCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x2B)
    ]


@partial_struct
class cGcCameraFollowSettings(Structure):
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AvoidCollisionLRSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AvoidCollisionPushSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AvoidCollisionUDSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    BackMaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    BackMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    BackSlopeAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    BackSlopeRotationAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    CenterBlendTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    CenterMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    CenterMaxSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    CenterStartSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    CenterStartTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    CustomBlendTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    DistSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    DistSpeedOutsideMainRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    DistStiffness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    HorizRotationAngleMaxPerFrame: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x50)
    ]
    LeftMaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    LeftMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    LookStickLimitAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    LookStickOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    LRProbesRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    LRProbesRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    MinMoveVelToTriggerSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    MinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    NumLRProbes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    NumUDProbes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]
    OffsetX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    OffsetY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    OffsetYAlt: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    OffsetYExtraMaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    OffsetYMinSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    OffsetYSlopeExtra: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    OffsetZFlat: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    PanFar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    PanNear: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    ProbeCenterX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    ProbeCenterY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    PushForwardDropoffLR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    PushForwardDropoffUD: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    SpeedRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    SpringSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    UDProbesRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    UpGamma: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    UpMaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    UpMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    UpSlopeAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    UpWaveAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    UpWaveAdjustMaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    VelocityAnticipate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    VelocityAnticipateSpringSpeed: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xD8)
    ]
    VertMaxSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    VertRotationMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    VertRotationMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    VertRotationOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    VertRotationOffsetMaxAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    VertRotationOffsetMinAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0)]
    VertRotationSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    AvoidCollisionLRUseStickDelay: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF8)]
    AvoidCollisionUDUseStickDelay: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF9)]
    EnableCollisionDetection: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFA)]
    LockToObjectOnIdle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFB)]
    UseCustomBlendTime: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFC)]
    UseMinSpeedYOffset: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFD)]
    UseSpeedBasedSpring: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFE)]
    VertStartLookingDown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFF)]


@partial_struct
class cGcCameraWarpSettings(Structure):
    FocusPointDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    OffsetXFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    OffsetXPhase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    OffsetXRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    OffsetYBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    OffsetYFrequency_1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    OffsetYFrequency_2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    OffsetYPhase_1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    OffsetYPhase_2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    OffsetYRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    OffsetYStartBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    OffsetZBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    OffsetZFrequency_1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    OffsetZFrequency_2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    OffsetZPhase_1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    OffsetZPhase_2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    OffsetZRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    OffsetZStartBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    RollRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    YawnRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    OffsetXCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x50)
    ]


@partial_struct
class cGcColourModifier(Structure):
    ForceColourTo: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    MultiplySaturation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MultiplyValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    OffsetSaturation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    OffsetValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    ForceColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcColourPaletteData(Structure):
    Colours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ColourIndices: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]


@partial_struct
class cGcPaletteData(Structure):
    Colours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]

    class eNumColoursEnum(IntEnum):
        Inactive = 0x0
        _1 = 0x1
        _4 = 0x2
        _8 = 0x3
        _16 = 0x4
        All = 0x5

    NumColours: Annotated[
        c_enum32[eNumColoursEnum], Field(c_enum32[eNumColoursEnum], 0x400)
    ]


@partial_struct
class cGcTerrainGlobals(Structure):
    TerrainBeamLightColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    MiningSubstanceBiome: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    MiningSubstanceRare: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x120),
    ]
    MiningSubstanceStar: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x130),
    ]
    MiningSubstanceStarExtreme: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x140),
    ]
    RegionHotspotsTable: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x150)
    ]
    TerrainEditing: Annotated[cGcTerrainEditing, Field(cGcTerrainEditing, 0x160)]
    HueOverlay: Annotated[
        cGcTerrainOverlayColours, Field(cGcTerrainOverlayColours, 0x1F8)
    ]
    SaturationOverlay: Annotated[
        cGcTerrainOverlayColours, Field(cGcTerrainOverlayColours, 0x210)
    ]
    ValueOverlay: Annotated[
        cGcTerrainOverlayColours, Field(cGcTerrainOverlayColours, 0x228)
    ]
    HeightBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x240)]
    MaxHighWaterLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x244)]
    MaxHighWaterRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x248)]
    MaxWaterRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24C)]
    MinHighWaterLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x250)]
    MinHighWaterRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x254)]
    MinHighWaterRegionRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x258)]
    MinWaterRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x25C)]
    MouseWheelRotatePlaneSensitivity: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x260)
    ]
    NumGeneratorCalls: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x264)]
    NumPolygoniseCalls: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x268)]
    NumPostPolygoniseCalls: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x26C)]
    PurpleSystemMaxHighWaterChance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x270)
    ]
    RegisterTerrainMinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x274)]
    SeaLevelGasGiant: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x278)]
    SeaLevelHigh: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x27C)]
    SeaLevelMoon: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x280)]
    SeaLevelStandard: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x284)]
    SeaLevelWaterWorld: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x288)]
    SmoothStepAbove: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28C)]
    SmoothStepBelow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x290)]
    SmoothStepStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x294)]
    SubtractEditFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x298)]
    SubtractEditLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x29C)]
    SubtractEditOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A0)]
    TerrainBeamDefaultRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A4)]
    TerrainBeamHologramTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A8)]
    TerrainBeamLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2AC)]
    TerrainBeamUndoRangeFromLastAdd: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2B0)
    ]
    TerrainPrimeIndexStart: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2B4)]
    TerrainPurpleSystemIndexStart: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x2B8)
    ]
    TerrainUndoCubesAlpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2BC)]
    TerrainUndoCubesNoiseFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C0)]
    TerrainUndoCubesNoiseThreshold: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2C4)
    ]
    TerrainUndoCubesRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C8)]
    TerrainUndoFadeDepthConstant: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2CC)
    ]
    TerrainUndoFadeDepthScalar: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D0)]
    TextureBlendOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D4)]
    TextureBlendScale0: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D8)]
    TextureBlendScale1: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2DC)]
    TextureBlendScale2: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E0)]
    TextureFadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E4)]
    TextureFadePower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E8)]
    TextureScaleMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2EC)]
    TextureScalePower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F0)]
    TileBlendMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F4)]
    UseMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F8)]
    DebugFlattenAllTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2FC)]
    DebugLockTerrainSettingsIndex: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2FD)]
    DebugNoFlattenForBuildings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2FE)]
    DebugRegionHotspots: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2FF)]
    ForcePurpleSystemHighWater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x300)]


@partial_struct
class cGcSmokeTestOptions(Structure):
    CameraFastHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CameraFastMoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CameraHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    CameraMoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    CameraPitchAngleDeg: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    CameraPitchSpeedRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    CameraRotateSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    GifFrames: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    GifTimeBetweenKeyframes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    InitialPause: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    PlanetFlightTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    PlanetFlightTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    SmokeBotNumWalksBeforeWarp: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    SmokeBotTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    SmokeTestFlashTimeDuration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    GifMode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]


@partial_struct
class cGcSolarGenerationGlobals(Structure):
    PlanetRingsMax: Annotated[cGcPlanetRingData, Field(cGcPlanetRingData, 0x0)]
    PlanetRingsMin: Annotated[cGcPlanetRingData, Field(cGcPlanetRingData, 0x60)]
    SolarSystemSize: Annotated[basic.Vector3f, Field(basic.Vector3f, 0xC0)]
    AsteroidSettings: Annotated[
        basic.cTkDynamicArray[cGcAsteroidSystemGenerationData],
        Field(basic.cTkDynamicArray[cGcAsteroidSystemGenerationData], 0xD0),
    ]
    CommonAsteroidResourceFuel: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xE0)]
    CommonAsteroidResourceMain: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xF0)]
    CommonAsteroidResourceProduct: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x100)
    ]
    CommonAsteroidResourceSecondary: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x110)
    ]
    RareAsteroidDataProduct: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x120)]
    RareAsteroidResource: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x130)]
    RareAsteroidResourceFuel: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x140)]
    SpaceshipSpawnFreqMultipliers: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x150),
    ]
    SpaceshipWeightings: Annotated[
        basic.cTkDynamicArray[cGcAISpaceshipWeightingData],
        Field(basic.cTkDynamicArray[cGcAISpaceshipWeightingData], 0x160),
    ]
    AbandonedSystemProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x170)]
    EmptySystemProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x184)]
    ExtremePlanetChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x198)]
    PirateSystemProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1AC)]
    PerPlanetGenerationAngleChangeDegreesRange: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x1C0)
    ]
    PerPlanetGenerationElevationChangeDegreesRange: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x1C8)
    ]
    RareAsteroidNoiseRangeLotsOfRares: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x1D0)
    ]
    RareAsteroidNoiseRangeSomeRares: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x1D8)
    ]
    SpawnPointStationToPlanetInterpRange: Annotated[
        basic.Vector2f, Field(basic.Vector2f, 0x1E0)
    ]
    AsteroidAnomalyAvoidRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E8)]
    AsteroidLotsOfRaresOdds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1EC)]
    AsteroidNoiseOctaves: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1F0)]
    AsteroidSomeRaresOdds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F4)]
    AsteroidSpaceStationAvoidRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1F8)
    ]
    AsteroidWarpInAreaAvoidRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1FC)
    ]
    AsteroidCreatureRichSystemProbability: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x200)
    ]
    CivilianTraderSpaceshipsCacheCount: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x204)
    ]
    CommonAsteroidMaxResources: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x208)]
    CommonAsteroidMinResources: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20C)]
    CommonAsteroidResourceFuelMultiplier: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x210)
    ]
    CommonAsteroidResourceFuelOdds: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x214)
    ]
    CommonAsteroidResourceProductOdds: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x218)
    ]
    CommonAsteroidResourceSecondaryOdds: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x21C)
    ]
    CorruptSentinelBuildingCheckDifficulty: Annotated[
        c_enum32[enums.cGcCombatTimerDifficultyOption],
        Field(c_enum32[enums.cGcCombatTimerDifficultyOption], 0x220),
    ]
    FuelAsteroidMultiplier: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x224)]
    GenerateForcedNumberPlanets: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x228)]
    LargeAsteroidFadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x22C)]
    LocatorScatterChanceOfCapitalShips: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x230)
    ]
    LocatorScatterChanceOfPirates: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x234)
    ]
    LocatorScatterMaxCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x238)]
    LocatorScatterMaxDistanceFromPlanet: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x23C)
    ]
    LocatorScatterMinCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x240)]
    PercentChanceExtraPrime: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x244)]
    PirateClassShipOverrideProbability: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x248)
    ]
    PirateClassShipOverrideProbabilityPirateSystem: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x24C)
    ]
    PlanetInvalidAsteroidZone: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x250)]
    PlanetRingProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x254)]
    RareAsteroidDataProductOdds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x258)]
    RareAsteroidMaxResources: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x25C)]
    RareAsteroidMinResources: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x260)]
    RareAsteroidResourceFuelOdds: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x264)
    ]
    RareAsteroidSystemOddsBlue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x268)]
    RareAsteroidSystemOddsGreen: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x26C)]
    RareAsteroidSystemOddsPurple: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x270)
    ]
    RareAsteroidSystemOddsRed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x274)]
    RareAsteroidSystemOddsYellow: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x278)
    ]
    SolarSystemMaximumRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x27C)]
    SolarSystemMaximumRadiusMassive: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x280)
    ]
    SparseAsteroidSpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x284)]
    StationSpawnAvoidRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x288)]
    AsteroidScaleVarianceCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x28C)
    ]
    AsteroidsCheckNoise: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28D)]
    AsteroidsEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28E)]
    GenerateMaximumSolarSystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28F)]
    MassiveSolarSystems: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x290)]
    UseSingleRacePerSystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x291)]
    UseCorruptSentinelLUT: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x292)]


@partial_struct
class cGcScratchpadGlobals(Structure):
    IBLMaps: Annotated[
        basic.cTkDynamicArray[cGcPresetTextureData],
        Field(basic.cTkDynamicArray[cGcPresetTextureData], 0x0),
    ]
    OverlayTextures: Annotated[
        basic.cTkDynamicArray[cGcPresetTextureData],
        Field(basic.cTkDynamicArray[cGcPresetTextureData], 0x10),
    ]
    TerrainColours: Annotated[
        basic.cTkDynamicArray[basic.Colour],
        Field(basic.cTkDynamicArray[basic.Colour], 0x20),
    ]
    TerrainTextures: Annotated[
        basic.cTkDynamicArray[cGcPresetTextureData],
        Field(basic.cTkDynamicArray[cGcPresetTextureData], 0x30),
    ]


@partial_struct
class cGcSimulationGlobals(Structure):
    AbandonedSpaceStationFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    AtlasStationAnomalies: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x10),
    ]
    BlackHoleAnomalies: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x20),
    ]
    BlackHoleTunnelFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    HeavyAirAbandonedFreighter: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    HeavyAirCave: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    HeavyAirSpaceStormDefault: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    HeavyAirSpaceStormList: Annotated[
        basic.cTkDynamicArray[cGcSpaceStormData],
        Field(basic.cTkDynamicArray[cGcSpaceStormData], 0x70),
    ]
    HeavyAirUnderwater: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x80)
    ]
    MultitoolPool: Annotated[
        basic.cTkDynamicArray[cGcMultitoolPoolData],
        Field(basic.cTkDynamicArray[cGcMultitoolPoolData], 0x90),
    ]
    NexusExteriorFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xA0)
    ]
    NexusFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xB0)
    ]
    None_: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0xC0)]
    PirateSystemSpaceStationFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xD0)
    ]
    PlaceMarkerFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xE0)
    ]
    PlacementDroneFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xF0)
    ]
    PlanetAtmosphereFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x100)
    ]
    PlanetAtmosphereMaterialFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x110)
    ]
    PlanetGasGiantAtmosphereFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x120)
    ]
    PlanetGasGiantAtmosphereMaterialFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x130)
    ]
    PlanetMaterialFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x140)
    ]
    PlanetRingFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x150)
    ]
    PlanetRingMaterialFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x160)
    ]
    PlanetTerrainMaterials: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x170),
    ]
    PortalStoryTunnelFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x180)
    ]
    PortalTunnelFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x190)
    ]
    PrefetchMaterialResources: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x1A0),
    ]
    PrefetchScenegraphResources: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x1B0),
    ]
    PrefetchTextureResources: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x1C0),
    ]
    SpaceStationFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x1D0)
    ]
    StartingSceneFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x1E0)
    ]
    TeleportTunnelFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x1F0)
    ]
    WarpTunnelFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x200)
    ]
    ProceduralBuildingsGenerationSeed: Annotated[
        ctypes.c_uint64, Field(ctypes.c_uint64, 0x210)
    ]
    GasGiantFadeDistanceEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x218)]
    GasGiantFadeDistanceStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x21C)]
    GasGiantFlowSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x220)]
    GasGiantFlowStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x224)]
    WarpTunnelScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x228)]


@partial_struct
class cGcRichPresenceGlobals(Structure):
    EvaluationPeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    GameModePriority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    IdleThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PlanetLocationPriority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    PublishPeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SpaceCombatPriority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    SpaceLocationPriority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    StormLocationPriority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    ShowOnScreen: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcSceneOptions(Structure):
    AtmosphereFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    BiomeFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    CaveBiomeFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    ForceResource: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x30),
    ]
    TerrainFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    WaterBiomeFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    ForceResourceSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    RecentToolboxIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x64)]
    SelectedToolboxIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    OverrideAtmosphere: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6C)]
    OverrideBiome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6D)]
    OverrideCaveBiome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6E)]
    OverrideTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6F)]
    OverrideWaterBiome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x70)]


@partial_struct
class cGcPlacementGlobals(Structure):
    LodDistancesDetail: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    LodDistancesDistant: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    LodDistancesLandmark: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    LodDistancesObject: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    AddToLodDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    HighInterpValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    InterpValueVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    LowInterpValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    MaxDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    MaxFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    MaxPatchSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    MaxPatchVariance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x6C)]
    MidInterpValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    MinDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    MinFrequency: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    MinPatchSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    MinPatchVariance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    MultiplyLodDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]


@partial_struct
class cGcMultiplayerGlobals(Structure):
    EpicMissionIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    EpicMissionIconNotSelected: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x18)
    ]
    EpicMissionIconSelected: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x30)
    ]
    EpicMissionRewardOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]
    EpicMissionSecondReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x58)]
    NexusMissionStandardReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x68)]
    QuicksilverMissionSecondReward: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x78)
    ]
    StandardMissionSecondReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x88)]
    WeekendMissionSecondReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x98)]
    AbandonedEntityWaitPeriod: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA8)]
    FullSimHandUpdateDistance: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xB0)]
    FullSimHandUpdateInterval: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xB8)]
    BaseHeaderBroadcastInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    BlobHeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    ChanceMissionEpic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    CharacterDirectionLerpModifier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xCC)
    ]
    ConstantScoreDepletionRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    DisconnectionDisplayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    DistanceBetweenTeleportMovementEffects: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xD8)
    ]
    EditMessageInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    EditMessageReceivedSyncBackOffTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xE0)
    ]
    EditMessageSentSyncBackOffTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xE4)
    ]
    EntityUpdateMaxRateDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    EntityUpdateMinRateDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    FactorScoreDepletionRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0)]
    FullSimHandUpdateDisabledDistance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF4)
    ]
    FullSimUpdateInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    HashCheckMessageInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    HashCheckMessageOverdueDistanceDivisor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x100)
    ]
    HashMessageSentCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x104)]
    HashReceivedCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x108)]
    HostBiasScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10C)]
    HostOnConnectedTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x110)]
    InviteInteractionTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x114)]
    JoinInteractionTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x118)]
    MaxDownloadableBases: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x11C)]
    MaxSyncResponsesPerHash: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x120)]
    MessageQueueSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x124)]
    MessageQueueSizeDropUnreliable: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x128)
    ]
    MinScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x12C)]
    MissionRecurrenceTime: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x130)]
    MissionWaitOnceAllPlayersReadyTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x134)
    ]
    NewBlockMessageInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x138)]
    NewBlockMessageOverdueDistanceDivisor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x13C)
    ]
    NewBlockMessageSentCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x140)]
    NewerHashReceivedCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x144)]
    NPCInteractionTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x148)]
    NPCReplicateEndDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14C)]
    NPCReplicateStartDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x150)]
    PlaceholderBroadcastInterval: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x154)
    ]
    PlanetLocalEnitityInterestEnd: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x158)
    ]
    PlanetLocalEnitityInterestStart: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x15C)
    ]
    PlayerInteractCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x160)]
    PlayerMarkerDisplayDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x164)]
    PlayerMarkerLargeIconCloseSize: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x168)
    ]
    PlayerMarkerLargeIconDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x16C)]
    PlayerMarkerLargeIconFarSize: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x170)
    ]
    PlayerMarkerMinShowDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x174)]
    PlayerMarkerScreenOffsetY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x178)]
    PlayerMarkerSmallIconSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x17C)]
    RemoveDuplicateChatMessageTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x180)
    ]
    ShipDirectionLerpModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x184)]
    ShipLandShakeMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x188)]
    ShipSyncConvervengeMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18C)
    ]
    StatSyncRadiusPlanet: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x190)]
    StatSyncRadiusSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x194)]
    SyncMessageInterval: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x198)]
    TransactionTimeout: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x19C)]
    UpdateSlerpModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A0)]
    UsefulSyncResponseCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1A4)]
    UsefulSyncResponseScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A8)]
    UselessSyncResponseCooldown: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1AC)]
    UselessSyncResponseScore: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B0)]
    VehicleStickLerpModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B4)]
    VehicleThrottleLerpModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B8)]
    PlayerMarkerCenteredName: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BC)]
    VoiceChatEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1BD)]


@partial_struct
class cGcGraphicsGlobals(Structure):
    ImGui: Annotated[cTkImGuiSettings, Field(cTkImGuiSettings, 0x0)]
    ShellsSettings: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x190)]
    TessSettings: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x1D0)]
    LightShaftProperties: Annotated[
        cGcLightShaftProperties, Field(cGcLightShaftProperties, 0x210)
    ]
    StormLightShaftProperties: Annotated[
        cGcLightShaftProperties, Field(cGcLightShaftProperties, 0x240)
    ]
    LensParams: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x270)]
    MipLevelDebug: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x280)]
    ScanColour: Annotated[basic.Colour, Field(basic.Colour, 0x290)]
    ShadowBias: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2A0)]
    ShadowSplit: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2B0)]
    ShadowSplitCameraView: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2C0)]
    ShadowSplitShip: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2D0)]
    ShadowSplitSpace: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2E0)]
    ShadowSplitStation: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x2F0)]
    TaaSettings: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x300)]
    TerrainMipDistanceHigh: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x310)]
    TerrainMipDistanceLow: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x320)]
    TerrainMipDistanceMed: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x330)]
    TerrainMipDistanceUlt: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x340)]
    UIColour: Annotated[basic.Colour, Field(basic.Colour, 0x350)]
    UIShipColour: Annotated[basic.Colour, Field(basic.Colour, 0x360)]
    VerticalColourBottom: Annotated[basic.Colour, Field(basic.Colour, 0x370)]
    VerticalColourTop: Annotated[basic.Colour, Field(basic.Colour, 0x380)]
    VerticalGradient: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x390)]
    CascadeRenderSequence: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x3A0),
    ]
    GraphicsDetailPresetsPC: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x3B0)
    ]
    GraphicsDetailPresetiOS: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x540)
    ]
    GraphicsDetailPresetMacOS: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x5A4)
    ]
    GraphicsDetailPresetNX64Handheld: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x608)
    ]
    GraphicsDetailPresetOberon: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x66C)
    ]
    GraphicsDetailPresetPS4: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x6D0)
    ]
    GraphicsDetailPresetPS4Pro: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x734)
    ]
    GraphicsDetailPresetPS4ProVR: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x798)
    ]
    GraphicsDetailPresetPS4VR: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x7FC)
    ]
    GraphicsDetailPresetPS5: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x860)
    ]
    GraphicsDetailPresetPS5VR: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x8C4)
    ]
    GraphicsDetailPresetSwitch2Handheld: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x928)
    ]
    GraphicsDetailPresetTrinity: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x98C)
    ]
    GraphicsDetailPresetTrinityVR: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x9F0)
    ]
    GraphicsDetailPresetXB1: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0xA54)
    ]
    GraphicsDetailPresetXB1X: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0xAB8)
    ]
    VariableUpdatePeriodModifers: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB1C)
    ]
    WindDir1: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xB2C)]
    WindDir2: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xB34)]
    AlphaCutoutMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB3C)]
    AlphaCutoutMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB40)]
    AtmosphereSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB44)]
    Brightness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB48)]
    Contrast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4C)]
    DirectionLightFOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB50)]
    DirectionLightRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB54)]
    DirectionLightShadowBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB58)]
    DOFAmountManual: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB5C)]
    DOFAmountManualFull: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB60)]
    DOFAmountManualFullIndoor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB64)]
    DOFAmountManualLight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB68)]
    DOFAmountManualLightIndoor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB6C)]
    DOFAutoFarAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB70)]
    DOFAutoFarFarPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB74)]
    DOFAutoFarFarPlaneFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB78)]
    DOFAutoFarNearPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB7C)]
    DOFFarFadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB80)]
    DOFFarFadeDistanceCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB84)]
    DOFFarFadeDistanceInteraction: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB88)
    ]
    DOFFarFadeDistanceManual: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8C)]
    DOFFarFadeDistanceManualIndoor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB90)
    ]
    DOFFarFadeDistanceSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB94)]
    DOFFarFadeDistanceWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB98)]
    DOFFarPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB9C)]
    DOFFarPlaneCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBA0)]
    DOFFarPlaneInteraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBA4)]
    DOFFarPlaneManual: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBA8)]
    DOFFarPlaneSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBAC)]
    DOFFarPlaneWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBB0)]
    DOFFarStrengthWater: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBB4)]
    DOFNearAdjustInteraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBB8)]
    DOFNearFadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBBC)]
    DOFNearFadeDistanceManual: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC0)]
    DOFNearMinInteraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC4)]
    DOFNearPlane: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC8)]
    FarClipDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBCC)]
    FoliageSaturationMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBD0)]
    FoliageSaturationMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBD4)]
    FoliageValueMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBD8)]
    FoliageValueMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBDC)]
    FrustumJitterAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBE0)]
    FrustumJitterAmountDLSS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBE4)]
    GrassSaturationMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBE8)]
    GrassSaturationMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBEC)]
    GrassValueMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBF0)]
    GrassValueMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBF4)]
    HBAOBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBF8)]
    HBAOIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBFC)]
    HBAORadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC00)]
    HDRExposure: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC04)]
    HDRExposureCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC08)]
    HDRGamma: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0C)]
    HDRLutExposure: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC10)]
    HDRLutGamma: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC14)]
    HDRLutToe: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC18)]
    HDROffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC1C)]
    HDROffsetCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC20)]
    HDRThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC24)]
    HDRThresholdCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC28)]
    HUDDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC2C)]
    HUDMotionPos: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC30)]
    HUDMotionPosSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC34)]
    HUDMotionX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC38)]
    HUDMotionXSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC3C)]
    HUDMotionY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC40)]
    HUDMotionYSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC44)]
    HueVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC48)]
    LensDirt: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4C)]
    LensDirtCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC50)]
    LensOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC54)]
    LensOffsetCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC58)]
    LensScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC5C)]
    LensScaleCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC60)]
    LensThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC64)]
    LensThresholdCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC68)]
    LowHealthDesaturationIntensityMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC6C)
    ]
    LowHealthDesaturationIntensityMin: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC70)
    ]
    LowHealthDesaturationIntensityTimeSinceHit: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC74)
    ]
    LowHealthFadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC78)]
    LowHealthFadeOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC7C)]
    LowHealthOverlayIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC80)]
    LowHealthPulseRateFullShield: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC84)
    ]
    LowHealthPulseRateLowShield: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC88)]
    LowHealthStrengthFullShield: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8C)]
    LowHealthStrengthLowShield: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC90)]
    LowHealthVignetteEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC94)]
    LowHealthVignetteStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC98)]
    LUTDistanceFlightMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC9C)]
    MaxParticleRenderRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCA0)]
    MaxParticleRenderRangeSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCA4)]
    MaxSpaceFogStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCA8)]
    MinPixelSizeOfObjectsInShadowsCockpitOnPlanet: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xCAC)
    ]
    MinPixelSizeOfObjectsInShadowsPlanet: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xCB0)
    ]
    MinPixelSizeOfObjectsInShadowsSpace: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xCB4)
    ]
    ModelRendererLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCB8)]
    MotionBlurShutterAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCBC)]
    MotionBlurShutterSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC0)]
    MotionBlurThresholdDefault: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC4)]
    MotionBlurThresholdInVehicle: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xCC8)
    ]
    MotionBlurThresholdOnFoot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCCC)]
    MotionBlurThresholdSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCD0)]
    NearClipDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCD4)]
    New_BounceLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCD8)]
    New_BounceLightPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCDC)]
    New_BounceLightWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCE0)]
    New_SideRimColourMixer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCE4)]
    New_SideRimWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCE8)]
    New_SkyLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCEC)]
    New_SkyLightPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCF0)]
    New_SkyLightWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCF4)]
    New_TopRimColourMixer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCF8)]
    New_TopRimIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCFC)]
    New_TopRimPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD00)]
    New_TopRimWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD04)]
    NoFocusMaxFPS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD08)]
    Old_BounceLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0C)]
    Old_BounceLightPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD10)]
    Old_BounceLightWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD14)]
    Old_SideRimColourMixer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD18)]
    Old_SideRimWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD1C)]
    Old_SkyLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD20)]
    Old_SkyLightPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD24)]
    Old_SkyLightWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD28)]
    Old_TopRimColourMixer: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD2C)]
    Old_TopRimIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD30)]
    Old_TopRimPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD34)]
    Old_TopRimWarp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD38)]
    PetModelRendererLightIntensity: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xD3C)
    ]
    PhotoModeBloomGainMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD40)]
    PhotoModeBloomGainMedium: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD44)]
    PhotoModeBloomGainMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD48)]
    PhotoModeBloomThresholdMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4C)]
    PhotoModeBloomThresholdMedium: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xD50)
    ]
    PhotoModeBloomThresholdMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD54)]
    PhotoModeDefaultBloomValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD58)]
    PhotoModeMediumValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD5C)]
    QuantizeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD60)]
    QuantizeTimeCameraView: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD64)]
    QuantizeTimeShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD68)]
    QuantizeTimeSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD6C)]
    Redo_BounceIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD70)]
    Redo_LightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD74)]
    Redo_SkyIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD78)]
    ReflectionStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD7C)]
    RingAvoidanceSphereInterpTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xD80)
    ]
    RingRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD84)]
    RingSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD88)]
    Saturation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8C)]
    SaturationVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD90)]
    ScanAlpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD94)]
    ScanBandWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD98)]
    ScanClamp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD9C)]
    ScanDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDA0)]
    ScanEffectSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDA4)]
    ScanFadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDA8)]
    ScanFadeOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDAC)]
    ScanFresnel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDB0)]
    ScanHeightScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDB4)]
    ScanHorizontalScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDB8)]
    ScanObjectFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDBC)]
    ShadowBillboardOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC0)]
    ShadowLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC4)]
    ShadowLengthCameraView: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC8)]
    ShadowLengthFreighter: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDCC)]
    ShadowLengthFreighterAbandoned: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xDD0)
    ]
    ShadowLengthShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDD4)]
    ShadowLengthSpace: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDD8)]
    ShadowLengthStation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDDC)]
    ShadowMapSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xDE0)]
    SharpenFilterAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDE4)]
    SharpenFilterDepthFactorEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDE8)]
    SharpenFilterDepthFactorStart: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xDEC)
    ]
    ShieldDownScanlineTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDF0)]
    Single1ScanBandWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDF4)]
    Single1ScanEffectSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDF8)]
    Single1ScanHeightScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDFC)]
    Single1ScanHorizontalScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE00)]
    Single1ScanObjectFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE04)]
    Single1ScanTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE08)]
    Single2ScanBandWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0C)]
    Single2ScanEffectSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE10)]
    Single2ScanHeightScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE14)]
    Single2ScanHorizontalScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE18)]
    Single2ScanObjectFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE1C)]
    Single2ScanTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE20)]
    SkySaturationMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE24)]
    SkySaturationMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE28)]
    SkyValueMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE2C)]
    SkyValueMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE30)]
    SpaceIBLBlendDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE34)]
    SpaceIBLBlendStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE38)]
    SpaceMieFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE3C)]
    SpaceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE40)]
    SpaceSunFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE44)]
    SunLightBlendTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE48)]
    SunLightIntensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4C)]
    SunRayDecay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE50)]
    SunRayDensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE54)]
    SunRayExposure: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE58)]
    SunRayWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE5C)]
    SupersamplingLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE60)]
    TaaAccumDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE64)]
    TaaHighFreqConstant: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE68)]
    TaaLowFreqConstant: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE6C)]
    TargetTextureMemUsageMB: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE70)]
    TeleportFlashTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE74)]
    TerrainAnisoHi: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE78)]
    TerrainAnisoLow: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE7C)]
    TerrainAnisoMed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE80)]
    TerrainAnisoUlt: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE84)]
    TerrainBlocksPerFrameHi: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE88)]
    TerrainBlocksPerFrameLow: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE8C)]
    TerrainBlocksPerFrameMed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE90)]
    TerrainBlocksPerFrameOberon: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE94)]
    TerrainBlocksPerFramePs430: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE98)]
    TerrainBlocksPerFramePs460: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xE9C)]
    TerrainBlocksPerFrameUlt: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xEA0)]
    TerrainBlocksPerFrameXb130: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xEA4)]
    TerrainBlocksPerFrameXb160: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xEA8)]
    TerrainDroppedMipsLow: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xEAC)]
    TerrainDroppedMipsMed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xEB0)]
    TerrainMipBiasLow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEB4)]
    TerrainMipBiasMed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEB8)]
    ToneMapExposure: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEBC)]
    ToneMapExposureCave: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC0)]
    ValueVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC4)]
    VignetteEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC8)]
    VignetteEndMoveVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xECC)]
    VignetteEndMoveVRShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xED0)]
    VignetteEndRidingVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xED4)]
    VignetteEndTurnRidingVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xED8)]
    VignetteEndTurnVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEDC)]
    VignetteEndTurnVRShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEE0)]
    VignetteStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEE4)]
    VignetteStartMoveVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEE8)]
    VignetteStartMoveVRShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEEC)]
    VignetteStartRidingVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEF0)]
    VignetteStartTurnRidingVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEF4)]
    VignetteStartTurnVR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEF8)]
    VignetteStartTurnVRShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEFC)]
    VignetteVRMoveInterpTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF00)]
    VignetteVRMoveInterpTimeShip: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF04)
    ]
    VignetteVRRidingInterpTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF08)]
    VignetteVRTurnInterpTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0C)]
    VignetteVRTurnInterpTimeShip: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF10)
    ]
    VignetteVRTurnRidingInterpTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF14)
    ]
    WarpK: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF18)]
    WarpKCube: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF1C)]
    WarpKDispersion: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF20)]
    WarpScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF24)]
    WaterHueShift: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF28)]
    WaterSaturation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF2C)]
    WaterValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF30)]
    WonderModelRendererLightIntensity: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xF34)
    ]
    AllowPartialCascadeRender: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF38)]
    ApplyTaaTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF39)]
    CenterRenderSpaceOffset: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3A)]
    DebugLinesDepthTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3B)]
    DOFEnablePhysCamera: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3C)]
    EnableCrossPipeSharing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3D)]
    EnableSSR: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3E)]
    EnableTerrainCachePs4Base: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF3F)]
    EnableTerrainCachePs4Pro: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF40)]
    EnableTerrainCachePs5: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF41)]
    EnableTerrainCacheXb1Base: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF42)]
    EnableTerrainCacheXb1X: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF43)]
    EnableTerrainCacheXboxSeriesS: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF44)]
    EnableTerrainCacheXboxSeriesX: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF45)]
    EnableTextureStreaming: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF46)]
    EnableVariableUpdate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF47)]
    ForceCachedTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF48)]
    ForceEvictAllTextures: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF49)]
    ForceStreamAllTextures: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4A)]
    ForceUncachedTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4B)]
    FullscreenScanEffect: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4C)]
    IBLReflections: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4D)]
    Redo_On: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4E)]
    ShadowQuantized: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF4F)]
    ShowReflectionProbes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF50)]
    ShowTaaBuf: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF51)]
    ShowTaaCVarianceBuf: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF52)]
    ShowTaaNVarianceBuf: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF53)]
    ShowTaaVarianceBuf: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF54)]
    TonemapInLuminance: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF55)]
    UseImposters: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF56)]
    UseTaaResolve: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF57)]


@partial_struct
class cGcFishingGlobals(Structure):
    CastLaunchOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    LineColourBite: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    LineColourChase: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    LineColourDefault: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    LineColourFail: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    LineColourLand: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    LineColourNibble: Annotated[basic.Colour, Field(basic.Colour, 0x60)]
    RodFirstPersonOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x70)]
    RodFirstPersonOffsetReelIn: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x80)]
    VRRodOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x90)]
    VRRodRotation: Annotated[basic.Vector3f, Field(basic.Vector3f, 0xA0)]
    BaitFlickBobCurve: Annotated[
        cGcCompositeCurveData, Field(cGcCompositeCurveData, 0xB0)
    ]
    BaitFlickLineCurve: Annotated[
        cGcCompositeCurveData, Field(cGcCompositeCurveData, 0xC8)
    ]
    SizeWeightsBiomeOverrides: Annotated[
        basic.cTkDynamicArray[cGcFishSizeProbabilityBiomeOverride],
        Field(basic.cTkDynamicArray[cGcFishSizeProbabilityBiomeOverride], 0xE0),
    ]
    SizeWeights: Annotated[cGcFishSizeProbability, Field(cGcFishSizeProbability, 0xF0)]
    FishMass: Annotated[cGcGaussianCurveData, Field(cGcGaussianCurveData, 0x130)]
    BaitRarityBoostTotalScoreQualityScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x150)
    ]
    MaxSeaHarvesterCaughtFish: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x164)]
    QualityWeights: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x178)]
    BaitSizeBoostTotalScoreQualityScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18C)
    ]
    ChaseTimes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x19C)]
    MysteryFishScales: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1AC)]
    BaitCookingValueMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1BC)]
    BaitFlickBobHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C0)]
    BaitFlickBobHeightLean: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C4)]
    BaitFlickBobTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C8)]
    BaitFlickBobTimeLean: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1CC)]
    BaitFlickBobTimeOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D0)]
    BaitFlickEffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D4)]
    BaitRandScoreCookingValueFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1D8)
    ]
    BaitRarityBoostTotalScoreMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1DC)
    ]
    BaitRarityBoostTotalScoreMin: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1E0)
    ]
    BaitSizeBoostTotalScoreMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E4)]
    BaitSizeBoostTotalScoreMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1E8)]
    BaitWeatherBoostScoreThresholdForNotes: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1EC)
    ]
    CastGravity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F0)]
    CastLaunchAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F4)]
    CastLaunchDelayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F8)]
    CastVelocityBlendFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1FC)]
    DebugSceneCastDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x200)]
    DebugSceneFlicktimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x204)]
    DebugSceneFlicktimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x208)]
    FirstPersonMaxTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20C)]
    FirstPersonPitchMaxSpeedScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x210)
    ]
    FirstPersonPitchMaxSpeedYawAngle: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x214)
    ]
    FirstPersonPitchMinSpeedScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x218)
    ]
    FirstPersonPitchMinSpeedYawAngle: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x21C)
    ]
    FirstPersonPullBackAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x220)]
    FirstPersonPullBackSpeedScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x224)
    ]
    FirstPersonTurnSpeedBaseScaling: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x228)
    ]
    FishCatchAfterBiteTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x22C)]
    FishingRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x230)]
    FishingRangeVRMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x234)]
    FishMouthOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x238)]
    FishNibbleOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x23C)]
    FishWaterDisplacementSmoothTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x240)
    ]
    FloatTiltAmount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x244)]
    FloatTiltIntoTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x248)]
    FloatTiltOutOfTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24C)]
    FloatTiltThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x250)]
    LandTimeBegin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x254)]
    LandTimeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x258)]
    LeanCausesBobThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x25C)]
    LineAttachmentOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x260)]
    LineBiteSag: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x264)]
    LineBrightness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x268)]
    LineColourChangeRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x26C)]
    LineColourChangeRateBite: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x270)]
    LineColourChangeRateNibble: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x274)]
    LineFlickSag: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x278)]
    LineNibbleSag: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x27C)]
    LineWaitSag: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x280)]
    LineWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x284)]
    MaxWaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x288)]
    MinVelocityToCast: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28C)]
    MinWaitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x290)]
    ReelHoldTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x294)]
    RequiredBackCastAngleDegrees: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x298)
    ]
    RequiredCastAngleDegrees: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x29C)]
    SeaHarvesterAverageCatchTimeSeconds: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2A0)
    ]
    StormThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A4)]
    ThirdPersonLeanMaxAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A8)]
    ThirdPersonLeanMidpointAngle: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2AC)
    ]
    ThirdPersonLeanTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B0)]
    VRCastStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B4)]
    WaveStrengthBite: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B8)]
    WaveStrengthBob: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2BC)]
    WaveStrengthLand: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C0)]
    EnableFirstPersonPitchSpeedScaling: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x2C4)
    ]
    EnableFirstPersonYawPullback: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C5)]
    EnableFirstPersonYawTurnSpeedScaling: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x2C6)
    ]
    FirstPersonPitchSpeedCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x2C7)
    ]
    FirstPersonPullBackSpeedCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x2C8)
    ]
    FirstPersonTurnSpeedCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x2C9)
    ]
    LineSagCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x2CA)
    ]
    LineUsesLineRenderer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2CB)]


@partial_struct
class cGcEnvironmentGlobals(Structure):
    CloudProperties: Annotated[cGcCloudProperties, Field(cGcCloudProperties, 0x0)]
    IndoorAmbientColour: Annotated[basic.Colour, Field(basic.Colour, 0xE0)]
    IndoorsLightingFactorFreighterAbandoned: Annotated[
        basic.Colour, Field(basic.Colour, 0xF0)
    ]
    IndoorsLightingFactorPlanet: Annotated[basic.Colour, Field(basic.Colour, 0x100)]
    IndoorsLightingFactorSpaceStation: Annotated[
        basic.Colour, Field(basic.Colour, 0x110)
    ]
    IndoorsLightingFactorSpaceStationAbandoned: Annotated[
        basic.Colour, Field(basic.Colour, 0x120)
    ]
    IndoorsLightingFactorSpaceStationPirate: Annotated[
        basic.Colour, Field(basic.Colour, 0x130)
    ]
    FarBlendHeight: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x140),
    ]
    ShearWindSettings: Annotated[
        basic.cTkDynamicArray[cTkShearWindData],
        Field(basic.cTkDynamicArray[cTkShearWindData], 0x150),
    ]
    SkyAtmosphereBlendLength: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x160),
    ]
    SkyBlendLength: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x170),
    ]
    SpacePlanetFogStrength: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x180),
    ]
    LODSettings: Annotated[cTkLODSettingsData, Field(cTkLODSettingsData, 0x190)]
    EnvironmentGasGiantProperties: Annotated[
        cGcEnvironmentProperties, Field(cGcEnvironmentProperties, 0x3E0)
    ]
    EnvironmentPrimeProperties: Annotated[
        cGcEnvironmentProperties, Field(cGcEnvironmentProperties, 0x45C)
    ]
    EnvironmentProperties: Annotated[
        cGcEnvironmentProperties, Field(cGcEnvironmentProperties, 0x4D8)
    ]
    DynamicTreeWindFrequency: Annotated[
        cTkDynamicTreeWindFrequency, Field(cTkDynamicTreeWindFrequency, 0x554)
    ]
    ExposureHeightBracket: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x574)]
    SpaceBuildingTemperature: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x57C)]
    AbandonedFreighterMaxTemperature: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x584)
    ]
    AbandonedFreighterMinTemperature: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x588)
    ]
    AsteroidFadeHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58C)]
    AsteroidFadeHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x590)]
    AsteroidFieldStableEnterTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x594)
    ]
    AsteroidFieldStableLeaveTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x598)
    ]
    AsteroidMaxRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x59C)]
    AsteroidMinRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5A0)]
    AsteroidScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5A4)]
    AtmosphereSpaceRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5A8)]
    CameraLocationStableTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5AC)]
    CreatureFadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5B0)]
    DailyTempChangePercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5B4)]
    DeepWaterDepthTransitionMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5B8)]
    DeepWaterDepthTransitionMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5BC)]
    DeepWaterOxygenMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C0)]
    DistortionStep: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C4)]
    DoFHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C8)]
    DoFHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5CC)]
    DuplicateColourThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5D0)]
    ExposureGroundFactorAddMul: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5D4)]
    ExposureSurfaceContrib: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5D8)]
    ExposureSurfaceDistMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5DC)]
    FarBlendLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5E0)]
    FloraFadeTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5E4)]
    FloraFadeTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5E8)]
    GrassNormalMap: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5EC)]
    GrassNormalOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5F0)]
    GrassNormalSpherify: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5F4)]
    GrassNormalUpright: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5F8)]
    HDeform: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5FC)]
    HeavyAirFadeDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x600)]
    HeavyAirFadeInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x604)]
    HeavyAirFadeOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x608)]
    HeightFogHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60C)]
    HotspotsLOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x610)]
    IblUndergroundFadeSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x614)]
    IblUndergroundLightDirectionHorizonBias: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x618)
    ]
    IblUndergroundLightIntensity: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x61C)
    ]
    IndoorColourBlendTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x620)]
    IndoorsLightingAbandonedFreighterMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x624)
    ]
    IndoorsLightingFreighterMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x628)]
    IndoorsLightingNexusMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x62C)]
    IndoorsLightingPlanetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x630)]
    IndoorsLightingSpaceStationAbandonedMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x634)
    ]
    IndoorsLightingSpaceStationMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x638)
    ]
    IndoorsLightingSpaceStationPirateMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x63C)
    ]
    IndoorsLightingThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x640)]
    IndoorsLightingTransitionTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x644)
    ]
    IndoorsLightingWeightAround: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x648)]
    IndoorsLightingWeightGround: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64C)]
    IndoorsLightingWeightOverhead: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x650)
    ]
    IndoorsLightingWeightTowardsSun: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x654)
    ]
    InteractionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x658)]
    InterestStableTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x65C)]
    LightColourBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x660)]
    LightColourHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x664)]
    LightDirectionBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x668)]
    LightDirectionHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x66C)]
    LocationStableTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x670)]
    MaxElevation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x674)]
    MaxHotspotFalloffDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x678)]
    MaxHotspotOffsetDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x67C)]
    MaxMurkVarianceOverTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x680)]
    MaxPlacementBlendValuePatch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x684)]
    MinHotspotFalloffDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x688)]
    MinPlacementBlendValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68C)]
    MinPlacementBlendValuePatch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x690)]
    MinPlacementObjectScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x694)]
    MinWaterReflections: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x698)]
    ObjectSpawnDetailRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x69C)]
    ObjectSpawnFirstDotCheck: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6A0)]
    ObjectSpawnFirstRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6A4)]
    PlanetEffectEndDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6A8)]
    PlanetFlipDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6AC)]
    PlanetUnwrapMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6B0)]
    PlanetUnwrapMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6B4)]
    ProbeBlendRadiusEdge: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6B8)]
    RegionHotspotProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6BC)]
    SDeform: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C0)]
    SenseProbingValueSmoothingTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6C4)
    ]
    SenseProbingValueSmoothingTimeMed: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6C8)
    ]
    SenseProbingValueSmoothingTimeSlow: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6CC)
    ]
    ShipRadiation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6D0)]
    ShipSpookLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6D4)]
    ShipTemperature: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6D8)]
    ShipToxicity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6DC)]
    SkyAtmospherePower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6E0)]
    SmallAsteroidScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6E4)]
    SpaceRadiation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6E8)]
    SpaceSpookLevel: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6EC)]
    SpaceStationStateBoundingBoxScaler: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6F0)
    ]
    SpaceTemperature: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6F4)]
    SpaceToxicity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6F8)]
    SpawnLowerAtmosphereRadiusMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6FC)
    ]
    SphereLodTextureScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x700)]
    StandardNearProbeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x704)]
    SunClampHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x708)]
    SunClampHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70C)]
    SunFactorMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x710)]

    class eSwitchTypeEnum(IntEnum):
        None_ = 0x0
        Debug = 0x1
        Enabled = 0x2

    SwitchType: Annotated[
        c_enum32[eSwitchTypeEnum], Field(c_enum32[eSwitchTypeEnum], 0x714)
    ]
    TemperatureSmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x718)]
    TerrainFadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x71C)]
    TerrainFadeTimeInShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x720)]
    TerrainFlattenMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x724)]
    TerrainFlattenMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x728)]
    UndergroundFakeSkyFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x72C)]
    UndergroundNearProbeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x730)]
    VDeform: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x734)]
    WaterAlphaHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x738)]
    WaterAlphaHeightMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x73C)]
    WaterChangeTime: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x740)]
    WaterConditionTransitionTime: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x744)
    ]
    WaterFogHeightMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x748)]
    WaterMurkMaxPlayerDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74C)]
    WaterMurkMinPlayerDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x750)]
    WaterMurkVariancePeriod: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x754)]
    EnableWind: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x758)]
    ForceAddCaveProps: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x759)]
    ForceAddUnderwaterProps: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75A)]
    MatchPlantPalettes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75B)]


@partial_struct
class cGcDebugEditorGlobals(Structure):
    AtAxisColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    CentreHandleColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    RightAxisColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    SelectedAxisTint: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    TransformingAxisTint: Annotated[basic.Colour, Field(basic.Colour, 0x40)]
    UpAxisColour: Annotated[basic.Colour, Field(basic.Colour, 0x50)]
    AxisLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AxisThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    CameraDollySpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    CameraPanSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    CameraRotateSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    CentrePickingSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    FramingMinOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    FramingOffsetFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    LinePickingSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    MaxCameraPivotOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    MinCameraPivotOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    PlaneHandleOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    PlaneHandleSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    ScaleHandleSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    SelectedAxisTintStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    TransformArrowLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    TransformArrowRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    TransformingAxisTintStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    TransformRotationSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]


@partial_struct
class cGcCharacterGlobals(Structure):
    CharacterFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    CharacterSeedOverride: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]
    LadderClimbDown: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    LadderClimbIdle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    LadderClimbUp: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    LadderDismountBottom: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    LadderDismountTop: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    LadderMountBottom: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    LadderMountTop: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    NPCStaffPropTag: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    WaterEffectBodyID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    WaterEffectLeftHandID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    WaterEffectRightHandID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    AimPitchAnimScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    AimPitchInterpSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    AimYawAnimScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    BankingMaxStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    BankingMinimumSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    BankingSpeedForMaxStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    BlendToNewFeetSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    CharacterJetpackTurnAimSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    CharacterJetpackTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0)]
    CharacterRotationOffsetY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    CharacterRoughHeadHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    CharacterRunTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    CharacterSwimmingTurnAimSpeed: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x100)
    ]
    CharacterSwimmingTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x104)]
    CharacterTurnAimSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x108)]
    CharacterTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10C)]
    DontShowCharacterWithinCameraDistance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x110)
    ]
    FeetShiftOnTurnMaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x114)]
    FeetShiftOnTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x118)]
    FootPlantedTolerance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x11C)]
    FootPlantSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x120)]
    GunRotationSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x124)]
    HoldWeaponAsPropXRotationDegrees: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x128)
    ]
    IkBlendStrengthSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x12C)]
    IKLegStretchStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x130)]
    JetpackSwimmingPitchRotation: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x134)
    ]
    LadderCooldownAfterBeforeAutoClimb: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x138)
    ]
    LadderDistanceToAutoMount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x13C)]
    MaxAnkleRotationAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]
    MaxSwimmingPitchRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x144)]
    MaxSwimmingRollRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x148)]
    MinimumIdleToJogAnimSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14C)]
    MinStickForIntoJogAnim: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x150)]
    MinSwimmingPitchRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x154)]
    MinSwimmingRollRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x158)]
    MinTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x15C)]
    NPCActiveListenChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x160)]
    NPCAnimSpeedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x164)]
    NPCAnimSpeedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x168)]
    NPCArriveDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x16C)]
    NPCBehaviourTimeModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x170)]
    NPCBlockedDestRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x174)]
    NPCCamoScanRevealTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x178)]
    NPCCamoWipeEffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x17C)]
    NPCDecelerateStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x180)]
    NPCDisplayThoughtsMaxDistance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x184)
    ]
    NPCDisplayThoughtsMaxDuration: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x188)
    ]
    NPCDisplayThoughtsProbability: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18C)
    ]
    NPCDisplayThoughtsRefreshInterval: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x190)
    ]
    NPCFastStaticTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x194)]
    NPCFlavourIdleTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x198)]
    NPCFlavourIdleTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x19C)]
    NPCForceProp: Annotated[
        c_enum32[enums.cGcNPCPropType], Field(c_enum32[enums.cGcNPCPropType], 0x1A0)
    ]
    NPCHackMoveUpToStopFallingThoughFloor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1A4)
    ]
    NPCIKBodyWeightNormal: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1A8)]
    NPCIKBodyWeightNormalGek: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1AC)]
    NPCIKBodyWeightSeated: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B0)]
    NPCIncreasedSteeringDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B4)]
    NPCLookAtTerminateAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1B8)]
    NPCLookAtThingChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1BC)]
    NPCLookAtThingTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C0)]
    NPCLookAtThingTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C4)]
    NPCLookAwayTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C8)]
    NPCLookAwayTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1CC)]
    NPCMaxFreighterInteractionSearchDist: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1D0)
    ]
    NPCMaxInteractionSearchDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D4)]
    NPCMaxLookAtAngleMoving: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D8)]
    NPCMaxLookAtAngleStatic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1DC)]
    NPCMaxRandomNavPathMaxIndoorOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1E0)
    ]
    NPCMaxRandomNavPathMaxOutdoorOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1E4)
    ]
    NPCMaxRandomNavPathMinIndoorOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1E8)
    ]
    NPCMaxRandomNavPathMinOutdoorOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1EC)
    ]
    NPCMaxSettlementInteractionSearchDist: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1F0)
    ]
    NPCMaxStaticTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F4)]
    NPCMaxTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F8)]
    NPCMinInteractionSearchDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1FC)]
    NPCMinStaticTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x200)]
    NPCMinTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x204)]
    NPCMinTurnSpeedMech: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x208)]
    NPCMoodIdleDelayChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20C)]
    NPCMoodIdleLowIntensityChance: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x210)
    ]
    NPCNumNavFailuresUntilNoPhysFallback: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x214)
    ]
    NPCPerceptionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x218)]
    NPCPermittedNavigationDelayFactor: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x21C)
    ]
    NPCPOISelectionNearbyNPCBaseMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x220)
    ]
    NPCPropScaleTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x224)]
    NPCReactCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x228)]
    NPCReactionChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x22C)]
    NPCReactToPlayerPresenceDist: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x230)
    ]
    NPCReactToPlayerPresenceGloablCooldown: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x234)
    ]
    NPCReactToPlayerPresenceIndividualCooldown: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x238)
    ]
    NPCReactToPlayerPresenceStaticTimer: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x23C)
    ]
    NPCRunSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x240)]
    NPCRunSpeedGek: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x244)]
    NPCScalingMaxRandomVariance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x248)]
    NPCSeatedLookAtLateralReduction: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x24C)
    ]
    NPCSlowStaticTurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x250)]
    NPCSpineAdjustGek: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x254)]
    NPCSpineAdjustVykeen: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x258)]
    NPCStaticDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x25C)]
    NPCStaticTimeUntilFail: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x260)]
    NPCStaticTurnTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x264)]
    NPCSteeringAvoidStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x268)]
    NPCSteeringCollisionAvoidAngle: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x26C)
    ]
    NPCSteeringCollisionAvoidStrength: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x270)
    ]
    NPCSteeringComingTowardsDegrees: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x274)
    ]
    NPCSteeringFollowStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x278)]
    NPCSteeringObstacleAvoidStrength: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x27C)
    ]
    NPCSteeringRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x280)]
    NPCSteeringRayLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x284)]
    NPCSteeringRaySphereSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x288)]
    NPCSteeringRaySpread: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28C)]
    NPCSteeringRepelDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x290)]
    NPCSteeringSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x294)]
    NPCTeleportEffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x298)]
    NPCWalkSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x29C)]
    NPCWalkSpeedGek: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A0)]
    NPCWalkSpeedMech: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2A4)]
    NPCWithScanEventReactCooldown: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2A8)
    ]
    NPCWithScanEventReactToPlayerPresenceDist: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2AC)
    ]
    NPCWithScanEventReactToPlayerPresenceIndividualCooldown: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2B0)
    ]
    PitchTest: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B4)]
    RagdollConeLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B8)]
    RagdollDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2BC)]
    RagdollMotorFadeEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C0)]
    RagdollMotorFadeStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C4)]
    RagdollTau: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C8)]
    RagdollTwistLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2CC)]
    RocketBootsLandedTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D0)]
    RocketBootsTurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D4)]
    RollTest: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2D8)]
    RootedAnimInterpolationTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2DC)]
    RotateToFaceSlopeSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E0)]
    RoughSeaIdleSwimmingPitchRotation: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x2E4)
    ]
    SitPostureChangeTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2E8)]
    SitPostureChangeTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2EC)]
    SlidingBrake: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F0)]
    SlopeAngleForDownhillClimb: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F4)]
    SlopeAngleForSlide: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2F8)]
    SlopeAngleForUphillClimb: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2FC)]
    SmoothVelocitySpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x300)]
    SwimmingPitchRotationSurfaceExtra: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x304)
    ]
    SwimmingRollSmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x308)]
    SwimmingRollSmoothTimeWithWeapon: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x30C)
    ]
    SwimmingSmoothTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x310)]
    SwimmingSmoothTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x314)]
    SwimmingSmoothTimeWithWeapon: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x318)
    ]
    TimeAfterDeathRagdollIsEnabledBackward: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x31C)
    ]
    TimeAfterDeathRagdollIsEnabledForward: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x320)
    ]
    TimeAfterDeathRagdollIsEnabledWhenBlocked: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x324)
    ]
    TimeFallingUntilPanic: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x328)]
    TimeNotOnGroundToBeConsideredInAir: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x32C)
    ]
    TimeNotOnGroundToUseFallingCamera: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x330)
    ]
    TimeToShowSplashEffect: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x334)]
    TrudgeUphillSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x338)]
    UnderwaterToAirTolerance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x33C)]
    UphillSpeedMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x340)]
    WaterBottomSmoothPushUp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x344)]
    WaterBottomSmoothPushUpDepth: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x348)
    ]
    WaterEffectFadeSpring: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34C)]
    WaterEffectSpeedFadeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x350)]
    WaterEffectSpeedFadeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x354)]
    YawPullSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x358)]
    NPCBehaviourInfo: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35C)]
    NPCLightsAlwaysOn: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35D)]
    NPCLookAtEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35E)]
    NPCUseBehaviourTree: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35F)]


@partial_struct
class cGcCollisionTable(Structure):
    CollisionTable: Annotated[
        basic.cTkDynamicArray[cGcPhysicsCollisionGroupCollidesWith],
        Field(basic.cTkDynamicArray[cGcPhysicsCollisionGroupCollidesWith], 0x0),
    ]


@partial_struct
class cGcAtlasGlobals(Structure):
    ChanceOfDisconnect: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    TimeoutSecConnection: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    TimeoutSecNameResolution: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    TimeoutSecSendRecv: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]


@partial_struct
class cGcTelemetryStat(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Type: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Value: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcStatValueData(Structure):
    Denominator: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FloatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    IntValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]


@partial_struct
class cGcStatLevelData(Structure):
    LevelName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    LevelNameUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    OSDLevelName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    TrophyToUnlock: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Value: Annotated[cGcStatValueData, Field(cGcStatValueData, 0x70)]


@partial_struct
class cGcLeveledStatData(Structure):
    StatLevels: Annotated[cGcStatLevelData, Field(cGcStatLevelData, 0x0)]
    NotifyMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x580)
    ]
    NotifyMessageSingular: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x5A0)
    ]
    StatTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x5C0)
    ]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x5E0)]
    StatId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x5F8)]

    class eStatMessageTypeEnum(IntEnum):
        Full = 0x0
        Quick = 0x1
        Silent = 0x2

    StatMessageType: Annotated[
        c_enum32[eStatMessageTypeEnum], Field(c_enum32[eStatMessageTypeEnum], 0x608)
    ]
    ShowInTerminal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60C)]
    ShowStatLevel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60D)]
    TelemetryUpload: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60E)]
    UseRankNotStats: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60F)]


@partial_struct
class cGcMinMaxFloat(Structure):
    Max: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Min: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcPlayerStat(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Value: Annotated[cGcStatValueData, Field(cGcStatValueData, 0x10)]


@partial_struct
class cGcPlayerStatsGroup(Structure):
    GroupId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Stats: Annotated[
        basic.cTkDynamicArray[cGcPlayerStat],
        Field(basic.cTkDynamicArray[cGcPlayerStat], 0x10),
    ]
    Address: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x20)]


@partial_struct
class cGcStatDefinition(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DefaultValue: Annotated[cGcStatValueData, Field(cGcStatValueData, 0x10)]
    DisplayType: Annotated[
        c_enum32[enums.cGcStatDisplayType],
        Field(c_enum32[enums.cGcStatDisplayType], 0x1C),
    ]
    MissionMessageDecimals: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    TrackType: Annotated[
        c_enum32[enums.cGcStatTrackType], Field(c_enum32[enums.cGcStatTrackType], 0x24)
    ]
    Type: Annotated[
        c_enum32[enums.cGcStatType], Field(c_enum32[enums.cGcStatType], 0x28)
    ]
    IsProgression: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    TelemetryUpload: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]


@partial_struct
class cGcStatGroupData(Structure):
    GroupName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TrackedStats: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]


@partial_struct
class cGcPlayerTitle(Structure):
    AlreadyUnlockedDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    UnlockDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    RevealedBy: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    TitleUnlocksSpecials: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x80),
    ]
    UnlockedByMission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    UnlockedByProductRecipe: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    UnlockedByStat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    UnlockedByTrophy: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    UnlockedByInteraction: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0xD0),
    ]
    UnlockedByInteractionIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xD4)]
    UnlockedByInteractionRace: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0xD8)
    ]
    UnlockedByLeveledStatRank: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xDC)]
    UnlockedByStatValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    UnlockedByInteractionOnlyTestMainRaces: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0xE4)
    ]


@partial_struct
class cGcJourneyMilestoneData(Structure):
    JourneyMilestoneTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    JourneyMilestoneTitleLower: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    JourneyMilestoneId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    PointsToUnlock: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]


@partial_struct
class cGcStatRewardGroupStatData(Structure):
    StatID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ManualAdjust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    StatMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcStatRewardGroup(Structure):
    LocIDMultiple: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    LocIDSingle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x40)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x58)]
    Stats: Annotated[
        basic.cTkDynamicArray[cGcStatRewardGroupStatData],
        Field(basic.cTkDynamicArray[cGcStatRewardGroupStatData], 0x68),
    ]
    BaseMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    Currency: Annotated[
        c_enum32[enums.cGcCurrency], Field(c_enum32[enums.cGcCurrency], 0x7C)
    ]


@partial_struct
class cGcSavedInteractionDialogData(Structure):
    Dialog: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Hash: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x20)]


@partial_struct
class cGcSavedInteractionRaceData(Structure):
    SavedRaceIndicies: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    HasLoopedIndicies: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcFriendlyDroneVocabularyEntry(Structure):
    GenericFallback: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]


@partial_struct
class cGcPetVocabularyTraitEntry(Structure):
    Negative: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Positive: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Trait: Annotated[
        c_enum32[enums.cGcCreaturePetTraits],
        Field(c_enum32[enums.cGcCreaturePetTraits], 0x40),
    ]


@partial_struct
class cGcPetVocabularyEntry(Structure):
    GenericFallback: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Vocabulary: Annotated[
        basic.cTkDynamicArray[cGcPetVocabularyTraitEntry],
        Field(basic.cTkDynamicArray[cGcPetVocabularyTraitEntry], 0x20),
    ]
    OddsOfProcReplacement: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cGcInteractionData(Structure):
    Position: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x0)]
    GalacticAddress: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    Value: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x18)]


@partial_struct
class cGcInteractionBuffer(Structure):
    Interactions: Annotated[
        basic.cTkDynamicArray[cGcInteractionData],
        Field(basic.cTkDynamicArray[cGcInteractionData], 0x0),
    ]
    CurrentPos: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcStatusMessageDefinition(Structure):
    CustomPrefixLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Message: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    DisplayDurationMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    MissionMarkup: Annotated[
        c_enum32[enums.cGcStatusMessageMissionMarkup],
        Field(c_enum32[enums.cGcStatusMessageMissionMarkup], 0x58),
    ]

    class eReplicateToEnum(IntEnum):
        None_ = 0x0
        Fireteam = 0x1
        Fireteam_SameUA = 0x2
        Global = 0x3
        Global_Distance = 0x4
        Fireteam_Distance = 0x5
        Fireteam_Global_Distance = 0x6
        Not_Fireteam = 0x7

    ReplicateTo: Annotated[
        c_enum32[eReplicateToEnum], Field(c_enum32[eReplicateToEnum], 0x5C)
    ]
    AddFriendlyDronePrefix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    AddPetNamePrefix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]
    AddPlayerNamePrefix: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x62)]
    IncludePlayerName: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x63)]
    OnlyInMultiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]
    OnlyOnFireteam: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x65)]
    PostLocally: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x66)]


@partial_struct
class cGcTerrainEdit(Structure):
    Position: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Data: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0x4)]


@partial_struct
class cGcPersistentTerrainEdits(Structure):
    BufferAnchors: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x0),
    ]
    BufferSizes: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x10),
    ]
    Edits: Annotated[
        basic.cTkDynamicArray[cGcTerrainEdit],
        Field(basic.cTkDynamicArray[cGcTerrainEdit], 0x20),
    ]
    GalacticAddress: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x30)]


@partial_struct
class cGcSyncBufferSaveData(Structure):
    SpaceAddress: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    BufferVersion: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x8)]
    ItemsCount: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0xC)]
    OwnerOnlineId: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)
    ]
    OwnerPlatformId: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x50)
    ]


@partial_struct
class cGcSyncBufferSaveDataArray(Structure):
    Data: Annotated[
        basic.cTkDynamicArray[cGcSyncBufferSaveData],
        Field(basic.cTkDynamicArray[cGcSyncBufferSaveData], 0x0),
    ]


@partial_struct
class cGcSynchronisedBufferData(Structure):
    Data: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint64],
        Field(basic.cTkDynamicArray[ctypes.c_uint64], 0x0),
    ]


@partial_struct
class cGcTradingSupplyData(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    GalacticAddress: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    Timestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x18)]
    Demand: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    InteractionType: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0x24),
    ]
    Supply: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcSettlementTowerPowerTimestamps(Structure):
    TimeStamps: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    ClusterIndex: Annotated[ctypes.c_int8, Field(ctypes.c_int8, 0x20)]


@partial_struct
class cGcUniqueIdData(Structure):
    DeterministicSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    Iteration: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x8)]

    class eUniqueIdTypeEnum(IntEnum):
        Invalid = 0x0
        Deterministic = 0x1
        UserSpawned = 0x2

    UniqueIdType: Annotated[
        c_enum32[eUniqueIdTypeEnum], Field(c_enum32[eUniqueIdTypeEnum], 0xC)
    ]
    OnlineID: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)]
    PlatformID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x50)
    ]


@partial_struct
class cGcSettlementWeaponRespawnData(Structure):
    InteractionSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    LastWeaponRefreshTimestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x8)]


@partial_struct
class cGcWordGroupKnowledge(Structure):
    Group: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Races: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcSkiffSaveData(Structure):
    Direction: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x0)]
    Position: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x10)]
    Location: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x20)]


@partial_struct
class cGcWordKnowledge(Structure):
    Word: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Races: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcSeasonPetConstraints(Structure):
    CreatureId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TimeSinceBirth: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    TimeSinceLastEgg: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x18)]
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x20)
    ]
    MaxRelativeScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    MinRelativeScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    StartingTrust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    SpecificBiome: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcSettlementProductionElementRequirement(Structure):
    RequiredSettlementBuildingLevel: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x0)
    ]
    RequiredSettlementBuildingType: Annotated[
        c_enum32[enums.cGcBuildingClassification],
        Field(c_enum32[enums.cGcBuildingClassification], 0x4),
    ]


@partial_struct
class cGcSettlementProductionElement(Structure):
    Product: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Requirements: Annotated[
        basic.cTkDynamicArray[cGcSettlementProductionElementRequirement],
        Field(basic.cTkDynamicArray[cGcSettlementProductionElementRequirement], 0x10),
    ]
    ProductionAccumulationCap: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    ProductionAmountMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    ProductionTimeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcSettlementProductionSlotData(Structure):
    ElementId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LastChangeTimestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    ProductionAccumulationCap: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    ProductionAmountMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ProductionTimeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    RequiredSettlementBuildingLevel: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x28)
    ]
    RequiredSettlementBuildingType: Annotated[
        c_enum32[enums.cGcBuildingClassification],
        Field(c_enum32[enums.cGcBuildingClassification], 0x2C),
    ]


@partial_struct
class cGcSeasonalMilestoneEncryption(Structure):
    Description: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    Subtitle: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    TitleUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    HoverPopupIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x60)]
    Patch: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x78)]
    DecryptMissionId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    DecryptMissionSeed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    IsEncrypted: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA4)]


@partial_struct
class cGcSeasonalMilestone(Structure):
    Encryption: Annotated[
        cGcSeasonalMilestoneEncryption, Field(cGcSeasonalMilestoneEncryption, 0x0)
    ]
    CantRewardMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xA8)
    ]
    Description: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC8)
    ]
    DescriptionDone: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xE8)
    ]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x108)]
    TitleUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x128)
    ]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x148)]
    IconGrey: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x160)]
    MissionIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x178)]
    MissionIconNotSelected: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x190)
    ]
    MissionIconSelected: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1A8)]
    IdToUseInMissionData: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1C0)]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1D0)]
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1E0)]
    RewardSwitchAlt: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1F0)]
    Amount: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x200)]
    BlockRendezvousMilestoneSeed: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x204)
    ]
    MilestoneIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x208)]
    RendezvousIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20C)]
    StageIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x210)]
    CantClaimRewardDescription: Annotated[
        basic.cTkFixedString0x200, Field(basic.cTkFixedString0x200, 0x214)
    ]
    RewardDescription: Annotated[
        basic.cTkFixedString0x200, Field(basic.cTkFixedString0x200, 0x414)
    ]
    DontAttemptFallbackTextSubs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x614)]
    GreyIfCantStart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x615)]
    IsOptional: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x616)]
    IsRendezvous: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x617)]
    IsStageControl: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x618)]


@partial_struct
class cGcSeasonalRingData(Structure):
    CoreOpacity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    RingOpacity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    RingSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcSeasonalRingArray(Structure):
    SeasonalRingData: Annotated[
        basic.cTkDynamicArray[cGcSeasonalRingData],
        Field(basic.cTkDynamicArray[cGcSeasonalRingData], 0x0),
    ]


@partial_struct
class cGcSettlementHistory(Structure):
    SeedValue: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x0)]
    BugAttackCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    GiftsRecieved: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    InitialBuildingCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    InitialHappiness: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    InitialPopulation: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    InitialProductivity: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    InitialUpkeepCost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    JudgementsSettled: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    LastWentIntoDebtTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    LastWentIntoProfitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    LongestDebtStretch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    LongestProfitStretch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    PlayerClaimedTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    PlayerKillCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    SentinelAttackCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    SettlerDeathCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]


@partial_struct
class cGcSaveContextDataMask(Structure):
    Ammo: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]
    AtlasStations: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1)]
    Banner: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2)]
    BaseBuildingObjects: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3)]
    BuildersKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    CharacterCustomisation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]
    ChestInventories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x6)]
    ChestMagicInventories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7)]
    CookingIngredientsInventory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    DifficultySettings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]
    FishPlatformInventory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA)]
    Fleet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB)]
    Freighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC)]
    GalaxyWaypoints: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD)]
    HotActions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xE)]
    Interactions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF)]
    KnownProducts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    KnownRefinerRecipes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    KnownSpecials: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]
    KnownTech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x13)]
    KnownWords: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    MultiTools: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]
    Nanites: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x16)]
    NexusAccess: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x17)]
    NPCWorkers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    PersistentBases: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]
    Pets: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A)]
    PlayerInventory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B)]
    Portals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]
    ProcTechIndex: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1D)]
    ProgressionLevel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1E)]
    RedeemedRewards: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1F)]
    RevealBlackHoles: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    RocketLauncherInventory: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    SeenBaseObjects: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]
    SeenStories: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23)]
    SettlementState: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    Ships: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    ShopTier: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    Specials: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]
    SquadronPilots: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    Stats: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    TeleportEndpoints: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    TerrainEdits: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    TradingSupply: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    Units: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    Vehicles: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    VisitedSystems: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]
    Wonders: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcSaveContextDataMaskTableEntry(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Mask: Annotated[cGcSaveContextDataMask, Field(cGcSaveContextDataMask, 0x10)]


@partial_struct
class cGcSavedEntitlement(Structure):
    EntitlementId: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x0)
    ]


@partial_struct
class cGcPortalSaveData(Structure):
    PortalSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x0)]
    LastPortalUA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    IsStoryPortal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcProtectedLocation(Structure):
    Location: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcPlayerMissionUpgradeMapEntry(Structure):
    CompletedMissions: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    NewMission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    CompletePoint: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    MinProgress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]


@partial_struct
class cGcPlayerSpawnStateData(Structure):
    AbandonedFreighterPositionInSystem: Annotated[
        basic.Vector4f, Field(basic.Vector4f, 0x0)
    ]
    AbandonedFreighterTransformAt: Annotated[
        basic.Vector4f, Field(basic.Vector4f, 0x10)
    ]
    AbandonedFreighterTransformUp: Annotated[
        basic.Vector4f, Field(basic.Vector4f, 0x20)
    ]
    FreighterPositionInSystem: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x30)]
    FreighterTransformAt: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x40)]
    FreighterTransformUp: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x50)]
    PlayerDeathRespawnPositionInSystem: Annotated[
        basic.Vector4f, Field(basic.Vector4f, 0x60)
    ]
    PlayerDeathRespawnTransformAt: Annotated[
        basic.Vector4f, Field(basic.Vector4f, 0x70)
    ]
    PlayerPositionInSystem: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x80)]
    PlayerTransformAt: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x90)]
    ShipPositionInSystem: Annotated[basic.Vector4f, Field(basic.Vector4f, 0xA0)]
    ShipTransformAt: Annotated[basic.Vector4f, Field(basic.Vector4f, 0xB0)]
    ShipTransformUp: Annotated[basic.Vector4f, Field(basic.Vector4f, 0xC0)]

    class eLastKnownPlayerStateEnum(IntEnum):
        OnFoot = 0x0
        InShip = 0x1
        InStation = 0x2
        AboardFleet = 0x3
        InNexus = 0x4
        AbandonedFreighter = 0x5
        InShipLanded = 0x6
        InVehicle = 0x7
        OnFootInCorvette = 0x8
        OnFootInCorvetteLanded = 0x9

    LastKnownPlayerState: Annotated[
        c_enum32[eLastKnownPlayerStateEnum],
        Field(c_enum32[eLastKnownPlayerStateEnum], 0xD0),
    ]
    ShipHovering: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD4)]


@partial_struct
class cGcPlayerMissionParticipant(Structure):
    BuildingLocation: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    BuildingSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x20)]
    ParticipantType: Annotated[
        c_enum32[enums.cGcPlayerMissionParticipantType],
        Field(c_enum32[enums.cGcPlayerMissionParticipantType], 0x28),
    ]


@partial_struct
class cGcPlayerMissionProgress(Structure):
    Participants: Annotated[
        cGcPlayerMissionParticipant, Field(cGcPlayerMissionParticipant, 0x0)
    ]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x270)]
    Data: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x280)]
    Seed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x288)]
    Stat: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x290)]
    Progress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x298)]


@partial_struct
class cGcPlayerMissionProgressMapEntry(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    MaxProgress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinProgress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    NewProgress: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]


@partial_struct
class cGcPetData(Structure):
    CustomSpeciesName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    BoneScaleSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x20)]
    ColourBaseSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x30)]
    CreatureID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    CreatureSecondarySeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x50)]
    CreatureSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x60)]
    Descriptors: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x70),
    ]
    BirthTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x80)]
    GenusSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x88)]
    LastEggTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x90)]
    LastTrustDecreaseTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x98)]
    LastTrustIncreaseTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA0)]
    SpeciesSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA8)]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xB0)]
    SenderData: Annotated[cGcDiscoveryOwner, Field(cGcDiscoveryOwner, 0xB8)]
    Traits: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1BC)]
    Moods: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C8)]
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x1D0)
    ]
    CreatureType: Annotated[
        c_enum32[enums.cGcCreatureTypes], Field(c_enum32[enums.cGcCreatureTypes], 0x1D4)
    ]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1D8)]
    Trust: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1DC)]
    CustomName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x1E0)
    ]
    AllowUnmodifiedReroll: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x200)]
    EggModified: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x201)]
    HasBeenSummoned: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x202)]
    HasFur: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x203)]
    Predator: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x204)]


@partial_struct
class cGcInventoryLayout(Structure):
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x0)]
    Level: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    Slots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]


@partial_struct
class cGcModularCustomisationProductLookupList(Structure):
    ProductLookupList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcKnownThingsPreset(Structure):
    KnownProducts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    KnownRefinerRecipes: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x10),
    ]
    KnownSpecials: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    KnownTech: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    KnownWordGroups: Annotated[
        basic.cTkDynamicArray[cGcWordGroupKnowledge],
        Field(basic.cTkDynamicArray[cGcWordGroupKnowledge], 0x40),
    ]
    KnownWords: Annotated[
        basic.cTkDynamicArray[cGcWordKnowledge],
        Field(basic.cTkDynamicArray[cGcWordKnowledge], 0x50),
    ]


@partial_struct
class cGcHistoricalSeasonData(Structure):
    SeasonName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    SeasonNameUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    UnlockedTitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    MainIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x60)]
    FinalReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x78)]
    DisplayNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x88)]
    RemixNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8C)]
    SeasonNumber: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x90)]
    Description: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x94)
    ]


@partial_struct
class cGcMaintenanceSaveKey(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Location: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcInventoryIndex(Structure):
    X: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    Y: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cGcInventoryElement(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Index: Annotated[cGcInventoryIndex, Field(cGcInventoryIndex, 0x10)]
    Amount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    DamageFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    MaxAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    Type: Annotated[
        c_enum32[enums.cGcInventoryType], Field(c_enum32[enums.cGcInventoryType], 0x24)
    ]
    AddedAutomatically: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    FullyInstalled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]


@partial_struct
class cGcPersistedStatData(Structure):
    GroupId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    StatId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcModSettingsInfo(Structure):
    Dependencies: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint64],
        Field(basic.cTkDynamicArray[ctypes.c_uint64], 0x0),
    ]
    AuthorID: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x10)]
    ID: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x18)]
    LastUpdated: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x20)]
    ModPriority: Annotated[ctypes.c_uint16, Field(ctypes.c_uint16, 0x28)]
    Author: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x2A)]
    Name: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xAA)]
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12A)]
    EnabledVR: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12B)]


@partial_struct
class cGcModSettings(Structure):
    Data: Annotated[
        basic.cTkDynamicArray[cGcModSettingsInfo],
        Field(basic.cTkDynamicArray[cGcModSettingsInfo], 0x0),
    ]
    DisableAllMods: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcInventorySpecialSlot(Structure):
    Index: Annotated[cGcInventoryIndex, Field(cGcInventoryIndex, 0x0)]
    Type: Annotated[
        c_enum32[enums.cGcInventorySpecialSlotType],
        Field(c_enum32[enums.cGcInventorySpecialSlotType], 0x8),
    ]


@partial_struct
class cGcInventoryContainer(Structure):
    BaseStatValues: Annotated[
        basic.cTkDynamicArray[cGcInventoryBaseStatEntry],
        Field(basic.cTkDynamicArray[cGcInventoryBaseStatEntry], 0x0),
    ]
    Slots: Annotated[
        basic.cTkDynamicArray[cGcInventoryElement],
        Field(basic.cTkDynamicArray[cGcInventoryElement], 0x10),
    ]
    SpecialSlots: Annotated[
        basic.cTkDynamicArray[cGcInventorySpecialSlot],
        Field(basic.cTkDynamicArray[cGcInventorySpecialSlot], 0x20),
    ]
    ValidSlotIndices: Annotated[
        basic.cTkDynamicArray[cGcInventoryIndex],
        Field(basic.cTkDynamicArray[cGcInventoryIndex], 0x30),
    ]
    Class: Annotated[
        c_enum32[enums.cGcInventoryClass],
        Field(c_enum32[enums.cGcInventoryClass], 0x40),
    ]
    Height: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    NumSlotsFromTech: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    StackSizeGroup: Annotated[
        c_enum32[enums.cGcInventoryStackSizeGroup],
        Field(c_enum32[enums.cGcInventoryStackSizeGroup], 0x4C),
    ]
    Version: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    Width: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    Name: Annotated[basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x58)]
    IsCool: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x158)]


@partial_struct
class cGcCustomisationColourPaletteExtraData(Structure):
    ProductToUnlock: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    TipText: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x10),
    ]


@partial_struct
class cGcCustomisationColourPalette(Structure):
    PaletteData: Annotated[cGcPaletteData, Field(cGcPaletteData, 0x0)]
    ExtraData: Annotated[
        cGcCustomisationColourPaletteExtraData,
        Field(cGcCustomisationColourPaletteExtraData, 0x410),
    ]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x430)]


@partial_struct
class cGcGalacticAddressData(Structure):
    PlanetIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    SolarSystemIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    VoxelX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    VoxelY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    VoxelZ: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcCustomisationHeadToRace(Structure):
    HeadDescriptor: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    HeadAnimationRace: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x20)
    ]
    Race: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x24)
    ]


@partial_struct
class cGcFleetFrigateSaveData(Structure):
    ForcedTraitsSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x0)]
    HomeSystemSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x10)]
    ResourceSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x20)]
    Stats: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x30),
    ]
    TraitIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x40),
    ]
    TimeOfLastIncomeCollection: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x50)]
    DamageTaken: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x58)]
    FrigateClass: Annotated[
        c_enum32[enums.cGcFrigateClass], Field(c_enum32[enums.cGcFrigateClass], 0x5C)
    ]
    InventoryClass: Annotated[
        c_enum32[enums.cGcInventoryClass],
        Field(c_enum32[enums.cGcInventoryClass], 0x60),
    ]
    NumberOfTimesDamaged: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x64)]
    Race: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x68)
    ]
    RepairsMade: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x6C)]
    TotalNumberOfExpeditions: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    TotalNumberOfFailedEvents: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    TotalNumberOfSuccessfulEvents: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x78)
    ]
    CustomName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x7C)
    ]


@partial_struct
class cGcExpeditionEventSaveData(Structure):
    EventID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    InterventionEventID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x20)]
    OverriddenRewardDescription: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)
    ]
    AffectedFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x60),
    ]
    AffectedFrigateResponses: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x70),
    ]
    OverriddenReward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    RepairingFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x90),
    ]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0xA0)]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xB0)]
    OverriddenDescription: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0xB8)
    ]
    AvoidedIntervention: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF8)]
    IsInterventionEvent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xF9)]
    Success: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFA)]
    WhaleEvent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xFB)]


@partial_struct
class cGcFleetExpeditionSaveData(Structure):
    SpawnPosition: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    TerminalPosition: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    ActiveFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x20),
    ]
    AllFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x30),
    ]
    DamagedFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x40),
    ]
    DestroyedFrigateIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x50),
    ]
    Events: Annotated[
        basic.cTkDynamicArray[cGcExpeditionEventSaveData],
        Field(basic.cTkDynamicArray[cGcExpeditionEventSaveData], 0x60),
    ]
    InterventionEventMissionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    Powerups: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x80),
    ]
    Seed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x90)]
    PauseTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA0)]
    StartTime: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA8)]
    TimeOfLastUAChange: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xB0)]
    UA: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xB8)]
    ExpeditionCategory: Annotated[
        c_enum32[enums.cGcExpeditionCategory],
        Field(c_enum32[enums.cGcExpeditionCategory], 0xC0),
    ]
    ExpeditionDuration: Annotated[
        c_enum32[enums.cGcExpeditionDuration],
        Field(c_enum32[enums.cGcExpeditionDuration], 0xC4),
    ]
    NextEventToTrigger: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC8)]
    NumberOfFailedEventsThisExpedition: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0xCC)
    ]
    NumberOfSuccessfulEventsThisExpedition: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0xD0)
    ]
    SpeedMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    CustomName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xD8)
    ]
    InterventionPhoneCallActivated: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x1D8)
    ]


@partial_struct
class cGcFreighterRoomNPCData(Structure):
    RoomID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    POISelectionWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SpawnCapacity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]


@partial_struct
class cGcFreighterRoomNPCSpawnCapacityEntry(Structure):
    RoomID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    SpawnCapacity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcFreighterRoomNPCSpawnCapacities(Structure):
    RoomSpawnCapacities: Annotated[
        basic.cTkDynamicArray[cGcFreighterRoomNPCSpawnCapacityEntry],
        Field(basic.cTkDynamicArray[cGcFreighterRoomNPCSpawnCapacityEntry], 0x0),
    ]


@partial_struct
class cGcCustomisationMultiTextureSubOption(Structure):
    Option: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Layer: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcCustomisationMultiTextureOptionList(Structure):
    TextureOptionsID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    SubOptions: Annotated[
        basic.cTkDynamicArray[cGcCustomisationMultiTextureSubOption],
        Field(basic.cTkDynamicArray[cGcCustomisationMultiTextureSubOption], 0x20),
    ]


@partial_struct
class cGcCustomisationMultiTextureOption(Structure):
    MultiTextureOptionsID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Options: Annotated[
        basic.cTkDynamicArray[cGcCustomisationMultiTextureOptionList],
        Field(basic.cTkDynamicArray[cGcCustomisationMultiTextureOptionList], 0x10),
    ]
    ProductsToUnlock: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    Tips: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x30),
    ]


@partial_struct
class cGcNPCNavSubgraphNodeTypeConnectivity(Structure):
    ConnectionToPOI: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ExternalConnection: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    InternalConnection: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PathToPOI: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cGcCharacterCustomisationBoneScaleData(Structure):
    BoneName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcCustomisationTextureOption(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Layer: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Options: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x20),
    ]
    ProductsToUnlock: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x30),
    ]
    TextureOptionsID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Tips: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x50),
    ]
    AllowAllColoursWithNoMarkings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]


@partial_struct
class cGcCharacterCustomisationColourData(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x10)]


@partial_struct
class cGcCharacterCustomisationTextureOptionData(Structure):
    TextureOptionName: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    TextureOptionGroupName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcCharacterCustomisationData(Structure):
    BoneScales: Annotated[
        basic.cTkDynamicArray[cGcCharacterCustomisationBoneScaleData],
        Field(basic.cTkDynamicArray[cGcCharacterCustomisationBoneScaleData], 0x0),
    ]
    Colours: Annotated[
        basic.cTkDynamicArray[cGcCharacterCustomisationColourData],
        Field(basic.cTkDynamicArray[cGcCharacterCustomisationColourData], 0x10),
    ]
    DescriptorGroups: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    PaletteID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    TextureOptions: Annotated[
        basic.cTkDynamicArray[cGcCharacterCustomisationTextureOptionData],
        Field(basic.cTkDynamicArray[cGcCharacterCustomisationTextureOptionData], 0x40),
    ]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]


@partial_struct
class cGcCharacterCustomisationSaveData(Structure):
    CustomData: Annotated[
        cGcCharacterCustomisationData, Field(cGcCharacterCustomisationData, 0x0)
    ]
    SelectedPreset: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x58)]


@partial_struct
class cGcPersistentBBObjectData(Structure):
    At: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    ObjectID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    GalacticAddress: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x40)]
    RegionSeed: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x48)]
    Timestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x50)]
    UserData: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x58)]


@partial_struct
class cGcCustomisationDescriptorGroup(Structure):
    Tip: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Descriptors: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x40),
    ]
    GroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    LinkedSpecialID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    SuffixInclusionList: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x70),
    ]
    Image: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x80)]
    HiddenInCustomiser: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x100)]


@partial_struct
class cGcCustomisationDescriptorGroupFallbackData(Structure):
    DescriptorGroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FallbackPriorityList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]


@partial_struct
class cGcFreighterNPCSpawnPriority(Structure):
    PriorityScale: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x0),
    ]


@partial_struct
class cGcCustomisationDescriptorList(Structure):
    Descriptors: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x0),
    ]


@partial_struct
class cGcCustomisationDescriptorVisualEffect(Structure):
    Effect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AttachTo: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)]


@partial_struct
class cGcGeneratedBaseDecorationTemplate(Structure):
    TemplateScene: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    InvalidRoomIndexes: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x30),
    ]

    class eDecorationLayerEnum(IntEnum):
        Stairs = 0x0
        Corridor = 0x1
        Room = 0x2
        Door = 0x3
        Decoration1 = 0x4
        Decoration2 = 0x5
        Decoration3 = 0x6
        DecorationCorridor = 0x7

    DecorationLayer: Annotated[
        c_enum32[eDecorationLayerEnum], Field(c_enum32[eDecorationLayerEnum], 0x40)
    ]
    MaxPerRoom: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]


@partial_struct
class cGcGeneratedBaseLockDoorPair(Structure):
    Door: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Lock: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcGeneratedBasePruningRule(Structure):
    NodeName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RoomFilters: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    RuleId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    MaxPerDungeon: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    MaxPerRoom: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]


@partial_struct
class cGcGeneratedBaseRoomTemplate(Structure):
    PrimaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    QuaternaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    SecondaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    TernaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    LocId: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)]
    DecorationThemes: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x60),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    MaxPathLength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    MinContiguousDepth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x84)]
    MinContiguousHeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x88)]
    MinContiguousWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8C)]
    MinPathLength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x90)]
    ShrinkFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]


@partial_struct
class cGcGeneratedBaseStructuralTemplate(Structure):
    TemplateScene: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcGeneratedBaseThemeTemplate(Structure):
    DecorationTemplates: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cGcBiomeCondition(Structure):
    BiomeType: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x0)
    ]


@partial_struct
class cGcPersistentBaseEntry(Structure):
    At: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    Up: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    ObjectID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Timestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x40)]
    UserData: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x48)]
    Message: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x50)]


@partial_struct
class cGcGroupCondition(Structure):
    Conditions: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    ORConditions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcBuildMenuIconSet(Structure):
    Glow: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    Normal: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x18)]


@partial_struct
class cGcId256List(Structure):
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    IdList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x20],
        Field(basic.cTkDynamicArray[basic.TkID0x20], 0x20),
    ]


@partial_struct
class cGcBaseGridSearchFilter(Structure):
    GridHasMaxNonPassiveParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    GridHasMaxParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    GridHasMinNonPassiveParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    GridHasMinParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    GridRateIsGreaterThan: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    GridRateIsLessThan: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    NetworkType: Annotated[
        c_enum32[enums.cGcLinkNetworkTypes],
        Field(c_enum32[enums.cGcLinkNetworkTypes], 0x18),
    ]
    PartRateIsGreaterThan: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    PartRateIsLessThan: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    GridHasANegativeRate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]
    GridHasAPositiveRate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x25)]
    GridHasPositiveRatePotential: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    GridIsNotOnline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]
    GridIsOnline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]


@partial_struct
class cGcBaseBuildingProperties(Structure):
    DefaultInBaseObject: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DefaultInFreighterObject: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DefaultOnTerrainObject: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcBasePartSearchFilter(Structure):
    ReferenceWorldPosition: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    IsSpecificID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BaseGridFilter: Annotated[
        cGcBaseGridSearchFilter, Field(cGcBaseGridSearchFilter, 0x20)
    ]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    ApplyGridFilter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    PartIsNotOnline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    PartIsNotVision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]
    PartIsOnline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x53)]
    PartIsVision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]


@partial_struct
class cGcBaseBuildingSubGroup(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcBasePlacementRule(Structure):
    PartID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    Conditions: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x20),
    ]

    class eTwinCriteriaEnum(IntEnum):
        None_ = 0x0
        MoveToTwin = 0x1
        StretchToTwin = 0x2
        StretchToRaycast = 0x3
        MoveToTwinRelative = 0x4

    TwinCriteria: Annotated[
        c_enum32[eTwinCriteriaEnum], Field(c_enum32[eTwinCriteriaEnum], 0x30)
    ]
    PositionLocator: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x34)
    ]
    ORConditions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB4)]


@partial_struct
class cGcBaseLinkGridConnectionData(Structure):
    LinkSocketPositions: Annotated[
        basic.cTkDynamicArray[basic.Vector3f],
        Field(basic.cTkDynamicArray[basic.Vector3f], 0x0),
    ]
    LinkSocketSubGroups: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x10),
    ]
    ConnectionDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    Network: Annotated[
        c_enum32[enums.cGcLinkNetworkTypes],
        Field(c_enum32[enums.cGcLinkNetworkTypes], 0x24),
    ]
    NetworkMask: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    NetworkSubGroup: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    UseMinDistance: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcBaseLinkGridConnectionDependency(Structure):
    Connection: Annotated[
        cGcBaseLinkGridConnectionData, Field(cGcBaseLinkGridConnectionData, 0x0)
    ]

    class eDependentEffectEnum(IntEnum):
        None_ = 0x0
        EnablesRate = 0x1
        DisablesRate = 0x2
        EnablesConnection = 0x3
        DisablesConnection = 0x4

    DependentEffect: Annotated[
        c_enum32[eDependentEffectEnum], Field(c_enum32[eDependentEffectEnum], 0x38)
    ]
    DependentRate: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3C)]
    DisableWhenOffline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]
    TransfersConnections: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41)]


@partial_struct
class cGcBaseSearchFilter(Structure):
    BasePartFilter: Annotated[
        cGcBasePartSearchFilter, Field(cGcBasePartSearchFilter, 0x0)
    ]
    ReferenceWorldPosition: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x60)]
    OnSpecificPlanetScanEvent: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x70)
    ]
    MatchingTypes: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcPersistentBaseTypes]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcPersistentBaseTypes]], 0x90),
    ]
    InSpecificSystem: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA0)]
    OnSpecificPlanet: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0xA8)]
    ContainsMaxParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB0)]
    ContainsMinParts: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB4)]
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    InCurrentSystem: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBC)]
    IsBuildable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBD)]
    IsOverlapping: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBE)]
    OnCurrentPlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBF)]


@partial_struct
class cGcBaseLinkGridData(Structure):
    Connection: Annotated[
        cGcBaseLinkGridConnectionData, Field(cGcBaseLinkGridConnectionData, 0x0)
    ]
    DependentConnections: Annotated[
        basic.cTkDynamicArray[cGcBaseLinkGridConnectionDependency],
        Field(basic.cTkDynamicArray[cGcBaseLinkGridConnectionDependency], 0x38),
    ]

    class eDependsOnEnvironmentEnum(IntEnum):
        None_ = 0x0
        DayNight = 0x1
        Storms = 0x2

    DependsOnEnvironment: Annotated[
        c_enum32[eDependsOnEnvironmentEnum],
        Field(c_enum32[eDependsOnEnvironmentEnum], 0x48),
    ]

    class eDependsOnHotspotsEnum(IntEnum):
        None_ = 0x0
        Power = 0x1
        Mineral = 0x2
        Gas = 0x3

    DependsOnHotspots: Annotated[
        c_enum32[eDependsOnHotspotsEnum], Field(c_enum32[eDependsOnHotspotsEnum], 0x4C)
    ]
    Rate: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    Storage: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]


@partial_struct
class cGcBaseBuildingPartNavNodeData(Structure):
    AtDir: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    LocalPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    ConnectedNodeIndices: Annotated[
        basic.cTkDynamicArray[ctypes.c_uint32],
        Field(basic.cTkDynamicArray[ctypes.c_uint32], 0x20),
    ]
    InteractionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    ArriveDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Type: Annotated[
        c_enum32[enums.cGcNPCNavSubgraphNodeType],
        Field(c_enum32[enums.cGcNPCNavSubgraphNodeType], 0x44),
    ]


@partial_struct
class cGcBaseStatCondition(Structure):
    class eBaseStatEnum(IntEnum):
        HasTeleporter = 0x0
        HasMainframe = 0x1

    BaseStat: Annotated[c_enum32[eBaseStatEnum], Field(c_enum32[eBaseStatEnum], 0x0)]
    StatValue: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]


@partial_struct
class cGcBaseBuildingPartData(Structure):
    MagicData: Annotated[cTkMagicModelData, Field(cTkMagicModelData, 0x0)]
    PartID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x30)]
    InstanceLastProfiledTimestamp: Annotated[
        ctypes.c_uint64, Field(ctypes.c_uint64, 0x50)
    ]
    LastProfiledTimestamp: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x58)]
    InstanceMeshesCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x60)]
    InstanceNodesCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x64)]
    InstanceTimeCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x68)]
    MeshesCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x6C)]
    NodesCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x70)]
    PhysicsCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x74)]
    Style: Annotated[
        c_enum32[enums.cGcBaseBuildingPartStyle],
        Field(c_enum32[enums.cGcBaseBuildingPartStyle], 0x78),
    ]
    TimeCost: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x7C)]


@partial_struct
class cGcBaseBuildingPartInteractionData(Structure):
    AtDir: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    LocalPos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    InteractionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]


@partial_struct
class cGcBaseBuildingPartNavData(Structure):
    PartID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    NavNodeData: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingPartNavNodeData],
        Field(basic.cTkDynamicArray[cGcBaseBuildingPartNavNodeData], 0x20),
    ]
    SharedInteractions: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingPartInteractionData],
        Field(basic.cTkDynamicArray[cGcBaseBuildingPartInteractionData], 0x30),
    ]


@partial_struct
class cGcBaseBuildingFamily(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ObjectIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]

    class eFamilyTypeEnum(IntEnum):
        Replacements = 0x0
        Extras = 0x1
        Symmetrical = 0x2
        YFlip = 0x3
        Rotations = 0x4

    FamilyType: Annotated[
        c_enum32[eFamilyTypeEnum], Field(c_enum32[eFamilyTypeEnum], 0x20)
    ]


@partial_struct
class cGcBaseBuildingGroup(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x38)]
    SubGroups: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingSubGroup],
        Field(basic.cTkDynamicArray[cGcBaseBuildingSubGroup], 0x48),
    ]
    DefaultColourIdx: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x58)]


@partial_struct
class cGcBaseBuildingMaterial(Structure):
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    LocName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x40)]
    SwatchImage: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x58)]
    MaterialIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]


@partial_struct
class cGcBaseBuildingPalette(Structure):
    PrimaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    QuaternaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    SecondaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    TernaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]
    Id: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x40)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x60)]

    class eSwatchPrimaryColourEnum(IntEnum):
        Primary = 0x0
        Secondary = 0x1
        Ternary = 0x2
        Quaternary = 0x3

    SwatchPrimaryColour: Annotated[
        c_enum32[eSwatchPrimaryColourEnum],
        Field(c_enum32[eSwatchPrimaryColourEnum], 0x80),
    ]

    class eSwatchSecondaryColourEnum(IntEnum):
        Primary = 0x0
        Secondary = 0x1
        Ternary = 0x2
        Quaternary = 0x3

    SwatchSecondaryColour: Annotated[
        c_enum32[eSwatchSecondaryColourEnum],
        Field(c_enum32[eSwatchSecondaryColourEnum], 0x84),
    ]


@partial_struct
class cGcBaseBuildingEntryCosts(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Active0AverageFrameTimeCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Active1AverageFrameTimeCost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    ActivePhysicsComponents: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    ActiveTotalNodes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    Inactive0AverageFrameTimeCost: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x20)
    ]
    Inactive1AverageFrameTimeCost: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x24)
    ]
    InactivePhysicsComponents: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x28)]
    InactiveTotalNodes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]


@partial_struct
class cGcBaseBuildingCostsTable(Structure):
    ObjectCosts: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingEntryCosts],
        Field(basic.cTkDynamicArray[cGcBaseBuildingEntryCosts], 0x0),
    ]


@partial_struct
class cGcBaseBuildingEntryGroup(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    SubGroupName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    SubGroup: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]


@partial_struct
class cGcSentinelWaveGroup(Structure):
    ExtremeWaves: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    Waves: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]


@partial_struct
class cGcSettlementStatValueRange(Structure):
    MaxValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MinValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Type: Annotated[
        c_enum32[enums.cGcSettlementStatType],
        Field(c_enum32[enums.cGcSettlementStatType], 0x8),
    ]


@partial_struct
class cGcSettlementBuildingContribution(Structure):
    Base: Annotated[
        basic.cTkDynamicArray[cGcSettlementStatValueRange],
        Field(basic.cTkDynamicArray[cGcSettlementStatValueRange], 0x0),
    ]
    Upgrade1: Annotated[
        basic.cTkDynamicArray[cGcSettlementStatValueRange],
        Field(basic.cTkDynamicArray[cGcSettlementStatValueRange], 0x10),
    ]
    Upgrade2: Annotated[
        basic.cTkDynamicArray[cGcSettlementStatValueRange],
        Field(basic.cTkDynamicArray[cGcSettlementStatValueRange], 0x20),
    ]
    Upgrade3: Annotated[
        basic.cTkDynamicArray[cGcSettlementStatValueRange],
        Field(basic.cTkDynamicArray[cGcSettlementStatValueRange], 0x30),
    ]


@partial_struct
class cGcPortalData(Structure):
    RuneRotateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    KnowAllRunes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    SkipRuneEntry: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcSentinelSpawnData(Structure):
    MaxAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MinAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    Type: Annotated[
        c_enum32[enums.cGcSentinelTypes], Field(c_enum32[enums.cGcSentinelTypes], 0x8)
    ]


@partial_struct
class cGcSentinelSpawnSequenceStep(Structure):
    WavePool: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcSentinelSpawnNamedSequence(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Waves: Annotated[
        basic.cTkDynamicArray[cGcSentinelSpawnSequenceStep],
        Field(basic.cTkDynamicArray[cGcSentinelSpawnSequenceStep], 0x10),
    ]


@partial_struct
class cGcPersistencyMissionOverride(Structure):
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Buffer: Annotated[
        c_enum32[enums.cGcInteractionBufferType],
        Field(c_enum32[enums.cGcInteractionBufferType], 0x10),
    ]


@partial_struct
class cGcSentinelSpawnSequence(Structure):
    Waves: Annotated[
        basic.cTkDynamicArray[cGcSentinelSpawnSequenceStep],
        Field(basic.cTkDynamicArray[cGcSentinelSpawnSequenceStep], 0x0),
    ]


@partial_struct
class cGcPlayerExperienceAsteroidCreatureSpawnData(Structure):
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LargeMinMax: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    MediumMinMax: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x18)]
    SmallMinMax: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcSentinelSpawnSequenceGroup(Structure):
    ExtremeSequence: Annotated[
        cGcSentinelSpawnSequence, Field(cGcSentinelSpawnSequence, 0x0)
    ]
    Sequence: Annotated[cGcSentinelSpawnSequence, Field(cGcSentinelSpawnSequence, 0x10)]


@partial_struct
class cGcPlayerExperienceAsteroidCreatureSpawnTable(Structure):
    LargeAsteroidSpawns: Annotated[
        basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData],
        Field(basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData], 0x0),
    ]
    MediumAsteroidSpawns: Annotated[
        basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData],
        Field(
            basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData], 0x10
        ),
    ]
    SmallAsteroidSpawns: Annotated[
        basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData],
        Field(
            basic.cTkDynamicArray[cGcPlayerExperienceAsteroidCreatureSpawnData], 0x20
        ),
    ]
    LargeAsteroidSpawnPercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    MediumAsteroidSpawnPercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    SmallAsteroidSpawnPercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]


@partial_struct
class cGcSentinelSpawnSequenceGroupList(Structure):
    CorruptSequences: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    ExtremeSequences: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]
    Sequences: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]


@partial_struct
class cGcPlayerExperienceSpawnArchetypeData(Structure):
    AppearAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BehaviourOverrides: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x10),
    ]
    BehaviourTreeOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    BlackboardValues: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x30),
    ]
    DamageOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    DamageReceivedMultiplier: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    GenerateResource: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    KillingBlowMessageIDOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    KillStatIDOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    DespawnDistOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    HealthOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA4)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    ScaleVariation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    SpawnDistOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    SpeedMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    Type: Annotated[
        c_enum32[enums.cGcCreatureTypes], Field(c_enum32[enums.cGcCreatureTypes], 0xB8)
    ]
    AllowSpawnInAir: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBC)]


@partial_struct
class cGcPlayerExperienceSpawnData(Structure):
    SpawnLocatorScanEvent: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x0)]
    AppearAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Archetype: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    SpawnLocator: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    MaxNum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    MinNum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x60)]
    ActiveTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]

    class eFaceDirEnum(IntEnum):
        Random = 0x0
        TowardsPlayer = 0x1
        SpawnerAt = 0x2
        InFrontOfPlayer = 0x3

    FaceDir: Annotated[c_enum32[eFaceDirEnum], Field(c_enum32[eFaceDirEnum], 0x74)]
    MaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    MinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    PlayerFacingOffsetMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]


@partial_struct
class cGcPlayerExperienceSpawnTable(Structure):
    Event: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Spawns: Annotated[
        basic.cTkDynamicArray[cGcPlayerExperienceSpawnData],
        Field(basic.cTkDynamicArray[cGcPlayerExperienceSpawnData], 0x10),
    ]

    class eExperienceSpawnTypeEnum(IntEnum):
        Freighter = 0x0
        Mission = 0x1

    ExperienceSpawnType: Annotated[
        c_enum32[eExperienceSpawnTypeEnum],
        Field(c_enum32[eExperienceSpawnTypeEnum], 0x20),
    ]
    InitialDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    PerSpawnDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ResponseRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    Destroy: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcPoliceSpawnWaveData(Structure):
    ShipData: Annotated[cGcAIShipSpawnData, Field(cGcAIShipSpawnData, 0x0)]
    MaxCountsForFireteamSize: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x160)]


@partial_struct
class cGcInteractionActivationCost(Structure):
    AltIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    OnlyChargeDuringSeasons: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x10),
    ]
    RequiredTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    StartMissionOnCantAfford: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    SubstanceId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    UseCostID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    Cost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x60)]
    Repeat: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]


@partial_struct
class cGcInteractionBaseBuildingState(Structure):
    TriggerAction: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Time: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcFiendCrimeSpawnData(Structure):
    MaxNum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MinNum: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    MinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Type: Annotated[
        c_enum32[enums.cGcCreatureTypes], Field(c_enum32[enums.cGcCreatureTypes], 0x28)
    ]


@partial_struct
class cGcAntagonistEnemy(Structure):
    Perceptions: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    GrudgeFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    HatredFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcAntagonistFriend(Structure):
    Perceptions: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    ArticulationFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]


@partial_struct
class cGcAntagonistPerception(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Range: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]

    class eViewShapeEnum(IntEnum):
        Pyramid = 0x0
        Cone = 0x1

    ViewShape: Annotated[
        c_enum32[eViewShapeEnum], Field(c_enum32[eViewShapeEnum], 0x14)
    ]
    XFOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    YFOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    SenseLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    Raycast: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]


@partial_struct
class cGcDroneGun(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    RequiredDestructibles: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x10),
    ]
    Locator: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    LaunchDuringAnim: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]
    MirrorAnim: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41)]


@partial_struct
class cGcBasePlacementComponentData(Structure):
    Rules: Annotated[
        basic.cTkDynamicArray[cGcBasePlacementRule],
        Field(basic.cTkDynamicArray[cGcBasePlacementRule], 0x0),
    ]


@partial_struct
class cGcFontTableEntry(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    LargeOverrideFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    VROverrideFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Spacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcFontTable(Structure):
    Fonts: Annotated[
        basic.cTkDynamicArray[cGcFontTableEntry],
        Field(basic.cTkDynamicArray[cGcFontTableEntry], 0x0),
    ]
    Language: Annotated[
        c_enum32[enums.cTkLanguages], Field(c_enum32[enums.cTkLanguages], 0x10)
    ]


@partial_struct
class cGcEntitlementRewardData(Structure):
    Error: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    EntitlementId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    RewardId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]


@partial_struct
class cTkEntitlementListData(Structure):
    EntitlementId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ServiceID: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)
    ]


@partial_struct
class cGcCutSceneTriggerActionData(Structure):
    Action: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    GroupFilter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    IdFilter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Parameter: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]


@partial_struct
class cGcConstraintsToCreateSpec(Structure):
    PushingStrength_Diagonal_1x1_0011: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x0)
    ]
    PushingStrength_Diagonal_1x1_0110: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x4)
    ]
    PushingStrength_Horizontal_1x0: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x8)
    ]
    PushingStrength_Horizontal_2x0: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xC)
    ]
    PushingStrength_SkewedDiagonal_2x1_0012: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x10)
    ]
    PushingStrength_SkewedDiagonal_2x1_0021: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x14)
    ]
    PushingStrength_SkewedDiagonal_2x1_1002: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18)
    ]
    PushingStrength_SkewedDiagonal_2x1_2001: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1C)
    ]
    PushingStrength_Vertical_1x0: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    PushingStrength_Vertical_2x0: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Diagonal_1x1_0011: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    Diagonal_1x1_0110: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    Horizontal_1x0: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    Horizontal_2x0: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    SkewedDiagonal_2x1_0012: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    SkewedDiagonal_2x1_0021: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    SkewedDiagonal_2x1_1002: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    SkewedDiagonal_2x1_2001: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]
    Vertical_1x0: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    Vertical_2x0: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcByteBeatSong(Structure):
    LocID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RequiredSpecialId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Data: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x40)]
    AuthorOnlineID: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x240)
    ]
    AuthorPlatform: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x280)
    ]
    AuthorUsername: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x2C0)
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x300)]


@partial_struct
class cGcByteBeatLibraryData(Structure):
    MySongs: Annotated[cGcByteBeatSong, Field(cGcByteBeatSong, 0x0)]
    Playlist: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1900)]
    AutoplayInShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A00)]
    AutoplayInVehicle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A01)]
    AutoplayOnFoot: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A02)]
    Shuffle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A03)]


@partial_struct
class cGcByteBeatTemplate(Structure):
    Children: Annotated[
        "basic.cTkDynamicArray[cGcByteBeatTemplate]",
        Field("basic.cTkDynamicArray[cGcByteBeatTemplate]", 0x0),
    ]
    MaxValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    MinValue: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    TokenType: Annotated[
        c_enum32[enums.cGcByteBeatToken], Field(c_enum32[enums.cGcByteBeatToken], 0x18)
    ]
    Weight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcAdvancedTweaks(Structure):
    NodesThatMustBePresent: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0x0),
    ]
    NodesToHide: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0x10),
    ]
    EdgeMultiplierForTangentI: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    EdgeMultiplierForTangentJ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    ParticleKillSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ParticleKillSpeedWrtFixed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    RenderNormalMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    StretchUvsToHideTextureEdges: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    LeaveRenderedTrianglesUnaffected: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x38)
    ]


@partial_struct
class cGcAttachedNode(Structure):
    RelativeTransform_Axis0: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    RelativeTransform_Axis1: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    RelativeTransform_Axis2: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    RelativeTransform_Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    BlendStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MaxRenderIFraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MaxRenderJFraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MinRenderIFraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MinRenderJFraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    NodeName: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x54)]
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x94)]


@partial_struct
class cGcByteBeatDrum(Structure):
    AttackEnvelope: Annotated[
        c_enum32[enums.cGcByteBeatEnvelope],
        Field(c_enum32[enums.cGcByteBeatEnvelope], 0x0),
    ]

    class eAugmentModeEnum(IntEnum):
        Add = 0x0
        Multiply = 0x1
        Max = 0x2

    AugmentMode: Annotated[
        c_enum32[eAugmentModeEnum], Field(c_enum32[eAugmentModeEnum], 0x4)
    ]
    AugmentOverdrive: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AugmentPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    AugmentPitchFalloff: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AugmentPitchFalloffPower: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AugmentSineNoiseMix: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    AugmentVolume: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    DecayEnvelope: Annotated[
        c_enum32[enums.cGcByteBeatEnvelope],
        Field(c_enum32[enums.cGcByteBeatEnvelope], 0x20),
    ]
    Duration: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    OctaveShift: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Volume: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    WaveType: Annotated[
        c_enum32[enums.cGcByteBeatWave], Field(c_enum32[enums.cGcByteBeatWave], 0x30)
    ]
    Tree: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x34)]


@partial_struct
class cGcAttachmentPointData(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    SimP: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]


@partial_struct
class cGcAttachmentPointSet(Structure):
    AttachmentPoints: Annotated[
        basic.cTkDynamicArray[cGcAttachmentPointData],
        Field(basic.cTkDynamicArray[cGcAttachmentPointData], 0x0),
    ]
    AttractionStartDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AttractionStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    NumSimI: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x18)]
    NumSimJ: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]
    JointName: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x20)
    ]
    Name: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x60)]
    Enabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA0)]


@partial_struct
class cGcByteBeatJukeboxData(Structure):
    Playlist: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Playing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x100)]
    Shuffle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x101)]


@partial_struct
class cGcAudio3PointDopplerData(Structure):
    Front: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Mid: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    Rear: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcAudioNPCDoppler(Structure):
    Config: Annotated[cGcAudio3PointDopplerData, Field(cGcAudio3PointDopplerData, 0x0)]


@partial_struct
class cGcAlienPodAnimParams(Structure):
    Intensity: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcThirdPersonAnimParams(Structure):
    AimDirection: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    MoveForce: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    Velocity: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    VelocityXY: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x18)]
    AimPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AimYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    DistanceFromGround: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Foot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    HitFB: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    HitLR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    LeanFB: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    LeanLR: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    MoveForceApplied: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SlopeAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    TimeSinceJetpackEngaged: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    TurnAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    Uphill: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    VelocityY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    VelocityZ: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]


@partial_struct
class cGcAtlasSendSubmitContribution(Structure):
    Contribution: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    MissionIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]


@partial_struct
class cTkPhysicsComponentData(Structure):
    Data: Annotated[cTkPhysicsData, Field(cTkPhysicsData, 0x0)]

    class eModelOwnershipEnum(IntEnum):
        Model = 0x0
        MasterModel = 0x1
        None_ = 0x2

    ModelOwnership: Annotated[
        c_enum32[eModelOwnershipEnum], Field(c_enum32[eModelOwnershipEnum], 0x18)
    ]
    SimpleCharacterCollisionFwdOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1C)
    ]
    SimpleCharacterCollisionHeight: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x20)
    ]
    SimpleCharacterCollisionHeightOffset: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x24)
    ]
    SimpleCharacterCollisionRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x28)
    ]
    SpinOnCreate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]

    class eSurfacePropertiesEnum(IntEnum):
        None_ = 0x0
        Glass = 0x1

    SurfaceProperties: Annotated[
        c_enum32[eSurfacePropertiesEnum], Field(c_enum32[eSurfacePropertiesEnum], 0x30)
    ]
    TriggerVolumeType: Annotated[
        c_enum32[enums.cTkVolumeTriggerType],
        Field(c_enum32[enums.cTkVolumeTriggerType], 0x34),
    ]
    AllowedDefaultCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]
    AllowTeleporter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x39)]
    Animated: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A)]
    BlocksInteract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3B)]
    BlockTeleporter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]
    CameraInvisible: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3D)]
    CanBeTooSteepForTeleporter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3E)]
    Climbable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3F)]
    DisableGravity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x40)]
    Floor: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x41)]
    IgnoreAllCollisions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x42)]
    IgnoreModelOwner: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43)]
    InvisibleForInteraction: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    IsTransporter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]
    NoFallDamage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46)]
    NoFireCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x47)]
    NoPlayerCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    NoTerrainCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]
    NoVehicleCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4A)]
    RotateSimpleCharacterCollisionCapsule: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4B)
    ]
    ScaleAffectsMass: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]
    TriggerVolume: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4D)]
    UseBasePartOptimisation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E)]
    UseSimpleCharacterCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4F)]
    Walkable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]


@partial_struct
class cTkAnimPoseComponentData(Structure):
    BabyModifiers: Annotated[
        basic.cTkDynamicArray[cTkAnimPoseBabyModifier],
        Field(basic.cTkDynamicArray[cTkAnimPoseBabyModifier], 0x0),
    ]
    CorrelationMat: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x10),
    ]
    Correlations: Annotated[
        basic.cTkDynamicArray[cTkAnimPoseCorrelationData],
        Field(basic.cTkDynamicArray[cTkAnimPoseCorrelationData], 0x20),
    ]
    Examples: Annotated[
        basic.cTkDynamicArray[cTkAnimPoseExampleData],
        Field(basic.cTkDynamicArray[cTkAnimPoseExampleData], 0x30),
    ]
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    PoseAnims: Annotated[
        basic.cTkDynamicArray[cTkAnimPoseData],
        Field(basic.cTkDynamicArray[cTkAnimPoseData], 0x50),
    ]
    AdultCorrelationValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    DisableForAnimOverrides: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]
    ShouldRandomise: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x65)]


@partial_struct
class cTkSketchComponentData(Structure):
    Nodes: Annotated[
        basic.cTkDynamicArray[cTkSketchNodeData],
        Field(basic.cTkDynamicArray[cTkSketchNodeData], 0x0),
    ]
    GraphPosX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    GraphPosY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    GraphZoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    UpdateRateMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcBootLogoData(Structure):
    DisplayTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Textures: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10)
    ]


@partial_struct
class cTkAnimDetailSettingsTable(Structure):
    Table: Annotated[cTkAnimDetailSettings, Field(cTkAnimDetailSettings, 0x0)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]


@partial_struct
class cGcTechnologyAttachmentComponentData(Structure):
    Techs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]

    class eInventoryEnum(IntEnum):
        Vehicle = 0x0

    Inventory: Annotated[
        c_enum32[eInventoryEnum], Field(c_enum32[eInventoryEnum], 0x10)
    ]
    Inverted: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]


@partial_struct
class cGcTriggerActionComponentData(Structure):
    PersistentState: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    States: Annotated[
        basic.cTkDynamicArray[cGcActionTriggerState],
        Field(basic.cTkDynamicArray[cGcActionTriggerState], 0x10),
    ]
    HideModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]
    LinkStateToBaseGrid: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x21)]
    Persistent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22)]
    ResetShotTimeOnStateChange: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23)]
    StartInactive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cGcPlayerCharacterComponentData(Structure):
    IntialPlayerControlMode: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    JetpackEffects: Annotated[
        basic.cTkDynamicArray[cGcCharacterJetpackEffect],
        Field(basic.cTkDynamicArray[cGcCharacterJetpackEffect], 0x10),
    ]
    PlayerControlModes: Annotated[
        basic.cTkDynamicArray[cGcPlayerControlModeEntry],
        Field(basic.cTkDynamicArray[cGcPlayerControlModeEntry], 0x20),
    ]


@partial_struct
class cGcCharacterInterfaceComponentData(Structure):
    pass


@partial_struct
class cGcBuildableSpaceshipComponentData(Structure):
    InitialLayouts: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cGcNPCComponentData(Structure):
    AlternateAnims: Annotated[
        basic.cTkDynamicArray[cGcCharacterAlternateAnimation],
        Field(basic.cTkDynamicArray[cGcCharacterAlternateAnimation], 0x0),
    ]
    HologramEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Tags: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    Race: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x30)
    ]
    IsMech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]
    IsOldStyleNPC: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35)]


@partial_struct
class cTkMaterialData(Structure):
    Flags: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cTkMaterialFlags]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cTkMaterialFlags]], 0x0),
    ]
    FxFlags: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cTkMaterialFxFlags]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cTkMaterialFxFlags]], 0x10),
    ]
    Link: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Metamaterial: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    Name: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)]
    Samplers: Annotated[
        basic.cTkDynamicArray[cTkMaterialSampler],
        Field(basic.cTkDynamicArray[cTkMaterialSampler], 0x50),
    ]
    Shader: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)]
    Uniforms_Float: Annotated[
        basic.cTkDynamicArray[cTkMaterialUniform_Float],
        Field(basic.cTkDynamicArray[cTkMaterialUniform_Float], 0x70),
    ]
    Uniforms_UInt: Annotated[
        basic.cTkDynamicArray[cTkMaterialUniform_UInt],
        Field(basic.cTkDynamicArray[cTkMaterialUniform_UInt], 0x80),
    ]
    ShaderMillDataHash: Annotated[ctypes.c_int64, Field(ctypes.c_int64, 0x90)]
    TransparencyLayerID: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x98)]
    Class: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x9C)]
    CastShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBC)]
    CreateFur: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBD)]
    DisableZTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBE)]
    EnableLodFade: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBF)]
    UseShaderMill: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC0)]


@partial_struct
class cGcCreatureComponentData(Structure):
    DiscoveryUIOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    PetLargeUIOverrideOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    DeathEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DeathEffectTrail: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    PetAccessoryNodes: Annotated[
        basic.cTkDynamicArray[basic.HashedString],
        Field(basic.cTkDynamicArray[basic.HashedString], 0x50),
    ]
    ReplacementImpacts: Annotated[
        basic.cTkDynamicArray[cGcReplacementEffectData],
        Field(basic.cTkDynamicArray[cGcReplacementEffectData], 0x60),
    ]
    ThumbnailOverrides: Annotated[
        basic.cTkDynamicArray[cGcCreatureDiscoveryThumbnailOverride],
        Field(basic.cTkDynamicArray[cGcCreatureDiscoveryThumbnailOverride], 0x70),
    ]
    AccessoryPitchOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    Axis: Annotated[
        c_enum32[enums.cGcPrimaryAxis], Field(c_enum32[enums.cGcPrimaryAxis], 0x84)
    ]
    DeathEffectScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    DeathFadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    DiscoveryFurScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    DiscoveryUIScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    NavRadiusModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    PetIndoorScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    PetLargeUIOverrideScaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    Scaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    UnderwaterRagdollAnimStrength: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xA8)
    ]
    UnderwaterRagdollAnimTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    UnderwaterRagdollDamping: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    UnderwaterRagdollDampingTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    UnderwaterRagdollGravityScale: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xB8)
    ]
    UnderwaterRagdollSpinStrength: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xBC)
    ]
    UnderwaterRagdollSpinTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    UsePetLargeUIOverride: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC4)]
    UseStandardWaterPusher: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xC5)]


@partial_struct
class cGcLanguageFontTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcFontTable],
        Field(basic.cTkDynamicArray[cGcFontTable], 0x0),
    ]


@partial_struct
class cGcPunctuationDelayTable(Structure):
    PunctuationDelays: Annotated[
        cGcPunctuationDelayData, Field(cGcPunctuationDelayData, 0x0)
    ]


@partial_struct
class cGcNGuiSpecialTextImages(Structure):
    SpecialImages: Annotated[
        basic.cTkDynamicArray[cGcNGuiSpecialTextImageData],
        Field(basic.cTkDynamicArray[cGcNGuiSpecialTextImageData], 0x0),
    ]


@partial_struct
class cGcNGuiSpecialTextStyles(Structure):
    SpecialStyles: Annotated[
        basic.cTkDynamicArray[cGcNGuiSpecialTextStyleData],
        Field(basic.cTkDynamicArray[cGcNGuiSpecialTextStyleData], 0x0),
    ]


@partial_struct
class cGcLightingRigComponentData(Structure):
    LightData: Annotated[
        basic.cTkDynamicArray[cGcHeroLightData],
        Field(basic.cTkDynamicArray[cGcHeroLightData], 0x0),
    ]
    PitchAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    PitchAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cTkMeshWaterQualitySettings(Structure):
    MeshWaterQualitySettings: Annotated[
        cTkMeshWaterQualitySettingData, Field(cTkMeshWaterQualitySettingData, 0x0)
    ]
    MeshWaterReflectionQualitySettings: Annotated[
        cTkMeshWaterReflectionQualitySettingData,
        Field(cTkMeshWaterReflectionQualitySettingData, 0xB0),
    ]


@partial_struct
class cGcTexturePrefetchData(Structure):
    Textures: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cGcAudioPulseDemo(Structure):
    InWarp: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x0)]
    Planet: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x8)]
    Space: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]
    SpaceStation: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x18)]
    Wanted: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    MixRateSeconds: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]


@partial_struct
class cGcBaseBuildingPartsDataTable(Structure):
    PartsData: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingPartData],
        Field(basic.cTkDynamicArray[cGcBaseBuildingPartData], 0x0),
    ]


@partial_struct
class cGcGeneratedBaseTemplatesTable(Structure):
    DecorationTemplates: Annotated[
        basic.cTkDynamicArray[cGcGeneratedBaseDecorationTemplate],
        Field(basic.cTkDynamicArray[cGcGeneratedBaseDecorationTemplate], 0x0),
    ]
    PruningRules: Annotated[
        basic.cTkDynamicArray[cGcGeneratedBasePruningRule],
        Field(basic.cTkDynamicArray[cGcGeneratedBasePruningRule], 0x10),
    ]
    RoomTemplates: Annotated[
        basic.cTkDynamicArray[cGcGeneratedBaseRoomTemplate],
        Field(basic.cTkDynamicArray[cGcGeneratedBaseRoomTemplate], 0x20),
    ]
    ThemeTemplates: Annotated[
        basic.cTkDynamicArray[cGcGeneratedBaseThemeTemplate],
        Field(basic.cTkDynamicArray[cGcGeneratedBaseThemeTemplate], 0x30),
    ]


@partial_struct
class cTkStaticPhysicsComponentData(Structure):
    Data: Annotated[cTkPhysicsData, Field(cTkPhysicsData, 0x0)]
    NavMeshInclusion: Annotated[
        cTkNavMeshInclusionParams, Field(cTkNavMeshInclusionParams, 0x18)
    ]

    class eStaticPhysicsTargetNodeEnum(IntEnum):
        Attachment = 0x0
        MasterModel = 0x1

    StaticPhysicsTargetNode: Annotated[
        c_enum32[eStaticPhysicsTargetNodeEnum],
        Field(c_enum32[eStaticPhysicsTargetNodeEnum], 0x20),
    ]
    TriggerVolumeType: Annotated[
        c_enum32[enums.cTkVolumeTriggerType],
        Field(c_enum32[enums.cTkVolumeTriggerType], 0x24),
    ]
    AddToWorldImmediately: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    AddToWorldOnPrepare: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    CameraInvisible: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    Climbable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    NoPlayerCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    NoTerrainCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    NoVehicleCollide: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    TriggerVolume: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]


@partial_struct
class cGcBuildingModeCondition(Structure):
    ValidBuildingModes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcBaseBuildingPartsNavDataTable(Structure):
    Parts: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingPartNavData],
        Field(basic.cTkDynamicArray[cGcBaseBuildingPartNavData], 0x0),
    ]


@partial_struct
class cGcBaseObjectDescriptorComponentData(Structure):
    ProcSceneFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    ForceShowPickUpLabel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]


@partial_struct
class cGcCockpitComponentData(Structure):
    Cockpit: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    FoVFixedDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    MaxHeadPitchDown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MaxHeadPitchUp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MaxHeadTurn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]


@partial_struct
class cGcFishingRodTable(Structure):
    FishingRodResource: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    FishingRods: Annotated[
        basic.cTkDynamicArray[cGcFishingRodData],
        Field(basic.cTkDynamicArray[cGcFishingRodData], 0x10),
    ]


@partial_struct
class cGcEntitlementRewardsTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcEntitlementRewardData],
        Field(basic.cTkDynamicArray[cGcEntitlementRewardData], 0x0),
    ]


@partial_struct
class cGcPlayerMissionUpgradeMapTable(Structure):
    MissionProgressTable: Annotated[
        basic.cTkDynamicArray[cGcPlayerMissionUpgradeMapEntry],
        Field(basic.cTkDynamicArray[cGcPlayerMissionUpgradeMapEntry], 0x0),
    ]


@partial_struct
class cGcInventoryStoreBalance(Structure):
    DeconstructRefundPercentage: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    PlayerPersonalInventoryCargoHeight: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x4)
    ]
    PlayerPersonalInventoryCargoWidth: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x8)
    ]
    PlayerPersonalInventoryTechHeight: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0xC)
    ]
    PlayerPersonalInventoryTechWidth: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x10)
    ]


@partial_struct
class cGcPlayerMissionProgressMapTable(Structure):
    MissionProgressTable: Annotated[
        basic.cTkDynamicArray[cGcPlayerMissionProgressMapEntry],
        Field(basic.cTkDynamicArray[cGcPlayerMissionProgressMapEntry], 0x0),
    ]


@partial_struct
class cTkGraphicsSettings(Structure):
    MonitorNames: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x100],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x100], 0x0),
    ]
    GraphicsDetail: Annotated[
        cTkGraphicsDetailPreset, Field(cTkGraphicsDetailPreset, 0x10)
    ]
    AdapterIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    Brightness: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x78)]
    FoVInShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    FoVOnFoot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]

    class eHDRModeEnum(IntEnum):
        Off = 0x0
        HDR400 = 0x1
        HDR600 = 0x2
        HDR1000 = 0x3

    HDRMode: Annotated[c_enum32[eHDRModeEnum], Field(c_enum32[eHDRModeEnum], 0x84)]
    MaxframeRate: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x88)]
    Monitor: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8C)]
    MotionBlurStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    MouseClickSpeedMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    NumGraphicsThreadsBeta: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x98)]
    NumHighThreads: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x9C)]
    NumLowThreads: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA0)]
    ResolutionHeight: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xA4)]
    ResolutionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    ResolutionWidth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xAC)]
    RetinaScaleIOS: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]

    class eTextureStreamingVkEnum(IntEnum):
        Off = 0x0
        On = 0x1
        Auto = 0x2
        NonDynamic = 0x3

    TextureStreamingVk: Annotated[
        c_enum32[eTextureStreamingVkEnum],
        Field(c_enum32[eTextureStreamingVkEnum], 0xB4),
    ]
    Version: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB8)]

    class eVsyncExEnum(IntEnum):
        Off = 0x0
        On = 0x1
        Adaptive = 0x2
        Triple = 0x3

    VsyncEx: Annotated[c_enum32[eVsyncExEnum], Field(c_enum32[eVsyncExEnum], 0xBC)]
    AdapterName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xC0)
    ]
    Borderless: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C0)]
    FullScreen: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C1)]
    RemoveBaseBuildingRestrictions: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x1C2)
    ]
    ShowRequirementsWarnings: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C3)]
    UseArbSparseTexture: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C4)]
    UseTerrainTextureCache: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C5)]
    VignetteAndScanlines: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C6)]


@partial_struct
class cGcPetAccessoryTable(Structure):
    Accessories: Annotated[cGcPetAccessoryInfo, Field(cGcPetAccessoryInfo, 0x0)]
    AccessoryGroups: Annotated[
        basic.cTkDynamicArray[cGcPetAccessoryGroup],
        Field(basic.cTkDynamicArray[cGcPetAccessoryGroup], 0x3C0),
    ]


@partial_struct
class cGcPetEggSpeciesOverrideTable(Structure):
    SpeciesOverrides: Annotated[
        basic.cTkDynamicArray[cGcPetEggSpeciesOverrideData],
        Field(basic.cTkDynamicArray[cGcPetEggSpeciesOverrideData], 0x0),
    ]


@partial_struct
class cTkNetReplicatedEntityComponentData(Structure):
    ReplicaComponentMask: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0x0),
    ]

    class eReplicationRangeEnum(IntEnum):
        NotSet = 0x0
        System = 0x1
        SystemLocal = 0x2
        Planet = 0x3
        PlanetLocal = 0x4
        Space = 0x5
        SpaceStation = 0x6
        Nexus = 0x7

    ReplicationRange: Annotated[
        c_enum32[eReplicationRangeEnum], Field(c_enum32[eReplicationRangeEnum], 0x10)
    ]

    class eSpawnTypeEnum(IntEnum):
        Basic = 0x0
        Creature = 0x1

    SpawnType: Annotated[
        c_enum32[eSpawnTypeEnum], Field(c_enum32[eSpawnTypeEnum], 0x14)
    ]
    IgnoreComponents: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    ReplicateToShipmates: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]


@partial_struct
class cGcCustomisationTextureOptions(Structure):
    MultiTextureOptions: Annotated[
        basic.cTkDynamicArray[cGcCustomisationMultiTextureOption],
        Field(basic.cTkDynamicArray[cGcCustomisationMultiTextureOption], 0x0),
    ]
    TextureOptions: Annotated[
        basic.cTkDynamicArray[cGcCustomisationTextureOption],
        Field(basic.cTkDynamicArray[cGcCustomisationTextureOption], 0x10),
    ]


@partial_struct
class cGcCustomisationColourPalettes(Structure):
    CustomisationTypePalettes: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Palettes: Annotated[
        basic.cTkDynamicArray[cGcCustomisationColourPalette],
        Field(basic.cTkDynamicArray[cGcCustomisationColourPalette], 0x1A0),
    ]


@partial_struct
class cGcCustomisationBannerGroup(Structure):
    BackgroundColours: Annotated[cGcPaletteData, Field(cGcPaletteData, 0x0)]
    MainColours: Annotated[cGcPaletteData, Field(cGcPaletteData, 0x410)]
    BackgroundColoursExtraData: Annotated[
        cGcCustomisationColourPaletteExtraData,
        Field(cGcCustomisationColourPaletteExtraData, 0x820),
    ]
    MainColoursExtraData: Annotated[
        cGcCustomisationColourPaletteExtraData,
        Field(cGcCustomisationColourPaletteExtraData, 0x840),
    ]
    BannerImages: Annotated[
        basic.cTkDynamicArray[cGcCustomisationBannerImageData],
        Field(basic.cTkDynamicArray[cGcCustomisationBannerImageData], 0x860),
    ]


@partial_struct
class cGcCustomisationShipBobbleHeads(Structure):
    BobbleHeads: Annotated[
        basic.cTkDynamicArray[cGcCustomisationBobbleHead],
        Field(basic.cTkDynamicArray[cGcCustomisationBobbleHead], 0x0),
    ]


@partial_struct
class cGcCustomisationThrusterEffects(Structure):
    BackpackData: Annotated[
        basic.cTkDynamicArray[cGcCustomisationBackpackData],
        Field(basic.cTkDynamicArray[cGcCustomisationBackpackData], 0x0),
    ]
    FreighterEngineEffects: Annotated[
        basic.cTkDynamicArray[cGcCustomisationFreighterEngineEffect],
        Field(basic.cTkDynamicArray[cGcCustomisationFreighterEngineEffect], 0x10),
    ]
    JetpackEffects: Annotated[
        basic.cTkDynamicArray[cGcCustomisationThrusterEffect],
        Field(basic.cTkDynamicArray[cGcCustomisationThrusterEffect], 0x20),
    ]
    ShipEffects: Annotated[
        basic.cTkDynamicArray[cGcCustomisationShipTrails],
        Field(basic.cTkDynamicArray[cGcCustomisationShipTrails], 0x30),
    ]


@partial_struct
class cGcSaveContextDataMaskTable(Structure):
    Masks: Annotated[
        basic.cTkDynamicArray[cGcSaveContextDataMaskTableEntry],
        Field(basic.cTkDynamicArray[cGcSaveContextDataMaskTableEntry], 0x0),
    ]
    Default: Annotated[cGcSaveContextDataMask, Field(cGcSaveContextDataMask, 0x10)]


@partial_struct
class cGcUserSettingsData(Structure):
    CustomBindingsMac: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x0),
    ]
    CustomBindingsPC: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x10),
    ]
    CustomBindingsPlaystation: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x20),
    ]
    CustomBindingsSwitch: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x30),
    ]
    CustomBindingsXbox: Annotated[
        basic.cTkDynamicArray[cGcInputActionMapping2],
        Field(basic.cTkDynamicArray[cGcInputActionMapping2], 0x40),
    ]
    SeenProducts: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x50),
    ]
    SeenSubstances: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x60),
    ]
    SeenTechnologies: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x70),
    ]
    SeenWikiTopics: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x80),
    ]
    UnlockedPlatformRewards: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x90),
    ]
    UnlockedSeasonRewards: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0xA0),
    ]
    UnlockedSpecials: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0xB0),
    ]
    UnlockedTitles: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0xC0),
    ]
    UnlockedTwitchRewards: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0xD0),
    ]
    UnlockedWikiTopics: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0xE0),
    ]
    UpgradedUsers: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0xF0),
    ]
    BlockList: Annotated[cGcBlockListPersistence, Field(cGcBlockListPersistence, 0x100)]
    GyroSettings: Annotated[cGcGyroSettingsData, Field(cGcGyroSettingsData, 0x3950)]

    class eBaseSharingModeEnum(IntEnum):
        Undecided = 0x0
        On = 0x1
        Off = 0x2

    BaseSharingMode: Annotated[
        c_enum32[eBaseSharingModeEnum], Field(c_enum32[eBaseSharingModeEnum], 0x39C4)
    ]
    CamerShakeStrength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39C8)]

    class eConsoleHFREnum(IntEnum):
        False_ = 0x0
        True_ = 0x1

    ConsoleHFR: Annotated[
        c_enum32[eConsoleHFREnum], Field(c_enum32[eConsoleHFREnum], 0x39CC)
    ]
    CrossSavesUploadTimeout: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x39D0)]
    CursorSensitivityMode1: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39D4)]
    CursorSensitivityMode2: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39D8)]
    DominantHand: Annotated[
        c_enum32[enums.cGcHand], Field(c_enum32[enums.cGcHand], 0x39DC)
    ]

    class eEyeTrackingFlagsEnum(IntEnum):
        empty = 0x0
        BaseBuilding = 0x1
        WristMenus = 0x2
        Menus = 0x4

    EyeTrackingFlags: Annotated[
        c_enum32[eEyeTrackingFlagsEnum], Field(c_enum32[eEyeTrackingFlagsEnum], 0x39E0)
    ]
    Filter: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39E4)]
    FireteamSessionCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39E8)]
    FlightSensitivityMode1: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39EC)]
    FlightSensitivityMode2: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39F0)]
    FrontendZoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x39F4)]
    HazardEffectsStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x39F8)]
    HeadsetVibrationStrength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x39FC)]

    class eHighResVRUIEnum(IntEnum):
        High = 0x0
        Low = 0x1

    HighResVRUI: Annotated[
        c_enum32[eHighResVRUIEnum], Field(c_enum32[eHighResVRUIEnum], 0x3A00)
    ]
    HUDZoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A04)]
    Language: Annotated[
        c_enum32[enums.cTkLanguages], Field(c_enum32[enums.cTkLanguages], 0x3A08)
    ]
    LastSeenCommunityMission: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A0C)]
    LastSeenCommunityMissionTier: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x3A10)
    ]
    LookSensitivityMode1: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A14)]
    LookSensitivityMode2: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A18)]
    MotionBlurAmount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A1C)]
    MouseSpringSmoothing: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A20)]
    MovementDirectionHands: Annotated[
        c_enum32[enums.cGcMovementDirection],
        Field(c_enum32[enums.cGcMovementDirection], 0x3A24),
    ]
    MovementDirectionPad: Annotated[
        c_enum32[enums.cGcMovementDirection],
        Field(c_enum32[enums.cGcMovementDirection], 0x3A28),
    ]

    class eMovementModeEnum(IntEnum):
        Teleporter = 0x0
        Smooth = 0x1

    MovementMode: Annotated[
        c_enum32[eMovementModeEnum], Field(c_enum32[eMovementModeEnum], 0x3A2C)
    ]
    MusicVolume: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A30)]
    PlayerHUDVROffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A34)]

    class ePlayerVoiceEnum(IntEnum):
        Off = 0x0
        High = 0x1
        Low = 0x2
        Alien = 0x3

    PlayerVoice: Annotated[
        c_enum32[ePlayerVoiceEnum], Field(c_enum32[ePlayerVoiceEnum], 0x3A38)
    ]

    class ePS4FixedFPSEnum(IntEnum):
        Invalid = 0x0
        True_ = 0x1
        False_ = 0x2
        MaxPerformance = 0x3

    PS4FixedFPS: Annotated[
        c_enum32[ePS4FixedFPSEnum], Field(c_enum32[ePS4FixedFPSEnum], 0x3A3C)
    ]
    PS4FOVFoot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A40)]
    PS4FOVShip: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A44)]
    ScreenBrightness: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A48)]
    SfxVolume: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A4C)]
    ShipHUDVROffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A50)]

    class eSpaceCombatFollowModeEnum(IntEnum):
        Disabled = 0x0
        Hold = 0x1
        Toggle = 0x2

    SpaceCombatFollowMode: Annotated[
        c_enum32[eSpaceCombatFollowModeEnum],
        Field(c_enum32[eSpaceCombatFollowModeEnum], 0x3A54),
    ]

    class eSuitVoiceEnum(IntEnum):
        Off = 0x0
        High = 0x1
        Low = 0x2

    SuitVoice: Annotated[
        c_enum32[eSuitVoiceEnum], Field(c_enum32[eSuitVoiceEnum], 0x3A58)
    ]

    class eTemperatureUnitEnum(IntEnum):
        Invalid = 0x0
        C = 0x1
        F = 0x2
        K = 0x3

    TemperatureUnit: Annotated[
        c_enum32[eTemperatureUnitEnum], Field(c_enum32[eTemperatureUnitEnum], 0x3A5C)
    ]
    TriggerFeedbackStrength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A60)]

    class eTurnModeEnum(IntEnum):
        Smooth = 0x0
        Snap = 0x1

    TurnMode: Annotated[c_enum32[eTurnModeEnum], Field(c_enum32[eTurnModeEnum], 0x3A64)]

    class eUIColourSchemeEnum(IntEnum):
        Default = 0x0
        Protanopia = 0x1
        Deuteranopia = 0x2
        Tritanopia = 0x3

    UIColourScheme: Annotated[
        c_enum32[eUIColourSchemeEnum], Field(c_enum32[eUIColourSchemeEnum], 0x3A68)
    ]
    UnderwaterDepthOfFieldStrength: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3A6C)
    ]
    VibrationStrength: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A70)]
    VoiceVolume: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3A74)]
    VRVignetteStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A78)]
    AccessibleText: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A7C)]
    AllowWhiteScreenTransitions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A7D)]
    AutoRotateThirdPersonPlayerCamera: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3A7E)
    ]
    AutoScanDiscoveries: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A7F)]
    BaseBuildingShowOptionsFromVision: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3A80)
    ]
    BaseComplexityLimitsEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A81)]
    CrossPlatform: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A82)]
    CrossSaves: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A83)]
    CrossSavesAutoUploads: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A84)]
    CrossSavesSuppressAutoUploadTimeoutPopup: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3A85)
    ]
    DamageNumbers: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A86)]
    EnableControllerCursorInVR: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A87)]
    EnableLargeLobbies: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A88)]
    EnableModdingConsole: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A89)]
    HeadBob: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8A)]
    HighlightInteractableObjects: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8B)]
    HUDHidden: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8C)]
    IncreaseMissionTextContrast: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8D)]
    InstantUIDelete: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8E)]
    InstantUIInputs: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A8F)]
    InvertFlightControls: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A90)]
    InvertLookControls: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A91)]
    InvertVRInWorldFlightControls: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3A92)
    ]
    MoveableWristMenus: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A93)]
    Multiplayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A94)]
    PlaceJumpSwap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A95)]
    PS4VignetteAndScanlines: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A96)]
    PS5ProVRPSSR: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A97)]
    QuickMenuBuildMenuSwap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A98)]
    SpeechToText: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A99)]
    SpookHazardSkySpin: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9A)]
    SprintScanSwap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9B)]
    Translate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9C)]
    UseAutoTorch: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9D)]
    UseCharacterHeightForCamera: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9E)]
    UseOldMouseFlight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3A9F)]
    UseShipAutoControlVignette: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA0)]
    Vibration: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA1)]
    VoiceChat: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA2)]
    VRHandControllerEnableTwist: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA3)]
    VRHandControllerSwapYawAndRoll: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x3AA4)
    ]
    VRHeadBob: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA5)]
    VRShowBody: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA6)]
    VRVehiclesUseWorldControls: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA7)]
    XboxOneXHighResolutionMode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3AA8)]


@partial_struct
class cGcLeveledStatTable(Structure):
    LeveledStatTable: Annotated[
        basic.cTkDynamicArray[cGcLeveledStatData],
        Field(basic.cTkDynamicArray[cGcLeveledStatData], 0x0),
    ]


@partial_struct
class cGcJourneyMilestoneTable(Structure):
    JourneyMilestoneTable: Annotated[
        basic.cTkDynamicArray[cGcJourneyMilestoneData],
        Field(basic.cTkDynamicArray[cGcJourneyMilestoneData], 0x0),
    ]


@partial_struct
class cGcStatDefinitionTable(Structure):
    StatDefinitionTable: Annotated[
        basic.cTkDynamicArray[cGcStatDefinition],
        Field(basic.cTkDynamicArray[cGcStatDefinition], 0x0),
    ]


@partial_struct
class cGcStatGroupTable(Structure):
    StatGroupTable: Annotated[
        basic.cTkDynamicArray[cGcStatGroupData],
        Field(basic.cTkDynamicArray[cGcStatGroupData], 0x0),
    ]


@partial_struct
class cGcPaletteList(Structure):
    Palettes: Annotated[cGcPaletteData, Field(cGcPaletteData, 0x0)]


@partial_struct
class cGcByteBeatTemplates(Structure):
    HiHats: Annotated[
        basic.cTkDynamicArray[cGcByteBeatDrum],
        Field(basic.cTkDynamicArray[cGcByteBeatDrum], 0x0),
    ]
    InitialTrees: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x40],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x40], 0x10),
    ]
    KickDrums: Annotated[
        basic.cTkDynamicArray[cGcByteBeatDrum],
        Field(basic.cTkDynamicArray[cGcByteBeatDrum], 0x20),
    ]
    SnareDrums: Annotated[
        basic.cTkDynamicArray[cGcByteBeatDrum],
        Field(basic.cTkDynamicArray[cGcByteBeatDrum], 0x30),
    ]
    Songs: Annotated[
        basic.cTkDynamicArray[cGcByteBeatSong],
        Field(basic.cTkDynamicArray[cGcByteBeatSong], 0x40),
    ]
    Templates: Annotated[
        basic.cTkDynamicArray[cGcByteBeatTemplate],
        Field(basic.cTkDynamicArray[cGcByteBeatTemplate], 0x50),
    ]
    CombinerWeights: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    OperatorPermuteChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    TemplateCombineChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    TemplateCombineChanceAtRoot: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]


@partial_struct
class cGcByteBeatIcons(Structure):
    Icons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    SawTooth: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1B0)]
    Sine: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1C8)]
    Square: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1E0)]
    Triangle: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1F8)]


@partial_struct
class cGcCustomInventoryComponentData(Structure):
    DesiredTechs: Annotated[
        basic.cTkDynamicArray[cGcInventoryTechProbability],
        Field(basic.cTkDynamicArray[cGcInventoryTechProbability], 0x0),
    ]
    Size: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Cool: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x20)]


@partial_struct
class cGcScreenFilterTable(Structure):
    Filters: Annotated[cGcScreenFilterData, Field(cGcScreenFilterData, 0x0)]


@partial_struct
class cGcScannerIcons(Structure):
    ScannableColours: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    NetworkFSPlayerColours: Annotated[basic.Colour, Field(basic.Colour, 0x4B0)]
    BuildingColour: Annotated[basic.Colour, Field(basic.Colour, 0x4F0)]
    GenericColour: Annotated[basic.Colour, Field(basic.Colour, 0x500)]
    RelicColour: Annotated[basic.Colour, Field(basic.Colour, 0x510)]
    SignalColour: Annotated[basic.Colour, Field(basic.Colour, 0x520)]
    UnknownColour: Annotated[basic.Colour, Field(basic.Colour, 0x530)]
    ScannableIcons: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x540)]
    ScannableIconsBinocs: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x15A8)]
    BuildingIcons: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x2610)]
    BuildingIconsBinocs: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x2DB8)]
    BuildingIconsHuge: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x3560)]
    Vehicles: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x3D08)]
    GenericIcons: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x3E90)]
    NetworkFSPlayerCorvetteTeleporter: Annotated[
        cGcScannerIcon, Field(cGcScannerIcon, 0x3FE0)
    ]
    NetworkFSPlayerMarkers: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x40C0)]
    NetworkFSPlayerMarkersShip: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x41A0)]
    NetworkPlayerFreighter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4280)]
    HighlightIcons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x4360)]
    ArrowLarge: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x43D8)]
    ArrowSmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4410)]
    BaseBuildingMarker: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4448)]
    Battle: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4480)]
    BattleSmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x44B8)]
    BlackHole: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x44F0)]
    Bounty1: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4528)]
    Bounty2: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4560)]
    Bounty3: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4598)]
    BountySmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x45D0)]
    Checkpoint: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4608)]
    CircleAnimation: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4640)]
    Corvette: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4678)]
    CorvetteDeployedTeleporter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x46B0)]
    CreatureAction: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x46E8)]
    CreatureCurious: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4720)]
    CreatureDanger: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4758)]
    CreatureDiscovered: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4790)]
    CreatureFiend: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x47C8)]
    CreatureInteraction: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4800)]
    CreatureMilk: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4838)]
    CreatureTame: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4870)]
    CreatureUndiscovered: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x48A8)]
    CreatureUnknown: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x48E0)]
    DamagedFrigate: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4918)]
    Death: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4950)]
    DeathSmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4988)]
    DiamondAnimation: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x49C0)]
    EditingBase: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x49F8)]
    Expedition: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4A30)]
    Freighter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4A68)]
    FreighterBase: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4AA0)]
    FriendlyDrone: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4AD8)]
    Garage: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4B10)]
    HexAnimation: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4B48)]
    MessageBeacon: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4B80)]
    MessageBeaconSmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4BB8)]
    MissionAbandonedFreighter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4BF0)]
    MissionEnterBuilding: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4C28)]
    MissionEnterFreighter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4C60)]
    MissionEnterOrbit: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4C98)]
    MissionEnterStation: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4CD0)]
    MonumentMarker: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4D08)]
    NetworkPlayerMarker: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4D40)]
    NetworkPlayerMarkerShip: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4D78)]
    NetworkPlayerMarkerVehicle: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4DB0)]
    NPC: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4DE8)]
    OtherPlayerSettlement: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4E20)]
    Pet: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4E58)]
    PetActivity: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4E90)]
    PetInteraction: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4EC8)]
    PetSad: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4F00)]
    PirateRaid: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4F38)]
    PlanetPoleEast: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4F70)]
    PlanetPoleNorth: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4FA8)]
    PlanetPoleSouth: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x4FE0)]
    PlanetPoleWest: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5018)]
    PlayerBase: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5050)]
    PlayerFreighter: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5088)]
    PlayerSettlement: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x50C0)]
    PortalMarker: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x50F8)]
    PurchasableFrigate: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5130)]
    SettlementNPC: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5168)]
    Ship: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x51A0)]
    ShipSmall: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x51D8)]
    TaggedBuilding: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5210)]
    TaggedPlanet: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5248)]
    TimedEvent: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x5280)]
    VehicleGeneric: Annotated[cGcScannerIcon, Field(cGcScannerIcon, 0x52B8)]


@partial_struct
class cTkMetadataFilenameList(Structure):
    Filenames: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cGcNetworkInterpolationComponentData(Structure):
    class eSynchroniseScaleEnum(IntEnum):
        Never = 0x0
        Once = 0x1
        Always = 0x2

    SynchroniseScale: Annotated[
        c_enum32[eSynchroniseScaleEnum], Field(c_enum32[eSynchroniseScaleEnum], 0x0)
    ]
    SupportTeleportation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4)]
    UpdateWhileInactive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5)]


@partial_struct
class cGcNetworkPlayerMarkerComponentData(Structure):
    pass


@partial_struct
class cGcStatusMessageDefinitions(Structure):
    MissionMarkupColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    PetChatTemplates: Annotated[
        cGcPetVocabularyEntry, Field(cGcPetVocabularyEntry, 0x10)
    ]
    PetVocabulary: Annotated[cGcPetVocabularyEntry, Field(cGcPetVocabularyEntry, 0x4A8)]
    FriendlyDroneChatTemplates: Annotated[
        cGcFriendlyDroneVocabularyEntry, Field(cGcFriendlyDroneVocabularyEntry, 0x7F0)
    ]
    Messages: Annotated[
        basic.cTkDynamicArray[cGcStatusMessageDefinition],
        Field(basic.cTkDynamicArray[cGcStatusMessageDefinition], 0x890),
    ]


@partial_struct
class cGcItemFilterDataTable(Structure):
    Filters: Annotated[
        basic.cTkDynamicArray[cGcItemFilterDataTableEntry],
        Field(basic.cTkDynamicArray[cGcItemFilterDataTableEntry], 0x0),
    ]


@partial_struct
class cGcPlayerEmoteList(Structure):
    Emotes: Annotated[cGcPlayerEmote, Field(cGcPlayerEmote, 0x0)]


@partial_struct
class cGcGalaxyInfoIcons(Structure):
    RaceIcons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    EconomyIcons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0xD8)]
    ConflictIcons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x180)]
    WealthIcons: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x1E0)]
    ConflictTechNotInstalledIcon: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x240)
    ]
    EconomyTechNotInstalledIcon: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x258)
    ]
    WarpErrorIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x270)]
    WarpIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x288)]
    WarpTechNotInstalledIcon: Annotated[
        cTkTextureResource, Field(cTkTextureResource, 0x2A0)
    ]


@partial_struct
class cGcMissionCommunityData(Structure):
    CommunityMissionsData: Annotated[
        basic.cTkDynamicArray[cGcMissionCommunityMissionData],
        Field(basic.cTkDynamicArray[cGcMissionCommunityMissionData], 0x0),
    ]
    CommunityMissionsIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x10),
    ]


@partial_struct
class cGcHistoricalSeasonDataTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcHistoricalSeasonData],
        Field(basic.cTkDynamicArray[cGcHistoricalSeasonData], 0x0),
    ]


@partial_struct
class cGcPlayerTitleData(Structure):
    Titles: Annotated[cGcPlayerTitle, Field(cGcPlayerTitle, 0x0)]


@partial_struct
class cGcProductDescriptionOverrideTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcProductDescriptionOverride],
        Field(basic.cTkDynamicArray[cGcProductDescriptionOverride], 0x0),
    ]


@partial_struct
class cGcBaitTable(Structure):
    Bait: Annotated[
        basic.cTkDynamicArray[cGcBaitData],
        Field(basic.cTkDynamicArray[cGcBaitData], 0x0),
    ]


@partial_struct
class cGcFishTable(Structure):
    Fish: Annotated[
        basic.cTkDynamicArray[cGcFishData],
        Field(basic.cTkDynamicArray[cGcFishData], 0x0),
    ]


@partial_struct
class cGcDialogClearanceTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcDialogClearanceInfo],
        Field(basic.cTkDynamicArray[cGcDialogClearanceInfo], 0x0),
    ]


@partial_struct
class cGcUnlockablePlatformRewards(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcUnlockablePlatformReward],
        Field(basic.cTkDynamicArray[cGcUnlockablePlatformReward], 0x0),
    ]


@partial_struct
class cGcUnlockableTwitchRewards(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcUnlockableTwitchReward],
        Field(basic.cTkDynamicArray[cGcUnlockableTwitchReward], 0x0),
    ]


@partial_struct
class cGcItemCostTable(Structure):
    Items: Annotated[cGcItemCostData, Field(cGcItemCostData, 0x0)]


@partial_struct
class cGcPurchaseableBuildingBlueprints(Structure):
    GroupMaxItems: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x0),
    ]
    Table: Annotated[
        basic.cTkDynamicArray[cGcBuildingBlueprint],
        Field(basic.cTkDynamicArray[cGcBuildingBlueprint], 0x10),
    ]


@partial_struct
class cGcUnlockableSeasonRewards(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcUnlockableSeasonReward],
        Field(basic.cTkDynamicArray[cGcUnlockableSeasonReward], 0x0),
    ]


@partial_struct
class cGcPurchaseableSpecials(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcPurchaseableSpecial],
        Field(basic.cTkDynamicArray[cGcPurchaseableSpecial], 0x0),
    ]


@partial_struct
class cGcStatRewardsTable(Structure):
    StatRewardGroups: Annotated[
        basic.cTkDynamicArray[cGcStatRewardGroup],
        Field(basic.cTkDynamicArray[cGcStatRewardGroup], 0x0),
    ]


@partial_struct
class cGcCostTable(Structure):
    AtlasPathCosts: Annotated[
        basic.cTkDynamicArray[cGcCostTableEntry],
        Field(basic.cTkDynamicArray[cGcCostTableEntry], 0x0),
    ]
    InteractionTable: Annotated[
        basic.cTkDynamicArray[cGcCostTableEntry],
        Field(basic.cTkDynamicArray[cGcCostTableEntry], 0x10),
    ]
    ItemCostsTable: Annotated[
        basic.cTkDynamicArray[cGcCostTableEntry],
        Field(basic.cTkDynamicArray[cGcCostTableEntry], 0x20),
    ]
    SimpleInteractionTable: Annotated[
        basic.cTkDynamicArray[cGcCostTableEntry],
        Field(basic.cTkDynamicArray[cGcCostTableEntry], 0x30),
    ]
    UnusedCostsTable: Annotated[
        basic.cTkDynamicArray[cGcCostTableEntry],
        Field(basic.cTkDynamicArray[cGcCostTableEntry], 0x40),
    ]


@partial_struct
class cGcAlienSpeechTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcAlienSpeechEntry],
        Field(basic.cTkDynamicArray[cGcAlienSpeechEntry], 0x0),
    ]


@partial_struct
class cGcDiscoveryRewardLookupTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcDiscoveryRewardLookup],
        Field(basic.cTkDynamicArray[cGcDiscoveryRewardLookup], 0x0),
    ]


@partial_struct
class cGcTechBoxTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcTechBoxData],
        Field(basic.cTkDynamicArray[cGcTechBoxData], 0x0),
    ]


@partial_struct
class cGcLegacyItemTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcLegacyItem],
        Field(basic.cTkDynamicArray[cGcLegacyItem], 0x0),
    ]


@partial_struct
class cGcProceduralTechnologyTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcProceduralTechnologyData],
        Field(basic.cTkDynamicArray[cGcProceduralTechnologyData], 0x0),
    ]


@partial_struct
class cGcAudioAreaTriggerComponentData(Structure):
    EnterDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    EventEnter: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0x4),
    ]
    EventExit: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0x8),
    ]
    ExitDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]


@partial_struct
class cGcObjectSpawnerComponentData(Structure):
    Object: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    SpawnCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    SpawnPowerCost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]


@partial_struct
class cGcSpawnedObjectComponentData(Structure):
    CanBeTeleported: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcDissolveEffectComponentData(Structure):
    DissolveBeginHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DissolveEndHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcHologramComponentData(Structure):
    HologramColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    AttractDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    HologramType: Annotated[
        c_enum32[enums.cGcHologramType], Field(c_enum32[enums.cGcHologramType], 0x14)
    ]
    MaxSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MinSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    OnInteractState: Annotated[
        c_enum32[enums.cGcHologramState], Field(c_enum32[enums.cGcHologramState], 0x20)
    ]
    RotateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    xPivot: Annotated[
        c_enum32[enums.cGcHologramPivotType],
        Field(c_enum32[enums.cGcHologramPivotType], 0x28),
    ]
    yPivot: Annotated[
        c_enum32[enums.cGcHologramPivotType],
        Field(c_enum32[enums.cGcHologramPivotType], 0x2C),
    ]
    zPivot: Annotated[
        c_enum32[enums.cGcHologramPivotType],
        Field(c_enum32[enums.cGcHologramPivotType], 0x30),
    ]
    DisableOnInteract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]
    DisableWhenNotInteracting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x35)]
    ScaleInAndOut: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x36)]
    UseStationLightColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x37)]


@partial_struct
class cGcModelExplosionRules(Structure):
    Rules: Annotated[
        basic.cTkDynamicArray[cGcModelExplosionRule],
        Field(basic.cTkDynamicArray[cGcModelExplosionRule], 0x0),
    ]
    ShipSalvageDisplayScales: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    UseRules: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]


@partial_struct
class cGcAlienPodComponentData(Structure):
    AgroMovement: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AgroMovementRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    AgroRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    AgroSpookTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    AgroSpookTimeMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    AgroSpookTimeMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    AgroSpookValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    AgroThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    AgroThresholdOffscreen: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AgroTorch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    AgroTorchFOV: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    AgroTorchRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    GlowIntensityMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    GlowIntensityMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    GunfireAgro: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    GunfireAgroRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    InstaAgroDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]


@partial_struct
class cGcBaseDefenceComponentData(Structure):
    Triggers: Annotated[
        basic.cTkDynamicArray[cGcBaseDefenceTrigger],
        Field(basic.cTkDynamicArray[cGcBaseDefenceTrigger], 0x0),
    ]
    LaserRangeAnimateTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    LostUncertaintyThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SearchTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    PrioritiseThreats: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cGcAntagonistComponentData(Structure):
    Enemies: Annotated[cGcAntagonistEnemy, Field(cGcAntagonistEnemy, 0x0)]
    Friends: Annotated[cGcAntagonistFriend, Field(cGcAntagonistFriend, 0x90)]
    Perceptions: Annotated[
        basic.cTkDynamicArray[cGcAntagonistPerception],
        Field(basic.cTkDynamicArray[cGcAntagonistPerception], 0x120),
    ]
    CommunicationDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x130)]
    ComprehensionFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x134)]
    Group: Annotated[
        c_enum32[enums.cGcAntagonistGroup],
        Field(c_enum32[enums.cGcAntagonistGroup], 0x138),
    ]
    ScarinessFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x13C)]
    ShockedFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x140)]


@partial_struct
class cGcAtmosphereEntryComponentData(Structure):
    FlareEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    ImpactEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    EditTerrainRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    EntryOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    EntryTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    AutoEntry: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]


@partial_struct
class cGcChairComponentData(Structure):
    pass


@partial_struct
class cGcByteBeatSwitchComponentData(Structure):
    Temp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcBuildingComponentData(Structure):
    pass


@partial_struct
class cGcDiscoveryDisplayComponentData(Structure):
    DiscoveryScanEffect: Annotated[cGcScanEffectData, Field(cGcScanEffectData, 0x0)]
    DiscoveryScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    DiscoveryScalePlanets: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]


@partial_struct
class cGcCustomSpaceStormComponentData(Structure):
    StormId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cTkLODComponentData(Structure):
    LODModels: Annotated[
        basic.cTkDynamicArray[cTkLODModelResource],
        Field(basic.cTkDynamicArray[cTkLODModelResource], 0x0),
    ]
    CrossFadeOverlap: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    CrossFadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    UseMasterModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cTkAudioComponentData(Structure):
    AmbientState: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    AnimTriggers: Annotated[
        basic.cTkDynamicArray[cTkAudioAnimTrigger],
        Field(basic.cTkDynamicArray[cTkAudioAnimTrigger], 0x10),
    ]
    Emitters: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x20),
    ]
    MaxDistance: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    OcclusionRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    OcclusionRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Ambient: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x3C)]
    Shutdown: Annotated[basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0xBC)]
    LocalOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x13C)]


@partial_struct
class cGcCombatEffectsComponentData(Structure):
    EffectsProperties: Annotated[
        cGcCombatEffectsProperties, Field(cGcCombatEffectsProperties, 0x0)
    ]


@partial_struct
class cGcBaseMiniPortalComponentData(Structure):
    CorvetteTeleportInteractionName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    DestinationGroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    GroupID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    AssociatedCorvetteDockIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]

    class eDestinationSortTypeEnum(IntEnum):
        NearestPotal = 0x0
        BaseBuildingConnection = 0x1
        AbandonedFreighter = 0x2
        PortalNearestPlayerShip = 0x3
        ExitCorvette = 0x4
        ReturnToCorvette = 0x5
        ReturnToCorvetteOutpost = 0x6

    DestinationSortType: Annotated[
        c_enum32[eDestinationSortTypeEnum],
        Field(c_enum32[eDestinationSortTypeEnum], 0x44),
    ]
    PowerCost: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    SnapFacingAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    AllowSpawnedObjects: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x50)]
    AllowVehicles: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x51)]
    DoPlayerEffects: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x52)]
    FlipFacingDirection: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x53)]
    SnapFacingDirection: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]
    TeleportCamera: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x55)]


@partial_struct
class cGcDistanceScaleComponentData(Structure):
    MaxDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MinDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Scale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    DisabledWhenOnFreighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x14)]
    UseGlobals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x15)]


@partial_struct
class cGcPlayerEffectsComponentData(Structure):
    VehicleInOutDissolveDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    VehicleInOutEffectDelay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    VehicleInOutTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcNPCHabitationComponentData(Structure):
    NPCSpawnLocator: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    NPCHabitationType: Annotated[
        c_enum32[enums.cGcNPCHabitationType],
        Field(c_enum32[enums.cGcNPCHabitationType], 0x10),
    ]


@partial_struct
class cGcEncounterStateComponentData(Structure):
    pass


@partial_struct
class cGcEncounterComponentData(Structure):
    InteractMissionTable: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    EncounterType: Annotated[
        c_enum32[enums.cGcEncounterType], Field(c_enum32[enums.cGcEncounterType], 0x10)
    ]


@partial_struct
class cGcGroundWormComponentData(Structure):
    AttackDamageType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    EmergeEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    EmergeShake: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    RoarShake: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    SpitProjectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    SubmergeEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    AttackAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    AttackCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    AttackDamageRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    AttackDistMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    AttackDistMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    CollisionBodySize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    EmergeDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    EmergeEffectTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    EmergeLookBlendEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    EmergeLookBlendStart: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    EmergeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    FlinchAngleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    FlinchAngleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    FlinchSmooth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    FlinchTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    LungeAngleBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    LungeAngleHead: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    LungeBeginTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    LungeBlendInSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    LungeBlendOutSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    LungeEndTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    LungeStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    RearUpBeginDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    RearUpEndDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    RestTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    RoarCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    RumbleTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    SpitCooldown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    SpitCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xD0)]
    SubmergeDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    SubmergeDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    TrackTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    TurnSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    WindUpAngleBase: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    WindUpAngleHead: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    WindUpStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    GrabJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xF0)
    ]
    LookJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1F0)
    ]


@partial_struct
class cGcExhibitAssemblyComponentData(Structure):
    ExhibitType: Annotated[
        c_enum32[enums.cGcModularCustomisationResourceType],
        Field(c_enum32[enums.cGcModularCustomisationResourceType], 0x0),
    ]


@partial_struct
class cGcFishableAreaComponentData(Structure):
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    SourceFishBasedOnSettlementBuildingLevel: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x4)
    ]


@partial_struct
class cGcExpeditionHologramComponentData(Structure):
    SpawnOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    CaptainScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FrigateScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    HologramRotationSpeedDegPerSec: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x18)
    ]


@partial_struct
class cGcGrabPlayerComponentData(Structure):
    GrabOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    DamageType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DefendAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    GrabAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    HitReactAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    HoldAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    IdleAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    PlayerGrabbedAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    HitReactAngles: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x80)]
    LookAroundAngles: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x88)]
    LookAroundAnglesFine: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x90)]
    LookAroundTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x98)]
    LookAroundTrackTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xA0)]
    LookAtPlayerTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xA8)]
    SleepTime: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xB0)]
    ActivateRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    BodgeInputAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    BodgeOutputAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    CooldownTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    DamageTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    EjectImpulse: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    FocusRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    GrabAttachStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    GrabBeginAudioEvent: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0xD8),
    ]
    GrabBlendTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xDC)]
    GrabEndAudioEvent: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0xE0),
    ]
    GrabRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    HitReactAnimChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    HoldTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]
    LookAroundFineModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF0)]
    LookAtPlayerChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF4)]
    LungeRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    MaxLookAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    RestTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x100)]
    SleepChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x104)]
    TrackTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x108)]
    TriggerRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10C)]
    GrabJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x110)
    ]
    LookJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x210)
    ]


@partial_struct
class cGcFleetHologramComponentData(Structure):
    pass


@partial_struct
class cGcHeightAdjustComponentData(Structure):
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcGrabbableComponentData(Structure):
    GrabbableDataArray: Annotated[
        basic.cTkDynamicArray[cGcGrabbableData],
        Field(basic.cTkDynamicArray[cGcGrabbableData], 0x0),
    ]


@partial_struct
class cGcLadderComponentData(Structure):
    pass


@partial_struct
class cGcLookAtComponentData(Structure):
    class eLookAtTypeEnum(IntEnum):
        Player = 0x0

    LookAtType: Annotated[
        c_enum32[eLookAtTypeEnum], Field(c_enum32[eLookAtTypeEnum], 0x0)
    ]
    MinRotationRateDegrees: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    RotationRateFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    NodeName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xC)]


@partial_struct
class cGcLootComponentData(Structure):
    Reward: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    TimeOutEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Timed: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x20)]
    FlashPercent: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    NumFlashes: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]
    DeathPoint: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    KeepUpright: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    PhysicsControlled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cGcLandingHelperComponentData(Structure):
    ActiveDistanceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    ActiveDistanceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LandPoint: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]


@partial_struct
class cGcNPCPlacementComponentData(Structure):
    PlacementInfosToApply: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    PlaceInAbandonedSystems: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    SearchPlacementFromMaster: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]
    WaitToPlace: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12)]


@partial_struct
class cGcObjectPlacementComponentData(Structure):
    class eActivationTypeEnum(IntEnum):
        GroupNode = 0x0
        Locator = 0x1

    ActivationType: Annotated[
        c_enum32[eActivationTypeEnum], Field(c_enum32[eActivationTypeEnum], 0x0)
    ]
    FractionOfNodesActive: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxGroupsActivated: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    MaxNodesActivated: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    GroupNodeName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x10)
    ]
    UseNodeParent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    UseRaycast: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcPortalComponentData(Structure):
    Temp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcSentinelCoverComponentData(Structure):
    CoverStateAnims: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DestroyEffectId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    SpawnEffectId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    HealthPercLostPerSecMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    HealthPercLostPerSecMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    EffectLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x68)
    ]


@partial_struct
class cGcSimpleInteractionComponentData(Structure):
    ActivationCost: Annotated[
        cGcInteractionActivationCost, Field(cGcInteractionActivationCost, 0x0)
    ]
    RarityLocators: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x68)]
    ForceSubtitle: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x98)
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xB8)]
    ScanData: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xD8)]
    ScanType: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xF8)]
    TerminalHeading: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x118)
    ]
    TerminalMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x138)
    ]
    VRInteractMessage: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x158)
    ]
    BaseBuildingTriggerActions: Annotated[
        basic.cTkDynamicArray[cGcInteractionBaseBuildingState],
        Field(basic.cTkDynamicArray[cGcInteractionBaseBuildingState], 0x178),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x188)]
    OnlyActiveDuringSeasons: Annotated[
        basic.cTkDynamicArray[ctypes.c_int32],
        Field(basic.cTkDynamicArray[ctypes.c_int32], 0x198),
    ]
    PersistencyBufferOverride: Annotated[
        basic.cTkDynamicArray[cGcPersistencyMissionOverride],
        Field(basic.cTkDynamicArray[cGcPersistencyMissionOverride], 0x1A8),
    ]
    RewardOverrideTable: Annotated[
        basic.cTkDynamicArray[cGcRewardMissionOverride],
        Field(basic.cTkDynamicArray[cGcRewardMissionOverride], 0x1B8),
    ]
    TriggerAction: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1C8)]
    TriggerActionOnPrepare: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1D8)]
    TriggerActionToggle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1E8)]
    DeactivateSimilarInteractionsNearbyRadius: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x1F8)
    ]
    Delay: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1FC)]
    IncreaseCorruptSentinelWanted: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x200)
    ]
    InteractCrimeLevel: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x204)]
    InteractDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x208)]
    InteractFiendCrimeChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20C)]
    InteractFiendCrimeType: Annotated[
        c_enum32[enums.cGcFiendCrime], Field(c_enum32[enums.cGcFiendCrime], 0x210)
    ]
    Rarity: Annotated[
        c_enum32[enums.cGcRarity], Field(c_enum32[enums.cGcRarity], 0x214)
    ]
    ScanIcon: Annotated[
        c_enum32[enums.cGcDiscoveryType], Field(c_enum32[enums.cGcDiscoveryType], 0x218)
    ]

    class eSimpleInteractionTypeEnum(IntEnum):
        Interact = 0x0
        Treasure = 0x1
        Beacon = 0x2
        Scan = 0x3
        Save = 0x4
        CallShip = 0x5
        CallVehicle = 0x6
        Word = 0x7
        Tech = 0x8
        GenericReward = 0x9
        Feed = 0xA
        Ladder = 0xB
        ClaimBase = 0xC
        TeleportStartPoint = 0xD
        TeleportEndPoint = 0xE
        Portal = 0xF
        Chest = 0x10
        ResourceHarvester = 0x11
        BaseCapsule = 0x12
        Hologram = 0x13
        NPCTerminalMessage = 0x14
        VehicleBoot = 0x15
        BiomeHarvester = 0x16
        FreighterGalacticMap = 0x17
        FreighterChest = 0x18
        Collectable = 0x19
        Chair = 0x1A
        BaseTreasureChest = 0x1B
        SpawnObject = 0x1C
        NoiseBox = 0x1D
        AbandFreighterTeleporter = 0x1E
        PetEgg = 0x1F
        SubstancePickup = 0x20
        FreighterTeleport = 0x21
        MiniPortalTrigger = 0x22
        SuperDoopaScanner = 0x23
        RefundedCorvetteStorage = 0x24
        CorvetteMissionBoard = 0x25
        CorvetteRampSwitch = 0x26

    SimpleInteractionType: Annotated[
        c_enum32[eSimpleInteractionTypeEnum],
        Field(c_enum32[eSimpleInteractionTypeEnum], 0x21C),
    ]
    Size: Annotated[
        c_enum32[enums.cGcSizeIndicator], Field(c_enum32[enums.cGcSizeIndicator], 0x220)
    ]
    StatToTrack: Annotated[
        c_enum32[enums.cGcStatsEnum], Field(c_enum32[enums.cGcStatsEnum], 0x224)
    ]
    ActivateLocatorsFromRarity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x228)]
    BroadcastTriggerAction: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x229)]
    CanCollectInMech: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22A)]
    DisableAnimationUntilInteract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22B)]
    HideContents: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22C)]
    InteractIsCrime: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22D)]
    MustBeVisibleToInteract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22E)]
    NeedsStorm: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22F)]
    NotifyEncounter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x230)]
    ReseedOnRewardSuccess: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x231)]
    StartsBuried: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x232)]
    Use2dInteractDistance: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x233)]
    UsePersonalPersistentBuffer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x234)]


@partial_struct
class cGcSquadronHologramComponentData(Structure):
    SpawnOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    HologramRotationSpeedDegPerSec: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x10)
    ]
    PilotScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SpawnRotation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cGcSpaceObjectComponentData(Structure):
    Size: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcThereminComponentData(Structure):
    IgnorePlayerDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaxPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxVolume: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MinVolume: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    PitchMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    PitchMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    VolumeMaxDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    VolumeMinDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    PitchEndLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x24)
    ]
    PitchStartLocator: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x44)
    ]
    VolumeBBName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x64)
    ]


@partial_struct
class cGcWiringSocketComponentData(Structure):
    Value: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcTurretComponentData(Structure):
    LaserEffectId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LaserMuzzleChargeId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    LaserMuzzleFlashId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    MissileId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    ProjectileId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    ProjectileMuzzleFlashId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    BaseRotationAngleThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]

    class eGunTypeEnum(IntEnum):
        Laser = 0x0
        Projectile = 0x1
        Missile = 0x2

    GunType: Annotated[c_enum32[eGunTypeEnum], Field(c_enum32[eGunTypeEnum], 0x64)]
    LevelledBurstCountExtra: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    LevelledBurstTimeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]

    class eTargetFilterEnum(IntEnum):
        Any = 0x0
        FreightersOnly = 0x1
        SmallShipsOnly = 0x2

    TargetFilter: Annotated[
        c_enum32[eTargetFilterEnum], Field(c_enum32[eTargetFilterEnum], 0x70)
    ]
    TurrentLaserShootTimeRandomExtraMax: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x74)
    ]
    TurretAimOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    TurretAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    TurretBurstCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x80)]
    TurretBurstTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    TurretDispersionAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    TurretLaserAbortDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]
    TurretLaserActiveTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x90)]
    TurretLaserChargeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    TurretLaserLength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    TurretLaserMoveSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    TurretLaserShootTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    TurretMaxDownAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    TurretMaxPitchTurnSpeedDegPerSec: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xA8)
    ]
    TurretMaxYawTurnSpeedDegPerSec: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0xAC)
    ]
    TurretMissileLaunchSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    TurretMissileLaunchTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]
    TurretMissileRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB8)]
    TurretPitchSmoothTurnTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xBC)]
    TurretProjectileRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC0)]
    TurretRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC4)]
    TurretShootPauseTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC8)]
    TurretYawSmoothTurnTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xCC)]
    CanMoveDuringBurst: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD0)]
    FireInTurretFacing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD1)]
    HasFreighterAlertLight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD2)]
    RemotePlayersCanDamage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xD3)]


@partial_struct
class cGcBuoyancyComponentData(Structure):
    AirborneSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AnchorArrivalTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaximumAnchorForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MaximumForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    MinimumForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    SelfRightingStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    TargetHeightBufferFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    TargetSurfaceHeightCalm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    TargetSurfaceHeightRough: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    UnderwaterSpringTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    UpwardRotationFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    WaveRotationFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    SetAnchorOnPrepare: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]


@partial_struct
class cGcRocketLockerComponentData(Structure):
    NumSlots: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcSkiffComponentData(Structure):
    ArrivalTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaximumTravelForce: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcOutpostComponentData(Structure):
    Door: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LSystems: Annotated[
        basic.cTkDynamicArray[cGcOutpostLSystemPair],
        Field(basic.cTkDynamicArray[cGcOutpostLSystemPair], 0x10),
    ]
    ApproachAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    ApproachNodeTargetOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    ApproachRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    ApproachSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    CircleRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    CorvetteLandingIndicatorRange: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x34)
    ]
    DockingAttractConeAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    DockingAttractFacingAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    DockingAttractRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    LandingHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    LandingSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    PlayerAutoLandRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    PostTakeOffExtraPlayerHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    PostTakeOffExtraPlayerSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    TakeOffAlignTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    TakeOffBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    TakeOffExtraAIHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    TakeOffFwdDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    TakeOffHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x68)]
    TakeOffProgressForExtraHeight: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x6C)
    ]
    TakeOffSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    TakeOffTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x74)]
    AbandonedFreighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]
    AIDestination: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x79)]
    Anomaly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7A)]
    CheckLandingAreaClear: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7B)]
    Frigate: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7C)]
    HasDoors: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7D)]
    HasOwnGravity: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7E)]
    NexusExterior: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7F)]
    NexusInterior: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x80)]
    RotateToDock: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x81)]
    SpaceStation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x82)]


@partial_struct
class cGcPlayerWeaponComponentData(Structure):
    pass


@partial_struct
class cGcScannableComponentData(Structure):
    FreighterObjectAlreadyUsedLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ValidMissionSurveyIds: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    AlwaysShowRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    BinocsDiscoIconOverride: Annotated[
        c_enum32[enums.cGcDiscoveryType], Field(c_enum32[enums.cGcDiscoveryType], 0x34)
    ]
    CompassRangeMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Icon: Annotated[
        c_enum32[enums.cGcScannerIconTypes],
        Field(c_enum32[enums.cGcScannerIconTypes], 0x3C),
    ]
    MarkerOffsetOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    MinDisplayDistanceOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]

    class eScannableTypeEnum(IntEnum):
        Binoculars = 0x0
        BinocularsHotspots = 0x1
        Scanner = 0x2
        Marker = 0x3
        SpaceBattleTarget = 0x4
        None_ = 0x5

    ScannableType: Annotated[
        c_enum32[eScannableTypeEnum], Field(c_enum32[eScannableTypeEnum], 0x48)
    ]
    ScanRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    ScanTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    ScanName: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x54)]
    AllowedToMerge: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]
    CanTagIcon: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x75)]
    ClearTagOnArrival: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x76)]
    DisableIfBuildingPart: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x77)]
    DisableIfInBase: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x78)]
    ForceCompassMarkerOnForScannerIcon: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x79)
    ]
    GetIconAndNameFromSettlementBuilding: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x7A)
    ]
    IsPlacedMarker: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7B)]
    MarkerActiveWithNodeInactive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7C)]
    ShowInFreighterBranchRoom: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7D)]
    TellPlayerIfFreighterObjectUsed: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x7E)
    ]
    UseModelNode: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x7F)]


@partial_struct
class cGcScanToRevealComponentData(Structure):
    LockedMarkerScanOverride: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    OnRevealEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    RequiredTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DissolveTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]

    class eHideScanMarkerConditionEnum(IntEnum):
        Never = 0x0
        MissingTech = 0x1
        Hidden = 0x2

    HideScanMarkerCondition: Annotated[
        c_enum32[eHideScanMarkerConditionEnum],
        Field(c_enum32[eHideScanMarkerConditionEnum], 0x34),
    ]
    MaxRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    RequiredStat: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x3C)
    ]
    RevealTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    DoDissolve: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]
    EnabledOnlyOnAbandonedNexus: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45)]
    LockedMarkerClearOnReveal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46)]
    OnRevealEffectScaleWithAABB: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x47)]
    RevealedByShipScan: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x48)]
    RevealedByToolScan: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]
    SetNodeActivation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4A)]
    StartEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B)]


@partial_struct
class cGcEncyclopediaComponentData(Structure):
    Type: Annotated[
        c_enum32[enums.cGcDiscoveryType], Field(c_enum32[enums.cGcDiscoveryType], 0x0)
    ]


@partial_struct
class cGcScanEffectComponentData(Structure):
    ScanEffects: Annotated[
        basic.cTkDynamicArray[cGcScanEffectData],
        Field(basic.cTkDynamicArray[cGcScanEffectData], 0x0),
    ]
    NodeName: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x10)]


@partial_struct
class cGcWFCBuilding(Structure):
    DecorationSet: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    FallbackSeeds: Annotated[
        basic.cTkDynamicArray[ctypes.c_int64],
        Field(basic.cTkDynamicArray[ctypes.c_int64], 0x10),
    ]
    GroupsEnabled: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x20),
    ]
    Layouts: Annotated[
        basic.cTkDynamicArray[cGcWeightedResource],
        Field(basic.cTkDynamicArray[cGcWeightedResource], 0x30),
    ]
    MinimumUseConstraints: Annotated[
        basic.cTkDynamicArray[cGcMinimumUseConstraint],
        Field(basic.cTkDynamicArray[cGcMinimumUseConstraint], 0x40),
    ]
    ModuleOverrides: Annotated[
        basic.cTkDynamicArray[cGcModuleOverride],
        Field(basic.cTkDynamicArray[cGcModuleOverride], 0x50),
    ]
    ModuleSet: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x60)
    ]
    NPCs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x70),
    ]
    PresetFallbackSeeds: Annotated[
        basic.cTkDynamicArray[ctypes.c_int64],
        Field(basic.cTkDynamicArray[ctypes.c_int64], 0x80),
    ]
    Rooms: Annotated[
        basic.cTkDynamicArray[cGcFreighterBaseRoom],
        Field(basic.cTkDynamicArray[cGcFreighterBaseRoom], 0x90),
    ]
    Sizes: Annotated[
        basic.cTkDynamicArray[cGcWeightedBuildingSize],
        Field(basic.cTkDynamicArray[cGcWeightedBuildingSize], 0xA0),
    ]
    InitialUnlockProbability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    NumberOfPresetsPerPlanet: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xB4)]
    ReplaceMaterials: Annotated[
        c_enum32[enums.cGcBaseBuildingPartStyle],
        Field(c_enum32[enums.cGcBaseBuildingPartStyle], 0xB8),
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0xBC)]
    DontSpawnNearPlayerBases: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xDC)]
    ImprovedCoherence: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xDD)]
    RemoveUnreachableBlocks: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xDE)]
    RequireNoUnreachableRooms: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xDF)]


@partial_struct
class cGcAbandonedFreighterComponentData(Structure):
    DungeonRootScene: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    MarkerLabel: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    MarkerIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x40)]
    DungeonOptions: Annotated[
        basic.cTkDynamicArray[cGcFreighterDungeonChoice],
        Field(basic.cTkDynamicArray[cGcFreighterDungeonChoice], 0x58),
    ]


@partial_struct
class cGcColouriseComponentData(Structure):
    PrimaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    QuaternaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    SecondaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x20)]
    TernaryColour: Annotated[basic.Colour, Field(basic.Colour, 0x30)]


@partial_struct
class cGcCameraShakeComponentData(Structure):
    ShakeID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FalloffDistanceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    FalloffDistanceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]


@partial_struct
class cGcFreighterBaseComponentData(Structure):
    FreighterBaseOptions: Annotated[
        cGcFreighterBaseOptions, Field(cGcFreighterBaseOptions, 0x0)
    ]
    FreighterBaseForPlayerReset: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    WFCBuildingFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]

    class eFreighterBaseGenerationModeEnum(IntEnum):
        Prefab = 0x0
        WFC = 0x1

    FreighterBaseGenerationMode: Annotated[
        c_enum32[eFreighterBaseGenerationModeEnum],
        Field(c_enum32[eFreighterBaseGenerationModeEnum], 0x60),
    ]


@partial_struct
class cGcDecorationComponentData(Structure):
    MaxTestRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    StartOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]


@partial_struct
class cGcPlayerCharacterStateTable(Structure):
    CharacterStates: Annotated[
        cGcPlayerCharacterStateData, Field(cGcPlayerCharacterStateData, 0x0)
    ]


@partial_struct
class cGcMultiTextureComponentData(Structure):
    MultiTextureIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcMarkerComponentData(Structure):
    CustomName: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CustomIcon: Annotated[
        c_enum32[enums.cGcRealityGameIcons],
        Field(c_enum32[enums.cGcRealityGameIcons], 0x20),
    ]

    class eDisplayModeEnum(IntEnum):
        Always = 0x0
        SpaceOnly = 0x1
        PlanetOnly = 0x2

    DisplayMode: Annotated[
        c_enum32[eDisplayModeEnum], Field(c_enum32[eDisplayModeEnum], 0x24)
    ]
    Icon: Annotated[
        c_enum32[enums.cGcGenericIconTypes],
        Field(c_enum32[enums.cGcGenericIconTypes], 0x28),
    ]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    ShipScannable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    UseCustomIcon: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]


@partial_struct
class cGcMultiColouriseComponentData(Structure):
    Palettes: Annotated[
        basic.cTkDynamicArray[cGcColourisePalette],
        Field(basic.cTkDynamicArray[cGcColourisePalette], 0x0),
    ]


@partial_struct
class cGcPlayerControlComponentData(Structure):
    BaseInput: Annotated[cGcPlayerControlInput, Field(cGcPlayerControlInput, 0x0)]
    AimDir: Annotated[cTkBlackboardKey, Field(cTkBlackboardKey, 0x38)]
    CrosshairDir: Annotated[cTkBlackboardKey, Field(cTkBlackboardKey, 0x50)]
    TorchDir: Annotated[cTkBlackboardKey, Field(cTkBlackboardKey, 0x68)]
    BaseCamera: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    InitialState: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    States: Annotated[
        basic.cTkDynamicArray[cGcPlayerControlState],
        Field(basic.cTkDynamicArray[cGcPlayerControlState], 0xA0),
    ]


@partial_struct
class cGcSimpleIkRecoilComponentData(Structure):
    ActiveRange: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    AngleLimit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    HitReactDirectedMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    HitReactDirectedMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    HitReactRandomMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    HitReactRandomMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MinHitReactTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    RecoverTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    EndJoint: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x20)
    ]


@partial_struct
class cGcUniqueIdComponentData(Structure):
    pass


@partial_struct
class cGcIDEnum(Structure):
    Values: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]


@partial_struct
class cGcCreatureAttractorComponentData(Structure):
    ArriveDist: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]

    class eAttractorTypeEnum(IntEnum):
        Food = 0x0
        Harvester = 0x1

    AttractorType: Annotated[
        c_enum32[eAttractorTypeEnum], Field(c_enum32[eAttractorTypeEnum], 0x4)
    ]
    Static: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8)]
    Universal: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9)]


@partial_struct
class cGcCreatureBaitComponentData(Structure):
    AttractList: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x0),
    ]
    BaitRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    BaitStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Debug: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]
    InducesRage: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x19)]


@partial_struct
class cTkRandomComponentData(Structure):
    Seed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcCreatureEffectComponentData(Structure):
    AnimTriggers: Annotated[
        basic.cTkDynamicArray[cGcCreatureEffectTrigger],
        Field(basic.cTkDynamicArray[cGcCreatureEffectTrigger], 0x0),
    ]


@partial_struct
class cGcCreatureEggComponentData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]


@partial_struct
class cGcCreatureLegIKComponentData(Structure):
    Stuff: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcCreatureAudioTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcCreatureVocalSoundData],
        Field(basic.cTkDynamicArray[cGcCreatureVocalSoundData], 0x0),
    ]


@partial_struct
class cGcCreatureFilenameTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcCreatureFilename],
        Field(basic.cTkDynamicArray[cGcCreatureFilename], 0x0),
    ]


@partial_struct
class cGcFoliageComponentData(Structure):
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcRegionHotspotsTable(Structure):
    RegionHotspotBiomeGases: Annotated[
        cGcRegionHotspotBiomeGases, Field(cGcRegionHotspotBiomeGases, 0x0)
    ]
    RegionHotspotSubstances: Annotated[
        basic.cTkDynamicArray[cGcRegionHotspotSubstance],
        Field(basic.cTkDynamicArray[cGcRegionHotspotSubstance], 0x220),
    ]
    RegionHotspots: Annotated[cGcRegionHotspotData, Field(cGcRegionHotspotData, 0x230)]
    RegionHotspotsMaxDifferentCategoryOverlap: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x350)
    ]
    RegionHotspotsMinSameCategorySpacing: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x354)
    ]
    RegionHotspotsPerPoleMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x358)]
    RegionHotspotsPerPoleMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x35C)]
    RegionHotspotsPoleSpacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x360)]


@partial_struct
class cGcVehicleScanTable(Structure):
    VehicleScanTable: Annotated[
        basic.cTkDynamicArray[cGcVehicleScanTableEntry],
        Field(basic.cTkDynamicArray[cGcVehicleScanTableEntry], 0x0),
    ]


@partial_struct
class cGcScanDataTable(Structure):
    ScanData: Annotated[
        basic.cTkDynamicArray[cGcScanDataTableEntry],
        Field(basic.cTkDynamicArray[cGcScanDataTableEntry], 0x0),
    ]


@partial_struct
class cGcAreaDamageDataTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cGcAreaDamageData],
        Field(basic.cTkDynamicArray[cGcAreaDamageData], 0x0),
    ]


@partial_struct
class cGcShootableComponentData(Structure):
    ImpactOverrideData: Annotated[
        cGcProjectileImpactData, Field(cGcProjectileImpactData, 0x0)
    ]
    DamageMultiplier: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ImpactShakeEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    RequiredTech: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    CapHealthForMissingArmour: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    FiendCrimeModifier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    FiendCrimeType: Annotated[
        c_enum32[enums.cGcFiendCrime], Field(c_enum32[enums.cGcFiendCrime], 0x58)
    ]
    ForceImpactType: Annotated[
        c_enum32[enums.cGcProjectileImpactType],
        Field(c_enum32[enums.cGcProjectileImpactType], 0x5C),
    ]
    Health: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x60)]
    IncreaseCorruptSentinelWanted: Annotated[
        ctypes.c_int32, Field(ctypes.c_int32, 0x64)
    ]
    IncreaseWanted: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    IncreaseWantedThresholdTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    LevelledExtraHealth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x70)]
    MinDamage: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x74)]
    RepairTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78)]
    NameOverride: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x7C)
    ]
    AutoAimTarget: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9C)]
    CouldCountAsArmourForParent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9D)]
    HitEffectEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9E)]
    HitEffectEntireModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x9F)]
    IgnoreHitPush: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA0)]
    IgnorePlayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA1)]
    IgnoreTerrainEditKills: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA2)]
    ImpactShake: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA3)]
    IsAffectedByPiercing: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA4)]
    IsArmoured: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA5)]
    IsPiercable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA6)]
    PlayerOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA7)]
    StaticUntilShot: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA8)]
    UseSpaceLevelForExtraHealth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA9)]


@partial_struct
class cGcNPCNavigationAreaComponentData(Structure):
    ConnectionLengthFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    MaxNeighbourSlope: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    MaxRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MinRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]

    class eNavAreaTypeEnum(IntEnum):
        Normal = 0x0
        BuildingWithExterior = 0x1
        Debris = 0x2
        Ship = 0x3
        Mech = 0x4
        PlanetMech = 0x5
        Demo = 0x6
        WFCBase = 0x7
        FreighterBase = 0x8

    NavAreaType: Annotated[
        c_enum32[eNavAreaTypeEnum], Field(c_enum32[eNavAreaTypeEnum], 0x10)
    ]
    NeighbourCandidateDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    SphereCastHeightClearance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    LimitPOIConnections: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1C)]


@partial_struct
class cGcPlayerHazardTable(Structure):
    Table: Annotated[cGcPlayerHazardData, Field(cGcPlayerHazardData, 0x0)]


@partial_struct
class cGcTorpedoComponentData(Structure):
    DamageProjectileId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    DamageShieldProjectileId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DestroyedEffect: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    ApproachTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    BrakeForceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    BrakeForceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    BrakeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    ForceMax: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    ForceMin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    HitRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MaxLifetime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MaxSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    MinCircleTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    NoTargetLife: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    RotateSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]


@partial_struct
class cGcMissileComponentData(Structure):
    Explosion: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Trail: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    NoTargetLife: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cGcDroneComponentData(Structure):
    Health: Annotated[cGcCreatureHealthData, Field(cGcCreatureHealthData, 0x0)]
    Guns: Annotated[
        basic.cTkDynamicArray[cGcDroneGun],
        Field(basic.cTkDynamicArray[cGcDroneGun], 0x68),
    ]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x78)]
    ProjectileChoices: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x88),
    ]
    Axis: Annotated[
        c_enum32[enums.cGcPrimaryAxis], Field(c_enum32[enums.cGcPrimaryAxis], 0x98)
    ]
    HeadLookIdleTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]
    HeadLookTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    MaxHeadPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    MaxHeadRoll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    MaxHeadYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    Scaler: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    HeadJointName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0xB4)
    ]


@partial_struct
class cGcSentinelRobotComponentData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Type: Annotated[
        c_enum32[enums.cGcSentinelTypes], Field(c_enum32[enums.cGcSentinelTypes], 0x10)
    ]


@partial_struct
class cGcSceneSettings(Structure):
    PlayerState: Annotated[cGcPlayerSpawnStateData, Field(cGcPlayerSpawnStateData, 0x0)]
    PlanetFiles: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0xE0)
    ]
    Events: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x130),
    ]
    NextSettingFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x140)
    ]
    PlanetSceneFiles: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x150),
    ]
    PostWarpEvents: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x160),
    ]
    SceneFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x170)
    ]
    ShipPreloadFiles: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x180),
    ]
    SolarSystemFile: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x190)
    ]
    SpawnerOptionId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1A0)]
    SpawnInsideShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B0)]
    SpawnShip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B1)]


@partial_struct
class cGcWFCModuleSet(Structure):
    BlockSize: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    CompatibleConnectors: Annotated[
        basic.cTkDynamicArray[cGcIDPair], Field(basic.cTkDynamicArray[cGcIDPair], 0x10)
    ]
    ConnectorsOnHorizontalBoundary: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x20),
    ]
    ConnectorsOnLowerBoundary: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x30),
    ]
    ConnectorsOnUpperBoundary: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x20],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x20], 0x40),
    ]
    DefaultGroups: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x50),
    ]
    ModulePrototypes: Annotated[
        basic.cTkDynamicArray[cGcWFCModulePrototype],
        Field(basic.cTkDynamicArray[cGcWFCModulePrototype], 0x60),
    ]
    VerticalOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x74)]
    ApplyWallThemes: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x94)]


@partial_struct
class cGcBuildingDefinitionTable(Structure):
    BuildingPlacement: Annotated[
        cGcBuildingDefinitionData, Field(cGcBuildingDefinitionData, 0x0)
    ]
    BuildingFiles: Annotated[
        cGcBuildingFilenameList, Field(cGcBuildingFilenameList, 0x2580)
    ]
    ClusterLayouts: Annotated[
        basic.cTkDynamicArray[cGcBuildingClusterLayout],
        Field(basic.cTkDynamicArray[cGcBuildingClusterLayout], 0xF000),
    ]


@partial_struct
class cGcSpaceSkyColourSettingList(Structure):
    Settings: Annotated[
        basic.cTkDynamicArray[cGcSolarSystemSkyColourData],
        Field(basic.cTkDynamicArray[cGcSolarSystemSkyColourData], 0x0),
    ]


@partial_struct
class cGcNPCColourTable(Structure):
    Groups: Annotated[
        basic.cTkDynamicArray[cGcNPCColourGroup],
        Field(basic.cTkDynamicArray[cGcNPCColourGroup], 0x0),
    ]


@partial_struct
class cGcHeavyAirList(Structure):
    Options: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]


@partial_struct
class cGcBiomeListPerStarType(Structure):
    StarType: Annotated[cGcBiomeList, Field(cGcBiomeList, 0x0)]
    AbandonedYellow: Annotated[cGcBiomeList, Field(cGcBiomeList, 0x2A8)]
    LushYellow: Annotated[cGcBiomeList, Field(cGcBiomeList, 0x330)]
    AbandonedLifeChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3B8)]
    LifeChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C8)]
    ConvertDeadToWeird: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D8)]


@partial_struct
class cGcDeprecatedAssetsTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x80],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x80], 0x0),
    ]


@partial_struct
class cGcTileTypeSets(Structure):
    TileTypeSets: Annotated[
        basic.cTkDynamicArray[cGcTileTypeSet],
        Field(basic.cTkDynamicArray[cGcTileTypeSet], 0x0),
    ]


@partial_struct
class cGcTerrainTexture(Structure):
    DiffuseTexture: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    NormalMap: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    TextureConfig: Annotated[
        cGcTerrainTextureSettings, Field(cGcTerrainTextureSettings, 0x20)
    ]


@partial_struct
class cGcSpawnDensityList(Structure):
    DensityList: Annotated[
        basic.cTkDynamicArray[cGcSpawnDensity],
        Field(basic.cTkDynamicArray[cGcSpawnDensity], 0x0),
    ]


@partial_struct
class cGcCreatureGenerationData(Structure):
    SubBiomeSpecific: Annotated[
        cGcCreatureGenerationOptionalWeightedList,
        Field(cGcCreatureGenerationOptionalWeightedList, 0x0),
    ]
    BiomeSpecific: Annotated[
        cGcCreatureGenerationOptionalWeightedList,
        Field(cGcCreatureGenerationOptionalWeightedList, 0x900),
    ]
    AbandonedSystemSpecific: Annotated[
        cGcCreatureGenerationOptionalWeightedList,
        Field(cGcCreatureGenerationOptionalWeightedList, 0xDC8),
    ]
    EmptySystemSpecific: Annotated[
        cGcCreatureGenerationOptionalWeightedList,
        Field(cGcCreatureGenerationOptionalWeightedList, 0xE10),
    ]
    PurpleSystemSpecific: Annotated[
        cGcCreatureGenerationOptionalWeightedList,
        Field(cGcCreatureGenerationOptionalWeightedList, 0xE58),
    ]
    Generic: Annotated[
        cGcCreatureGenerationWeightedList,
        Field(cGcCreatureGenerationWeightedList, 0xEA0),
    ]
    AirArchetypesForEmptyGround: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry],
        Field(
            basic.cTkDynamicArray[cGcCreatureGenerationWeightedListDomainEntry], 0xEE0
        ),
    ]
    SandwormPresenceChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEF0)]
    AirGroupsPerKm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF34)]
    CaveGroupsPerKm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF44)]
    DensityModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF54)]
    GroundGroupsPerKm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF64)]
    LifeChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF74)]
    LifeLevelDensityModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF84)]
    RarityFrequencyModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF94)]
    RoleFrequencyModifiers: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFA4)]
    WaterGroupsPerKm: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFB4)]
    HerdCreaturePenalty: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC4)]


@partial_struct
class cGcCreatureGenerationArchetypes(Structure):
    AirArchetypes: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainTable],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainTable], 0x0),
    ]
    CaveArchetypes: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainTable],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainTable], 0x10),
    ]
    GroundArchetypes: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainTable],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainTable], 0x20),
    ]
    WaterArchetypes: Annotated[
        basic.cTkDynamicArray[cGcCreatureGenerationDomainTable],
        Field(basic.cTkDynamicArray[cGcCreatureGenerationDomainTable], 0x30),
    ]


@partial_struct
class cGcOverlayTexture(Structure):
    OverlayDiffuse: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)
    ]
    OverlayMasks: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x10)
    ]
    OverlayNormal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    OverlayMaskIdx: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]


@partial_struct
class cGcWeatherTable(Structure):
    Table: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    DefaultRadiation: Annotated[cGcHazardValues, Field(cGcHazardValues, 0x110)]
    DefaultSpookLevel: Annotated[cGcHazardValues, Field(cGcHazardValues, 0x140)]
    DefaultTemperature: Annotated[cGcHazardValues, Field(cGcHazardValues, 0x170)]
    DefaultToxicity: Annotated[cGcHazardValues, Field(cGcHazardValues, 0x1A0)]


@partial_struct
class cGcWaterColourSettingList(Structure):
    Settings: Annotated[
        basic.cTkDynamicArray[cGcPlanetWaterColourData],
        Field(basic.cTkDynamicArray[cGcPlanetWaterColourData], 0x0),
    ]
    EmissionTypeSelection: Annotated[
        cGcWaterEmissionBiomeData, Field(cGcWaterEmissionBiomeData, 0x10)
    ]


@partial_struct
class cGcGasGiantAtmosphereSettingsList(Structure):
    LookUps: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x0),
    ]
    Normals: Annotated[
        basic.cTkDynamicArray[basic.VariableSizeString],
        Field(basic.cTkDynamicArray[basic.VariableSizeString], 0x10),
    ]
    Settings: Annotated[
        basic.cTkDynamicArray[cGcGasGiantAtmosphereSetting],
        Field(basic.cTkDynamicArray[cGcGasGiantAtmosphereSetting], 0x20),
    ]


@partial_struct
class cGcPlanetaryMappingTable(Structure):
    MappingInfo: Annotated[
        cGcPlanetaryMappingValues, Field(cGcPlanetaryMappingValues, 0x0)
    ]


@partial_struct
class cGcAmbientModeCameras(Structure):
    BuildingCameraAnimations: Annotated[
        basic.cTkDynamicArray[cGcCameraAmbientBuildingData],
        Field(basic.cTkDynamicArray[cGcCameraAmbientBuildingData], 0x0),
    ]
    SpaceCameraAnimations: Annotated[
        basic.cTkDynamicArray[cGcCameraAmbientSpaceData],
        Field(basic.cTkDynamicArray[cGcCameraAmbientSpaceData], 0x10),
    ]
    SpecialCameraAnimations: Annotated[
        basic.cTkDynamicArray[cGcCameraAmbientSpecialData],
        Field(basic.cTkDynamicArray[cGcCameraAmbientSpecialData], 0x20),
    ]


@partial_struct
class cGcShipAIAttackDataTable(Structure):
    TraderAttackLookup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    BehaviourTable: Annotated[
        basic.cTkDynamicArray[cGcShipAIAttackData],
        Field(basic.cTkDynamicArray[cGcShipAIAttackData], 0x40),
    ]
    Definitions: Annotated[
        basic.cTkDynamicArray[cGcShipAICombatDefinition],
        Field(basic.cTkDynamicArray[cGcShipAICombatDefinition], 0x50),
    ]
    EngineTable: Annotated[
        basic.cTkDynamicArray[cGcSpaceshipTravelData],
        Field(basic.cTkDynamicArray[cGcSpaceshipTravelData], 0x60),
    ]
    ShieldTable: Annotated[
        basic.cTkDynamicArray[cGcSpaceshipShieldData],
        Field(basic.cTkDynamicArray[cGcSpaceshipShieldData], 0x70),
    ]


@partial_struct
class cGcAISpaceshipComponentData(Structure):
    Hangar: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    CombatDefinitionID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Axis: Annotated[
        c_enum32[enums.cGcPrimaryAxis], Field(c_enum32[enums.cGcPrimaryAxis], 0x30)
    ]
    Class: Annotated[
        c_enum32[enums.cGcSpaceshipClasses],
        Field(c_enum32[enums.cGcSpaceshipClasses], 0x34),
    ]
    Type: Annotated[
        c_enum32[enums.cGcAISpaceshipTypes],
        Field(c_enum32[enums.cGcAISpaceshipTypes], 0x38),
    ]
    IsSpaceAnomaly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x3C)]


@partial_struct
class cTkGravityComponentData(Structure):
    OverrideBounds: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    FalloffRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    MoveWithParent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x18)]


@partial_struct
class cGcShipAccesswayComponentData(Structure):
    HasCustomInFlightAnimations: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcFreighterSyncComponentData(Structure):
    Dummy: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x0)]


@partial_struct
class cGcEngineComponentData(Structure):
    Type: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]


@partial_struct
class cGcLandingGearComponentData(Structure):
    ExtendAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    FlyingAnim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    DeployTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    EndAudioEvent: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0x24),
    ]
    LandTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    RetractTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    StartAudioEvent: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0x30),
    ]
    TakeOffTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    DeployCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x38)
    ]
    FlyingCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x39)
    ]
    RetractCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x3A)
    ]


@partial_struct
class cGcSpaceshipShieldComponentData(Structure):
    ShieldID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    IgnoreHitsWhenPlayerAimingElsewhere: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0x10)
    ]
    RotateOnHit: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcVehicleCheckpointComponentData(Structure):
    class eCheckpointTypeEnum(IntEnum):
        Checkpoint = 0x0
        Start = 0x1

    CheckpointType: Annotated[
        c_enum32[eCheckpointTypeEnum], Field(c_enum32[eCheckpointTypeEnum], 0x0)
    ]

    class eRaceTypeEnum(IntEnum):
        Vehicle = 0x0
        Spaceship = 0x1

    RaceType: Annotated[c_enum32[eRaceTypeEnum], Field(c_enum32[eRaceTypeEnum], 0x4)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cGcVehicleGarageComponentData(Structure):
    Vehicle: Annotated[
        c_enum32[enums.cGcVehicleType], Field(c_enum32[enums.cGcVehicleType], 0x0)
    ]


@partial_struct
class cGcVehicleRaceInviteComponentData(Structure):
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]


@partial_struct
class cGcVehicleComponentData(Structure):
    WheelModel: Annotated[cTkModelResource, Field(cTkModelResource, 0x0)]
    Cockpit: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    VehicleType: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    BaseHealth: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    Class: Annotated[
        c_enum32[enums.cGcVehicleType], Field(c_enum32[enums.cGcVehicleType], 0x44)
    ]
    FoVFixedDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    MaxHeadPitchDown: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]
    MaxHeadPitchUp: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    MaxHeadTurn: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    MinTurretAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]


@partial_struct
class cGcWaypointComponentData(Structure):
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]


@partial_struct
class cGcInputActionInfoMap(Structure):
    ActionMap: Annotated[cGcInputActionInfo, Field(cGcInputActionInfo, 0x0)]


@partial_struct
class cGcActionSets(Structure):
    ActionSets: Annotated[
        basic.cTkDynamicArray[cGcActionSet],
        Field(basic.cTkDynamicArray[cGcActionSet], 0x0),
    ]


@partial_struct
class cGcVibrationDataTable(Structure):
    Data: Annotated[
        basic.cTkDynamicArray[cGcVibrationChannelData],
        Field(basic.cTkDynamicArray[cGcVibrationChannelData], 0x0),
    ]


@partial_struct
class cGcTriggerFeedbackStateTable(Structure):
    Events: Annotated[
        basic.cTkDynamicArray[cGcTriggerFeedbackState],
        Field(basic.cTkDynamicArray[cGcTriggerFeedbackState], 0x0),
    ]


@partial_struct
class cGcBaseBuildingEntry(Structure):
    LinkGridData: Annotated[cGcBaseLinkGridData, Field(cGcBaseLinkGridData, 0x0)]
    ColourPaletteGroupId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x58)]
    DefaultColourPaletteId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x78)]
    DefaultMaterialId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x98)]
    DescriptorID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0xB8)]
    MaterialGroupId: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0xD8)]
    NPCInteractionScene: Annotated[cTkModelResource, Field(cTkModelResource, 0xF8)]
    PlacementScene: Annotated[cTkModelResource, Field(cTkModelResource, 0x118)]
    SinglePartID: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x138)]
    CompositePartObjectIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x158),
    ]
    FamilyIDs: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x168),
    ]
    FossilDisplayID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x178)]
    Groups: Annotated[
        basic.cTkDynamicArray[cGcBaseBuildingEntryGroup],
        Field(basic.cTkDynamicArray[cGcBaseBuildingEntryGroup], 0x188),
    ]
    IconOverrideProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x198)]
    ID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1A8)]
    ModularCustomisationBaseID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1B8)]
    OverrideProductID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1C8)]
    Tag: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1D8)]

    class eBaseTerrainEditShapeEnum(IntEnum):
        Cube = 0x0
        Cylinder = 0x1

    BaseTerrainEditShape: Annotated[
        c_enum32[eBaseTerrainEditShapeEnum],
        Field(c_enum32[eBaseTerrainEditShapeEnum], 0x1E8),
    ]
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0x1EC)
    ]
    BuildEffectAccelerator: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1F0)]
    CorvetteBaseLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1F4)]
    DecorationType: Annotated[
        c_enum32[enums.cGcBaseBuildingObjectDecorationTypes],
        Field(c_enum32[enums.cGcBaseBuildingObjectDecorationTypes], 0x1F8),
    ]
    FreighterBaseLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1FC)]
    GhostsCountOverride: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x200)]
    MinimumDeleteDistance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x204)]
    PlanetBaseLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x208)]
    PlanetLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20C)]
    RegionLimit: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x210)]
    RegionSpawnLOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x214)]
    SnappingDistanceOverride: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x218)]
    StorageContainerIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x21C)]
    Style: Annotated[
        c_enum32[enums.cGcBaseBuildingPartStyle],
        Field(c_enum32[enums.cGcBaseBuildingPartStyle], 0x220),
    ]
    BuildableAboveWater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x224)]
    BuildableInShipDecorative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x225)]
    BuildableInShipStructural: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x226)]
    BuildableOnFreighter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x227)]
    BuildableOnPlanet: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x228)]
    BuildableOnPlanetBase: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x229)]
    BuildableOnPlanetWithProduct: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22A)]
    BuildableOnSpaceBase: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22B)]
    BuildableUnderwater: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22C)]
    CanChangeColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22D)]
    CanChangeMaterial: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22E)]
    CanPickUp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x22F)]
    CanRotate3D: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x230)]
    CanScale: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x231)]
    CanStack: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x232)]
    CheckPlaceholderCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x233)]
    CheckPlayerCollision: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x234)]
    CloseMenuAfterBuild: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x235)]
    EditsTerrain: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x236)]
    HasDescriptor: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x237)]
    IsDecoration: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x238)]
    IsFromModFolder: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x239)]
    IsModularCustomisation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23A)]
    IsPlaceable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23B)]
    IsSealed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23C)]
    IsTemporary: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23D)]
    RemovesAttachedDecoration: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23E)]
    RemovesWhenUnsnapped: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x23F)]
    ShowGhosts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x240)]
    ShowInBuildMenu: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x241)]
    SnapRotateBlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x242)]
    UseProductIDOverride: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x243)]


@partial_struct
class cTkAttachmentData(Structure):
    AdditionalData: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    Components: Annotated[
        basic.cTkDynamicArray[basic.LinkableNMSTemplate],
        Field(basic.cTkDynamicArray[basic.LinkableNMSTemplate], 0x10),
    ]
    LodDistances: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]


@partial_struct
class cTkSpeedLineData(Structure):
    ColourEnd: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    ColourOrigin: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    Material: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)]
    Alpha: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    FadeTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]
    Length: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    Lifetime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]

    class eLinesPositionEnum(IntEnum):
        Absolute = 0x0
        Relative = 0x1

    LinesPosition: Annotated[
        c_enum32[eLinesPositionEnum], Field(c_enum32[eLinesPositionEnum], 0x40)
    ]
    MaxVisibleSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MinVisibleSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x48)]
    NumberOfParticles: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4C)]
    Radius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    RemoveCylinderRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]


@partial_struct
class cTkTrailData(Structure):
    DistanceThreshold: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    FrontPoints: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    FrontUvEnd: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    MaxPointsPerFrame: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    PointLife: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Points: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]


@partial_struct
class cAxisSpecification(Structure):
    CustomAxis: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]

    class eAxisEnum(IntEnum):
        X = 0x0
        Y = 0x1
        Z = 0x2
        NegativeX = 0x3
        NegativeY = 0x4
        NegativeZ = 0x5
        CustomAxis = 0x6

    Axis: Annotated[c_enum32[eAxisEnum], Field(c_enum32[eAxisEnum], 0x10)]


@partial_struct
class cDirectMesh(Structure):
    NumPointsInDirectMeshI: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x0)]
    NumPointsInDirectMeshJ: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x4)]
    NumSimPointsI: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x8)]
    NumSimPointsJ: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    VertexOrdering: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10)]
    NodeName: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x14)]
    RenderVertexBasedCloth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x54)]


@partial_struct
class cMappedMesh(Structure):
    NodeName: Annotated[basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x0)]


@partial_struct
class cShapePoint(Structure):
    Position: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Uv: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x10)]


@partial_struct
class cMappingInfluence(Structure):
    mTransformInClothT_Axis0: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    mTransformInClothT_Axis1: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    mTransformInClothT_Axis2: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    mTransformInClothT_Pos: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    DistanceSquared: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SimP: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]


@partial_struct
class cTkVoxelGeneratorRegionData(Structure):
    FlattenTerrainPoints: Annotated[
        basic.cTkDynamicArray[cTkNoiseFlattenPoint],
        Field(basic.cTkDynamicArray[cTkNoiseFlattenPoint], 0x0),
    ]
    FlattenTypeChances: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x10),
    ]
    ShelterIndices: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x20)]
    AddShelterChance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    LandingPadIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    NumShelters: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    PlanetRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38)]
    VoronoiPointDivisions: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    VoronoiPointSeed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x40)]
    VoronoiSectorSeed: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x44)]
    WaypointIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]


@partial_struct
class cTkNoiseUberLayerData(Structure):
    NoiseData: Annotated[cTkNoiseUberData, Field(cTkNoiseUberData, 0x0)]
    Height: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]
    MaximumLOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x48)]
    Offset: Annotated[
        c_enum32[enums.cTkNoiseOffsetEnum],
        Field(c_enum32[enums.cTkNoiseOffsetEnum], 0x4C),
    ]
    PlateauRegionSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x50)]
    PlateauSharpness: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    PlateauStratas: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    RegionGain: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]
    RegionRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]
    RegionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x64)]
    SeedOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x68)]
    SmoothRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x6C)]
    TileBlendMeters: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x70)]
    VoxelType: Annotated[
        c_enum32[enums.cTkNoiseVoxelTypeEnum],
        Field(c_enum32[enums.cTkNoiseVoxelTypeEnum], 0x74),
    ]

    class eWaterFadeEnum(IntEnum):
        None_ = 0x0
        Above = 0x1
        Below = 0x2

    WaterFade: Annotated[
        c_enum32[eWaterFadeEnum], Field(c_enum32[eWaterFadeEnum], 0x78)
    ]
    Width: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x7C)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x80)]
    Subtract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x81)]


@partial_struct
class cTkNoiseGridData(Structure):
    Filename: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x0)]
    TurbulenceNoiseLayer: Annotated[
        cTkNoiseUberLayerData, Field(cTkNoiseUberLayerData, 0x10)
    ]
    SuperPrimitive: Annotated[
        cTkNoiseSuperPrimitiveData, Field(cTkNoiseSuperPrimitiveData, 0x94)
    ]
    SuperFormula1: Annotated[
        cTkNoiseSuperFormulaData, Field(cTkNoiseSuperFormulaData, 0xB0)
    ]
    SuperFormula2: Annotated[
        cTkNoiseSuperFormulaData, Field(cTkNoiseSuperFormulaData, 0xC0)
    ]
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD0)]
    MaxHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD4)]
    MaxHeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xD8)]
    MaximumLOD: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xDC)]
    MaxWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE0)]
    MinHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE4)]
    MinHeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xE8)]
    MinWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xEC)]

    class eNoiseGridTypeEnum(IntEnum):
        Cube = 0x0
        Cone = 0x1
        Torus = 0x2
        Sphere = 0x3
        Cylinder = 0x4
        Capsule = 0x5
        Corridor = 0x6
        Pipe = 0x7
        Puck = 0x8
        SuperPrimitiveRandom = 0x9
        SuperFormula_01 = 0xA
        SuperFormula_02 = 0xB
        SuperFormula_03 = 0xC
        SuperFormula_04 = 0xD
        SuperFormula_05 = 0xE
        SuperFormula_06 = 0xF
        SuperFormula_07 = 0x10
        SuperFormula_08 = 0x11
        SuperFormulaRandom = 0x12
        SuperFormula = 0x13
        SuperPrimitive = 0x14
        File = 0x15

    NoiseGridType: Annotated[
        c_enum32[eNoiseGridTypeEnum], Field(c_enum32[eNoiseGridTypeEnum], 0xF0)
    ]
    Offset: Annotated[
        c_enum32[enums.cTkNoiseOffsetEnum],
        Field(c_enum32[enums.cTkNoiseOffsetEnum], 0xF4),
    ]
    Pitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xF8)]
    RandomPrimitive: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xFC)]
    RegionRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x100)]
    RegionScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x104)]
    Roll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x108)]
    SeedOffset: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x10C)]
    SmoothRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x110)]
    TileBlendMeters: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x114)]
    VaryPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x118)]
    VaryRoll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x11C)]
    VaryYaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x120)]
    VoxelType: Annotated[
        c_enum32[enums.cTkNoiseVoxelTypeEnum],
        Field(c_enum32[enums.cTkNoiseVoxelTypeEnum], 0x124),
    ]
    Yaw: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x128)]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12C)]
    Hemisphere: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12D)]
    Subtract: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12E)]
    SwapZY: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12F)]


@partial_struct
class cTkVirtualBinding(Structure):
    CustomLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    AltHudLayerIDs: Annotated[
        basic.cTkDynamicArray[cTkVirtualBindingAltLayer],
        Field(basic.cTkDynamicArray[cTkVirtualBindingAltLayer], 0x20),
    ]
    HudLayerID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    TogglableActions: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cGcInputActions]], 0x40),
    ]
    BottomAction: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x50)
    ]
    LeftAction: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x54)
    ]
    RightAction: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x58)
    ]
    TopAction: Annotated[
        c_enum32[enums.cGcInputActions], Field(c_enum32[enums.cGcInputActions], 0x5C)
    ]
    Active: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    DefaultActive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]
    DirectionalActions: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x62)]
    SupportsJoystick: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x63)]


@partial_struct
class cTkButtonPathMapping(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    OverlayIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    SolidIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    SpecialIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    Hand: Annotated[
        c_enum32[enums.cTkInputHandEnum], Field(c_enum32[enums.cTkInputHandEnum], 0x50)
    ]
    Id: Annotated[
        c_enum32[enums.cTkInputEnum], Field(c_enum32[enums.cTkInputEnum], 0x54)
    ]
    OpenVROriginNames: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x58)
    ]


@partial_struct
class cTkButtonImageLookup(Structure):
    Lookup: Annotated[
        basic.cTkDynamicArray[cTkButtonPathMapping],
        Field(basic.cTkDynamicArray[cTkButtonPathMapping], 0x0),
    ]


@partial_struct
class cTkChordPathMapping(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    ButtonIds: Annotated[
        basic.cTkDynamicArray[c_enum32[enums.cTkInputEnum]],
        Field(basic.cTkDynamicArray[c_enum32[enums.cTkInputEnum]], 0x20),
    ]
    OverlayIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    SolidIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    SpecialIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x50)
    ]
    TextTag: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]


@partial_struct
class cTkChordsImageLookup(Structure):
    Lookup: Annotated[
        basic.cTkDynamicArray[cTkChordPathMapping],
        Field(basic.cTkDynamicArray[cTkChordPathMapping], 0x0),
    ]


@partial_struct
class cTkActionButtonMap(Structure):
    ActionId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Platforms: Annotated[
        basic.cTkDynamicArray[cTkPlatformButtonPair],
        Field(basic.cTkDynamicArray[cTkPlatformButtonPair], 0x10),
    ]
    PadButtonId: Annotated[
        c_enum32[enums.cTkInputEnum], Field(c_enum32[enums.cTkInputEnum], 0x20)
    ]
    ScaleToFitFont: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cTkActionButtonLookup(Structure):
    Lookup: Annotated[
        basic.cTkDynamicArray[cTkActionButtonMap],
        Field(basic.cTkDynamicArray[cTkActionButtonMap], 0x0),
    ]


@partial_struct
class cTkAxisPathMapping(Structure):
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    OverlayIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x20)
    ]
    SolidIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x30)
    ]
    SpecialIcon: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x40)
    ]
    Hand: Annotated[
        c_enum32[enums.cTkInputHandEnum], Field(c_enum32[enums.cTkInputHandEnum], 0x50)
    ]
    Id: Annotated[
        c_enum32[enums.cTkInputAxisEnum], Field(c_enum32[enums.cTkInputAxisEnum], 0x54)
    ]
    OpenVROriginNames: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x58)
    ]


@partial_struct
class cTkAxisImageLookup(Structure):
    Lookup: Annotated[
        basic.cTkDynamicArray[cTkAxisPathMapping],
        Field(basic.cTkDynamicArray[cTkAxisPathMapping], 0x0),
    ]


@partial_struct
class cTkTestMetadata(Structure):
    DocOptionalVector: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    TestColour: Annotated[basic.Colour, Field(basic.Colour, 0x10)]
    TestVector: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    TestVector4: Annotated[basic.Vector4f, Field(basic.Vector4f, 0x30)]
    TestClass: Annotated[cTkTrophyEntry, Field(cTkTrophyEntry, 0x40)]
    TestExternalBitfieldEnumArray: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0xB8)
    ]
    TestHashMap: Annotated[cTkLocalisationEntry, Field(cTkLocalisationEntry, 0xF8)]
    DocOptionalRenamed: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x128)
    ]
    TestID256: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x148)]
    TestLocID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x168)
    ]
    TestHashedString: Annotated[basic.HashedString, Field(basic.HashedString, 0x188)]
    TestClassPointer: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x1A0)]
    TestDynamicArray: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x1B0),
    ]
    TestDynamicString: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x1C0)
    ]
    TestID: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1D0)]
    TestIDLookup: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x1E0)]
    TestLinkableClassPointerArray: Annotated[
        basic.cTkDynamicArray[basic.LinkableNMSTemplate],
        Field(basic.cTkDynamicArray[basic.LinkableNMSTemplate], 0x1F0),
    ]
    TestModelFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x200)
    ]
    TestSeed: Annotated[basic.GcSeed, Field(basic.GcSeed, 0x210)]
    TestTextureFilename: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x220)
    ]
    TestInt64: Annotated[ctypes.c_int64, Field(ctypes.c_int64, 0x230)]
    TestUInt64: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x238)]
    TestUniqueId: Annotated[ctypes.c_uint64, Field(ctypes.c_uint64, 0x240)]
    TestStaticArray: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x248)]
    TestExternalEnumArray: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x270)]
    TestEnumArray: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x284)]
    TestVector2: Annotated[basic.Vector2f, Field(basic.Vector2f, 0x294)]

    class eDocOptionalEnumEnum(IntEnum):
        SomeValue1 = 0x0
        SomeValue2 = 0x1
        SomeValue3 = 0x2
        SomeValue4 = 0x3

    DocOptionalEnum: Annotated[
        c_enum32[eDocOptionalEnumEnum], Field(c_enum32[eDocOptionalEnumEnum], 0x29C)
    ]
    TestAudioEvent: Annotated[
        c_enum32[enums.cGcAudioWwiseEvents],
        Field(c_enum32[enums.cGcAudioWwiseEvents], 0x2A0),
    ]

    class eTestEnumEnum(IntEnum):
        Default = 0x0
        Option1 = 0x1
        Option2 = 0x2
        Option3 = 0x3

    TestEnum: Annotated[c_enum32[eTestEnumEnum], Field(c_enum32[eTestEnumEnum], 0x2A4)]

    class eTestEnumClassEnum(IntEnum):
        Default = 0x0
        Option1 = 0x1
        Option2 = 0x2
        Option3 = 0x3

    TestEnumClass: Annotated[
        c_enum32[eTestEnumClassEnum], Field(c_enum32[eTestEnumClassEnum], 0x2A8)
    ]

    class eTestEnumUInt32BitFieldEnum(IntEnum):
        empty = 0x0
        Enum1 = 0x1
        Enum2 = 0x2
        Enum3 = 0x4

    TestEnumUInt32BitField: Annotated[
        c_enum32[eTestEnumUInt32BitFieldEnum],
        Field(c_enum32[eTestEnumUInt32BitFieldEnum], 0x2AC),
    ]
    TestExternalEnum: Annotated[
        c_enum32[enums.cTkLanguages], Field(c_enum32[enums.cTkLanguages], 0x2B0)
    ]

    class eTestFlagsEnum(IntEnum):
        empty = 0x0
        Flag1 = 0x1
        Flag2 = 0x2
        Flag3 = 0x4

    TestFlags: Annotated[
        c_enum32[eTestFlagsEnum], Field(c_enum32[eTestFlagsEnum], 0x2B4)
    ]
    TestFloat: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2B8)]

    class eTestInlineEnumEnum(IntEnum):
        Default = 0x0
        NotDefault = 0x1
        Other = 0x2

    TestInlineEnum: Annotated[
        c_enum32[eTestInlineEnumEnum], Field(c_enum32[eTestInlineEnumEnum], 0x2BC)
    ]
    TestInt: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C0)]
    TestNodeHandle: Annotated[basic.GcNodeID, Field(basic.GcNodeID, 0x2C4)]
    TestResource: Annotated[basic.GcResource, Field(basic.GcResource, 0x2C8)]
    TestUInt32: Annotated[ctypes.c_uint32, Field(ctypes.c_uint32, 0x2CC)]
    TestInt16: Annotated[ctypes.c_int16, Field(ctypes.c_int16, 0x2D0)]
    TestUInt16: Annotated[ctypes.c_uint16, Field(ctypes.c_uint16, 0x2D2)]
    TestString2048: Annotated[
        basic.cTkFixedString0x800, Field(basic.cTkFixedString0x800, 0x2D4)
    ]
    TestString1024: Annotated[
        basic.cTkFixedString0x400, Field(basic.cTkFixedString0x400, 0xAD4)
    ]
    TestString512: Annotated[
        basic.cTkFixedString0x200, Field(basic.cTkFixedString0x200, 0xED4)
    ]
    TestString256: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x10D4)
    ]
    TestString128: Annotated[
        basic.cTkFixedString0x80, Field(basic.cTkFixedString0x80, 0x11D4)
    ]
    DocRenamedString64: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x1254)
    ]
    TestString64: Annotated[
        basic.cTkFixedString0x40, Field(basic.cTkFixedString0x40, 0x1294)
    ]
    TestString: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x12D4)
    ]
    TestColour32: Annotated[basic.Colour32, Field(basic.Colour32, 0x12F4)]
    TestBool: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x12F8)]
    TestByte: Annotated[ctypes.c_byte, Field(ctypes.c_byte, 0x12F9)]

    class eTestEnumUInt8Enum(IntEnum):
        Enum1 = 0x0
        Enum2 = 0x1
        Enum3 = 0x2

    TestEnumUInt8: Annotated[
        c_enum32[eTestEnumUInt8Enum], Field(c_enum32[eTestEnumUInt8Enum], 0x12FA)
    ]
    TestInt8: Annotated[ctypes.c_int8, Field(ctypes.c_int8, 0x12FB)]


@partial_struct
class cTkReplacementResource(Structure):
    Original: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x0)]
    Replacement: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x18)]


@partial_struct
class cTkInputFrameArray(Structure):
    Array: Annotated[cTkInputFrame, Field(cTkInputFrame, 0x0)]


@partial_struct
class cTkMaterialMetaData(Structure):
    WaveOneAmplitude: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    WaveOneFallOff: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    WaveOneFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x20)]
    WaveTwoAmplitude: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x30)]
    WaveTwoFallOff: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    WaveTwoFrequency: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x50)]
    ShaderMillData: Annotated[
        cTkMaterialShaderMillData, Field(cTkMaterialShaderMillData, 0x60)
    ]
    DetailNormal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x2F8)
    ]
    ExternalMaterial: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x308)
    ]
    ForceDiffuse: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x318)
    ]
    ForceFeature: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x328)
    ]
    ForceMask: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x338)
    ]
    ForceNormal: Annotated[
        basic.VariableSizeString, Field(basic.VariableSizeString, 0x348)
    ]
    BillboardSphereFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x358)]
    BranchHSwing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x35C)]
    BranchTrunkAnim: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x360)]
    BranchVSwing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x364)]
    DetailHeightBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x368)]
    DetailHeightBoost: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x36C)]
    FurNoiseScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x370)]
    FurNoiseThickness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x374)]
    FurNoiseTurbulence: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x378)]
    FurTurbulenceScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x37C)]
    Glow: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x380)]
    HeightScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x384)]
    IBLWeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x388)]
    LeafNoise: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x38C)]
    LeafSwing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x390)]
    NormalTiling: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x394)]
    NumSteps: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x398)]
    ParallaxDepth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x39C)]
    ParticleRefractionBrightnessMultiplier: Annotated[
        ctypes.c_float, Field(ctypes.c_float, 0x3A0)
    ]
    ParticleRefractionStrengthX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A4)]
    ParticleRefractionStrengthY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3A8)]
    ParticleRefractionTint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3AC)]
    ReactivityBias: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3B0)]
    Reflectance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3B4)]
    Refraction: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3B8)]
    RefractionIndex: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3BC)]
    Roughness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C0)]

    class eShaderEnum(IntEnum):
        UberShader = 0x0
        Sky = 0x1
        Screen = 0x2
        UberHack = 0x3
        UIScreen = 0x4
        Decal = 0x5
        Particle = 0x6
        ReflectionProbe = 0x7

    Shader: Annotated[c_enum32[eShaderEnum], Field(c_enum32[eShaderEnum], 0x3C4)]
    ShadowFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C8)]
    ShellsHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3CC)]
    SoftFadeStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D0)]
    Subsurface: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D4)]
    TerrainNormalFactor: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3D8)]
    TessellationHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3DC)]
    TopBlend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E0)]
    TopBlendOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E4)]
    TopBlendSharpness: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3E8)]
    TransparencyLayerID: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x3EC)]
    TrunkBend: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F0)]
    UVFrameTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F4)]
    UVNumTilesX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3F8)]
    UVNumTilesY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3FC)]
    UVScrollNormalX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x400)]
    UVScrollNormalY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x404)]
    UVScrollX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x408)]
    UVScrollY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40C)]
    WaveOneSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x410)]
    WaveTwoSpeed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x414)]
    MaterialClass: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x418)
    ]
    Additive: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x438)]
    AlphaCutout: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x439)]
    AlwaysOnTopUI: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43A)]
    AnisotropicFilter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43B)]
    AOMap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43C)]
    BeforeUI: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43D)]
    BentNormals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43E)]
    Billboard: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x43F)]
    BrightEdge: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x440)]
    CameraRelative: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x441)]
    CastShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x442)]
    Colourisable: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x443)]
    ColourMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x444)]
    CreateFur: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x445)]
    DecalNormalOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x446)]
    DecalTerrainOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x447)]
    DepthMaskUI: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x448)]
    DisablePostProcess: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x449)]
    DisableZTest: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44A)]
    DisplacementPositionOffset: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44B)]
    DisplacementWave: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44C)]
    Dissolve: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44D)]
    DoubleBufferGeometry: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44E)]
    DoubleSided: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44F)]
    DoubleSidedKeepNormals: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x450)]
    DrawToBloom: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x451)]
    DrawToLensFlare: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x452)]
    EnableLodFade: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x453)]
    FeatureMap: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x454)]
    FullPrecisionPosition: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x455)]
    GlowMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x456)]
    HighQualityParticle: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x457)]
    ImageBasedLighting: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x458)]
    Imposter: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x459)]
    InvertAlpha: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45A)]
    LightLayers: Annotated[
        c_enum32[enums.cTkLightLayer], Field(c_enum32[enums.cTkLightLayer], 0x45B)
    ]
    MatchGroundColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45C)]
    MergedMeshBillboard: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45D)]
    Metallic: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45E)]
    MetallicMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x45F)]
    Multitexture: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x460)]
    ParallaxMapped: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x461)]
    ReceiveShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x462)]
    ReflectanceMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x463)]
    ReflectionProbe: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x464)]
    RefractionMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x465)]
    RotateAroundAt: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x466)]
    RoughnessMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x467)]
    ScanEffect: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x468)]
    ScreenSpaceReflections: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x469)]
    SelfShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46A)]
    ShadowOnly: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46B)]
    SimulatedCloth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46C)]
    SubsurfaceMask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46D)]
    TopBlendFlip: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46E)]
    Transparent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x46F)]
    UISurface: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x470)]
    Unlit: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x471)]
    UseShaderMill: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x472)]
    UVAnimation: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x473)]
    UVScrolling: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x474)]
    UVTileAlts: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x475)]
    VertexAlphaAO: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x476)]
    VertexColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x477)]
    VertexDetailBlend: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x478)]
    Wind: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x479)]
    WriteLogZ: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x47A)]


@partial_struct
class cTkEmitterWindDrift(Structure):
    CurveBlendMidpoint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    CurveEndValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    CurveMidValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    CurveStartValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    Speed: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Strength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Curve1Shape: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x18)
    ]
    Curve2Shape: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x19)
    ]
    LimitEmitterLifetime: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1A)]
    LimitEmitterSpeed: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x1B)]


@partial_struct
class cTkProceduralTextureLayer(Structure):
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    LinkedLayer: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    Textures: Annotated[
        basic.cTkDynamicArray[cTkProceduralTexture],
        Field(basic.cTkDynamicArray[cTkProceduralTexture], 0x30),
    ]
    Probability: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    SelectToMatchBase: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x44)]


@partial_struct
class cTkEmitterFloatProperty(Structure):
    NextStage: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x0)]

    class eAuthoringEnum(IntEnum):
        FixedValue = 0x0
        RandomRangeFloat = 0x1
        Curves = 0x2

    Authoring: Annotated[
        c_enum32[eAuthoringEnum], Field(c_enum32[eAuthoringEnum], 0x10)
    ]
    CurveBlendMidpoint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    CurveEndValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    CurveMidValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    CurveStartValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    CurveVariation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    FixedValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    MaxRandomValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    MinRandomValue: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Curve1Shape: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x34)
    ]
    Curve2Shape: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x35)
    ]


@partial_struct
class cTkEmitterRotation(Structure):
    RotationAxis: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Rotation: Annotated[cTkEmitterFloatProperty, Field(cTkEmitterFloatProperty, 0x10)]

    class eAlignmentAxisEnum(IntEnum):
        Rotation = 0x0
        Velocity = 0x1
        VelocityScreenSpace = 0x2

    AlignmentAxis: Annotated[
        c_enum32[eAlignmentAxisEnum], Field(c_enum32[eAlignmentAxisEnum], 0x48)
    ]
    StartRotationVariation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4C)]


@partial_struct
class cTkProceduralTextureChosenOption(Structure):
    Colour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    OptionName: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x10)]
    Group: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    Layer: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    Palette: Annotated[cTkPaletteTexture, Field(cTkPaletteTexture, 0x50)]
    OverrideColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5C)]


@partial_struct
class cTkModelRendererCameraData(Structure):
    Offset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    Wander: Annotated[cTkCameraWanderData, Field(cTkCameraWanderData, 0x10)]
    Distance: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    LightPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    LightRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    Pitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    Roll: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    Rotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]


@partial_struct
class cTkModelRendererData(Structure):
    Camera: Annotated[
        cTkModelRendererCameraData, Field(cTkModelRendererCameraData, 0x0)
    ]
    FocusOffset: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x40)]
    FocusLocator: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x50)]
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    AspectRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x80)]
    BlendInOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x84)]
    BlendInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x88)]
    FocusInterpTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8C)]

    class eFocusTypeEnum(IntEnum):
        ResourceBounds = 0x0
        ResourceBoundingHeight = 0x1
        NodeBoundingBox = 0x2
        DiscoveryView = 0x3

    FocusType: Annotated[
        c_enum32[eFocusTypeEnum], Field(c_enum32[eFocusTypeEnum], 0x90)
    ]
    Fov: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x94)]
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x98)]
    LightIntensityMultiplier: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x9C)]

    class eThumbnailModeEnum(IntEnum):
        None_ = 0x0
        HUD = 0x1
        GUI = 0x2

    ThumbnailMode: Annotated[
        c_enum32[eThumbnailModeEnum], Field(c_enum32[eThumbnailModeEnum], 0xA0)
    ]
    AlignUIToCameraInHmd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA4)]
    FlipRotationIfNecessary: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA5)]
    LookForFocusInMasterModel: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA6)]
    UsePlayerCameraInHmd: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xA7)]
    UseSensibleCameraFocusNodeIsNowOffsetNode: Annotated[
        ctypes.c_bool, Field(ctypes.c_bool, 0xA8)
    ]


@partial_struct
class cTkModelResourceCameraData(Structure):
    CameraData: Annotated[cTkCameraData, Field(cTkCameraData, 0x0)]
    FocusLocator: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x30)]
    Wander: Annotated[cTkCameraWanderData, Field(cTkCameraWanderData, 0x50)]
    FocusInterpTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x5C)]

    class eResourceFocusTypeEnum(IntEnum):
        ResourceBounds = 0x0
        ResourceBoundingHeight = 0x1
        NodeBoundingBox = 0x2
        World = 0x3

    ResourceFocusType: Annotated[
        c_enum32[eResourceFocusTypeEnum], Field(c_enum32[eResourceFocusTypeEnum], 0x60)
    ]
    UseWorldUp: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x64)]


@partial_struct
class cTkModelResourceData(Structure):
    Camera: Annotated[
        cTkModelResourceCameraData, Field(cTkModelResourceCameraData, 0x0)
    ]
    Anim: Annotated[basic.TkID0x20, Field(basic.TkID0x20, 0x70)]
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    AspectRatio: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA0)]
    BlendInOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA4)]
    BlendInTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xA8)]
    HeightOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xAC)]
    LightPitch: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB0)]
    LightRotate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xB4)]

    class eResourceThumbnailModeEnum(IntEnum):
        None_ = 0x0
        HUD = 0x1
        GUI = 0x2

    ResourceThumbnailMode: Annotated[
        c_enum32[eResourceThumbnailModeEnum],
        Field(c_enum32[eResourceThumbnailModeEnum], 0xB8),
    ]
    CanRotateWithInput: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xBC)]


@partial_struct
class cTkVolumeNavMeshBuildParams(Structure):
    BoundsMax: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x0)]
    BoundsMin: Annotated[basic.Vector3f, Field(basic.Vector3f, 0x10)]
    BaseParams: Annotated[cTkNavMeshBuildParams, Field(cTkNavMeshBuildParams, 0x20)]
    CellsPerUnitHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x54)]
    CellsPerUnitWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x58)]
    NumBorderCells: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x5C)]
    TileSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x60)]


@partial_struct
class cTkAnimCompactMetadata(Structure):
    StillFrameData: Annotated[
        cTkAnimNodeFrameHalfData, Field(cTkAnimNodeFrameHalfData, 0x0)
    ]
    AnimFrameData: Annotated[
        basic.cTkDynamicArray[cTkAnimNodeFrameHalfData],
        Field(basic.cTkDynamicArray[cTkAnimNodeFrameHalfData], 0x30),
    ]
    NodeData: Annotated[
        basic.cTkDynamicArray[cTkAnimNodeData],
        Field(basic.cTkDynamicArray[cTkAnimNodeData], 0x40),
    ]
    FrameCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    NodeCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    Has30HzFrames: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]


@partial_struct
class cTkAnimMetadata(Structure):
    StillFrameData: Annotated[cTkAnimNodeFrameData, Field(cTkAnimNodeFrameData, 0x0)]
    AnimFrameData: Annotated[
        basic.cTkDynamicArray[cTkAnimNodeFrameData],
        Field(basic.cTkDynamicArray[cTkAnimNodeFrameData], 0x30),
    ]
    NodeData: Annotated[
        basic.cTkDynamicArray[cTkAnimNodeData],
        Field(basic.cTkDynamicArray[cTkAnimNodeData], 0x40),
    ]
    FrameCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x50)]
    NodeCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x54)]
    Has30HzFrames: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]


@partial_struct
class cTkNGuiLayoutList(Structure):
    Layouts: Annotated[
        basic.cTkDynamicArray[cTkNGuiLayoutListData],
        Field(basic.cTkDynamicArray[cTkNGuiLayoutListData], 0x0),
    ]


@partial_struct
class cTkNGuiLayoutShortcut(Structure):
    EditorIcon: Annotated[
        c_enum32[enums.cTkNGuiEditorIcons],
        Field(c_enum32[enums.cTkNGuiEditorIcons], 0x0),
    ]
    Name: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x4)]
    Available: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x24)]


@partial_struct
class cTkNGuiGraphicStyleData(Structure):
    CornerRadius: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    Desaturation: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    EditorIcon: Annotated[
        c_enum32[enums.cTkNGuiEditorIcons],
        Field(c_enum32[enums.cTkNGuiEditorIcons], 0x8),
    ]
    GradientEndOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0xC)]
    GradientStartOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    Image: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x14)]
    MarginX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x18)]
    MarginY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x1C)]
    PaddingX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    PaddingY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    StrokeGradientFeather: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    StrokeGradientOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    StrokeSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    Colour: Annotated[basic.Colour32, Field(basic.Colour32, 0x34)]
    GradientColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x38)]
    IconColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x3C)]
    StrokeColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x40)]
    StrokeGradientColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x44)]

    class eGradientEnum(IntEnum):
        None_ = 0x0
        Vertical = 0x1
        Horizontal = 0x2
        HorizontalBounce = 0x3
        Radial = 0x4
        Box = 0x5

    Gradient: Annotated[c_enum32[eGradientEnum], Field(c_enum32[eGradientEnum], 0x48)]
    GradientOffsetPercent: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x49)]
    HasDropShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4A)]
    HasInnerGradient: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4B)]
    HasOuterGradient: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4C)]

    class eShapeEnum(IntEnum):
        Rectangle = 0x0
        Ellipse = 0x1
        Line = 0x2
        LineInverted = 0x3
        Bezier = 0x4
        BezierInverted = 0x5
        BezierWide = 0x6
        BezierWideInverted = 0x7

    Shape: Annotated[c_enum32[eShapeEnum], Field(c_enum32[eShapeEnum], 0x4D)]
    SolidColour: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4E)]
    StrokeGradient: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x4F)]


@partial_struct
class cTkNGuiGraphicStyle(Structure):
    Active: Annotated[cTkNGuiGraphicStyleData, Field(cTkNGuiGraphicStyleData, 0x0)]
    Default: Annotated[cTkNGuiGraphicStyleData, Field(cTkNGuiGraphicStyleData, 0x50)]
    Highlight: Annotated[cTkNGuiGraphicStyleData, Field(cTkNGuiGraphicStyleData, 0xA0)]
    CustomMaxStart: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xF0)]
    CustomMinStart: Annotated[basic.Vector2f, Field(basic.Vector2f, 0xF8)]

    class eAnimateEnum(IntEnum):
        None_ = 0x0
        WipeRightToLeft = 0x1
        SimpleWipe = 0x2
        SimpleWipeDown = 0x3
        CustomWipe = 0x4
        CustomWipeAlpha = 0x5

    Animate: Annotated[c_enum32[eAnimateEnum], Field(c_enum32[eAnimateEnum], 0x100)]
    AnimSplit: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x104)]
    AnimTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x108)]
    GlobalFade: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10C)]
    HighlightScale: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x110)]
    HighlightTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x114)]
    AnimCurve1: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x118)
    ]
    AnimCurve2: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x119)
    ]
    AutoAdjustToChildrenHeight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11A)]
    AutoAdjustToChildrenWidth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11B)]
    DistributeChildrenHeight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11C)]
    DistributeChildrenWidth: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11D)]
    InheritStyleFromParentLayer: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11E)]


@partial_struct
class cTkNGuiTextStyleData(Structure):
    DropShadowAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    DropShadowOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    FontHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    FontIndex: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0xC)]
    FontSpacing: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x10)]
    OutlineSize: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x14)]
    Colour: Annotated[basic.Colour32, Field(basic.Colour32, 0x18)]
    OutlineColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x1C)]
    ShadowColour: Annotated[basic.Colour32, Field(basic.Colour32, 0x20)]
    Align: Annotated[cTkNGuiAlignment, Field(cTkNGuiAlignment, 0x24)]
    AllowScroll: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x26)]
    AutoAdjustFontHeight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x27)]
    AutoAdjustHeight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x28)]
    BlockAudio: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x29)]
    BypassStyleColours: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2A)]
    BypassStyleFont: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2B)]
    BypassStyleFontHeight: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2C)]
    ForceUpperCase: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2D)]
    HasDropShadow: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2E)]
    HasOutline: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x2F)]
    IsIndented: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x30)]
    IsParagraph: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x31)]
    ScrollOnHover: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x32)]


@partial_struct
class cTkNGuiTextStyle(Structure):
    Active: Annotated[cTkNGuiTextStyleData, Field(cTkNGuiTextStyleData, 0x0)]
    Default: Annotated[cTkNGuiTextStyleData, Field(cTkNGuiTextStyleData, 0x34)]
    Highlight: Annotated[cTkNGuiTextStyleData, Field(cTkNGuiTextStyleData, 0x68)]


@partial_struct
class cTkNGuiEditorStyleData(Structure):
    SkinColours: Annotated[
        cTkNGuiEditorStyleColour, Field(cTkNGuiEditorStyleColour, 0x0)
    ]
    Font: Annotated[basic.VariableSizeString, Field(basic.VariableSizeString, 0x480)]
    LayoutShortcuts: Annotated[
        basic.cTkDynamicArray[cTkNGuiLayoutShortcut],
        Field(basic.cTkDynamicArray[cTkNGuiLayoutShortcut], 0x490),
    ]
    SnapSettings: Annotated[
        basic.cTkDynamicArray[ctypes.c_float],
        Field(basic.cTkDynamicArray[ctypes.c_float], 0x4A0),
    ]
    GraphicStyles: Annotated[cTkNGuiGraphicStyle, Field(cTkNGuiGraphicStyle, 0x4B0)]
    TextStyles: Annotated[cTkNGuiTextStyle, Field(cTkNGuiTextStyle, 0x6F90)]
    Sizes: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x78B4)]
    SkinFontHeight: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x79B8)]


@partial_struct
class cTkEntitlementList(Structure):
    Entitlements: Annotated[
        basic.cTkDynamicArray[cTkEntitlementListData],
        Field(basic.cTkDynamicArray[cTkEntitlementListData], 0x0),
    ]


@partial_struct
class cTkNGuiRectanglePulseEffect(Structure):
    PulseOffset: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    PulseRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    PulseWidth: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]
    PulseAlphaCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xC)
    ]
    PulseSizeCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0xD)
    ]


@partial_struct
class cTkIOSDevicePreset(Structure):
    DefaultGraphicsSettings: Annotated[
        cTkGraphicsSettings, Field(cTkGraphicsSettings, 0x0)
    ]
    ModelIdentifiers: Annotated[
        basic.cTkDynamicArray[basic.cTkFixedString0x100],
        Field(basic.cTkDynamicArray[basic.cTkFixedString0x100], 0x1C8),
    ]
    DeviceName: Annotated[
        basic.cTkFixedString0x100, Field(basic.cTkFixedString0x100, 0x1D8)
    ]


@partial_struct
class cTkAnimDetailSettingsTables(Structure):
    Tables: Annotated[
        basic.cTkDynamicArray[cTkAnimDetailSettingsTable],
        Field(basic.cTkDynamicArray[cTkAnimDetailSettingsTable], 0x0),
    ]


@partial_struct
class cTkWaterConditionData(Structure):
    Waves: Annotated[
        basic.cTkDynamicArray[cTkWaveInputData],
        Field(basic.cTkDynamicArray[cTkWaveInputData], 0x0),
    ]
    FoamProperties: Annotated[cTkFoamProperties, Field(cTkFoamProperties, 0x10)]
    DetailNormalsStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x30)]
    WaveRTPCStrength: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x34)]


@partial_struct
class cTkBiomeSpecificWaterConditions(Structure):
    WaterConditionUsage: Annotated[
        cTkAllowedWaterConditions, Field(cTkAllowedWaterConditions, 0x0)
    ]


@partial_struct
class cTkCreatureTailComponentData(Structure):
    DefaultParams: Annotated[cTkCreatureTailParams, Field(cTkCreatureTailParams, 0x0)]
    ParamVariations: Annotated[
        basic.cTkDynamicArray[cTkCreatureTailParams],
        Field(basic.cTkDynamicArray[cTkCreatureTailParams], 0x78),
    ]
    LengthAxis: Annotated[
        c_enum32[enums.cGcPrimaryAxis], Field(c_enum32[enums.cGcPrimaryAxis], 0x88)
    ]
    CanUseDefaultParams: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x8C)]


@partial_struct
class cTkAnimationOverrideList(Structure):
    Anims: Annotated[
        basic.cTkDynamicArray[cTkAnimationData],
        Field(basic.cTkDynamicArray[cTkAnimationData], 0x0),
    ]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]


@partial_struct
class cTkEasedFalloff(Structure):
    LeftMargin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    RightMargin: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x4)]
    LeftCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x8)
    ]
    RightCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x9)
    ]


@partial_struct
class cTkInOutCurve(Structure):
    Midpoint: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x0)]
    InCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x4)
    ]
    OutCurve: Annotated[
        c_enum32[enums.cTkCurveType], Field(c_enum32[enums.cTkCurveType], 0x5)
    ]


@partial_struct
class cTkHitCurveData(Structure):
    Curve: Annotated[cTkInOutCurve, Field(cTkInOutCurve, 0x0)]
    Time: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x8)]


@partial_struct
class cTkAnimStateMachineTransitionData(Structure):
    Conditions: Annotated[
        basic.cTkDynamicArray[basic.NMSTemplate],
        Field(basic.cTkDynamicArray[basic.NMSTemplate], 0x0),
    ]
    DestinationStateDebugName: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    BlendType: Annotated[
        c_enum32[enums.cTkAnimBlendType], Field(c_enum32[enums.cTkAnimBlendType], 0x20)
    ]
    DestinationState: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x24)]
    ExitTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    TransitionTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    TransitionTimeMode: Annotated[
        c_enum32[enums.cTkAnimStateMachineBlendTimeMode],
        Field(c_enum32[enums.cTkAnimStateMachineBlendTimeMode], 0x30),
    ]
    HasTimedExit: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x34)]


@partial_struct
class cTkAnimStateMachineStateData(Structure):
    Anim: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Name: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    Transitions: Annotated[
        basic.cTkDynamicArray[cTkAnimStateMachineTransitionData],
        Field(basic.cTkDynamicArray[cTkAnimStateMachineTransitionData], 0x20),
    ]
    Id: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    NodePosX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    NodePosY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    ScrollX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    ScrollY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Zoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]


@partial_struct
class cTkAnimationDataTable(Structure):
    Table: Annotated[
        basic.cTkDynamicArray[cTkAnimationData],
        Field(basic.cTkDynamicArray[cTkAnimationData], 0x0),
    ]


@partial_struct
class cTkAnimationNotifies(Structure):
    Notifies: Annotated[
        basic.cTkDynamicArray[cTkAnimationNotify],
        Field(basic.cTkDynamicArray[cTkAnimationNotify], 0x0),
    ]


@partial_struct
class cTkAnimStateMachineData(Structure):
    EntryTransitions: Annotated[
        basic.cTkDynamicArray[cTkAnimStateMachineTransitionData],
        Field(basic.cTkDynamicArray[cTkAnimStateMachineTransitionData], 0x0),
    ]
    LayerId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    States: Annotated[
        basic.cTkDynamicArray[cTkAnimStateMachineStateData],
        Field(basic.cTkDynamicArray[cTkAnimStateMachineStateData], 0x20),
    ]
    DefaultState: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x30)]
    EntryPosX: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x34)]
    EntryPosY: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x38)]
    ScrollX: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x3C)]
    ScrollY: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x40)]
    Zoom: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x44)]


@partial_struct
class cTkAnimBlendTree(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Tree: Annotated[basic.NMSTemplate, Field(basic.NMSTemplate, 0x10)]
    GameData: Annotated[cTkAnimationGameData, Field(cTkAnimationGameData, 0x20)]
    Priority: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x2C)]


@partial_struct
class cGcWikiTopic(Structure):
    MissionButtonText: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    ShortDescriptionID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    TopicID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x60)]
    NotifyIcon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x78)]
    Mission: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    Pages: Annotated[
        basic.cTkDynamicArray[cGcWikiPage],
        Field(basic.cTkDynamicArray[cGcWikiPage], 0xA0),
    ]
    ActionSet: Annotated[
        c_enum32[enums.cGcActionSetType], Field(c_enum32[enums.cGcActionSetType], 0xB0)
    ]
    Seen: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB4)]
    Unlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0xB5)]


@partial_struct
class cGcWikiCategory(Structure):
    CategoryID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CategoryIDUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    IconOff: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x40)]
    IconOn: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x58)]
    Items: Annotated[
        basic.cTkDynamicArray[basic.TkID0x10],
        Field(basic.cTkDynamicArray[basic.TkID0x10], 0x70),
    ]
    Topics: Annotated[
        basic.cTkDynamicArray[cGcWikiTopic],
        Field(basic.cTkDynamicArray[cGcWikiTopic], 0x80),
    ]
    Type: Annotated[
        c_enum32[enums.cGcWikiTopicType], Field(c_enum32[enums.cGcWikiTopicType], 0x90)
    ]
    UnlockedCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x94)]
    UnseenCount: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x98)]


@partial_struct
class cGcStoryEntry(Structure):
    AlienText: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Entry: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)]
    Title: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x40)]
    BranchedEntries: Annotated[
        basic.cTkDynamicArray[cGcStoryEntryBranch],
        Field(basic.cTkDynamicArray[cGcStoryEntryBranch], 0x60),
    ]
    AlienTextForceRace: Annotated[
        c_enum32[enums.cGcAlienRace], Field(c_enum32[enums.cGcAlienRace], 0x70)
    ]
    AutoPrefixWithAlienText: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x74)]


@partial_struct
class cGcStoryPage(Structure):
    ID: Annotated[basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)]
    Icon: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x20)]
    Entries: Annotated[
        basic.cTkDynamicArray[cGcStoryEntry],
        Field(basic.cTkDynamicArray[cGcStoryEntry], 0x38),
    ]
    Stat: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x48)]
    InteractionType: Annotated[
        c_enum32[enums.cGcInteractionType],
        Field(c_enum32[enums.cGcInteractionType], 0x58),
    ]
    WikiGridType: Annotated[
        c_enum32[enums.cGcWikiTopicType], Field(c_enum32[enums.cGcWikiTopicType], 0x5C)
    ]
    StatIsBitmask: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x60)]
    UseGridType: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x61)]


@partial_struct
class cGcStoryCategory(Structure):
    CategoryID: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x0)
    ]
    CategoryIDUpper: Annotated[
        basic.cTkFixedString0x20, Field(basic.cTkFixedString0x20, 0x20)
    ]
    IconOff: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x40)]
    IconOn: Annotated[cTkTextureResource, Field(cTkTextureResource, 0x58)]
    Pages: Annotated[
        basic.cTkDynamicArray[cGcStoryPage],
        Field(basic.cTkDynamicArray[cGcStoryPage], 0x70),
    ]


@partial_struct
class cGcPersistentBaseDifficultyData(Structure):
    DifficultyPreset: Annotated[
        c_enum32[enums.cGcDifficultyPresetType],
        Field(c_enum32[enums.cGcDifficultyPresetType], 0x0),
    ]

    class ePersistentBaseDifficultyFlagsEnum(IntEnum):
        empty = 0x0
        Locked = 0x1

    PersistentBaseDifficultyFlags: Annotated[
        c_enum32[ePersistentBaseDifficultyFlagsEnum],
        Field(c_enum32[ePersistentBaseDifficultyFlagsEnum], 0x4),
    ]


@partial_struct
class cGcDifficultySettingsReplicatedState(Structure):
    EasiestUsedPreset: Annotated[
        c_enum32[enums.cGcDifficultyPresetType],
        Field(c_enum32[enums.cGcDifficultyPresetType], 0x0),
    ]
    HardestUsedPreset: Annotated[
        c_enum32[enums.cGcDifficultyPresetType],
        Field(c_enum32[enums.cGcDifficultyPresetType], 0x4),
    ]
    Preset: Annotated[
        c_enum32[enums.cGcDifficultyPresetType],
        Field(c_enum32[enums.cGcDifficultyPresetType], 0x8),
    ]
    RoundedDownPreset: Annotated[
        c_enum32[enums.cGcDifficultyPresetType],
        Field(c_enum32[enums.cGcDifficultyPresetType], 0xC),
    ]
    IsLocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x10)]
    IsPermadeath: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x11)]


@partial_struct
class cGcDifficultyStartWithAllItemsKnownOptionData(Structure):
    InitialShipInventory: Annotated[
        cGcInventoryContainer, Field(cGcInventoryContainer, 0x0)
    ]
    InitialWeaponInventory: Annotated[
        cGcInventoryContainer, Field(cGcInventoryContainer, 0x160)
    ]
    InitialKnownThings: Annotated[
        cGcKnownThingsPreset, Field(cGcKnownThingsPreset, 0x2C0)
    ]


@partial_struct
class cGcDifficultySettingsData(Structure):
    ActiveSurvivalBars: Annotated[
        c_enum32[enums.cGcActiveSurvivalBarsDifficultyOption],
        Field(c_enum32[enums.cGcActiveSurvivalBarsDifficultyOption], 0x0),
    ]
    BreakTechOnDamage: Annotated[
        c_enum32[enums.cGcBreakTechOnDamageDifficultyOption],
        Field(c_enum32[enums.cGcBreakTechOnDamageDifficultyOption], 0x4),
    ]
    ChargingRequirements: Annotated[
        c_enum32[enums.cGcChargingRequirementsDifficultyOption],
        Field(c_enum32[enums.cGcChargingRequirementsDifficultyOption], 0x8),
    ]
    CreatureHostility: Annotated[
        c_enum32[enums.cGcCreatureHostilityDifficultyOption],
        Field(c_enum32[enums.cGcCreatureHostilityDifficultyOption], 0xC),
    ]
    CurrencyCost: Annotated[
        c_enum32[enums.cGcCurrencyCostDifficultyOption],
        Field(c_enum32[enums.cGcCurrencyCostDifficultyOption], 0x10),
    ]
    DamageGiven: Annotated[
        c_enum32[enums.cGcDamageGivenDifficultyOption],
        Field(c_enum32[enums.cGcDamageGivenDifficultyOption], 0x14),
    ]
    DamageReceived: Annotated[
        c_enum32[enums.cGcDamageReceivedDifficultyOption],
        Field(c_enum32[enums.cGcDamageReceivedDifficultyOption], 0x18),
    ]
    DeathConsequences: Annotated[
        c_enum32[enums.cGcDeathConsequencesDifficultyOption],
        Field(c_enum32[enums.cGcDeathConsequencesDifficultyOption], 0x1C),
    ]
    EnergyDrain: Annotated[
        c_enum32[enums.cGcEnergyDrainDifficultyOption],
        Field(c_enum32[enums.cGcEnergyDrainDifficultyOption], 0x20),
    ]
    Fishing: Annotated[
        c_enum32[enums.cGcFishingDifficultyOption],
        Field(c_enum32[enums.cGcFishingDifficultyOption], 0x24),
    ]
    FuelUse: Annotated[
        c_enum32[enums.cGcFuelUseDifficultyOption],
        Field(c_enum32[enums.cGcFuelUseDifficultyOption], 0x28),
    ]
    GroundCombatTimers: Annotated[
        c_enum32[enums.cGcCombatTimerDifficultyOption],
        Field(c_enum32[enums.cGcCombatTimerDifficultyOption], 0x2C),
    ]
    HazardDrain: Annotated[
        c_enum32[enums.cGcHazardDrainDifficultyOption],
        Field(c_enum32[enums.cGcHazardDrainDifficultyOption], 0x30),
    ]
    InventoryStackLimits: Annotated[
        c_enum32[enums.cGcInventoryStackLimitsDifficultyOption],
        Field(c_enum32[enums.cGcInventoryStackLimitsDifficultyOption], 0x34),
    ]
    ItemShopAvailability: Annotated[
        c_enum32[enums.cGcItemShopAvailabilityDifficultyOption],
        Field(c_enum32[enums.cGcItemShopAvailabilityDifficultyOption], 0x38),
    ]
    LaunchFuelCost: Annotated[
        c_enum32[enums.cGcLaunchFuelCostDifficultyOption],
        Field(c_enum32[enums.cGcLaunchFuelCostDifficultyOption], 0x3C),
    ]
    NPCPopulation: Annotated[
        c_enum32[enums.cGcNPCPopulationDifficultyOption],
        Field(c_enum32[enums.cGcNPCPopulationDifficultyOption], 0x40),
    ]
    ReputationGain: Annotated[
        c_enum32[enums.cGcReputationGainDifficultyOption],
        Field(c_enum32[enums.cGcReputationGainDifficultyOption], 0x44),
    ]
    ScannerRecharge: Annotated[
        c_enum32[enums.cGcScannerRechargeDifficultyOption],
        Field(c_enum32[enums.cGcScannerRechargeDifficultyOption], 0x48),
    ]
    SpaceCombatTimers: Annotated[
        c_enum32[enums.cGcCombatTimerDifficultyOption],
        Field(c_enum32[enums.cGcCombatTimerDifficultyOption], 0x4C),
    ]
    SprintingCost: Annotated[
        c_enum32[enums.cGcSprintingCostDifficultyOption],
        Field(c_enum32[enums.cGcSprintingCostDifficultyOption], 0x50),
    ]
    SubstanceCollection: Annotated[
        c_enum32[enums.cGcSubstanceCollectionDifficultyOption],
        Field(c_enum32[enums.cGcSubstanceCollectionDifficultyOption], 0x54),
    ]
    AllSlotsUnlocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x58)]
    BaseAutoPower: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x59)]
    CraftingIsFree: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5A)]
    InventoriesAlwaysInRange: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5B)]
    SettingsLocked: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5C)]
    StartWithAllItemsKnown: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5D)]
    TutorialEnabled: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5E)]
    WarpDriveRequirements: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x5F)]


@partial_struct
class cGcQuickMenuActionSaveData(Structure):
    Id: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    InventoryIndex: Annotated[cGcInventoryIndex, Field(cGcInventoryIndex, 0x10)]
    Action: Annotated[
        c_enum32[enums.cGcQuickMenuActions],
        Field(c_enum32[enums.cGcQuickMenuActions], 0x18),
    ]
    Number: Annotated[ctypes.c_int32, Field(ctypes.c_int32, 0x1C)]


@partial_struct
class cGcHotActionsSaveData(Structure):
    KeyActions: Annotated[
        cGcQuickMenuActionSaveData, Field(cGcQuickMenuActionSaveData, 0x0)
    ]


@partial_struct
class cGcShipWeaponData(Structure):
    Projectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x0)]
    Reticle: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    AutoAimAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x20)]
    AutoAimExtraAngle: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x24)]
    CoolRate: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x28)]
    OverheatCoolTime: Annotated[ctypes.c_float, Field(ctypes.c_float, 0x2C)]
    RemoteType: Annotated[
        c_enum32[enums.cGcRemoteWeapons], Field(c_enum32[enums.cGcRemoteWeapons], 0x30)
    ]
    Stat: Annotated[
        c_enum32[enums.cGcStatsTypes], Field(c_enum32[enums.cGcStatsTypes], 0x34)
    ]
    IsProjectile: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x38)]
    ShowOverheatSwitch: Annotated[ctypes.c_bool, Field(ctypes.c_bool, 0x39)]


@partial_struct
class cGcPlayerWeaponBiomeProperties(Structure):
    UpgradeColourOverride: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    MuzzleChargedAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x10)]
    MuzzleChargedParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    MuzzleFireAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x30)]
    MuzzleFireParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    MuzzleIdleAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    MuzzleIdleParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    Projectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    StatBonusesOverride: Annotated[
        basic.cTkDynamicArray[cGcStatsBonus],
        Field(basic.cTkDynamicArray[cGcStatsBonus], 0x80),
    ]
    WeaponChargedAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    WeaponFireAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    WeaponFireParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    WeaponIdleAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    Biome: Annotated[
        c_enum32[enums.cGcBiomeType], Field(c_enum32[enums.cGcBiomeType], 0xD0)
    ]


@partial_struct
class cGcPlayerWeaponPropertiesData(Structure):
    DefaultMuzzleLightColour: Annotated[basic.Colour, Field(basic.Colour, 0x0)]
    BiomeProperties: Annotated[
        basic.cTkDynamicArray[cGcPlayerWeaponBiomeProperties],
        Field(basic.cTkDynamicArray[cGcPlayerWeaponBiomeProperties], 0x10),
    ]
    DefaultMuzzleChargedAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x20)]
    DefaultMuzzleChargedParticlesId: Annotated[
        basic.TkID0x10, Field(basic.TkID0x10, 0x30)
    ]
    DefaultMuzzleFireAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x40)]
    DefaultMuzzleFireParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x50)]
    DefaultMuzzleIdleAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x60)]
    DefaultMuzzleIdleParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x70)]
    DefaultProjectile: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x80)]
    DefaultWeaponChargedAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0x90)]
    DefaultWeaponFireAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xA0)]
    DefaultWeaponFireParticlesId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xB0)]
    DefaultWeaponIdleAnimId: Annotated[basic.TkID0x10, Field(basic.TkID0x10, 0xC0)]
    MuzzleGunResource: Annotated[
        basic.VariableSizeString, Field(