# coding: utf-8

"""
    College Football Data API

    This API is in limited Beta for Patreon subscribers. It may have bugs and is subject to changes. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.3.2
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import List, Optional

from cfbd.models.advanced_box_score import AdvancedBoxScore
from cfbd.models.calendar_week import CalendarWeek
from cfbd.models.division_classification import DivisionClassification
from cfbd.models.game import Game
from cfbd.models.game_media import GameMedia
from cfbd.models.game_player_stats import GamePlayerStats
from cfbd.models.game_team_stats import GameTeamStats
from cfbd.models.game_weather import GameWeather
from cfbd.models.media_type import MediaType
from cfbd.models.scoreboard_game import ScoreboardGame
from cfbd.models.season_type import SeasonType
from cfbd.models.team_records import TeamRecords

from cfbd.api_client import ApiClient
from cfbd.api_response import ApiResponse
from cfbd.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class GamesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_advanced_box_score(self, id : Annotated[StrictInt, Field(..., description="Required game id filter")], **kwargs) -> AdvancedBoxScore:  # noqa: E501
        """get_advanced_box_score  # noqa: E501

        Retrieves an advanced box score for a game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_box_score(id, async_req=True)
        >>> result = thread.get()

        :param id: Required game id filter (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AdvancedBoxScore
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_advanced_box_score_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_advanced_box_score_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_advanced_box_score_with_http_info(self, id : Annotated[StrictInt, Field(..., description="Required game id filter")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_advanced_box_score  # noqa: E501

        Retrieves an advanced box score for a game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_advanced_box_score_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Required game id filter (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AdvancedBoxScore, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_advanced_box_score" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "AdvancedBoxScore",
        }

        return self.api_client.call_api(
            '/game/box/advanced', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_calendar(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], **kwargs) -> List[CalendarWeek]:  # noqa: E501
        """get_calendar  # noqa: E501

        Retrieves calendar information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar(year, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[CalendarWeek]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_calendar_with_http_info(year, **kwargs)  # noqa: E501

    @validate_arguments
    def get_calendar_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_calendar  # noqa: E501

        Retrieves calendar information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar_with_http_info(year, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[CalendarWeek], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[CalendarWeek]",
        }

        return self.api_client.call_api(
            '/calendar', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_game_player_stats(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (along with one of week, team, or conference), unless id is specified")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter, required if team and conference not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter, required if week and conference not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter, required if week and team not specified")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, category : Annotated[Optional[StrictStr], Field(description="Optional player statistical category filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Optional id filter to retrieve a single game")] = None, **kwargs) -> List[GamePlayerStats]:  # noqa: E501
        """get_game_player_stats  # noqa: E501

        Retrieves player box score statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_game_player_stats(year, week, team, conference, classification, season_type, category, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (along with one of week, team, or conference), unless id is specified
        :type year: int
        :param week: Optional week filter, required if team and conference not specified
        :type week: int
        :param team: Optional team filter, required if week and conference not specified
        :type team: str
        :param conference: Optional conference filter, required if week and team not specified
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param category: Optional player statistical category filter
        :type category: str
        :param id: Optional id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[GamePlayerStats]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_game_player_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_game_player_stats_with_http_info(year, week, team, conference, classification, season_type, category, id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_game_player_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (along with one of week, team, or conference), unless id is specified")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter, required if team and conference not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter, required if week and conference not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter, required if week and team not specified")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, category : Annotated[Optional[StrictStr], Field(description="Optional player statistical category filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Optional id filter to retrieve a single game")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_game_player_stats  # noqa: E501

        Retrieves player box score statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_game_player_stats_with_http_info(year, week, team, conference, classification, season_type, category, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (along with one of week, team, or conference), unless id is specified
        :type year: int
        :param week: Optional week filter, required if team and conference not specified
        :type week: int
        :param team: Optional team filter, required if week and conference not specified
        :type team: str
        :param conference: Optional conference filter, required if week and team not specified
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param category: Optional player statistical category filter
        :type category: str
        :param id: Optional id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[GamePlayerStats], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'team',
            'conference',
            'classification',
            'season_type',
            'category',
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_game_player_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))

        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[GamePlayerStats]",
        }

        return self.api_client.call_api(
            '/games/players', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_game_team_stats(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (along with one of week, team, or conference), unless id is specified")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter, required if team and conference not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter, required if week and conference not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter, required if week and team not specified")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Optional id filter to retrieve a single game")] = None, **kwargs) -> List[GameTeamStats]:  # noqa: E501
        """get_game_team_stats  # noqa: E501

        Retrieves team box score statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_game_team_stats(year, week, team, conference, classification, season_type, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (along with one of week, team, or conference), unless id is specified
        :type year: int
        :param week: Optional week filter, required if team and conference not specified
        :type week: int
        :param team: Optional team filter, required if week and conference not specified
        :type team: str
        :param conference: Optional conference filter, required if week and team not specified
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param id: Optional id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[GameTeamStats]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_game_team_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_game_team_stats_with_http_info(year, week, team, conference, classification, season_type, id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_game_team_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (along with one of week, team, or conference), unless id is specified")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter, required if team and conference not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter, required if week and conference not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter, required if week and team not specified")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Optional id filter to retrieve a single game")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_game_team_stats  # noqa: E501

        Retrieves team box score statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_game_team_stats_with_http_info(year, week, team, conference, classification, season_type, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (along with one of week, team, or conference), unless id is specified
        :type year: int
        :param week: Optional week filter, required if team and conference not specified
        :type week: int
        :param team: Optional team filter, required if week and conference not specified
        :type team: str
        :param conference: Optional conference filter, required if week and team not specified
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param id: Optional id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[GameTeamStats], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'team',
            'conference',
            'classification',
            'season_type',
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_game_team_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[GameTeamStats]",
        }

        return self.api_client.call_api(
            '/games/teams', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_games(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (except when id is specified)")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, home : Annotated[Optional[StrictStr], Field(description="Optional home team filter")] = None, away : Annotated[Optional[StrictStr], Field(description="Optional away team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Game id filter to retrieve a single game")] = None, **kwargs) -> List[Game]:  # noqa: E501
        """get_games  # noqa: E501

        Retrieves historical game data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_games(year, week, season_type, classification, team, home, away, conference, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (except when id is specified)
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param team: Optional team filter
        :type team: str
        :param home: Optional home team filter
        :type home: str
        :param away: Optional away team filter
        :type away: str
        :param conference: Optional conference filter
        :type conference: str
        :param id: Game id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Game]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_games_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_games_with_http_info(year, week, season_type, classification, team, home, away, conference, id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_games_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Required year filter (except when id is specified)")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, home : Annotated[Optional[StrictStr], Field(description="Optional home team filter")] = None, away : Annotated[Optional[StrictStr], Field(description="Optional away team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, id : Annotated[Optional[StrictInt], Field(description="Game id filter to retrieve a single game")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_games  # noqa: E501

        Retrieves historical game data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_games_with_http_info(year, week, season_type, classification, team, home, away, conference, id, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (except when id is specified)
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param team: Optional team filter
        :type team: str
        :param home: Optional home team filter
        :type home: str
        :param away: Optional away team filter
        :type away: str
        :param conference: Optional conference filter
        :type conference: str
        :param id: Game id filter to retrieve a single game
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Game], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'season_type',
            'classification',
            'team',
            'home',
            'away',
            'conference',
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_games" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('home') is not None:  # noqa: E501
            _query_params.append(('home', _params['home']))

        if _params.get('away') is not None:  # noqa: E501
            _query_params.append(('away', _params['away']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[Game]",
        }

        return self.api_client.call_api(
            '/games', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_media(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, media_type : Annotated[Optional[MediaType], Field(description="Optional media type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, **kwargs) -> List[GameMedia]:  # noqa: E501
        """get_media  # noqa: E501

        Retrieves media information for games  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media(year, season_type, week, team, conference, media_type, classification, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param media_type: Optional media type filter
        :type media_type: MediaType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[GameMedia]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_media_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_media_with_http_info(year, season_type, week, team, conference, media_type, classification, **kwargs)  # noqa: E501

    @validate_arguments
    def get_media_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, media_type : Annotated[Optional[MediaType], Field(description="Optional media type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_media  # noqa: E501

        Retrieves media information for games  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_with_http_info(year, season_type, week, team, conference, media_type, classification, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param media_type: Optional media type filter
        :type media_type: MediaType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[GameMedia], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'season_type',
            'week',
            'team',
            'conference',
            'media_type',
            'classification'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('media_type') is not None:  # noqa: E501
            _query_params.append(('mediaType', _params['media_type'].value))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[GameMedia]",
        }

        return self.api_client.call_api(
            '/games/media', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_records(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> List[TeamRecords]:  # noqa: E501
        """get_records  # noqa: E501

        Retrieves historical team records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_records(year, team, conference, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[TeamRecords]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_records_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_records_with_http_info(year, team, conference, **kwargs)  # noqa: E501

    @validate_arguments
    def get_records_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_records  # noqa: E501

        Retrieves historical team records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_records_with_http_info(year, team, conference, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[TeamRecords], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'team',
            'conference'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_records" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[TeamRecords]",
        }

        return self.api_client.call_api(
            '/records', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_scoreboard(self, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter, defaults to fbs")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> List[ScoreboardGame]:  # noqa: E501
        """get_scoreboard  # noqa: E501

        Retrieves live scoreboard data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scoreboard(classification, conference, async_req=True)
        >>> result = thread.get()

        :param classification: Optional division classification filter, defaults to fbs
        :type classification: DivisionClassification
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[ScoreboardGame]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_scoreboard_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_scoreboard_with_http_info(classification, conference, **kwargs)  # noqa: E501

    @validate_arguments
    def get_scoreboard_with_http_info(self, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter, defaults to fbs")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_scoreboard  # noqa: E501

        Retrieves live scoreboard data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scoreboard_with_http_info(classification, conference, async_req=True)
        >>> result = thread.get()

        :param classification: Optional division classification filter, defaults to fbs
        :type classification: DivisionClassification
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[ScoreboardGame], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'classification',
            'conference'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scoreboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[ScoreboardGame]",
        }

        return self.api_client.call_api(
            '/scoreboard', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_weather(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if game id not specified")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, game_id : Annotated[Optional[StrictInt], Field(description="Filter for retrieving a single game")] = None, **kwargs) -> List[GameWeather]:  # noqa: E501
        """get_weather  # noqa: E501

        Retrieve historical and future weather data (Patreon only)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_weather(year, season_type, week, team, conference, classification, game_id, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if game id not specified
        :type year: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param game_id: Filter for retrieving a single game
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[GameWeather]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_weather_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_weather_with_http_info(year, season_type, week, team, conference, classification, game_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_weather_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if game id not specified")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, game_id : Annotated[Optional[StrictInt], Field(description="Filter for retrieving a single game")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_weather  # noqa: E501

        Retrieve historical and future weather data (Patreon only)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_weather_with_http_info(year, season_type, week, team, conference, classification, game_id, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if game id not specified
        :type year: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference filter
        :type conference: str
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param game_id: Filter for retrieving a single game
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[GameWeather], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'season_type',
            'week',
            'team',
            'conference',
            'classification',
            'game_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_weather" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        if _params.get('game_id') is not None:  # noqa: E501
            _query_params.append(('gameId', _params['game_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[GameWeather]",
        }

        return self.api_client.call_api(
            '/games/weather', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
