# coding: utf-8

"""
    College Football Data API

    This API is in limited Beta for Patreon subscribers. It may have bugs and is subject to changes. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.3.2
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from cfbd.models.recruit_classification import RecruitClassification
from cfbd.models.recruit_hometown_info import RecruitHometownInfo

class Recruit(BaseModel):
    """
    Recruit
    """
    id: StrictStr = Field(...)
    athlete_id: Optional[StrictStr] = Field(default=..., alias="athleteId")
    recruit_type: RecruitClassification = Field(default=..., alias="recruitType")
    year: StrictInt = Field(...)
    ranking: Optional[StrictInt] = Field(...)
    name: StrictStr = Field(...)
    school: Optional[StrictStr] = Field(...)
    committed_to: Optional[StrictStr] = Field(default=..., alias="committedTo")
    position: Optional[StrictStr] = Field(...)
    height: Optional[StrictInt] = Field(...)
    weight: Optional[StrictInt] = Field(...)
    stars: StrictInt = Field(...)
    rating: Union[StrictFloat, StrictInt] = Field(...)
    city: Optional[StrictStr] = Field(...)
    state_province: Optional[StrictStr] = Field(default=..., alias="stateProvince")
    country: Optional[StrictStr] = Field(...)
    hometown_info: RecruitHometownInfo = Field(default=..., alias="hometownInfo")
    __properties = ["id", "athleteId", "recruitType", "year", "ranking", "name", "school", "committedTo", "position", "height", "weight", "stars", "rating", "city", "stateProvince", "country", "hometownInfo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Recruit:
        """Create an instance of Recruit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hometown_info
        if self.hometown_info:
            _dict['hometownInfo'] = self.hometown_info.to_dict()
        # set to None if athlete_id (nullable) is None
        # and __fields_set__ contains the field
        if self.athlete_id is None and "athlete_id" in self.__fields_set__:
            _dict['athleteId'] = None

        # set to None if ranking (nullable) is None
        # and __fields_set__ contains the field
        if self.ranking is None and "ranking" in self.__fields_set__:
            _dict['ranking'] = None

        # set to None if school (nullable) is None
        # and __fields_set__ contains the field
        if self.school is None and "school" in self.__fields_set__:
            _dict['school'] = None

        # set to None if committed_to (nullable) is None
        # and __fields_set__ contains the field
        if self.committed_to is None and "committed_to" in self.__fields_set__:
            _dict['committedTo'] = None

        # set to None if position (nullable) is None
        # and __fields_set__ contains the field
        if self.position is None and "position" in self.__fields_set__:
            _dict['position'] = None

        # set to None if height (nullable) is None
        # and __fields_set__ contains the field
        if self.height is None and "height" in self.__fields_set__:
            _dict['height'] = None

        # set to None if weight (nullable) is None
        # and __fields_set__ contains the field
        if self.weight is None and "weight" in self.__fields_set__:
            _dict['weight'] = None

        # set to None if city (nullable) is None
        # and __fields_set__ contains the field
        if self.city is None and "city" in self.__fields_set__:
            _dict['city'] = None

        # set to None if state_province (nullable) is None
        # and __fields_set__ contains the field
        if self.state_province is None and "state_province" in self.__fields_set__:
            _dict['stateProvince'] = None

        # set to None if country (nullable) is None
        # and __fields_set__ contains the field
        if self.country is None and "country" in self.__fields_set__:
            _dict['country'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Recruit:
        """Create an instance of Recruit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Recruit.parse_obj(obj)

        _obj = Recruit.parse_obj({
            "id": obj.get("id"),
            "athlete_id": obj.get("athleteId"),
            "recruit_type": obj.get("recruitType"),
            "year": obj.get("year"),
            "ranking": obj.get("ranking"),
            "name": obj.get("name"),
            "school": obj.get("school"),
            "committed_to": obj.get("committedTo"),
            "position": obj.get("position"),
            "height": obj.get("height"),
            "weight": obj.get("weight"),
            "stars": obj.get("stars"),
            "rating": obj.get("rating"),
            "city": obj.get("city"),
            "state_province": obj.get("stateProvince"),
            "country": obj.get("country"),
            "hometown_info": RecruitHometownInfo.from_dict(obj.get("hometownInfo")) if obj.get("hometownInfo") is not None else None
        })
        return _obj


