# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMetadataSamlResult',
    'AwaitableGetMetadataSamlResult',
    'get_metadata_saml',
    'get_metadata_saml_output',
]

@pulumi.output_type
class GetMetadataSamlResult:
    """
    A collection of values returned by getMetadataSaml.
    """
    def __init__(__self__, app_id=None, certificate=None, entity_id=None, http_post_binding=None, http_redirect_binding=None, id=None, key_id=None, metadata=None, want_authn_requests_signed=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if entity_id and not isinstance(entity_id, str):
            raise TypeError("Expected argument 'entity_id' to be a str")
        pulumi.set(__self__, "entity_id", entity_id)
        if http_post_binding and not isinstance(http_post_binding, str):
            raise TypeError("Expected argument 'http_post_binding' to be a str")
        pulumi.set(__self__, "http_post_binding", http_post_binding)
        if http_redirect_binding and not isinstance(http_redirect_binding, str):
            raise TypeError("Expected argument 'http_redirect_binding' to be a str")
        pulumi.set(__self__, "http_redirect_binding", http_redirect_binding)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if want_authn_requests_signed and not isinstance(want_authn_requests_signed, bool):
            raise TypeError("Expected argument 'want_authn_requests_signed' to be a bool")
        pulumi.set(__self__, "want_authn_requests_signed", want_authn_requests_signed)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        The application ID.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        Public certificate from application metadata.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        Entity URL for instance https://www.okta.com/saml2/service-provider/sposcfdmlybtwkdcgtuf
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="httpPostBinding")
    def http_post_binding(self) -> _builtins.str:
        """
        urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Post location from the SAML metadata.
        """
        return pulumi.get(self, "http_post_binding")

    @_builtins.property
    @pulumi.getter(name="httpRedirectBinding")
    def http_redirect_binding(self) -> _builtins.str:
        """
        urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect location from the SAML metadata.
        """
        return pulumi.get(self, "http_redirect_binding")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        Certificate Key ID.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> _builtins.str:
        """
        Raw metadata of application.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="wantAuthnRequestsSigned")
    def want_authn_requests_signed(self) -> _builtins.bool:
        """
        Whether authn requests are signed.
        """
        return pulumi.get(self, "want_authn_requests_signed")


class AwaitableGetMetadataSamlResult(GetMetadataSamlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetadataSamlResult(
            app_id=self.app_id,
            certificate=self.certificate,
            entity_id=self.entity_id,
            http_post_binding=self.http_post_binding,
            http_redirect_binding=self.http_redirect_binding,
            id=self.id,
            key_id=self.key_id,
            metadata=self.metadata,
            want_authn_requests_signed=self.want_authn_requests_signed)


def get_metadata_saml(app_id: Optional[_builtins.str] = None,
                      key_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetadataSamlResult:
    """
    Get a SAML application's metadata from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_metadata_saml(app_id="<app id>",
        key_id="<cert key id>")
    ```


    :param _builtins.str app_id: The application ID.
    :param _builtins.str key_id: Certificate Key ID.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['keyId'] = key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:app/getMetadataSaml:getMetadataSaml', __args__, opts=opts, typ=GetMetadataSamlResult).value

    return AwaitableGetMetadataSamlResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        certificate=pulumi.get(__ret__, 'certificate'),
        entity_id=pulumi.get(__ret__, 'entity_id'),
        http_post_binding=pulumi.get(__ret__, 'http_post_binding'),
        http_redirect_binding=pulumi.get(__ret__, 'http_redirect_binding'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        want_authn_requests_signed=pulumi.get(__ret__, 'want_authn_requests_signed'))
def get_metadata_saml_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                             key_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMetadataSamlResult]:
    """
    Get a SAML application's metadata from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_metadata_saml(app_id="<app id>",
        key_id="<cert key id>")
    ```


    :param _builtins.str app_id: The application ID.
    :param _builtins.str key_id: Certificate Key ID.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['keyId'] = key_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:app/getMetadataSaml:getMetadataSaml', __args__, opts=opts, typ=GetMetadataSamlResult)
    return __ret__.apply(lambda __response__: GetMetadataSamlResult(
        app_id=pulumi.get(__response__, 'app_id'),
        certificate=pulumi.get(__response__, 'certificate'),
        entity_id=pulumi.get(__response__, 'entity_id'),
        http_post_binding=pulumi.get(__response__, 'http_post_binding'),
        http_redirect_binding=pulumi.get(__response__, 'http_redirect_binding'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        metadata=pulumi.get(__response__, 'metadata'),
        want_authn_requests_signed=pulumi.get(__response__, 'want_authn_requests_signed')))
