# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrgMetadataResult',
    'AwaitableGetOrgMetadataResult',
    'get_org_metadata',
    'get_org_metadata_output',
]

@pulumi.output_type
class GetOrgMetadataResult:
    """
    A collection of values returned by getOrgMetadata.
    """
    def __init__(__self__, domains=None, id=None, pipeline=None, settings=None):
        if domains and not isinstance(domains, dict):
            raise TypeError("Expected argument 'domains' to be a dict")
        pulumi.set(__self__, "domains", domains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pipeline and not isinstance(pipeline, str):
            raise TypeError("Expected argument 'pipeline' to be a str")
        pulumi.set(__self__, "pipeline", pipeline)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional['outputs.GetOrgMetadataDomainsResult']:
        """
        The URIs for the org's configured domains.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the Org.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def pipeline(self) -> _builtins.str:
        """
        The authentication pipeline of the org. idx means the org is using the Identity Engine, while v1 means the org is using the Classic authentication pipeline.
        """
        return pulumi.get(self, "pipeline")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional['outputs.GetOrgMetadataSettingsResult']:
        """
        The wellknown org settings (safe for public consumption).
        """
        return pulumi.get(self, "settings")


class AwaitableGetOrgMetadataResult(GetOrgMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrgMetadataResult(
            domains=self.domains,
            id=self.id,
            pipeline=self.pipeline,
            settings=self.settings)


def get_org_metadata(domains: Optional[Union['GetOrgMetadataDomainsArgs', 'GetOrgMetadataDomainsArgsDict']] = None,
                     settings: Optional[Union['GetOrgMetadataSettingsArgs', 'GetOrgMetadataSettingsArgsDict']] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrgMetadataResult:
    """
    Retrieves the well-known org metadata, which includes the id, configured custom domains, authentication pipeline, and various other org settings.


    :param Union['GetOrgMetadataDomainsArgs', 'GetOrgMetadataDomainsArgsDict'] domains: The URIs for the org's configured domains.
    :param Union['GetOrgMetadataSettingsArgs', 'GetOrgMetadataSettingsArgsDict'] settings: The wellknown org settings (safe for public consumption).
    """
    __args__ = dict()
    __args__['domains'] = domains
    __args__['settings'] = settings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getOrgMetadata:getOrgMetadata', __args__, opts=opts, typ=GetOrgMetadataResult).value

    return AwaitableGetOrgMetadataResult(
        domains=pulumi.get(__ret__, 'domains'),
        id=pulumi.get(__ret__, 'id'),
        pipeline=pulumi.get(__ret__, 'pipeline'),
        settings=pulumi.get(__ret__, 'settings'))
def get_org_metadata_output(domains: Optional[pulumi.Input[Optional[Union['GetOrgMetadataDomainsArgs', 'GetOrgMetadataDomainsArgsDict']]]] = None,
                            settings: Optional[pulumi.Input[Optional[Union['GetOrgMetadataSettingsArgs', 'GetOrgMetadataSettingsArgsDict']]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrgMetadataResult]:
    """
    Retrieves the well-known org metadata, which includes the id, configured custom domains, authentication pipeline, and various other org settings.


    :param Union['GetOrgMetadataDomainsArgs', 'GetOrgMetadataDomainsArgsDict'] domains: The URIs for the org's configured domains.
    :param Union['GetOrgMetadataSettingsArgs', 'GetOrgMetadataSettingsArgsDict'] settings: The wellknown org settings (safe for public consumption).
    """
    __args__ = dict()
    __args__['domains'] = domains
    __args__['settings'] = settings
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getOrgMetadata:getOrgMetadata', __args__, opts=opts, typ=GetOrgMetadataResult)
    return __ret__.apply(lambda __response__: GetOrgMetadataResult(
        domains=pulumi.get(__response__, 'domains'),
        id=pulumi.get(__response__, 'id'),
        pipeline=pulumi.get(__response__, 'pipeline'),
        settings=pulumi.get(__response__, 'settings')))
