# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PasswordArgs', 'Password']

@pulumi.input_type
class PasswordArgs:
    def __init__(__self__, *,
                 auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 call_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_auto_unlock_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_dictionary_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_first_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_last_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_username: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expire_warn_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_history_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password_lockout_notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_max_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_age_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_lowercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_number: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_symbol: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_uppercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_show_lockout_failures: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 question_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 question_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_email_token: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_unlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 sms_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Password resource.
        :param pulumi.Input[_builtins.str] auth_provider: Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        :param pulumi.Input[_builtins.str] call_recovery: Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[_builtins.str] email_recovery: Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] password_auto_unlock_minutes: Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.bool] password_dictionary_lookup: Check Passwords Against Common Password Dictionary. Default: `false`
        :param pulumi.Input[_builtins.bool] password_exclude_first_name: User firstName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_last_name: User lastName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_username: If the user name must be excluded from the password. Default: `true`
        :param pulumi.Input[_builtins.int] password_expire_warn_days: Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        :param pulumi.Input[_builtins.int] password_history_count: Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] password_lockout_notification_channels: Notification channels to use to notify a user when their account has been locked.
        :param pulumi.Input[_builtins.int] password_max_age_days: Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_max_lockout_attempts: Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        :param pulumi.Input[_builtins.int] password_min_age_minutes: Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_length: Minimum password length. Default: `8`
        :param pulumi.Input[_builtins.int] password_min_lowercase: If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_number: If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_symbol: If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_uppercase: If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.bool] password_show_lockout_failures: If a user should be informed when their account is locked. Default: `false`
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.int] question_min_length: Min length of the password recovery question answer. Default: `4`
        :param pulumi.Input[_builtins.str] question_recovery: Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.int] recovery_email_token: Lifetime in minutes of the recovery email token. Default: `60`
        :param pulumi.Input[_builtins.bool] skip_unlock: When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        :param pulumi.Input[_builtins.str] sms_recovery: Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)
        if call_recovery is not None:
            pulumi.set(__self__, "call_recovery", call_recovery)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_recovery is not None:
            pulumi.set(__self__, "email_recovery", email_recovery)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_auto_unlock_minutes is not None:
            pulumi.set(__self__, "password_auto_unlock_minutes", password_auto_unlock_minutes)
        if password_dictionary_lookup is not None:
            pulumi.set(__self__, "password_dictionary_lookup", password_dictionary_lookup)
        if password_exclude_first_name is not None:
            pulumi.set(__self__, "password_exclude_first_name", password_exclude_first_name)
        if password_exclude_last_name is not None:
            pulumi.set(__self__, "password_exclude_last_name", password_exclude_last_name)
        if password_exclude_username is not None:
            pulumi.set(__self__, "password_exclude_username", password_exclude_username)
        if password_expire_warn_days is not None:
            pulumi.set(__self__, "password_expire_warn_days", password_expire_warn_days)
        if password_history_count is not None:
            pulumi.set(__self__, "password_history_count", password_history_count)
        if password_lockout_notification_channels is not None:
            pulumi.set(__self__, "password_lockout_notification_channels", password_lockout_notification_channels)
        if password_max_age_days is not None:
            pulumi.set(__self__, "password_max_age_days", password_max_age_days)
        if password_max_lockout_attempts is not None:
            pulumi.set(__self__, "password_max_lockout_attempts", password_max_lockout_attempts)
        if password_min_age_minutes is not None:
            pulumi.set(__self__, "password_min_age_minutes", password_min_age_minutes)
        if password_min_length is not None:
            pulumi.set(__self__, "password_min_length", password_min_length)
        if password_min_lowercase is not None:
            pulumi.set(__self__, "password_min_lowercase", password_min_lowercase)
        if password_min_number is not None:
            pulumi.set(__self__, "password_min_number", password_min_number)
        if password_min_symbol is not None:
            pulumi.set(__self__, "password_min_symbol", password_min_symbol)
        if password_min_uppercase is not None:
            pulumi.set(__self__, "password_min_uppercase", password_min_uppercase)
        if password_show_lockout_failures is not None:
            pulumi.set(__self__, "password_show_lockout_failures", password_show_lockout_failures)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if question_min_length is not None:
            pulumi.set(__self__, "question_min_length", question_min_length)
        if question_recovery is not None:
            pulumi.set(__self__, "question_recovery", question_recovery)
        if recovery_email_token is not None:
            pulumi.set(__self__, "recovery_email_token", recovery_email_token)
        if skip_unlock is not None:
            pulumi.set(__self__, "skip_unlock", skip_unlock)
        if sms_recovery is not None:
            pulumi.set(__self__, "sms_recovery", sms_recovery)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        """
        return pulumi.get(self, "auth_provider")

    @auth_provider.setter
    def auth_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_provider", value)

    @_builtins.property
    @pulumi.getter(name="callRecovery")
    def call_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "call_recovery")

    @call_recovery.setter
    def call_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "call_recovery", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="emailRecovery")
    def email_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "email_recovery")

    @email_recovery.setter
    def email_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_recovery", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="passwordAutoUnlockMinutes")
    def password_auto_unlock_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_auto_unlock_minutes")

    @password_auto_unlock_minutes.setter
    def password_auto_unlock_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_auto_unlock_minutes", value)

    @_builtins.property
    @pulumi.getter(name="passwordDictionaryLookup")
    def password_dictionary_lookup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check Passwords Against Common Password Dictionary. Default: `false`
        """
        return pulumi.get(self, "password_dictionary_lookup")

    @password_dictionary_lookup.setter
    def password_dictionary_lookup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_dictionary_lookup", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeFirstName")
    def password_exclude_first_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User firstName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_first_name")

    @password_exclude_first_name.setter
    def password_exclude_first_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_first_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeLastName")
    def password_exclude_last_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User lastName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_last_name")

    @password_exclude_last_name.setter
    def password_exclude_last_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_last_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeUsername")
    def password_exclude_username(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the user name must be excluded from the password. Default: `true`
        """
        return pulumi.get(self, "password_exclude_username")

    @password_exclude_username.setter
    def password_exclude_username(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_username", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpireWarnDays")
    def password_expire_warn_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        """
        return pulumi.get(self, "password_expire_warn_days")

    @password_expire_warn_days.setter
    def password_expire_warn_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_expire_warn_days", value)

    @_builtins.property
    @pulumi.getter(name="passwordHistoryCount")
    def password_history_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        """
        return pulumi.get(self, "password_history_count")

    @password_history_count.setter
    def password_history_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_history_count", value)

    @_builtins.property
    @pulumi.getter(name="passwordLockoutNotificationChannels")
    def password_lockout_notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Notification channels to use to notify a user when their account has been locked.
        """
        return pulumi.get(self, "password_lockout_notification_channels")

    @password_lockout_notification_channels.setter
    def password_lockout_notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "password_lockout_notification_channels", value)

    @_builtins.property
    @pulumi.getter(name="passwordMaxAgeDays")
    def password_max_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_max_age_days")

    @password_max_age_days.setter
    def password_max_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_max_age_days", value)

    @_builtins.property
    @pulumi.getter(name="passwordMaxLockoutAttempts")
    def password_max_lockout_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        """
        return pulumi.get(self, "password_max_lockout_attempts")

    @password_max_lockout_attempts.setter
    def password_max_lockout_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_max_lockout_attempts", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinAgeMinutes")
    def password_min_age_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_min_age_minutes")

    @password_min_age_minutes.setter
    def password_min_age_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_age_minutes", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinLength")
    def password_min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum password length. Default: `8`
        """
        return pulumi.get(self, "password_min_length")

    @password_min_length.setter
    def password_min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_length", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinLowercase")
    def password_min_lowercase(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_lowercase")

    @password_min_lowercase.setter
    def password_min_lowercase(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_lowercase", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinNumber")
    def password_min_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_number")

    @password_min_number.setter
    def password_min_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_number", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinSymbol")
    def password_min_symbol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        """
        return pulumi.get(self, "password_min_symbol")

    @password_min_symbol.setter
    def password_min_symbol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_symbol", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinUppercase")
    def password_min_uppercase(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_uppercase")

    @password_min_uppercase.setter
    def password_min_uppercase(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_uppercase", value)

    @_builtins.property
    @pulumi.getter(name="passwordShowLockoutFailures")
    def password_show_lockout_failures(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If a user should be informed when their account is locked. Default: `false`
        """
        return pulumi.get(self, "password_show_lockout_failures")

    @password_show_lockout_failures.setter
    def password_show_lockout_failures(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_show_lockout_failures", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="questionMinLength")
    def question_min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Min length of the password recovery question answer. Default: `4`
        """
        return pulumi.get(self, "question_min_length")

    @question_min_length.setter
    def question_min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "question_min_length", value)

    @_builtins.property
    @pulumi.getter(name="questionRecovery")
    def question_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "question_recovery")

    @question_recovery.setter
    def question_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "question_recovery", value)

    @_builtins.property
    @pulumi.getter(name="recoveryEmailToken")
    def recovery_email_token(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime in minutes of the recovery email token. Default: `60`
        """
        return pulumi.get(self, "recovery_email_token")

    @recovery_email_token.setter
    def recovery_email_token(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recovery_email_token", value)

    @_builtins.property
    @pulumi.getter(name="skipUnlock")
    def skip_unlock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        """
        return pulumi.get(self, "skip_unlock")

    @skip_unlock.setter
    def skip_unlock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_unlock", value)

    @_builtins.property
    @pulumi.getter(name="smsRecovery")
    def sms_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "sms_recovery")

    @sms_recovery.setter
    def sms_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sms_recovery", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _PasswordState:
    def __init__(__self__, *,
                 auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 call_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_auto_unlock_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_dictionary_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_first_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_last_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_username: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expire_warn_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_history_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password_lockout_notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_max_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_age_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_lowercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_number: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_symbol: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_uppercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_show_lockout_failures: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 question_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 question_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_email_token: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_unlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 sms_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Password resources.
        :param pulumi.Input[_builtins.str] auth_provider: Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        :param pulumi.Input[_builtins.str] call_recovery: Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[_builtins.str] email_recovery: Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] password_auto_unlock_minutes: Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.bool] password_dictionary_lookup: Check Passwords Against Common Password Dictionary. Default: `false`
        :param pulumi.Input[_builtins.bool] password_exclude_first_name: User firstName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_last_name: User lastName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_username: If the user name must be excluded from the password. Default: `true`
        :param pulumi.Input[_builtins.int] password_expire_warn_days: Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        :param pulumi.Input[_builtins.int] password_history_count: Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] password_lockout_notification_channels: Notification channels to use to notify a user when their account has been locked.
        :param pulumi.Input[_builtins.int] password_max_age_days: Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_max_lockout_attempts: Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        :param pulumi.Input[_builtins.int] password_min_age_minutes: Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_length: Minimum password length. Default: `8`
        :param pulumi.Input[_builtins.int] password_min_lowercase: If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_number: If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_symbol: If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_uppercase: If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.bool] password_show_lockout_failures: If a user should be informed when their account is locked. Default: `false`
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.int] question_min_length: Min length of the password recovery question answer. Default: `4`
        :param pulumi.Input[_builtins.str] question_recovery: Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.int] recovery_email_token: Lifetime in minutes of the recovery email token. Default: `60`
        :param pulumi.Input[_builtins.bool] skip_unlock: When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        :param pulumi.Input[_builtins.str] sms_recovery: Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        if auth_provider is not None:
            pulumi.set(__self__, "auth_provider", auth_provider)
        if call_recovery is not None:
            pulumi.set(__self__, "call_recovery", call_recovery)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_recovery is not None:
            pulumi.set(__self__, "email_recovery", email_recovery)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_auto_unlock_minutes is not None:
            pulumi.set(__self__, "password_auto_unlock_minutes", password_auto_unlock_minutes)
        if password_dictionary_lookup is not None:
            pulumi.set(__self__, "password_dictionary_lookup", password_dictionary_lookup)
        if password_exclude_first_name is not None:
            pulumi.set(__self__, "password_exclude_first_name", password_exclude_first_name)
        if password_exclude_last_name is not None:
            pulumi.set(__self__, "password_exclude_last_name", password_exclude_last_name)
        if password_exclude_username is not None:
            pulumi.set(__self__, "password_exclude_username", password_exclude_username)
        if password_expire_warn_days is not None:
            pulumi.set(__self__, "password_expire_warn_days", password_expire_warn_days)
        if password_history_count is not None:
            pulumi.set(__self__, "password_history_count", password_history_count)
        if password_lockout_notification_channels is not None:
            pulumi.set(__self__, "password_lockout_notification_channels", password_lockout_notification_channels)
        if password_max_age_days is not None:
            pulumi.set(__self__, "password_max_age_days", password_max_age_days)
        if password_max_lockout_attempts is not None:
            pulumi.set(__self__, "password_max_lockout_attempts", password_max_lockout_attempts)
        if password_min_age_minutes is not None:
            pulumi.set(__self__, "password_min_age_minutes", password_min_age_minutes)
        if password_min_length is not None:
            pulumi.set(__self__, "password_min_length", password_min_length)
        if password_min_lowercase is not None:
            pulumi.set(__self__, "password_min_lowercase", password_min_lowercase)
        if password_min_number is not None:
            pulumi.set(__self__, "password_min_number", password_min_number)
        if password_min_symbol is not None:
            pulumi.set(__self__, "password_min_symbol", password_min_symbol)
        if password_min_uppercase is not None:
            pulumi.set(__self__, "password_min_uppercase", password_min_uppercase)
        if password_show_lockout_failures is not None:
            pulumi.set(__self__, "password_show_lockout_failures", password_show_lockout_failures)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if question_min_length is not None:
            pulumi.set(__self__, "question_min_length", question_min_length)
        if question_recovery is not None:
            pulumi.set(__self__, "question_recovery", question_recovery)
        if recovery_email_token is not None:
            pulumi.set(__self__, "recovery_email_token", recovery_email_token)
        if skip_unlock is not None:
            pulumi.set(__self__, "skip_unlock", skip_unlock)
        if sms_recovery is not None:
            pulumi.set(__self__, "sms_recovery", sms_recovery)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        """
        return pulumi.get(self, "auth_provider")

    @auth_provider.setter
    def auth_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_provider", value)

    @_builtins.property
    @pulumi.getter(name="callRecovery")
    def call_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "call_recovery")

    @call_recovery.setter
    def call_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "call_recovery", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="emailRecovery")
    def email_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "email_recovery")

    @email_recovery.setter
    def email_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_recovery", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="passwordAutoUnlockMinutes")
    def password_auto_unlock_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_auto_unlock_minutes")

    @password_auto_unlock_minutes.setter
    def password_auto_unlock_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_auto_unlock_minutes", value)

    @_builtins.property
    @pulumi.getter(name="passwordDictionaryLookup")
    def password_dictionary_lookup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Check Passwords Against Common Password Dictionary. Default: `false`
        """
        return pulumi.get(self, "password_dictionary_lookup")

    @password_dictionary_lookup.setter
    def password_dictionary_lookup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_dictionary_lookup", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeFirstName")
    def password_exclude_first_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User firstName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_first_name")

    @password_exclude_first_name.setter
    def password_exclude_first_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_first_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeLastName")
    def password_exclude_last_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User lastName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_last_name")

    @password_exclude_last_name.setter
    def password_exclude_last_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_last_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordExcludeUsername")
    def password_exclude_username(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the user name must be excluded from the password. Default: `true`
        """
        return pulumi.get(self, "password_exclude_username")

    @password_exclude_username.setter
    def password_exclude_username(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_exclude_username", value)

    @_builtins.property
    @pulumi.getter(name="passwordExpireWarnDays")
    def password_expire_warn_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        """
        return pulumi.get(self, "password_expire_warn_days")

    @password_expire_warn_days.setter
    def password_expire_warn_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_expire_warn_days", value)

    @_builtins.property
    @pulumi.getter(name="passwordHistoryCount")
    def password_history_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        """
        return pulumi.get(self, "password_history_count")

    @password_history_count.setter
    def password_history_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_history_count", value)

    @_builtins.property
    @pulumi.getter(name="passwordLockoutNotificationChannels")
    def password_lockout_notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Notification channels to use to notify a user when their account has been locked.
        """
        return pulumi.get(self, "password_lockout_notification_channels")

    @password_lockout_notification_channels.setter
    def password_lockout_notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "password_lockout_notification_channels", value)

    @_builtins.property
    @pulumi.getter(name="passwordMaxAgeDays")
    def password_max_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_max_age_days")

    @password_max_age_days.setter
    def password_max_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_max_age_days", value)

    @_builtins.property
    @pulumi.getter(name="passwordMaxLockoutAttempts")
    def password_max_lockout_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        """
        return pulumi.get(self, "password_max_lockout_attempts")

    @password_max_lockout_attempts.setter
    def password_max_lockout_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_max_lockout_attempts", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinAgeMinutes")
    def password_min_age_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_min_age_minutes")

    @password_min_age_minutes.setter
    def password_min_age_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_age_minutes", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinLength")
    def password_min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum password length. Default: `8`
        """
        return pulumi.get(self, "password_min_length")

    @password_min_length.setter
    def password_min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_length", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinLowercase")
    def password_min_lowercase(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_lowercase")

    @password_min_lowercase.setter
    def password_min_lowercase(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_lowercase", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinNumber")
    def password_min_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_number")

    @password_min_number.setter
    def password_min_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_number", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinSymbol")
    def password_min_symbol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        """
        return pulumi.get(self, "password_min_symbol")

    @password_min_symbol.setter
    def password_min_symbol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_symbol", value)

    @_builtins.property
    @pulumi.getter(name="passwordMinUppercase")
    def password_min_uppercase(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_uppercase")

    @password_min_uppercase.setter
    def password_min_uppercase(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_min_uppercase", value)

    @_builtins.property
    @pulumi.getter(name="passwordShowLockoutFailures")
    def password_show_lockout_failures(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If a user should be informed when their account is locked. Default: `false`
        """
        return pulumi.get(self, "password_show_lockout_failures")

    @password_show_lockout_failures.setter
    def password_show_lockout_failures(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_show_lockout_failures", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="questionMinLength")
    def question_min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Min length of the password recovery question answer. Default: `4`
        """
        return pulumi.get(self, "question_min_length")

    @question_min_length.setter
    def question_min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "question_min_length", value)

    @_builtins.property
    @pulumi.getter(name="questionRecovery")
    def question_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "question_recovery")

    @question_recovery.setter
    def question_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "question_recovery", value)

    @_builtins.property
    @pulumi.getter(name="recoveryEmailToken")
    def recovery_email_token(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime in minutes of the recovery email token. Default: `60`
        """
        return pulumi.get(self, "recovery_email_token")

    @recovery_email_token.setter
    def recovery_email_token(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recovery_email_token", value)

    @_builtins.property
    @pulumi.getter(name="skipUnlock")
    def skip_unlock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        """
        return pulumi.get(self, "skip_unlock")

    @skip_unlock.setter
    def skip_unlock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_unlock", value)

    @_builtins.property
    @pulumi.getter(name="smsRecovery")
    def sms_recovery(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "sms_recovery")

    @sms_recovery.setter
    def sms_recovery(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sms_recovery", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("okta:policy/password:Password")
class Password(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 call_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_auto_unlock_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_dictionary_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_first_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_last_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_username: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expire_warn_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_history_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password_lockout_notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_max_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_age_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_lowercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_number: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_symbol: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_uppercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_show_lockout_failures: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 question_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 question_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_email_token: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_unlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 sms_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Password Policy. This resource allows you to create and configure a Password Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.policy.Password("example",
            name="example",
            status="ACTIVE",
            description="Example",
            password_history_count=4,
            groups_includeds=[everyone["id"]])
        ```

        ## Import

        ```sh
        $ pulumi import okta:policy/password:Password example <policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_provider: Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        :param pulumi.Input[_builtins.str] call_recovery: Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[_builtins.str] email_recovery: Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] password_auto_unlock_minutes: Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.bool] password_dictionary_lookup: Check Passwords Against Common Password Dictionary. Default: `false`
        :param pulumi.Input[_builtins.bool] password_exclude_first_name: User firstName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_last_name: User lastName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_username: If the user name must be excluded from the password. Default: `true`
        :param pulumi.Input[_builtins.int] password_expire_warn_days: Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        :param pulumi.Input[_builtins.int] password_history_count: Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] password_lockout_notification_channels: Notification channels to use to notify a user when their account has been locked.
        :param pulumi.Input[_builtins.int] password_max_age_days: Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_max_lockout_attempts: Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        :param pulumi.Input[_builtins.int] password_min_age_minutes: Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_length: Minimum password length. Default: `8`
        :param pulumi.Input[_builtins.int] password_min_lowercase: If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_number: If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_symbol: If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_uppercase: If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.bool] password_show_lockout_failures: If a user should be informed when their account is locked. Default: `false`
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.int] question_min_length: Min length of the password recovery question answer. Default: `4`
        :param pulumi.Input[_builtins.str] question_recovery: Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.int] recovery_email_token: Lifetime in minutes of the recovery email token. Default: `60`
        :param pulumi.Input[_builtins.bool] skip_unlock: When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        :param pulumi.Input[_builtins.str] sms_recovery: Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PasswordArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Password Policy. This resource allows you to create and configure a Password Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.policy.Password("example",
            name="example",
            status="ACTIVE",
            description="Example",
            password_history_count=4,
            groups_includeds=[everyone["id"]])
        ```

        ## Import

        ```sh
        $ pulumi import okta:policy/password:Password example <policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param PasswordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PasswordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 call_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password_auto_unlock_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_dictionary_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_first_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_last_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_exclude_username: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_expire_warn_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_history_count: Optional[pulumi.Input[_builtins.int]] = None,
                 password_lockout_notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 password_max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 password_max_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_age_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_lowercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_number: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_symbol: Optional[pulumi.Input[_builtins.int]] = None,
                 password_min_uppercase: Optional[pulumi.Input[_builtins.int]] = None,
                 password_show_lockout_failures: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 question_min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 question_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_email_token: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_unlock: Optional[pulumi.Input[_builtins.bool]] = None,
                 sms_recovery: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PasswordArgs.__new__(PasswordArgs)

            __props__.__dict__["auth_provider"] = auth_provider
            __props__.__dict__["call_recovery"] = call_recovery
            __props__.__dict__["description"] = description
            __props__.__dict__["email_recovery"] = email_recovery
            __props__.__dict__["groups_includeds"] = groups_includeds
            __props__.__dict__["name"] = name
            __props__.__dict__["password_auto_unlock_minutes"] = password_auto_unlock_minutes
            __props__.__dict__["password_dictionary_lookup"] = password_dictionary_lookup
            __props__.__dict__["password_exclude_first_name"] = password_exclude_first_name
            __props__.__dict__["password_exclude_last_name"] = password_exclude_last_name
            __props__.__dict__["password_exclude_username"] = password_exclude_username
            __props__.__dict__["password_expire_warn_days"] = password_expire_warn_days
            __props__.__dict__["password_history_count"] = password_history_count
            __props__.__dict__["password_lockout_notification_channels"] = password_lockout_notification_channels
            __props__.__dict__["password_max_age_days"] = password_max_age_days
            __props__.__dict__["password_max_lockout_attempts"] = password_max_lockout_attempts
            __props__.__dict__["password_min_age_minutes"] = password_min_age_minutes
            __props__.__dict__["password_min_length"] = password_min_length
            __props__.__dict__["password_min_lowercase"] = password_min_lowercase
            __props__.__dict__["password_min_number"] = password_min_number
            __props__.__dict__["password_min_symbol"] = password_min_symbol
            __props__.__dict__["password_min_uppercase"] = password_min_uppercase
            __props__.__dict__["password_show_lockout_failures"] = password_show_lockout_failures
            __props__.__dict__["priority"] = priority
            __props__.__dict__["question_min_length"] = question_min_length
            __props__.__dict__["question_recovery"] = question_recovery
            __props__.__dict__["recovery_email_token"] = recovery_email_token
            __props__.__dict__["skip_unlock"] = skip_unlock
            __props__.__dict__["sms_recovery"] = sms_recovery
            __props__.__dict__["status"] = status
        super(Password, __self__).__init__(
            'okta:policy/password:Password',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_provider: Optional[pulumi.Input[_builtins.str]] = None,
            call_recovery: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            email_recovery: Optional[pulumi.Input[_builtins.str]] = None,
            groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password_auto_unlock_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            password_dictionary_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
            password_exclude_first_name: Optional[pulumi.Input[_builtins.bool]] = None,
            password_exclude_last_name: Optional[pulumi.Input[_builtins.bool]] = None,
            password_exclude_username: Optional[pulumi.Input[_builtins.bool]] = None,
            password_expire_warn_days: Optional[pulumi.Input[_builtins.int]] = None,
            password_history_count: Optional[pulumi.Input[_builtins.int]] = None,
            password_lockout_notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            password_max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
            password_max_lockout_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_age_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_length: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_lowercase: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_number: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_symbol: Optional[pulumi.Input[_builtins.int]] = None,
            password_min_uppercase: Optional[pulumi.Input[_builtins.int]] = None,
            password_show_lockout_failures: Optional[pulumi.Input[_builtins.bool]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            question_min_length: Optional[pulumi.Input[_builtins.int]] = None,
            question_recovery: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_email_token: Optional[pulumi.Input[_builtins.int]] = None,
            skip_unlock: Optional[pulumi.Input[_builtins.bool]] = None,
            sms_recovery: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Password':
        """
        Get an existing Password resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_provider: Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        :param pulumi.Input[_builtins.str] call_recovery: Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[_builtins.str] email_recovery: Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] password_auto_unlock_minutes: Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.bool] password_dictionary_lookup: Check Passwords Against Common Password Dictionary. Default: `false`
        :param pulumi.Input[_builtins.bool] password_exclude_first_name: User firstName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_last_name: User lastName attribute must be excluded from the password
        :param pulumi.Input[_builtins.bool] password_exclude_username: If the user name must be excluded from the password. Default: `true`
        :param pulumi.Input[_builtins.int] password_expire_warn_days: Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        :param pulumi.Input[_builtins.int] password_history_count: Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] password_lockout_notification_channels: Notification channels to use to notify a user when their account has been locked.
        :param pulumi.Input[_builtins.int] password_max_age_days: Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_max_lockout_attempts: Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        :param pulumi.Input[_builtins.int] password_min_age_minutes: Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_length: Minimum password length. Default: `8`
        :param pulumi.Input[_builtins.int] password_min_lowercase: If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_number: If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.int] password_min_symbol: If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        :param pulumi.Input[_builtins.int] password_min_uppercase: If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        :param pulumi.Input[_builtins.bool] password_show_lockout_failures: If a user should be informed when their account is locked. Default: `false`
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.int] question_min_length: Min length of the password recovery question answer. Default: `4`
        :param pulumi.Input[_builtins.str] question_recovery: Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.int] recovery_email_token: Lifetime in minutes of the recovery email token. Default: `60`
        :param pulumi.Input[_builtins.bool] skip_unlock: When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        :param pulumi.Input[_builtins.str] sms_recovery: Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PasswordState.__new__(_PasswordState)

        __props__.__dict__["auth_provider"] = auth_provider
        __props__.__dict__["call_recovery"] = call_recovery
        __props__.__dict__["description"] = description
        __props__.__dict__["email_recovery"] = email_recovery
        __props__.__dict__["groups_includeds"] = groups_includeds
        __props__.__dict__["name"] = name
        __props__.__dict__["password_auto_unlock_minutes"] = password_auto_unlock_minutes
        __props__.__dict__["password_dictionary_lookup"] = password_dictionary_lookup
        __props__.__dict__["password_exclude_first_name"] = password_exclude_first_name
        __props__.__dict__["password_exclude_last_name"] = password_exclude_last_name
        __props__.__dict__["password_exclude_username"] = password_exclude_username
        __props__.__dict__["password_expire_warn_days"] = password_expire_warn_days
        __props__.__dict__["password_history_count"] = password_history_count
        __props__.__dict__["password_lockout_notification_channels"] = password_lockout_notification_channels
        __props__.__dict__["password_max_age_days"] = password_max_age_days
        __props__.__dict__["password_max_lockout_attempts"] = password_max_lockout_attempts
        __props__.__dict__["password_min_age_minutes"] = password_min_age_minutes
        __props__.__dict__["password_min_length"] = password_min_length
        __props__.__dict__["password_min_lowercase"] = password_min_lowercase
        __props__.__dict__["password_min_number"] = password_min_number
        __props__.__dict__["password_min_symbol"] = password_min_symbol
        __props__.__dict__["password_min_uppercase"] = password_min_uppercase
        __props__.__dict__["password_show_lockout_failures"] = password_show_lockout_failures
        __props__.__dict__["priority"] = priority
        __props__.__dict__["question_min_length"] = question_min_length
        __props__.__dict__["question_recovery"] = question_recovery
        __props__.__dict__["recovery_email_token"] = recovery_email_token
        __props__.__dict__["skip_unlock"] = skip_unlock
        __props__.__dict__["sms_recovery"] = sms_recovery
        __props__.__dict__["status"] = status
        return Password(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authProvider")
    def auth_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authentication Provider: `OKTA`, `ACTIVE_DIRECTORY` or `LDAP`. Default: `OKTA`
        """
        return pulumi.get(self, "auth_provider")

    @_builtins.property
    @pulumi.getter(name="callRecovery")
    def call_recovery(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable or disable voice call recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "call_recovery")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="emailRecovery")
    def email_recovery(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable or disable email password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "email_recovery")

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="passwordAutoUnlockMinutes")
    def password_auto_unlock_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of minutes before a locked account is unlocked: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_auto_unlock_minutes")

    @_builtins.property
    @pulumi.getter(name="passwordDictionaryLookup")
    def password_dictionary_lookup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Check Passwords Against Common Password Dictionary. Default: `false`
        """
        return pulumi.get(self, "password_dictionary_lookup")

    @_builtins.property
    @pulumi.getter(name="passwordExcludeFirstName")
    def password_exclude_first_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        User firstName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_first_name")

    @_builtins.property
    @pulumi.getter(name="passwordExcludeLastName")
    def password_exclude_last_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        User lastName attribute must be excluded from the password
        """
        return pulumi.get(self, "password_exclude_last_name")

    @_builtins.property
    @pulumi.getter(name="passwordExcludeUsername")
    def password_exclude_username(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the user name must be excluded from the password. Default: `true`
        """
        return pulumi.get(self, "password_exclude_username")

    @_builtins.property
    @pulumi.getter(name="passwordExpireWarnDays")
    def password_expire_warn_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Length in days a user will be warned before password expiry: 0 = no warning. Default: `0`
        """
        return pulumi.get(self, "password_expire_warn_days")

    @_builtins.property
    @pulumi.getter(name="passwordHistoryCount")
    def password_history_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of distinct passwords that must be created before they can be reused: 0 = none. Default: `0`
        """
        return pulumi.get(self, "password_history_count")

    @_builtins.property
    @pulumi.getter(name="passwordLockoutNotificationChannels")
    def password_lockout_notification_channels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Notification channels to use to notify a user when their account has been locked.
        """
        return pulumi.get(self, "password_lockout_notification_channels")

    @_builtins.property
    @pulumi.getter(name="passwordMaxAgeDays")
    def password_max_age_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Length in days a password is valid before expiry: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_max_age_days")

    @_builtins.property
    @pulumi.getter(name="passwordMaxLockoutAttempts")
    def password_max_lockout_attempts(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of unsuccessful login attempts allowed before lockout: 0 = no limit. Default: `10`
        """
        return pulumi.get(self, "password_max_lockout_attempts")

    @_builtins.property
    @pulumi.getter(name="passwordMinAgeMinutes")
    def password_min_age_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum time interval in minutes between password changes: 0 = no limit. Default: `0`
        """
        return pulumi.get(self, "password_min_age_minutes")

    @_builtins.property
    @pulumi.getter(name="passwordMinLength")
    def password_min_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum password length. Default: `8`
        """
        return pulumi.get(self, "password_min_length")

    @_builtins.property
    @pulumi.getter(name="passwordMinLowercase")
    def password_min_lowercase(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_lowercase")

    @_builtins.property
    @pulumi.getter(name="passwordMinNumber")
    def password_min_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If a password must contain at least one number: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_number")

    @_builtins.property
    @pulumi.getter(name="passwordMinSymbol")
    def password_min_symbol(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default: `0`
        """
        return pulumi.get(self, "password_min_symbol")

    @_builtins.property
    @pulumi.getter(name="passwordMinUppercase")
    def password_min_uppercase(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default: `1`
        """
        return pulumi.get(self, "password_min_uppercase")

    @_builtins.property
    @pulumi.getter(name="passwordShowLockoutFailures")
    def password_show_lockout_failures(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If a user should be informed when their account is locked. Default: `false`
        """
        return pulumi.get(self, "password_show_lockout_failures")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="questionMinLength")
    def question_min_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Min length of the password recovery question answer. Default: `4`
        """
        return pulumi.get(self, "question_min_length")

    @_builtins.property
    @pulumi.getter(name="questionRecovery")
    def question_recovery(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable or disable security question password recovery: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "question_recovery")

    @_builtins.property
    @pulumi.getter(name="recoveryEmailToken")
    def recovery_email_token(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime in minutes of the recovery email token. Default: `60`
        """
        return pulumi.get(self, "recovery_email_token")

    @_builtins.property
    @pulumi.getter(name="skipUnlock")
    def skip_unlock(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account. Default: `false`
        """
        return pulumi.get(self, "skip_unlock")

    @_builtins.property
    @pulumi.getter(name="smsRecovery")
    def sms_recovery(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable or disable SMS password recovery: `ACTIVE` or `INACTIVE`. Default: `INACTIVE`
        """
        return pulumi.get(self, "sms_recovery")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

