def 更新_追加内容(连接对象, 表名, 字段名, 新内容, 条件):
    """
    在指定表的某个字段追加内容（不覆盖原有内容）。

    参数：
        - 连接对象：数据库连接对象。
        - 表名：需要更新的表名。
        - 字段名：需要追加内容的字段名称。
        - 新内容：要追加到字段中的内容。
        - 条件：指定更新条件的 SQL WHERE 字符串，例如 "id = 1"。

    返回值：
        - 更新成功返回 True，失败返回 False。

    使用示例（可以复制并直接修改）：
        更新结果 = zfx_mysql.更新_追加内容(连接对象, "test", "log", "BBB CCC", "id = 1")

        # 替换参数：
        # - 连接对象：已建立的数据库连接对象
        # - 表名：要更新的表名称，如 "微软自动兑换"
        # - 字段名：需要追加内容的字段名称，如 "运行日志"
        # - 新内容：要追加的内容，如 "BBB CCC"
        # - 条件：更新的条件字符串，如 "id = 1"

        # 使用返回结果：
        # if 更新结果:
        #     print("内容追加成功")
        # else:
        #     print("内容追加失败")
    """
    游标对象 = None
    try:
        # 构造 SQL 语句，使用 CONCAT 函数追加内容，并处理 NULL 值
        sql = f"UPDATE {表名} SET {字段名} = CONCAT(COALESCE({字段名}, ''), %s) WHERE {条件};"

        # 获取游标对象，用于执行 SQL 语句
        游标对象 = 连接对象.cursor()

        # 执行 SQL 语句，将新内容追加到指定字段
        游标对象.execute(sql, (新内容,))

        # 提交事务，确保更改生效
        连接对象.commit()

        return True
    except Exception:
        return False
    finally:
        # 如果游标对象存在，关闭游标，释放资源
        if 游标对象:
            游标对象.close()