import mysql.connector
from mysql.connector import Error


def 连接数据库(
    主机: str,
    用户名: str,
    密码: str,
    数据库名: str,
    字符集: str = "utf8mb4",
    排序规则: str | None = None,
    字典游标: bool = True,
    自动提交: bool = False,
):
    """
    建立到 MySQL 的连接并返回 (连接对象, 游标对象)，适配 mysql-connector-python 官方库。

    Args:
        主机 (str): 数据库主机名或 IP。
        用户名 (str): 数据库用户名。
        密码 (str): 数据库密码。
        数据库名 (str): 目标数据库名称。
        字符集 (str): 连接字符集，默认 "utf8mb4"。
        排序规则 (str | None): 字符排序规则（collation），如 "utf8mb4_0900_ai_ci"；为 None 则仅设置字符集。
        字典游标 (bool): 为 True 时返回字典行游标（按列名取值更方便）。
        自动提交 (bool): 是否启用 autocommit，默认 False。

    Returns:
        tuple:
            (连接对象, 游标对象)。当连接失败时返回 (None, None)。

    Notes:
        - 官方推荐在连接建立后使用 set_charset_collation() 设置字符集/排序规则，
          而不是把 charset 作为 connect() 的关键字参数传入。
        - 若运行环境极端精简导致无 set_charset_collation()，将降级执行 SQL：SET NAMES <字符集>。
        - 默认 autocommit=False；需要自动提交可传入 自动提交=True。
    """
    try:
        连接对象 = mysql.connector.connect(
            host=主机,
            user=用户名,
            password=密码,
            database=数据库名,
        )

        # 可选：自动提交
        连接对象.autocommit = 自动提交

        # 官方路径：设置字符集/排序规则
        try:
            if 排序规则:
                连接对象.set_charset_collation(字符集, 排序规则)
            else:
                连接对象.set_charset_collation(字符集)
        except AttributeError:
            # 极端降级兜底（不常见）：老环境无该方法时，直接执行 SET NAMES
            临时游标 = 连接对象.cursor()
            临时游标.execute(f"SET NAMES {字符集}")
            临时游标.close()

        游标对象 = 连接对象.cursor(dictionary=字典游标)
        return 连接对象, 游标对象

    except Error as e:
        print(f"数据库连接失败：{e}")
        return None, None


print(连接数据库("127.0.0.1","root","root","zengfengxiang"))