def 反转(列表对象, debug=True):
    """
    将列表中的元素顺序颠倒，返回一个新的列表。

    参数:
        - 列表对象 (list): 要处理的列表，例如 [1, 2, 3, 4]。
        - debug (bool): 是否输出调试日志（异常时打印错误信息），默认值为 True。

    返回值:
        - list:
            - 成功时返回反转后的新列表；
            - 如果输入为空列表或发生异常，返回空列表 []。

    注意事项:
        1. 输入必须是列表类型，否则会触发异常。
        2. 本函数不修改原列表，返回一个新的反转列表。

    使用示例:
        新列表 = 反转([1, 2, 3, 4])
        新列表 = 反转(["a", "b", "c", "d"])
    """
    try:
        if not isinstance(列表对象, list):
            raise TypeError("参数必须为列表类型")
        return 列表对象[::-1]
    except Exception as e:
        if debug:
            print(f"[反转] 功能异常：{e}（输入={列表对象}）")
        return []
