def 降序排序(列表对象, debug=True):
    r"""
    将列表中的元素降序排列，返回一个新的列表。

    参数：
        - 列表对象 (list): 要处理的列表，例如 [4, 2, 9, 1]。
        - debug (bool): 是否输出调试日志（异常时打印错误信息），默认值为 True。

    返回值：
        - list:
            - 成功时返回降序排列的新列表；
            - 如果列表为空或发生异常，返回空列表 []。

    注意事项：
        1. 输入必须是列表类型，否则会触发异常。
        2. 列表元素必须可比较（支持大小比较运算）。
        3. 原列表不会被修改，返回的是一个新的排序后的列表。

    使用示例：
        新列表 = 降序排序([5, 2, 9])
        新列表 = 降序排序(["b", "a", "c"])
    """
    try:
        # 确保输入是列表类型
        if not isinstance(列表对象, list):
            raise TypeError("参数必须为列表类型")

        # 返回降序排列的新列表
        return sorted(列表对象, reverse=True)

    except Exception as e:
        if debug:
            print(f"[降序排序] 功能异常：{e}（输入={列表对象}）")
        return []
