def 去除指定字符串_首次出现(原始文本, 目标文本):
    """
    去除原始文本中目标文本的首次出现。

    参数:
        - 原始文本(str): 原始的文本内容。
        - 目标文本(str): 需要去除的字符或字符串。

    返回:
        处理后的文本。如果输入不是字符串，则返回原始文本。
    """
    # 确保输入为字符串类型
    if not isinstance(原始文本, str) or not isinstance(目标文本, str):
        return 原始文本

    # 查找目标文本首次出现的位置
    位置 = 原始文本.find(目标文本)

    # 如果找到了目标文本，去除它的首次出现
    if 位置 != -1:
        return 原始文本[:位置] + 原始文本[位置 + len(目标文本):]

    # 如果没有找到目标文本，返回原始文本
    return 原始文本
