import re


def 只取符号(源文本):
    """
    从源文本中提取符号。

    参数:
        源文本 (str): 要提取符号的源文本。

    返回:
        str: 提取的符号字符串，如果出现任何异常，则返回空字符串。

    示例:
        源文本 = "这是一个示例文本，包含一些符号：!?@#$%^&*()_+"
        符号文本 = zfx_textutils.只取符号(源文本)
        print("提取的符号文本:", 符号文本)
    """
    try:
        # 使用正则表达式匹配非字母、非数字、非空格的字符
        符号列表 = re.findall(r'[^\w\s]', 源文本)
        # 将符号列表连接成一个字符串并返回
        return ''.join(符号列表)
    except Exception:
        return ""