def 响应文本_去除换行符(响应文本):
    """
    功能：
        对传入的响应文本（字符串）进行处理，移除其中的所有换行符，
        包括 '\n' 和 '\r'，返回一行连续的字符串。

    参数：
        - 响应文本 (str)：
            已经提取出来的字符串内容。
            如果传入 None，则直接返回空字符串。

    返回：
        - str：
            处理后的字符串，所有换行符均已去除。
        - str（空字符串）：
            当 响应文本 为 None 或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应文本 为 None，立即返回空字符串。
        - 如果字符串替换过程中出错，也会返回空字符串。

    示例：
        >>> 内容 = "第一行\\n第二行\\r\\n第三行"
        >>> 结果 = 响应文本_去除换行符(内容)
        >>> print(结果)
        "第一行第二行第三行"

    注意事项：
        - 仅去除换行符，不会去除空格或制表符。
        - 如果需要进一步清理多余空格，可在本函数结果上再调用 .strip() 或正则。
    """
    try:
        if 响应文本 is None:
            return ''
        return 响应文本.replace('\n', '').replace('\r', '')
    except Exception:
        return ''
