def 响应文本_取指定行内容(响应文本, 行号):
    """
    功能：
        从响应文本（字符串）中获取指定行号的内容。
        行号从 1 开始计数（符合常规习惯）。

    参数：
        - 响应文本 (str)：
            已经提取出来的字符串内容。
            如果传入 None，则直接返回空字符串。
        - 行号 (int)：
            要获取的行号，从 1 开始计数。
            例如 行号=1 表示第一行。

    返回：
        - str：
            指定行号对应的文本内容。
        - str（空字符串）：
            当 响应文本 为 None、行号超出范围、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应文本 为 None，立即返回空字符串。
        - 如果行号小于 1 或超出总行数，返回空字符串。
        - 如果 splitlines 或切片过程中出错，也会返回空字符串。

    示例：
        >>> 内容 = "第一行\\n第二行\\n第三行"
        >>> 行2 = 响应文本_取指定行内容(内容, 2)
        >>> print(行2)
        "第二行"

        >>> 行999 = 响应文本_取指定行内容(内容, 999)
        >>> print(行999)
        ""

    注意事项：
        - 行号从 1 开始，而不是 0。
        - 使用 .splitlines() 自动兼容 \n / \r\n / \r。
        - 返回的字符串不包含换行符本身。
    """
    try:
        if 响应文本 is None:
            return ''
        行列表 = 响应文本.splitlines()
        实际行号 = 行号 - 1  # 转换为 0 基索引
        if 0 <= 实际行号 < len(行列表):
            return 行列表[实际行号]
        return ''
    except Exception:
        return ''
