def 响应文本_取行数(响应文本):
    """
    功能：
        统计响应文本（字符串）的总行数。
        行数按换行符分割，自动兼容 \n / \r\n / \r。

    参数：
        - 响应文本 (str)：
            已经提取出来的字符串内容。
            如果传入 None，则直接返回 0。

    返回：
        - int：
            文本的总行数。
        - 0：
            当 响应文本 为 None 或出现异常时，返回 0。

    异常处理逻辑：
        - 如果 响应文本 为 None，立即返回 0。
        - 如果 splitlines 过程中出错，也会返回 0。

    示例：
        >>> 内容 = "第一行\\n第二行\\n第三行"
        >>> 行数 = 响应文本_取行数(内容)
        >>> print(行数)
        3

        >>> 空 = 响应文本_取行数(None)
        >>> print(空)
        0

    注意事项：
        - 使用 .splitlines()，能兼容多种换行符格式。
        - 返回的是逻辑行数，不包含换行符本身。
    """
    try:
        if 响应文本 is None:
            return 0
        return len(响应文本.splitlines())
    except Exception:
        return 0
