def 搜索邮件_按收件人和日期(连接对象, 收件人邮箱, 年, 月, 日, 条件="SINCE"):
    """
    通过收件人邮箱和日期搜索邮件。

    参数:
        - 连接对象 (imaplib.IMAP4_SSL or imaplib.IMAP4): 已连接的IMAP服务器对象。
        - 收件人邮箱 (str): 要搜索的收件人邮箱地址。
        - 年 (int): 年份，格式为四位数，例如 2024。
        - 月 (int): 月份，1 到 12。
        - 日 (int): 日期，1 到 31。
        - 条件 (str): 搜索条件，默认为 'SINCE'，表示搜索指定日期之后的邮件。可以为 'BEFORE' 表示搜索指定日期之前的邮件，也可以为 'ON'（精确匹配指定日期的邮件）。

    返回:
        - list: 包含符合搜索条件的邮件的邮件ID列表。

    说明:
        1. 先根据收件人邮箱和日期条件生成精确的搜索条件，缩小搜索范围。
        2. 如果搜索失败，返回空列表。
        3. 搜索条件支持 `SINCE`（指定日期之后的所有邮件）、`BEFORE`（指定日期之前的所有邮件）和 `ON`（精确匹配指定日期的邮件）三种。
        4. 使用 IMAP 搜索语法中的 `TO` 关键字来根据收件人邮箱搜索邮件。
           IMAP 的 `TO` 关键字用于匹配邮件的收件人字段。如果没有使用正确的搜索关键字，
           可能会导致搜索失败或者返回不正确的结果。
    """
    try:
        # 定义月份名称的列表
        月份名称 = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

        # 构建符合标准的日期格式
        日期 = f'{日}-{月份名称[月 - 1]}-{年}'

        # 构建IMAP的日期搜索条件
        日期搜索条件 = f'{条件} "{日期}"'

        # 构建IMAP的收件人搜索条件
        收件人搜索条件 = f'TO "{收件人邮箱}"'

        # 联合日期和收件人搜索条件
        搜索条件 = f'({收件人搜索条件} {日期搜索条件})'

        # 使用 search 方法根据联合条件查找邮件
        状态, 邮件数据 = 连接对象.search(None, 搜索条件)

        # 如果搜索失败，返回空列表
        if 状态 != "OK":
            return []

        # 返回符合条件的邮件ID列表
        邮件ID列表 = 邮件数据[0].split()
        return 邮件ID列表

    except Exception:
        return []