def 删除指定邮件(服务器对象, 邮件索引):
    """
    删除指定 POP3 服务器上某一 索引的邮件。

    参数：
        - 服务器对象：一个已连接的 POP3 服务器对象，通常由 poplib.POP3 或 poplib.POP3_SSL 创建。
        - 邮件索引：要删除的邮件的索引号，通常从 1 开始计数。

    返回值：
        - bool：如果邮件成功删除，返回 True；如果删除失败，返回 False。

    使用示例：
        连接对象 = zfx_pop3.连接服务器('pop.服务器.com', use_ssl=True)
        登录结果 = zfx_pop3.登录(连接对象, '用户名', '密码')
        删除结果 = zfx_pop3.删除指定邮件(连接对象, 3)

        # 该示例尝试删除索引为 3 的邮件。

    注意：
        - 删除操作仅在邮件会话关闭时（例如调用 `zfx_pop3.断开连接(服务器对象)`）才会生效。
        - 确保在删除之前对邮件索引进行验证，以避免误删邮件。
    """
    try:
        服务器对象.dele(邮件索引)
        return True
    except Exception:
        return False