def 获取邮箱占用空间(服务器对象):
    """
    获取邮箱的占用空间，以字节为单位。

    参数：
        - 服务器对象 (poplib.POP3)：已经连接并登录的 POP3 服务器对象。

    返回值：
        - int：邮箱占用的空间大小（以字节为单位）。
        - bool：如果出现异常，返回 False。

    使用示例：
        邮件服务器 = zfx_pop3.登录('pop.服务器.com', '用户名', '密码')
        邮箱空间 = zfx_pop3.获取邮箱占用空间(邮件服务器)
        if 邮箱空间 is not False:
            print(f"邮箱占用了 {邮箱空间} 字节的空间")
        else:
            print("获取邮箱占用空间失败")

    注意：
        - 此函数返回邮箱当前占用的总空间大小（以字节为单位），如果操作失败或发生异常，则返回 False。
    """
    try:
        # 获取邮箱的邮件数量和总占用空间
        _, 邮箱占用空间 = 服务器对象.stat()
        return 邮箱占用空间  # 返回邮箱占用的字节大小
    except Exception:
        return False  # 捕获异常并返回 False