# Default Template Documentation

## Template Overview
- **Template Name**: default
- **Analysis Date**: 2025-06-23 13:26:00
- **Total Layouts**: 19
- **Template Location**: `/Users/bruce/GitHub/teknologika/deck-builder-mcp/assets/templates/default`

## Layout Summary

| Layout Name | Index | Placeholders | Structured Support | JSON Mapping |
|-------------|-------|--------------|-------------------|--------------|
| Title Slide | 0 | 5 | ⏳ | ✅ |
| Title and Content | 1 | 5 | ⏳ | ✅ |
| Section Header | 2 | 5 | ⏳ | ✅ |
| Two Content | 3 | 6 | ⏳ | ✅ |
| Comparison | 4 | 8 | ⏳ | ✅ |
| Title Only | 5 | 4 | ⏳ | ✅ |
| Blank | 6 | 3 | ⏳ | ✅ |
| Content with Caption | 7 | 6 | ⏳ | ✅ |
| Picture with Caption | 8 | 6 | ⏳ | ✅ |
| Title and Vertical Text | 9 | 5 | ⏳ | ✅ |
| Vertical Title and Text | 10 | 5 | ⏳ | ✅ |
| Three Columns With Titles | 11 | 10 | ⏳ | ✅ |
| Three Columns | 12 | 7 | ⏳ | ✅ |
| Four Columns With Titles | 13 | 12 | ⏳ | ✅ |
| Four Columns | 14 | 8 | ⏳ | ✅ |
| Agenda, 6 Textboxes | 15 | 16 | ⏳ | ✅ |
| Title and 6-item Lists | 16 | 22 | ⏳ | ✅ |
| Big Number | 17 | 5 | ⏳ | ✅ |
| SWOT Analysis | 18 | 7 | ⏳ | ✅ |

## Detailed Layout Specifications

### Title Slide (Index: 0)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Subtitle 2"\n- `idx=10`: "Date Placeholder 3"\n- `idx=11`: "Footer Placeholder 4"\n- `idx=12`: "Slide Number Placeholder 5"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and Content (Index: 1)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Content Placeholder 2"\n- `idx=10`: "Date Placeholder 3"\n- `idx=11`: "Footer Placeholder 4"\n- `idx=12`: "Slide Number Placeholder 5"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Section Header (Index: 2)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Text Placeholder 2"\n- `idx=10`: "Date Placeholder 3"\n- `idx=11`: "Footer Placeholder 4"\n- `idx=12`: "Slide Number Placeholder 5"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Two Content (Index: 3)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Content Placeholder 2"\n- `idx=2`: "Content Placeholder 3"\n- `idx=10`: "Date Placeholder 4"\n- `idx=11`: "Footer Placeholder 5"\n- `idx=12`: "Slide Number Placeholder 6"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Comparison (Index: 4)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Text Placeholder 2"\n- `idx=2`: "Content Placeholder 3"\n- `idx=3`: "Text Placeholder 4"\n- `idx=4`: "Content Placeholder 5"\n- `idx=10`: "Date Placeholder 6"\n- `idx=11`: "Footer Placeholder 7"\n- `idx=12`: "Slide Number Placeholder 8"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title Only (Index: 5)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=10`: "Date Placeholder 2"\n- `idx=11`: "Footer Placeholder 3"\n- `idx=12`: "Slide Number Placeholder 4"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Blank (Index: 6)\n\n**PowerPoint Placeholders**:\n- `idx=10`: "Date Placeholder 1"\n- `idx=11`: "Footer Placeholder 2"\n- `idx=12`: "Slide Number Placeholder 3"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Content with Caption (Index: 7)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Content Placeholder 2"\n- `idx=2`: "Text Placeholder 3"\n- `idx=10`: "Date Placeholder 4"\n- `idx=11`: "Footer Placeholder 5"\n- `idx=12`: "Slide Number Placeholder 6"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Picture with Caption (Index: 8)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Picture Placeholder 2"\n- `idx=2`: "Text Placeholder 3"\n- `idx=10`: "Date Placeholder 4"\n- `idx=11`: "Footer Placeholder 5"\n- `idx=12`: "Slide Number Placeholder 6"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and Vertical Text (Index: 9)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Vertical Text Placeholder 2"\n- `idx=10`: "Date Placeholder 3"\n- `idx=11`: "Footer Placeholder 4"\n- `idx=12`: "Slide Number Placeholder 5"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Vertical Title and Text (Index: 10)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Vertical Title 1"\n- `idx=1`: "Vertical Text Placeholder 2"\n- `idx=10`: "Date Placeholder 3"\n- `idx=11`: "Footer Placeholder 4"\n- `idx=12`: "Slide Number Placeholder 5"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Three Columns With Titles (Index: 11)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=13`: "Col 1 Title Placeholder 2"\n- `idx=14`: "Col 1 Text Placeholder 3"\n- `idx=15`: "Col 2 Title Placeholder 4"\n- `idx=16`: "Col 2 Text Placeholder 5"\n- `idx=17`: "Col 3 Title Placeholder 6"\n- `idx=18`: "Col 3 Text Placeholder 7"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Three Columns (Index: 12)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=14`: "Col 1 Text Placeholder 2"\n- `idx=16`: "Col 2 Text Placeholder 3"\n- `idx=18`: "Col 3 Text Placeholder 4"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Four Columns With Titles (Index: 13)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=13`: "Col 1 Title Placeholder 2"\n- `idx=14`: "Col 1 Text Placeholder 3"\n- `idx=15`: "Col 2 Title Placeholder 4"\n- `idx=16`: "Col 2 Text Placeholder 5"\n- `idx=17`: "Col 3 Title Placeholder 6"\n- `idx=18`: "Col 3 Text Placeholder 7"\n- `idx=19`: "Col 4 Title Placeholder 8"\n- `idx=20`: "Col 4 Text Placeholder 9"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Four Columns (Index: 14)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=14`: "Col 1 Text Placeholder 3"\n- `idx=16`: "Col 2 Text Placeholder 2"\n- `idx=18`: "Col 3 Text Placeholder 4"\n- `idx=20`: "Col 4 Text Placeholder 4"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Agenda, 6 Textboxes (Index: 15)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=28`: "Text Placeholder Number 01"\n- `idx=18`: "Text Placeholder Content 1"\n- `idx=29`: "Text Placeholder Number 02"\n- `idx=20`: "Text Placeholder Content 2"\n- `idx=30`: "Text Placeholder Number 03"\n- `idx=22`: "Text Placeholder Content 3"\n- `idx=31`: "Text Placeholder Number 04"\n- `idx=19`: "Text Placeholder Content 4"\n- `idx=32`: "Text Placeholder Number 05"\n- `idx=21`: "Text Placeholder Content 5"\n- `idx=33`: "Text Placeholder Number 06"\n- `idx=34`: "Text Placeholder Content 6"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and 6-item Lists (Index: 16)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=25`: "Text Placeholder Number 01"\n- `idx=13`: "Text Placeholder Title 1"\n- `idx=14`: "Text Placeholder Content 1"\n- `idx=26`: "Text Placeholder Number 02"\n- `idx=18`: "Text Placeholder Title 2"\n- `idx=17`: "Text Placeholder Content 2"\n- `idx=27`: "Text Placeholder Number 03"\n- `idx=22`: "Text Placeholder Title 3"\n- `idx=21`: "Text Placeholder Content 3"\n- `idx=30`: "Text Placeholder Number 04"\n- `idx=24`: "Text Placeholder Title 4"\n- `idx=23`: "Text Placeholder Content 4"\n- `idx=29`: "Text Placeholder Number 05"\n- `idx=20`: "Text Placeholder Title 5"\n- `idx=19`: "Text Placeholder Content 5"\n- `idx=28`: "Text Placeholder Number 06"\n- `idx=16`: "Text Placeholder Title 6"\n- `idx=15`: "Text Placeholder 10"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Big Number (Index: 17)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "Title 1"\n- `idx=1`: "Subtitle 2"\n- `idx=10`: "Date Placeholder 10"\n- `idx=11`: "Footer Placeholder 11"\n- `idx=12`: "Slide Number Placeholder 12"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### SWOT Analysis (Index: 18)\n\n**PowerPoint Placeholders**:\n- `idx=10`: "Date Placeholder 1"\n- `idx=11`: "Footer Placeholder 2"\n- `idx=12`: "Slide Number Placeholder 3"\n- `idx=16`: "Text Placeholder Bottom Right"\n- `idx=17`: "Text Placeholder Top Right"\n- `idx=18`: "Text Placeholder Bottom Left"\n- `idx=19`: "Text Placeholder Top Left"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n

## Template Management

### Adding JSON Mapping
1. **Analyze template**: Run `python -m deckbuilder.cli_tools analyze default`
2. **Edit generated file**: Customize `default.g.json` with semantic names
3. **Activate mapping**: Rename to `default.json` in templates folder

### Example JSON Mapping Structure
```json
{
  "template_info": {
    "name": "Default",
    "version": "1.0"
  },
  "layouts": {
    "Title Slide": {
      "index": 0,
      "placeholders": {
        "0": "Title 1",
        "1": "Subtitle 2"
      }
    }
  },
  "aliases": {
    "title": "Title Slide",
    "content": "Title and Content"
  }
}
```

### Usage Examples

**JSON Format**:
```json
{
  "presentation": {
    "slides": [
      {
        "type": "Title Slide",
        "layout": "Title Slide",
        "title": "My Presentation",
        "subtitle": "Subtitle text"
      }
    ]
  }
}
```

**Markdown with Frontmatter**:
```yaml
---
layout: Title Slide
---
# My Presentation
## Subtitle text
```

---
*Generated automatically by Deckbuilder Template Manager on 2025-06-23 13:26:00*
