# 
# Generated by the nebius.base.protos.compiler.  DO NOT EDIT!
# 

import builtins as builtins
import collections.abc as abc
import datetime as datetime
import google.protobuf.descriptor as descriptor_1
import google.protobuf.duration_pb2 as duration_pb2
import google.protobuf.message as message
import grpc as grpc
import nebius.aio.client as client
import nebius.aio.request as request
import nebius.api.nebius.logging.v1.agentmanager.version_service_pb2 as version_service_pb2
import nebius.base.protos.descriptor as descriptor
import nebius.base.protos.pb_classes as pb_classes
import nebius.base.protos.pb_enum as pb_enum
import nebius.base.protos.unset as unset
import nebius.base.protos.well_known as well_known
import typing as typing
#@ local imports here @#

# file: nebius/logging/v1/agentmanager/version_service.proto
class AgentType(pb_enum.Enum):
    """
    Type of the agent in the system.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.logging.agentmanager.v1.AgentType",version_service_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    AGENT_UNDEFINED = 0
    """
    Default undefined state.
    """
    
    O11Y_AGENT = 1
    """
    Observability agent type.
    """
    

class AgentState(pb_enum.Enum):
    """
    Current operational state of the agent.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.logging.agentmanager.v1.AgentState",version_service_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    STATE_UNDEFINED = 0
    """
    Default undefined state.
    """
    
    STATE_HEALTHY = 1
    """
    Agent is functioning normally.
    """
    
    STATE_ERROR = 2
    """
    Agent is in error state.
    """
    

class Action(pb_enum.Enum):
    """
    Action to be taken by the agent based on version check.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.EnumDescriptor](".nebius.logging.agentmanager.v1.Action",version_service_pb2.DESCRIPTOR,descriptor_1.EnumDescriptor)
    ACTION_UNDEFINED = 0
    """
    Default undefined action.
    """
    
    NOP = 1
    """
    No operation needed.
    """
    
    UPDATE = 2
    """
    Update to new version required.
    """
    
    RESTART = 3
    """
    Agent restart required.
    """
    

class GetVersionRequest(pb_classes.Message):
    """
    Request message for GetVersion RPC containing agent status and system information.
    """
    
    __PB2_CLASS__ = version_service_pb2.GetVersionRequest
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.GetVersionRequest",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
        "agent_uptime": well_known.duration_mask,
        "system_uptime": well_known.duration_mask,
        "updater_uptime": well_known.duration_mask,
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        type: "AgentType|version_service_pb2.AgentType|None|unset.UnsetType" = unset.Unset,
        agent_version: "builtins.str|None|unset.UnsetType" = unset.Unset,
        updater_version: "builtins.str|None|unset.UnsetType" = unset.Unset,
        parent_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        instance_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        os_info: "OSInfo|version_service_pb2.OSInfo|None|unset.UnsetType" = unset.Unset,
        agent_state: "AgentState|version_service_pb2.AgentState|None|unset.UnsetType" = unset.Unset,
        agent_uptime: "duration_pb2.Duration|datetime.timedelta|None|unset.UnsetType" = unset.Unset,
        system_uptime: "duration_pb2.Duration|datetime.timedelta|None|unset.UnsetType" = unset.Unset,
        updater_uptime: "duration_pb2.Duration|datetime.timedelta|None|unset.UnsetType" = unset.Unset,
        agent_state_messages: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        last_update_error: "builtins.str|None|unset.UnsetType" = unset.Unset,
        mk8s_cluster_id: "builtins.str|None|unset.UnsetType" = unset.Unset,
        modules_health: "ModulesHealth|version_service_pb2.ModulesHealth|None|unset.UnsetType" = unset.Unset,
        cloud_init_status: "builtins.str|None|unset.UnsetType" = unset.Unset,
        instance_id_used_fallback: "builtins.bool|None|unset.UnsetType" = unset.Unset,
        last_agent_logs: "builtins.str|None|unset.UnsetType" = unset.Unset,
        gpu_model: "builtins.str|None|unset.UnsetType" = unset.Unset,
        gpu_number: "builtins.int|None|unset.UnsetType" = unset.Unset,
        dcgm_version: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(type, unset.UnsetType):
            self.type = type
        if not isinstance(agent_version, unset.UnsetType):
            self.agent_version = agent_version
        if not isinstance(updater_version, unset.UnsetType):
            self.updater_version = updater_version
        if not isinstance(parent_id, unset.UnsetType):
            self.parent_id = parent_id
        if not isinstance(instance_id, unset.UnsetType):
            self.instance_id = instance_id
        if not isinstance(os_info, unset.UnsetType):
            self.os_info = os_info
        if not isinstance(agent_state, unset.UnsetType):
            self.agent_state = agent_state
        if not isinstance(agent_uptime, unset.UnsetType):
            self.agent_uptime = agent_uptime
        if not isinstance(system_uptime, unset.UnsetType):
            self.system_uptime = system_uptime
        if not isinstance(updater_uptime, unset.UnsetType):
            self.updater_uptime = updater_uptime
        if not isinstance(agent_state_messages, unset.UnsetType):
            self.agent_state_messages = agent_state_messages
        if not isinstance(last_update_error, unset.UnsetType):
            self.last_update_error = last_update_error
        if not isinstance(mk8s_cluster_id, unset.UnsetType):
            self.mk8s_cluster_id = mk8s_cluster_id
        if not isinstance(modules_health, unset.UnsetType):
            self.modules_health = modules_health
        if not isinstance(cloud_init_status, unset.UnsetType):
            self.cloud_init_status = cloud_init_status
        if not isinstance(instance_id_used_fallback, unset.UnsetType):
            self.instance_id_used_fallback = instance_id_used_fallback
        if not isinstance(last_agent_logs, unset.UnsetType):
            self.last_agent_logs = last_agent_logs
        if not isinstance(gpu_model, unset.UnsetType):
            self.gpu_model = gpu_model
        if not isinstance(gpu_number, unset.UnsetType):
            self.gpu_number = gpu_number
        if not isinstance(dcgm_version, unset.UnsetType):
            self.dcgm_version = dcgm_version
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "type",
            "agent_version",
            "updater_version",
            "parent_id",
            "instance_id",
            "os_info",
            "agent_state",
            "agent_uptime",
            "system_uptime",
            "updater_uptime",
            "agent_state_messages",
            "last_update_error",
            "mk8s_cluster_id",
            "modules_health",
            "cloud_init_status",
            "instance_id_used_fallback",
            "last_agent_logs",
            "gpu_model",
            "gpu_number",
            "dcgm_version",
        ]
    
    @builtins.property
    def type(self) -> "AgentType":
        """
        Type of the agent. Must be O11Y_AGENT (1).
        """
        
        return super()._get_field("type", explicit_presence=False,
        wrap=AgentType,
        )
    @type.setter
    def type(self, value: "AgentType|version_service_pb2.AgentType|None") -> None:
        return super()._set_field("type",value,explicit_presence=False,
        )
    
    @builtins.property
    def agent_version(self) -> "builtins.str":
        """
        Current version of the agent software.
        """
        
        return super()._get_field("agent_version", explicit_presence=False,
        )
    @agent_version.setter
    def agent_version(self, value: "builtins.str|None") -> None:
        return super()._set_field("agent_version",value,explicit_presence=False,
        )
    
    @builtins.property
    def updater_version(self) -> "builtins.str":
        """
        Version of the updater component.
        """
        
        return super()._get_field("updater_version", explicit_presence=False,
        )
    @updater_version.setter
    def updater_version(self, value: "builtins.str|None") -> None:
        return super()._set_field("updater_version",value,explicit_presence=False,
        )
    
    @builtins.property
    def parent_id(self) -> "builtins.str":
        """
        Parent identifier for the VM
        """
        
        return super()._get_field("parent_id", explicit_presence=False,
        )
    @parent_id.setter
    def parent_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("parent_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def instance_id(self) -> "builtins.str":
        """
        Unique identifier for the instance where agent is running.
        """
        
        return super()._get_field("instance_id", explicit_presence=False,
        )
    @instance_id.setter
    def instance_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("instance_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def os_info(self) -> "OSInfo":
        """
        Detailed information about the operating system.
        """
        
        return super()._get_field("os_info", explicit_presence=False,
        wrap=OSInfo,
        )
    @os_info.setter
    def os_info(self, value: "OSInfo|version_service_pb2.OSInfo|None") -> None:
        return super()._set_field("os_info",value,explicit_presence=False,
        )
    
    @builtins.property
    def agent_state(self) -> "AgentState":
        """
        Current operational state of the agent.
        """
        
        return super()._get_field("agent_state", explicit_presence=False,
        wrap=AgentState,
        )
    @agent_state.setter
    def agent_state(self, value: "AgentState|version_service_pb2.AgentState|None") -> None:
        return super()._set_field("agent_state",value,explicit_presence=False,
        )
    
    @builtins.property
    def agent_uptime(self) -> "datetime.timedelta":
        """
        Time duration since the agent started.
        """
        
        return super()._get_field("agent_uptime", explicit_presence=False,
        wrap=well_known.from_duration
        )
    @agent_uptime.setter
    def agent_uptime(self, value: "duration_pb2.Duration|datetime.timedelta|None") -> None:
        return super()._set_field("agent_uptime",value,explicit_presence=False,
        unwrap=well_known.to_duration
        )
    
    @builtins.property
    def system_uptime(self) -> "datetime.timedelta":
        """
        Total system uptime.
        """
        
        return super()._get_field("system_uptime", explicit_presence=False,
        wrap=well_known.from_duration
        )
    @system_uptime.setter
    def system_uptime(self, value: "duration_pb2.Duration|datetime.timedelta|None") -> None:
        return super()._set_field("system_uptime",value,explicit_presence=False,
        unwrap=well_known.to_duration
        )
    
    @builtins.property
    def updater_uptime(self) -> "datetime.timedelta":
        """
        Time duration since the updater component started.
        """
        
        return super()._get_field("updater_uptime", explicit_presence=False,
        wrap=well_known.from_duration
        )
    @updater_uptime.setter
    def updater_uptime(self, value: "duration_pb2.Duration|datetime.timedelta|None") -> None:
        return super()._set_field("updater_uptime",value,explicit_presence=False,
        unwrap=well_known.to_duration
        )
    
    @builtins.property
    def agent_state_messages(self) -> "abc.MutableSequence[builtins.str]":
        """
        Status messages from the agent describing its current state.
        """
        
        return super()._get_field("agent_state_messages", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @agent_state_messages.setter
    def agent_state_messages(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("agent_state_messages",value,explicit_presence=False,
        )
    
    @builtins.property
    def last_update_error(self) -> "builtins.str":
        """
        Description of the last update failure, if any.
        """
        
        return super()._get_field("last_update_error", explicit_presence=False,
        )
    @last_update_error.setter
    def last_update_error(self, value: "builtins.str|None") -> None:
        return super()._set_field("last_update_error",value,explicit_presence=False,
        )
    
    @builtins.property
    def mk8s_cluster_id(self) -> "builtins.str":
        """
        Managed Kubernetes cluster identifier, if applicable.
        """
        
        return super()._get_field("mk8s_cluster_id", explicit_presence=False,
        )
    @mk8s_cluster_id.setter
    def mk8s_cluster_id(self, value: "builtins.str|None") -> None:
        return super()._set_field("mk8s_cluster_id",value,explicit_presence=False,
        )
    
    @builtins.property
    def modules_health(self) -> "ModulesHealth|None":
        """
        Health status of individual agent modules.
        """
        
        return super()._get_field("modules_health", explicit_presence=True,
        wrap=ModulesHealth,
        )
    @modules_health.setter
    def modules_health(self, value: "ModulesHealth|version_service_pb2.ModulesHealth|None") -> None:
        return super()._set_field("modules_health",value,explicit_presence=True,
        )
    
    @builtins.property
    def cloud_init_status(self) -> "builtins.str":
        """
        Status of cloud initialization process.
        """
        
        return super()._get_field("cloud_init_status", explicit_presence=False,
        )
    @cloud_init_status.setter
    def cloud_init_status(self, value: "builtins.str|None") -> None:
        return super()._set_field("cloud_init_status",value,explicit_presence=False,
        )
    
    @builtins.property
    def instance_id_used_fallback(self) -> "builtins.bool":
        """
        Indicates if a fallback method was used to determine instance_id.
        """
        
        return super()._get_field("instance_id_used_fallback", explicit_presence=False,
        )
    @instance_id_used_fallback.setter
    def instance_id_used_fallback(self, value: "builtins.bool|None") -> None:
        return super()._set_field("instance_id_used_fallback",value,explicit_presence=False,
        )
    
    @builtins.property
    def last_agent_logs(self) -> "builtins.str":
        """
        Recent agent log entries for diagnostic purposes.
        """
        
        return super()._get_field("last_agent_logs", explicit_presence=False,
        )
    @last_agent_logs.setter
    def last_agent_logs(self, value: "builtins.str|None") -> None:
        return super()._set_field("last_agent_logs",value,explicit_presence=False,
        )
    
    @builtins.property
    def gpu_model(self) -> "builtins.str":
        """
        Model of the GPU used in the system.
        """
        
        return super()._get_field("gpu_model", explicit_presence=False,
        )
    @gpu_model.setter
    def gpu_model(self, value: "builtins.str|None") -> None:
        return super()._set_field("gpu_model",value,explicit_presence=False,
        )
    
    @builtins.property
    def gpu_number(self) -> "builtins.int":
        """
        Number of GPUs available in the system.
        """
        
        return super()._get_field("gpu_number", explicit_presence=False,
        )
    @gpu_number.setter
    def gpu_number(self, value: "builtins.int|None") -> None:
        return super()._set_field("gpu_number",value,explicit_presence=False,
        )
    
    @builtins.property
    def dcgm_version(self) -> "builtins.str":
        """
        Version of the DCGM (Data Center GPU Manager) used.
        """
        
        return super()._get_field("dcgm_version", explicit_presence=False,
        )
    @dcgm_version.setter
    def dcgm_version(self, value: "builtins.str|None") -> None:
        return super()._set_field("dcgm_version",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "type":"type",
        "agent_version":"agent_version",
        "updater_version":"updater_version",
        "parent_id":"parent_id",
        "instance_id":"instance_id",
        "os_info":"os_info",
        "agent_state":"agent_state",
        "agent_uptime":"agent_uptime",
        "system_uptime":"system_uptime",
        "updater_uptime":"updater_uptime",
        "agent_state_messages":"agent_state_messages",
        "last_update_error":"last_update_error",
        "mk8s_cluster_id":"mk8s_cluster_id",
        "modules_health":"modules_health",
        "cloud_init_status":"cloud_init_status",
        "instance_id_used_fallback":"instance_id_used_fallback",
        "last_agent_logs":"last_agent_logs",
        "gpu_model":"gpu_model",
        "gpu_number":"gpu_number",
        "dcgm_version":"dcgm_version",
    }
    
class ModulesHealth(pb_classes.Message):
    """
    Health status information for all agent modules.
    """
    
    __PB2_CLASS__ = version_service_pb2.ModulesHealth
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.ModulesHealth",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        process: "ModuleHealth|version_service_pb2.ModuleHealth|None|unset.UnsetType" = unset.Unset,
        gpu_pipeline: "ModuleHealth|version_service_pb2.ModuleHealth|None|unset.UnsetType" = unset.Unset,
        cpu_pipeline: "ModuleHealth|version_service_pb2.ModuleHealth|None|unset.UnsetType" = unset.Unset,
        cilium_pipeline: "ModuleHealth|version_service_pb2.ModuleHealth|None|unset.UnsetType" = unset.Unset,
        vmapps_pipeline: "ModulesHealth|version_service_pb2.ModulesHealth|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(process, unset.UnsetType):
            self.process = process
        if not isinstance(gpu_pipeline, unset.UnsetType):
            self.gpu_pipeline = gpu_pipeline
        if not isinstance(cpu_pipeline, unset.UnsetType):
            self.cpu_pipeline = cpu_pipeline
        if not isinstance(cilium_pipeline, unset.UnsetType):
            self.cilium_pipeline = cilium_pipeline
        if not isinstance(vmapps_pipeline, unset.UnsetType):
            self.vmapps_pipeline = vmapps_pipeline
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "process",
            "gpu_pipeline",
            "cpu_pipeline",
            "cilium_pipeline",
            "vmapps_pipeline",
        ]
    
    @builtins.property
    def process(self) -> "ModuleHealth":
        """
        Health status of the process module.
        """
        
        return super()._get_field("process", explicit_presence=False,
        wrap=ModuleHealth,
        )
    @process.setter
    def process(self, value: "ModuleHealth|version_service_pb2.ModuleHealth|None") -> None:
        return super()._set_field("process",value,explicit_presence=False,
        )
    
    @builtins.property
    def gpu_pipeline(self) -> "ModuleHealth":
        """
        Health status of the GPU pipeline module.
        """
        
        return super()._get_field("gpu_pipeline", explicit_presence=False,
        wrap=ModuleHealth,
        )
    @gpu_pipeline.setter
    def gpu_pipeline(self, value: "ModuleHealth|version_service_pb2.ModuleHealth|None") -> None:
        return super()._set_field("gpu_pipeline",value,explicit_presence=False,
        )
    
    @builtins.property
    def cpu_pipeline(self) -> "ModuleHealth":
        """
        Health status of the CPU pipeline module.
        """
        
        return super()._get_field("cpu_pipeline", explicit_presence=False,
        wrap=ModuleHealth,
        )
    @cpu_pipeline.setter
    def cpu_pipeline(self, value: "ModuleHealth|version_service_pb2.ModuleHealth|None") -> None:
        return super()._set_field("cpu_pipeline",value,explicit_presence=False,
        )
    
    @builtins.property
    def cilium_pipeline(self) -> "ModuleHealth":
        """
        Health status of the Cilium pipeline module.
        """
        
        return super()._get_field("cilium_pipeline", explicit_presence=False,
        wrap=ModuleHealth,
        )
    @cilium_pipeline.setter
    def cilium_pipeline(self, value: "ModuleHealth|version_service_pb2.ModuleHealth|None") -> None:
        return super()._set_field("cilium_pipeline",value,explicit_presence=False,
        )
    
    @builtins.property
    def vmapps_pipeline(self) -> "ModulesHealth|None":
        """
        Health status of the VM applications pipeline module.
        """
        
        return super()._get_field("vmapps_pipeline", explicit_presence=True,
        wrap=ModulesHealth,
        )
    @vmapps_pipeline.setter
    def vmapps_pipeline(self, value: "ModulesHealth|version_service_pb2.ModulesHealth|None") -> None:
        return super()._set_field("vmapps_pipeline",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "process":"process",
        "gpu_pipeline":"gpu_pipeline",
        "cpu_pipeline":"cpu_pipeline",
        "cilium_pipeline":"cilium_pipeline",
        "vmapps_pipeline":"vmapps_pipeline",
    }
    
class ModuleHealth(pb_classes.Message):
    """
    Health status information for an individual module.
    """
    
    __PB2_CLASS__ = version_service_pb2.ModuleHealth
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.ModuleHealth",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        state: "AgentState|version_service_pb2.AgentState|None|unset.UnsetType" = unset.Unset,
        messages: "abc.Iterable[builtins.str]|None|unset.UnsetType" = unset.Unset,
        parameters: "abc.Iterable[Parameter]|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(state, unset.UnsetType):
            self.state = state
        if not isinstance(messages, unset.UnsetType):
            self.messages = messages
        if not isinstance(parameters, unset.UnsetType):
            self.parameters = parameters
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "state",
            "messages",
            "parameters",
        ]
    
    @builtins.property
    def state(self) -> "AgentState":
        """
        Current operational state of the module.
        """
        
        return super()._get_field("state", explicit_presence=False,
        wrap=AgentState,
        )
    @state.setter
    def state(self, value: "AgentState|version_service_pb2.AgentState|None") -> None:
        return super()._set_field("state",value,explicit_presence=False,
        )
    
    @builtins.property
    def messages(self) -> "abc.MutableSequence[builtins.str]":
        """
        Status messages describing the module's state.
        """
        
        return super()._get_field("messages", explicit_presence=False,
        wrap=pb_classes.Repeated,
        )
    @messages.setter
    def messages(self, value: "abc.Iterable[builtins.str]|None") -> None:
        return super()._set_field("messages",value,explicit_presence=False,
        )
    
    @builtins.property
    def parameters(self) -> "abc.MutableSequence[Parameter]":
        """
        Current parameters of the module.
        """
        
        return super()._get_field("parameters", explicit_presence=False,
        wrap=pb_classes.Repeated.with_wrap(Parameter,None,None),
        )
    @parameters.setter
    def parameters(self, value: "abc.Iterable[Parameter]|None") -> None:
        return super()._set_field("parameters",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "state":"state",
        "messages":"messages",
        "parameters":"parameters",
    }
    
class Parameter(pb_classes.Message):
    """
    Key-value parameter for module configuration.
    """
    
    __PB2_CLASS__ = version_service_pb2.Parameter
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.Parameter",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
        value: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(name, unset.UnsetType):
            self.name = name
        if not isinstance(value, unset.UnsetType):
            self.value = value
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "name",
            "value",
        ]
    
    @builtins.property
    def name(self) -> "builtins.str":
        """
        Name of the parameter.
        """
        
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    @builtins.property
    def value(self) -> "builtins.str":
        """
        Value of the parameter.
        """
        
        return super()._get_field("value", explicit_presence=False,
        )
    @value.setter
    def value(self, value: "builtins.str|None") -> None:
        return super()._set_field("value",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "name":"name",
        "value":"value",
    }
    
class OSInfo(pb_classes.Message):
    """
    Operating system information for the instance.
    """
    
    __PB2_CLASS__ = version_service_pb2.OSInfo
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.OSInfo",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        name: "builtins.str|None|unset.UnsetType" = unset.Unset,
        uname: "builtins.str|None|unset.UnsetType" = unset.Unset,
        architecture: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(name, unset.UnsetType):
            self.name = name
        if not isinstance(uname, unset.UnsetType):
            self.uname = uname
        if not isinstance(architecture, unset.UnsetType):
            self.architecture = architecture
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "name",
            "uname",
            "architecture",
        ]
    
    @builtins.property
    def name(self) -> "builtins.str":
        """
        Operating system name and version.
        Example: "Ubuntu 22.04.4 LTS"
        """
        
        return super()._get_field("name", explicit_presence=False,
        )
    @name.setter
    def name(self, value: "builtins.str|None") -> None:
        return super()._set_field("name",value,explicit_presence=False,
        )
    
    @builtins.property
    def uname(self) -> "builtins.str":
        """
        Detailed system information from uname command.
        Example: "Linux computeimage-abcdef 6.5.0-44-generic #44~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Tue Jun 18 14:36:16 UTC 2 x86_64 x86_64 x86_64 GNU/Linux"
        """
        
        return super()._get_field("uname", explicit_presence=False,
        )
    @uname.setter
    def uname(self, value: "builtins.str|None") -> None:
        return super()._set_field("uname",value,explicit_presence=False,
        )
    
    @builtins.property
    def architecture(self) -> "builtins.str":
        """
        System architecture.
        """
        
        return super()._get_field("architecture", explicit_presence=False,
        )
    @architecture.setter
    def architecture(self, value: "builtins.str|None") -> None:
        return super()._set_field("architecture",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "name":"name",
        "uname":"uname",
        "architecture":"architecture",
    }
    
class GetVersionResponse(pb_classes.Message):
    """
    Response message for GetVersion RPC containing required action for the agent.
    """
    
    __PB2_CLASS__ = version_service_pb2.GetVersionResponse
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.GetVersionResponse",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    class __OneOfClass_response__(pb_classes.OneOf):
        name: builtins.str= "response"
        
        def __init__(self, msg: "GetVersionResponse") -> None:
            super().__init__()
            self._message: "GetVersionResponse" = msg
    
    class __OneOfClass_response_nop__(__OneOfClass_response__):
        field: typing.Literal["nop"] = "nop"
        
        def __init__(self, msg: "GetVersionResponse") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "NopActionParams":
            return self._message.nop
    
    class __OneOfClass_response_update__(__OneOfClass_response__):
        field: typing.Literal["update"] = "update"
        
        def __init__(self, msg: "GetVersionResponse") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "UpdateActionParams":
            return self._message.update
    
    class __OneOfClass_response_restart__(__OneOfClass_response__):
        field: typing.Literal["restart"] = "restart"
        
        def __init__(self, msg: "GetVersionResponse") -> None:
            super().__init__(msg)
        @builtins.property
        def value(self) -> "RestartActionParams":
            return self._message.restart
    
    @builtins.property
    def response(self) -> __OneOfClass_response_nop__|__OneOfClass_response_update__|__OneOfClass_response_restart__|None:
        """
        Parameters specific to the required action.
        """
        
        field_name: str|None = super().which_field_in_oneof("response")
        match field_name:
            case "nop":
                return self.__OneOfClass_response_nop__(self)
            case "update":
                return self.__OneOfClass_response_update__(self)
            case "restart":
                return self.__OneOfClass_response_restart__(self)
            case None:
                return None
            case _:
                raise pb_classes.OneOfMatchError(field_name)
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        action: "Action|version_service_pb2.Action|None|unset.UnsetType" = unset.Unset,
        nop: "NopActionParams|version_service_pb2.NopActionParams|None|unset.UnsetType" = unset.Unset,
        update: "UpdateActionParams|version_service_pb2.UpdateActionParams|None|unset.UnsetType" = unset.Unset,
        restart: "RestartActionParams|version_service_pb2.RestartActionParams|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(action, unset.UnsetType):
            self.action = action
        if not isinstance(nop, unset.UnsetType):
            self.nop = nop
        if not isinstance(update, unset.UnsetType):
            self.update = update
        if not isinstance(restart, unset.UnsetType):
            self.restart = restart
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "action",
            "nop",
            "update",
            "restart",
            "response",
        ]
    
    @builtins.property
    def action(self) -> "Action":
        """
        Required action for the agent to take.
        """
        
        return super()._get_field("action", explicit_presence=False,
        wrap=Action,
        )
    @action.setter
    def action(self, value: "Action|version_service_pb2.Action|None") -> None:
        return super()._set_field("action",value,explicit_presence=False,
        )
    
    @builtins.property
    def nop(self) -> "NopActionParams|None":
        """
        Parameters for no-operation action.
        """
        
        return super()._get_field("nop", explicit_presence=True,
        wrap=NopActionParams,
        )
    @nop.setter
    def nop(self, value: "NopActionParams|version_service_pb2.NopActionParams|None") -> None:
        return super()._set_field("nop",value,explicit_presence=True,
        )
    
    @builtins.property
    def update(self) -> "UpdateActionParams|None":
        """
        Parameters for update action.
        """
        
        return super()._get_field("update", explicit_presence=True,
        wrap=UpdateActionParams,
        )
    @update.setter
    def update(self, value: "UpdateActionParams|version_service_pb2.UpdateActionParams|None") -> None:
        return super()._set_field("update",value,explicit_presence=True,
        )
    
    @builtins.property
    def restart(self) -> "RestartActionParams|None":
        """
        Parameters for restart action.
        """
        
        return super()._get_field("restart", explicit_presence=True,
        wrap=RestartActionParams,
        )
    @restart.setter
    def restart(self, value: "RestartActionParams|version_service_pb2.RestartActionParams|None") -> None:
        return super()._set_field("restart",value,explicit_presence=True,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "action":"action",
        "nop":"nop",
        "update":"update",
        "restart":"restart",
        "response":"response",
    }
    
class NopActionParams(pb_classes.Message):
    """
    Parameters when no operation is required.
    """
    
    __PB2_CLASS__ = version_service_pb2.NopActionParams
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.NopActionParams",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
    ) -> None:
        super().__init__(initial_message)
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
        ]
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
    }
    
class UpdateActionParams(pb_classes.Message):
    """
    Parameters for agent update action.
    """
    
    __PB2_CLASS__ = version_service_pb2.UpdateActionParams
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.UpdateActionParams",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
        *,
        version: "builtins.str|None|unset.UnsetType" = unset.Unset,
        repo_url: "builtins.str|None|unset.UnsetType" = unset.Unset,
    ) -> None:
        super().__init__(initial_message)
        if not isinstance(version, unset.UnsetType):
            self.version = version
        if not isinstance(repo_url, unset.UnsetType):
            self.repo_url = repo_url
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
            "version",
            "repo_url",
        ]
    
    @builtins.property
    def version(self) -> "builtins.str":
        """
        Target version for the update.
        """
        
        return super()._get_field("version", explicit_presence=False,
        )
    @version.setter
    def version(self, value: "builtins.str|None") -> None:
        return super()._set_field("version",value,explicit_presence=False,
        )
    
    @builtins.property
    def repo_url(self) -> "builtins.str":
        """
        URL of the repository containing the update.
        """
        
        return super()._get_field("repo_url", explicit_presence=False,
        )
    @repo_url.setter
    def repo_url(self, value: "builtins.str|None") -> None:
        return super()._set_field("repo_url",value,explicit_presence=False,
        )
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
        "version":"version",
        "repo_url":"repo_url",
    }
    
class RestartActionParams(pb_classes.Message):
    """
    Parameters for agent restart action.
    """
    
    __PB2_CLASS__ = version_service_pb2.RestartActionParams
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.Descriptor](".nebius.logging.agentmanager.v1.RestartActionParams",version_service_pb2.DESCRIPTOR,descriptor_1.Descriptor)
    __mask_functions__ = {
    }
    
    def __init__(
        self,
        initial_message: message.Message|None = None,
    ) -> None:
        super().__init__(initial_message)
    
    def __dir__(self) ->abc.Iterable[builtins.str]:
        return [
        ]
    
    __PY_TO_PB2__: builtins.dict[builtins.str,builtins.str] = {
    }
    

class VersionServiceClient(client.Client):
    """
    VersionService provides functionality for managing nebius-observability-agent versions and health status
    in the Nebius observability system.
    """
    
    __PB2_DESCRIPTOR__ = descriptor.DescriptorWrap[descriptor_1.ServiceDescriptor](".nebius.logging.agentmanager.v1.VersionService",version_service_pb2.DESCRIPTOR,descriptor_1.ServiceDescriptor)
    __service_name__ = ".nebius.logging.agentmanager.v1.VersionService"
    
    def get_version(self,
        request: "GetVersionRequest",
        metadata: abc.Iterable[builtins.tuple[builtins.str,builtins.str]]|None = None,
        timeout: builtins.float|unset.UnsetType|None = unset.Unset,
        credentials: grpc.CallCredentials | None = None,
        compression: grpc.Compression | None = None,
        retries: builtins.int | None = 3,
        per_retry_timeout: builtins.float|unset.UnsetType|None = unset.Unset,
    ) -> request.Request["GetVersionRequest","GetVersionResponse"]:
        """
        GetVersion retrieves version information and receives instructions for agent updates
        or maintenance based on the current state and health of the agent.
        """
        
        return super().request(
            method="GetVersion",
            request=request,
            result_pb2_class=version_service_pb2.GetVersionResponse,
            metadata=metadata,
            timeout=timeout,
            credentials=credentials,
            compression=compression,
            retries=retries,
            per_retry_timeout=per_retry_timeout,
            result_wrapper=pb_classes.simple_wrapper(GetVersionResponse),
        )
    

__all__ = [
    #@ local import names here @#
    "AgentType",
    "AgentState",
    "Action",
    "GetVersionRequest",
    "ModulesHealth",
    "ModuleHealth",
    "Parameter",
    "OSInfo",
    "GetVersionResponse",
    "NopActionParams",
    "UpdateActionParams",
    "RestartActionParams",
    "VersionServiceClient",
]
