# MoAI-ADK GitFlow PR

> 🗿 Full GitFlow Transparency — the agent auto-fills information

## 📝 SPEC Info

- Related SPEC: `SPEC-AUTH-001` (e.g., JWT authentication system)
- Directory: `.moai/specs/SPEC-AUTH-001/`
- @TAG Links: @SPEC:AUTH-001 @CODE:AUTH-001 (auto-tagging)

## ✅ SPEC Quality Checks

- [ ] YAML Front Matter: 7 required fields (id, version, status, created, updated, author, priority)
- [ ] HISTORY Section: Record versioned change log (include v0.0.1 INITIAL)
- [ ] EARS Requirements: Ubiquitous, Event-driven, State-driven, Optional, Unwanted Behaviors
- [ ] @SPEC:ID TAG: Include TAG in doc and check duplicates (`rg "@SPEC:<ID>" -n`)

## 🤖 Automated Validation Status

<!-- The checklist below is auto-updated by the agent -->
<!-- /alfred:1-plan → create feature branch → Draft PR -->
<!-- /alfred:2-run → implement via TDD → auto-check checkboxes -->
<!-- /alfred:3-sync → synchronize documents → Ready for Review -->

- [ ] spec-builder: Complete EARS spec and create feature branch
- [ ] code-builder: Finish TDD RED-GREEN-REFACTOR
- [ ] doc-syncer: Sync Living Documents and mark PR Ready

## 📊 Quality Metrics (auto-calculated)

- TRUST 5 Principles: ✅ Compliant
- Test Coverage: XX% (target ≥ 85%)
- @TAG Traceability: 100%

## 🌍 Locale Settings

- Project Language: <!-- ko/en/ja/zh -->
- Commit Messages: <!-- generated automatically according to locale -->

## 🎯 Changes

<!-- code-builder auto-fills TDD results -->

### 🔴 RED (Test Authoring)
- Test File: `tests/auth/service.test.ts`
- Test Description: [describe the failing test]

### 🟢 GREEN (Implementation)
- Implementation File: `src/auth/service.ts`
- Implementation Done: [describe functionality]

### ♻️ REFACTOR (Improvements)
- Refactoring Details: [code quality improvements]

## 📚 Documentation Sync

<!-- auto-filled by doc-syncer -->

- [ ] Update README
- [ ] Sync API docs
- [ ] Update TAG index
- [ ] Update HISTORY section (SPEC docs)

---

🚀 MoAI-ADK: Professional development without Git commands via a 3-stage pipeline!

Reviewers: Check TRUST 5 compliance and SPEC metadata completeness only.

