# MD002 - First heading should be a top-level heading

## What this rule does

Ensures the first heading in your document is a level 1 heading (# Title).

## Why this matters

- **Document structure**: Every document needs a clear main title
- **Accessibility**: Screen readers expect documents to start with a main heading
- **Navigation**: Table of contents generators need a top-level heading
- **SEO**: Search engines look for a main H1 heading

## Examples

### ✅ Correct

```markdown
# Document Title

## Section 1

### Subsection 1.1

## Section 2
```

### ❌ Incorrect

```markdown
## Document Title     (starts with level 2)

### Section 1

# Main Heading       (H1 appears later)
```

### 🔧 Fixed

```markdown
# Document Title

## Section 1

### Subsection 1.1
```

## Configuration

```yaml
MD002:
  level: 1  # The level the first heading should be (default: 1)
```

## Automatic fixes

This rule automatically changes the first heading to the configured level (default: H1).

## Learn more

- [Web Content Accessibility Guidelines - Page Title](https://www.w3.org/WAI/WCAG21/Understanding/page-titled.html) - Why documents need titles
- [CommonMark headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical specification

## Related rules

- [MD001](md001.md) - Heading levels should only increment by one
- [MD003](md003.md) - Heading style should be consistent
- [MD025](md025.md) - Only one top-level heading allowed
