# MD011 - Fix reversed link syntax

## What this rule does

Detects and fixes links where the text and URL are accidentally swapped, converting them to proper Markdown format.

## Why this matters

- **Broken links**: Reversed syntax creates text that looks like a link but doesn't work
- **User frustration**: Readers click on non-functional links and get confused
- **SEO impact**: Search engines can't follow improperly formatted links
- **Professional appearance**: Correctly formatted links show attention to detail

## Examples

### ✅ Correct

```markdown
Check out [our documentation](https://docs.example.com)
Visit the [GitHub repository](https://github.com/example/repo)
Contact us at [support@example.com](mailto:support@example.com)
```

### ❌ Incorrect

<!-- rumdl-disable MD011 -->

```markdown
Check out (our documentation)[https://docs.example.com]
Visit the (GitHub repository)[https://github.com/example/repo]
Contact us at (support@example.com)[mailto:support@example.com]
```

<!-- rumdl-enable MD011 -->

### 🔧 Fixed

```markdown
Check out [our documentation](https://docs.example.com)
Visit the [GitHub repository](https://github.com/example/repo)
Contact us at [support@example.com](mailto:support@example.com)
```

## Configuration

```yaml
MD011: true  # This rule has no configuration options
```

## Automatic fixes

This rule automatically swaps the text and URL to create properly formatted links. It even handles complex cases like nested parentheses in link text correctly.

## Learn more

- [Links in Markdown](https://www.markdownguide.org/basic-syntax/#links) - How to create proper links
- [CommonMark specification](https://spec.commonmark.org/0.31.2/#links) - Technical details about link syntax

## Related rules

- [MD034](md034.md) - Format bare URLs properly
- [MD039](md039.md) - Remove spaces inside link text
- [MD042](md042.md) - Fix empty links
