# MD020 - No missing space in closed heading

## What this rule does

Ensures there's a space after the opening # and before the closing # in headings that use # symbols at both ends.

## Why this matters

- **Readability**: Spaces make the heading text easier to read
- **Compatibility**: Some Markdown processors require spaces for proper rendering
- **Consistency**: Maintains uniform heading formatting

## Examples

### ✅ Correct

```markdown
# Heading 1 #
## Heading 2 ##
### Heading 3 ###
#### Heading 4 ####
##### Heading 5 #####
###### Heading 6 ######
```

### ❌ Incorrect

<!-- rumdl-disable MD020 -->

```markdown
#Heading 1#
##Heading 2##
###Heading 3###
#Heading 4 ####    (missing space at start)
##### Heading 5#####  (missing space at end)
```

<!-- rumdl-enable MD020 -->

### 🔧 Fixed

```markdown
# Heading 1 #
## Heading 2 ##
### Heading 3 ###
#### Heading 4 ####
##### Heading 5 #####
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically adds spaces where they're missing:

- After the opening # symbols
- Before the closing # symbols

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical details about heading syntax
- [Closed headings](https://www.markdownguide.org/basic-syntax/#alternate-syntax) - Alternative heading syntax

## Related rules

- [MD018](md018.md) - No missing space after hash in heading
- [MD019](md019.md) - No multiple spaces after hash in heading
- [MD021](md021.md) - No multiple spaces in closed heading
- [MD003](md003.md) - Heading style should be consistent
