# MD021 - No multiple spaces in closed heading

## What this rule does

Ensures there's only one space after the opening # and before the closing # in headings that use # symbols at both ends.

## Why this matters

- **Consistency**: Extra spaces create uneven visual spacing
- **Cleanliness**: Single spacing looks professional
- **Standards**: Follows Markdown best practices for heading formatting

## Examples

### ✅ Correct

```markdown
# Heading 1 #
## Heading 2 ##
### Heading 3 ###
#### Heading 4 ####
##### Heading 5 #####
###### Heading 6 ######
```

### ❌ Incorrect

<!-- rumdl-disable MD021 -->

```markdown
#  Heading 1  #
##   Heading 2   ##
###    Heading 3    ###
####  Heading 4 ####      (extra spaces at start)
##### Heading 5  #####  (extra spaces at end)
```

<!-- rumdl-enable MD021 -->

### 🔧 Fixed

```markdown
# Heading 1 #
## Heading 2 ##
### Heading 3 ###
#### Heading 4 ####
##### Heading 5 #####
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically removes extra spaces:

- Leaves only one space after the opening # symbols
- Leaves only one space before the closing # symbols

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical details about heading syntax
- [Closed headings](https://www.markdownguide.org/basic-syntax/#alternate-syntax) - Alternative heading syntax

## Related rules

- [MD018](md018.md) - No missing space after hash in heading
- [MD019](md019.md) - No multiple spaces after hash in heading
- [MD020](md020.md) - No missing space in closed heading
- [MD003](md003.md) - Heading style should be consistent
