# MD030 - Add consistent spacing after list markers

## What this rule does

Ensures consistent spacing between list markers (bullets or numbers) and the text that follows them.

## Why this matters

- **Visual consistency**: Uniform spacing makes lists easier to scan
- **Proper rendering**: Some parsers require specific spacing to recognize lists
- **Professional appearance**: Consistent formatting looks more polished
- **Readability**: Proper spacing prevents list items from looking cramped

## Examples

### ✅ Correct

```markdown
* Unordered list item with one space
* Another item

1. Ordered list item with one space
2. Another item
```

### ❌ Incorrect

<!-- rumdl-disable MD030 -->

```markdown
*  Unordered list item with two spaces
*   Another item with three spaces

1.  Ordered list item with two spaces
2.   Another item with three spaces
```

<!-- rumdl-enable MD030 -->

### 🔧 Fixed

```markdown
* Unordered list item with one space
* Another item with one space

1. Ordered list item with one space
2. Another item with one space
```

## Configuration

```yaml
MD030:
  ul_single: 1  # Spaces after bullet for single-line items (default: 1)
  ol_single: 1  # Spaces after number for single-line items (default: 1)
  ul_multi: 1   # Spaces after bullet for multi-line items (default: 1)
  ol_multi: 1   # Spaces after number for multi-line items (default: 1)
```

## Automatic fixes

This rule will:

- Adjust spacing after list markers to match your configuration
- Preserve list item content and structure
- Handle single-line and multi-line items according to their specific settings

## Learn more

- [CommonMark Spec: List items](https://spec.commonmark.org/0.31.2/#list-items)
- [CommonMark Spec: Lists](https://spec.commonmark.org/0.31.2/#lists)

## Related rules

- [MD004 - Use consistent list markers](md004.md)
- [MD005 - Keep list indentation consistent](md005.md)
- [MD007 - Indent lists properly](md007.md)
- [MD029 - Use consistent numbers for ordered lists](md029.md)
