# MD041 - Start Your Document with a Clear Title

## What this rule does

Ensures every document begins with a top-level heading (like `# Title`), giving your document a clear title and purpose from the start.

## Why this matters

- **Professional appearance**: Documents without titles look incomplete and unprofessional
- **Better navigation**: Readers and tools can quickly identify what the document is about
- **Improved SEO**: Search engines and documentation systems rely on document titles
- **Consistent structure**: All documents in your project will have a uniform starting point

## Examples

### ✅ Correct

```markdown
# Getting Started Guide

Welcome to our documentation! This guide will help you...
```

```markdown
# Project README

This project provides tools for...
```

Also correct with HTML headings:

```markdown
<h1>Getting Started Guide</h1>

Welcome to our documentation! This guide will help you...
```

### ❌ Incorrect  

```markdown
Welcome to our documentation! This guide will help you...

## Installation

First, install the dependencies...
```

```markdown
This project provides tools for...

Some more content here.
```

### 🔧 Fixed

```markdown
# Documentation

Welcome to our documentation! This guide will help you...

## Installation

First, install the dependencies...
```

## Configuration

```yaml
MD041:
  level: 1                    # Heading level required (1-6, default: 1)
  front_matter_title: "title" # Front matter field to use as title
  front_matter_title_pattern: "^(title|header):" # Regex pattern to match title fields in front matter
```

## Automatic fixes

When enabled, this rule will:

- Add a generic `# Title` heading at the beginning of documents that lack one
- You should replace this with a meaningful title for your document

## Special cases

- Documents with front matter containing a title field are considered valid
- Empty documents are not checked
- HTML comments at the start are ignored when checking
- HTML heading tags (e.g., `<h1>Title</h1>`) are recognized as valid headings
- The `front_matter_title_pattern` allows custom regex patterns for matching title fields

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Writing good documentation titles](https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/#structure)

## Related rules

- [MD001](md001.md) - Keep heading levels organized
- [MD003](md003.md) - Use consistent heading styles  
- [MD025](md025.md) - Use only one main title per document
