"""

Revision ID: 037dbd721317
Revises:
Create Date: 2025-06-14 16:50:56.919222

"""

from typing import Sequence, Union

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "037dbd721317"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "analysis",
        sa.Column("quarterly_positive_free_cash_flow", sa.Float(), nullable=True),
        sa.Column("quarterly_growing_operating_cash_flow", sa.Float(), nullable=True),
        sa.Column(
            "quarterly_operating_cash_flow_is_higher_than_net_income",
            sa.Float(),
            nullable=True,
        ),
        sa.Column("quarterly_mean_capex_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_max_capex_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_min_capex_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_mean_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_max_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_min_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_net_income", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_operating_income", sa.Float(), nullable=True),
        sa.Column("quarterly_growing_net_income", sa.Float(), nullable=True),
        sa.Column("quarterly_growing_operating_income", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_diluted_eps", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_basic_eps", sa.Float(), nullable=True),
        sa.Column("quarterly_growing_basic_eps", sa.Float(), nullable=True),
        sa.Column("quarterly_growing_diluted_eps", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_debt_to_equity", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_return_on_assets", sa.Float(), nullable=True),
        sa.Column("quarterly_positive_return_on_equity", sa.Float(), nullable=True),
        sa.Column("quarterly_earning_per_share", sa.Float(), nullable=True),
        sa.Column("positive_free_cash_flow", sa.Float(), nullable=True),
        sa.Column("growing_operating_cash_flow", sa.Float(), nullable=True),
        sa.Column(
            "operating_cash_flow_is_higher_than_net_income", sa.Float(), nullable=True
        ),
        sa.Column("mean_capex_ratio", sa.Float(), nullable=True),
        sa.Column("max_capex_ratio", sa.Float(), nullable=True),
        sa.Column("min_capex_ratio", sa.Float(), nullable=True),
        sa.Column("mean_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("max_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("min_dividend_payout_ratio", sa.Float(), nullable=True),
        sa.Column("positive_net_income", sa.Float(), nullable=True),
        sa.Column("positive_operating_income", sa.Float(), nullable=True),
        sa.Column("growing_net_income", sa.Float(), nullable=True),
        sa.Column("growing_operating_income", sa.Float(), nullable=True),
        sa.Column("positive_diluted_eps", sa.Float(), nullable=True),
        sa.Column("positive_basic_eps", sa.Float(), nullable=True),
        sa.Column("growing_basic_eps", sa.Float(), nullable=True),
        sa.Column("growing_diluted_eps", sa.Float(), nullable=True),
        sa.Column("positive_debt_to_equity", sa.Float(), nullable=True),
        sa.Column("positive_return_on_assets", sa.Float(), nullable=True),
        sa.Column("positive_return_on_equity", sa.Float(), nullable=True),
        sa.Column("earning_per_share", sa.Float(), nullable=True),
        sa.Column("rsi_last_value", sa.Float(), nullable=True),
        sa.Column("macd_12_26_9_buy_date", sa.Date(), nullable=True),
        sa.Column("ma_50_200_buy_date", sa.Date(), nullable=True),
        sa.Column("slope_7", sa.Float(), nullable=True),
        sa.Column("slope_14", sa.Float(), nullable=True),
        sa.Column("slope_30", sa.Float(), nullable=True),
        sa.Column("slope_60", sa.Float(), nullable=True),
        sa.Column("last_adx", sa.Float(), nullable=True),
        sa.Column("last_dmp", sa.Float(), nullable=True),
        sa.Column("last_dmn", sa.Float(), nullable=True),
        sa.Column("last_price", sa.Float(), nullable=True),
        sa.Column("last_price_date", sa.Date(), nullable=True),
        sa.Column("year_to_date_growth", sa.Float(), nullable=True),
        sa.Column("last_52_weeks_growth", sa.Float(), nullable=True),
        sa.Column("last_week_growth", sa.Float(), nullable=True),
        sa.Column("last_month_growth", sa.Float(), nullable=True),
        sa.Column("last_year_growth", sa.Float(), nullable=True),
        sa.Column("year_to_date_max_growth", sa.Float(), nullable=True),
        sa.Column("last_week_max_growth", sa.Float(), nullable=True),
        sa.Column("last_month_max_growth", sa.Float(), nullable=True),
        sa.Column("last_year_max_growth", sa.Float(), nullable=True),
        sa.Column("macd_12_26_9_buy", sa.Float(), nullable=True),
        sa.Column("star_yoy", sa.Float(), nullable=True),
        sa.Column("star_wow", sa.Float(), nullable=True),
        sa.Column("star_mom", sa.Float(), nullable=True),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("base_symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("modifier", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("summary", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("currency", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("sector", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("industry", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("website", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("market_capitalization", sa.Float(), nullable=True),
        sa.Column("book_value", sa.Float(), nullable=True),
        sa.Column("price_to_book", sa.Float(), nullable=True),
        sa.Column("trailing_price_to_earnings", sa.Float(), nullable=True),
        sa.Column("dividend_yield", sa.Float(), nullable=True),
        sa.Column("dividend_rate", sa.Float(), nullable=True),
        sa.Column("trailing_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("forward_earnings_per_share", sa.Float(), nullable=True),
        sa.Column("return_on_equity", sa.Float(), nullable=True),
        sa.Column("operating_margins", sa.Float(), nullable=True),
        sa.Column("gross_margins", sa.Float(), nullable=True),
        sa.Column("revenue_growth", sa.Float(), nullable=True),
        sa.Column("price_per_earning_ratio", sa.Float(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source"),
    )
    op.create_table(
        "view",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("source", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("created_at", sa.Date(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("isin", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("view_name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "source"),
    )


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("view")
    op.drop_table("analysis")
    # ### end Alembic commands ###
